/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.OverlapI;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;

public class ORF_Overlap
implements OverlapI {
    public boolean areOverlapping(SeqFeatureI sa, SeqFeatureI sb) {
        boolean overlap = false;
        if (sb.canHaveChildren()) {
            FeatureSetI fb = (FeatureSetI)sb;
            for (int i = 0; i < fb.size() && !overlap; ++i) {
                overlap = this.areOverlapping(sa, fb.getFeatureAt(i));
            }
        } else if (sa.canHaveChildren()) {
            FeatureSetI fa = (FeatureSetI)sa;
            for (int i = 0; i < fa.size() && !overlap; ++i) {
                overlap = this.areOverlapping(fa.getFeatureAt(i), sb);
            }
        } else if (sa.overlaps(sb)) {
            SeqFeatureI sf1 = this.getCodingPortion(sa);
            SeqFeatureI sf2 = this.getCodingPortion(sb);
            if (sf1 != null && sf2 != null) {
                overlap = sf1.overlaps(sf2);
            }
        }
        return overlap;
    }

    private SeqFeatureI getCodingPortion(SeqFeatureI sf) {
        AnnotatedFeatureI fs;
        SeqFeatureI orf = null;
        boolean is_orf = false;
        AnnotatedFeatureI annotatedFeatureI = fs = sf instanceof AnnotatedFeatureI ? (AnnotatedFeatureI)sf.getRefFeature() : null;
        if (fs != null && fs.isProteinCodingGene()) {
            int tss = fs.getTranslationStart();
            int tes = fs.getPositionFrom(fs.getTranslationEnd(), -1);
            is_orf |= sf.getStrand() == 1 && tss > 0 && tss <= sf.getEnd() && tes >= sf.getStart();
            if (is_orf |= sf.getStrand() == -1 && tss > 0 && tss >= sf.getEnd() && tes <= sf.getStart()) {
                orf = new SeqFeature(sf);
                if (tss != orf.getStart() && orf.contains(tss)) {
                    orf.setStart(tss);
                }
                if (tes != orf.getEnd() && orf.contains(tes)) {
                    orf.setEnd(tes);
                }
            }
        } else {
            orf = sf;
        }
        return orf;
    }
}

