/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.GmodNameAdapter;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Transcript;
import apollo.editor.CompoundTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import apollo.util.FeatureComparator;
import apollo.util.SeqFeatureUtil;
import java.util.Vector;
import org.bdgp.util.Comparator;
import org.bdgp.util.VectorUtil;

public class FlyNameAdapter
extends GmodNameAdapter {
    private static final String transcriptSuffixRoot = "-R";
    private static final String peptideSuffixRoot = "-P";
    static /* synthetic */ Class class$apollo$datamodel$AnnotatedFeature;

    public String generateName(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (feature instanceof ExonI) {
            Transcript transcript = ((ExonI)feature).getTranscript();
            AnnotatedFeatureI annot = (AnnotatedFeatureI)transcript.getRefFeature();
            int exonNum = this.getExonNumber((ExonI)feature, annot);
            return annot.getName() + ":" + exonNum;
        }
        return super.generateName(annots, curation_name, feature);
    }

    private int getExonNumber(ExonI thisExon, AnnotatedFeatureI annot) {
        Vector allExons = new Vector();
        Vector transcripts = annot.getFeatures();
        for (int t = 0; t < transcripts.size(); ++t) {
            Transcript transcript = (Transcript)transcripts.elementAt(t);
            Vector exons = transcript.getFeatures();
            for (int e = 0; e < exons.size(); ++e) {
                ExonI exon = (ExonI)exons.elementAt(e);
                if (this.vectorContains(allExons, exon)) continue;
                allExons.add(exon);
            }
        }
        allExons = VectorUtil.sort(allExons, (Comparator)new FeatureComparator());
        for (int e = 0; e < allExons.size(); ++e) {
            RangeI r = (RangeI)allExons.elementAt(e);
            if (!r.sameRange(thisExon)) continue;
            return e + 1;
        }
        System.err.println("Programmer error: couldn't find exon " + thisExon + " in vector");
        return 9999;
    }

    private boolean vectorContains(Vector features, RangeI range) {
        for (int i = 0; i < features.size(); ++i) {
            RangeI f = (RangeI)features.elementAt(i);
            if (!f.sameRange(range)) continue;
            return true;
        }
        return false;
    }

    public String generateId(StrandedFeatureSetI annots, String curation_name, SeqFeatureI feature) {
        if (feature.isTranscript()) {
            return this.generateTranscriptId(feature);
        }
        if (feature instanceof ExonI) {
            Transcript transcript = ((ExonI)feature).getTranscript();
            AnnotatedFeatureI annot = (AnnotatedFeatureI)transcript.getRefFeature();
            int exonNum = this.getExonNumber((ExonI)feature, annot);
            return annot.getId() + ":" + exonNum;
        }
        if (feature.hasAnnotatedFeature()) {
            return this.generateAnnotTempId(annots, curation_name, this.getIDPrefix(feature), ":" + curation_name);
        }
        return "???";
    }

    public String generateAnnotSplitName(SeqFeatureI annot, StrandedFeatureSetI annotParent, String curationName) {
        if (this.isTemp(annot) || this.isAnnotId(annot)) {
            String suffix = ":" + curationName;
            return this.generateAnnotTempId(annotParent, curationName, this.getIDPrefix(annot), suffix);
        }
        return super.generateAnnotSplitName(annot, annotParent, curationName);
    }

    private String generateAnnotTempId(StrandedFeatureSetI annots, String curation_name, String prefix, String suffix) {
        prefix = prefix + ":temp";
        if (annots == null) {
            System.err.println("GmodNameAdapter.genAnnTempId: annots is null!?");
            return "";
        }
        int num = this.nextAnnotNumber(annots, curation_name);
        return prefix + num + suffix;
    }

    private int nextAnnotNumber(StrandedFeatureSetI annots, String curation_name) {
        int i;
        int num = annotNumber;
        Vector features = SeqFeatureUtil.getFeaturesOfClass(annots, class$apollo$datamodel$AnnotatedFeature == null ? (class$apollo$datamodel$AnnotatedFeature = FlyNameAdapter.class$("apollo.datamodel.AnnotatedFeature")) : class$apollo$datamodel$AnnotatedFeature, false);
        for (i = 0; i < features.size(); ++i) {
            SeqFeatureI g = (SeqFeatureI)features.elementAt(i);
            String this_id = g.getId();
            num = this.skipUsedTempNum(curation_name, this_id, num);
        }
        for (i = 0; i < this.getTransactionManager().size(); ++i) {
            Transaction trans = this.getTransactionManager().getTransaction(i);
            String id = trans.getProperty("id", Transaction.OLD);
            num = this.skipUsedTempNum(curation_name, id, num);
            id = trans.getProperty("id", Transaction.NEW);
            num = this.skipUsedTempNum(curation_name, id, num);
            id = trans.getProperty("annotation_id", Transaction.OLD);
            num = this.skipUsedTempNum(curation_name, id, num);
        }
        annotNumber = num;
        return annotNumber;
    }

    protected int skipUsedTempNum(String curation_name, String id, int num) {
        int tempIdNum = -1;
        if (id != null && !id.equals("")) {
            int index;
            if (id.indexOf("temp") < 0) {
                return num;
            }
            int n = index = curation_name != null ? id.indexOf(":" + curation_name) : -1;
            if (index > 0) {
                id = id.substring(0, index);
            }
        }
        return super.skipUsedTempNum(id, num);
    }

    protected String generateTranscriptSuffix(int t_index, Vector transcripts, boolean addTemp) {
        char letter;
        String suffix = "";
        if (t_index >= 26) {
            int div26 = t_index / 26 - 1;
            letter = (char)(65 + div26);
            suffix = suffix + letter;
        }
        int remainder = t_index % 26;
        letter = (char)(65 + remainder);
        suffix = suffix + letter;
        suffix = transcriptSuffixRoot + suffix;
        if (this.suffixInUse(transcripts, suffix, t_index)) {
            return this.generateTranscriptSuffix(t_index + 1, transcripts, addTemp);
        }
        return suffix;
    }

    protected CompoundTransaction setSeqNamesFromTranscript(AnnotatedFeatureI trans) {
        CompoundTransaction ct = super.setSeqNamesFromTranscript(trans);
        if (trans.get_cDNASequence() != null) {
            TransactionSubpart ts = TransactionSubpart.CDNA_NAME;
            UpdateTransaction t = new UpdateTransaction(trans, ts);
            t.setOldSubpartValue(trans.get_cDNASequence().getName());
            t.setNewSubpartValue(trans.getName());
            t.editModel();
            ct.addTransaction(t);
        }
        return ct;
    }

    protected String getDefaultIDPrefix() {
        return "CG";
    }

    protected String getPrefix(String idFormat) {
        int i;
        for (i = 0; i < idFormat.length() && Character.isLetter(idFormat.charAt(i)); ++i) {
        }
        return idFormat.substring(0, i);
    }

    protected String getTranscriptSuffixRoot() {
        return transcriptSuffixRoot;
    }

    protected String getPeptideSuffixRoot() {
        return peptideSuffixRoot;
    }

    protected boolean transcriptOrdinalIsNumeric() {
        return false;
    }

    protected boolean transcriptCanHaveTempSuffix() {
        return false;
    }

    public CompoundTransaction setAnnotId(AnnotatedFeatureI annot, String id) {
        CompoundTransaction compoundTrans = super.setAnnotId(annot, id);
        if (annot.isAnnotTop()) {
            CompoundTransaction transcriptTrans = this.setTranscriptIdsFromAnnot(annot);
            compoundTrans.addTransaction(transcriptTrans);
        }
        return compoundTrans;
    }

    private CompoundTransaction setTranscriptIdsFromAnnot(AnnotatedFeatureI annotParent) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        for (int i = 0; i < annotParent.size(); ++i) {
            SeqFeatureI trans = annotParent.getFeatureAt(i);
            String transcriptSuffix = this.getTranscriptSuffix(trans, annotParent);
            String transId = annotParent.getId() + transcriptSuffix;
            UpdateTransaction ut = this.setId(trans, transId);
            compTrans.addTransaction(ut);
            ut = this.setPeptideIdFromTranscriptId(trans);
            compTrans.addTransaction(ut);
        }
        return compTrans;
    }

    private UpdateTransaction setPeptideIdFromTranscriptId(SeqFeatureI transcript) {
        if (!transcript.hasPeptideSequence()) {
            return null;
        }
        String pepId = this.generatePeptideIdFromTranscriptId(transcript.getId());
        TransactionSubpart ts = TransactionSubpart.PEPTIDE_ID;
        String oldId = transcript.getPeptideSequence().getAccessionNo();
        UpdateTransaction ut = new UpdateTransaction(transcript, ts, oldId, pepId);
        ut.editModel();
        return ut;
    }

    protected UpdateTransaction setPeptideIdFromTranscript(SeqFeatureI trans) {
        if (!trans.hasPeptideSequence()) {
            System.out.println("Cant set pep id, trans has no pep(see FlyNameAdapter)");
            if (Config.DEBUG) {
                new Throwable().printStackTrace();
            }
            return null;
        }
        String newPepId = this.generatePeptideIdFromTranscriptId(trans.getId());
        String oldPepId = trans.getPeptideSequence().getAccessionNo();
        TransactionSubpart ts = TransactionSubpart.PEPTIDE_ID;
        UpdateTransaction ut = new UpdateTransaction(trans, ts, oldPepId, newPepId);
        ut.editModel();
        return ut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

