/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.DefaultDisplayPrefs;
import apollo.config.FeatureProperty;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Synonym;
import apollo.gui.URLQueryGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class FlyDisplayPrefs
extends DefaultDisplayPrefs {
    public String getDisplayName(RangeI sf) {
        if (sf instanceof SeqFeatureI) {
            return this.getDisplayName((SeqFeatureI)sf);
        }
        return super.getDisplayName(sf);
    }

    private String getDisplayName(SeqFeatureI sf) {
        String display_name = "";
        if (sf instanceof AnnotatedFeatureI) {
            display_name = sf.getName();
        } else {
            SeqFeatureI hit;
            FeatureSetI fset = sf.canHaveChildren() ? (FeatureSetI)sf : (FeatureSetI)sf.getRefFeature();
            SequenceI seq = fset != null ? fset.getHitSequence() : null;
            SeqFeatureI featPair = null;
            if (fset != null && fset.size() > 0 && fset.getFeatureAt(0).hasHitFeature()) {
                featPair = fset.getFeatureAt(0);
            } else if (sf.hasHitFeature()) {
                featPair = sf;
            }
            if (seq == null && featPair != null) {
                seq = featPair.getHitFeature().getRefSequence();
            }
            if (seq == null) {
                seq = sf.getFeatureSequence();
            }
            display_name = seq != null ? (seq.getName() != null ? seq.getName() : "") : (featPair != null ? ((hit = featPair.getHitFeature()).getName() != null ? hit.getName() : "") : this.getBioTypeForDisplay(sf));
        }
        return display_name;
    }

    public String getHeader(RangeI sf) {
        if (sf instanceof FeaturePair) {
            return ((FeaturePair)sf).getDisplayId();
        }
        return this.getDisplayName(sf);
    }

    public String generateURL(SeqFeatureI f) {
        if (f instanceof AnnotatedFeatureI) {
            return this.generateAnnotURL((AnnotatedFeatureI)f, Config.getExternalRefURL());
        }
        return this.generateAnalysisURL(f);
    }

    private String generateAnalysisURL(SeqFeatureI f) {
        String id = this.getIdForURL(f);
        FeatureProperty prop = Config.getPropertyScheme().getFeatureProperty(f.getFeatureType());
        String urlPrefix = this.getURLPrefix(prop, f, id);
        if (urlPrefix == null) {
            String m = "Sorry, no URL registered for type " + f.getFeatureType() + "\nin tiers file " + Config.getStyle().getTiersFile();
            JOptionPane.showMessageDialog(null, m);
            return null;
        }
        return URLQueryGenerator.getURL(urlPrefix, id);
    }

    protected String getIdForURL(SeqFeatureI f) {
        String id;
        if (f instanceof FeatureSet) {
            f = ((FeatureSet)f).getFeatureAt(0);
        }
        if (f instanceof FeaturePair) {
            FeaturePair fp = (FeaturePair)f;
            SeqFeatureI sbjct = fp.getHitFeature();
            id = sbjct.getName();
            if (id.equals("") || id.equals("no_name")) {
                id = f.getName();
            }
        } else {
            id = this.getDisplayName(f);
        }
        if (id.endsWith(".3prime") || id.endsWith(".5prime")) {
            id = id.substring(0, id.lastIndexOf("."));
        }
        if (id.indexOf(":contig") > 0 && (id = id.substring(0, id.indexOf(":contig"))).indexOf("_") > 0) {
            id = id.substring(id.indexOf("_") + 1);
        }
        if (id.indexOf("_revcomp") > 0) {
            id = id.substring(0, id.indexOf("_revcomp"));
        }
        return id;
    }

    protected String getURLPrefix(FeatureProperty prop, SeqFeatureI f, String id) {
        String defaultURL = prop.getURLString();
        if (!(f instanceof FeaturePair)) {
            return defaultURL;
        }
        FeaturePair fp = (FeaturePair)f;
        SeqFeatureI fs = fp.getRefFeature();
        String database = fs.getDatabase();
        String url = defaultURL;
        String nucleotide = "nucleotide";
        String protein = "protein";
        String ENTREZ_N = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=" + nucleotide + "&doptcmdl=GenBank&term=";
        String ENTREZ_P = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=" + protein + "&doptcmdl=GenBank&term=";
        if (prop.getDisplayType().startsWith("BLASTX") && id.startsWith("AA")) {
            url = ENTREZ_P;
        } else if (prop.typeEquals("Rodent") && database.indexOf("unigene") >= 0) {
            url = ENTREZ_N;
        } else if (prop.typeEquals("Insect") && database.indexOf("dbEST") >= 0) {
            url = ENTREZ_N;
        } else if (prop.typeEquals("tRNA-result") && database.indexOf("na_tRNA.dros") >= 0) {
            String acc = id.substring(id.indexOf("|") + 1);
            acc = acc.substring(0, acc.indexOf("|"));
        } else if (prop.typeEquals("New Fly Sequence")) {
            String acc = id;
            if (acc.indexOf("|") >= 0) {
                acc = acc.substring(acc.lastIndexOf("|") + 1);
            }
            url = ENTREZ_N + acc + "#";
        }
        return url;
    }

    protected String generateAnnotURL(AnnotatedFeatureI g, String baseAnnotURL) {
        String id;
        int i;
        if (baseAnnotURL == null || baseAnnotURL.equals("")) {
            return null;
        }
        Hashtable<String, String> id_hash = new Hashtable<String, String>();
        for (i = 0; i < g.getDbXrefs().size(); ++i) {
            DbXref ref = (DbXref)g.getDbXrefs().elementAt(i);
            id = ref.getIdValue();
            if (id.startsWith("FBan")) {
                id = id.substring("FBan".length());
                try {
                    int cg_num = Integer.parseInt(id);
                    id = "CG" + cg_num;
                    id_hash.put(id, id);
                }
                catch (Exception e) {}
                continue;
            }
            if (id.startsWith("FB")) {
                id_hash.put(id, id);
                continue;
            }
            if (!id.startsWith("TE")) continue;
            id_hash.put(id, id);
        }
        id = this.getCG(g.getId(), "CG");
        if (id != null) {
            id_hash.put(id, id);
        } else {
            id = this.getCG(g.getId(), "CR");
            if (id != null) {
                id_hash.put(id, id);
            } else {
                id = this.getCG(g.getId(), "FB");
                if (id != null) {
                    id_hash.put(id, id);
                }
            }
        }
        id = this.getCG(g.getName(), "CG");
        if (id != null) {
            id_hash.put(id, id);
        } else {
            id = this.getCG(g.getName(), "CR");
            if (id != null) {
                id_hash.put(id, id);
            }
        }
        for (i = 0; i < g.getSynonyms().size(); ++i) {
            Synonym syn = (Synonym)g.getSynonyms().elementAt(i);
            id = this.getCG(syn.getName(), "CG");
            if (id != null) {
                id_hash.put(id, id);
                continue;
            }
            id = this.getCG(syn.getName(), "CR");
            if (id != null) {
                id_hash.put(id, id);
                continue;
            }
            id = this.getCG(g.getId(), "FB");
            if (id == null) continue;
            id_hash.put(id, id);
        }
        StringBuffer query_str = new StringBuffer();
        Enumeration e = id_hash.elements();
        while (e.hasMoreElements()) {
            String namepart = (String)e.nextElement();
            if (namepart.indexOf("FB") == 0 || namepart.indexOf("CG") == 0 || namepart.indexOf("CR") == 0) {
                if (query_str.length() > 0) {
                    query_str.replace(0, query_str.length(), namepart);
                    break;
                }
                query_str.append(namepart);
                break;
            }
            if (query_str.length() > 0) {
                query_str.append('|');
            }
            query_str.append(namepart);
        }
        String url = null;
        if (query_str.length() > 0) {
            url = baseAnnotURL + query_str.toString();
        }
        return url;
    }

    private String getCG(String name, String prefix) {
        String cg_name = null;
        String tmp_name = name;
        if (tmp_name.startsWith(prefix)) {
            int index = tmp_name.indexOf(":");
            if (index > 0) {
                tmp_name = tmp_name.substring(0, index);
            }
            if (!tmp_name.equals(prefix)) {
                cg_name = tmp_name;
            }
        }
        return cg_name;
    }

    public String getTitle(CurationSet curation) {
        if (curation.getChildCurationSets().size() <= 0) {
            return curation.toString();
        }
        return "composite";
    }

    public String getBioTypeForDisplay(SeqFeatureI sf) {
        String typeDisplay;
        if (sf instanceof AnnotatedFeatureI) {
            typeDisplay = sf.getTopLevelType();
            typeDisplay = this.capitalize(typeDisplay);
            if (!sf.getTopLevelType().equalsIgnoreCase(sf.getFeatureType())) {
                typeDisplay = typeDisplay + " " + this.capitalize(sf.getFeatureType());
            }
        } else {
            String db = sf.getDatabase();
            typeDisplay = db != null && !db.equals("") && !db.equals("dummy") ? sf.getProgramName() + ":" + sf.getDatabase() : sf.getProgramName() + ":" + sf.getStart() + "-" + sf.getEnd();
        }
        return typeDisplay;
    }

    private String capitalize(String s) {
        if (s.endsWith("RNA")) {
            return s;
        }
        String first = s.substring(0, 1);
        first = first.toUpperCase();
        return first + s.substring(1);
    }

    private void print(String m) {
        System.out.println(m);
    }
}

