/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.DefaultNameAdapter;
import apollo.config.LinkType;
import apollo.config.OverlapI;
import apollo.config.SimpleOverlap;
import apollo.config.TierProperty;
import apollo.util.DateUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FeatureProperty
implements Cloneable,
Serializable {
    private static final String package_path = "apollo.config.";
    public static Color DEFAULT_COLOR = new Color(250, 250, 210);
    private static final Color DEFAULT_UTR_COLOR = Color.black;
    public static String DEFAULT_STYLE = "DrawableResultFeatureSet";
    public static Color midBlue = new Color(150, 150, 255);
    public static Color midRed = new Color(255, 100, 100);
    public static Color blueGreen = new Color(0, 255, 150);
    public static Color brown = new Color(227, 144, 0);
    public static final Integer GRP_GENE = new Integer(1);
    public static final Integer GRP_HOMOLOGY = new Integer(2);
    public static final Integer GRP_SINGLE = new Integer(3);
    public static Hashtable groupTypes = new Hashtable();
    protected Vector column_headings;
    public static Vector default_columns;
    protected String sortProperty = null;
    protected boolean reverseSort = false;
    public static Hashtable colourHash;
    protected String type;
    protected String tiername;
    protected TierProperty tier;
    protected Vector analysis_types = new Vector();
    protected String style = DEFAULT_STYLE;
    protected Color colour = DEFAULT_COLOR;
    private Color utrColor = DEFAULT_UTR_COLOR;
    protected boolean usescore = false;
    protected float minScore = 0.0f;
    protected float maxScore = 100.0f;
    protected int minWidth = 3;
    protected float thresholdScore = -1.0f;
    protected String URLString = null;
    protected Integer groupFlag = GRP_GENE;
    protected Date recentDate = null;
    protected Vector comments = new Vector();
    private String idFormat;
    private static final String defaultAnnotType = "gene";
    private String annotType = "gene";
    private String nameAdapterString;
    private OverlapI overlapper = null;
    private boolean nameAdapterWasSet = false;
    private boolean overlapperWasSet = false;
    protected boolean groupFlagSet = false;
    private LinkType linkType = LinkType.NO_LINK;
    private String linkSpecies1;
    private String linkSpecies2;
    private boolean warnOnEdit = false;
    private boolean warnOnEditWasSet = false;
    private int numberOfLevels = 1;
    static /* synthetic */ Class class$apollo$config$DefaultNameAdapter;

    public FeatureProperty(TierProperty tier, String type, Vector anal_types, Color colour, String style, boolean usescore, float min, float max) {
        this(tier, type, anal_types);
        this.setColour(colour);
        this.setStyle(style);
        this.setSizeByScore(usescore);
        this.setMinScore(min);
        this.setMaxScore(max);
    }

    public FeatureProperty(TierProperty tier, String type, Vector anal_types) {
        this.init(tier, type, anal_types);
    }

    private void init(TierProperty tier, String type, Vector anal_types) {
        this.setDisplayType(type);
        this.setAnalysisTypes(anal_types);
        this.setTier(tier);
        this.column_headings = default_columns;
    }

    public FeatureProperty(FeatureProperty from) {
        this(from.getTier(), from.getDisplayType(), from.getAnalysisTypes(), from.getColour(), from.getStyle(), from.getSizeByScore(), from.getMinScore(), from.getMaxScore());
        this.setMinWidth(from.getMinWidth());
    }

    public FeatureProperty(TierProperty tier, String type, Vector anal_types, Color colour, String style) {
        this.init(tier, type, anal_types, colour, style);
    }

    void init(TierProperty tier, String type, Vector anal_types, Color colour, String style) {
        this.init(tier, type, anal_types);
        this.setColour(colour);
        this.setStyle(style);
    }

    public FeatureProperty(TierProperty tier, String type, Vector anal_types, Color colour) {
        this(tier, type, anal_types);
        this.setColour(colour);
    }

    public FeatureProperty() {
    }

    protected void setTierName(String tier) {
        this.tiername = tier;
    }

    protected String getTierName() {
        return this.tiername;
    }

    protected void setTier(TierProperty tier) {
        if (tier != null) {
            this.tier = tier;
            this.setTierName(tier.getLabel());
            if (this.getDisplayType() != null) {
                tier.addFeatureProperty(this);
            }
        } else {
            throw new NullPointerException("FeatureProperty.setTier: can't accept null tier!");
        }
    }

    public TierProperty getTier() {
        return this.tier;
    }

    public boolean isAnnotationType() {
        return Config.getPropertyScheme().isAnnotationTier(this.tiername);
    }

    private void firePropSchemeChangeEvent() {
        if (this.getTier() != null) {
            this.getTier().firePropSchemeChangeEvent();
        }
    }

    public boolean getSizeByScore() {
        return this.usescore;
    }

    public void setSizeByScore(boolean usescore) {
        this.usescore = usescore;
        if (!usescore) {
            this.minScore = 0.0f;
            this.maxScore = 0.0f;
        } else if (this.maxScore == 0.0f) {
            this.maxScore = 100.0f;
        }
        this.firePropSchemeChangeEvent();
    }

    public float getThreshold() {
        return this.thresholdScore;
    }

    public void setThreshold(float thresh) {
        this.thresholdScore = thresh;
        this.firePropSchemeChangeEvent();
    }

    public void setDisplayType(String type) {
        if (type == null) {
            throw new NullPointerException("FeatureProperty.setDisplayType: can't accept null type");
        }
        this.type = type;
        this.firePropSchemeChangeEvent();
    }

    public String getDisplayType() {
        return this.type;
    }

    public Date getRecentDate() {
        return this.recentDate;
    }

    public void setRecentDate(String dateString) {
        this.recentDate = DateUtil.makeADate(dateString);
    }

    public void inheritWarnOnEdit(boolean warn) {
        if (!this.warnOnEditWasSet) {
            this.setWarnOnEdit(warn);
        }
    }

    public boolean warnOnEdit() {
        return this.warnOnEdit;
    }

    public void setWarnOnEdit(boolean warn) {
        this.warnOnEdit = warn;
        this.warnOnEditWasSet = true;
    }

    public void setIdFormat(String idFormat) {
        this.idFormat = idFormat;
    }

    public String getIdFormat() {
        return this.idFormat;
    }

    public void setAnnotType(String annot_type) {
        this.annotType = annot_type;
    }

    public String getAnnotType() {
        return this.annotType;
    }

    public static String getDefaultAnnotType() {
        return defaultAnnotType;
    }

    protected void setAnalysisTypes(Vector anal_types) {
        if (anal_types == null || anal_types.size() <= 0) {
            throw new NullPointerException("Can't create feature without analyses");
        }
        this.analysis_types = (Vector)anal_types.clone();
    }

    public void addAnalysisType(String analysis) {
        if (!this.analysis_types.contains(analysis)) {
            this.analysis_types.addElement(analysis);
            if (this.tier != null) {
                this.tier.addAnalysisType(this, analysis);
            }
        }
    }

    public Vector getAnalysisTypes() {
        return this.analysis_types;
    }

    public int getAnalysisTypesSize() {
        return this.analysis_types.size();
    }

    public String getAnalysisType(int i) {
        return (String)this.analysis_types.get(i);
    }

    public void setStyle(String style) {
        this.style = style;
        this.firePropSchemeChangeEvent();
    }

    public String getStyle() {
        return this.style;
    }

    public void setColour(Color colour, boolean temporary) {
        if (temporary) {
            this.colour = colour;
        } else {
            this.setColour(colour);
        }
    }

    public void setColour(Color colour) {
        this.colour = colour;
        this.firePropSchemeChangeEvent();
    }

    void setUtrColor(Color color) {
        this.utrColor = color;
    }

    public static Color toColour(String colourStr) {
        return FeatureProperty.toColour(colourStr, Color.darkGray);
    }

    public static Color toColour(String colourStr, Color defaultColour) {
        Color colour;
        try {
            colour = FeatureProperty.parseColour(colourStr);
        }
        catch (NumberFormatException e) {
            System.err.println("Warning: Failed parsing RGB colour \"" + colourStr + "\"");
            colour = defaultColour;
        }
        return colour;
    }

    public static Color parseColour(String colourStr) throws NumberFormatException {
        if (colourHash.containsKey(colourStr)) {
            return (Color)colourHash.get(colourStr);
        }
        int count = 0;
        int[] components = new int[3];
        StringTokenizer tokenizer = new StringTokenizer(colourStr, ",");
        while (tokenizer.hasMoreTokens() && count < 3) {
            String token = tokenizer.nextToken();
            components[count++] = Integer.parseInt(token);
        }
        if (count != 3 || tokenizer.hasMoreTokens()) {
            throw new NumberFormatException("Warning: Unknown colour " + colourStr);
        }
        Color colour = new Color(components[0], components[1], components[2]);
        return colour;
    }

    public String getGroupFlagAsString() {
        String groupStr = this.getKeyFromValue(groupTypes, this.groupFlag);
        if (groupStr.equals("UNKNOWN")) {
            System.err.println("ERROR: Unknown grouping flag " + this.groupFlag);
            groupStr = "GENE";
        }
        return groupStr;
    }

    public String getColourAsString() {
        return this.getColourAsString(this.colour);
    }

    public String getColourAsString(Color colour) {
        String colourStr = this.getKeyFromValue(colourHash, colour);
        if (colourStr.equals("UNKNOWN")) {
            colourStr = new String(colour.getRed() + "," + colour.getGreen() + "," + colour.getBlue());
        }
        return colourStr;
    }

    public String getKeyFromValue(Hashtable table, Object value) {
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!table.get(key).equals(value)) continue;
            return (String)key;
        }
        return "UNKNOWN";
    }

    public Color getColour() {
        return this.colour;
    }

    public Color getUtrColor() {
        return this.utrColor;
    }

    public Vector getColumnHeadings() {
        return this.getColumnHeadings(true);
    }

    public Vector getColumnHeadings(boolean use_default) {
        if (this.column_headings == null) {
            return default_columns;
        }
        return this.column_headings;
    }

    public void setColumnHeadings(Vector headings) {
        this.column_headings = headings;
    }

    public void addColumnHeading(String heading) {
        if (this.column_headings == null) {
            this.column_headings = new Vector(6);
        }
        if (!this.column_headings.contains(heading)) {
            this.column_headings.addElement(heading);
        }
    }

    private String getColHeadingsString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i < this.getColumnHeadings().size(); ++i) {
            buf.append(this.getColumnHeadings().elementAt(i));
            if (i >= this.getColumnHeadings().size() - 1) continue;
            buf.append(" ");
        }
        buf.append("}");
        return buf.toString();
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String sort_by) {
        this.sortProperty = sort_by;
    }

    public boolean getReverseSort() {
        return this.reverseSort;
    }

    public void setReverseSort(boolean reverse) {
        this.reverseSort = reverse;
    }

    public void setMaxScore(float max) {
        this.maxScore = max;
        this.firePropSchemeChangeEvent();
    }

    public void setMinScore(float min) {
        this.minScore = min;
        this.firePropSchemeChangeEvent();
    }

    public void setMinWidth(int min) {
        this.minWidth = min;
        this.firePropSchemeChangeEvent();
    }

    public void setURLString(String str) {
        this.URLString = str;
    }

    public void setGroupFlag(String grpStr) {
        if (groupTypes.get(grpStr) != null) {
            this.groupFlag = (Integer)groupTypes.get(grpStr);
            this.groupFlagSet = true;
        } else {
            System.err.println("ERROR: Unknown grouping flag " + grpStr);
        }
    }

    public Integer getGroupFlag() {
        return this.groupFlag;
    }

    public String getURLString() {
        return this.URLString;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public float getMinScore() {
        return this.minScore;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void write(PrintWriter out) throws IOException {
        StringBuffer buf = new StringBuffer("type ");
        buf.append(this.quoteIfSpace(this.getTier().getLabel()) + ", " + this.quoteIfSpace(this.getDisplayType()) + ", {");
        for (int i = 0; i < this.analysis_types.size(); ++i) {
            buf.append("\"" + (String)this.analysis_types.elementAt(i) + "\"");
            if (i >= this.analysis_types.size() - 1) continue;
            buf.append(" ");
        }
        buf.append("}, ");
        buf.append(this.getColourAsString() + ", " + this.getSizeByScore() + ", " + this.getMinScore() + ", " + this.getMaxScore() + ", " + this.getStyle() + ", " + this.getColHeadingsString() + ", " + this.getSortProperty() + ", " + this.getReverseSort());
        if (this.minWidth != 3) {
            buf.append(", " + this.getMinWidth());
        }
        if (this.groupFlagSet) {
            buf.append(", " + this.getGroupFlagAsString());
        }
        if (this.URLString != null) {
            if (!this.groupFlagSet) {
                System.err.println("Trying to write URL string without group flag");
            }
            buf.append(", \"" + this.URLString + "\"");
            if ((double)this.thresholdScore != -1.0 || this.getRecentDate() != null) {
                buf.append(", " + this.getThreshold());
            }
            if (this.getRecentDate() != null) {
                buf.append(", " + DateUtil.formatDate(this.getRecentDate()));
            }
        }
        out.println(buf.toString());
    }

    protected String quoteIfSpace(String str) {
        if (str.indexOf(" ") > -1 || str.indexOf("/") > -1) {
            return new String("\"" + str + "\"");
        }
        return str;
    }

    public Object clone() throws CloneNotSupportedException {
        FeatureProperty clone = (FeatureProperty)super.clone();
        if (this.column_headings != null) {
            clone.column_headings = (Vector)this.column_headings.clone();
        }
        if (this.linkType != null) {
            clone.linkType = this.linkType;
        }
        clone.analysis_types = (Vector)this.analysis_types.clone();
        clone.colour = new Color(this.colour.getRGB());
        clone.utrColor = new Color(this.utrColor.getRGB());
        clone.comments = (Vector)this.comments.clone();
        return clone;
    }

    FeatureProperty cloneFeatureProperty() {
        try {
            return (FeatureProperty)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean typeEquals(String typeName) {
        return this.type.equalsIgnoreCase(typeName);
    }

    protected void addComment(String comment) {
        this.comments.addElement(comment);
    }

    protected Vector getComments() {
        return this.comments;
    }

    void setNameAdapterString(String str) {
        if (str == null) {
            return;
        }
        this.nameAdapterString = str;
        this.nameAdapterWasSet = true;
    }

    public String getNameAdapterString() {
        return this.nameAdapterString;
    }

    public ApolloNameAdapterI createNameAdapter() {
        if (this.nameAdapterString == null) {
            System.err.println("No name adapter for " + this + ".\nPlease check tiers file.");
            return new DefaultNameAdapter();
        }
        try {
            return (ApolloNameAdapterI)this.createClassFromName(this.nameAdapterString);
        }
        catch (ClassCastException e) {
            System.err.println("FeatureProperty.createNameAdapter: " + this.nameAdapterString + " does not implement ApolloNameAdapterI");
            if (Config.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    void setNameAdapterStringIfNotSet(String str) {
        if (!this.nameAdapterWasSet) {
            this.setNameAdapterString(str);
        }
    }

    public boolean hasNonDefaultNameAdapter() {
        return this.tiername != null && Config.getPropertyScheme().isAnnotationTier(this.tiername) && this.nameAdapterString != null && !this.nameAdapterString.equals((class$apollo$config$DefaultNameAdapter == null ? (class$apollo$config$DefaultNameAdapter = FeatureProperty.class$("apollo.config.DefaultNameAdapter")) : class$apollo$config$DefaultNameAdapter).getName());
    }

    public void setOverlapper(String str) {
        try {
            this.overlapper = (OverlapI)this.createClassFromName(str);
        }
        catch (ClassCastException e) {
            this.overlapper = null;
            System.err.println("FeatureProperty.setOverlapper: " + str + " does not implement OverlapI");
        }
        this.overlapperWasSet = true;
    }

    public void setOverlapperIfNotSet(String str) {
        if (!this.overlapperWasSet) {
            this.setOverlapper(str);
        }
    }

    public boolean hasOverlapper() {
        return this.tiername != null && Config.getPropertyScheme().isAnnotationTier(this.tiername);
    }

    public OverlapI getOverlapper() {
        if (this.tiername == null) {
            return null;
        }
        if (Config.getPropertyScheme().isAnnotationTier(this.tiername)) {
            if (this.overlapper == null) {
                this.overlapper = SimpleOverlap.getSimpleOverlap();
            }
            return this.overlapper;
        }
        System.out.println("Why is an overlapper adapter requested in non-annotation tier " + this.tiername + "?");
        return null;
    }

    protected Object createClassFromName(String str) {
        boolean no_class = true;
        String prefix = package_path;
        String class_name = str;
        int tries = 0;
        Object new_instance = null;
        while (new_instance == null && tries < 2) {
            try {
                Class<?> new_class;
                if (prefix != "" && !class_name.startsWith(prefix)) {
                    class_name = prefix + class_name;
                }
                no_class = (new_class = Class.forName(class_name)) == null;
                new_instance = new_class.newInstance();
            }
            catch (Exception e) {
                System.out.println("createClassFromName: couldn't create " + class_name + "; no class = " + no_class);
                if (++tries >= 2) continue;
                prefix = "";
            }
        }
        return new_instance;
    }

    public String createNameFromClass(Object cl) {
        String name = cl.getClass().getName();
        if (name.indexOf(".") > 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    void setLinkType(String linkTypeString) {
        this.linkType = LinkType.getLinkTypeForString(linkTypeString);
    }

    void setSyntenyLinkLevel(String syntenyLinkLevel) {
        if (this.linkType == null) {
            System.out.println("synteny_link_type must be specified before synteny_link_level");
            return;
        }
        this.linkType.setSyntenyLinkLevel(syntenyLinkLevel);
    }

    void setSyntenyLinkMatchOn(String matchOn) {
        if (this.linkType == null) {
            System.out.println("synteny_link_type must be specified before synteny_link_match_on");
            return;
        }
        this.linkType.setSyntenyLinkMatchOn(matchOn);
    }

    public boolean isSyntenyLinked() {
        return this.linkType != LinkType.NO_LINK;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    void setLinkSpecies1(String species1) {
        this.linkSpecies1 = species1;
    }

    public String getLinkSpecies1() {
        return this.linkSpecies1;
    }

    void setLinkSpecies2(String species2) {
        this.linkSpecies2 = species2;
    }

    public String getLinkSpecies2() {
        return this.linkSpecies2;
    }

    void setNumberOfLevels(int levels) {
        this.numberOfLevels = levels;
    }

    public int getNumberOfLevels() {
        return this.numberOfLevels;
    }

    public boolean isOneLevel() {
        return this.getNumberOfLevels() == 1;
    }

    public String toString() {
        return "FeatureProperty " + this.type + " (in tier " + this.tiername + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        groupTypes.put("GENE", GRP_GENE);
        groupTypes.put("HOMOLOGY", GRP_HOMOLOGY);
        groupTypes.put("SINGLE", GRP_SINGLE);
        default_columns = new Vector();
        default_columns.addElement("GENOMIC_LENGTH");
        default_columns.addElement("MATCH_LENGTH");
        default_columns.addElement("GENOMIC_RANGE");
        default_columns.addElement("MATCH_RANGE");
        default_columns.addElement("SCORE");
        colourHash = new Hashtable();
        colourHash.put("red", Color.red);
        colourHash.put("green", Color.green);
        colourHash.put("blue", Color.blue);
        colourHash.put("pink", Color.pink);
        colourHash.put("orange", Color.orange);
        colourHash.put("darkGray", Color.darkGray);
        colourHash.put("gray", Color.gray);
        colourHash.put("magenta", Color.magenta);
        colourHash.put("cyan", Color.cyan);
        colourHash.put("yellow", Color.yellow);
        colourHash.put("black", Color.black);
        colourHash.put("white", Color.white);
        colourHash.put("midBlue", midBlue);
        colourHash.put("midRed", midRed);
        colourHash.put("blueGreen", blueGreen);
        colourHash.put("brown", brown);
    }
}

