/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.DefaultDisplayPrefs;
import apollo.config.DisplayPrefsI;
import apollo.config.FeatureProperty;
import apollo.config.OverlapI;
import apollo.config.PeptideStatus;
import apollo.config.PropertyScheme;
import apollo.config.SimpleOverlap;
import apollo.config.Style;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.editor.AnnotationEditor;
import apollo.editor.UserName;
import apollo.gui.Controller;
import apollo.main.CommandLine;
import apollo.util.IOUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterRegistry;
import org.bdgp.io.IOOperation;
import org.bdgp.util.DNAUtils;

public class Config {
    private static Style style;
    private static boolean outputChadoTransaction;
    private static boolean outputTransactionXML;
    private static String chadoTemplFileName;
    private static String chadoJdbcAdapterConfigFile;
    private static String chadoJdbcAdapterConfigFileFullName;
    private static String dataDir;
    private static String rootDir;
    private static String adapterHistoryFile;
    private static String karyotypeFile;
    private static String syntenyDir;
    private static String exonSyntenyDir;
    private static boolean showSyntenyEvidencePanels;
    private static int syntenyPanelRelativeSize;
    private static int translationShowLimit;
    private static long memoryAllocation;
    private static Controller controller;
    private static DataAdapterRegistry adapterRegistry;
    private static OverlapI defaultOverlapper;
    private static HashMap filenameToStyle;
    private static HashMap adapterToStyle;
    private static int autosaveInterval;
    private static String autosaveFile;
    private static int cgiPort;
    private static String cgiHost;
    private static String cgiScript;
    private static String dbHost;
    private static String dbName;
    private static String gpName;
    private static String srsServer;
    private static String pfetchServer;
    private static Hashtable pubDbToURL;
    private static String dasServer;
    private static String frameOrientation;
    private static int mainWindowWidth;
    private static int geneWindowSize;
    private static boolean confirmOverwrite;
    private static Color dataLoaderBackgroundColor;
    private static Color dataLoaderLabelColor;
    private static Color dataLoaderTitleColor;
    static Color defaultAnnotationColor;
    private static int siteShowLimit;
    private static int textAvoidLimit;
    private static float fastDrawLimit;
    private static boolean fastClipGraphics;
    private static boolean refreshPeptides;
    private static String commandLineXmlFileFormat;
    public static String osarch;
    public static String osname;
    public static String jvm;
    private static String fileName;
    private static String browserProgram;
    private static boolean httpServerIsEnabled;
    private static boolean initialized;
    public static boolean DO_ONE_LEVEL_ANNOTS;
    public static boolean inBatchMode;
    private static boolean supressMacJvmPopup;
    public static boolean DEBUG;
    private static HashMap speciesToStyle;
    private static final String gbURL = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nucleotide&val=*";
    private static String defaultSpecies;
    static /* synthetic */ Class class$apollo$config$Config;

    public static boolean getDebug() {
        Config.init();
        return DEBUG;
    }

    private static void setDataAdapterType(String adapterType) {
        if (!adapterToStyle.containsKey(adapterType)) {
            String message = "Failed to set style " + adapterType + "--couldn't find style file.  This could be a problem!";
            IOUtil.errorDialog(message);
            return;
        }
        Style oldStyle = style;
        Style newStyle = (Style)adapterToStyle.get(adapterType);
        if (oldStyle == newStyle) {
            return;
        }
        Config.setStyle(newStyle);
    }

    public static void setStyle(Style s) {
        Config.setStyle(s, false);
    }

    public static void setStyle(Style s, boolean updateStyleHash) {
        if (s == style) {
            return;
        }
        style = s;
        DNAUtils.setGeneticCode((int)s.getGeneticCodeNumber());
        if (updateStyleHash) {
            String styleFile = s.getFileName();
            filenameToStyle.put(styleFile, s);
            Iterator keys = adapterToStyle.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                if (!((Style)adapterToStyle.get(key)).getFileName().equals(styleFile)) continue;
                adapterToStyle.put(key, s);
            }
        }
    }

    public static void newDataAdapter(DataAdapter da) {
        Config.setDataAdapterType(da.getClass().getName());
        System.out.println("Set style to " + da.getClass().getName() + "; style file source(s): " + style.getAllStyleFilesString());
    }

    public static Style getStyle(String adapterType) {
        return (Style)adapterToStyle.get(adapterType);
    }

    public static Style getStyle() {
        return style;
    }

    public static boolean hasStyleForSpecies(String species) {
        if (species == null) {
            return false;
        }
        if (speciesToStyle == null) {
            return false;
        }
        return speciesToStyle.get(species) != null;
    }

    public static void setStyleForSpecies(String species) {
        if (!Config.hasStyleForSpecies(species)) {
            return;
        }
        Style speciesStyle = (Style)speciesToStyle.get(species);
        System.out.println("Species style override. Setting style to " + speciesStyle + " for species " + species);
        Config.setStyle(speciesStyle);
    }

    private static void addSpeciesToStyle(String keyValueArrowString) {
        KeyValue keyValue = new KeyValue(keyValueArrowString);
        Style speciesStyle = Config.createStyle(keyValue.value);
        if (speciesToStyle == null) {
            speciesToStyle = new HashMap(3);
        }
        speciesToStyle.put(keyValue.key, speciesStyle);
    }

    public static Color getAnnotationBackground() {
        return style.getAnnotationBackground();
    }

    public static Color getFeatureBackground() {
        return style.getFeatureBackground();
    }

    public static int getEdgematchWidth() {
        return style.getEdgematchWidth();
    }

    public static boolean verticallyMovePopups() {
        return style.verticallyMovePopups();
    }

    public static Color getCoordBackground() {
        return style.getCoordBackground();
    }

    public static Color getCoordForeground() {
        return style.getCoordForeground();
    }

    public static Color getCoordRevcompColor() {
        return style.getCoordRevcompColor();
    }

    public static Color getSequenceColor() {
        return style.getSequenceColor();
    }

    public static Color getEdgematchColor() {
        return style.getEdgematchColor();
    }

    public static Color getHighlightColor() {
        return style.getHighlightColor();
    }

    public static Color getSelectionColor() {
        return style.getSelectionColor();
    }

    public static Color getSeqGapColor() {
        return style.getSeqGapColor();
    }

    public static Color getFeatureLabelColor() {
        return style.getFeatureLabelColor();
    }

    public static Color getAnnotationLabelColor() {
        return style.getAnnotationLabelColor();
    }

    public static Color getDataLoaderBackgroundColor() {
        return dataLoaderBackgroundColor;
    }

    public static Color getDataLoaderLabelColor() {
        return dataLoaderLabelColor;
    }

    public static Color getDataLoaderTitleColor() {
        return dataLoaderTitleColor;
    }

    public static Color getExonDetailEditorBackgroundColor1() {
        return style.getExonDetailEditorBackgroundColor1();
    }

    public static Color getExonDetailEditorBackgroundColor2() {
        return style.getExonDetailEditorBackgroundColor2();
    }

    public static Color getExonDetailEditorFeatureColor1() {
        return style.getExonDetailEditorFeatureColor1();
    }

    public static Color getExonDetailEditorFeatureColor2() {
        return style.getExonDetailEditorFeatureColor2();
    }

    public static Vector getAnnotationComments() {
        return style == null ? null : style.getAnnotationComments();
    }

    public static Vector getTranscriptComments() {
        return style == null ? null : style.getTranscriptComments();
    }

    public static Hashtable getPeptideStates() {
        return style == null ? null : style.getPeptideStates();
    }

    public static PeptideStatus getPeptideStatus(String pep_status) {
        return style == null ? null : style.getPeptideStatus(pep_status);
    }

    public static DataAdapterRegistry getAdapterRegistry() {
        Config.init();
        return adapterRegistry;
    }

    public static boolean dataAdapterIsAvailable(IOOperation io) {
        DataAdapter[] allAdapters = adapterRegistry.getAdapters(io, false);
        return allAdapters.length > 0;
    }

    public static DisplayPrefsI getDisplayPrefs() {
        return style == null ? new DefaultDisplayPrefs() : style.getDisplayPrefs();
    }

    public static OverlapI getOverlapper(SeqFeatureI sf) {
        PropertyScheme scheme = Config.getPropertyScheme();
        FeatureProperty fp = scheme.getFeatureProperty(sf.getTopLevelType());
        if (fp != null) {
            return fp.getOverlapper();
        }
        if (defaultOverlapper == null) {
            defaultOverlapper = SimpleOverlap.getSimpleOverlap();
        }
        return defaultOverlapper;
    }

    public static String getTiersFile() {
        Config.init();
        String tiersfile = style.getTiersFile();
        if (tiersfile == null) {
            IOUtil.errorDialog("can't find Types (tiers) file for style file " + style.getFileName() + ".\nPlease fix the Types parameter in " + style.getFileName() + ".\nYou may then need to restart Apollo.");
        }
        return tiersfile;
    }

    public static String getKaryotypeFile() {
        Config.init();
        return karyotypeFile;
    }

    public static String getSyntenyDir() {
        Config.init();
        return syntenyDir;
    }

    public static String getExonSyntenyDir() {
        Config.init();
        return exonSyntenyDir;
    }

    public static boolean getShowAnnotations() {
        Config.init();
        return style == null ? false : style.getShowAnnotations();
    }

    public static boolean getShowResults() {
        Config.init();
        if (style == null) {
            return true;
        }
        return style.getShowResults();
    }

    public static boolean getShowSyntenyEvidencePanels() {
        return showSyntenyEvidencePanels;
    }

    public static boolean isEditingEnabled() {
        Config.init();
        if (style == null) {
            return false;
        }
        return style.isEditingEnabled();
    }

    public static boolean isEditingEnabled(String adapterClassName) {
        Config.init();
        if (Config.getStyle(adapterClassName) == null) {
            return false;
        }
        return Config.getStyle(adapterClassName).isEditingEnabled();
    }

    public static boolean isNavigationManagerEnabled() {
        Config.init();
        if (style == null) {
            return false;
        }
        return style.isNavigationManagerEnabled();
    }

    public static int getAutosaveInterval() {
        Config.init();
        return autosaveInterval;
    }

    public static int getCGIPort() {
        Config.init();
        return cgiPort;
    }

    public static String getCGIScript() {
        Config.init();
        return cgiScript;
    }

    public static String getCGIHost() {
        Config.init();
        return cgiHost;
    }

    public static String getDBHost() {
        Config.init();
        return dbHost;
    }

    public static String getDBName() {
        Config.init();
        return dbName;
    }

    public static String getGPName() {
        Config.init();
        return gpName;
    }

    public static String getSRSServer() {
        Config.init();
        return srsServer;
    }

    public static String getPFetchServer() {
        Config.init();
        return pfetchServer;
    }

    public static String getDASServer() {
        Config.init();
        return dasServer;
    }

    public static String getAutosaveFile() {
        Config.init();
        return autosaveFile;
    }

    public static Controller getController() {
        Config.init();
        return controller;
    }

    public static void setController(Controller newValue) {
        controller = newValue;
    }

    public static int getSiteShowLimit() {
        Config.init();
        return siteShowLimit;
    }

    public static int getSyntenyPanelRelativeSize() {
        Config.init();
        return syntenyPanelRelativeSize;
    }

    public static int getTranslationShowLimit() {
        Config.init();
        return translationShowLimit;
    }

    public static int getTextAvoidLimit() {
        Config.init();
        return textAvoidLimit;
    }

    public static Font getDefaultFont() {
        return style == null ? null : style.getDefaultFont();
    }

    public static Font getDefaultFeatureLabelFont() {
        return style == null ? null : style.getDefaultFeatureLabelFont();
    }

    public static float getFastDrawLimit() {
        Config.init();
        return fastDrawLimit;
    }

    public static boolean getDrawOutline() {
        return style.getDrawOutline();
    }

    public static Color getOutlineColor() {
        return style.getOutlineColor();
    }

    public static String getFrameOrientation() {
        Config.init();
        return frameOrientation;
    }

    public static int getMainWindowWidth() {
        return mainWindowWidth;
    }

    public static String getGeneUrl() {
        return style == null ? null : style.getGeneUrl();
    }

    public static String getBandUrl() {
        return style == null ? null : style.getBandUrl();
    }

    public static String getScaffoldUrl() {
        return style == null ? null : style.getScaffoldUrl();
    }

    public static String getSeqUrl() {
        return style == null ? null : style.getSeqUrl();
    }

    public static String getRangeUrl() {
        return style == null ? null : style.getRangeUrl();
    }

    public static boolean hasChromosomes() {
        return style == null ? false : style.hasChromosomes();
    }

    public static Vector getChromosomes() {
        return style == null ? null : style.getChromosomes();
    }

    public static String getExternalRefURL() {
        return style == null ? null : style.getExternalRefUrl();
    }

    public static boolean internalMode() {
        return style == null ? false : style.internalMode();
    }

    public static String getProjectName(String username) {
        return style == null ? username : style.getProjectName(username);
    }

    public static String getFileName() {
        return fileName;
    }

    private static boolean readConfig(File confFile) {
        fileName = confFile.getPath();
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(confFile)));
            tokenizer.eolIsSignificant(true);
            tokenizer.slashStarComments(true);
            boolean EOF = false;
            int tokType = 0;
            Vector<String> words = new Vector<String>();
            while (!EOF) {
                tokType = tokenizer.nextToken();
                if (tokType == -1) {
                    EOF = true;
                    continue;
                }
                if (tokType != 10) {
                    if (tokenizer.sval == null) continue;
                    words.addElement(tokenizer.sval);
                    continue;
                }
                if (words.size() == 2 || words.size() == 3 || words.size() == 4) {
                    String key = (String)words.elementAt(0);
                    String value = (String)words.elementAt(1);
                    String styleName = null;
                    String dataAdapterLabel = null;
                    if (words.size() >= 3) {
                        styleName = (String)words.elementAt(2);
                    }
                    if (words.size() == 4) {
                        dataAdapterLabel = (String)words.elementAt(3);
                    }
                    if (key.equalsIgnoreCase("AutosaveInterval")) {
                        if (value.equalsIgnoreCase("none")) {
                            Config.setAutosaveInterval(-1);
                        } else {
                            try {
                                Config.setAutosaveInterval(Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                System.err.println("Can't parse number: " + value + " for AutosaveInterval");
                            }
                        }
                    } else if (key.equalsIgnoreCase("CGIPort")) {
                        if (value.equalsIgnoreCase("none")) {
                            Config.setCGIPort(-1);
                        } else {
                            try {
                                Config.setCGIPort(Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                System.err.println("Can't parse number: " + value + " for CGIPort");
                            }
                        }
                    } else if (key.equalsIgnoreCase("SiteShowLimit")) {
                        try {
                            Config.setSiteShowLimit(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can't parse number: " + value + " for SiteShowLimit");
                        }
                    } else if (key.equalsIgnoreCase("TextAvoidLimit")) {
                        try {
                            Config.setTextAvoidLimit(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can't parse number: " + value + " for TextAvoidLimit");
                        }
                    } else if (key.equalsIgnoreCase("TranslationShowLimit")) {
                        try {
                            Config.setTranslationShowLimit(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can't parse number: " + value);
                        }
                    } else if (key.equalsIgnoreCase("SyntenyPanelRelativeSize")) {
                        try {
                            Config.setSyntenyPanelRelativeSize(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can't parse number: " + value);
                        }
                    } else if (key.equalsIgnoreCase("ShowSyntenyEvidencePanels")) {
                        showSyntenyEvidencePanels = new Boolean(value);
                    } else if (key.equalsIgnoreCase("FastDrawLimit")) {
                        try {
                            Config.setFastDrawLimit(Float.valueOf(value).floatValue());
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can't parse number: " + value + " for FastDrawLimit");
                        }
                    } else if (key.equalsIgnoreCase("SyntenyDir")) {
                        syntenyDir = value;
                    } else if (key.equalsIgnoreCase("ExonSyntenyDir")) {
                        exonSyntenyDir = value;
                    } else if (key.equalsIgnoreCase("CGIHost")) {
                        cgiHost = value;
                    } else if (key.equalsIgnoreCase("DBHost")) {
                        dbHost = value;
                    } else if (key.equalsIgnoreCase("DBName")) {
                        dbName = value;
                    } else if (key.equalsIgnoreCase("GoldenPathType")) {
                        gpName = value;
                    } else if (key.equalsIgnoreCase("SRSServer")) {
                        srsServer = value;
                    } else if (key.equalsIgnoreCase("PFetchServer")) {
                        pfetchServer = value;
                    } else if (key.equalsIgnoreCase("CGIScript")) {
                        cgiScript = value;
                    } else if (key.equalsIgnoreCase("DASServer")) {
                        dasServer = value;
                    } else if (key.equalsIgnoreCase("PublicSeqDbURL")) {
                        if (pubDbToURL == null) {
                            pubDbToURL = new Hashtable();
                        }
                        Config.addStringToHash(value, pubDbToURL);
                    } else if (key.equalsIgnoreCase("AutosaveFile")) {
                        autosaveFile = IOUtil.findFile(value, true);
                    } else if (key.equalsIgnoreCase("FrameOrientation")) {
                        frameOrientation = value;
                    } else if (key.equalsIgnoreCase("MainWindowWidth")) {
                        mainWindowWidth = Integer.parseInt(value);
                    } else if (key.equalsIgnoreCase("AdapterHistoryFile")) {
                        String hisfile = IOUtil.findFile(value, true);
                        Config.setAdapterHistoryFile(hisfile);
                    } else if (!key.equalsIgnoreCase("JavaPath")) {
                        if (key.equalsIgnoreCase("Memory")) {
                            if (value.indexOf("M") >= 0) {
                                value = value.substring(0, value.indexOf("M"));
                            }
                            try {
                                memoryAllocation = (long)Integer.parseInt(value) * 0x100000L;
                            }
                            catch (NumberFormatException e) {
                                System.err.println("Can't parse number: " + value + " for Memory " + value);
                            }
                        } else if (key.equalsIgnoreCase("DataAdapterInstall")) {
                            Config.installDataAdapter(value, styleName, dataAdapterLabel);
                            Config.setDataAdapterType(value);
                        } else if (key.equalsIgnoreCase("BrowserProgram")) {
                            Config.setBrowserProgram(value);
                        } else if (key.equalsIgnoreCase("Karyotypes")) {
                            karyotypeFile = new String(value);
                            if (osname.startsWith("Windows")) {
                                if (karyotypeFile.indexOf(":") < 0 || karyotypeFile.indexOf("\\") != 0) {
                                    karyotypeFile = Config.getRootDir() + "data\\" + karyotypeFile;
                                }
                            } else if (karyotypeFile.indexOf("/") != 0) {
                                karyotypeFile = Config.getRootDir() + "/data/" + karyotypeFile;
                            }
                        } else if (key.equals("OutputChadoTransaction")) {
                            outputChadoTransaction = Boolean.valueOf(value);
                        } else if (key.equals("OutputTransactionXML")) {
                            outputTransactionXML = Boolean.valueOf(value);
                        } else if (key.equals("ChadoTransactionTemplate")) {
                            chadoTemplFileName = value;
                        } else if (key.equals("ChadoJdbcAdapterConfigFile")) {
                            Config.setChadoJdbcConfigFile(value);
                        } else if (key.equals("CommandLineXmlFileFormat")) {
                            commandLineXmlFileFormat = value;
                        } else if (key.equalsIgnoreCase("AskConfirmOverwrite")) {
                            if (Config.checkBoolean(value, "AskConfirmOverwrite")) {
                                confirmOverwrite = new Boolean(value);
                            }
                        } else if (key.equalsIgnoreCase("SpeciesToStyle")) {
                            Config.addSpeciesToStyle(value);
                        } else if (key.equalsIgnoreCase("EnableHttpServer")) {
                            if (Config.checkBoolean(value, key)) {
                                httpServerIsEnabled = Config.getBoolean(value);
                            }
                        } else if (key.equalsIgnoreCase("DEBUG")) {
                            if (Config.checkBoolean(value, key)) {
                                Config.setDebug(Config.getBoolean(value));
                            }
                            DEBUG = Config.getBoolean(value);
                        } else if (key.equalsIgnoreCase("DO-ONE-LEVEL-ANNOTS")) {
                            if (Config.checkBoolean(value, key)) {
                                Config.setDoOneLevelAnnots(Config.getBoolean(value));
                            }
                        } else if (key.equalsIgnoreCase("SupressMacJvmPopupMessage")) {
                            if (Config.checkBoolean(value, key)) {
                                supressMacJvmPopup = Config.getBoolean(value);
                            }
                        } else {
                            System.out.println("Unknown config key " + key + " in config file " + fileName);
                        }
                    }
                } else if (words.size() == 1) {
                    System.err.println("Error parsing " + fileName + ": only 1 word on line: " + words.elementAt(0));
                } else if (words.size() != 0) {
                    System.err.println("Error parsing " + fileName + ": too many words on line beginning " + (String)words.elementAt(0) + " " + (String)words.elementAt(1) + " " + (words.size() > 1 ? (String)words.elementAt(2) : ""));
                }
                words.removeAllElements();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static void setDebug(boolean debug) {
        DEBUG = debug;
        AnnotationEditor.setDebug(debug);
        CurationSet.DEBUG = debug;
    }

    private static void setDoOneLevelAnnots(boolean doOne) {
        DO_ONE_LEVEL_ANNOTS = doOne;
        AnnotationEditor.setDoOneLevelAnnots(doOne);
    }

    private static void createStyle(String styleFilename, String driverName) {
        Style newStyle = Config.createStyle(styleFilename);
        if (newStyle != null) {
            adapterToStyle.put(driverName, newStyle);
        }
    }

    public static Style createStyle(String styleFilename) {
        String styleFilePath;
        if (styleFilename == null) {
            styleFilename = "default.style";
        }
        if (filenameToStyle.containsKey(styleFilename)) {
            return (Style)filenameToStyle.get(styleFilename);
        }
        String pathname = styleFilename;
        if (!styleFilename.startsWith("conf/")) {
            pathname = "conf/" + pathname;
        }
        if ((styleFilePath = IOUtil.findFile(pathname)) == null) {
            if (Config.getDebug()) {
                System.out.println("Config.createStyle: couldn't find " + styleFilename + " with findFile--trying digForConfigFile");
            }
            styleFilePath = Config.digForConfigFile(styleFilename);
        }
        Style newStyle = null;
        if (styleFilePath != null) {
            newStyle = new Style(styleFilePath);
            if (newStyle == null) {
                IOUtil.errorDialog("Couldn't read style file " + styleFilePath);
                return null;
            }
            if (Config.getDebug()) {
                System.out.println("Read style file " + styleFilePath);
            }
        }
        if (styleFilename.indexOf("fly") >= 0) {
            Style.askRenameGameConfig("game.style", "fly.style");
        }
        if ((styleFilePath = IOUtil.findFile("~/.apollo/" + styleFilename)) != null) {
            File sf = new File(styleFilePath);
            if (newStyle == null) {
                newStyle = new Style(styleFilePath);
            } else {
                newStyle.setStyleFile(styleFilePath);
                newStyle.readStyle(sf);
            }
            if (Config.getDebug()) {
                System.out.println("Read personal style file " + styleFilePath);
            }
        }
        if (newStyle != null) {
            filenameToStyle.put(styleFilename, newStyle);
        }
        return newStyle;
    }

    public static String digForConfigFile(String styleFilename) {
        String pathname = styleFilename;
        String styleFilePath = IOUtil.findFile(pathname);
        if (styleFilePath == null && !styleFilename.startsWith("conf/")) {
            pathname = "conf/" + pathname;
            styleFilePath = IOUtil.findFile(pathname);
        }
        if (styleFilePath == null) {
            try {
                System.err.println("Couldn't find style file " + styleFilename + "--trying to get from jar");
                styleFilePath = Config.getRootDir() + "/conf/" + styleFilename;
                if (styleFilename.indexOf("/") > 0) {
                    styleFilename = styleFilename.substring(styleFilename.indexOf("/") + 1);
                }
                File style = new File(styleFilePath);
                Config.ensureExists(style, styleFilename, true);
            }
            catch (Exception e) {
                System.err.println("Couldn't get " + styleFilePath + " from jar, either.");
                styleFilePath = null;
            }
        }
        if (Config.getDebug()) {
            System.out.println("Config.digForConfigFile: found " + styleFilename + " in " + styleFilePath);
        }
        return styleFilePath;
    }

    private static void installDataAdapter(String installString, String style, String label) {
        String driverName = installString;
        try {
            int breakIndex = driverName.indexOf(":");
            if (breakIndex > 0) {
                driverName = installString.substring(0, breakIndex);
            }
            adapterRegistry.removeDataAdapter(driverName);
            if (Config.canRunWithThisJVM(driverName)) {
                Config.createStyle(style, driverName);
                adapterRegistry.installDataAdapter(driverName);
                if (label != null && !label.equals("")) {
                    DataAdapter newAdapter = adapterRegistry.getAdapter(adapterRegistry.getAdapterCount() - 1);
                    if (newAdapter instanceof AbstractApolloAdapter) {
                        ((AbstractApolloAdapter)newAdapter).setName(label);
                    } else {
                        System.out.println("Warning: can't set name label " + label + " for " + newAdapter);
                    }
                }
            } else {
                System.err.println("Warning: " + driverName + " can't run with Java version " + jvm);
            }
        }
        catch (DataAdapterException e) {
            System.err.println("Could not install driver " + driverName + " because of: " + (Object)((Object)e));
        }
    }

    private static boolean canRunWithThisJVM(String driverName) {
        if ((driverName.indexOf("EnsJ") > 0 || driverName.indexOf("Synteny") > 0) && jvm.indexOf("1.4") < 0 && jvm.indexOf("1.5") < 0 && jvm.indexOf("1.6") < 0) {
            System.err.println("JVM " + jvm + " doesn't support data adapter " + driverName);
            return false;
        }
        return true;
    }

    public static String getRootDir() {
        Config.init();
        return rootDir;
    }

    public static String getDataDir() {
        Config.init();
        return dataDir;
    }

    public static int getMaxHistoryLength() {
        Config.init();
        return 5;
    }

    public static String getAdapterHistoryFile() {
        Config.init();
        return adapterHistoryFile;
    }

    public static boolean getConfirmOverwrite() {
        return !CommandLine.isInCommandLineMode() && confirmOverwrite;
    }

    public static void setConfirmOverwrite(boolean state) {
        confirmOverwrite = state;
    }

    public static boolean httpServerIsEnabled() {
        return httpServerIsEnabled;
    }

    public static boolean getDashSets() {
        return style.getDashSets();
    }

    public static boolean useFastClipGraphics() {
        return fastClipGraphics;
    }

    public static boolean doUserTranscriptColouring() {
        return style.doUserTranscriptColouring();
    }

    public static boolean getDraw3D() {
        return style.getDraw3D();
    }

    public static boolean getNoStripes() {
        return style.getNoStripes();
    }

    public static PropertyScheme getPropertyScheme() {
        Config.init();
        return Config.getStyle().getPropertyScheme();
    }

    public static Color getAnnotationColor(AnnotatedFeatureI annot) {
        AnnotatedFeatureI transcript = null;
        if (annot instanceof Transcript) {
            transcript = (Transcript)annot;
        } else if (annot.hasKids() && annot.getFeatureAt(0).isTranscript()) {
            transcript = annot.getFeatureAt(0).getAnnotatedFeature();
        } else {
            if (!annot.hasKids()) {
                FeatureProperty property = Config.getPropertyScheme().getFeatureProperty(annot.getTopLevelType());
                return property.getColour();
            }
            return defaultAnnotationColor;
        }
        String owner = transcript.getOwner();
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(transcript.getTopLevelType());
        return Config.getAnnotationColor(owner, fp);
    }

    public static Color getAnnotationColor(String username, FeatureProperty fp) {
        if (!Config.doUserTranscriptColouring() || !Config.getStyle().internalMode()) {
            return fp.getColour();
        }
        if (username == null || username.equals("") || username.equalsIgnoreCase("auto")) {
            return fp.getColour();
        }
        if (style == null) {
            return defaultAnnotationColor;
        }
        return style.getAnnotationColor(username);
    }

    public static Color getDefaultAnnotationColor() {
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty("gene");
        if (fp == null) {
            return defaultAnnotationColor;
        }
        return fp.getColour();
    }

    public static String getBlixemLocation() {
        Config.init();
        return style.getBlixemLocation();
    }

    public static String getBrowserProgram() {
        return browserProgram;
    }

    public static void setBrowserProgram(String browser) {
        browserProgram = browser;
    }

    public static Font getExonDetailEditorSequenceFont() {
        return style.getExonDetailEditorSequenceFont();
    }

    public static long getMemoryAllocation() {
        return memoryAllocation;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            Config.setDataDir(args[0]);
        }
        System.out.println("Data dir    = " + Config.getDataDir());
        System.out.println("Tiers       = " + Config.getPropertyScheme());
    }

    public static void initializeConfiguration() {
        Config.init();
    }

    private static void init() {
        if (!initialized) {
            String configFileName;
            initialized = true;
            osarch = System.getProperty("os.arch");
            osname = System.getProperty("os.name");
            jvm = System.getProperty("java.version");
            rootDir = IOUtil.getRootDir();
            System.out.println("OS name: " + osname);
            System.out.println("OS arch: " + osarch);
            System.out.println("Java version: " + jvm);
            if (IOUtil.isUnix() && browserProgram == null && ((browserProgram = System.getProperty("BROWSER")) == null || browserProgram.equals("")) && ((browserProgram = Config.findBrowser("mozilla")) == null || browserProgram.equals(""))) {
                browserProgram = "netscape";
            }
            if ((configFileName = IOUtil.findFile("conf/apollo.cfg")) == null) {
                System.err.println("Couldn't find apollo.cfg--trying to get from jar");
                configFileName = Config.getRootDir() + "/conf/apollo.cfg";
                File cfg = new File(configFileName);
                try {
                    Config.ensureExists(cfg, "apollo.cfg", true);
                }
                catch (Exception e) {
                    System.out.println("Couldn't get apollo.cfg from jar");
                    configFileName = null;
                }
            }
            if (configFileName == null) {
                IOUtil.errorDialog("Couldn't find config file (apollo.cfg) anywhere!");
                System.exit(-1);
            }
            File configFile = new File(configFileName);
            try {
                System.out.println("Reading config file " + configFileName);
                boolean success = Config.readConfig(configFile);
                if (!success) {
                    IOUtil.errorDialog("Failed to read config file " + configFileName);
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                IOUtil.errorDialog("Couldn't open config file " + configFileName + ": " + e.getMessage());
                System.exit(-1);
            }
            configFileName = IOUtil.findFile("~/.apollo/apollo.cfg");
            if (configFileName != null) {
                configFile = new File(configFileName);
                try {
                    System.out.println("Reading personal config file " + configFileName);
                    boolean success = Config.readConfig(configFile);
                    if (!success) {
                        System.err.println("Warning: failed to read personal config file " + configFileName);
                    }
                }
                catch (Exception e) {
                    System.out.println("Warning: couldn't open personal config file " + configFileName + ": " + e.getMessage());
                }
            }
            Config.setDefaultHistoryAndAutosaveLocs();
        }
    }

    private static void setDataDir(String dir) {
        dataDir = dir;
    }

    private static void setAdapterHistoryFile(String fileName) {
        adapterHistoryFile = fileName;
        try {
            File hist = new File(fileName);
            if (!hist.exists()) {
                try {
                    String default_hist = IOUtil.isWindows() ? Config.getRootDir() + "\\data\\history.default" : Config.getRootDir() + "/data/history.default";
                    System.out.println("Couldn't find history file " + fileName + "; copying default history file " + default_hist + " to " + fileName);
                    IOUtil.copyFile(default_hist, fileName);
                }
                catch (Exception e) {
                    System.out.println("Exception trying to copy history.default: " + e);
                }
            }
            System.out.println("Using history file " + fileName);
        }
        catch (Exception e) {
            System.out.println("Exception while checking for history file " + e);
        }
    }

    private static void addStringToHash(String string, Hashtable the_hash) {
        int index = string.indexOf("==");
        if (index > 0 && index + 2 < string.length()) {
            String label = string.substring(0, index);
            String val = string.substring(index += 2);
            the_hash.put(label, val);
        }
    }

    private static void setDefaultHistoryAndAutosaveLocs() {
        File dotApollo = new File(IOUtil.expandSquiggle("~/.apollo"));
        String whereToPut = dotApollo.isDirectory() && dotApollo.canWrite() || dotApollo.mkdir() ? IOUtil.expandSquiggle("~/.apollo/") : (IOUtil.isWindows() ? Config.getRootDir() + "\\data\\" : Config.getRootDir() + "/data/");
        File dir = new File(whereToPut);
        if (!dir.isDirectory() || !dir.canWrite()) {
            String message = "Can't write to " + dotApollo + " or to " + whereToPut + ".\nYour history and backup file will not be saved.\nAsk your sysadmin to change the permissions.";
            IOUtil.errorDialog(message);
            Config.setAutosaveInterval(-1);
            return;
        }
        if (Config.getAdapterHistoryFile() == null) {
            Config.setAdapterHistoryFile(whereToPut + "apollo.history");
        }
        if (Config.getAutosaveFile() == null) {
            autosaveFile = whereToPut + "apollo.backup";
        }
        System.out.println("Using backup file " + autosaveFile);
    }

    public static void setDBName(String name) {
        dbName = name;
    }

    public static void setDBHost(String host) {
        dbHost = host;
    }

    public static void setGPName(String name) {
        gpName = name;
    }

    private static void setAutosaveInterval(int in) {
        autosaveInterval = in;
    }

    private static void setCGIPort(int in) {
        cgiPort = in;
    }

    private static void setSiteShowLimit(int in) {
        siteShowLimit = in;
    }

    private static void setTextAvoidLimit(int in) {
        textAvoidLimit = in;
    }

    private static void setFastDrawLimit(float in) {
        fastDrawLimit = in;
    }

    private static void setTranslationShowLimit(int in) {
        translationShowLimit = in;
    }

    private static void setSyntenyPanelRelativeSize(int in) {
        syntenyPanelRelativeSize = in;
    }

    public static int getGeneWindow() {
        return geneWindowSize;
    }

    public static String getJVM() {
        return jvm;
    }

    private static String findBrowser(String browserName) {
        try {
            String command = Config.getRootDir() + "/bin/get-real-path ";
            Process proc = Runtime.getRuntime().exec(command + browserName);
            proc.waitFor();
            InputStream out = proc.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(out));
            String line = reader.readLine();
            if (line != null) {
                return line;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return "";
    }

    public static void setRefreshPeptides(boolean value) {
        refreshPeptides = value;
        System.out.println("Set refreshPeptides to " + value);
    }

    public static boolean getRefreshPeptides() {
        return refreshPeptides;
    }

    public static void ensureExists(File thing, String resource, boolean recreate) {
        if (!thing.exists() || recreate) {
            try {
                if (resource.indexOf("/") != 0) {
                    resource = "/" + resource;
                }
                System.err.println("Creating " + thing + " from " + resource);
                InputStream is = (class$apollo$config$Config == null ? (class$apollo$config$Config = Config.class$("apollo.config.Config")) : class$apollo$config$Config).getResourceAsStream(resource);
                if (is == null) {
                    throw new NullPointerException("Can't find resource: " + resource);
                }
                Config.getParentFile(thing).mkdirs();
                FileOutputStream os = new FileOutputStream(thing);
                int next = is.read();
                while (next != -1) {
                    ((OutputStream)os).write(next);
                    next = is.read();
                }
                os.flush();
                ((OutputStream)os).close();
            }
            catch (FileNotFoundException fnfe) {
                throw new Error("Can't create resource: " + fnfe.getMessage());
            }
            catch (IOException ioe) {
                throw new Error("Can't create resource: " + ioe.getMessage());
            }
        }
    }

    public static void ensureExists(File thing, String resource) {
        Config.ensureExists(thing, resource, false);
    }

    public static File getParentFile(File thing) {
        String p = thing.getParent();
        if (p == null) {
            return null;
        }
        return new File(p);
    }

    public static void reset() {
        initialized = false;
    }

    public static String getTimestamp() {
        File timestampFile;
        String time_path = IOUtil.findFile("data/timestamp");
        if (time_path == null) {
            timestampFile = new File(Config.getRootDir() + "/data/timestamp");
            try {
                Config.ensureExists(timestampFile, "timestamp");
            }
            catch (Exception e) {
                System.out.println("Couldn't find or create timestamp");
                return null;
            }
        }
        try {
            timestampFile = new File(time_path);
            BufferedReader in = new BufferedReader(new FileReader(timestampFile));
            String stamp = in.readLine();
            return stamp;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getUsersFullName() {
        return Config.getFullNameForUser(UserName.getUserName());
    }

    public static String getFullNameForUser(String user) {
        return Config.getStyle().getFullNameForUser(user);
    }

    public static Hashtable getPublicDbList() {
        if (pubDbToURL == null) {
            pubDbToURL = new Hashtable(1);
            pubDbToURL.put("Genbank", gbURL);
        }
        return pubDbToURL;
    }

    public static String getSyntenyDatabaseForSpecies(String species) {
        return Config.getStyle().getSyntenyDatabaseForSpecies(species);
    }

    public static String getDefaultSingleSpeciesName() {
        return defaultSpecies;
    }

    static boolean getBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static String getChadoTemplateName() {
        return chadoTemplFileName;
    }

    private static void setChadoJdbcConfigFile(String filename) {
        chadoJdbcAdapterConfigFile = filename;
        chadoJdbcAdapterConfigFileFullName = null;
        Config.getChadoJdbcAdapterConfigFile();
        String chadoClassString = "apollo.dataadapter.chado.ChadoAdapter";
        if (adapterRegistry.isInstalled(chadoClassString)) {
            adapterRegistry.removeDataAdapter(chadoClassString);
            try {
                adapterRegistry.installDataAdapter(chadoClassString);
            }
            catch (DataAdapterException e) {
                System.err.println("Could not install driver " + chadoClassString + " because of: " + (Object)((Object)e));
            }
        }
    }

    public static String getChadoJdbcAdapterConfigFile() {
        if (chadoJdbcAdapterConfigFileFullName == null) {
            chadoJdbcAdapterConfigFileFullName = IOUtil.findFile(chadoJdbcAdapterConfigFile, false);
            if (Config.getDebug() && chadoJdbcAdapterConfigFileFullName == null) {
                if (Config.getDebug()) {
                    System.out.println("Config.getChadoJdbcAdapterConfigFile: couldn't find " + chadoJdbcAdapterConfigFile + " with findFile--trying digForConfigFile");
                }
                chadoJdbcAdapterConfigFileFullName = Config.digForConfigFile(chadoJdbcAdapterConfigFile);
            }
            if (DEBUG) {
                System.out.println("Using chado jdbc adap config file " + chadoJdbcAdapterConfigFileFullName);
            }
        }
        if (chadoJdbcAdapterConfigFileFullName == null) {
            System.out.println("warning - unable to find chado jdbc adapter config file " + chadoJdbcAdapterConfigFile);
        }
        return chadoJdbcAdapterConfigFileFullName;
    }

    public static boolean isChadoTnOutputNeeded() {
        return outputChadoTransaction;
    }

    public static boolean outputTransactionXML() {
        return outputTransactionXML;
    }

    public static String getCommandLineXmlFileFormat() {
        return commandLineXmlFileFormat;
    }

    public static boolean commandLineXmlFileFormatIsConfigged() {
        if (commandLineXmlFileFormat == null) {
            return false;
        }
        return commandLineXmlFileFormat.matches("game|chado");
    }

    public static boolean supressMacJvmPopupMessage() {
        Config.init();
        return supressMacJvmPopup;
    }

    static boolean checkBoolean(String value, String variableName) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return true;
        }
        Config.complain("Value " + value + " for " + variableName + " is not boolean (should" + " be true or false)");
        return false;
    }

    private static void complain(String message) {
        System.err.println("Error in apollo.cfg file:\n  " + message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        outputChadoTransaction = false;
        outputTransactionXML = false;
        chadoTemplFileName = null;
        chadoJdbcAdapterConfigFile = "chado-adapter.xml";
        chadoJdbcAdapterConfigFileFullName = null;
        dataDir = null;
        rootDir = null;
        showSyntenyEvidencePanels = false;
        syntenyPanelRelativeSize = 2;
        translationShowLimit = 5;
        controller = Controller.getMasterController();
        adapterRegistry = new DataAdapterRegistry();
        defaultOverlapper = null;
        filenameToStyle = new HashMap(8);
        adapterToStyle = new HashMap(8);
        autosaveInterval = 30;
        cgiPort = 80;
        cgiHost = "ensrv1.sanger.ac.uk";
        cgiScript = "perl/apolloview";
        dbHost = "";
        dbName = "";
        gpName = "";
        srsServer = "www.sanger.ac.uk";
        pfetchServer = null;
        dasServer = "http://servlet.sanger.ac.uk:8080/das/";
        frameOrientation = "vertical";
        mainWindowWidth = 1000;
        geneWindowSize = 5000;
        confirmOverwrite = true;
        dataLoaderBackgroundColor = new Color(193, 205, 205);
        dataLoaderLabelColor = Color.black;
        dataLoaderTitleColor = new Color(0, 0, 102);
        defaultAnnotationColor = Color.blue;
        siteShowLimit = 15;
        textAvoidLimit = 1500;
        fastDrawLimit = 0.5f;
        fastClipGraphics = true;
        refreshPeptides = false;
        commandLineXmlFileFormat = "game";
        httpServerIsEnabled = false;
        initialized = false;
        DO_ONE_LEVEL_ANNOTS = false;
        inBatchMode = false;
        supressMacJvmPopup = false;
        DEBUG = false;
        defaultSpecies = "Species1";
    }

    private static class KeyValue {
        private String key;
        private String value;

        private KeyValue(String arrowString) {
            int arrowIndex = arrowString.indexOf("->");
            this.key = arrowString.substring(0, arrowIndex);
            this.value = arrowString.substring(arrowIndex + 2);
            this.key = this.key.trim();
            this.value = this.value.trim();
        }
    }
}

