/*
 * Decompiled with CFR 0.152.
 */
package apollo.bop;

import apollo.bop.JobOutput;
import apollo.dataadapter.exception.BopException;
import apollo.dataadapter.exception.NoOutputException;
import apollo.datamodel.Sequence;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.InflaterInputStream;

public class JDBCPipelineAdapter {
    String driver = "org.gjt.mm.mysql.Driver";
    String default_host = "space.lbl.gov";
    String default_db = "pipe";
    String url;
    protected int current_job_id;
    protected JobOutput job_run;

    public JDBCPipelineAdapter(String host, String db) {
        this.url = "jdbc:mysql://" + (host != null ? host : this.default_host) + "/" + (db != null ? db : this.default_db) + "?user=jdbc";
    }

    public JDBCPipelineAdapter() {
    }

    public JobOutput retrieveJob(int job_id) throws NoOutputException, BopException {
        this.job_run = new JobOutput();
        Statement stmt = null;
        Connection con = null;
        try {
            con = this.getConnection();
        }
        catch (Exception e) {
            throw new BopException("in retrieveJob: " + e.getMessage());
        }
        if (con == null) {
            throw new BopException("Can not establish db connection");
        }
        try {
            ResultSet rSet2;
            stmt = con.createStatement();
            ResultSet rSet = stmt.executeQuery("select j.time_processed, j.program, ds.name from job j, data_source_vrsn dsv, data_source ds where j.ds_vrsn_id = dsv.id and dsv.data_source_id = ds.id and j.id = " + job_id);
            if (rSet.next()) {
                this.job_run.setRunDate(rSet.getLong(1));
                System.out.println("Job run on " + this.job_run.getRunDate());
                String program = rSet.getString(2);
                String seq_ds = rSet.getString(3).toLowerCase();
                if (program == null) {
                    throw new NoOutputException("No program name for job: " + job_id);
                }
                System.out.println("Job was " + program + ":" + seq_ds);
                this.job_run.setAnalysisType(program, seq_ds);
            }
            String strResult = "";
            ResultSet rSet1 = stmt.executeQuery("select output_text, is_compressed from job_output where job_id = " + job_id + " and output_type = 'out'");
            if (rSet1.next()) {
                String compressed = rSet1.getString(2);
                if (compressed.equalsIgnoreCase("t")) {
                    System.out.println("Have to decompress results");
                    ResultSet rSet22 = stmt.executeQuery("select output_text from job_out_compress where job_id = " + job_id);
                    if (rSet22.next()) {
                        String strCompressed = rSet22.getString(1);
                        ByteArrayInputStream bis = new ByteArrayInputStream(strCompressed.getBytes());
                        InflaterInputStream istream = new InflaterInputStream(bis);
                        InputStreamReader r = new InputStreamReader(istream);
                        try {
                            BufferedReader bufreader = new BufferedReader(r);
                            String line = bufreader.readLine();
                            StringBuffer buf = new StringBuffer();
                            while (line != null) {
                                buf.append(line + "\n");
                                line = bufreader.readLine();
                            }
                            strResult = buf.toString();
                        }
                        catch (Exception e) {
                            throw new BopException("Can not decompress job: " + job_id + " error: " + e.getMessage());
                        }
                    }
                } else {
                    strResult = rSet1.getString(1);
                }
                if (strResult == null || strResult.equals("")) {
                    throw new NoOutputException("No output for job: " + job_id);
                }
                String extra1 = "Warning: no access to tty (Bad file descriptor).";
                String extra2 = "Thus no job control in this shell.";
                if (strResult.startsWith(extra1)) {
                    System.out.println("Trimming off " + extra1);
                    strResult = strResult.substring(extra1.length()).trim();
                }
                if (strResult.startsWith(extra2)) {
                    if (strResult.length() > extra2.length()) {
                        System.out.println("Trimming off " + extra2);
                        strResult = strResult.substring(extra2.length()).trim();
                    } else {
                        throw new NoOutputException("Empty job output");
                    }
                }
                System.out.println("Job raw output retrieved length=" + strResult.length() + " " + strResult.substring(0, 24));
                this.job_run.setRawOutput(strResult);
            }
            if ((rSet2 = stmt.executeQuery("select seq.name, seq.description, seq.residues from job, job_seq, seq where job.id = job_seq.job_id and seq.id = job_seq.seq_id and job.id = " + job_id)).next()) {
                Sequence seq = new Sequence(rSet2.getString(1), rSet2.getString(3));
                seq.setDescription(rSet2.getString(2));
                this.job_run.setQuerySequence(seq);
                System.out.println("Job sequence retrieved: " + seq.getName());
                this.current_job_id = job_id;
            }
        }
        catch (SQLException e) {
            System.err.println("Error in getting raw output from db: " + e.getMessage());
        }
        return this.job_run;
    }

    public Connection getConnection() throws Exception {
        Connection con = null;
        try {
            DriverManager.registerDriver((Driver)Class.forName(this.driver).newInstance());
            con = DriverManager.getConnection(this.url);
        }
        catch (InstantiationException e) {
            throw new Exception("Could not instantiate databasedriver: " + this.driver);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Illege access using databasedriver: " + this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Could not locate JDBC Drive class for mysql: " + this.driver);
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return con;
    }
}

