/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.ProgramHandlerFactory;
import apollo.analysis.ProgramHandlerI;
import apollo.analysis.SeqAnalysisBase;
import apollo.analysis.SeqAnalysisGUI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.seq.io.FastaFile;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class SeqAnalysisLocal
extends SeqAnalysisBase {
    private Runtime runner = Runtime.getRuntime();
    private Process proc;
    private String progOutput;
    private ProgramHandlerFactory phf;
    protected String seqFile;

    public SeqAnalysisLocal() {
        this.initSeqAnalysisLocal();
    }

    public SeqAnalysisLocal(Hashtable inproperties) {
        super(inproperties);
        this.initSeqAnalysisLocal();
    }

    public void init() {
        super.init();
    }

    public void initSeqAnalysisLocal() {
        this.progOutput = "";
        this.phf = new ProgramHandlerFactory();
        Vector<String> v = new Vector<String>();
        v.addElement("programName");
        v.addElement("programParams");
        v.addElement("datasourcePath");
        v.addElement("filter");
        v.addElement("tmpdir");
        this.setAllowedProperties(v);
        this.setPropertyDescription("programName", "name of an executable program to run should be in your PATH; otherwise you must specify the full path");
        Vector<String> progs = new Vector<String>();
        progs.addElement("blastx");
        progs.addElement("blastp");
        progs.addElement("blastall");
        progs.addElement("sim4");
        progs.addElement("genie");
        progs.addElement("genscan");
        this.setAllowedValues("programName", progs);
        Vector<String> filteropts = new Vector<String>();
        filteropts.addElement("none");
        filteropts.addElement("BOP");
        this.setAllowedValues("filter", filteropts);
        this.setPropertyType("datasourcePath", "path");
        this.setPropertyType("tmpdir", "dir");
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new SeqAnalysisGUI(this, op);
    }

    public String getName() {
        return "SeqAnalysisLocal";
    }

    public String getType() {
        return "locally executed analysis";
    }

    public boolean launch() {
        String cmd = this.getProgramShellCommand();
        boolean success = true;
        System.out.println("Launching " + cmd);
        try {
            this.proc = this.runner.exec(cmd);
            this.addProperty("isStarted", "true");
            if (this.proc.exitValue() == 0) {
                this.slurpResults(cmd);
                this.filter();
                this.addProperty("isFinished", "true");
            } else {
                this.slurpError(cmd);
                this.addProperty("isFinished", "false");
                success = false;
            }
        }
        catch (IOException e) {
            this.alertUserToError(cmd, e.getMessage());
            success = false;
        }
        return success;
    }

    protected String getSeqFile() {
        String seqpath = "tmp.fa";
        try {
            String fastr = FastaFile.print(this.getInputSequence());
            FileWriter w = new FileWriter(seqpath);
            w.write(fastr);
            System.out.println(fastr);
            w.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.seqFile = seqpath;
        return seqpath;
    }

    private void slurpResults(String cmd) {
        InputStreamReader isr = new InputStreamReader(this.proc.getInputStream());
        this.setProgOutput(cmd, isr);
        this.rawResults.put("out", this.progOutput);
    }

    private void slurpError(String cmd) {
        InputStreamReader isr = new InputStreamReader(this.proc.getErrorStream());
        this.setProgOutput(cmd, isr);
        this.alertUserToError(cmd, this.progOutput);
    }

    private void alertUserToError(String cmd, String err) {
        JOptionPane.showMessageDialog(null, err, "Unable to carry out " + cmd, 0);
        this.addProperty("isFinished", "false");
    }

    private void setProgOutput(String cmd, InputStreamReader isr) {
        BufferedReader br = new BufferedReader(isr);
        StringBuffer buf = new StringBuffer();
        try {
            String line = br.readLine();
            while (line != null) {
                buf.append(line + "\n");
                line = br.readLine();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.out);
            this.alertUserToError(cmd, e.getMessage());
        }
        this.progOutput = buf.toString();
    }

    private void filter() {
        String filter = this.getProperty("filter");
        if (filter != null && filter.equals("BOP")) {
            String out = (String)this.rawResults.get("out");
            String outpath = "tmp.out";
            try {
                FileWriter w = new FileWriter(outpath);
                w.write(out);
                w.close();
                String seqpath = this.getSeqFile();
                String bopclasspath = "/home/cjm/cvs/flybase/software/java-apps/classes:/home/cjm/cvs/flybase/software/java-apps/classes/jakarta-oro.jar";
                String bopcmd = "java -classpath " + bopclasspath + " bop.bop -fasta " + seqpath + " -o tmp.xml/home/cjm/cvs/flybase/software/java-apps/data/bop.prefs tmp.out";
                System.out.println("bopcmd = " + bopcmd);
                Process bopproc = this.runner.exec(bopcmd);
                GAMEAdapter ga = new GAMEAdapter();
                ga.init();
                ga.setInputType(DataInputType.FILE);
                ga.setInput("tmp.xml");
                this.curationSet = ga.getCurationSet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector getRawResultVector() {
        return new Vector();
    }

    protected String getProgramShellCommand() {
        String cmd = this.getProperty("programShellCommand");
        if (cmd == null) {
            ProgramHandlerI ph = this.phf.getProgramHandler(this);
            System.out.println("Got ph = " + ph);
            cmd = ph.createUnixShellCommand(this);
        }
        return cmd;
    }

    protected String getProgramPath() {
        String path = this.getProperty("programPath");
        if (path == null) {
            String pdir = this.getProgramDirectory();
            String pname = this.getProgramName();
            path = pdir == null ? pname : pdir + "/" + pname;
        }
        return path;
    }

    protected String getProgramDirectory() {
        return this.getProperty("programDirectory");
    }

    protected void run() {
    }
}

