/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BrowserFrame;
import java.awt.Event;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleBrowser {
    String server;
    int port;
    String out;
    BrowserFrame bf;
    Vector pages;
    int position = 0;

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            SimpleBrowser simpleBrowser = new SimpleBrowser("srs.ebi.ac.uk", 80, "srs5bin/cgi-bin/wgetz?-e+[" + stringArray[0] + "-id:" + stringArray[1] + "]");
        } else if (stringArray.length == 1) {
            SimpleBrowser simpleBrowser = new SimpleBrowser(stringArray[0]);
        } else {
            SimpleBrowser simpleBrowser = new SimpleBrowser("");
        }
    }

    public SimpleBrowser(String string) {
        this.pages = new Vector();
        this.pages.addElement(string);
        this.frameInit(string);
    }

    public SimpleBrowser(String string, int n, String string2) {
        this.server = string;
        this.port = n;
        if (string2.indexOf("/") != 0) {
            string2 = "/" + string2;
        }
        String string3 = "http://" + string + ":" + n + string2;
        this.pages = new Vector();
        this.pages.addElement(string3);
        this.frameInit(string3);
    }

    public void frameInit(String string) {
        this.bf = new BrowserFrame(this, "SimpleBrowser", 25, 72, "", string);
        this.bf.ta.setFont(new Font("Courier", 0, 12));
        this.bf.resize(700, 500);
        this.bf.show();
        this.bf.back.disable();
        this.bf.forward.disable();
        this.bf.status.setText("Connecting to server");
        this.connect(this.split(string));
    }

    public void connect(String string) {
        this.bf.status.setText("Connecting to server...");
        try {
            Socket socket = new Socket(this.server, this.port);
            socket.setSoTimeout(5000);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
            this.bf.status.setText("Reading URL...");
            printWriter.println("GET " + string + " HTTP/1.0");
            printWriter.println("Host: " + this.server);
            printWriter.println();
            String string2 = "";
            String string3 = "";
            int n = 0;
            boolean bl = true;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.equals("")) {
                    bl = false;
                }
                if (!bl && !string2.equals("")) {
                    string3 = string3 + SimpleBrowser.parse(string2) + "\n";
                }
                if (n != 1) {
                    this.bf.status.setText("Read " + n + " lines");
                } else {
                    this.bf.status.setText("Read " + n + " line");
                }
                ++n;
            }
            this.bf.setText(string3);
            this.bf.status.setText("done");
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException);
            this.bf.setText("Not online");
            this.bf.status.setText("");
        }
        catch (SocketException socketException) {
            System.out.println("Socket Exception " + socketException);
            this.bf.setText("Socket exception");
            this.bf.status.setText("");
        }
        catch (InterruptedIOException interruptedIOException) {
            System.out.println("Read to server timed out " + interruptedIOException);
            this.bf.setText("Server connect timed out");
            this.bf.status.setText("");
        }
        catch (IOException iOException) {
            this.bf.setText("IO exception");
            this.bf.status.setText("");
            System.out.println("IOException " + iOException);
        }
    }

    public boolean action(Event event, Object object) {
        System.out.println(event + " " + object);
        if (event.target == this.bf.tf) {
            System.out.println("new page");
            String string = this.bf.tf.getText();
            this.pages.addElement(string);
            String string2 = this.split(string);
            System.out.println("Server = " + this.server);
            System.out.println("Port = " + this.port);
            System.out.println("Page = " + string2);
            this.connect(string2);
            ++this.position;
            this.bf.back.enable();
            return true;
        }
        if (event.target == this.bf.back) {
            System.out.println("pos " + this.position + " " + this.pages.size());
            if (this.position > 0) {
                --this.position;
                String string = this.split((String)this.pages.elementAt(this.position));
                this.bf.tf.setText((String)this.pages.elementAt(this.position));
                this.connect(string);
                if (this.position == 0) {
                    this.bf.back.disable();
                }
                this.bf.forward.enable();
            }
            return true;
        }
        if (event.target == this.bf.forward) {
            if (this.position != this.pages.size() - 1) {
                ++this.position;
                this.bf.tf.setText((String)this.pages.elementAt(this.position));
                String string = this.split((String)this.pages.elementAt(this.position));
                if (this.position == this.pages.size() - 1) {
                    this.bf.forward.disable();
                }
                this.bf.back.enable();
                this.connect(string);
            }
            return true;
        }
        if (event.target == this.bf.b) {
            System.out.println("Disposing of browser frame");
            this.bf.hide();
            this.bf.dispose();
            this.bf = null;
            return true;
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            System.out.println("Disposing of browser frame");
            this.bf.hide();
            this.bf.dispose();
            this.bf = null;
            return true;
        }
        return false;
    }

    public static String removeString(String string, String string2) {
        String string3 = "";
        while (string.indexOf(string2) >= 0) {
            String string4;
            string = string4 = string.substring(0, string.indexOf(string2)) + string.substring(string.indexOf(string2) + string2.length());
        }
        return string;
    }

    public static String parse(String string) {
        String string2 = "";
        if ((string = SimpleBrowser.removeString(string, "&nbsp;")).indexOf("<") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string2 = string3.indexOf(">") >= 0 ? string2 + string3.substring(string3.indexOf(">") + 1) : string2 + string3;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public String split(String string) {
        System.out.println(string);
        if (string.indexOf("http://") == 0) {
            string = string.substring(7);
        }
        System.out.println("URL = " + string);
        String string2 = "/";
        if (string.indexOf("/") != -1) {
            string2 = string.substring(string.indexOf("/"));
            string = string.substring(0, string.indexOf("/"));
        }
        System.out.println("PAge = " + string2);
        System.out.println("Url = " + string);
        if (string.indexOf(":") >= 0) {
            this.port = Integer.parseInt(string.substring(string.indexOf(":") + 1));
            this.server = string.substring(0, string.indexOf(":"));
        } else {
            this.port = 80;
            this.server = string.indexOf("/") != -1 ? string.substring(0, string.indexOf("/")) : string;
        }
        System.out.println(this.server);
        System.out.println(this.port);
        return string2;
    }
}

