/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Mail;
import jalview.OutputGenerator;
import jalview.Popup;
import jalview.PostscriptProperties;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;

public class PostscriptPopup
extends Popup {
    TextField tf;
    Label tfLabel;
    Mail mail;
    Label fontLabel;
    Choice font;
    Label fontsizeLabel;
    Choice fontSize;
    Label orientLabel;
    Choice orient;
    Label sizeLabel;
    Choice size;
    OutputGenerator og;

    public PostscriptPopup(Frame frame, String string, OutputGenerator outputGenerator) {
        super(frame, string);
        this.og = outputGenerator;
        this.createInterface();
    }

    public void createInterface() {
        this.tf = new TextField(40);
        this.tfLabel = new Label("Mail address : ");
        this.tf.setText(this.og.getMailProperties().address);
        this.fontLabel = new Label("Font");
        this.font = new Choice();
        this.font.addItem("Times-Roman");
        this.font.addItem("Courier");
        this.font.addItem("Helvetica");
        this.fontsizeLabel = new Label("Font size");
        this.fontSize = new Choice();
        this.fontSize.addItem("1");
        this.fontSize.addItem("2");
        this.fontSize.addItem("4");
        this.fontSize.addItem("6");
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("20");
        this.fontSize.addItem("24");
        this.fontSize.select(new Integer(8).toString());
        this.orientLabel = new Label("Orientation");
        this.orient = new Choice();
        this.orient.addItem("Portrait");
        this.orient.addItem("Landscape");
        this.sizeLabel = new Label("Paper size");
        this.size = new Choice();
        this.size.addItem("A4");
        this.size.addItem("US letter");
        this.size.addItem("US letter small");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.fontLabel, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.font, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.fontsizeLabel, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.fontSize, this.gb, this.gbc, 1, 2, 1, 1);
        this.add(this.orientLabel, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(this.orient, this.gb, this.gbc, 1, 3, 1, 1);
        this.add(this.sizeLabel, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.size, this.gb, this.gbc, 1, 4, 1, 1);
        this.add(this.status, this.gb, this.gbc, 0, 5, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 6, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 6, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            String string = this.tf.getText();
            this.status.setText("Checking email address");
            this.status.validate();
            if (string.indexOf(64) == -1) {
                this.status.setText("Invalid mail address (enter name@my.email.server )");
                this.status.validate();
                this.hide();
                this.dispose();
            } else {
                this.status.setText("done");
                this.status.validate();
                System.out.println("Mail address " + string);
                this.status.setText("Connecting to mail server");
                this.status.validate();
                this.mail = new Mail();
                String string2 = string;
                String string3 = "<michele@ebi.ac.uk>";
                String string4 = "Jalview alignment";
                String string5 = "";
                this.status.setText("Mail Server = " + this.og.getMailProperties().server);
                this.status.validate();
                this.mail.send(this.og.getMailProperties().server, string2, string3, string4, string5);
                this.sendText();
                this.mail.finish();
                this.hide();
                this.dispose();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public void sendText() {
        this.og.getPostscriptProperties().font = this.font.getSelectedItem();
        this.og.getPostscriptProperties().fsize = Integer.valueOf(this.fontSize.getSelectedItem());
        this.og.getPostscriptProperties().orientation = this.orient.getSelectedItem().equals("Landscape") ? PostscriptProperties.LANDSCAPE : PostscriptProperties.PORTRAIT;
        if (this.size.getSelectedItem().equals("US letter")) {
            this.og.getPostscriptProperties().width = 576;
            this.og.getPostscriptProperties().height = 776;
        } else if (this.size.getSelectedItem().equals("US letter small")) {
            this.og.getPostscriptProperties().width = 552;
            this.og.getPostscriptProperties().height = 730;
        }
        this.status.setText("Generating postscript...(this takes a while)");
        this.og.getPostscript(this.mail.out);
        this.status.setText("done");
    }
}

