/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.Format;
import jalview.PostscriptProperties;
import jalview.ProgressBar;
import jalview.ResidueProperties;
import jalview.SequenceGroup;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class Postscript {
    AlignFrame af;
    DrawableAlignment al;
    int noseqs;
    float boxsize;
    float yspace;
    int ygap;
    int maxseqlen;
    int maxidlen;
    StringBuffer out;
    BufferedWriter sw;
    PrintStream ps;
    Color lightBlue = new Color(175, 175, 255);
    Color midBlue = new Color(110, 110, 255);
    float xorig;
    float xtext;
    float ytext;
    float seqstart;
    int orient;
    int fontsize;
    int xmargin;
    int ymargin;
    int paperwidth;
    int paperheight;
    int alignwidth;
    int alignheight;
    String font;
    boolean makeString;
    ProgressBar pb;

    public Postscript(AlignFrame alignFrame, BufferedWriter bufferedWriter, ProgressBar progressBar) {
        this.af = alignFrame;
        this.al = alignFrame.ap.seqPanel.align;
        this.pb = progressBar;
        this.orient = alignFrame.pp.orientation;
        this.font = alignFrame.pp.font;
        this.fontsize = alignFrame.pp.fsize;
        this.xmargin = alignFrame.pp.xoffset;
        this.ymargin = alignFrame.pp.yoffset;
        this.ygap = 30;
        this.sw = bufferedWriter;
    }

    public Postscript(AlignFrame alignFrame, PrintStream printStream, ProgressBar progressBar) {
        this.af = alignFrame;
        this.al = alignFrame.ap.seqPanel.align;
        this.orient = alignFrame.pp.orientation;
        this.pb = progressBar;
        this.out = new StringBuffer();
        this.font = alignFrame.pp.font;
        this.fontsize = alignFrame.pp.fsize;
        this.xmargin = alignFrame.pp.xoffset;
        this.ymargin = alignFrame.pp.yoffset;
        this.ygap = 30;
        this.ps = printStream;
    }

    public Postscript(AlignFrame alignFrame, boolean bl, ProgressBar progressBar) {
        if (bl) {
            this.makeString = true;
            this.af = alignFrame;
            this.al = alignFrame.ap.seqPanel.align;
            this.orient = alignFrame.pp.orientation;
            this.pb = progressBar;
            this.out = new StringBuffer();
            this.font = alignFrame.pp.font;
            this.fontsize = alignFrame.pp.fsize;
            this.xmargin = alignFrame.pp.xoffset;
            this.ymargin = alignFrame.pp.yoffset;
            this.ygap = 30;
        }
    }

    public void print(String string) throws IOException {
        if (this.sw != null) {
            this.sw.write(string);
        }
        if (this.ps != null) {
            this.ps.print(string);
        }
        if (this.makeString) {
            this.out.append(string);
        }
    }

    public void generate() {
        DecimalFormat decimalFormat = new DecimalFormat("####.#");
        PostscriptProperties cfr_ignored_0 = this.af.pp;
        if (this.orient == PostscriptProperties.PORTRAIT) {
            PostscriptProperties cfr_ignored_1 = this.af.pp;
            this.paperwidth = PostscriptProperties.SHORTSIDE;
            PostscriptProperties cfr_ignored_2 = this.af.pp;
            this.paperheight = PostscriptProperties.LONGSIDE;
        } else {
            PostscriptProperties cfr_ignored_3 = this.af.pp;
            this.paperwidth = PostscriptProperties.LONGSIDE;
            PostscriptProperties cfr_ignored_4 = this.af.pp;
            this.paperheight = PostscriptProperties.SHORTSIDE;
        }
        this.noseqs = this.al.size();
        int n = this.al.maxLength();
        this.maxidlen = this.al.maxIdLength();
        this.boxsize = (float)((double)this.fontsize * 1.1);
        this.yspace = this.af.ap.seqPanel.seqCanvas.showScores ? this.boxsize * 2.0f : this.boxsize;
        double d = 0.7;
        if (this.font.equals("Courier")) {
            d = 1.0;
        }
        this.seqstart = (float)((double)(this.boxsize * (float)this.maxidlen) * d + (double)this.xmargin);
        int n2 = (int)(((float)this.paperwidth - this.seqstart - (float)(2 * this.xmargin)) / this.boxsize);
        int n3 = (int)((float)(this.paperheight - 2 * this.ymargin) / this.yspace);
        float f = 2.0f * this.boxsize + (float)this.noseqs * this.yspace;
        int n4 = (int)((float)(this.paperheight - this.ymargin) / (f + (float)this.ymargin));
        if (n4 == 0) {
            n4 = 1;
        }
        System.out.println("height " + this.paperheight + " ymargin " + this.ymargin + " aligny " + f);
        System.out.println("boxsize " + this.boxsize + " noseqs " + this.noseqs + " yspace " + this.yspace);
        int n5 = 1;
        System.out.println("nocharx " + n2 + " noalign " + n4);
        System.out.println("number of pages = " + (n5 += n / (n2 * n4)));
        this.alignwidth = (int)(this.seqstart + (float)(2 * this.xmargin) + (float)n2 * this.boxsize);
        this.alignheight = n4 > 1 ? (int)(f * (float)(n4 + 1) + (float)(2 * this.ymargin)) : (int)(f * (float)n4 + (float)(2 * this.ymargin));
        this.printinit();
        int n6 = 1;
        float f2 = 0.0f;
        int n7 = 0;
        try {
            int n8 = 0;
            while (n8 < n) {
                float f3;
                float f4;
                int n9;
                if (n8 % n2 == 0) {
                    if (n4 > 1 && n7 < n4 && n7 != 0) {
                        f2 = (float)n7 * (f + 30.0f);
                        ++n7;
                    } else {
                        f2 = 0.0f;
                        n7 = 1;
                        if (n6 > 1) {
                            this.print("\nshowpage\n");
                        }
                        this.print("\n%%Page: ? " + n6 + "\n");
                        if (this.paperwidth > this.paperheight) {
                            PostscriptProperties cfr_ignored_5 = this.af.pp;
                            this.print(PostscriptProperties.SHORTSIDE + " 0 translate\n90 rotate\n");
                        }
                        ++n6;
                        if (this.sw != null) {
                            this.sw.flush();
                        }
                    }
                    this.print("black setrgbcolor\n");
                    n9 = 0;
                    while (n9 < this.noseqs) {
                        String string = this.al.sequences[n9].getName() + "/" + this.al.sequences[n9].start + "-" + this.al.sequences[n9].end;
                        f4 = (float)(this.paperheight - this.ymargin) - this.boxsize - (float)n9 * this.yspace - f2;
                        this.ytext = this.af.ap.seqPanel.seqCanvas.showScores ? (float)((double)(f4 + this.yspace / 2.0f) + 0.2 * (double)this.boxsize) : (float)((double)f4 + 0.2 * (double)this.boxsize);
                        this.print("(" + string + ") " + decimalFormat.format(this.xmargin) + " " + decimalFormat.format(this.ytext) + " moveto show\n");
                        ++n9;
                    }
                }
                n9 = n8 % n2;
                this.xorig = (float)n9 * this.boxsize + this.seqstart;
                this.xtext = (float)((double)this.xorig + 0.12 * (double)this.boxsize);
                if (n8 % 10 == 9 && n8 != 0) {
                    float f5 = (float)((double)(this.paperheight - this.ymargin) + 0.2 * (double)this.boxsize - (double)f2);
                    f4 = (float)((double)(this.paperheight - this.ymargin) + 1.2 * (double)this.boxsize - (double)f2);
                    f3 = (float)((double)this.xorig + 0.4 * (double)this.boxsize);
                    int n10 = n8 + 1;
                    this.print("black setrgbcolor\n");
                    this.print("(|) " + decimalFormat.format(f3) + " " + decimalFormat.format(f5) + " moveto show\n");
                    this.print("(" + n10 + ") " + decimalFormat.format(this.xtext) + " " + decimalFormat.format(f4) + " moveto show\n");
                }
                if (this.pb != null) {
                    this.pb.updateBar(this.noseqs * n8 / n);
                }
                int n11 = 0;
                while (n11 < this.noseqs) {
                    int n12;
                    String string;
                    String string2;
                    Object object;
                    String string3 = this.al.sequences[n11].getName();
                    f3 = (float)(this.paperheight - this.ymargin) - this.boxsize - (float)n11 * this.yspace - f2;
                    this.ytext = this.af.ap.seqPanel.seqCanvas.showScores ? (float)((double)(f3 + this.yspace / 2.0f) + 0.2 * (double)this.boxsize) : (float)((double)f3 + 0.2 * (double)this.boxsize);
                    String string4 = " ";
                    if (n8 < this.al.sequences[n11].getSequence().length()) {
                        string4 = this.al.sequences[n11].getSequence().substring(n8, n8 + 1);
                    } else if (n8 == this.al.sequences[n11].getSequence().length()) {
                        string4 = this.al.sequences[n11].getSequence().substring(n8);
                    }
                    int n13 = 23;
                    try {
                        n13 = (Integer)ResidueProperties.aaHash.get(string4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SequenceGroup sequenceGroup = this.al.findGroup(n11);
                    Color color = Color.white;
                    if (sequenceGroup.displayBoxes) {
                        color = this.findBoxColor(n8, n11, string4);
                    }
                    Format format = new Format("%6.1f");
                    String string5 = format.form((float)((double)color.getRed() / 256.0));
                    String string6 = format.form((float)((double)color.getGreen() / 256.0));
                    String string7 = format.form((float)((double)color.getBlue() / 256.0));
                    if (!sequenceGroup.displayText) {
                        string4 = " ";
                    }
                    if (sequenceGroup.colourText) {
                        Color color2 = this.findTextColor(n8, n11, string4);
                        object = format.form((float)((double)color2.getRed() / 256.0));
                        string2 = format.form((float)((double)color2.getGreen() / 256.0));
                        string = format.form((float)((double)color2.getBlue() / 256.0));
                        if (this.af.ap.seqPanel.seqCanvas.showScores) {
                            this.print("(" + string4 + ") " + decimalFormat.format(this.xtext) + " " + decimalFormat.format(this.ytext) + " " + (String)object + " " + string2 + " " + string + " " + string5 + " " + string6 + " " + string7 + " " + decimalFormat.format(this.xorig) + " " + decimalFormat.format(f3 + this.boxsize) + " -" + decimalFormat.format(this.boxsize) + " " + decimalFormat.format(this.boxsize) + " boxtext\n");
                        } else {
                            this.print("(" + string4 + ") " + decimalFormat.format(this.xtext) + " " + decimalFormat.format(this.ytext) + " " + (String)object + " " + string2 + " " + string + " " + string5 + " " + string6 + " " + string7 + " " + decimalFormat.format(this.xorig) + " " + decimalFormat.format(f3) + " -" + decimalFormat.format(this.boxsize) + " " + decimalFormat.format(this.boxsize) + " boxtext\n");
                        }
                    } else if (this.af.ap.seqPanel.seqCanvas.showScores) {
                        this.print("(" + string4 + ") " + this.xtext + " " + this.ytext + " black " + string5 + " " + string6 + " " + string7 + " " + decimalFormat.format(this.xorig) + " " + decimalFormat.format(f3 + this.boxsize) + " -" + decimalFormat.format(this.boxsize) + " " + decimalFormat.format(this.boxsize) + " boxtext\n");
                    } else {
                        this.print("(" + string4 + ") " + decimalFormat.format(this.xtext) + " " + decimalFormat.format(this.ytext) + " black " + string5 + " " + string6 + " " + string7 + " " + decimalFormat.format(this.xorig) + " " + decimalFormat.format(f3) + " -" + decimalFormat.format(this.boxsize) + " " + decimalFormat.format(this.boxsize) + " boxtext\n");
                    }
                    if (this.af.ap.seqPanel.seqCanvas.showScores && this.al.sequences[n11].score[0] != null && this.al.sequences[n11].score[0].size() > n8 && (n12 = ((Double)this.al.sequences[n11].score[0].elementAt(n8)).intValue()) >= 0 && n12 < 10) {
                        object = (Color)((DrawableSequence)this.al.sequences[n11]).scaleColours.elementAt(((Double)this.al.sequences[n11].score[0].elementAt(n8)).intValue());
                        string2 = format.form((float)((double)((Color)object).getRed() / 256.0));
                        string = format.form((float)((double)((Color)object).getGreen() / 256.0));
                        String string8 = format.form((float)((double)((Color)object).getBlue() / 256.0));
                        this.print("( ) " + this.xtext + " " + this.ytext + " black " + string2 + " " + string + " " + string8 + " " + this.xorig + " " + (f3 + this.boxsize - this.yspace / 4.0f) + " -" + this.boxsize / 2.0f + " " + this.boxsize / 2.0f + " " + this.boxsize + " recttext\n");
                    }
                    ++n11;
                }
                ++n8;
            }
            this.print("showpage\n");
            if (this.sw != null) {
                this.sw.flush();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    public Color findBoxColor(int n, int n2, String string) {
        return (Color)this.af.ap.seqPanel.align.ds[n2].boxColour.elementAt(n);
    }

    public Color findTextColor(int n, int n2, String string) {
        return ((Color)this.af.ap.seqPanel.align.ds[n2].boxColour.elementAt(n)).darker();
    }

    public void printinit() {
        try {
            this.print("%!PS-Adobe-3.0 EPSF-3.0\n");
            PostscriptProperties cfr_ignored_0 = this.af.pp;
            if (this.orient == PostscriptProperties.PORTRAIT) {
                this.print("%%BoundingBox: 0 " + (this.paperheight - this.alignheight) + " " + this.alignwidth + " " + this.paperheight + "\n");
            } else {
                this.print("%%BoundingBox: 0 " + (this.paperwidth - this.alignheight) + " " + this.alignwidth + " " + this.paperwidth + "\n");
            }
            this.print("/white {1.0 1.0 1.0 } def\n");
            this.print("/black {0.0 0.0 0.0 } def\n");
            this.print("/gray  {0.35 0.35 0.35 } def\n");
            this.print("/red  {1.0 0.35 0.35 } def\n");
            this.print("/green  {0.35 1.0 0.35 } def\n");
            this.print("/blue  {0.35 0.35 1.0 } def\n");
            this.print("/boxtext {\n");
            this.print("/boxsize exch def\n");
            this.print("/negsize exch def\n");
            this.print("newpath\nmoveto\n\n");
            this.print("0 boxsize rlineto\n");
            this.print("boxsize 0 rlineto\n");
            this.print("0 negsize  rlineto\n");
            this.print("closepath\n");
            this.print("setrgbcolor fill setrgbcolor\n");
            this.print("moveto show\n");
            this.print("} def\n");
            this.print("/recttext {\n");
            this.print("/boxx exch def\n");
            this.print("/boxy exch def\n");
            this.print("/negy exch def\n");
            this.print("newpath\nmoveto\n\n");
            this.print("0 boxy rlineto\n");
            this.print("boxx 0 rlineto\n");
            this.print("0 negy  rlineto\n");
            this.print("closepath\n");
            this.print("setrgbcolor fill setrgbcolor\n");
            this.print("moveto show\n");
            this.print("} def\n");
            this.print("/" + this.font + " findfont\n");
            this.print(this.fontsize + " scalefont\n");
            this.print("setfont\n");
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
        }
    }
}

