/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.FileParse;
import jalview.Format;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PfamFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector ids;
    Vector words = new Vector();
    long start;
    long end;

    public PfamFile(String string) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        this.readLines(string);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public PfamFile(String string, String string2) throws IOException {
        super(string, string2);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        System.err.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.err.println("done");
        System.err.println("Total time taken = " + (this.end - this.start) + "ms");
        System.err.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        Object object;
        String string;
        Object object2;
        int n = 0;
        Vector<CharSequence> vector = new Vector<CharSequence>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        n = 0;
        while (n < this.noLines) {
            if (this.lineArray.elementAt(n).toString().indexOf(" ") != 0) {
                CharSequence charSequence;
                String string2;
                if (this.lineArray.elementAt(n).toString().indexOf("#") != 0) {
                    object2 = new StringTokenizer(this.lineArray.elementAt(n).toString(), " ");
                    string2 = "";
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object2).nextToken();
                        charSequence = new StringBuffer();
                        if (this.myHash.containsKey(string2)) {
                            charSequence = new StringBuffer(this.myHash.get(string2).toString());
                        }
                        if (!this.headers.contains(string2)) {
                            this.headers.addElement(string2);
                        }
                        ((StringBuffer)charSequence).append(((StringTokenizer)object2).nextToken());
                        this.myHash.put(string2, ((StringBuffer)charSequence).toString());
                    }
                } else if (this.lineArray.elementAt(n).toString().indexOf("#=") == 0) {
                    object2 = new StringTokenizer(this.lineArray.elementAt(n).toString(), " ");
                    string = "";
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object2).nextToken();
                        charSequence = ((StringTokenizer)object2).nextToken();
                        object = ((StringTokenizer)object2).nextToken();
                        if (!vector.contains(charSequence)) {
                            vector.addElement(charSequence);
                        }
                        if (string2.equals("#=GR")) {
                            hashtable2.put((String)charSequence + (String)object, object);
                            hashtable.put((String)charSequence + (String)object, string2);
                            string = ((StringTokenizer)object2).nextToken();
                            hashtable3.put((String)charSequence + (String)object, string);
                        } else if (string2.equals("#=GS")) {
                            hashtable2.put((String)charSequence + (String)object, object);
                            hashtable.put((String)charSequence + (String)object, string2);
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                string = string + ((StringTokenizer)object2).nextToken();
                            }
                            hashtable3.put((String)charSequence + (String)object, string);
                        } else if (string2.equals("#=GC")) {
                            hashtable2.put((String)charSequence + "GC", object);
                            hashtable.put((String)charSequence + "GC", string2);
                        } else {
                            System.err.println("Unrecognised feature type " + string2);
                        }
                    }
                }
            }
            ++n;
        }
        this.noSeqs = this.headers.size();
        n = 0;
        while (n < this.headers.size()) {
            if (this.myHash.get(this.headers.elementAt(n)) != null) {
                Sequence sequence;
                String string3;
                if (this.maxLength < this.myHash.get(this.headers.elementAt(n)).toString().length()) {
                    this.maxLength = this.myHash.get(this.headers.elementAt(n)).toString().length();
                }
                object2 = this.headers.elementAt(n).toString();
                int n2 = 1;
                int n3 = this.myHash.get(this.headers.elementAt(n)).toString().length();
                if (((String)object2).indexOf("/") > 0) {
                    object = new StringTokenizer((String)object2, "/");
                    if (((StringTokenizer)object).countTokens() == 2) {
                        vector.addElement(((StringTokenizer)object).nextToken());
                        string = ((StringTokenizer)object).nextToken();
                        object = new StringTokenizer(string, "-");
                        if (((StringTokenizer)object).countTokens() == 2) {
                            n2 = Integer.valueOf(((StringTokenizer)object).nextToken());
                            n3 = Integer.valueOf(((StringTokenizer)object).nextToken());
                        } else {
                            n2 = -1;
                            n3 = -1;
                        }
                    } else {
                        vector.addElement((CharSequence)this.headers.elementAt(n));
                    }
                } else {
                    vector.addElement((CharSequence)this.headers.elementAt(n));
                }
                if (n2 != -1 && n3 != -1) {
                    object = new Sequence(vector.elementAt(n).toString(), this.myHash.get(this.headers.elementAt(n).toString()).toString(), n2, n3);
                    this.seqs.addElement(object);
                    string = ((Sequence)object).getName();
                    if (vector.contains(string)) {
                        if (hashtable2.containsKey(string + "SS")) {
                            string3 = (String)hashtable3.get(string + "SS");
                            sequence = new Sequence(string, string3, ((Sequence)object).getStart(), ((Sequence)object).getEnd());
                            sequence.type = Sequence.STRUCTURE;
                            this.seqs.addElement(sequence);
                        }
                        if (hashtable3.containsKey(string + "SA")) {
                            string3 = (String)hashtable3.get(string + "SA");
                            sequence = new Sequence(string, string3, ((Sequence)object).getStart(), ((Sequence)object).getEnd());
                            sequence.type = Sequence.SURFACC;
                            this.seqs.addElement(sequence);
                        }
                        if (hashtable3.containsKey(string + "AS")) {
                            string3 = (String)hashtable3.get(string + "AS");
                            sequence = new Sequence(string, string3, ((Sequence)object).getStart(), ((Sequence)object).getEnd());
                            sequence.type = Sequence.ACTIVESITE;
                            this.seqs.addElement(sequence);
                        }
                    }
                } else {
                    object = new Sequence(vector.elementAt(n).toString(), this.myHash.get(this.headers.elementAt(n).toString()).toString(), 1, this.myHash.get(this.headers.elementAt(n).toString()).toString().length());
                    this.seqs.addElement(object);
                    string = ((Sequence)object).getName() + "/" + ((Sequence)object).getStart() + "-" + ((Sequence)object).getEnd();
                    if (vector.contains(string)) {
                        if (hashtable2.contains(string + "SS")) {
                            string3 = (String)hashtable3.get(string + "SS");
                            sequence = new Sequence(string, string3, ((Sequence)object).getStart(), ((Sequence)object).getEnd());
                            sequence.type = Sequence.STRUCTURE;
                            this.seqs.addElement(sequence);
                            System.err.println("Tyhpe " + sequence.type);
                        }
                        if (hashtable3.containsKey(string + "SA")) {
                            string3 = (String)hashtable3.get(string + "SA");
                            sequence = new Sequence(string, string3, ((Sequence)object).getStart(), ((Sequence)object).getEnd());
                            sequence.type = Sequence.SURFACC;
                            this.seqs.addElement(sequence);
                        }
                        if (hashtable3.containsKey(string + "AS")) {
                            string3 = (String)hashtable3.get(string + "AS");
                            sequence = new Sequence(string, string3, ((Sequence)object).getStart(), ((Sequence)object).getEnd());
                            sequence.type = Sequence.ACTIVESITE;
                            this.seqs.addElement(sequence);
                        }
                    }
                }
            } else {
                System.err.println("Can't find sequence for " + this.headers.elementAt(n));
            }
            ++n;
        }
        this.end = System.currentTimeMillis();
        System.err.println("done");
        System.err.println("Total time taken = " + (this.end - this.start) + "ms");
    }

    public static String print(Sequence[] sequenceArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < sequenceArray.length && sequenceArray[n3] != null) {
            String string = sequenceArray[n3].getName() + "/" + sequenceArray[n3].start + "-" + sequenceArray[n3].end;
            if (sequenceArray[n3].getSequence().length() > n) {
                n = sequenceArray[n3].getSequence().length();
            }
            if (string.length() > n2) {
                n2 = string.length();
            }
            ++n3;
        }
        if (n2 < 15) {
            n2 = 15;
        }
        int n4 = 0;
        while (n4 < sequenceArray.length && sequenceArray[n4] != null) {
            stringBuffer.append(new Format("%-" + n2 + "s").form(sequenceArray[n4].getName() + "/" + sequenceArray[n4].start + "-" + sequenceArray[n4].end) + " ");
            stringBuffer.append(sequenceArray[n4].getSequence() + "\n");
            ++n4;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            PfamFile pfamFile = new PfamFile(string, "File");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

