/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.FileParse;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PIRFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector words = new Vector();
    long start;
    long end;

    public PIRFile(String string) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.readLines(string);
        this.parse();
    }

    public PIRFile(String string, String string2) throws IOException {
        super(string, string2);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.lineArray.size()) {
            if (((String)this.lineArray.elementAt(n4)).length() > 0) {
                StringTokenizer stringTokenizer;
                if (((String)this.lineArray.elementAt(n4)).indexOf(">P1;") == 0) {
                    bl = true;
                    if (n != 0) {
                        if (string2.indexOf("*") > 0) {
                            string2 = string2.substring(0, string2.indexOf("*"));
                        }
                        this.seqs.addElement(new Sequence(string, string2, 1, string2.length()));
                    }
                    ++n;
                    stringTokenizer = new StringTokenizer((String)this.lineArray.elementAt(n4), " ");
                    string = stringTokenizer.nextToken();
                    if ((string = string.substring(4)).indexOf("/") > 0) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "/");
                        if (stringTokenizer2.countTokens() == 2) {
                            string = stringTokenizer2.nextToken();
                            String string4 = stringTokenizer2.nextToken();
                            if ((stringTokenizer2 = new StringTokenizer(string4, "-")).countTokens() == 2) {
                                n2 = Integer.valueOf(stringTokenizer2.nextToken());
                                n3 = Integer.valueOf(stringTokenizer2.nextToken());
                            } else {
                                n2 = -1;
                                n3 = -1;
                            }
                        } else {
                            n2 = -1;
                            n3 = -1;
                        }
                    }
                    string3 = (String)this.lineArray.elementAt(++n4);
                    string2 = "";
                } else {
                    stringTokenizer = new StringTokenizer((String)this.lineArray.elementAt(n4), " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = string2 + stringTokenizer.nextToken();
                    }
                }
            }
            ++n4;
        }
        if (bl) {
            if (string2.indexOf("*") > 0) {
                string2 = string2.substring(0, string2.indexOf("*"));
            }
            if (n2 >= 0 && n3 >= 0) {
                this.seqs.addElement(new Sequence(string, string2, n2, n3));
            } else {
                this.seqs.addElement(new Sequence(string, string2, 1, string2.length()));
            }
        }
    }

    public static String print(Sequence[] sequenceArray, int n) {
        return PIRFile.print(sequenceArray, n, true);
    }

    public static String print(Sequence[] sequenceArray, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < sequenceArray.length && sequenceArray[n2] != null) {
            String string = "";
            if (bl) {
                string = sequenceArray[n2].getSequence() + "*";
            } else {
                string = AlignSeq.extractGaps(sequenceArray[n2].getSequence(), "-");
                string = AlignSeq.extractGaps(string, ".");
                string = AlignSeq.extractGaps(string, " ");
                string = string + "*";
            }
            stringBuffer.append(">P1;" + sequenceArray[n2].getName() + "/" + sequenceArray[n2].start + "-" + sequenceArray[n2].end + "\n");
            stringBuffer.append(" Dummy title\n");
            int n3 = string.length() / n + 1;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 * n;
                int n6 = n5 + n;
                if (n6 < string.length()) {
                    stringBuffer.append(string.substring(n5, n6) + "\n");
                } else if (n5 < string.length()) {
                    stringBuffer.append(string.substring(n5) + "\n");
                }
                ++n4;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = ">P1;LCAT_MOUSE_90.35\nMGLPGSPWQRVLLLLGLLLPPATPFWLLNVLFPPHTTPKAELSNHTRPVILVPGCLGNRLEAKLDKPDVVNW\nMCYRKTEDFFTIWLDFNLFLPLGVDCWIDNTRIVYNHSSGRVSNAPGVQIRVPGFGKTESVEYVDDNKLAGY\n\n>LCAT_PAPAN_95.78\nMGPPGSPWQWVPLLLGLLLPPAAPFWLLNVLFPPHTTPKAELSNHTRPVILVPGCLGNQLEAKLDKPDVVNW\nMCYRKTEDFFTIWLDLNMFLPLGVDCWIDNTRVVYNRSSGLVSNAPGVQIRVPGFGKTYSVEYLDSSKLAGY\nLHTLVQNLVNNGYVRDETVRAAPYDWRLEPGQQEEYYHKLAGLVEEMHAAYGKPVFLIGHSLGCLHLLYFLL\n";
        PIRFile pIRFile = new PIRFile(string);
    }
}

