/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ColorSelect;
import jalview.ColourCanvas;
import jalview.ColourPanel;
import jalview.ResidueProperties;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ColourChooserPanel
extends Panel {
    Vector cp;
    ColourPanel none;
    Color[] color;
    ColorSelect cs;
    Hashtable hash;
    Frame f;
    AlignFrame af;

    public ColourChooserPanel(AlignFrame alignFrame, Color[] colorArray) {
        Serializable serializable;
        this.af = alignFrame;
        this.color = colorArray;
        this.cs = new ColorSelect();
        this.hash = new Hashtable();
        this.makeHash(colorArray);
        this.cp = new Vector(this.hash.size());
        Enumeration enumeration = this.hash.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serializable = (Color)enumeration.nextElement();
            String string = (String)this.hash.get(serializable);
            this.cp.addElement(new ColourPanel((Color)serializable, string));
            ++n;
        }
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridLayout(this.cp.size() + 1, 1));
        int n2 = 0;
        while (n2 < this.cp.size()) {
            ((Container)serializable).add((ColourPanel)this.cp.elementAt(n2));
            ++n2;
        }
        ((Component)serializable).resize(250, (this.cp.size() + 1) * 50);
        ((Container)serializable).invalidate();
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)serializable);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.cs);
        this.cs.resize(this.size().width, 150);
        panel.resize(this.size().width, 150);
        this.add("South", panel);
    }

    public void makeHash(Color[] colorArray) {
        int n = 0;
        while (n < colorArray.length) {
            String string;
            if (this.hash.containsKey(colorArray[n])) {
                string = (String)this.hash.get(colorArray[n]);
                String string2 = this.findResidueString(n);
                this.hash.put(colorArray[n], string + string2);
            } else {
                string = this.findResidueString(n);
                this.hash.put(colorArray[n], string);
            }
            ++n;
        }
    }

    public void updateHash() {
        int n = 0;
        while (n < this.cp.size()) {
            Color color = ((ColourPanel)this.cp.elementAt((int)n)).cc.c;
            ((ColourPanel)this.cp.elementAt(n)).setString((String)this.hash.get(color));
            ++n;
        }
    }

    public String findResidueString(int n) {
        Enumeration enumeration = ResidueProperties.aaHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = (Integer)ResidueProperties.aaHash.get(string);
            if (n != n2) continue;
            return string;
        }
        return null;
    }

    public void makeArray() {
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Color color = (Color)enumeration.nextElement();
            String string = (String)this.hash.get(color);
            int n = 0;
            while (n < string.length()) {
                String string2 = string.substring(n, n + 1);
                int n2 = ResidueProperties.aaHash.size();
                try {
                    n2 = (Integer)ResidueProperties.aaHash.get(string2);
                    this.color[n2] = color;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void changeColour(ColourPanel colourPanel) {
        String string = colourPanel.s;
        String string2 = colourPanel.getString();
        int n = 0;
        while (n < string.length()) {
            String string3 = string.substring(n, n + 1);
            if (string2.indexOf(string3) < 0) {
                this.hash.put(Color.white, this.hash.get(Color.white) + string3);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < string2.length()) {
            String string4 = string2.substring(n2, n2 + 1);
            Enumeration enumeration = this.hash.keys();
            while (enumeration.hasMoreElements()) {
                Color color = (Color)enumeration.nextElement();
                if (((String)this.hash.get(color)).indexOf(string4) < 0) continue;
                String string5 = (String)this.hash.get(color);
                string5 = string5.substring(0, string5.indexOf(string4)) + string5.substring(string5.indexOf(string4) + 1);
                this.hash.put(color, string5);
            }
            ++n2;
        }
        this.hash.put(colourPanel.cc.c, string2);
        this.updateHash();
    }

    public boolean handleEvent(Event event) {
        Button button;
        if (event.target instanceof Button && event.id == 1001 && (button = (Button)event.target).getParent() instanceof ColourPanel) {
            ColourPanel colourPanel = (ColourPanel)button.getParent();
            this.changeColour(colourPanel);
            if (this.af != null) {
                this.makeArray();
                this.af.ap.color = this.color;
                this.af.ap.setSequenceColor();
                this.af.updateFont();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof TextField) {
            return false;
        }
        return super.action(event, object);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.target instanceof ColourCanvas) {
            ColourCanvas colourCanvas = (ColourCanvas)event.target;
            if ((event.modifiers & 4) != 0) {
                this.cs.setColor(colourCanvas.c);
                this.cs.myColorPanel.pogCanvas.paint(this.cs.myColorPanel.pogCanvas.getGraphics());
            } else {
                Color color = this.cs.getColor();
                colourCanvas.c = this.cs.getColor();
                colourCanvas.repaint();
            }
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        ColourChooserPanel colourChooserPanel = new ColourChooserPanel(null, ResidueProperties.color);
        frame.setLayout(new BorderLayout());
        frame.add("Center", colourChooserPanel);
        frame.resize(colourChooserPanel.getPreferredSize().width, colourChooserPanel.getPreferredSize().height);
        frame.show();
    }

    public Dimension getPreferredSize() {
        return new Dimension(((ColourPanel)this.cp.elementAt((int)0)).getPreferredSize().width, this.cp.size() * ((ColourPanel)this.cp.elementAt((int)0)).getPreferredSize().height + 150);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

