# This Makefile defines the standard rules for building the project.
#
# The following variables are used:
#
# JARTARGET
#   The name of the jar archive
#   Example: JARTARGET=UCEcho.jar
#
# CLASSTARGETS
#   Java Classes that have to be build 
#   Example: CLASSTARGETS=UCEcho.class
#
# CLASSEXTRADEPS
#   Extra dependencies for Java Classes
#
# IHXTARGETS
#   ihx files (firmware ROM files) that have to be build 
#   Example: IHXTARGETS=ucecho.ihx
#
# IHXEXTRADEPS
#   Extra Dependencies for ihx files
#
# EXTRAJARFILES
#   Extra files that should be included into the jar archive
#   Example: EXTRAJARFILES=ucecho.ihx fpga/ucecho.bin
# EXTRAJARFLAGS
#   Extra flags for the jar command
#   Example: EXTRAJARFLAGS=-C com

# EXTRACLEANFILES
#   Extra files that should be cleaned by target "clean"

# EXTRADISTCLEANFILES
#   Extra files that should be cleaned by target "distclean"


.PHONY: all ihx jar clean distclean default
.SUFFIXES: .ihx .class .jar .java .c

PREFIX=/usr
JAVADIR=$(PREFIX)/share/java

JAVAC=javac
SDCC=bmpsdcc.sh
CLASSPATH:=.:/usr/share/java/libusb.jar:$(PREFIX)/share/ztex/FWLoader.jar
INCLUDES=-I $(PREFIX)/share/ztex/fx2

all : ihx jar 
ihx : $(IHXTARGETS)
jar : $(JARTARGET)

%.ihx: %.c $(IHXEXTRADEPS)
	$(SDCC) $< "$(INCLUDES)"

%.class: %.java $(CLASSEXTRADEPS)
	$(JAVAC) -cp "$(CLASSPATH)" $<

$(JARTARGET) : $(CLASSTARGETS) $(EXTRAJARFILES)
	#jar cf $(JARTARGET) *.class $(EXTRAJARFILES) $(EXTRAJARFLAGS) -C $(JAVADIR) ch -C $(JAVADIR) ztex $(shell [ -d $(PREFIX)/share/libusbJava ] && echo "-C $(PREFIX)/share/libusbJava .")
	jar cf $(JARTARGET) *.class $(EXTRAJARFILES) $(EXTRAJARFLAGS)

clean: 
	rm -f *~ *.bak *.old
	rm -f *.class 
	rm -f *.rel *.rst *.lnk *.lst *.map *.asm *.sym *.mem *.tmp.c 
	rm -f $(EXTRACLEANFILES)

distclean: clean
	rm -f $(JARTARGET)
	rm -f *.ihx
	rm -f $(EXTRADISTCLEANFILES)
