##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Techreport reference main class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import registerType

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields \
    import institutionField, typeField, numberField, addressField


SourceSchema = Schema((
    institutionField,
    typeField,
    numberField,
    addressField,
    ))

TechreportSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
                   SourceSchema + TrailingSchema


class TechreportReference(BaseEntry):
    """ content type to make reference to a technical report.
    """
    security = ClassSecurityInfo()
    archetype_name = "Techreport Reference"
    source_fields = ('institution', 'type', 'number', 'address')

    schema = TechreportSchema
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default technical report source format
        """
        try:
            return self.TechreportSource()
        except AttributeError:
            institution = self.getInstitution()
            type        = self.getType()
            number      = self.getNumber()
            address     = self.getAddress()
            
            source = "%s, %s(%s), %s." % (institution, type, number, address)
            
            return source.replace('()','').replace(' ,','')


registerType(TechreportReference)
