use Test::More tests => 2;
require 't/env.pm';

use strict;
use Zim::Formats;

# TODO test registering
# TODO test listing

my $tree = [
	'Document', {},
	['head1', {}, 'a b c'],
	['head2', {}, 'd 1'],
	"text 1",
	['head3', {}, 'e 2'],
	"text 2",
	['head4', {}, 'f 3'],
	"text 3",
];

Zim::Formats->update_heads($tree, 3, 5);
is_deeply($tree, [
	'Document', {},
	['head3', {}, 'a b c'],
	['head4', {}, 'd 1'],
	"text 1",
	['head5', {}, 'e 2'],
	"text 2",
	['head5', {}, 'f 3'],
	"text 3",
],
'update_heads' );

my ($l, $t) = Zim::Formats->get_first_head($tree);
is_deeply([$l, $t], ['3', 'a b c'], 'get_first_head');

