use Test::More tests => 4;
require 't/env.pm';

use strict;
use Zim;

# This test is intended to test if calls to the store object
# end up correctly in the Dir object set trough "DirType".
# In order to do this a mock object is set for the DirType
# that is used to wrap methods with test code.
#
# This test should make sure that e.g. Bazaar.pm will work

# fake loading module
unshift @INC, sub {
	my (undef, $file) = @_;
	return undef unless $file =~ /Mock/;
	my $package = q{
package Zim::FS::Mock;

our @ISA = qw/Zim::FS::Dir/;
} ;
	my $fh;
	open $fh, '<', \$package;
	return $fh;
};

# New repository
my $rep = Zim->new(
	dir => 't/notebook',
	config => {
		DirType => 'Mock',
	}
);

# new page
my $page = $rep->get_page(':sdfsdfsdfsdf');
$page->delete if $page->exists;

# test "on_write_file"
set(on_write_file => sub {
	my ($dir, $file, $new) = @_;
	ok($file eq $$page{source} && $new, 'on_write called 1');
});
$page->set_parse_tree(['Document', {}, ['head1', {}, 'FOO']]);

set(on_write_file => sub {
	my ($dir, $file, $new) = @_;
	ok($file eq $$page{source} && !$new, 'on_write called 2');
});
$page->set_parse_tree(['Document', {}, ['head1', {}, 'FOOBAR']]);

my $new = $rep->get_page(':sfsdfsdfsdfggg');
$new->delete if $new->exists;

# test move_file
set('move_file' => sub {
	my ($dir, $src, $dest) = @_;
	ok($src eq $$page{source} && $dest eq $$new{source}, 'move_file 1');
});
$page->move($new);

set('move_file' => sub {
	my ($dir, $src, $dest) = @_;
	ok($src eq $$new{source} && $dest eq $$page{source}, 'move_file 2');
});
$rep->move_page($new, $page);

$page->delete if $page->exists;
$new->delete if $new->exists;

exit;

sub set {
	# Add watcher to mock object
	my ($sub, $code) = @_;
	no warnings;
	no strict 'refs';
	*{"Zim::FS::Mock::$sub"} = sub {
		delete ${"Zim::FS::Mock::"}{$sub};  # remove hook again at run
		$code->(@_);                        # call hook
		&{"Zim::FS::Dir::$sub"}(@_);        # call SUPER
	};
}

