<?php
return array(
	'slideshows' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'slideshowid',
		'fields' => array(
			'slideshowid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'slides' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'slideid',
		'fields' => array(
			'slideid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'slideshowid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'screenid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'step' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'drules' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'druleid',
		'fields' => array(
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'proxy_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'iprange' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'unique_dcheckid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'dchecks' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'dcheckid',
		'fields' => array(
			'dcheckid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
			'snmp_community' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
			'ports' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
			'snmpv3_securityname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_securitylevel' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_authpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_privpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'dhosts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'dhostid',
		'fields' => array(
			'dhostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastup' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastdown' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'dservices' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'dserviceid',
		'fields' => array(
			'dserviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'dhostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastup' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastdown' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dcheckid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
		),
	),
	'ids' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'nodeid,table_name,field_name',
		'fields' => array(
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'table_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'field_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'nextid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'httptest' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httptestid',
		'fields' => array(
			'httptestid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'applicationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'lastcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'curstate' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'curstep' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastfailedstep' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '60',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'macros' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'agent' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'time' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'authentication' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'http_user' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'http_password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'httpstep' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httpstepid',
		'fields' => array(
			'httpstepid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'httptestid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'no' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'timeout' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '30',
			),
			'posts' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'required' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status_codes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'httpstepitem' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httpstepitemid',
		'fields' => array(
			'httpstepitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'httpstepid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'httptestitem' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httptestitemid',
		'fields' => array(
			'httptestitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'httptestid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'nodes' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'nodeid',
		'fields' => array(
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '0',
			),
			'timezone' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '10051',
			),
			'slave_history' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '30',
			),
			'slave_trends' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'nodetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'masterid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'node_cksum' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'tablename' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'recordid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'cksumtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'cksum' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'sync' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
		),
	),
	'services_times' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'timeid',
		'fields' => array(
			'timeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'serviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_to' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'note' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'alerts' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'alertid',
		'fields' => array(
			'alertid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'mediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'sendto' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'subject' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'message' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'retries' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_step' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'alerttype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
		),
	),
	'history_sync' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
		),
	),
	'history_uint' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'history_uint_sync' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'history_str' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'history_str_sync' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'history_log' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'timestamp' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'severity' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'logeventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_text' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'proxy_history' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'timestamp' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'severity' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'logeventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'proxy_dhistory' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dcheckid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'events' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'eventid',
		'fields' => array(
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'object' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'objectid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'acknowledged' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'trends' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'itemid,clock',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'num' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_min' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
			'value_avg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
			'value_max' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
		),
	),
	'trends_uint' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'itemid,clock',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'num' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_min' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'value_avg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'value_max' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'acknowledges' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'acknowledgeid',
		'fields' => array(
			'acknowledgeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'message' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'auditlog' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'auditid',
		'fields' => array(
			'auditid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'action' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'resourcetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'details' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'resourceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'resourcename' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'auditlog_details' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'auditdetailid',
		'fields' => array(
			'auditdetailid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'auditid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'table_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'field_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'oldvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'newvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'service_alarms' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'servicealarmid',
		'fields' => array(
			'servicealarmid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'serviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'actions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'actionid',
		'fields' => array(
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'eventsource' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'evaltype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'def_shortdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'def_longdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'recovery_msg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'r_shortdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'r_longdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'operations' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'operationid',
		'fields' => array(
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'operationtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'object' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'objectid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'shortdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'longdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'esc_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_step_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_step_to' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'default_msg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'evaltype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'opconditions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opconditionid',
		'fields' => array(
			'opconditionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'conditiontype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'operator' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'opmediatypes' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opmediatypeid',
		'fields' => array(
			'opmediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'mediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'escalations' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'escalationid',
		'fields' => array(
			'escalationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'r_eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_step' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'applications' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'applicationid',
		'fields' => array(
			'applicationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'conditions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'conditionid',
		'fields' => array(
			'conditionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'conditiontype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'operator' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'config' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'configid',
		'fields' => array(
			'configid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'alert_history' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'event_history' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'refresh_unsupported' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'work_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '1-5,00:00-24:00',
			),
			'alert_usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'event_ack_enable' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'event_expire' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '7',
			),
			'event_show_max' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '100',
			),
			'default_theme' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => 'default.css',
			),
			'authentication_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ldap_host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ldap_port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 389,
			),
			'ldap_base_dn' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ldap_bind_dn' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ldap_bind_password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'ldap_search_attribute' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'dropdown_first_entry' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'dropdown_first_remember' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'discovery_groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'max_in_table' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '50',
			),
			'search_limit' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1000',
			),
		),
	),
	'functions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'functionid',
		'fields' => array(
			'functionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'lastvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'function' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 12,
				'default' => '',
			),
			'parameter' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
		),
	),
	'graphs' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'graphid',
		'fields' => array(
			'graphid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'yaxismin' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'yaxismax' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'show_work_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'show_triggers' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'graphtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'show_legend' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'show_3d' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'percent_left' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'percent_right' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'ymin_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ymax_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ymin_itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'ymax_itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'graphs_items' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'gitemid',
		'fields' => array(
			'gitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'graphid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'drawtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'sortorder' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '009600',
			),
			'yaxisside' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'calc_fnc' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'periods_cnt' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '5',
			),
		),
	),
	'graph_theme' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'graphthemeid',
		'fields' => array(
			'graphthemeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'theme' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'backgroundcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'F0F0F0',
			),
			'graphcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FFFFFF',
			),
			'graphbordercolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '222222',
			),
			'gridcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'CCCCCC',
			),
			'maingridcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'AAAAAA',
			),
			'gridbordercolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			),
			'textcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '202020',
			),
			'highlightcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'AA4444',
			),
			'leftpercentilecolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '11CC11',
			),
			'rightpercentilecolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'CC1111',
			),
			'noneworktimecolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'CCCCCC',
			),
			'gridview' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 1,
			),
			'legendview' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 1,
			),
		),
	),
	'groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'groupid',
		'fields' => array(
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'internal' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'help_items' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'itemtype,key_',
		'fields' => array(
			'itemtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'hosts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostid',
		'fields' => array(
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'proxy_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'dns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'useip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '127.0.0.1',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '10050',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastaccess' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'inbytes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'outbytes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'useipmi' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '623',
			),
			'ipmi_authtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_privilege' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'ipmi_username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			),
			'ipmi_password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 20,
				'default' => '',
			),
			'ipmi_disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'maintenance_status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'maintenance_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'maintenance_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '127.0.0.1',
			),
			'ipmi_errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'snmp_error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
		),
	),
	'globalmacro' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'globalmacroid',
		'fields' => array(
			'globalmacroid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'macro' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'hostmacro' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostmacroid',
		'fields' => array(
			'hostmacroid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'macro' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'hosts_groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostgroupid',
		'fields' => array(
			'hostgroupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'hosts_profiles' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostid',
		'fields' => array(
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'devicetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'os' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'serialno' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'tag' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'macaddress' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'hardware' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'software' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'contact' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'location' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'hosts_profiles_ext' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostid',
		'fields' => array(
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'device_alias' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_chassis' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_os' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_os_short' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_hw_arch' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			),
			'device_serial' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_model' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_tag' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_vendor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_contract' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_who' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_app_01' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_app_02' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_app_03' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_app_04' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_app_05' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'device_url_1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'device_url_2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'device_url_3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'device_networks' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'device_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'device_hardware' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'device_software' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'ip_subnet_mask' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'ip_router' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'ip_macaddress' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'oob_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'oob_subnet_mask' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'oob_router' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'date_hw_buy' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'date_hw_install' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'date_hw_expiry' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'date_hw_decomm' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_street_1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_street_2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_street_3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_city' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_state' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_country' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_zip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_rack' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'poc_1_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_1_email' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_1_phone_1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_phone_2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_cell' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_screen' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'poc_2_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_2_email' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_2_phone_1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_phone_2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_cell' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_screen' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'hosts_templates' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hosttemplateid',
		'fields' => array(
			'hosttemplateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'housekeeper' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'housekeeperid',
		'fields' => array(
			'housekeeperid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'tablename' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'field' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'images' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'imageid',
		'fields' => array(
			'imageid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'imagetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '0',
			),
			'image' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_BLOB,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'items' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'itemid',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_community' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmp_oid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'snmp_port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '161',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'history' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '90',
			),
			'trends' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'lastvalue' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'lastclock' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'prevvalue' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'trapper_hosts' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'units' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 10,
				'default' => '',
			),
			'multiplier' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'delta' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'prevorgvalue' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'snmpv3_securityname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_securitylevel' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_authpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_privpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'formula' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '1',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'lastlogsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'logtimefmt' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'valuemapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'delay_flex' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'params' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'ipmi_sensor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'data_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'authtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'publickey' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'privatekey' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'mtime' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'items_applications' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'itemappid',
		'fields' => array(
			'itemappid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'applicationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'mappings' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'mappingid',
		'fields' => array(
			'mappingid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'valuemapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'newvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'media' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'mediaid',
		'fields' => array(
			'mediaid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'mediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'sendto' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'active' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'severity' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '63',
			),
			'period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '1-7,00:00-23:59',
			),
		),
	),
	'media_type' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'mediatypeid',
		'fields' => array(
			'mediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'smtp_server' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'smtp_helo' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'smtp_email' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'exec_path' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'gsm_modem' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'passwd' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'profiles' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'profileid',
		'fields' => array(
			'profileid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'idx' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 96,
				'default' => '',
			),
			'idx2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'value_id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'value_int' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_str' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 96,
				'default' => '',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'rights' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'rightid',
		'fields' => array(
			'rightid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'permission' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
		),
	),
	'scripts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'scriptid',
		'fields' => array(
			'scriptid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'command' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'host_access' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'screens' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'screenid',
		'fields' => array(
			'screenid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => 'Screen',
			),
			'hsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'vsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
		),
	),
	'screens_items' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'screenitemid',
		'fields' => array(
			'screenitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'screenid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'resourcetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'resourceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '320',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			),
			'x' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'y' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'colspan' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'rowspan' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'elements' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '25',
			),
			'valign' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'halign' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'style' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'dynamic' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'services' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'serviceid',
		'fields' => array(
			'serviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'algorithm' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'showsla' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'goodsla' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '99.9',
			),
			'sortorder' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'services_links' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'linkid',
		'fields' => array(
			'linkid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'serviceupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'servicedownid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'soft' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'sessions' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'sessionid',
		'fields' => array(
			'sessionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'lastaccess' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'sysmaps_links' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'linkid',
		'fields' => array(
			'linkid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'selementid1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'selementid2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'drawtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			),
			'label' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'sysmaps_link_triggers' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'linktriggerid',
		'fields' => array(
			'linktriggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'linkid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'drawtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			),
		),
	),
	'sysmaps_elements' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'selementid',
		'fields' => array(
			'selementid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'elementid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'elementtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'iconid_off' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'iconid_on' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'iconid_unknown' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'label' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'label_location' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'x' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'y' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'iconid_disabled' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'iconid_maintenance' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'sysmaps' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'sysmapid',
		'fields' => array(
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'backgroundid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'label_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'label_location' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'highlight' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
		),
	),
	'triggers' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'triggerid',
		'fields' => array(
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'expression' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'priority' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastchange' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dep_level' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'comments' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'trigger_depends' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'triggerdepid',
		'fields' => array(
			'triggerdepid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'triggerid_down' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'triggerid_up' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'users' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'userid',
		'fields' => array(
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'alias' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'surname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'passwd' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'autologin' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'autologout' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '900',
			),
			'lang' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 5,
				'default' => 'en_gb',
			),
			'refresh' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '30',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'theme' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => 'default.css',
			),
			'attempt_failed' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'attempt_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'attempt_clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'rows_per_page' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 50,
			),
		),
	),
	'usrgrp' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'usrgrpid',
		'fields' => array(
			'usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'gui_access' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'users_status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'api_access' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'debug_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'users_groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'valuemaps' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'valuemapid',
		'fields' => array(
			'valuemapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'maintenances' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenanceid',
		'fields' => array(
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'maintenance_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'active_since' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'active_till' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'maintenances_hosts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenance_hostid',
		'fields' => array(
			'maintenance_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'maintenances_groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenance_groupid',
		'fields' => array(
			'maintenance_groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'maintenances_windows' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenance_timeperiodid',
		'fields' => array(
			'maintenance_timeperiodid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'timeperiodid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'timeperiods' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'timeperiodid',
		'fields' => array(
			'timeperiodid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'timeperiod_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'every' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'month' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dayofweek' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'day' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'start_time' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'start_date' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'regexps' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'regexpid',
		'fields' => array(
			'regexpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'test_string' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'user_history' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'userhistoryid',
		'fields' => array(
			'userhistoryid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'title1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title4' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url4' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title5' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url5' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'expressions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'expressionid',
		'fields' => array(
			'expressionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'regexpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'expression' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'expression_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'exp_delimiter' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 1,
				'default' => '',
			),
			'case_sensitive' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'autoreg_host' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'autoreg_hostid',
		'fields' => array(
			'autoreg_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'proxy_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'proxy_autoreg_host' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
);
?>