(* $Id: biniou.mli 30 2010-06-03 07:43:25Z mjambon $ *)

(** Conversions between JSON and biniou *)

val biniou_of_json : Safe.json -> Bi_io.tree
  (** Converts from JSON to biniou.
      @raise Failure if conversion is not reversible. *)

val json_of_biniou : Bi_io.tree -> Safe.json
  (** Converts from biniou to JSON.
      @raise Failure if conversion is not reversible, except for biniou
      tables which are considered equivalent to arrays of records. *)
