// file      : morphing/anonymous/processor.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef MORPHING_ANONYMOUS_PROCESSOR_HXX
#define MORPHING_ANONYMOUS_PROCESSOR_HXX

#include <cult/types.hxx>

#include <cult/containers/vector.hxx>

#include <cult/cli/options.hxx>
#include <cult/cli/options-spec.hxx>

#include <xsd-frontend/semantic-graph/elements.hxx> // Path
#include <xsd-frontend/semantic-graph/schema.hxx>

namespace Morphing
{
  namespace Anonymous
  {
    using namespace Cult::Types;

    namespace CLI
    {
      typedef Char const Key[];

      extern Key preserve_anonymous;
      extern Key anonymous_regex;
      extern Key anonymous_regex_trace;

      typedef Cult::CLI::Options<

        preserve_anonymous,    Boolean,
        anonymous_regex,       Cult::Containers::Vector<String>,
        anonymous_regex_trace, Boolean

        > Options;

      struct OptionsSpec: Cult::CLI::OptionsSpec<Options> {};
    }

    class Processor
    {
    public:
      static Void
      usage ();

      static CLI::OptionsSpec
      options_spec ();

      struct Failed {};

      Void
      morph (CLI::Options const& options,
             XSDFrontend::SemanticGraph::Schema&,
             XSDFrontend::SemanticGraph::Path const& file);
    };
  }
}

#endif // MORPHING_ANONYMOUS_PROCESSOR_HXX
