/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/pim_xif.cc,v 1.46 2009/01/05 18:31:13 jtc Exp $"

#include "pim_xif.hh"

bool
XrlPimV0p1Client::send_enable_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const bool&	enable,
	const EnableVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/enable_vif");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, enable);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_enable_vif, cb));
}


/* Unmarshall enable_vif */
void
XrlPimV0p1Client::unmarshall_enable_vif(
	const XrlError&	e,
	XrlArgs*	a,
	EnableVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_start_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const StartVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/start_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_start_vif, cb));
}


/* Unmarshall start_vif */
void
XrlPimV0p1Client::unmarshall_start_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StartVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_stop_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const StopVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/stop_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_stop_vif, cb));
}


/* Unmarshall stop_vif */
void
XrlPimV0p1Client::unmarshall_stop_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StopVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_enable_all_vifs(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const EnableAllVifsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/enable_all_vifs");
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enable);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_enable_all_vifs, cb));
}


/* Unmarshall enable_all_vifs */
void
XrlPimV0p1Client::unmarshall_enable_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	EnableAllVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_start_all_vifs(
	const char*	dst_xrl_target_name,
	const StartAllVifsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/start_all_vifs");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_start_all_vifs, cb));
}


/* Unmarshall start_all_vifs */
void
XrlPimV0p1Client::unmarshall_start_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StartAllVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_stop_all_vifs(
	const char*	dst_xrl_target_name,
	const StopAllVifsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/stop_all_vifs");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_stop_all_vifs, cb));
}


/* Unmarshall stop_all_vifs */
void
XrlPimV0p1Client::unmarshall_stop_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StopAllVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_enable_pim(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const EnablePimCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/enable_pim");
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enable);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_enable_pim, cb));
}


/* Unmarshall enable_pim */
void
XrlPimV0p1Client::unmarshall_enable_pim(
	const XrlError&	e,
	XrlArgs*	a,
	EnablePimCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_start_pim(
	const char*	dst_xrl_target_name,
	const StartPimCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/start_pim");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_start_pim, cb));
}


/* Unmarshall start_pim */
void
XrlPimV0p1Client::unmarshall_start_pim(
	const XrlError&	e,
	XrlArgs*	a,
	StartPimCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_stop_pim(
	const char*	dst_xrl_target_name,
	const StopPimCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/stop_pim");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_stop_pim, cb));
}


/* Unmarshall stop_pim */
void
XrlPimV0p1Client::unmarshall_stop_pim(
	const XrlError&	e,
	XrlArgs*	a,
	StopPimCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_enable_cli(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const EnableCliCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/enable_cli");
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enable);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_enable_cli, cb));
}


/* Unmarshall enable_cli */
void
XrlPimV0p1Client::unmarshall_enable_cli(
	const XrlError&	e,
	XrlArgs*	a,
	EnableCliCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_start_cli(
	const char*	dst_xrl_target_name,
	const StartCliCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/start_cli");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_start_cli, cb));
}


/* Unmarshall start_cli */
void
XrlPimV0p1Client::unmarshall_start_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StartCliCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_stop_cli(
	const char*	dst_xrl_target_name,
	const StopCliCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/stop_cli");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_stop_cli, cb));
}


/* Unmarshall stop_cli */
void
XrlPimV0p1Client::unmarshall_stop_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StopCliCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_enable_bsr(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const EnableBsrCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/enable_bsr");
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enable);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_enable_bsr, cb));
}


/* Unmarshall enable_bsr */
void
XrlPimV0p1Client::unmarshall_enable_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	EnableBsrCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_start_bsr(
	const char*	dst_xrl_target_name,
	const StartBsrCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/start_bsr");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_start_bsr, cb));
}


/* Unmarshall start_bsr */
void
XrlPimV0p1Client::unmarshall_start_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	StartBsrCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_stop_bsr(
	const char*	dst_xrl_target_name,
	const StopBsrCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/stop_bsr");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_stop_bsr, cb));
}


/* Unmarshall stop_bsr */
void
XrlPimV0p1Client::unmarshall_stop_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	StopBsrCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_scope_zone_by_vif_name4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	scope_zone_id,
	const string&	vif_name,
	const AddConfigScopeZoneByVifName4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_scope_zone_by_vif_name4");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_name4, cb));
}


/* Unmarshall add_config_scope_zone_by_vif_name4 */
void
XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifName4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_scope_zone_by_vif_name6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	scope_zone_id,
	const string&	vif_name,
	const AddConfigScopeZoneByVifName6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_scope_zone_by_vif_name6");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_name6, cb));
}


/* Unmarshall add_config_scope_zone_by_vif_name6 */
void
XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifName6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_scope_zone_by_vif_addr4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	scope_zone_id,
	const IPv4&	vif_addr,
	const AddConfigScopeZoneByVifAddr4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_scope_zone_by_vif_addr4");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_addr4, cb));
}


/* Unmarshall add_config_scope_zone_by_vif_addr4 */
void
XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifAddr4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_scope_zone_by_vif_addr6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	scope_zone_id,
	const IPv6&	vif_addr,
	const AddConfigScopeZoneByVifAddr6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_scope_zone_by_vif_addr6");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_addr6, cb));
}


/* Unmarshall add_config_scope_zone_by_vif_addr6 */
void
XrlPimV0p1Client::unmarshall_add_config_scope_zone_by_vif_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifAddr6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_scope_zone_by_vif_name4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	scope_zone_id,
	const string&	vif_name,
	const DeleteConfigScopeZoneByVifName4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_scope_zone_by_vif_name4");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_name4, cb));
}


/* Unmarshall delete_config_scope_zone_by_vif_name4 */
void
XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifName4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_scope_zone_by_vif_name6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	scope_zone_id,
	const string&	vif_name,
	const DeleteConfigScopeZoneByVifName6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_scope_zone_by_vif_name6");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_name6, cb));
}


/* Unmarshall delete_config_scope_zone_by_vif_name6 */
void
XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifName6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_scope_zone_by_vif_addr4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	scope_zone_id,
	const IPv4&	vif_addr,
	const DeleteConfigScopeZoneByVifAddr4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_scope_zone_by_vif_addr4");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_addr4, cb));
}


/* Unmarshall delete_config_scope_zone_by_vif_addr4 */
void
XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifAddr4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_scope_zone_by_vif_addr6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	scope_zone_id,
	const IPv6&	vif_addr,
	const DeleteConfigScopeZoneByVifAddr6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_scope_zone_by_vif_addr6");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(vif_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, vif_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_addr6, cb));
}


/* Unmarshall delete_config_scope_zone_by_vif_addr6 */
void
XrlPimV0p1Client::unmarshall_delete_config_scope_zone_by_vif_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifAddr6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_cand_bsr4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const IPv4&	vif_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigCandBsr4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_cand_bsr4");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(vif_addr));
        x->args().add(XrlAtom(bsr_priority));
        x->args().add(XrlAtom(hash_mask_len));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, is_scope_zone);
    x->args().set_arg(2, vif_name);
    x->args().set_arg(3, vif_addr);
    x->args().set_arg(4, bsr_priority);
    x->args().set_arg(5, hash_mask_len);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_cand_bsr4, cb));
}


/* Unmarshall add_config_cand_bsr4 */
void
XrlPimV0p1Client::unmarshall_add_config_cand_bsr4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandBsr4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_cand_bsr6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const IPv6&	vif_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigCandBsr6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_cand_bsr6");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(vif_addr));
        x->args().add(XrlAtom(bsr_priority));
        x->args().add(XrlAtom(hash_mask_len));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, is_scope_zone);
    x->args().set_arg(2, vif_name);
    x->args().set_arg(3, vif_addr);
    x->args().set_arg(4, bsr_priority);
    x->args().set_arg(5, hash_mask_len);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_cand_bsr6, cb));
}


/* Unmarshall add_config_cand_bsr6 */
void
XrlPimV0p1Client::unmarshall_add_config_cand_bsr6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandBsr6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_cand_bsr4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const DeleteConfigCandBsr4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_cand_bsr4");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(is_scope_zone));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, is_scope_zone);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_cand_bsr4, cb));
}


/* Unmarshall delete_config_cand_bsr4 */
void
XrlPimV0p1Client::unmarshall_delete_config_cand_bsr4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandBsr4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_cand_bsr6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const DeleteConfigCandBsr6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_cand_bsr6");
        x->args().add(XrlAtom(scope_zone_id));
        x->args().add(XrlAtom(is_scope_zone));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, scope_zone_id);
    x->args().set_arg(1, is_scope_zone);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_cand_bsr6, cb));
}


/* Unmarshall delete_config_cand_bsr6 */
void
XrlPimV0p1Client::unmarshall_delete_config_cand_bsr6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandBsr6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_cand_rp4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const IPv4&	vif_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddConfigCandRp4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_cand_rp4");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(vif_addr));
        x->args().add(XrlAtom(rp_priority));
        x->args().add(XrlAtom(rp_holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, is_scope_zone);
    x->args().set_arg(2, vif_name);
    x->args().set_arg(3, vif_addr);
    x->args().set_arg(4, rp_priority);
    x->args().set_arg(5, rp_holdtime);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_cand_rp4, cb));
}


/* Unmarshall add_config_cand_rp4 */
void
XrlPimV0p1Client::unmarshall_add_config_cand_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandRp4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_cand_rp6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const IPv6&	vif_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddConfigCandRp6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_cand_rp6");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(vif_addr));
        x->args().add(XrlAtom(rp_priority));
        x->args().add(XrlAtom(rp_holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, is_scope_zone);
    x->args().set_arg(2, vif_name);
    x->args().set_arg(3, vif_addr);
    x->args().set_arg(4, rp_priority);
    x->args().set_arg(5, rp_holdtime);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_cand_rp6, cb));
}


/* Unmarshall add_config_cand_rp6 */
void
XrlPimV0p1Client::unmarshall_add_config_cand_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandRp6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_cand_rp4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const IPv4&	vif_addr,
	const DeleteConfigCandRp4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_cand_rp4");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(vif_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, is_scope_zone);
    x->args().set_arg(2, vif_name);
    x->args().set_arg(3, vif_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_cand_rp4, cb));
}


/* Unmarshall delete_config_cand_rp4 */
void
XrlPimV0p1Client::unmarshall_delete_config_cand_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandRp4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_cand_rp6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const IPv6&	vif_addr,
	const DeleteConfigCandRp6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_cand_rp6");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(vif_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, is_scope_zone);
    x->args().set_arg(2, vif_name);
    x->args().set_arg(3, vif_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_cand_rp6, cb));
}


/* Unmarshall delete_config_cand_rp6 */
void
XrlPimV0p1Client::unmarshall_delete_config_cand_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandRp6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_static_rp4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigStaticRp4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_static_rp4");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(rp_addr));
        x->args().add(XrlAtom(rp_priority));
        x->args().add(XrlAtom(hash_mask_len));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, rp_addr);
    x->args().set_arg(2, rp_priority);
    x->args().set_arg(3, hash_mask_len);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_static_rp4, cb));
}


/* Unmarshall add_config_static_rp4 */
void
XrlPimV0p1Client::unmarshall_add_config_static_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigStaticRp4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_config_static_rp6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigStaticRp6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_config_static_rp6");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(rp_addr));
        x->args().add(XrlAtom(rp_priority));
        x->args().add(XrlAtom(hash_mask_len));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, rp_addr);
    x->args().set_arg(2, rp_priority);
    x->args().set_arg(3, hash_mask_len);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_config_static_rp6, cb));
}


/* Unmarshall add_config_static_rp6 */
void
XrlPimV0p1Client::unmarshall_add_config_static_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigStaticRp6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_static_rp4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const DeleteConfigStaticRp4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_static_rp4");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(rp_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, rp_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_static_rp4, cb));
}


/* Unmarshall delete_config_static_rp4 */
void
XrlPimV0p1Client::unmarshall_delete_config_static_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigStaticRp4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_static_rp6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const DeleteConfigStaticRp6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_static_rp6");
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(rp_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, group_prefix);
    x->args().set_arg(1, rp_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_static_rp6, cb));
}


/* Unmarshall delete_config_static_rp6 */
void
XrlPimV0p1Client::unmarshall_delete_config_static_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigStaticRp6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_all_static_group_prefixes_rp4(
	const char*	dst_xrl_target_name,
	const IPv4&	rp_addr,
	const DeleteConfigAllStaticGroupPrefixesRp4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_all_static_group_prefixes_rp4");
        x->args().add(XrlAtom(rp_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, rp_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_all_static_group_prefixes_rp4, cb));
}


/* Unmarshall delete_config_all_static_group_prefixes_rp4 */
void
XrlPimV0p1Client::unmarshall_delete_config_all_static_group_prefixes_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigAllStaticGroupPrefixesRp4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_all_static_group_prefixes_rp6(
	const char*	dst_xrl_target_name,
	const IPv6&	rp_addr,
	const DeleteConfigAllStaticGroupPrefixesRp6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_all_static_group_prefixes_rp6");
        x->args().add(XrlAtom(rp_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, rp_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_all_static_group_prefixes_rp6, cb));
}


/* Unmarshall delete_config_all_static_group_prefixes_rp6 */
void
XrlPimV0p1Client::unmarshall_delete_config_all_static_group_prefixes_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigAllStaticGroupPrefixesRp6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_config_all_static_rps(
	const char*	dst_xrl_target_name,
	const DeleteConfigAllStaticRpsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_config_all_static_rps");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_config_all_static_rps, cb));
}


/* Unmarshall delete_config_all_static_rps */
void
XrlPimV0p1Client::unmarshall_delete_config_all_static_rps(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigAllStaticRpsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_config_static_rp_done(
	const char*	dst_xrl_target_name,
	const ConfigStaticRpDoneCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/config_static_rp_done");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_config_static_rp_done, cb));
}


/* Unmarshall config_static_rp_done */
void
XrlPimV0p1Client::unmarshall_config_static_rp_done(
	const XrlError&	e,
	XrlArgs*	a,
	ConfigStaticRpDoneCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_proto_version(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifProtoVersionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_proto_version");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_proto_version, cb));
}


/* Unmarshall get_vif_proto_version */
void
XrlPimV0p1Client::unmarshall_get_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifProtoVersionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t proto_version;
    try {
	a->get("proto_version", proto_version);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &proto_version);
}

bool
XrlPimV0p1Client::send_set_vif_proto_version(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	proto_version,
	const SetVifProtoVersionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_proto_version");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(proto_version));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, proto_version);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_proto_version, cb));
}


/* Unmarshall set_vif_proto_version */
void
XrlPimV0p1Client::unmarshall_set_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifProtoVersionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_proto_version(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifProtoVersionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_proto_version");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_proto_version, cb));
}


/* Unmarshall reset_vif_proto_version */
void
XrlPimV0p1Client::unmarshall_reset_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifProtoVersionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_hello_triggered_delay(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifHelloTriggeredDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_hello_triggered_delay");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_hello_triggered_delay, cb));
}


/* Unmarshall get_vif_hello_triggered_delay */
void
XrlPimV0p1Client::unmarshall_get_vif_hello_triggered_delay(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifHelloTriggeredDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t hello_triggered_delay;
    try {
	a->get("hello_triggered_delay", hello_triggered_delay);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &hello_triggered_delay);
}

bool
XrlPimV0p1Client::send_set_vif_hello_triggered_delay(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	hello_triggered_delay,
	const SetVifHelloTriggeredDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_hello_triggered_delay");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(hello_triggered_delay));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, hello_triggered_delay);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_hello_triggered_delay, cb));
}


/* Unmarshall set_vif_hello_triggered_delay */
void
XrlPimV0p1Client::unmarshall_set_vif_hello_triggered_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifHelloTriggeredDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_hello_triggered_delay(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifHelloTriggeredDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_hello_triggered_delay");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_hello_triggered_delay, cb));
}


/* Unmarshall reset_vif_hello_triggered_delay */
void
XrlPimV0p1Client::unmarshall_reset_vif_hello_triggered_delay(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifHelloTriggeredDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_hello_period(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifHelloPeriodCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_hello_period");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_hello_period, cb));
}


/* Unmarshall get_vif_hello_period */
void
XrlPimV0p1Client::unmarshall_get_vif_hello_period(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifHelloPeriodCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t hello_period;
    try {
	a->get("hello_period", hello_period);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &hello_period);
}

bool
XrlPimV0p1Client::send_set_vif_hello_period(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	hello_period,
	const SetVifHelloPeriodCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_hello_period");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(hello_period));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, hello_period);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_hello_period, cb));
}


/* Unmarshall set_vif_hello_period */
void
XrlPimV0p1Client::unmarshall_set_vif_hello_period(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifHelloPeriodCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_hello_period(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifHelloPeriodCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_hello_period");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_hello_period, cb));
}


/* Unmarshall reset_vif_hello_period */
void
XrlPimV0p1Client::unmarshall_reset_vif_hello_period(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifHelloPeriodCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_hello_holdtime(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifHelloHoldtimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_hello_holdtime");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_hello_holdtime, cb));
}


/* Unmarshall get_vif_hello_holdtime */
void
XrlPimV0p1Client::unmarshall_get_vif_hello_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifHelloHoldtimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t hello_holdtime;
    try {
	a->get("hello_holdtime", hello_holdtime);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &hello_holdtime);
}

bool
XrlPimV0p1Client::send_set_vif_hello_holdtime(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	hello_holdtime,
	const SetVifHelloHoldtimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_hello_holdtime");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(hello_holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, hello_holdtime);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_hello_holdtime, cb));
}


/* Unmarshall set_vif_hello_holdtime */
void
XrlPimV0p1Client::unmarshall_set_vif_hello_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifHelloHoldtimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_hello_holdtime(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifHelloHoldtimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_hello_holdtime");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_hello_holdtime, cb));
}


/* Unmarshall reset_vif_hello_holdtime */
void
XrlPimV0p1Client::unmarshall_reset_vif_hello_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifHelloHoldtimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_dr_priority(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifDrPriorityCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_dr_priority");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_dr_priority, cb));
}


/* Unmarshall get_vif_dr_priority */
void
XrlPimV0p1Client::unmarshall_get_vif_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifDrPriorityCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t dr_priority;
    try {
	a->get("dr_priority", dr_priority);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &dr_priority);
}

bool
XrlPimV0p1Client::send_set_vif_dr_priority(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	dr_priority,
	const SetVifDrPriorityCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_dr_priority");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(dr_priority));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, dr_priority);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_dr_priority, cb));
}


/* Unmarshall set_vif_dr_priority */
void
XrlPimV0p1Client::unmarshall_set_vif_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifDrPriorityCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_dr_priority(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifDrPriorityCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_dr_priority");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_dr_priority, cb));
}


/* Unmarshall reset_vif_dr_priority */
void
XrlPimV0p1Client::unmarshall_reset_vif_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifDrPriorityCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_propagation_delay(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifPropagationDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_propagation_delay");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_propagation_delay, cb));
}


/* Unmarshall get_vif_propagation_delay */
void
XrlPimV0p1Client::unmarshall_get_vif_propagation_delay(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifPropagationDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t propagation_delay;
    try {
	a->get("propagation_delay", propagation_delay);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &propagation_delay);
}

bool
XrlPimV0p1Client::send_set_vif_propagation_delay(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	propagation_delay,
	const SetVifPropagationDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_propagation_delay");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(propagation_delay));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, propagation_delay);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_propagation_delay, cb));
}


/* Unmarshall set_vif_propagation_delay */
void
XrlPimV0p1Client::unmarshall_set_vif_propagation_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifPropagationDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_propagation_delay(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifPropagationDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_propagation_delay");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_propagation_delay, cb));
}


/* Unmarshall reset_vif_propagation_delay */
void
XrlPimV0p1Client::unmarshall_reset_vif_propagation_delay(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifPropagationDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_override_interval(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifOverrideIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_override_interval");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_override_interval, cb));
}


/* Unmarshall get_vif_override_interval */
void
XrlPimV0p1Client::unmarshall_get_vif_override_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifOverrideIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t override_interval;
    try {
	a->get("override_interval", override_interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &override_interval);
}

bool
XrlPimV0p1Client::send_set_vif_override_interval(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	override_interval,
	const SetVifOverrideIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_override_interval");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(override_interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, override_interval);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_override_interval, cb));
}


/* Unmarshall set_vif_override_interval */
void
XrlPimV0p1Client::unmarshall_set_vif_override_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifOverrideIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_override_interval(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifOverrideIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_override_interval");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_override_interval, cb));
}


/* Unmarshall reset_vif_override_interval */
void
XrlPimV0p1Client::unmarshall_reset_vif_override_interval(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifOverrideIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_is_tracking_support_disabled(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifIsTrackingSupportDisabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_is_tracking_support_disabled");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_is_tracking_support_disabled, cb));
}


/* Unmarshall get_vif_is_tracking_support_disabled */
void
XrlPimV0p1Client::unmarshall_get_vif_is_tracking_support_disabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifIsTrackingSupportDisabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool is_tracking_support_disabled;
    try {
	a->get("is_tracking_support_disabled", is_tracking_support_disabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &is_tracking_support_disabled);
}

bool
XrlPimV0p1Client::send_set_vif_is_tracking_support_disabled(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const bool&	is_tracking_support_disabled,
	const SetVifIsTrackingSupportDisabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_is_tracking_support_disabled");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(is_tracking_support_disabled));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, is_tracking_support_disabled);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_is_tracking_support_disabled, cb));
}


/* Unmarshall set_vif_is_tracking_support_disabled */
void
XrlPimV0p1Client::unmarshall_set_vif_is_tracking_support_disabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifIsTrackingSupportDisabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_is_tracking_support_disabled(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifIsTrackingSupportDisabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_is_tracking_support_disabled");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_is_tracking_support_disabled, cb));
}


/* Unmarshall reset_vif_is_tracking_support_disabled */
void
XrlPimV0p1Client::unmarshall_reset_vif_is_tracking_support_disabled(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifIsTrackingSupportDisabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_accept_nohello_neighbors(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifAcceptNohelloNeighborsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_accept_nohello_neighbors");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_accept_nohello_neighbors, cb));
}


/* Unmarshall get_vif_accept_nohello_neighbors */
void
XrlPimV0p1Client::unmarshall_get_vif_accept_nohello_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifAcceptNohelloNeighborsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool accept_nohello_neighbors;
    try {
	a->get("accept_nohello_neighbors", accept_nohello_neighbors);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &accept_nohello_neighbors);
}

bool
XrlPimV0p1Client::send_set_vif_accept_nohello_neighbors(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const bool&	accept_nohello_neighbors,
	const SetVifAcceptNohelloNeighborsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_accept_nohello_neighbors");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(accept_nohello_neighbors));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, accept_nohello_neighbors);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_accept_nohello_neighbors, cb));
}


/* Unmarshall set_vif_accept_nohello_neighbors */
void
XrlPimV0p1Client::unmarshall_set_vif_accept_nohello_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifAcceptNohelloNeighborsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_accept_nohello_neighbors(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifAcceptNohelloNeighborsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_accept_nohello_neighbors");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_accept_nohello_neighbors, cb));
}


/* Unmarshall reset_vif_accept_nohello_neighbors */
void
XrlPimV0p1Client::unmarshall_reset_vif_accept_nohello_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifAcceptNohelloNeighborsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_vif_join_prune_period(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const GetVifJoinPrunePeriodCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_vif_join_prune_period");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_vif_join_prune_period, cb));
}


/* Unmarshall get_vif_join_prune_period */
void
XrlPimV0p1Client::unmarshall_get_vif_join_prune_period(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifJoinPrunePeriodCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t join_prune_period;
    try {
	a->get("join_prune_period", join_prune_period);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &join_prune_period);
}

bool
XrlPimV0p1Client::send_set_vif_join_prune_period(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const uint32_t&	join_prune_period,
	const SetVifJoinPrunePeriodCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_vif_join_prune_period");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(join_prune_period));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, join_prune_period);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_vif_join_prune_period, cb));
}


/* Unmarshall set_vif_join_prune_period */
void
XrlPimV0p1Client::unmarshall_set_vif_join_prune_period(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifJoinPrunePeriodCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_vif_join_prune_period(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ResetVifJoinPrunePeriodCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_vif_join_prune_period");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_vif_join_prune_period, cb));
}


/* Unmarshall reset_vif_join_prune_period */
void
XrlPimV0p1Client::unmarshall_reset_vif_join_prune_period(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifJoinPrunePeriodCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_get_switch_to_spt_threshold(
	const char*	dst_xrl_target_name,
	const GetSwitchToSptThresholdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/get_switch_to_spt_threshold");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_get_switch_to_spt_threshold, cb));
}


/* Unmarshall get_switch_to_spt_threshold */
void
XrlPimV0p1Client::unmarshall_get_switch_to_spt_threshold(
	const XrlError&	e,
	XrlArgs*	a,
	GetSwitchToSptThresholdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0);
	return;
    } else if (a && a->size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(3));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    bool is_enabled;
    uint32_t interval_sec;
    uint32_t bytes;
    try {
	a->get("is_enabled", is_enabled);
	a->get("interval_sec", interval_sec);
	a->get("bytes", bytes);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    cb->dispatch(e, &is_enabled, &interval_sec, &bytes);
}

bool
XrlPimV0p1Client::send_set_switch_to_spt_threshold(
	const char*	dst_xrl_target_name,
	const bool&	is_enabled,
	const uint32_t&	interval_sec,
	const uint32_t&	bytes,
	const SetSwitchToSptThresholdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/set_switch_to_spt_threshold");
        x->args().add(XrlAtom(is_enabled));
        x->args().add(XrlAtom(interval_sec));
        x->args().add(XrlAtom(bytes));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, is_enabled);
    x->args().set_arg(1, interval_sec);
    x->args().set_arg(2, bytes);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_set_switch_to_spt_threshold, cb));
}


/* Unmarshall set_switch_to_spt_threshold */
void
XrlPimV0p1Client::unmarshall_set_switch_to_spt_threshold(
	const XrlError&	e,
	XrlArgs*	a,
	SetSwitchToSptThresholdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_reset_switch_to_spt_threshold(
	const char*	dst_xrl_target_name,
	const ResetSwitchToSptThresholdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/reset_switch_to_spt_threshold");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_reset_switch_to_spt_threshold, cb));
}


/* Unmarshall reset_switch_to_spt_threshold */
void
XrlPimV0p1Client::unmarshall_reset_switch_to_spt_threshold(
	const XrlError&	e,
	XrlArgs*	a,
	ResetSwitchToSptThresholdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_alternative_subnet4(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv4Net&	subnet,
	const AddAlternativeSubnet4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_alternative_subnet4");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(subnet));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, subnet);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_alternative_subnet4, cb));
}


/* Unmarshall add_alternative_subnet4 */
void
XrlPimV0p1Client::unmarshall_add_alternative_subnet4(
	const XrlError&	e,
	XrlArgs*	a,
	AddAlternativeSubnet4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_alternative_subnet6(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv6Net&	subnet,
	const AddAlternativeSubnet6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_alternative_subnet6");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(subnet));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, subnet);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_alternative_subnet6, cb));
}


/* Unmarshall add_alternative_subnet6 */
void
XrlPimV0p1Client::unmarshall_add_alternative_subnet6(
	const XrlError&	e,
	XrlArgs*	a,
	AddAlternativeSubnet6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_alternative_subnet4(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv4Net&	subnet,
	const DeleteAlternativeSubnet4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_alternative_subnet4");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(subnet));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, subnet);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_alternative_subnet4, cb));
}


/* Unmarshall delete_alternative_subnet4 */
void
XrlPimV0p1Client::unmarshall_delete_alternative_subnet4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAlternativeSubnet4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_delete_alternative_subnet6(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv6Net&	subnet,
	const DeleteAlternativeSubnet6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/delete_alternative_subnet6");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(subnet));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, subnet);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_delete_alternative_subnet6, cb));
}


/* Unmarshall delete_alternative_subnet6 */
void
XrlPimV0p1Client::unmarshall_delete_alternative_subnet6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAlternativeSubnet6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_remove_all_alternative_subnets(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const RemoveAllAlternativeSubnetsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/remove_all_alternative_subnets");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_remove_all_alternative_subnets, cb));
}


/* Unmarshall remove_all_alternative_subnets */
void
XrlPimV0p1Client::unmarshall_remove_all_alternative_subnets(
	const XrlError&	e,
	XrlArgs*	a,
	RemoveAllAlternativeSubnetsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_log_trace_all(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const LogTraceAllCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/log_trace_all");
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enable);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_log_trace_all, cb));
}


/* Unmarshall log_trace_all */
void
XrlPimV0p1Client::unmarshall_log_trace_all(
	const XrlError&	e,
	XrlArgs*	a,
	LogTraceAllCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_jp_entry4(
	const char*	dst_xrl_target_name,
	const IPv4&	source_addr,
	const IPv4&	group_addr,
	const uint32_t&	group_mask_len,
	const string&	mrt_entry_type,
	const string&	action_jp,
	const uint32_t&	holdtime,
	const bool&	is_new_group,
	const AddTestJpEntry4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_jp_entry4");
        x->args().add(XrlAtom(source_addr));
        x->args().add(XrlAtom(group_addr));
        x->args().add(XrlAtom(group_mask_len));
        x->args().add(XrlAtom(mrt_entry_type));
        x->args().add(XrlAtom(action_jp));
        x->args().add(XrlAtom(holdtime));
        x->args().add(XrlAtom(is_new_group));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, source_addr);
    x->args().set_arg(1, group_addr);
    x->args().set_arg(2, group_mask_len);
    x->args().set_arg(3, mrt_entry_type);
    x->args().set_arg(4, action_jp);
    x->args().set_arg(5, holdtime);
    x->args().set_arg(6, is_new_group);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_jp_entry4, cb));
}


/* Unmarshall add_test_jp_entry4 */
void
XrlPimV0p1Client::unmarshall_add_test_jp_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestJpEntry4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_jp_entry6(
	const char*	dst_xrl_target_name,
	const IPv6&	source_addr,
	const IPv6&	group_addr,
	const uint32_t&	group_mask_len,
	const string&	mrt_entry_type,
	const string&	action_jp,
	const uint32_t&	holdtime,
	const bool&	is_new_group,
	const AddTestJpEntry6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_jp_entry6");
        x->args().add(XrlAtom(source_addr));
        x->args().add(XrlAtom(group_addr));
        x->args().add(XrlAtom(group_mask_len));
        x->args().add(XrlAtom(mrt_entry_type));
        x->args().add(XrlAtom(action_jp));
        x->args().add(XrlAtom(holdtime));
        x->args().add(XrlAtom(is_new_group));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, source_addr);
    x->args().set_arg(1, group_addr);
    x->args().set_arg(2, group_mask_len);
    x->args().set_arg(3, mrt_entry_type);
    x->args().set_arg(4, action_jp);
    x->args().set_arg(5, holdtime);
    x->args().set_arg(6, is_new_group);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_jp_entry6, cb));
}


/* Unmarshall add_test_jp_entry6 */
void
XrlPimV0p1Client::unmarshall_add_test_jp_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestJpEntry6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_jp_entry4(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv4&	nbr_addr,
	const SendTestJpEntry4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_jp_entry4");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(nbr_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, nbr_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_jp_entry4, cb));
}


/* Unmarshall send_test_jp_entry4 */
void
XrlPimV0p1Client::unmarshall_send_test_jp_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestJpEntry4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_jp_entry6(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv6&	nbr_addr,
	const SendTestJpEntry6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_jp_entry6");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(nbr_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, nbr_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_jp_entry6, cb));
}


/* Unmarshall send_test_jp_entry6 */
void
XrlPimV0p1Client::unmarshall_send_test_jp_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestJpEntry6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_assert4(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv4&	source_addr,
	const IPv4&	group_addr,
	const bool&	rpt_bit,
	const uint32_t&	metric_preference,
	const uint32_t&	metric,
	const SendTestAssert4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_assert4");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(source_addr));
        x->args().add(XrlAtom(group_addr));
        x->args().add(XrlAtom(rpt_bit));
        x->args().add(XrlAtom(metric_preference));
        x->args().add(XrlAtom(metric));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, source_addr);
    x->args().set_arg(2, group_addr);
    x->args().set_arg(3, rpt_bit);
    x->args().set_arg(4, metric_preference);
    x->args().set_arg(5, metric);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_assert4, cb));
}


/* Unmarshall send_test_assert4 */
void
XrlPimV0p1Client::unmarshall_send_test_assert4(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestAssert4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_assert6(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv6&	source_addr,
	const IPv6&	group_addr,
	const bool&	rpt_bit,
	const uint32_t&	metric_preference,
	const uint32_t&	metric,
	const SendTestAssert6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_assert6");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(source_addr));
        x->args().add(XrlAtom(group_addr));
        x->args().add(XrlAtom(rpt_bit));
        x->args().add(XrlAtom(metric_preference));
        x->args().add(XrlAtom(metric));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, source_addr);
    x->args().set_arg(2, group_addr);
    x->args().set_arg(3, rpt_bit);
    x->args().set_arg(4, metric_preference);
    x->args().set_arg(5, metric);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_assert6, cb));
}


/* Unmarshall send_test_assert6 */
void
XrlPimV0p1Client::unmarshall_send_test_assert6(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestAssert6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_bsr_zone4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4&	bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const uint32_t&	fragment_tag,
	const AddTestBsrZone4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_bsr_zone4");
        x->args().add(XrlAtom(zone_id_scope_zone_prefix));
        x->args().add(XrlAtom(zone_id_is_scope_zone));
        x->args().add(XrlAtom(bsr_addr));
        x->args().add(XrlAtom(bsr_priority));
        x->args().add(XrlAtom(hash_mask_len));
        x->args().add(XrlAtom(fragment_tag));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, zone_id_scope_zone_prefix);
    x->args().set_arg(1, zone_id_is_scope_zone);
    x->args().set_arg(2, bsr_addr);
    x->args().set_arg(3, bsr_priority);
    x->args().set_arg(4, hash_mask_len);
    x->args().set_arg(5, fragment_tag);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_bsr_zone4, cb));
}


/* Unmarshall add_test_bsr_zone4 */
void
XrlPimV0p1Client::unmarshall_add_test_bsr_zone4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrZone4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_bsr_zone6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6&	bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const uint32_t&	fragment_tag,
	const AddTestBsrZone6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_bsr_zone6");
        x->args().add(XrlAtom(zone_id_scope_zone_prefix));
        x->args().add(XrlAtom(zone_id_is_scope_zone));
        x->args().add(XrlAtom(bsr_addr));
        x->args().add(XrlAtom(bsr_priority));
        x->args().add(XrlAtom(hash_mask_len));
        x->args().add(XrlAtom(fragment_tag));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, zone_id_scope_zone_prefix);
    x->args().set_arg(1, zone_id_is_scope_zone);
    x->args().set_arg(2, bsr_addr);
    x->args().set_arg(3, bsr_priority);
    x->args().set_arg(4, hash_mask_len);
    x->args().set_arg(5, fragment_tag);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_bsr_zone6, cb));
}


/* Unmarshall add_test_bsr_zone6 */
void
XrlPimV0p1Client::unmarshall_add_test_bsr_zone6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrZone6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_bsr_group_prefix4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const uint32_t&	expected_rp_count,
	const AddTestBsrGroupPrefix4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_bsr_group_prefix4");
        x->args().add(XrlAtom(zone_id_scope_zone_prefix));
        x->args().add(XrlAtom(zone_id_is_scope_zone));
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(expected_rp_count));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, zone_id_scope_zone_prefix);
    x->args().set_arg(1, zone_id_is_scope_zone);
    x->args().set_arg(2, group_prefix);
    x->args().set_arg(3, is_scope_zone);
    x->args().set_arg(4, expected_rp_count);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_bsr_group_prefix4, cb));
}


/* Unmarshall add_test_bsr_group_prefix4 */
void
XrlPimV0p1Client::unmarshall_add_test_bsr_group_prefix4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrGroupPrefix4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_bsr_group_prefix6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const uint32_t&	expected_rp_count,
	const AddTestBsrGroupPrefix6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_bsr_group_prefix6");
        x->args().add(XrlAtom(zone_id_scope_zone_prefix));
        x->args().add(XrlAtom(zone_id_is_scope_zone));
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(is_scope_zone));
        x->args().add(XrlAtom(expected_rp_count));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, zone_id_scope_zone_prefix);
    x->args().set_arg(1, zone_id_is_scope_zone);
    x->args().set_arg(2, group_prefix);
    x->args().set_arg(3, is_scope_zone);
    x->args().set_arg(4, expected_rp_count);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_bsr_group_prefix6, cb));
}


/* Unmarshall add_test_bsr_group_prefix6 */
void
XrlPimV0p1Client::unmarshall_add_test_bsr_group_prefix6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrGroupPrefix6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_bsr_rp4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddTestBsrRp4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_bsr_rp4");
        x->args().add(XrlAtom(zone_id_scope_zone_prefix));
        x->args().add(XrlAtom(zone_id_is_scope_zone));
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(rp_addr));
        x->args().add(XrlAtom(rp_priority));
        x->args().add(XrlAtom(rp_holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, zone_id_scope_zone_prefix);
    x->args().set_arg(1, zone_id_is_scope_zone);
    x->args().set_arg(2, group_prefix);
    x->args().set_arg(3, rp_addr);
    x->args().set_arg(4, rp_priority);
    x->args().set_arg(5, rp_holdtime);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_bsr_rp4, cb));
}


/* Unmarshall add_test_bsr_rp4 */
void
XrlPimV0p1Client::unmarshall_add_test_bsr_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrRp4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_add_test_bsr_rp6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddTestBsrRp6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/add_test_bsr_rp6");
        x->args().add(XrlAtom(zone_id_scope_zone_prefix));
        x->args().add(XrlAtom(zone_id_is_scope_zone));
        x->args().add(XrlAtom(group_prefix));
        x->args().add(XrlAtom(rp_addr));
        x->args().add(XrlAtom(rp_priority));
        x->args().add(XrlAtom(rp_holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, zone_id_scope_zone_prefix);
    x->args().set_arg(1, zone_id_is_scope_zone);
    x->args().set_arg(2, group_prefix);
    x->args().set_arg(3, rp_addr);
    x->args().set_arg(4, rp_priority);
    x->args().set_arg(5, rp_holdtime);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_add_test_bsr_rp6, cb));
}


/* Unmarshall add_test_bsr_rp6 */
void
XrlPimV0p1Client::unmarshall_add_test_bsr_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrRp6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_bootstrap(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const SendTestBootstrapCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_bootstrap");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_bootstrap, cb));
}


/* Unmarshall send_test_bootstrap */
void
XrlPimV0p1Client::unmarshall_send_test_bootstrap(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestBootstrapCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_bootstrap_by_dest4(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv4&	dest_addr,
	const SendTestBootstrapByDest4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_bootstrap_by_dest4");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(dest_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, dest_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_bootstrap_by_dest4, cb));
}


/* Unmarshall send_test_bootstrap_by_dest4 */
void
XrlPimV0p1Client::unmarshall_send_test_bootstrap_by_dest4(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestBootstrapByDest4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_bootstrap_by_dest6(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const IPv6&	dest_addr,
	const SendTestBootstrapByDest6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_bootstrap_by_dest6");
        x->args().add(XrlAtom(vif_name));
        x->args().add(XrlAtom(dest_addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);
    x->args().set_arg(1, dest_addr);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_bootstrap_by_dest6, cb));
}


/* Unmarshall send_test_bootstrap_by_dest6 */
void
XrlPimV0p1Client::unmarshall_send_test_bootstrap_by_dest6(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestBootstrapByDest6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_send_test_cand_rp_adv(
	const char*	dst_xrl_target_name,
	const SendTestCandRpAdvCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/send_test_cand_rp_adv");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_send_test_cand_rp_adv, cb));
}


/* Unmarshall send_test_cand_rp_adv */
void
XrlPimV0p1Client::unmarshall_send_test_cand_rp_adv(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestCandRpAdvCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_pimstat_neighbors4(
	const char*	dst_xrl_target_name,
	const PimstatNeighbors4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_neighbors4");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_neighbors4, cb));
}


/* Unmarshall pimstat_neighbors4 */
void
XrlPimV0p1Client::unmarshall_pimstat_neighbors4(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighbors4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(8));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t nbrs_number;
    XrlAtomList vifs;
    XrlAtomList addresses;
    XrlAtomList pim_versions;
    XrlAtomList dr_priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList uptimes;
    try {
	a->get("nbrs_number", nbrs_number);
	a->get("vifs", vifs);
	a->get("addresses", addresses);
	a->get("pim_versions", pim_versions);
	a->get("dr_priorities", dr_priorities);
	a->get("holdtimes", holdtimes);
	a->get("timeouts", timeouts);
	a->get("uptimes", uptimes);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &nbrs_number, &vifs, &addresses, &pim_versions, &dr_priorities, &holdtimes, &timeouts, &uptimes);
}

bool
XrlPimV0p1Client::send_pimstat_neighbors6(
	const char*	dst_xrl_target_name,
	const PimstatNeighbors6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_neighbors6");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_neighbors6, cb));
}


/* Unmarshall pimstat_neighbors6 */
void
XrlPimV0p1Client::unmarshall_pimstat_neighbors6(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighbors6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(8));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t nbrs_number;
    XrlAtomList vifs;
    XrlAtomList addresses;
    XrlAtomList pim_versions;
    XrlAtomList dr_priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList uptimes;
    try {
	a->get("nbrs_number", nbrs_number);
	a->get("vifs", vifs);
	a->get("addresses", addresses);
	a->get("pim_versions", pim_versions);
	a->get("dr_priorities", dr_priorities);
	a->get("holdtimes", holdtimes);
	a->get("timeouts", timeouts);
	a->get("uptimes", uptimes);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &nbrs_number, &vifs, &addresses, &pim_versions, &dr_priorities, &holdtimes, &timeouts, &uptimes);
}

bool
XrlPimV0p1Client::send_pimstat_interface4(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatInterface4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_interface4");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_interface4, cb));
}


/* Unmarshall pimstat_interface4 */
void
XrlPimV0p1Client::unmarshall_pimstat_interface4(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatInterface4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    uint32_t pim_version;
    bool is_dr;
    uint32_t dr_priority;
    IPv4 dr_address;
    uint32_t pim_nbrs_number;
    try {
	a->get("pim_version", pim_version);
	a->get("is_dr", is_dr);
	a->get("dr_priority", dr_priority);
	a->get("dr_address", dr_address);
	a->get("pim_nbrs_number", pim_nbrs_number);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &pim_version, &is_dr, &dr_priority, &dr_address, &pim_nbrs_number);
}

bool
XrlPimV0p1Client::send_pimstat_interface6(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatInterface6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_interface6");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_interface6, cb));
}


/* Unmarshall pimstat_interface6 */
void
XrlPimV0p1Client::unmarshall_pimstat_interface6(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatInterface6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    uint32_t pim_version;
    bool is_dr;
    uint32_t dr_priority;
    IPv6 dr_address;
    uint32_t pim_nbrs_number;
    try {
	a->get("pim_version", pim_version);
	a->get("is_dr", is_dr);
	a->get("dr_priority", dr_priority);
	a->get("dr_address", dr_address);
	a->get("pim_nbrs_number", pim_nbrs_number);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &pim_version, &is_dr, &dr_priority, &dr_address, &pim_nbrs_number);
}

bool
XrlPimV0p1Client::send_pimstat_rps4(
	const char*	dst_xrl_target_name,
	const PimstatRps4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rps4");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rps4, cb));
}


/* Unmarshall pimstat_rps4 */
void
XrlPimV0p1Client::unmarshall_pimstat_rps4(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRps4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(7));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t rps_number;
    XrlAtomList addresses;
    XrlAtomList types;
    XrlAtomList priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList group_prefixes;
    try {
	a->get("rps_number", rps_number);
	a->get("addresses", addresses);
	a->get("types", types);
	a->get("priorities", priorities);
	a->get("holdtimes", holdtimes);
	a->get("timeouts", timeouts);
	a->get("group_prefixes", group_prefixes);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &rps_number, &addresses, &types, &priorities, &holdtimes, &timeouts, &group_prefixes);
}

bool
XrlPimV0p1Client::send_pimstat_rps6(
	const char*	dst_xrl_target_name,
	const PimstatRps6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rps6");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rps6, cb));
}


/* Unmarshall pimstat_rps6 */
void
XrlPimV0p1Client::unmarshall_pimstat_rps6(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRps6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(7));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t rps_number;
    XrlAtomList addresses;
    XrlAtomList types;
    XrlAtomList priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList group_prefixes;
    try {
	a->get("rps_number", rps_number);
	a->get("addresses", addresses);
	a->get("types", types);
	a->get("priorities", priorities);
	a->get("holdtimes", holdtimes);
	a->get("timeouts", timeouts);
	a->get("group_prefixes", group_prefixes);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &rps_number, &addresses, &types, &priorities, &holdtimes, &timeouts, &group_prefixes);
}

bool
XrlPimV0p1Client::send_clear_pim_statistics(
	const char*	dst_xrl_target_name,
	const ClearPimStatisticsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/clear_pim_statistics");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_clear_pim_statistics, cb));
}


/* Unmarshall clear_pim_statistics */
void
XrlPimV0p1Client::unmarshall_clear_pim_statistics(
	const XrlError&	e,
	XrlArgs*	a,
	ClearPimStatisticsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_clear_pim_statistics_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const ClearPimStatisticsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/clear_pim_statistics_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_clear_pim_statistics_per_vif, cb));
}


/* Unmarshall clear_pim_statistics_per_vif */
void
XrlPimV0p1Client::unmarshall_clear_pim_statistics_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	ClearPimStatisticsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlPimV0p1Client::send_pimstat_hello_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatHelloMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_hello_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_hello_messages_received, cb));
}


/* Unmarshall pimstat_hello_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_hello_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_hello_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatHelloMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_hello_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_hello_messages_sent, cb));
}


/* Unmarshall pimstat_hello_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_hello_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_hello_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatHelloMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_hello_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_hello_messages_rx_errors, cb));
}


/* Unmarshall pimstat_hello_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_hello_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatRegisterMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_messages_received, cb));
}


/* Unmarshall pimstat_register_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_register_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatRegisterMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_messages_sent, cb));
}


/* Unmarshall pimstat_register_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_register_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatRegisterMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_messages_rx_errors, cb));
}


/* Unmarshall pimstat_register_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_register_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_stop_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatRegisterStopMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_stop_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_received, cb));
}


/* Unmarshall pimstat_register_stop_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_stop_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatRegisterStopMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_stop_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_sent, cb));
}


/* Unmarshall pimstat_register_stop_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_stop_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatRegisterStopMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_stop_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_rx_errors, cb));
}


/* Unmarshall pimstat_register_stop_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_join_prune_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatJoinPruneMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_join_prune_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_received, cb));
}


/* Unmarshall pimstat_join_prune_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_join_prune_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatJoinPruneMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_join_prune_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_sent, cb));
}


/* Unmarshall pimstat_join_prune_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_join_prune_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatJoinPruneMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_join_prune_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_rx_errors, cb));
}


/* Unmarshall pimstat_join_prune_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bootstrap_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatBootstrapMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bootstrap_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_received, cb));
}


/* Unmarshall pimstat_bootstrap_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bootstrap_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatBootstrapMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bootstrap_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_sent, cb));
}


/* Unmarshall pimstat_bootstrap_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bootstrap_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatBootstrapMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bootstrap_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_rx_errors, cb));
}


/* Unmarshall pimstat_bootstrap_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_assert_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatAssertMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_assert_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_assert_messages_received, cb));
}


/* Unmarshall pimstat_assert_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_assert_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_assert_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatAssertMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_assert_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_assert_messages_sent, cb));
}


/* Unmarshall pimstat_assert_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_assert_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_assert_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatAssertMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_assert_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_assert_messages_rx_errors, cb));
}


/* Unmarshall pimstat_assert_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_assert_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatGraftMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_messages_received, cb));
}


/* Unmarshall pimstat_graft_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatGraftMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_messages_sent, cb));
}


/* Unmarshall pimstat_graft_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatGraftMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_messages_rx_errors, cb));
}


/* Unmarshall pimstat_graft_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_ack_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatGraftAckMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_ack_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_received, cb));
}


/* Unmarshall pimstat_graft_ack_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_ack_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatGraftAckMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_ack_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_sent, cb));
}


/* Unmarshall pimstat_graft_ack_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_ack_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatGraftAckMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_ack_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_rx_errors, cb));
}


/* Unmarshall pimstat_graft_ack_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_candidate_rp_messages_received(
	const char*	dst_xrl_target_name,
	const PimstatCandidateRpMessagesReceivedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_candidate_rp_messages_received");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_received, cb));
}


/* Unmarshall pimstat_candidate_rp_messages_received */
void
XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesReceivedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_candidate_rp_messages_sent(
	const char*	dst_xrl_target_name,
	const PimstatCandidateRpMessagesSentCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_candidate_rp_messages_sent");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_sent, cb));
}


/* Unmarshall pimstat_candidate_rp_messages_sent */
void
XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesSentCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_candidate_rp_messages_rx_errors(
	const char*	dst_xrl_target_name,
	const PimstatCandidateRpMessagesRxErrorsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_candidate_rp_messages_rx_errors");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_rx_errors, cb));
}


/* Unmarshall pimstat_candidate_rp_messages_rx_errors */
void
XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesRxErrorsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_unknown_type_messages(
	const char*	dst_xrl_target_name,
	const PimstatUnknownTypeMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_unknown_type_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_unknown_type_messages, cb));
}


/* Unmarshall pimstat_unknown_type_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_unknown_type_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownTypeMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_unknown_version_messages(
	const char*	dst_xrl_target_name,
	const PimstatUnknownVersionMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_unknown_version_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_unknown_version_messages, cb));
}


/* Unmarshall pimstat_unknown_version_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_unknown_version_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownVersionMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_neighbor_unknown_messages(
	const char*	dst_xrl_target_name,
	const PimstatNeighborUnknownMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_neighbor_unknown_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_neighbor_unknown_messages, cb));
}


/* Unmarshall pimstat_neighbor_unknown_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_neighbor_unknown_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighborUnknownMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bad_length_messages(
	const char*	dst_xrl_target_name,
	const PimstatBadLengthMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bad_length_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bad_length_messages, cb));
}


/* Unmarshall pimstat_bad_length_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_bad_length_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadLengthMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bad_checksum_messages(
	const char*	dst_xrl_target_name,
	const PimstatBadChecksumMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bad_checksum_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bad_checksum_messages, cb));
}


/* Unmarshall pimstat_bad_checksum_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_bad_checksum_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadChecksumMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bad_receive_interface_messages(
	const char*	dst_xrl_target_name,
	const PimstatBadReceiveInterfaceMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bad_receive_interface_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bad_receive_interface_messages, cb));
}


/* Unmarshall pimstat_bad_receive_interface_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_bad_receive_interface_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadReceiveInterfaceMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_interface_disabled_messages(
	const char*	dst_xrl_target_name,
	const PimstatRxInterfaceDisabledMessagesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_interface_disabled_messages");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_interface_disabled_messages, cb));
}


/* Unmarshall pimstat_rx_interface_disabled_messages */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_interface_disabled_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxInterfaceDisabledMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_register_not_rp(
	const char*	dst_xrl_target_name,
	const PimstatRxRegisterNotRpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_register_not_rp");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_register_not_rp, cb));
}


/* Unmarshall pimstat_rx_register_not_rp */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_register_not_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRegisterNotRpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rp_filtered_source(
	const char*	dst_xrl_target_name,
	const PimstatRpFilteredSourceCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rp_filtered_source");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rp_filtered_source, cb));
}


/* Unmarshall pimstat_rp_filtered_source */
void
XrlPimV0p1Client::unmarshall_pimstat_rp_filtered_source(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpFilteredSourceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_unknown_register_stop(
	const char*	dst_xrl_target_name,
	const PimstatUnknownRegisterStopCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_unknown_register_stop");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_unknown_register_stop, cb));
}


/* Unmarshall pimstat_unknown_register_stop */
void
XrlPimV0p1Client::unmarshall_pimstat_unknown_register_stop(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownRegisterStopCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_prune_no_state(
	const char*	dst_xrl_target_name,
	const PimstatRxJoinPruneNoStateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_prune_no_state");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_prune_no_state, cb));
}


/* Unmarshall pimstat_rx_join_prune_no_state */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_prune_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinPruneNoStateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_graft_graft_ack_no_state(
	const char*	dst_xrl_target_name,
	const PimstatRxGraftGraftAckNoStateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_graft_graft_ack_no_state");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_graft_graft_ack_no_state, cb));
}


/* Unmarshall pimstat_rx_graft_graft_ack_no_state */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_graft_graft_ack_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftGraftAckNoStateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_graft_on_upstream_interface(
	const char*	dst_xrl_target_name,
	const PimstatRxGraftOnUpstreamInterfaceCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_graft_on_upstream_interface");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_graft_on_upstream_interface, cb));
}


/* Unmarshall pimstat_rx_graft_on_upstream_interface */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_graft_on_upstream_interface(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftOnUpstreamInterfaceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_candidate_rp_not_bsr(
	const char*	dst_xrl_target_name,
	const PimstatRxCandidateRpNotBsrCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_candidate_rp_not_bsr");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_candidate_rp_not_bsr, cb));
}


/* Unmarshall pimstat_rx_candidate_rp_not_bsr */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_candidate_rp_not_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxCandidateRpNotBsrCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_bsr_when_bsr(
	const char*	dst_xrl_target_name,
	const PimstatRxBsrWhenBsrCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_bsr_when_bsr");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_when_bsr, cb));
}


/* Unmarshall pimstat_rx_bsr_when_bsr */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_when_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrWhenBsrCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_bsr_not_rpf_interface(
	const char*	dst_xrl_target_name,
	const PimstatRxBsrNotRpfInterfaceCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_bsr_not_rpf_interface");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_not_rpf_interface, cb));
}


/* Unmarshall pimstat_rx_bsr_not_rpf_interface */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_not_rpf_interface(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrNotRpfInterfaceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_unknown_hello_option(
	const char*	dst_xrl_target_name,
	const PimstatRxUnknownHelloOptionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_unknown_hello_option");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_unknown_hello_option, cb));
}


/* Unmarshall pimstat_rx_unknown_hello_option */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_unknown_hello_option(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxUnknownHelloOptionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_data_no_state(
	const char*	dst_xrl_target_name,
	const PimstatRxDataNoStateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_data_no_state");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_data_no_state, cb));
}


/* Unmarshall pimstat_rx_data_no_state */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_data_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxDataNoStateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_rp_no_state(
	const char*	dst_xrl_target_name,
	const PimstatRxRpNoStateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_rp_no_state");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_rp_no_state, cb));
}


/* Unmarshall pimstat_rx_rp_no_state */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_rp_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRpNoStateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_aggregate(
	const char*	dst_xrl_target_name,
	const PimstatRxAggregateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_aggregate");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_aggregate, cb));
}


/* Unmarshall pimstat_rx_aggregate */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_aggregate(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxAggregateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_malformed_packet(
	const char*	dst_xrl_target_name,
	const PimstatRxMalformedPacketCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_malformed_packet");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_malformed_packet, cb));
}


/* Unmarshall pimstat_rx_malformed_packet */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_malformed_packet(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxMalformedPacketCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_no_rp(
	const char*	dst_xrl_target_name,
	const PimstatNoRpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_no_rp");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_no_rp, cb));
}


/* Unmarshall pimstat_no_rp */
void
XrlPimV0p1Client::unmarshall_pimstat_no_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_no_route_upstream(
	const char*	dst_xrl_target_name,
	const PimstatNoRouteUpstreamCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_no_route_upstream");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_no_route_upstream, cb));
}


/* Unmarshall pimstat_no_route_upstream */
void
XrlPimV0p1Client::unmarshall_pimstat_no_route_upstream(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRouteUpstreamCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rp_mismatch(
	const char*	dst_xrl_target_name,
	const PimstatRpMismatchCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rp_mismatch");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rp_mismatch, cb));
}


/* Unmarshall pimstat_rp_mismatch */
void
XrlPimV0p1Client::unmarshall_pimstat_rp_mismatch(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpMismatchCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rpf_neighbor_unknown(
	const char*	dst_xrl_target_name,
	const PimstatRpfNeighborUnknownCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rpf_neighbor_unknown");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rpf_neighbor_unknown, cb));
}


/* Unmarshall pimstat_rpf_neighbor_unknown */
void
XrlPimV0p1Client::unmarshall_pimstat_rpf_neighbor_unknown(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpfNeighborUnknownCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_rp(
	const char*	dst_xrl_target_name,
	const PimstatRxJoinRpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_rp");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_rp, cb));
}


/* Unmarshall pimstat_rx_join_rp */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinRpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_rp(
	const char*	dst_xrl_target_name,
	const PimstatRxPruneRpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_rp");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_rp, cb));
}


/* Unmarshall pimstat_rx_prune_rp */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneRpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_wc(
	const char*	dst_xrl_target_name,
	const PimstatRxJoinWcCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_wc");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_wc, cb));
}


/* Unmarshall pimstat_rx_join_wc */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_wc(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinWcCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_wc(
	const char*	dst_xrl_target_name,
	const PimstatRxPruneWcCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_wc");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_wc, cb));
}


/* Unmarshall pimstat_rx_prune_wc */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_wc(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneWcCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_sg(
	const char*	dst_xrl_target_name,
	const PimstatRxJoinSgCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_sg");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg, cb));
}


/* Unmarshall pimstat_rx_join_sg */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_sg(
	const char*	dst_xrl_target_name,
	const PimstatRxPruneSgCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_sg");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg, cb));
}


/* Unmarshall pimstat_rx_prune_sg */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_sg_rpt(
	const char*	dst_xrl_target_name,
	const PimstatRxJoinSgRptCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_sg_rpt");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg_rpt, cb));
}


/* Unmarshall pimstat_rx_join_sg_rpt */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg_rpt(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgRptCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_sg_rpt(
	const char*	dst_xrl_target_name,
	const PimstatRxPruneSgRptCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_sg_rpt");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg_rpt, cb));
}


/* Unmarshall pimstat_rx_prune_sg_rpt */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg_rpt(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgRptCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_hello_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatHelloMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_hello_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_hello_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_hello_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_hello_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_hello_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatHelloMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_hello_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_hello_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_hello_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_hello_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_hello_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatHelloMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_hello_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_hello_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_hello_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_hello_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRegisterMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_register_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_register_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRegisterMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_register_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_register_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRegisterMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_register_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_register_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_stop_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRegisterStopMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_stop_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_register_stop_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_stop_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRegisterStopMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_stop_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_register_stop_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_register_stop_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRegisterStopMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_register_stop_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_register_stop_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_register_stop_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_join_prune_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatJoinPruneMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_join_prune_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_join_prune_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_join_prune_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatJoinPruneMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_join_prune_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_join_prune_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_join_prune_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatJoinPruneMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_join_prune_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_join_prune_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_join_prune_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bootstrap_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatBootstrapMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bootstrap_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_bootstrap_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bootstrap_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatBootstrapMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bootstrap_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_bootstrap_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bootstrap_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatBootstrapMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bootstrap_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_bootstrap_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_bootstrap_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_assert_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatAssertMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_assert_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_assert_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_assert_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_assert_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_assert_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatAssertMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_assert_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_assert_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_assert_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_assert_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_assert_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatAssertMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_assert_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_assert_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_assert_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_assert_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatGraftMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_graft_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatGraftMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_graft_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatGraftMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_graft_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_ack_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatGraftAckMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_ack_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_graft_ack_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_ack_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatGraftAckMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_ack_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_graft_ack_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_graft_ack_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatGraftAckMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_graft_ack_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_graft_ack_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_graft_ack_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_candidate_rp_messages_received_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatCandidateRpMessagesReceivedPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_candidate_rp_messages_received_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_received_per_vif, cb));
}


/* Unmarshall pimstat_candidate_rp_messages_received_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesReceivedPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_candidate_rp_messages_sent_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatCandidateRpMessagesSentPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_candidate_rp_messages_sent_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_sent_per_vif, cb));
}


/* Unmarshall pimstat_candidate_rp_messages_sent_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesSentPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_candidate_rp_messages_rx_errors_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatCandidateRpMessagesRxErrorsPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_candidate_rp_messages_rx_errors_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_rx_errors_per_vif, cb));
}


/* Unmarshall pimstat_candidate_rp_messages_rx_errors_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_candidate_rp_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesRxErrorsPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_unknown_type_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatUnknownTypeMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_unknown_type_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_unknown_type_messages_per_vif, cb));
}


/* Unmarshall pimstat_unknown_type_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_unknown_type_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownTypeMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_unknown_version_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatUnknownVersionMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_unknown_version_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_unknown_version_messages_per_vif, cb));
}


/* Unmarshall pimstat_unknown_version_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_unknown_version_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownVersionMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_neighbor_unknown_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatNeighborUnknownMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_neighbor_unknown_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_neighbor_unknown_messages_per_vif, cb));
}


/* Unmarshall pimstat_neighbor_unknown_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_neighbor_unknown_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighborUnknownMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bad_length_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatBadLengthMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bad_length_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bad_length_messages_per_vif, cb));
}


/* Unmarshall pimstat_bad_length_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_bad_length_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadLengthMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bad_checksum_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatBadChecksumMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bad_checksum_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bad_checksum_messages_per_vif, cb));
}


/* Unmarshall pimstat_bad_checksum_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_bad_checksum_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadChecksumMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_bad_receive_interface_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatBadReceiveInterfaceMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_bad_receive_interface_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_bad_receive_interface_messages_per_vif, cb));
}


/* Unmarshall pimstat_bad_receive_interface_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_bad_receive_interface_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadReceiveInterfaceMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_interface_disabled_messages_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxInterfaceDisabledMessagesPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_interface_disabled_messages_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_interface_disabled_messages_per_vif, cb));
}


/* Unmarshall pimstat_rx_interface_disabled_messages_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_interface_disabled_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxInterfaceDisabledMessagesPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_register_not_rp_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxRegisterNotRpPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_register_not_rp_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_register_not_rp_per_vif, cb));
}


/* Unmarshall pimstat_rx_register_not_rp_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_register_not_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRegisterNotRpPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rp_filtered_source_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRpFilteredSourcePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rp_filtered_source_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rp_filtered_source_per_vif, cb));
}


/* Unmarshall pimstat_rp_filtered_source_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rp_filtered_source_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpFilteredSourcePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_unknown_register_stop_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatUnknownRegisterStopPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_unknown_register_stop_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_unknown_register_stop_per_vif, cb));
}


/* Unmarshall pimstat_unknown_register_stop_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_unknown_register_stop_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownRegisterStopPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_prune_no_state_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxJoinPruneNoStatePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_prune_no_state_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_prune_no_state_per_vif, cb));
}


/* Unmarshall pimstat_rx_join_prune_no_state_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_prune_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinPruneNoStatePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_graft_graft_ack_no_state_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxGraftGraftAckNoStatePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_graft_graft_ack_no_state_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_graft_graft_ack_no_state_per_vif, cb));
}


/* Unmarshall pimstat_rx_graft_graft_ack_no_state_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_graft_graft_ack_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftGraftAckNoStatePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_graft_on_upstream_interface_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxGraftOnUpstreamInterfacePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_graft_on_upstream_interface_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_graft_on_upstream_interface_per_vif, cb));
}


/* Unmarshall pimstat_rx_graft_on_upstream_interface_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_graft_on_upstream_interface_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftOnUpstreamInterfacePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_candidate_rp_not_bsr_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxCandidateRpNotBsrPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_candidate_rp_not_bsr_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_candidate_rp_not_bsr_per_vif, cb));
}


/* Unmarshall pimstat_rx_candidate_rp_not_bsr_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_candidate_rp_not_bsr_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxCandidateRpNotBsrPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_bsr_when_bsr_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxBsrWhenBsrPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_bsr_when_bsr_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_when_bsr_per_vif, cb));
}


/* Unmarshall pimstat_rx_bsr_when_bsr_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_when_bsr_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrWhenBsrPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_bsr_not_rpf_interface_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxBsrNotRpfInterfacePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_bsr_not_rpf_interface_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_not_rpf_interface_per_vif, cb));
}


/* Unmarshall pimstat_rx_bsr_not_rpf_interface_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_bsr_not_rpf_interface_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrNotRpfInterfacePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_unknown_hello_option_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxUnknownHelloOptionPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_unknown_hello_option_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_unknown_hello_option_per_vif, cb));
}


/* Unmarshall pimstat_rx_unknown_hello_option_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_unknown_hello_option_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxUnknownHelloOptionPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_data_no_state_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxDataNoStatePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_data_no_state_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_data_no_state_per_vif, cb));
}


/* Unmarshall pimstat_rx_data_no_state_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_data_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxDataNoStatePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_rp_no_state_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxRpNoStatePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_rp_no_state_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_rp_no_state_per_vif, cb));
}


/* Unmarshall pimstat_rx_rp_no_state_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_rp_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRpNoStatePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_aggregate_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxAggregatePerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_aggregate_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_aggregate_per_vif, cb));
}


/* Unmarshall pimstat_rx_aggregate_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_aggregate_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxAggregatePerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_malformed_packet_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxMalformedPacketPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_malformed_packet_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_malformed_packet_per_vif, cb));
}


/* Unmarshall pimstat_rx_malformed_packet_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_malformed_packet_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxMalformedPacketPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_no_rp_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatNoRpPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_no_rp_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_no_rp_per_vif, cb));
}


/* Unmarshall pimstat_no_rp_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_no_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRpPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_no_route_upstream_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatNoRouteUpstreamPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_no_route_upstream_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_no_route_upstream_per_vif, cb));
}


/* Unmarshall pimstat_no_route_upstream_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_no_route_upstream_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRouteUpstreamPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rp_mismatch_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRpMismatchPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rp_mismatch_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rp_mismatch_per_vif, cb));
}


/* Unmarshall pimstat_rp_mismatch_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rp_mismatch_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpMismatchPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rpf_neighbor_unknown_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRpfNeighborUnknownPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rpf_neighbor_unknown_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rpf_neighbor_unknown_per_vif, cb));
}


/* Unmarshall pimstat_rpf_neighbor_unknown_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rpf_neighbor_unknown_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpfNeighborUnknownPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_rp_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxJoinRpPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_rp_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_rp_per_vif, cb));
}


/* Unmarshall pimstat_rx_join_rp_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinRpPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_rp_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxPruneRpPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_rp_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_rp_per_vif, cb));
}


/* Unmarshall pimstat_rx_prune_rp_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneRpPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_wc_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxJoinWcPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_wc_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_wc_per_vif, cb));
}


/* Unmarshall pimstat_rx_join_wc_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_wc_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinWcPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_wc_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxPruneWcPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_wc_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_wc_per_vif, cb));
}


/* Unmarshall pimstat_rx_prune_wc_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_wc_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneWcPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_sg_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxJoinSgPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_sg_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg_per_vif, cb));
}


/* Unmarshall pimstat_rx_join_sg_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_sg_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxPruneSgPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_sg_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg_per_vif, cb));
}


/* Unmarshall pimstat_rx_prune_sg_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_join_sg_rpt_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxJoinSgRptPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_join_sg_rpt_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg_rpt_per_vif, cb));
}


/* Unmarshall pimstat_rx_join_sg_rpt_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_join_sg_rpt_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgRptPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}

bool
XrlPimV0p1Client::send_pimstat_rx_prune_sg_rpt_per_vif(
	const char*	dst_xrl_target_name,
	const string&	vif_name,
	const PimstatRxPruneSgRptPerVifCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "pim/0.1/pimstat_rx_prune_sg_rpt_per_vif");
        x->args().add(XrlAtom(vif_name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, vif_name);

    return _sender->send(*x, callback(this, &XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg_rpt_per_vif, cb));
}


/* Unmarshall pimstat_rx_prune_sg_rpt_per_vif */
void
XrlPimV0p1Client::unmarshall_pimstat_rx_prune_sg_rpt_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgRptPerVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t value;
    try {
	a->get("value", value);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &value);
}
