/*
 *  Copyright © 2004-2005 Jasper Huijsmans <jasper@xfce.org>
 *  Copyright (c) 2005 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published 
 *  by the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__HANDLE_H_
#define _XFMEDIA__HANDLE_H_

#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define XFMEDIA_TYPE_HANDLE         (xfmedia_handle_get_type())
#define XFMEDIA_HANDLE(object)      (G_TYPE_CHECK_INSTANCE_CAST((object), XFMEDIA_TYPE_HANDLE, XfmediaHandle))
#define XFMEDIA_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_HANDLE, XfmediaHandleClass))
#define XFMEDIA_IS_HANDLE(object)   (G_TYPE_CHECK_INSTANCE_TYPE((object), XFMEDIA_TYPE_HANDLE))

typedef struct _XfmediaHandle         XfmediaHandle;
typedef struct _XfmediaHandleClass    XfmediaHandleClass;
typedef struct _XfmediaHandlePrivate  XfmediaHandlePrivate;

typedef enum
{
    XFMEDIA_HANDLE_STYLE_DOT, 
    XFMEDIA_HANDLE_STYLE_GRIP, 
    XFMEDIA_HANDLE_STYLE_BOX,
} XfmediaHandleStyle;
    
struct _XfmediaHandle
{
    GtkWidget parent;
    
    /*< private >*/
    XfmediaHandlePrivate *priv;
};

struct _XfmediaHandleClass
{
    GtkWidgetClass parent;
};

GType      xfmedia_handle_get_type             () G_GNUC_CONST;

GtkWidget *xfmedia_handle_new                  (XfmediaHandleStyle style,
                                                GtkOrientation orientation);

XfmediaHandleStyle xfmedia_handle_get_style    (XfmediaHandle *handle);
void       xfmedia_handle_set_style            (XfmediaHandle *handle,
                                                XfmediaHandleStyle style);

GtkOrientation xfmedia_handle_get_orientation  (XfmediaHandle *handle);
void       xfmedia_handle_set_orientation      (XfmediaHandle *handle,
                                                GtkOrientation orientation);

G_END_DECLS

#endif
