#ifndef PATHLINKER_H
#define PATHLINKER_H

#include <vector>


class FXAPI PathLinker : public FXHorizontalFrame
{
    FXDECLARE(PathLinker)

public:
#define MAX_LINKS 40
    enum ButtonIds
	{
        ID_START_LINK = FXHorizontalFrame::ID_LAST,
        // Note: Place any additional id's AFTER ID_END_LINK
        ID_END_LINK = ID_START_LINK + MAX_LINKS - 1,
		ID_FOCUS_BUTTON,
        ID_SPLITTER,
        ID_LAST
    };

    PathLinker(FXComposite *);
	PathLinker()
	{}
    virtual ~PathLinker();
	long pathButtonEnter(FXObject* obj, FXSelector sel, void* ptr);
    long pathButtonPressed(FXObject* obj, FXSelector sel, void* ptr);
    long pathButtonReleased(FXObject* obj, FXSelector sel, void* ptr);
	long onCmdFocusButton(FXObject * obj ,FXSelector sel ,void* ptr);
    void setText(FXString text);
	void focus();
	void unfocus();

protected:
    typedef std::vector<FXButton*> vector_FXButton;
    vector_FXButton mPath;
    int activeButtons;
    FXString mFullPath;
	FXButton* focusButton;

private:
    void setText(unsigned int index, FXString text);
    void SetPathHighlight(int endId);
    void RevertPathHighlight(int endId);

};

#endif /* PATHLINKER_H */
