/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.HeadingMap;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class HeadingConverter
extends ConverterHelper {
    private String[] sHeadingStyles = new String[11];

    public HeadingConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        this.appendHeadingStyles(decl);
    }

    public void handleHeading(Element node, LaTeXDocumentPortion ldp, Context oc) {
        int nLevel = this.ofr.isOpenDocument() ? Misc.getPosInteger(Misc.getAttribute(node, "text:outline-level"), 1) : Misc.getPosInteger(Misc.getAttribute(node, "text:level"), 1);
        HeadingMap hm = this.config.getHeadingMap();
        String sStyleName = node.getAttribute("text:style-name");
        if (nLevel <= hm.getMaxLevel()) {
            this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getParStyle(sStyleName)));
            Context ic = (Context)oc.clone();
            ic.setInSection(true);
            ic.setNoFootnotes(true);
            BeforeAfter baHardPage = new BeforeAfter();
            BeforeAfter baHardChar = new BeforeAfter();
            this.applyHardHeadingStyle(nLevel, sStyleName, baHardPage, baHardChar, ic);
            ldp.append(baHardPage.getBefore());
            ldp.append("\\" + hm.getName(nLevel));
            if (baHardChar.getBefore().length() > 0 || this.containsElements(node)) {
                ldp.append("[");
                this.palette.getInlineCv().traversePlainInlineText(node, ldp, ic);
                ldp.append("]");
            }
            ldp.append("{").append(baHardChar.getBefore());
            this.palette.getInlineCv().traverseInlineText(node, ldp, ic, false);
            ldp.append(baHardChar.getAfter()).append("}").nl();
            ldp.append(baHardPage.getAfter());
            this.palette.getFieldCv().flushReferenceMarks(ldp, oc);
            this.palette.getIndexCv().flushIndexMarks(ldp, oc);
            this.palette.getNoteCv().flushFootnotes(ldp, oc);
            this.palette.getDrawCv().flushFloatingFrames(ldp, ic);
            this.palette.getI18n().popSpecialTable();
        } else {
            this.palette.getParCv().handleParagraph(node, ldp, oc, false);
        }
    }

    private void applyHardHeadingStyle(int nLevel, String sStyleName, BeforeAfter baPage, BeforeAfter baText, Context context) {
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style == null) {
            return;
        }
        if (this.sHeadingStyles[nLevel] == null) {
            String string = this.sHeadingStyles[nLevel] = style.isAutomatic() ? style.getParentName() : sStyleName;
        }
        if (style.isAutomatic()) {
            this.palette.getPageSc().applyPageBreak(style, false, baPage);
            this.palette.getCharSc().applyHardCharFormatting(style, baText);
        }
        context.updateFormattingFromStyle(style);
    }

    private void appendHeadingStyles(LaTeXDocumentPortion ldp) {
        boolean bOnlyNum;
        if (this.config.formatting() <= 1) {
            return;
        }
        HeadingMap hm = this.config.getHeadingMap();
        int nMaxLevel = 0;
        int i = 1;
        while (i <= 5) {
            if (this.sHeadingStyles[i] != null) {
                nMaxLevel = i;
            }
            ++i;
        }
        if (nMaxLevel == 0) {
            return;
        }
        if (nMaxLevel > hm.getMaxLevel()) {
            nMaxLevel = hm.getMaxLevel();
        }
        boolean bl = bOnlyNum = this.config.formatting() == 2;
        if (bOnlyNum) {
            ldp.append("% Outline numbering").nl();
        } else {
            ldp.append("% Headings and outline numbering").nl().append("\\makeatletter").nl();
        }
        if (!bOnlyNum) {
            int i2 = 1;
            while (i2 <= nMaxLevel) {
                StyleWithProperties style;
                if (this.sHeadingStyles[i2] != null && (style = this.ofr.getParStyle(this.sHeadingStyles[i2])) != null) {
                    BeforeAfter decl = new BeforeAfter();
                    BeforeAfter comm = new BeforeAfter();
                    this.palette.getPageSc().applyPageBreak(style, true, decl);
                    this.palette.getCharSc().applyNormalFont(decl);
                    this.palette.getCharSc().applyFont(style, true, true, decl, new Context());
                    this.palette.getParCv().applyAlignment(style, false, true, decl);
                    this.palette.getI18n().applyLanguage(style, false, true, comm);
                    this.palette.getCharSc().applyFontEffects(style, true, comm);
                    String sMarginTop = style.getAbsoluteLength("fo:margin-top");
                    String sMarginBottom = style.getAbsoluteLength("fo:margin-bottom");
                    String sMarginLeft = style.getAbsoluteLength("fo:margin-left");
                    String sSecName = hm.getName(i2);
                    if (!comm.isEmpty()) {
                        ldp.append("\\newcommand\\cs").append(sSecName).append("[1]{").append(comm.getBefore()).append("#1").append(comm.getAfter()).append("}").nl();
                    }
                    ldp.append("\\renewcommand\\").append(sSecName).append("{\\@startsection{").append(sSecName).append("}{" + hm.getLevel(i2)).append("}{" + sMarginLeft + "}{");
                    ldp.append(sMarginTop).append("}{").append(sMarginBottom).append("}{");
                    ldp.append(decl.getBefore());
                    if (!comm.isEmpty()) {
                        ldp.append("\\cs").append(sSecName);
                    }
                    ldp.append("}}").nl();
                }
                ++i2;
            }
        }
        if (!bOnlyNum) {
            ldp.append("\\renewcommand\\@seccntformat[1]{").append("\\csname @textstyle#1\\endcsname{\\csname the#1\\endcsname}").append("\\csname @distance#1\\endcsname}").nl();
        }
        int nSecnumdepth = nMaxLevel;
        ListStyle outline = this.ofr.getOutlineStyle();
        String[] sNumFormat = new String[6];
        int i3 = nMaxLevel;
        while (i3 >= 1) {
            sNumFormat[i3] = ListStyleConverter.numFormat(outline.getLevelProperty(i3, "style:num-format"));
            if (sNumFormat[i3] == null || "".equals(sNumFormat[i3])) {
                nSecnumdepth = i3 - 1;
            }
            --i3;
        }
        ldp.append("\\setcounter{secnumdepth}{" + nSecnumdepth + "}").nl();
        int i4 = 1;
        while (i4 <= nMaxLevel) {
            if (sNumFormat[i4] == null || "".equals(sNumFormat[i4])) {
                if (!bOnlyNum) {
                    ldp.append("\\newcommand\\@distance").append(hm.getName(i4)).append("{}").nl().append("\\newcommand\\@textstyle").append(hm.getName(i4)).append("[1]{#1}").nl();
                }
            } else {
                if (!bOnlyNum) {
                    String sDistance = outline.getLevelStyleProperty(i4, "text:min-label-distance");
                    ldp.append("\\newcommand\\@distance").append(hm.getName(i4)).append("{");
                    if (sDistance != null) {
                        ldp.append("\\hspace{").append(sDistance).append("}");
                    }
                    ldp.append("}").nl();
                    String sLabelWidth = outline.getLevelStyleProperty(i4, "text:min-label-width");
                    String sTextAlign = outline.getLevelStyleProperty(i4, "fo:text-align");
                    String sAlignmentChar = "l";
                    if (sTextAlign != null) {
                        if ("end".equals(sTextAlign)) {
                            sAlignmentChar = "r";
                        } else if ("right".equals(sTextAlign)) {
                            sAlignmentChar = "r";
                        } else if ("center".equals(sTextAlign)) {
                            sAlignmentChar = "c";
                        }
                    }
                    String sStyleName = outline.getLevelProperty(i4, "text:style-name");
                    BeforeAfter baText = new BeforeAfter();
                    if (!bOnlyNum) {
                        this.palette.getCharSc().applyTextStyle(sStyleName, baText, new Context());
                    }
                    ldp.append("\\newcommand\\@textstyle").append(hm.getName(i4)).append("[1]{");
                    if (!bOnlyNum && sLabelWidth != null) {
                        ldp.append("\\makebox[").append(sLabelWidth).append("][").append(sAlignmentChar).append("]{");
                    }
                    ldp.append(baText.getBefore()).append("#1").append(baText.getAfter());
                    if (!bOnlyNum && sLabelWidth != null) {
                        ldp.append("}");
                    }
                    ldp.append("}").nl();
                }
                String sPrefix = outline.getLevelProperty(i4, "style:num-prefix");
                String sSuffix = outline.getLevelProperty(i4, "style:num-suffix");
                int nLevels = Misc.getPosInteger(outline.getLevelProperty(i4, "text:display-levels"), 1);
                ldp.append("\\renewcommand\\the").append(hm.getName(i4)).append("{");
                StringBuffer labelbuf = new StringBuffer();
                if (sPrefix != null) {
                    labelbuf.append(sPrefix);
                }
                int j = i4 - nLevels + 1;
                while (j < i4) {
                    labelbuf.append(sNumFormat[j]).append("{").append(HeadingConverter.sectionName(j)).append("}").append(".");
                    ++j;
                }
                labelbuf.append(sNumFormat[i4]).append("{").append(hm.getName(i4)).append("}");
                if (sSuffix != null) {
                    labelbuf.append(sSuffix);
                }
                if (bOnlyNum) {
                    ldp.append(labelbuf.toString().trim());
                } else {
                    ldp.append(labelbuf.toString());
                }
                ldp.append("}").nl();
            }
            ++i4;
        }
        if (!bOnlyNum) {
            ldp.append("\\makeatother").nl();
        }
    }

    public boolean containsElements(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList list = node.getChildNodes();
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = list.item(i);
            if (child.getNodeType() == 1 && !child.getNodeName().startsWith("text:reference-mark")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static final String sectionName(int nLevel) {
        switch (nLevel) {
            case 1: {
                return "section";
            }
            case 2: {
                return "subsection";
            }
            case 3: {
                return "subsubsection";
            }
            case 4: {
                return "paragraph";
            }
            case 5: {
                return "subparagraph";
            }
        }
        return null;
    }
}

