/* File generated automatically from tools/winapi/tests.dat; do not edit! */
/* This file can be copied, modified and distributed without restriction. */

/*
 * Unit tests for data structure packing
 */

#define WINVER 0x0501
#define _WIN32_IE 0x0501
#define _WIN32_WINNT 0x0501

#define WINE_NOWINSOCK

#include "windows.h"

#include "wine/test.h"

/***********************************************************************
 * Compatibility macros
 */

#define DWORD_PTR UINT_PTR
#define LONG_PTR INT_PTR
#define ULONG_PTR UINT_PTR

/***********************************************************************
 * Windows API extension
 */

#if defined(_MSC_VER) && (_MSC_VER >= 1300) && defined(__cplusplus)
# define _TYPE_ALIGNMENT(type) __alignof(type)
#elif defined(__GNUC__)
# define _TYPE_ALIGNMENT(type) __alignof__(type)
#else
/*
 * FIXME: May not be possible without a compiler extension
 *        (if type is not just a name that is, otherwise the normal
 *         TYPE_ALIGNMENT can be used)
 */
#endif

#if defined(TYPE_ALIGNMENT) && defined(_MSC_VER) && _MSC_VER >= 800 && !defined(__cplusplus)
#pragma warning(disable:4116)
#endif

#if !defined(TYPE_ALIGNMENT) && defined(_TYPE_ALIGNMENT)
# define TYPE_ALIGNMENT _TYPE_ALIGNMENT
#endif

/***********************************************************************
 * Test helper macros
 */

#ifdef _WIN64

# define TEST_TYPE_SIZE(type, size)
# define TEST_TYPE_ALIGN(type, align)
# define TEST_TARGET_ALIGN(type, align)
# define TEST_FIELD_ALIGN(type, field, align)
# define TEST_FIELD_OFFSET(type, field, offset)

#else

# define TEST_TYPE_SIZE(type, size)             C_ASSERT(sizeof(type) == size);

# ifdef TYPE_ALIGNMENT
#  define TEST_TYPE_ALIGN(type, align)          C_ASSERT(TYPE_ALIGNMENT(type) == align);
# else
#  define TEST_TYPE_ALIGN(type, align)
# endif

# ifdef _TYPE_ALIGNMENT
#  define TEST_TARGET_ALIGN(type, align)        C_ASSERT(_TYPE_ALIGNMENT(*(type)0) == align);
#  define TEST_FIELD_ALIGN(type, field, align)  C_ASSERT(_TYPE_ALIGNMENT(((type*)0)->field) == align);
# else
#  define TEST_TARGET_ALIGN(type, align)
#  define TEST_FIELD_ALIGN(type, field, align)
# endif

# define TEST_FIELD_OFFSET(type, field, offset) C_ASSERT(FIELD_OFFSET(type, field) == offset);

#endif

#define TEST_TARGET_SIZE(type, size)            TEST_TYPE_SIZE(*(type)0, size)
#define TEST_FIELD_SIZE(type, field, size)      TEST_TYPE_SIZE((((type*)0)->field), size)
#define TEST_TYPE_SIGNED(type)                  C_ASSERT((type) -1 < 0);
#define TEST_TYPE_UNSIGNED(type)                C_ASSERT((type) -1 > 0);


static void test_pack_ABC(void)
{
    /* ABC (pack 4) */
    TEST_TYPE_SIZE   (ABC, 12)
    TEST_TYPE_ALIGN  (ABC, 4)
    TEST_FIELD_SIZE  (ABC, abcA, 4)
    TEST_FIELD_ALIGN (ABC, abcA, 4)
    TEST_FIELD_OFFSET(ABC, abcA, 0)
    TEST_FIELD_SIZE  (ABC, abcB, 4)
    TEST_FIELD_ALIGN (ABC, abcB, 4)
    TEST_FIELD_OFFSET(ABC, abcB, 4)
    TEST_FIELD_SIZE  (ABC, abcC, 4)
    TEST_FIELD_ALIGN (ABC, abcC, 4)
    TEST_FIELD_OFFSET(ABC, abcC, 8)
}

static void test_pack_ABCFLOAT(void)
{
    /* ABCFLOAT (pack 4) */
    TEST_TYPE_SIZE   (ABCFLOAT, 12)
    TEST_TYPE_ALIGN  (ABCFLOAT, 4)
    TEST_FIELD_SIZE  (ABCFLOAT, abcfA, 4)
    TEST_FIELD_ALIGN (ABCFLOAT, abcfA, 4)
    TEST_FIELD_OFFSET(ABCFLOAT, abcfA, 0)
    TEST_FIELD_SIZE  (ABCFLOAT, abcfB, 4)
    TEST_FIELD_ALIGN (ABCFLOAT, abcfB, 4)
    TEST_FIELD_OFFSET(ABCFLOAT, abcfB, 4)
    TEST_FIELD_SIZE  (ABCFLOAT, abcfC, 4)
    TEST_FIELD_ALIGN (ABCFLOAT, abcfC, 4)
    TEST_FIELD_OFFSET(ABCFLOAT, abcfC, 8)
}

static void test_pack_ABORTPROC(void)
{
    /* ABORTPROC */
    TEST_TYPE_SIZE   (ABORTPROC, 4)
    TEST_TYPE_ALIGN  (ABORTPROC, 4)
}

static void test_pack_BITMAP(void)
{
    /* BITMAP (pack 4) */
    TEST_TYPE_SIZE   (BITMAP, 24)
    TEST_TYPE_ALIGN  (BITMAP, 4)
    TEST_FIELD_SIZE  (BITMAP, bmType, 4)
    TEST_FIELD_ALIGN (BITMAP, bmType, 4)
    TEST_FIELD_OFFSET(BITMAP, bmType, 0)
    TEST_FIELD_SIZE  (BITMAP, bmWidth, 4)
    TEST_FIELD_ALIGN (BITMAP, bmWidth, 4)
    TEST_FIELD_OFFSET(BITMAP, bmWidth, 4)
    TEST_FIELD_SIZE  (BITMAP, bmHeight, 4)
    TEST_FIELD_ALIGN (BITMAP, bmHeight, 4)
    TEST_FIELD_OFFSET(BITMAP, bmHeight, 8)
    TEST_FIELD_SIZE  (BITMAP, bmWidthBytes, 4)
    TEST_FIELD_ALIGN (BITMAP, bmWidthBytes, 4)
    TEST_FIELD_OFFSET(BITMAP, bmWidthBytes, 12)
    TEST_FIELD_SIZE  (BITMAP, bmPlanes, 2)
    TEST_FIELD_ALIGN (BITMAP, bmPlanes, 2)
    TEST_FIELD_OFFSET(BITMAP, bmPlanes, 16)
    TEST_FIELD_SIZE  (BITMAP, bmBitsPixel, 2)
    TEST_FIELD_ALIGN (BITMAP, bmBitsPixel, 2)
    TEST_FIELD_OFFSET(BITMAP, bmBitsPixel, 18)
    TEST_FIELD_SIZE  (BITMAP, bmBits, 4)
    TEST_FIELD_ALIGN (BITMAP, bmBits, 4)
    TEST_FIELD_OFFSET(BITMAP, bmBits, 20)
}

static void test_pack_BITMAPCOREHEADER(void)
{
    /* BITMAPCOREHEADER (pack 4) */
    TEST_TYPE_SIZE   (BITMAPCOREHEADER, 12)
    TEST_TYPE_ALIGN  (BITMAPCOREHEADER, 4)
    TEST_FIELD_SIZE  (BITMAPCOREHEADER, bcSize, 4)
    TEST_FIELD_ALIGN (BITMAPCOREHEADER, bcSize, 4)
    TEST_FIELD_OFFSET(BITMAPCOREHEADER, bcSize, 0)
    TEST_FIELD_SIZE  (BITMAPCOREHEADER, bcWidth, 2)
    TEST_FIELD_ALIGN (BITMAPCOREHEADER, bcWidth, 2)
    TEST_FIELD_OFFSET(BITMAPCOREHEADER, bcWidth, 4)
    TEST_FIELD_SIZE  (BITMAPCOREHEADER, bcHeight, 2)
    TEST_FIELD_ALIGN (BITMAPCOREHEADER, bcHeight, 2)
    TEST_FIELD_OFFSET(BITMAPCOREHEADER, bcHeight, 6)
    TEST_FIELD_SIZE  (BITMAPCOREHEADER, bcPlanes, 2)
    TEST_FIELD_ALIGN (BITMAPCOREHEADER, bcPlanes, 2)
    TEST_FIELD_OFFSET(BITMAPCOREHEADER, bcPlanes, 8)
    TEST_FIELD_SIZE  (BITMAPCOREHEADER, bcBitCount, 2)
    TEST_FIELD_ALIGN (BITMAPCOREHEADER, bcBitCount, 2)
    TEST_FIELD_OFFSET(BITMAPCOREHEADER, bcBitCount, 10)
}

static void test_pack_BITMAPCOREINFO(void)
{
    /* BITMAPCOREINFO (pack 4) */
    TEST_TYPE_SIZE   (BITMAPCOREINFO, 16)
    TEST_TYPE_ALIGN  (BITMAPCOREINFO, 4)
    TEST_FIELD_SIZE  (BITMAPCOREINFO, bmciHeader, 12)
    TEST_FIELD_ALIGN (BITMAPCOREINFO, bmciHeader, 4)
    TEST_FIELD_OFFSET(BITMAPCOREINFO, bmciHeader, 0)
    TEST_FIELD_SIZE  (BITMAPCOREINFO, bmciColors, 3)
    TEST_FIELD_ALIGN (BITMAPCOREINFO, bmciColors, 1)
    TEST_FIELD_OFFSET(BITMAPCOREINFO, bmciColors, 12)
}

static void test_pack_BITMAPFILEHEADER(void)
{
    /* BITMAPFILEHEADER (pack 2) */
    TEST_TYPE_SIZE   (BITMAPFILEHEADER, 14)
    TEST_TYPE_ALIGN  (BITMAPFILEHEADER, 2)
    TEST_FIELD_SIZE  (BITMAPFILEHEADER, bfType, 2)
    TEST_FIELD_ALIGN (BITMAPFILEHEADER, bfType, 2)
    TEST_FIELD_OFFSET(BITMAPFILEHEADER, bfType, 0)
    TEST_FIELD_SIZE  (BITMAPFILEHEADER, bfSize, 4)
    TEST_FIELD_ALIGN (BITMAPFILEHEADER, bfSize, 2)
    TEST_FIELD_OFFSET(BITMAPFILEHEADER, bfSize, 2)
    TEST_FIELD_SIZE  (BITMAPFILEHEADER, bfReserved1, 2)
    TEST_FIELD_ALIGN (BITMAPFILEHEADER, bfReserved1, 2)
    TEST_FIELD_OFFSET(BITMAPFILEHEADER, bfReserved1, 6)
    TEST_FIELD_SIZE  (BITMAPFILEHEADER, bfReserved2, 2)
    TEST_FIELD_ALIGN (BITMAPFILEHEADER, bfReserved2, 2)
    TEST_FIELD_OFFSET(BITMAPFILEHEADER, bfReserved2, 8)
    TEST_FIELD_SIZE  (BITMAPFILEHEADER, bfOffBits, 4)
    TEST_FIELD_ALIGN (BITMAPFILEHEADER, bfOffBits, 2)
    TEST_FIELD_OFFSET(BITMAPFILEHEADER, bfOffBits, 10)
}

static void test_pack_BITMAPINFO(void)
{
    /* BITMAPINFO (pack 4) */
    TEST_TYPE_SIZE   (BITMAPINFO, 44)
    TEST_TYPE_ALIGN  (BITMAPINFO, 4)
    TEST_FIELD_SIZE  (BITMAPINFO, bmiHeader, 40)
    TEST_FIELD_ALIGN (BITMAPINFO, bmiHeader, 4)
    TEST_FIELD_OFFSET(BITMAPINFO, bmiHeader, 0)
    TEST_FIELD_SIZE  (BITMAPINFO, bmiColors, 4)
    TEST_FIELD_ALIGN (BITMAPINFO, bmiColors, 1)
    TEST_FIELD_OFFSET(BITMAPINFO, bmiColors, 40)
}

static void test_pack_BITMAPINFOHEADER(void)
{
    /* BITMAPINFOHEADER (pack 4) */
    TEST_TYPE_SIZE   (BITMAPINFOHEADER, 40)
    TEST_TYPE_ALIGN  (BITMAPINFOHEADER, 4)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biSize, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biSize, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biSize, 0)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biWidth, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biWidth, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biWidth, 4)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biHeight, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biHeight, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biHeight, 8)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biPlanes, 2)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biPlanes, 2)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biPlanes, 12)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biBitCount, 2)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biBitCount, 2)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biBitCount, 14)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biCompression, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biCompression, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biCompression, 16)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biSizeImage, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biSizeImage, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biSizeImage, 20)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biXPelsPerMeter, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biXPelsPerMeter, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biXPelsPerMeter, 24)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biYPelsPerMeter, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biYPelsPerMeter, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biYPelsPerMeter, 28)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biClrUsed, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biClrUsed, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biClrUsed, 32)
    TEST_FIELD_SIZE  (BITMAPINFOHEADER, biClrImportant, 4)
    TEST_FIELD_ALIGN (BITMAPINFOHEADER, biClrImportant, 4)
    TEST_FIELD_OFFSET(BITMAPINFOHEADER, biClrImportant, 36)
}

static void test_pack_BITMAPV4HEADER(void)
{
    /* BITMAPV4HEADER (pack 4) */
    TEST_TYPE_SIZE   (BITMAPV4HEADER, 108)
    TEST_TYPE_ALIGN  (BITMAPV4HEADER, 4)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4Size, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4Size, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4Size, 0)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4Width, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4Width, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4Width, 4)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4Height, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4Height, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4Height, 8)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4Planes, 2)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4Planes, 2)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4Planes, 12)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4BitCount, 2)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4BitCount, 2)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4BitCount, 14)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4V4Compression, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4V4Compression, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4V4Compression, 16)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4SizeImage, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4SizeImage, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4SizeImage, 20)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4XPelsPerMeter, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4XPelsPerMeter, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4XPelsPerMeter, 24)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4YPelsPerMeter, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4YPelsPerMeter, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4YPelsPerMeter, 28)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4ClrUsed, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4ClrUsed, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4ClrUsed, 32)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4ClrImportant, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4ClrImportant, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4ClrImportant, 36)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4RedMask, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4RedMask, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4RedMask, 40)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4GreenMask, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4GreenMask, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4GreenMask, 44)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4BlueMask, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4BlueMask, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4BlueMask, 48)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4AlphaMask, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4AlphaMask, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4AlphaMask, 52)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4CSType, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4CSType, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4CSType, 56)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4Endpoints, 36)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4Endpoints, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4Endpoints, 60)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4GammaRed, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4GammaRed, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4GammaRed, 96)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4GammaGreen, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4GammaGreen, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4GammaGreen, 100)
    TEST_FIELD_SIZE  (BITMAPV4HEADER, bV4GammaBlue, 4)
    TEST_FIELD_ALIGN (BITMAPV4HEADER, bV4GammaBlue, 4)
    TEST_FIELD_OFFSET(BITMAPV4HEADER, bV4GammaBlue, 104)
}

static void test_pack_BITMAPV5HEADER(void)
{
    /* BITMAPV5HEADER (pack 4) */
    TEST_TYPE_SIZE   (BITMAPV5HEADER, 124)
    TEST_TYPE_ALIGN  (BITMAPV5HEADER, 4)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Size, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Size, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Size, 0)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Width, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Width, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Width, 4)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Height, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Height, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Height, 8)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Planes, 2)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Planes, 2)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Planes, 12)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5BitCount, 2)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5BitCount, 2)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5BitCount, 14)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Compression, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Compression, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Compression, 16)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5SizeImage, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5SizeImage, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5SizeImage, 20)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5XPelsPerMeter, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5XPelsPerMeter, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5XPelsPerMeter, 24)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5YPelsPerMeter, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5YPelsPerMeter, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5YPelsPerMeter, 28)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5ClrUsed, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5ClrUsed, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5ClrUsed, 32)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5ClrImportant, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5ClrImportant, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5ClrImportant, 36)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5RedMask, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5RedMask, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5RedMask, 40)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5GreenMask, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5GreenMask, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5GreenMask, 44)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5BlueMask, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5BlueMask, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5BlueMask, 48)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5AlphaMask, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5AlphaMask, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5AlphaMask, 52)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5CSType, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5CSType, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5CSType, 56)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Endpoints, 36)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Endpoints, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Endpoints, 60)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5GammaRed, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5GammaRed, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5GammaRed, 96)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5GammaGreen, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5GammaGreen, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5GammaGreen, 100)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5GammaBlue, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5GammaBlue, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5GammaBlue, 104)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Intent, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Intent, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Intent, 108)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5ProfileData, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5ProfileData, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5ProfileData, 112)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5ProfileSize, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5ProfileSize, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5ProfileSize, 116)
    TEST_FIELD_SIZE  (BITMAPV5HEADER, bV5Reserved, 4)
    TEST_FIELD_ALIGN (BITMAPV5HEADER, bV5Reserved, 4)
    TEST_FIELD_OFFSET(BITMAPV5HEADER, bV5Reserved, 120)
}

static void test_pack_BLENDFUNCTION(void)
{
    /* BLENDFUNCTION (pack 4) */
    TEST_TYPE_SIZE   (BLENDFUNCTION, 4)
    TEST_TYPE_ALIGN  (BLENDFUNCTION, 1)
    TEST_FIELD_SIZE  (BLENDFUNCTION, BlendOp, 1)
    TEST_FIELD_ALIGN (BLENDFUNCTION, BlendOp, 1)
    TEST_FIELD_OFFSET(BLENDFUNCTION, BlendOp, 0)
    TEST_FIELD_SIZE  (BLENDFUNCTION, BlendFlags, 1)
    TEST_FIELD_ALIGN (BLENDFUNCTION, BlendFlags, 1)
    TEST_FIELD_OFFSET(BLENDFUNCTION, BlendFlags, 1)
    TEST_FIELD_SIZE  (BLENDFUNCTION, SourceConstantAlpha, 1)
    TEST_FIELD_ALIGN (BLENDFUNCTION, SourceConstantAlpha, 1)
    TEST_FIELD_OFFSET(BLENDFUNCTION, SourceConstantAlpha, 2)
    TEST_FIELD_SIZE  (BLENDFUNCTION, AlphaFormat, 1)
    TEST_FIELD_ALIGN (BLENDFUNCTION, AlphaFormat, 1)
    TEST_FIELD_OFFSET(BLENDFUNCTION, AlphaFormat, 3)
}

static void test_pack_CHARSETINFO(void)
{
    /* CHARSETINFO (pack 4) */
    TEST_TYPE_SIZE   (CHARSETINFO, 32)
    TEST_TYPE_ALIGN  (CHARSETINFO, 4)
    TEST_FIELD_SIZE  (CHARSETINFO, ciCharset, 4)
    TEST_FIELD_ALIGN (CHARSETINFO, ciCharset, 4)
    TEST_FIELD_OFFSET(CHARSETINFO, ciCharset, 0)
    TEST_FIELD_SIZE  (CHARSETINFO, ciACP, 4)
    TEST_FIELD_ALIGN (CHARSETINFO, ciACP, 4)
    TEST_FIELD_OFFSET(CHARSETINFO, ciACP, 4)
    TEST_FIELD_SIZE  (CHARSETINFO, fs, 24)
    TEST_FIELD_ALIGN (CHARSETINFO, fs, 4)
    TEST_FIELD_OFFSET(CHARSETINFO, fs, 8)
}

static void test_pack_CIEXYZ(void)
{
    /* CIEXYZ (pack 4) */
    TEST_TYPE_SIZE   (CIEXYZ, 12)
    TEST_TYPE_ALIGN  (CIEXYZ, 4)
    TEST_FIELD_SIZE  (CIEXYZ, ciexyzX, 4)
    TEST_FIELD_ALIGN (CIEXYZ, ciexyzX, 4)
    TEST_FIELD_OFFSET(CIEXYZ, ciexyzX, 0)
    TEST_FIELD_SIZE  (CIEXYZ, ciexyzY, 4)
    TEST_FIELD_ALIGN (CIEXYZ, ciexyzY, 4)
    TEST_FIELD_OFFSET(CIEXYZ, ciexyzY, 4)
    TEST_FIELD_SIZE  (CIEXYZ, ciexyzZ, 4)
    TEST_FIELD_ALIGN (CIEXYZ, ciexyzZ, 4)
    TEST_FIELD_OFFSET(CIEXYZ, ciexyzZ, 8)
}

static void test_pack_CIEXYZTRIPLE(void)
{
    /* CIEXYZTRIPLE (pack 4) */
    TEST_TYPE_SIZE   (CIEXYZTRIPLE, 36)
    TEST_TYPE_ALIGN  (CIEXYZTRIPLE, 4)
    TEST_FIELD_SIZE  (CIEXYZTRIPLE, ciexyzRed, 12)
    TEST_FIELD_ALIGN (CIEXYZTRIPLE, ciexyzRed, 4)
    TEST_FIELD_OFFSET(CIEXYZTRIPLE, ciexyzRed, 0)
    TEST_FIELD_SIZE  (CIEXYZTRIPLE, ciexyzGreen, 12)
    TEST_FIELD_ALIGN (CIEXYZTRIPLE, ciexyzGreen, 4)
    TEST_FIELD_OFFSET(CIEXYZTRIPLE, ciexyzGreen, 12)
    TEST_FIELD_SIZE  (CIEXYZTRIPLE, ciexyzBlue, 12)
    TEST_FIELD_ALIGN (CIEXYZTRIPLE, ciexyzBlue, 4)
    TEST_FIELD_OFFSET(CIEXYZTRIPLE, ciexyzBlue, 24)
}

static void test_pack_COLOR16(void)
{
    /* COLOR16 */
    TEST_TYPE_SIZE   (COLOR16, 2)
    TEST_TYPE_ALIGN  (COLOR16, 2)
}

static void test_pack_COLORADJUSTMENT(void)
{
    /* COLORADJUSTMENT (pack 4) */
    TEST_TYPE_SIZE   (COLORADJUSTMENT, 24)
    TEST_TYPE_ALIGN  (COLORADJUSTMENT, 2)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caSize, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caSize, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caSize, 0)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caFlags, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caFlags, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caFlags, 2)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caIlluminantIndex, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caIlluminantIndex, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caIlluminantIndex, 4)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caRedGamma, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caRedGamma, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caRedGamma, 6)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caGreenGamma, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caGreenGamma, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caGreenGamma, 8)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caBlueGamma, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caBlueGamma, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caBlueGamma, 10)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caReferenceBlack, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caReferenceBlack, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caReferenceBlack, 12)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caReferenceWhite, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caReferenceWhite, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caReferenceWhite, 14)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caContrast, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caContrast, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caContrast, 16)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caBrightness, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caBrightness, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caBrightness, 18)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caColorfulness, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caColorfulness, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caColorfulness, 20)
    TEST_FIELD_SIZE  (COLORADJUSTMENT, caRedGreenTint, 2)
    TEST_FIELD_ALIGN (COLORADJUSTMENT, caRedGreenTint, 2)
    TEST_FIELD_OFFSET(COLORADJUSTMENT, caRedGreenTint, 22)
}

static void test_pack_DEVMODEA(void)
{
    /* DEVMODEA (pack 4) */
    TEST_FIELD_SIZE  (DEVMODEA, dmDeviceName, 32)
    TEST_FIELD_ALIGN (DEVMODEA, dmDeviceName, 1)
    TEST_FIELD_OFFSET(DEVMODEA, dmDeviceName, 0)
    TEST_FIELD_SIZE  (DEVMODEA, dmSpecVersion, 2)
    TEST_FIELD_ALIGN (DEVMODEA, dmSpecVersion, 2)
    TEST_FIELD_OFFSET(DEVMODEA, dmSpecVersion, 32)
    TEST_FIELD_SIZE  (DEVMODEA, dmDriverVersion, 2)
    TEST_FIELD_ALIGN (DEVMODEA, dmDriverVersion, 2)
    TEST_FIELD_OFFSET(DEVMODEA, dmDriverVersion, 34)
    TEST_FIELD_SIZE  (DEVMODEA, dmSize, 2)
    TEST_FIELD_ALIGN (DEVMODEA, dmSize, 2)
    TEST_FIELD_OFFSET(DEVMODEA, dmSize, 36)
    TEST_FIELD_SIZE  (DEVMODEA, dmDriverExtra, 2)
    TEST_FIELD_ALIGN (DEVMODEA, dmDriverExtra, 2)
    TEST_FIELD_OFFSET(DEVMODEA, dmDriverExtra, 38)
    TEST_FIELD_SIZE  (DEVMODEA, dmFields, 4)
    TEST_FIELD_ALIGN (DEVMODEA, dmFields, 4)
    TEST_FIELD_OFFSET(DEVMODEA, dmFields, 40)
}

static void test_pack_DEVMODEW(void)
{
    /* DEVMODEW (pack 4) */
    TEST_FIELD_SIZE  (DEVMODEW, dmDeviceName, 64)
    TEST_FIELD_ALIGN (DEVMODEW, dmDeviceName, 2)
    TEST_FIELD_OFFSET(DEVMODEW, dmDeviceName, 0)
    TEST_FIELD_SIZE  (DEVMODEW, dmSpecVersion, 2)
    TEST_FIELD_ALIGN (DEVMODEW, dmSpecVersion, 2)
    TEST_FIELD_OFFSET(DEVMODEW, dmSpecVersion, 64)
    TEST_FIELD_SIZE  (DEVMODEW, dmDriverVersion, 2)
    TEST_FIELD_ALIGN (DEVMODEW, dmDriverVersion, 2)
    TEST_FIELD_OFFSET(DEVMODEW, dmDriverVersion, 66)
    TEST_FIELD_SIZE  (DEVMODEW, dmSize, 2)
    TEST_FIELD_ALIGN (DEVMODEW, dmSize, 2)
    TEST_FIELD_OFFSET(DEVMODEW, dmSize, 68)
    TEST_FIELD_SIZE  (DEVMODEW, dmDriverExtra, 2)
    TEST_FIELD_ALIGN (DEVMODEW, dmDriverExtra, 2)
    TEST_FIELD_OFFSET(DEVMODEW, dmDriverExtra, 70)
    TEST_FIELD_SIZE  (DEVMODEW, dmFields, 4)
    TEST_FIELD_ALIGN (DEVMODEW, dmFields, 4)
    TEST_FIELD_OFFSET(DEVMODEW, dmFields, 72)
}

static void test_pack_DIBSECTION(void)
{
    /* DIBSECTION (pack 4) */
    TEST_TYPE_SIZE   (DIBSECTION, 84)
    TEST_TYPE_ALIGN  (DIBSECTION, 4)
    TEST_FIELD_SIZE  (DIBSECTION, dsBm, 24)
    TEST_FIELD_ALIGN (DIBSECTION, dsBm, 4)
    TEST_FIELD_OFFSET(DIBSECTION, dsBm, 0)
    TEST_FIELD_SIZE  (DIBSECTION, dsBmih, 40)
    TEST_FIELD_ALIGN (DIBSECTION, dsBmih, 4)
    TEST_FIELD_OFFSET(DIBSECTION, dsBmih, 24)
    TEST_FIELD_SIZE  (DIBSECTION, dsBitfields, 12)
    TEST_FIELD_ALIGN (DIBSECTION, dsBitfields, 4)
    TEST_FIELD_OFFSET(DIBSECTION, dsBitfields, 64)
    TEST_FIELD_SIZE  (DIBSECTION, dshSection, 4)
    TEST_FIELD_ALIGN (DIBSECTION, dshSection, 4)
    TEST_FIELD_OFFSET(DIBSECTION, dshSection, 76)
    TEST_FIELD_SIZE  (DIBSECTION, dsOffset, 4)
    TEST_FIELD_ALIGN (DIBSECTION, dsOffset, 4)
    TEST_FIELD_OFFSET(DIBSECTION, dsOffset, 80)
}

static void test_pack_DISPLAY_DEVICEA(void)
{
    /* DISPLAY_DEVICEA (pack 4) */
    TEST_TYPE_SIZE   (DISPLAY_DEVICEA, 424)
    TEST_TYPE_ALIGN  (DISPLAY_DEVICEA, 4)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEA, cb, 4)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEA, cb, 4)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEA, cb, 0)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEA, DeviceName, 32)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEA, DeviceName, 1)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEA, DeviceName, 4)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEA, DeviceString, 128)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEA, DeviceString, 1)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEA, DeviceString, 36)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEA, StateFlags, 4)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEA, StateFlags, 4)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEA, StateFlags, 164)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEA, DeviceID, 128)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEA, DeviceID, 1)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEA, DeviceID, 168)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEA, DeviceKey, 128)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEA, DeviceKey, 1)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEA, DeviceKey, 296)
}

static void test_pack_DISPLAY_DEVICEW(void)
{
    /* DISPLAY_DEVICEW (pack 4) */
    TEST_TYPE_SIZE   (DISPLAY_DEVICEW, 840)
    TEST_TYPE_ALIGN  (DISPLAY_DEVICEW, 4)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEW, cb, 4)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEW, cb, 4)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEW, cb, 0)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEW, DeviceName, 64)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEW, DeviceName, 2)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEW, DeviceName, 4)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEW, DeviceString, 256)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEW, DeviceString, 2)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEW, DeviceString, 68)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEW, StateFlags, 4)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEW, StateFlags, 4)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEW, StateFlags, 324)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEW, DeviceID, 256)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEW, DeviceID, 2)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEW, DeviceID, 328)
    TEST_FIELD_SIZE  (DISPLAY_DEVICEW, DeviceKey, 256)
    TEST_FIELD_ALIGN (DISPLAY_DEVICEW, DeviceKey, 2)
    TEST_FIELD_OFFSET(DISPLAY_DEVICEW, DeviceKey, 584)
}

static void test_pack_DOCINFOA(void)
{
    /* DOCINFOA (pack 4) */
    TEST_TYPE_SIZE   (DOCINFOA, 20)
    TEST_TYPE_ALIGN  (DOCINFOA, 4)
    TEST_FIELD_SIZE  (DOCINFOA, cbSize, 4)
    TEST_FIELD_ALIGN (DOCINFOA, cbSize, 4)
    TEST_FIELD_OFFSET(DOCINFOA, cbSize, 0)
    TEST_FIELD_SIZE  (DOCINFOA, lpszDocName, 4)
    TEST_FIELD_ALIGN (DOCINFOA, lpszDocName, 4)
    TEST_FIELD_OFFSET(DOCINFOA, lpszDocName, 4)
    TEST_FIELD_SIZE  (DOCINFOA, lpszOutput, 4)
    TEST_FIELD_ALIGN (DOCINFOA, lpszOutput, 4)
    TEST_FIELD_OFFSET(DOCINFOA, lpszOutput, 8)
    TEST_FIELD_SIZE  (DOCINFOA, lpszDatatype, 4)
    TEST_FIELD_ALIGN (DOCINFOA, lpszDatatype, 4)
    TEST_FIELD_OFFSET(DOCINFOA, lpszDatatype, 12)
    TEST_FIELD_SIZE  (DOCINFOA, fwType, 4)
    TEST_FIELD_ALIGN (DOCINFOA, fwType, 4)
    TEST_FIELD_OFFSET(DOCINFOA, fwType, 16)
}

static void test_pack_DOCINFOW(void)
{
    /* DOCINFOW (pack 4) */
    TEST_TYPE_SIZE   (DOCINFOW, 20)
    TEST_TYPE_ALIGN  (DOCINFOW, 4)
    TEST_FIELD_SIZE  (DOCINFOW, cbSize, 4)
    TEST_FIELD_ALIGN (DOCINFOW, cbSize, 4)
    TEST_FIELD_OFFSET(DOCINFOW, cbSize, 0)
    TEST_FIELD_SIZE  (DOCINFOW, lpszDocName, 4)
    TEST_FIELD_ALIGN (DOCINFOW, lpszDocName, 4)
    TEST_FIELD_OFFSET(DOCINFOW, lpszDocName, 4)
    TEST_FIELD_SIZE  (DOCINFOW, lpszOutput, 4)
    TEST_FIELD_ALIGN (DOCINFOW, lpszOutput, 4)
    TEST_FIELD_OFFSET(DOCINFOW, lpszOutput, 8)
    TEST_FIELD_SIZE  (DOCINFOW, lpszDatatype, 4)
    TEST_FIELD_ALIGN (DOCINFOW, lpszDatatype, 4)
    TEST_FIELD_OFFSET(DOCINFOW, lpszDatatype, 12)
    TEST_FIELD_SIZE  (DOCINFOW, fwType, 4)
    TEST_FIELD_ALIGN (DOCINFOW, fwType, 4)
    TEST_FIELD_OFFSET(DOCINFOW, fwType, 16)
}

static void test_pack_EMR(void)
{
    /* EMR (pack 4) */
    TEST_TYPE_SIZE   (EMR, 8)
    TEST_TYPE_ALIGN  (EMR, 4)
    TEST_FIELD_SIZE  (EMR, iType, 4)
    TEST_FIELD_ALIGN (EMR, iType, 4)
    TEST_FIELD_OFFSET(EMR, iType, 0)
    TEST_FIELD_SIZE  (EMR, nSize, 4)
    TEST_FIELD_ALIGN (EMR, nSize, 4)
    TEST_FIELD_OFFSET(EMR, nSize, 4)
}

static void test_pack_EMRABORTPATH(void)
{
    /* EMRABORTPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRABORTPATH, 8)
    TEST_TYPE_ALIGN  (EMRABORTPATH, 4)
    TEST_FIELD_SIZE  (EMRABORTPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRABORTPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRABORTPATH, emr, 0)
}

static void test_pack_EMRANGLEARC(void)
{
    /* EMRANGLEARC (pack 4) */
    TEST_TYPE_SIZE   (EMRANGLEARC, 28)
    TEST_TYPE_ALIGN  (EMRANGLEARC, 4)
    TEST_FIELD_SIZE  (EMRANGLEARC, emr, 8)
    TEST_FIELD_ALIGN (EMRANGLEARC, emr, 4)
    TEST_FIELD_OFFSET(EMRANGLEARC, emr, 0)
    TEST_FIELD_SIZE  (EMRANGLEARC, ptlCenter, 8)
    TEST_FIELD_ALIGN (EMRANGLEARC, ptlCenter, 4)
    TEST_FIELD_OFFSET(EMRANGLEARC, ptlCenter, 8)
    TEST_FIELD_SIZE  (EMRANGLEARC, nRadius, 4)
    TEST_FIELD_ALIGN (EMRANGLEARC, nRadius, 4)
    TEST_FIELD_OFFSET(EMRANGLEARC, nRadius, 16)
    TEST_FIELD_SIZE  (EMRANGLEARC, eStartAngle, 4)
    TEST_FIELD_ALIGN (EMRANGLEARC, eStartAngle, 4)
    TEST_FIELD_OFFSET(EMRANGLEARC, eStartAngle, 20)
    TEST_FIELD_SIZE  (EMRANGLEARC, eSweepAngle, 4)
    TEST_FIELD_ALIGN (EMRANGLEARC, eSweepAngle, 4)
    TEST_FIELD_OFFSET(EMRANGLEARC, eSweepAngle, 24)
}

static void test_pack_EMRARC(void)
{
    /* EMRARC (pack 4) */
    TEST_TYPE_SIZE   (EMRARC, 40)
    TEST_TYPE_ALIGN  (EMRARC, 4)
    TEST_FIELD_SIZE  (EMRARC, emr, 8)
    TEST_FIELD_ALIGN (EMRARC, emr, 4)
    TEST_FIELD_OFFSET(EMRARC, emr, 0)
    TEST_FIELD_SIZE  (EMRARC, rclBox, 16)
    TEST_FIELD_ALIGN (EMRARC, rclBox, 4)
    TEST_FIELD_OFFSET(EMRARC, rclBox, 8)
    TEST_FIELD_SIZE  (EMRARC, ptlStart, 8)
    TEST_FIELD_ALIGN (EMRARC, ptlStart, 4)
    TEST_FIELD_OFFSET(EMRARC, ptlStart, 24)
    TEST_FIELD_SIZE  (EMRARC, ptlEnd, 8)
    TEST_FIELD_ALIGN (EMRARC, ptlEnd, 4)
    TEST_FIELD_OFFSET(EMRARC, ptlEnd, 32)
}

static void test_pack_EMRARCTO(void)
{
    /* EMRARCTO (pack 4) */
    TEST_TYPE_SIZE   (EMRARCTO, 40)
    TEST_TYPE_ALIGN  (EMRARCTO, 4)
    TEST_FIELD_SIZE  (EMRARCTO, emr, 8)
    TEST_FIELD_ALIGN (EMRARCTO, emr, 4)
    TEST_FIELD_OFFSET(EMRARCTO, emr, 0)
    TEST_FIELD_SIZE  (EMRARCTO, rclBox, 16)
    TEST_FIELD_ALIGN (EMRARCTO, rclBox, 4)
    TEST_FIELD_OFFSET(EMRARCTO, rclBox, 8)
    TEST_FIELD_SIZE  (EMRARCTO, ptlStart, 8)
    TEST_FIELD_ALIGN (EMRARCTO, ptlStart, 4)
    TEST_FIELD_OFFSET(EMRARCTO, ptlStart, 24)
    TEST_FIELD_SIZE  (EMRARCTO, ptlEnd, 8)
    TEST_FIELD_ALIGN (EMRARCTO, ptlEnd, 4)
    TEST_FIELD_OFFSET(EMRARCTO, ptlEnd, 32)
}

static void test_pack_EMRBEGINPATH(void)
{
    /* EMRBEGINPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRBEGINPATH, 8)
    TEST_TYPE_ALIGN  (EMRBEGINPATH, 4)
    TEST_FIELD_SIZE  (EMRBEGINPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRBEGINPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRBEGINPATH, emr, 0)
}

static void test_pack_EMRBITBLT(void)
{
    /* EMRBITBLT (pack 4) */
    TEST_TYPE_SIZE   (EMRBITBLT, 100)
    TEST_TYPE_ALIGN  (EMRBITBLT, 4)
    TEST_FIELD_SIZE  (EMRBITBLT, emr, 8)
    TEST_FIELD_ALIGN (EMRBITBLT, emr, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, emr, 0)
    TEST_FIELD_SIZE  (EMRBITBLT, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRBITBLT, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRBITBLT, xDest, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, xDest, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, xDest, 24)
    TEST_FIELD_SIZE  (EMRBITBLT, yDest, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, yDest, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, yDest, 28)
    TEST_FIELD_SIZE  (EMRBITBLT, cxDest, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, cxDest, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, cxDest, 32)
    TEST_FIELD_SIZE  (EMRBITBLT, cyDest, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, cyDest, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, cyDest, 36)
    TEST_FIELD_SIZE  (EMRBITBLT, dwRop, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, dwRop, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, dwRop, 40)
    TEST_FIELD_SIZE  (EMRBITBLT, xSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, xSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, xSrc, 44)
    TEST_FIELD_SIZE  (EMRBITBLT, ySrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, ySrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, ySrc, 48)
    TEST_FIELD_SIZE  (EMRBITBLT, xformSrc, 24)
    TEST_FIELD_ALIGN (EMRBITBLT, xformSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, xformSrc, 52)
    TEST_FIELD_SIZE  (EMRBITBLT, crBkColorSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, crBkColorSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, crBkColorSrc, 76)
    TEST_FIELD_SIZE  (EMRBITBLT, iUsageSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, iUsageSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, iUsageSrc, 80)
    TEST_FIELD_SIZE  (EMRBITBLT, offBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, offBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, offBmiSrc, 84)
    TEST_FIELD_SIZE  (EMRBITBLT, cbBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, cbBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, cbBmiSrc, 88)
    TEST_FIELD_SIZE  (EMRBITBLT, offBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, offBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, offBitsSrc, 92)
    TEST_FIELD_SIZE  (EMRBITBLT, cbBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRBITBLT, cbBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRBITBLT, cbBitsSrc, 96)
}

static void test_pack_EMRCHORD(void)
{
    /* EMRCHORD (pack 4) */
    TEST_TYPE_SIZE   (EMRCHORD, 40)
    TEST_TYPE_ALIGN  (EMRCHORD, 4)
    TEST_FIELD_SIZE  (EMRCHORD, emr, 8)
    TEST_FIELD_ALIGN (EMRCHORD, emr, 4)
    TEST_FIELD_OFFSET(EMRCHORD, emr, 0)
    TEST_FIELD_SIZE  (EMRCHORD, rclBox, 16)
    TEST_FIELD_ALIGN (EMRCHORD, rclBox, 4)
    TEST_FIELD_OFFSET(EMRCHORD, rclBox, 8)
    TEST_FIELD_SIZE  (EMRCHORD, ptlStart, 8)
    TEST_FIELD_ALIGN (EMRCHORD, ptlStart, 4)
    TEST_FIELD_OFFSET(EMRCHORD, ptlStart, 24)
    TEST_FIELD_SIZE  (EMRCHORD, ptlEnd, 8)
    TEST_FIELD_ALIGN (EMRCHORD, ptlEnd, 4)
    TEST_FIELD_OFFSET(EMRCHORD, ptlEnd, 32)
}

static void test_pack_EMRCLOSEFIGURE(void)
{
    /* EMRCLOSEFIGURE (pack 4) */
    TEST_TYPE_SIZE   (EMRCLOSEFIGURE, 8)
    TEST_TYPE_ALIGN  (EMRCLOSEFIGURE, 4)
    TEST_FIELD_SIZE  (EMRCLOSEFIGURE, emr, 8)
    TEST_FIELD_ALIGN (EMRCLOSEFIGURE, emr, 4)
    TEST_FIELD_OFFSET(EMRCLOSEFIGURE, emr, 0)
}

static void test_pack_EMRCREATEBRUSHINDIRECT(void)
{
    /* EMRCREATEBRUSHINDIRECT (pack 4) */
    TEST_TYPE_SIZE   (EMRCREATEBRUSHINDIRECT, 24)
    TEST_TYPE_ALIGN  (EMRCREATEBRUSHINDIRECT, 4)
    TEST_FIELD_SIZE  (EMRCREATEBRUSHINDIRECT, emr, 8)
    TEST_FIELD_ALIGN (EMRCREATEBRUSHINDIRECT, emr, 4)
    TEST_FIELD_OFFSET(EMRCREATEBRUSHINDIRECT, emr, 0)
    TEST_FIELD_SIZE  (EMRCREATEBRUSHINDIRECT, ihBrush, 4)
    TEST_FIELD_ALIGN (EMRCREATEBRUSHINDIRECT, ihBrush, 4)
    TEST_FIELD_OFFSET(EMRCREATEBRUSHINDIRECT, ihBrush, 8)
    TEST_FIELD_SIZE  (EMRCREATEBRUSHINDIRECT, lb, 12)
    TEST_FIELD_ALIGN (EMRCREATEBRUSHINDIRECT, lb, 4)
    TEST_FIELD_OFFSET(EMRCREATEBRUSHINDIRECT, lb, 12)
}

static void test_pack_EMRCREATECOLORSPACE(void)
{
    /* EMRCREATECOLORSPACE (pack 4) */
    TEST_TYPE_SIZE   (EMRCREATECOLORSPACE, 340)
    TEST_TYPE_ALIGN  (EMRCREATECOLORSPACE, 4)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACE, emr, 8)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACE, emr, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACE, emr, 0)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACE, ihCS, 4)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACE, ihCS, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACE, ihCS, 8)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACE, lcs, 328)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACE, lcs, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACE, lcs, 12)
}

static void test_pack_EMRCREATECOLORSPACEW(void)
{
    /* EMRCREATECOLORSPACEW (pack 4) */
    TEST_TYPE_SIZE   (EMRCREATECOLORSPACEW, 612)
    TEST_TYPE_ALIGN  (EMRCREATECOLORSPACEW, 4)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACEW, emr, 8)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACEW, emr, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACEW, emr, 0)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACEW, ihCS, 4)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACEW, ihCS, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACEW, ihCS, 8)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACEW, lcs, 588)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACEW, lcs, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACEW, lcs, 12)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACEW, dwFlags, 4)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACEW, dwFlags, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACEW, dwFlags, 600)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACEW, cbData, 4)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACEW, cbData, 4)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACEW, cbData, 604)
    TEST_FIELD_SIZE  (EMRCREATECOLORSPACEW, Data, 1)
    TEST_FIELD_ALIGN (EMRCREATECOLORSPACEW, Data, 1)
    TEST_FIELD_OFFSET(EMRCREATECOLORSPACEW, Data, 608)
}

static void test_pack_EMRCREATEDIBPATTERNBRUSHPT(void)
{
    /* EMRCREATEDIBPATTERNBRUSHPT (pack 4) */
    TEST_TYPE_SIZE   (EMRCREATEDIBPATTERNBRUSHPT, 32)
    TEST_TYPE_ALIGN  (EMRCREATEDIBPATTERNBRUSHPT, 4)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, emr, 8)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, emr, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, emr, 0)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, ihBrush, 4)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, ihBrush, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, ihBrush, 8)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, iUsage, 4)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, iUsage, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, iUsage, 12)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, offBmi, 4)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, offBmi, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, offBmi, 16)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, cbBmi, 4)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, cbBmi, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, cbBmi, 20)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, offBits, 4)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, offBits, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, offBits, 24)
    TEST_FIELD_SIZE  (EMRCREATEDIBPATTERNBRUSHPT, cbBits, 4)
    TEST_FIELD_ALIGN (EMRCREATEDIBPATTERNBRUSHPT, cbBits, 4)
    TEST_FIELD_OFFSET(EMRCREATEDIBPATTERNBRUSHPT, cbBits, 28)
}

static void test_pack_EMRCREATEMONOBRUSH(void)
{
    /* EMRCREATEMONOBRUSH (pack 4) */
    TEST_TYPE_SIZE   (EMRCREATEMONOBRUSH, 32)
    TEST_TYPE_ALIGN  (EMRCREATEMONOBRUSH, 4)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, emr, 8)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, emr, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, emr, 0)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, ihBrush, 4)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, ihBrush, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, ihBrush, 8)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, iUsage, 4)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, iUsage, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, iUsage, 12)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, offBmi, 4)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, offBmi, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, offBmi, 16)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, cbBmi, 4)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, cbBmi, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, cbBmi, 20)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, offBits, 4)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, offBits, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, offBits, 24)
    TEST_FIELD_SIZE  (EMRCREATEMONOBRUSH, cbBits, 4)
    TEST_FIELD_ALIGN (EMRCREATEMONOBRUSH, cbBits, 4)
    TEST_FIELD_OFFSET(EMRCREATEMONOBRUSH, cbBits, 28)
}

static void test_pack_EMRCREATEPEN(void)
{
    /* EMRCREATEPEN (pack 4) */
    TEST_TYPE_SIZE   (EMRCREATEPEN, 28)
    TEST_TYPE_ALIGN  (EMRCREATEPEN, 4)
    TEST_FIELD_SIZE  (EMRCREATEPEN, emr, 8)
    TEST_FIELD_ALIGN (EMRCREATEPEN, emr, 4)
    TEST_FIELD_OFFSET(EMRCREATEPEN, emr, 0)
    TEST_FIELD_SIZE  (EMRCREATEPEN, ihPen, 4)
    TEST_FIELD_ALIGN (EMRCREATEPEN, ihPen, 4)
    TEST_FIELD_OFFSET(EMRCREATEPEN, ihPen, 8)
    TEST_FIELD_SIZE  (EMRCREATEPEN, lopn, 16)
    TEST_FIELD_ALIGN (EMRCREATEPEN, lopn, 4)
    TEST_FIELD_OFFSET(EMRCREATEPEN, lopn, 12)
}

static void test_pack_EMRDELETECOLORSPACE(void)
{
    /* EMRDELETECOLORSPACE (pack 4) */
    TEST_TYPE_SIZE   (EMRDELETECOLORSPACE, 12)
    TEST_TYPE_ALIGN  (EMRDELETECOLORSPACE, 4)
    TEST_FIELD_SIZE  (EMRDELETECOLORSPACE, emr, 8)
    TEST_FIELD_ALIGN (EMRDELETECOLORSPACE, emr, 4)
    TEST_FIELD_OFFSET(EMRDELETECOLORSPACE, emr, 0)
    TEST_FIELD_SIZE  (EMRDELETECOLORSPACE, ihCS, 4)
    TEST_FIELD_ALIGN (EMRDELETECOLORSPACE, ihCS, 4)
    TEST_FIELD_OFFSET(EMRDELETECOLORSPACE, ihCS, 8)
}

static void test_pack_EMRDELETEOBJECT(void)
{
    /* EMRDELETEOBJECT (pack 4) */
    TEST_TYPE_SIZE   (EMRDELETEOBJECT, 12)
    TEST_TYPE_ALIGN  (EMRDELETEOBJECT, 4)
    TEST_FIELD_SIZE  (EMRDELETEOBJECT, emr, 8)
    TEST_FIELD_ALIGN (EMRDELETEOBJECT, emr, 4)
    TEST_FIELD_OFFSET(EMRDELETEOBJECT, emr, 0)
    TEST_FIELD_SIZE  (EMRDELETEOBJECT, ihObject, 4)
    TEST_FIELD_ALIGN (EMRDELETEOBJECT, ihObject, 4)
    TEST_FIELD_OFFSET(EMRDELETEOBJECT, ihObject, 8)
}

static void test_pack_EMRELLIPSE(void)
{
    /* EMRELLIPSE (pack 4) */
    TEST_TYPE_SIZE   (EMRELLIPSE, 24)
    TEST_TYPE_ALIGN  (EMRELLIPSE, 4)
    TEST_FIELD_SIZE  (EMRELLIPSE, emr, 8)
    TEST_FIELD_ALIGN (EMRELLIPSE, emr, 4)
    TEST_FIELD_OFFSET(EMRELLIPSE, emr, 0)
    TEST_FIELD_SIZE  (EMRELLIPSE, rclBox, 16)
    TEST_FIELD_ALIGN (EMRELLIPSE, rclBox, 4)
    TEST_FIELD_OFFSET(EMRELLIPSE, rclBox, 8)
}

static void test_pack_EMRENDPATH(void)
{
    /* EMRENDPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRENDPATH, 8)
    TEST_TYPE_ALIGN  (EMRENDPATH, 4)
    TEST_FIELD_SIZE  (EMRENDPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRENDPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRENDPATH, emr, 0)
}

static void test_pack_EMREOF(void)
{
    /* EMREOF (pack 4) */
    TEST_TYPE_SIZE   (EMREOF, 20)
    TEST_TYPE_ALIGN  (EMREOF, 4)
    TEST_FIELD_SIZE  (EMREOF, emr, 8)
    TEST_FIELD_ALIGN (EMREOF, emr, 4)
    TEST_FIELD_OFFSET(EMREOF, emr, 0)
    TEST_FIELD_SIZE  (EMREOF, nPalEntries, 4)
    TEST_FIELD_ALIGN (EMREOF, nPalEntries, 4)
    TEST_FIELD_OFFSET(EMREOF, nPalEntries, 8)
    TEST_FIELD_SIZE  (EMREOF, offPalEntries, 4)
    TEST_FIELD_ALIGN (EMREOF, offPalEntries, 4)
    TEST_FIELD_OFFSET(EMREOF, offPalEntries, 12)
    TEST_FIELD_SIZE  (EMREOF, nSizeLast, 4)
    TEST_FIELD_ALIGN (EMREOF, nSizeLast, 4)
    TEST_FIELD_OFFSET(EMREOF, nSizeLast, 16)
}

static void test_pack_EMREXCLUDECLIPRECT(void)
{
    /* EMREXCLUDECLIPRECT (pack 4) */
    TEST_TYPE_SIZE   (EMREXCLUDECLIPRECT, 24)
    TEST_TYPE_ALIGN  (EMREXCLUDECLIPRECT, 4)
    TEST_FIELD_SIZE  (EMREXCLUDECLIPRECT, emr, 8)
    TEST_FIELD_ALIGN (EMREXCLUDECLIPRECT, emr, 4)
    TEST_FIELD_OFFSET(EMREXCLUDECLIPRECT, emr, 0)
    TEST_FIELD_SIZE  (EMREXCLUDECLIPRECT, rclClip, 16)
    TEST_FIELD_ALIGN (EMREXCLUDECLIPRECT, rclClip, 4)
    TEST_FIELD_OFFSET(EMREXCLUDECLIPRECT, rclClip, 8)
}

static void test_pack_EMREXTCREATEFONTINDIRECTW(void)
{
    /* EMREXTCREATEFONTINDIRECTW (pack 4) */
    TEST_TYPE_SIZE   (EMREXTCREATEFONTINDIRECTW, 332)
    TEST_TYPE_ALIGN  (EMREXTCREATEFONTINDIRECTW, 4)
    TEST_FIELD_SIZE  (EMREXTCREATEFONTINDIRECTW, emr, 8)
    TEST_FIELD_ALIGN (EMREXTCREATEFONTINDIRECTW, emr, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEFONTINDIRECTW, emr, 0)
    TEST_FIELD_SIZE  (EMREXTCREATEFONTINDIRECTW, ihFont, 4)
    TEST_FIELD_ALIGN (EMREXTCREATEFONTINDIRECTW, ihFont, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEFONTINDIRECTW, ihFont, 8)
    TEST_FIELD_SIZE  (EMREXTCREATEFONTINDIRECTW, elfw, 320)
    TEST_FIELD_ALIGN (EMREXTCREATEFONTINDIRECTW, elfw, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEFONTINDIRECTW, elfw, 12)
}

static void test_pack_EMREXTCREATEPEN(void)
{
    /* EMREXTCREATEPEN (pack 4) */
    TEST_TYPE_SIZE   (EMREXTCREATEPEN, 56)
    TEST_TYPE_ALIGN  (EMREXTCREATEPEN, 4)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, emr, 8)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, emr, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, emr, 0)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, ihPen, 4)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, ihPen, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, ihPen, 8)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, offBmi, 4)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, offBmi, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, offBmi, 12)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, cbBmi, 4)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, cbBmi, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, cbBmi, 16)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, offBits, 4)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, offBits, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, offBits, 20)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, cbBits, 4)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, cbBits, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, cbBits, 24)
    TEST_FIELD_SIZE  (EMREXTCREATEPEN, elp, 28)
    TEST_FIELD_ALIGN (EMREXTCREATEPEN, elp, 4)
    TEST_FIELD_OFFSET(EMREXTCREATEPEN, elp, 28)
}

static void test_pack_EMREXTFLOODFILL(void)
{
    /* EMREXTFLOODFILL (pack 4) */
    TEST_TYPE_SIZE   (EMREXTFLOODFILL, 24)
    TEST_TYPE_ALIGN  (EMREXTFLOODFILL, 4)
    TEST_FIELD_SIZE  (EMREXTFLOODFILL, emr, 8)
    TEST_FIELD_ALIGN (EMREXTFLOODFILL, emr, 4)
    TEST_FIELD_OFFSET(EMREXTFLOODFILL, emr, 0)
    TEST_FIELD_SIZE  (EMREXTFLOODFILL, ptlStart, 8)
    TEST_FIELD_ALIGN (EMREXTFLOODFILL, ptlStart, 4)
    TEST_FIELD_OFFSET(EMREXTFLOODFILL, ptlStart, 8)
    TEST_FIELD_SIZE  (EMREXTFLOODFILL, crColor, 4)
    TEST_FIELD_ALIGN (EMREXTFLOODFILL, crColor, 4)
    TEST_FIELD_OFFSET(EMREXTFLOODFILL, crColor, 16)
    TEST_FIELD_SIZE  (EMREXTFLOODFILL, iMode, 4)
    TEST_FIELD_ALIGN (EMREXTFLOODFILL, iMode, 4)
    TEST_FIELD_OFFSET(EMREXTFLOODFILL, iMode, 20)
}

static void test_pack_EMREXTSELECTCLIPRGN(void)
{
    /* EMREXTSELECTCLIPRGN (pack 4) */
    TEST_TYPE_SIZE   (EMREXTSELECTCLIPRGN, 20)
    TEST_TYPE_ALIGN  (EMREXTSELECTCLIPRGN, 4)
    TEST_FIELD_SIZE  (EMREXTSELECTCLIPRGN, emr, 8)
    TEST_FIELD_ALIGN (EMREXTSELECTCLIPRGN, emr, 4)
    TEST_FIELD_OFFSET(EMREXTSELECTCLIPRGN, emr, 0)
    TEST_FIELD_SIZE  (EMREXTSELECTCLIPRGN, cbRgnData, 4)
    TEST_FIELD_ALIGN (EMREXTSELECTCLIPRGN, cbRgnData, 4)
    TEST_FIELD_OFFSET(EMREXTSELECTCLIPRGN, cbRgnData, 8)
    TEST_FIELD_SIZE  (EMREXTSELECTCLIPRGN, iMode, 4)
    TEST_FIELD_ALIGN (EMREXTSELECTCLIPRGN, iMode, 4)
    TEST_FIELD_OFFSET(EMREXTSELECTCLIPRGN, iMode, 12)
    TEST_FIELD_SIZE  (EMREXTSELECTCLIPRGN, RgnData, 1)
    TEST_FIELD_ALIGN (EMREXTSELECTCLIPRGN, RgnData, 1)
    TEST_FIELD_OFFSET(EMREXTSELECTCLIPRGN, RgnData, 16)
}

static void test_pack_EMREXTTEXTOUTA(void)
{
    /* EMREXTTEXTOUTA (pack 4) */
    TEST_TYPE_SIZE   (EMREXTTEXTOUTA, 76)
    TEST_TYPE_ALIGN  (EMREXTTEXTOUTA, 4)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTA, emr, 8)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTA, emr, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTA, emr, 0)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTA, rclBounds, 16)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTA, rclBounds, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTA, rclBounds, 8)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTA, iGraphicsMode, 4)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTA, iGraphicsMode, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTA, iGraphicsMode, 24)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTA, exScale, 4)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTA, exScale, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTA, exScale, 28)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTA, eyScale, 4)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTA, eyScale, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTA, eyScale, 32)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTA, emrtext, 40)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTA, emrtext, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTA, emrtext, 36)
}

static void test_pack_EMREXTTEXTOUTW(void)
{
    /* EMREXTTEXTOUTW (pack 4) */
    TEST_TYPE_SIZE   (EMREXTTEXTOUTW, 76)
    TEST_TYPE_ALIGN  (EMREXTTEXTOUTW, 4)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTW, emr, 8)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTW, emr, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTW, emr, 0)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTW, rclBounds, 16)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTW, rclBounds, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTW, rclBounds, 8)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTW, iGraphicsMode, 4)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTW, iGraphicsMode, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTW, iGraphicsMode, 24)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTW, exScale, 4)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTW, exScale, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTW, exScale, 28)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTW, eyScale, 4)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTW, eyScale, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTW, eyScale, 32)
    TEST_FIELD_SIZE  (EMREXTTEXTOUTW, emrtext, 40)
    TEST_FIELD_ALIGN (EMREXTTEXTOUTW, emrtext, 4)
    TEST_FIELD_OFFSET(EMREXTTEXTOUTW, emrtext, 36)
}

static void test_pack_EMRFILLPATH(void)
{
    /* EMRFILLPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRFILLPATH, 24)
    TEST_TYPE_ALIGN  (EMRFILLPATH, 4)
    TEST_FIELD_SIZE  (EMRFILLPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRFILLPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRFILLPATH, emr, 0)
    TEST_FIELD_SIZE  (EMRFILLPATH, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRFILLPATH, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRFILLPATH, rclBounds, 8)
}

static void test_pack_EMRFILLRGN(void)
{
    /* EMRFILLRGN (pack 4) */
    TEST_TYPE_SIZE   (EMRFILLRGN, 36)
    TEST_TYPE_ALIGN  (EMRFILLRGN, 4)
    TEST_FIELD_SIZE  (EMRFILLRGN, emr, 8)
    TEST_FIELD_ALIGN (EMRFILLRGN, emr, 4)
    TEST_FIELD_OFFSET(EMRFILLRGN, emr, 0)
    TEST_FIELD_SIZE  (EMRFILLRGN, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRFILLRGN, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRFILLRGN, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRFILLRGN, cbRgnData, 4)
    TEST_FIELD_ALIGN (EMRFILLRGN, cbRgnData, 4)
    TEST_FIELD_OFFSET(EMRFILLRGN, cbRgnData, 24)
    TEST_FIELD_SIZE  (EMRFILLRGN, ihBrush, 4)
    TEST_FIELD_ALIGN (EMRFILLRGN, ihBrush, 4)
    TEST_FIELD_OFFSET(EMRFILLRGN, ihBrush, 28)
    TEST_FIELD_SIZE  (EMRFILLRGN, RgnData, 1)
    TEST_FIELD_ALIGN (EMRFILLRGN, RgnData, 1)
    TEST_FIELD_OFFSET(EMRFILLRGN, RgnData, 32)
}

static void test_pack_EMRFLATTENPATH(void)
{
    /* EMRFLATTENPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRFLATTENPATH, 8)
    TEST_TYPE_ALIGN  (EMRFLATTENPATH, 4)
    TEST_FIELD_SIZE  (EMRFLATTENPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRFLATTENPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRFLATTENPATH, emr, 0)
}

static void test_pack_EMRFORMAT(void)
{
    /* EMRFORMAT (pack 4) */
    TEST_TYPE_SIZE   (EMRFORMAT, 16)
    TEST_TYPE_ALIGN  (EMRFORMAT, 4)
    TEST_FIELD_SIZE  (EMRFORMAT, dSignature, 4)
    TEST_FIELD_ALIGN (EMRFORMAT, dSignature, 4)
    TEST_FIELD_OFFSET(EMRFORMAT, dSignature, 0)
    TEST_FIELD_SIZE  (EMRFORMAT, nVersion, 4)
    TEST_FIELD_ALIGN (EMRFORMAT, nVersion, 4)
    TEST_FIELD_OFFSET(EMRFORMAT, nVersion, 4)
    TEST_FIELD_SIZE  (EMRFORMAT, cbData, 4)
    TEST_FIELD_ALIGN (EMRFORMAT, cbData, 4)
    TEST_FIELD_OFFSET(EMRFORMAT, cbData, 8)
    TEST_FIELD_SIZE  (EMRFORMAT, offData, 4)
    TEST_FIELD_ALIGN (EMRFORMAT, offData, 4)
    TEST_FIELD_OFFSET(EMRFORMAT, offData, 12)
}

static void test_pack_EMRFRAMERGN(void)
{
    /* EMRFRAMERGN (pack 4) */
    TEST_TYPE_SIZE   (EMRFRAMERGN, 44)
    TEST_TYPE_ALIGN  (EMRFRAMERGN, 4)
    TEST_FIELD_SIZE  (EMRFRAMERGN, emr, 8)
    TEST_FIELD_ALIGN (EMRFRAMERGN, emr, 4)
    TEST_FIELD_OFFSET(EMRFRAMERGN, emr, 0)
    TEST_FIELD_SIZE  (EMRFRAMERGN, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRFRAMERGN, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRFRAMERGN, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRFRAMERGN, cbRgnData, 4)
    TEST_FIELD_ALIGN (EMRFRAMERGN, cbRgnData, 4)
    TEST_FIELD_OFFSET(EMRFRAMERGN, cbRgnData, 24)
    TEST_FIELD_SIZE  (EMRFRAMERGN, ihBrush, 4)
    TEST_FIELD_ALIGN (EMRFRAMERGN, ihBrush, 4)
    TEST_FIELD_OFFSET(EMRFRAMERGN, ihBrush, 28)
    TEST_FIELD_SIZE  (EMRFRAMERGN, szlStroke, 8)
    TEST_FIELD_ALIGN (EMRFRAMERGN, szlStroke, 4)
    TEST_FIELD_OFFSET(EMRFRAMERGN, szlStroke, 32)
    TEST_FIELD_SIZE  (EMRFRAMERGN, RgnData, 1)
    TEST_FIELD_ALIGN (EMRFRAMERGN, RgnData, 1)
    TEST_FIELD_OFFSET(EMRFRAMERGN, RgnData, 40)
}

static void test_pack_EMRGDICOMMENT(void)
{
    /* EMRGDICOMMENT (pack 4) */
    TEST_TYPE_SIZE   (EMRGDICOMMENT, 16)
    TEST_TYPE_ALIGN  (EMRGDICOMMENT, 4)
    TEST_FIELD_SIZE  (EMRGDICOMMENT, emr, 8)
    TEST_FIELD_ALIGN (EMRGDICOMMENT, emr, 4)
    TEST_FIELD_OFFSET(EMRGDICOMMENT, emr, 0)
    TEST_FIELD_SIZE  (EMRGDICOMMENT, cbData, 4)
    TEST_FIELD_ALIGN (EMRGDICOMMENT, cbData, 4)
    TEST_FIELD_OFFSET(EMRGDICOMMENT, cbData, 8)
    TEST_FIELD_SIZE  (EMRGDICOMMENT, Data, 1)
    TEST_FIELD_ALIGN (EMRGDICOMMENT, Data, 1)
    TEST_FIELD_OFFSET(EMRGDICOMMENT, Data, 12)
}

static void test_pack_EMRGLSBOUNDEDRECORD(void)
{
    /* EMRGLSBOUNDEDRECORD (pack 4) */
    TEST_TYPE_SIZE   (EMRGLSBOUNDEDRECORD, 32)
    TEST_TYPE_ALIGN  (EMRGLSBOUNDEDRECORD, 4)
    TEST_FIELD_SIZE  (EMRGLSBOUNDEDRECORD, emr, 8)
    TEST_FIELD_ALIGN (EMRGLSBOUNDEDRECORD, emr, 4)
    TEST_FIELD_OFFSET(EMRGLSBOUNDEDRECORD, emr, 0)
    TEST_FIELD_SIZE  (EMRGLSBOUNDEDRECORD, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRGLSBOUNDEDRECORD, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRGLSBOUNDEDRECORD, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRGLSBOUNDEDRECORD, cbData, 4)
    TEST_FIELD_ALIGN (EMRGLSBOUNDEDRECORD, cbData, 4)
    TEST_FIELD_OFFSET(EMRGLSBOUNDEDRECORD, cbData, 24)
    TEST_FIELD_SIZE  (EMRGLSBOUNDEDRECORD, Data, 1)
    TEST_FIELD_ALIGN (EMRGLSBOUNDEDRECORD, Data, 1)
    TEST_FIELD_OFFSET(EMRGLSBOUNDEDRECORD, Data, 28)
}

static void test_pack_EMRGLSRECORD(void)
{
    /* EMRGLSRECORD (pack 4) */
    TEST_TYPE_SIZE   (EMRGLSRECORD, 16)
    TEST_TYPE_ALIGN  (EMRGLSRECORD, 4)
    TEST_FIELD_SIZE  (EMRGLSRECORD, emr, 8)
    TEST_FIELD_ALIGN (EMRGLSRECORD, emr, 4)
    TEST_FIELD_OFFSET(EMRGLSRECORD, emr, 0)
    TEST_FIELD_SIZE  (EMRGLSRECORD, cbData, 4)
    TEST_FIELD_ALIGN (EMRGLSRECORD, cbData, 4)
    TEST_FIELD_OFFSET(EMRGLSRECORD, cbData, 8)
    TEST_FIELD_SIZE  (EMRGLSRECORD, Data, 1)
    TEST_FIELD_ALIGN (EMRGLSRECORD, Data, 1)
    TEST_FIELD_OFFSET(EMRGLSRECORD, Data, 12)
}

static void test_pack_EMRINTERSECTCLIPRECT(void)
{
    /* EMRINTERSECTCLIPRECT (pack 4) */
    TEST_TYPE_SIZE   (EMRINTERSECTCLIPRECT, 24)
    TEST_TYPE_ALIGN  (EMRINTERSECTCLIPRECT, 4)
    TEST_FIELD_SIZE  (EMRINTERSECTCLIPRECT, emr, 8)
    TEST_FIELD_ALIGN (EMRINTERSECTCLIPRECT, emr, 4)
    TEST_FIELD_OFFSET(EMRINTERSECTCLIPRECT, emr, 0)
    TEST_FIELD_SIZE  (EMRINTERSECTCLIPRECT, rclClip, 16)
    TEST_FIELD_ALIGN (EMRINTERSECTCLIPRECT, rclClip, 4)
    TEST_FIELD_OFFSET(EMRINTERSECTCLIPRECT, rclClip, 8)
}

static void test_pack_EMRINVERTRGN(void)
{
    /* EMRINVERTRGN (pack 4) */
    TEST_TYPE_SIZE   (EMRINVERTRGN, 32)
    TEST_TYPE_ALIGN  (EMRINVERTRGN, 4)
    TEST_FIELD_SIZE  (EMRINVERTRGN, emr, 8)
    TEST_FIELD_ALIGN (EMRINVERTRGN, emr, 4)
    TEST_FIELD_OFFSET(EMRINVERTRGN, emr, 0)
    TEST_FIELD_SIZE  (EMRINVERTRGN, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRINVERTRGN, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRINVERTRGN, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRINVERTRGN, cbRgnData, 4)
    TEST_FIELD_ALIGN (EMRINVERTRGN, cbRgnData, 4)
    TEST_FIELD_OFFSET(EMRINVERTRGN, cbRgnData, 24)
    TEST_FIELD_SIZE  (EMRINVERTRGN, RgnData, 1)
    TEST_FIELD_ALIGN (EMRINVERTRGN, RgnData, 1)
    TEST_FIELD_OFFSET(EMRINVERTRGN, RgnData, 28)
}

static void test_pack_EMRLINETO(void)
{
    /* EMRLINETO (pack 4) */
    TEST_TYPE_SIZE   (EMRLINETO, 16)
    TEST_TYPE_ALIGN  (EMRLINETO, 4)
    TEST_FIELD_SIZE  (EMRLINETO, emr, 8)
    TEST_FIELD_ALIGN (EMRLINETO, emr, 4)
    TEST_FIELD_OFFSET(EMRLINETO, emr, 0)
    TEST_FIELD_SIZE  (EMRLINETO, ptl, 8)
    TEST_FIELD_ALIGN (EMRLINETO, ptl, 4)
    TEST_FIELD_OFFSET(EMRLINETO, ptl, 8)
}

static void test_pack_EMRMASKBLT(void)
{
    /* EMRMASKBLT (pack 4) */
    TEST_TYPE_SIZE   (EMRMASKBLT, 128)
    TEST_TYPE_ALIGN  (EMRMASKBLT, 4)
    TEST_FIELD_SIZE  (EMRMASKBLT, emr, 8)
    TEST_FIELD_ALIGN (EMRMASKBLT, emr, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, emr, 0)
    TEST_FIELD_SIZE  (EMRMASKBLT, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRMASKBLT, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRMASKBLT, xDest, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, xDest, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, xDest, 24)
    TEST_FIELD_SIZE  (EMRMASKBLT, yDest, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, yDest, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, yDest, 28)
    TEST_FIELD_SIZE  (EMRMASKBLT, cxDest, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, cxDest, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, cxDest, 32)
    TEST_FIELD_SIZE  (EMRMASKBLT, cyDest, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, cyDest, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, cyDest, 36)
    TEST_FIELD_SIZE  (EMRMASKBLT, dwRop, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, dwRop, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, dwRop, 40)
    TEST_FIELD_SIZE  (EMRMASKBLT, xSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, xSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, xSrc, 44)
    TEST_FIELD_SIZE  (EMRMASKBLT, ySrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, ySrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, ySrc, 48)
    TEST_FIELD_SIZE  (EMRMASKBLT, xformSrc, 24)
    TEST_FIELD_ALIGN (EMRMASKBLT, xformSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, xformSrc, 52)
    TEST_FIELD_SIZE  (EMRMASKBLT, crBkColorSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, crBkColorSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, crBkColorSrc, 76)
    TEST_FIELD_SIZE  (EMRMASKBLT, iUsageSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, iUsageSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, iUsageSrc, 80)
    TEST_FIELD_SIZE  (EMRMASKBLT, offBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, offBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, offBmiSrc, 84)
    TEST_FIELD_SIZE  (EMRMASKBLT, cbBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, cbBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, cbBmiSrc, 88)
    TEST_FIELD_SIZE  (EMRMASKBLT, offBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, offBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, offBitsSrc, 92)
    TEST_FIELD_SIZE  (EMRMASKBLT, cbBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, cbBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, cbBitsSrc, 96)
    TEST_FIELD_SIZE  (EMRMASKBLT, xMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, xMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, xMask, 100)
    TEST_FIELD_SIZE  (EMRMASKBLT, yMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, yMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, yMask, 104)
    TEST_FIELD_SIZE  (EMRMASKBLT, iUsageMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, iUsageMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, iUsageMask, 108)
    TEST_FIELD_SIZE  (EMRMASKBLT, offBmiMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, offBmiMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, offBmiMask, 112)
    TEST_FIELD_SIZE  (EMRMASKBLT, cbBmiMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, cbBmiMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, cbBmiMask, 116)
    TEST_FIELD_SIZE  (EMRMASKBLT, offBitsMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, offBitsMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, offBitsMask, 120)
    TEST_FIELD_SIZE  (EMRMASKBLT, cbBitsMask, 4)
    TEST_FIELD_ALIGN (EMRMASKBLT, cbBitsMask, 4)
    TEST_FIELD_OFFSET(EMRMASKBLT, cbBitsMask, 124)
}

static void test_pack_EMRMODIFYWORLDTRANSFORM(void)
{
    /* EMRMODIFYWORLDTRANSFORM (pack 4) */
    TEST_TYPE_SIZE   (EMRMODIFYWORLDTRANSFORM, 36)
    TEST_TYPE_ALIGN  (EMRMODIFYWORLDTRANSFORM, 4)
    TEST_FIELD_SIZE  (EMRMODIFYWORLDTRANSFORM, emr, 8)
    TEST_FIELD_ALIGN (EMRMODIFYWORLDTRANSFORM, emr, 4)
    TEST_FIELD_OFFSET(EMRMODIFYWORLDTRANSFORM, emr, 0)
    TEST_FIELD_SIZE  (EMRMODIFYWORLDTRANSFORM, xform, 24)
    TEST_FIELD_ALIGN (EMRMODIFYWORLDTRANSFORM, xform, 4)
    TEST_FIELD_OFFSET(EMRMODIFYWORLDTRANSFORM, xform, 8)
    TEST_FIELD_SIZE  (EMRMODIFYWORLDTRANSFORM, iMode, 4)
    TEST_FIELD_ALIGN (EMRMODIFYWORLDTRANSFORM, iMode, 4)
    TEST_FIELD_OFFSET(EMRMODIFYWORLDTRANSFORM, iMode, 32)
}

static void test_pack_EMRMOVETOEX(void)
{
    /* EMRMOVETOEX (pack 4) */
    TEST_TYPE_SIZE   (EMRMOVETOEX, 16)
    TEST_TYPE_ALIGN  (EMRMOVETOEX, 4)
    TEST_FIELD_SIZE  (EMRMOVETOEX, emr, 8)
    TEST_FIELD_ALIGN (EMRMOVETOEX, emr, 4)
    TEST_FIELD_OFFSET(EMRMOVETOEX, emr, 0)
    TEST_FIELD_SIZE  (EMRMOVETOEX, ptl, 8)
    TEST_FIELD_ALIGN (EMRMOVETOEX, ptl, 4)
    TEST_FIELD_OFFSET(EMRMOVETOEX, ptl, 8)
}

static void test_pack_EMROFFSETCLIPRGN(void)
{
    /* EMROFFSETCLIPRGN (pack 4) */
    TEST_TYPE_SIZE   (EMROFFSETCLIPRGN, 16)
    TEST_TYPE_ALIGN  (EMROFFSETCLIPRGN, 4)
    TEST_FIELD_SIZE  (EMROFFSETCLIPRGN, emr, 8)
    TEST_FIELD_ALIGN (EMROFFSETCLIPRGN, emr, 4)
    TEST_FIELD_OFFSET(EMROFFSETCLIPRGN, emr, 0)
    TEST_FIELD_SIZE  (EMROFFSETCLIPRGN, ptlOffset, 8)
    TEST_FIELD_ALIGN (EMROFFSETCLIPRGN, ptlOffset, 4)
    TEST_FIELD_OFFSET(EMROFFSETCLIPRGN, ptlOffset, 8)
}

static void test_pack_EMRPAINTRGN(void)
{
    /* EMRPAINTRGN (pack 4) */
    TEST_TYPE_SIZE   (EMRPAINTRGN, 32)
    TEST_TYPE_ALIGN  (EMRPAINTRGN, 4)
    TEST_FIELD_SIZE  (EMRPAINTRGN, emr, 8)
    TEST_FIELD_ALIGN (EMRPAINTRGN, emr, 4)
    TEST_FIELD_OFFSET(EMRPAINTRGN, emr, 0)
    TEST_FIELD_SIZE  (EMRPAINTRGN, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPAINTRGN, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPAINTRGN, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPAINTRGN, cbRgnData, 4)
    TEST_FIELD_ALIGN (EMRPAINTRGN, cbRgnData, 4)
    TEST_FIELD_OFFSET(EMRPAINTRGN, cbRgnData, 24)
    TEST_FIELD_SIZE  (EMRPAINTRGN, RgnData, 1)
    TEST_FIELD_ALIGN (EMRPAINTRGN, RgnData, 1)
    TEST_FIELD_OFFSET(EMRPAINTRGN, RgnData, 28)
}

static void test_pack_EMRPIE(void)
{
    /* EMRPIE (pack 4) */
    TEST_TYPE_SIZE   (EMRPIE, 40)
    TEST_TYPE_ALIGN  (EMRPIE, 4)
    TEST_FIELD_SIZE  (EMRPIE, emr, 8)
    TEST_FIELD_ALIGN (EMRPIE, emr, 4)
    TEST_FIELD_OFFSET(EMRPIE, emr, 0)
    TEST_FIELD_SIZE  (EMRPIE, rclBox, 16)
    TEST_FIELD_ALIGN (EMRPIE, rclBox, 4)
    TEST_FIELD_OFFSET(EMRPIE, rclBox, 8)
    TEST_FIELD_SIZE  (EMRPIE, ptlStart, 8)
    TEST_FIELD_ALIGN (EMRPIE, ptlStart, 4)
    TEST_FIELD_OFFSET(EMRPIE, ptlStart, 24)
    TEST_FIELD_SIZE  (EMRPIE, ptlEnd, 8)
    TEST_FIELD_ALIGN (EMRPIE, ptlEnd, 4)
    TEST_FIELD_OFFSET(EMRPIE, ptlEnd, 32)
}

static void test_pack_EMRPIXELFORMAT(void)
{
    /* EMRPIXELFORMAT (pack 4) */
    TEST_TYPE_SIZE   (EMRPIXELFORMAT, 48)
    TEST_TYPE_ALIGN  (EMRPIXELFORMAT, 4)
    TEST_FIELD_SIZE  (EMRPIXELFORMAT, emr, 8)
    TEST_FIELD_ALIGN (EMRPIXELFORMAT, emr, 4)
    TEST_FIELD_OFFSET(EMRPIXELFORMAT, emr, 0)
    TEST_FIELD_SIZE  (EMRPIXELFORMAT, pfd, 40)
    TEST_FIELD_ALIGN (EMRPIXELFORMAT, pfd, 4)
    TEST_FIELD_OFFSET(EMRPIXELFORMAT, pfd, 8)
}

static void test_pack_EMRPLGBLT(void)
{
    /* EMRPLGBLT (pack 4) */
    TEST_TYPE_SIZE   (EMRPLGBLT, 140)
    TEST_TYPE_ALIGN  (EMRPLGBLT, 4)
    TEST_FIELD_SIZE  (EMRPLGBLT, emr, 8)
    TEST_FIELD_ALIGN (EMRPLGBLT, emr, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, emr, 0)
    TEST_FIELD_SIZE  (EMRPLGBLT, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPLGBLT, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPLGBLT, aptlDest, 24)
    TEST_FIELD_ALIGN (EMRPLGBLT, aptlDest, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, aptlDest, 24)
    TEST_FIELD_SIZE  (EMRPLGBLT, xSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, xSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, xSrc, 48)
    TEST_FIELD_SIZE  (EMRPLGBLT, ySrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, ySrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, ySrc, 52)
    TEST_FIELD_SIZE  (EMRPLGBLT, cxSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, cxSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, cxSrc, 56)
    TEST_FIELD_SIZE  (EMRPLGBLT, cySrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, cySrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, cySrc, 60)
    TEST_FIELD_SIZE  (EMRPLGBLT, xformSrc, 24)
    TEST_FIELD_ALIGN (EMRPLGBLT, xformSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, xformSrc, 64)
    TEST_FIELD_SIZE  (EMRPLGBLT, crBkColorSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, crBkColorSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, crBkColorSrc, 88)
    TEST_FIELD_SIZE  (EMRPLGBLT, iUsageSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, iUsageSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, iUsageSrc, 92)
    TEST_FIELD_SIZE  (EMRPLGBLT, offBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, offBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, offBmiSrc, 96)
    TEST_FIELD_SIZE  (EMRPLGBLT, cbBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, cbBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, cbBmiSrc, 100)
    TEST_FIELD_SIZE  (EMRPLGBLT, offBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, offBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, offBitsSrc, 104)
    TEST_FIELD_SIZE  (EMRPLGBLT, cbBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, cbBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, cbBitsSrc, 108)
    TEST_FIELD_SIZE  (EMRPLGBLT, xMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, xMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, xMask, 112)
    TEST_FIELD_SIZE  (EMRPLGBLT, yMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, yMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, yMask, 116)
    TEST_FIELD_SIZE  (EMRPLGBLT, iUsageMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, iUsageMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, iUsageMask, 120)
    TEST_FIELD_SIZE  (EMRPLGBLT, offBmiMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, offBmiMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, offBmiMask, 124)
    TEST_FIELD_SIZE  (EMRPLGBLT, cbBmiMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, cbBmiMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, cbBmiMask, 128)
    TEST_FIELD_SIZE  (EMRPLGBLT, offBitsMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, offBitsMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, offBitsMask, 132)
    TEST_FIELD_SIZE  (EMRPLGBLT, cbBitsMask, 4)
    TEST_FIELD_ALIGN (EMRPLGBLT, cbBitsMask, 4)
    TEST_FIELD_OFFSET(EMRPLGBLT, cbBitsMask, 136)
}

static void test_pack_EMRPOLYBEZIER(void)
{
    /* EMRPOLYBEZIER (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYBEZIER, 36)
    TEST_TYPE_ALIGN  (EMRPOLYBEZIER, 4)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER, cptl, 24)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER, aptl, 28)
}

static void test_pack_EMRPOLYBEZIER16(void)
{
    /* EMRPOLYBEZIER16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYBEZIER16, 32)
    TEST_TYPE_ALIGN  (EMRPOLYBEZIER16, 4)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER16, cpts, 24)
    TEST_FIELD_SIZE  (EMRPOLYBEZIER16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYBEZIER16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYBEZIER16, apts, 28)
}

static void test_pack_EMRPOLYBEZIERTO(void)
{
    /* EMRPOLYBEZIERTO (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYBEZIERTO, 36)
    TEST_TYPE_ALIGN  (EMRPOLYBEZIERTO, 4)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO, cptl, 24)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO, aptl, 28)
}

static void test_pack_EMRPOLYBEZIERTO16(void)
{
    /* EMRPOLYBEZIERTO16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYBEZIERTO16, 32)
    TEST_TYPE_ALIGN  (EMRPOLYBEZIERTO16, 4)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO16, cpts, 24)
    TEST_FIELD_SIZE  (EMRPOLYBEZIERTO16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYBEZIERTO16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYBEZIERTO16, apts, 28)
}

static void test_pack_EMRPOLYDRAW(void)
{
    /* EMRPOLYDRAW (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYDRAW, 40)
    TEST_TYPE_ALIGN  (EMRPOLYDRAW, 4)
    TEST_FIELD_SIZE  (EMRPOLYDRAW, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYDRAW, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYDRAW, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYDRAW, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYDRAW, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYDRAW, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW, cptl, 24)
    TEST_FIELD_SIZE  (EMRPOLYDRAW, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYDRAW, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW, aptl, 28)
    TEST_FIELD_SIZE  (EMRPOLYDRAW, abTypes, 1)
    TEST_FIELD_ALIGN (EMRPOLYDRAW, abTypes, 1)
    TEST_FIELD_OFFSET(EMRPOLYDRAW, abTypes, 36)
}

static void test_pack_EMRPOLYDRAW16(void)
{
    /* EMRPOLYDRAW16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYDRAW16, 36)
    TEST_TYPE_ALIGN  (EMRPOLYDRAW16, 4)
    TEST_FIELD_SIZE  (EMRPOLYDRAW16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYDRAW16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYDRAW16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYDRAW16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYDRAW16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYDRAW16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYDRAW16, cpts, 24)
    TEST_FIELD_SIZE  (EMRPOLYDRAW16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYDRAW16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYDRAW16, apts, 28)
    TEST_FIELD_SIZE  (EMRPOLYDRAW16, abTypes, 1)
    TEST_FIELD_ALIGN (EMRPOLYDRAW16, abTypes, 1)
    TEST_FIELD_OFFSET(EMRPOLYDRAW16, abTypes, 32)
}

static void test_pack_EMRPOLYGON(void)
{
    /* EMRPOLYGON (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYGON, 36)
    TEST_TYPE_ALIGN  (EMRPOLYGON, 4)
    TEST_FIELD_SIZE  (EMRPOLYGON, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYGON, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYGON, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYGON, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYGON, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYGON, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON, cptl, 24)
    TEST_FIELD_SIZE  (EMRPOLYGON, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYGON, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON, aptl, 28)
}

static void test_pack_EMRPOLYGON16(void)
{
    /* EMRPOLYGON16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYGON16, 32)
    TEST_TYPE_ALIGN  (EMRPOLYGON16, 4)
    TEST_FIELD_SIZE  (EMRPOLYGON16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYGON16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYGON16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYGON16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYGON16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYGON16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYGON16, cpts, 24)
    TEST_FIELD_SIZE  (EMRPOLYGON16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYGON16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYGON16, apts, 28)
}

static void test_pack_EMRPOLYLINE(void)
{
    /* EMRPOLYLINE (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYLINE, 36)
    TEST_TYPE_ALIGN  (EMRPOLYLINE, 4)
    TEST_FIELD_SIZE  (EMRPOLYLINE, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYLINE, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYLINE, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYLINE, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYLINE, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYLINE, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE, cptl, 24)
    TEST_FIELD_SIZE  (EMRPOLYLINE, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYLINE, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE, aptl, 28)
}

static void test_pack_EMRPOLYLINE16(void)
{
    /* EMRPOLYLINE16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYLINE16, 32)
    TEST_TYPE_ALIGN  (EMRPOLYLINE16, 4)
    TEST_FIELD_SIZE  (EMRPOLYLINE16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYLINE16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYLINE16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYLINE16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYLINE16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYLINE16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINE16, cpts, 24)
    TEST_FIELD_SIZE  (EMRPOLYLINE16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYLINE16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYLINE16, apts, 28)
}

static void test_pack_EMRPOLYLINETO(void)
{
    /* EMRPOLYLINETO (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYLINETO, 36)
    TEST_TYPE_ALIGN  (EMRPOLYLINETO, 4)
    TEST_FIELD_SIZE  (EMRPOLYLINETO, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYLINETO, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYLINETO, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYLINETO, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYLINETO, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYLINETO, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO, cptl, 24)
    TEST_FIELD_SIZE  (EMRPOLYLINETO, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYLINETO, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO, aptl, 28)
}

static void test_pack_EMRPOLYLINETO16(void)
{
    /* EMRPOLYLINETO16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYLINETO16, 32)
    TEST_TYPE_ALIGN  (EMRPOLYLINETO16, 4)
    TEST_FIELD_SIZE  (EMRPOLYLINETO16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYLINETO16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYLINETO16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYLINETO16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYLINETO16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYLINETO16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYLINETO16, cpts, 24)
    TEST_FIELD_SIZE  (EMRPOLYLINETO16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYLINETO16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYLINETO16, apts, 28)
}

static void test_pack_EMRPOLYPOLYGON(void)
{
    /* EMRPOLYPOLYGON (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYPOLYGON, 44)
    TEST_TYPE_ALIGN  (EMRPOLYPOLYGON, 4)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON, nPolys, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON, nPolys, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON, nPolys, 24)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON, cptl, 28)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON, aPolyCounts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON, aPolyCounts, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON, aPolyCounts, 32)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON, aptl, 36)
}

static void test_pack_EMRPOLYPOLYGON16(void)
{
    /* EMRPOLYPOLYGON16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYPOLYGON16, 40)
    TEST_TYPE_ALIGN  (EMRPOLYPOLYGON16, 4)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON16, nPolys, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON16, nPolys, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON16, nPolys, 24)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON16, cpts, 28)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON16, aPolyCounts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON16, aPolyCounts, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON16, aPolyCounts, 32)
    TEST_FIELD_SIZE  (EMRPOLYPOLYGON16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYGON16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYPOLYGON16, apts, 36)
}

static void test_pack_EMRPOLYPOLYLINE(void)
{
    /* EMRPOLYPOLYLINE (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYPOLYLINE, 44)
    TEST_TYPE_ALIGN  (EMRPOLYPOLYLINE, 4)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE, nPolys, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE, nPolys, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE, nPolys, 24)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE, cptl, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE, cptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE, cptl, 28)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE, aPolyCounts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE, aPolyCounts, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE, aPolyCounts, 32)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE, aptl, 8)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE, aptl, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE, aptl, 36)
}

static void test_pack_EMRPOLYPOLYLINE16(void)
{
    /* EMRPOLYPOLYLINE16 (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYPOLYLINE16, 40)
    TEST_TYPE_ALIGN  (EMRPOLYPOLYLINE16, 4)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE16, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE16, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE16, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE16, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE16, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE16, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE16, nPolys, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE16, nPolys, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE16, nPolys, 24)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE16, cpts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE16, cpts, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE16, cpts, 28)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE16, aPolyCounts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE16, aPolyCounts, 4)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE16, aPolyCounts, 32)
    TEST_FIELD_SIZE  (EMRPOLYPOLYLINE16, apts, 4)
    TEST_FIELD_ALIGN (EMRPOLYPOLYLINE16, apts, 2)
    TEST_FIELD_OFFSET(EMRPOLYPOLYLINE16, apts, 36)
}

static void test_pack_EMRPOLYTEXTOUTA(void)
{
    /* EMRPOLYTEXTOUTA (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYTEXTOUTA, 80)
    TEST_TYPE_ALIGN  (EMRPOLYTEXTOUTA, 4)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, iGraphicsMode, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, iGraphicsMode, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, iGraphicsMode, 24)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, exScale, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, exScale, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, exScale, 28)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, eyScale, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, eyScale, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, eyScale, 32)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, cStrings, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, cStrings, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, cStrings, 36)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTA, aemrtext, 40)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTA, aemrtext, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTA, aemrtext, 40)
}

static void test_pack_EMRPOLYTEXTOUTW(void)
{
    /* EMRPOLYTEXTOUTW (pack 4) */
    TEST_TYPE_SIZE   (EMRPOLYTEXTOUTW, 80)
    TEST_TYPE_ALIGN  (EMRPOLYTEXTOUTW, 4)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, emr, 8)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, emr, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, emr, 0)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, iGraphicsMode, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, iGraphicsMode, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, iGraphicsMode, 24)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, exScale, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, exScale, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, exScale, 28)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, eyScale, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, eyScale, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, eyScale, 32)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, cStrings, 4)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, cStrings, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, cStrings, 36)
    TEST_FIELD_SIZE  (EMRPOLYTEXTOUTW, aemrtext, 40)
    TEST_FIELD_ALIGN (EMRPOLYTEXTOUTW, aemrtext, 4)
    TEST_FIELD_OFFSET(EMRPOLYTEXTOUTW, aemrtext, 40)
}

static void test_pack_EMRREALIZEPALETTE(void)
{
    /* EMRREALIZEPALETTE (pack 4) */
    TEST_TYPE_SIZE   (EMRREALIZEPALETTE, 8)
    TEST_TYPE_ALIGN  (EMRREALIZEPALETTE, 4)
    TEST_FIELD_SIZE  (EMRREALIZEPALETTE, emr, 8)
    TEST_FIELD_ALIGN (EMRREALIZEPALETTE, emr, 4)
    TEST_FIELD_OFFSET(EMRREALIZEPALETTE, emr, 0)
}

static void test_pack_EMRRECTANGLE(void)
{
    /* EMRRECTANGLE (pack 4) */
    TEST_TYPE_SIZE   (EMRRECTANGLE, 24)
    TEST_TYPE_ALIGN  (EMRRECTANGLE, 4)
    TEST_FIELD_SIZE  (EMRRECTANGLE, emr, 8)
    TEST_FIELD_ALIGN (EMRRECTANGLE, emr, 4)
    TEST_FIELD_OFFSET(EMRRECTANGLE, emr, 0)
    TEST_FIELD_SIZE  (EMRRECTANGLE, rclBox, 16)
    TEST_FIELD_ALIGN (EMRRECTANGLE, rclBox, 4)
    TEST_FIELD_OFFSET(EMRRECTANGLE, rclBox, 8)
}

static void test_pack_EMRRESIZEPALETTE(void)
{
    /* EMRRESIZEPALETTE (pack 4) */
    TEST_TYPE_SIZE   (EMRRESIZEPALETTE, 16)
    TEST_TYPE_ALIGN  (EMRRESIZEPALETTE, 4)
    TEST_FIELD_SIZE  (EMRRESIZEPALETTE, emr, 8)
    TEST_FIELD_ALIGN (EMRRESIZEPALETTE, emr, 4)
    TEST_FIELD_OFFSET(EMRRESIZEPALETTE, emr, 0)
    TEST_FIELD_SIZE  (EMRRESIZEPALETTE, ihPal, 4)
    TEST_FIELD_ALIGN (EMRRESIZEPALETTE, ihPal, 4)
    TEST_FIELD_OFFSET(EMRRESIZEPALETTE, ihPal, 8)
    TEST_FIELD_SIZE  (EMRRESIZEPALETTE, cEntries, 4)
    TEST_FIELD_ALIGN (EMRRESIZEPALETTE, cEntries, 4)
    TEST_FIELD_OFFSET(EMRRESIZEPALETTE, cEntries, 12)
}

static void test_pack_EMRRESTOREDC(void)
{
    /* EMRRESTOREDC (pack 4) */
    TEST_TYPE_SIZE   (EMRRESTOREDC, 12)
    TEST_TYPE_ALIGN  (EMRRESTOREDC, 4)
    TEST_FIELD_SIZE  (EMRRESTOREDC, emr, 8)
    TEST_FIELD_ALIGN (EMRRESTOREDC, emr, 4)
    TEST_FIELD_OFFSET(EMRRESTOREDC, emr, 0)
    TEST_FIELD_SIZE  (EMRRESTOREDC, iRelative, 4)
    TEST_FIELD_ALIGN (EMRRESTOREDC, iRelative, 4)
    TEST_FIELD_OFFSET(EMRRESTOREDC, iRelative, 8)
}

static void test_pack_EMRROUNDRECT(void)
{
    /* EMRROUNDRECT (pack 4) */
    TEST_TYPE_SIZE   (EMRROUNDRECT, 32)
    TEST_TYPE_ALIGN  (EMRROUNDRECT, 4)
    TEST_FIELD_SIZE  (EMRROUNDRECT, emr, 8)
    TEST_FIELD_ALIGN (EMRROUNDRECT, emr, 4)
    TEST_FIELD_OFFSET(EMRROUNDRECT, emr, 0)
    TEST_FIELD_SIZE  (EMRROUNDRECT, rclBox, 16)
    TEST_FIELD_ALIGN (EMRROUNDRECT, rclBox, 4)
    TEST_FIELD_OFFSET(EMRROUNDRECT, rclBox, 8)
    TEST_FIELD_SIZE  (EMRROUNDRECT, szlCorner, 8)
    TEST_FIELD_ALIGN (EMRROUNDRECT, szlCorner, 4)
    TEST_FIELD_OFFSET(EMRROUNDRECT, szlCorner, 24)
}

static void test_pack_EMRSAVEDC(void)
{
    /* EMRSAVEDC (pack 4) */
    TEST_TYPE_SIZE   (EMRSAVEDC, 8)
    TEST_TYPE_ALIGN  (EMRSAVEDC, 4)
    TEST_FIELD_SIZE  (EMRSAVEDC, emr, 8)
    TEST_FIELD_ALIGN (EMRSAVEDC, emr, 4)
    TEST_FIELD_OFFSET(EMRSAVEDC, emr, 0)
}

static void test_pack_EMRSCALEVIEWPORTEXTEX(void)
{
    /* EMRSCALEVIEWPORTEXTEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSCALEVIEWPORTEXTEX, 24)
    TEST_TYPE_ALIGN  (EMRSCALEVIEWPORTEXTEX, 4)
    TEST_FIELD_SIZE  (EMRSCALEVIEWPORTEXTEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSCALEVIEWPORTEXTEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSCALEVIEWPORTEXTEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSCALEVIEWPORTEXTEX, xNum, 4)
    TEST_FIELD_ALIGN (EMRSCALEVIEWPORTEXTEX, xNum, 4)
    TEST_FIELD_OFFSET(EMRSCALEVIEWPORTEXTEX, xNum, 8)
    TEST_FIELD_SIZE  (EMRSCALEVIEWPORTEXTEX, xDenom, 4)
    TEST_FIELD_ALIGN (EMRSCALEVIEWPORTEXTEX, xDenom, 4)
    TEST_FIELD_OFFSET(EMRSCALEVIEWPORTEXTEX, xDenom, 12)
    TEST_FIELD_SIZE  (EMRSCALEVIEWPORTEXTEX, yNum, 4)
    TEST_FIELD_ALIGN (EMRSCALEVIEWPORTEXTEX, yNum, 4)
    TEST_FIELD_OFFSET(EMRSCALEVIEWPORTEXTEX, yNum, 16)
    TEST_FIELD_SIZE  (EMRSCALEVIEWPORTEXTEX, yDenom, 4)
    TEST_FIELD_ALIGN (EMRSCALEVIEWPORTEXTEX, yDenom, 4)
    TEST_FIELD_OFFSET(EMRSCALEVIEWPORTEXTEX, yDenom, 20)
}

static void test_pack_EMRSCALEWINDOWEXTEX(void)
{
    /* EMRSCALEWINDOWEXTEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSCALEWINDOWEXTEX, 24)
    TEST_TYPE_ALIGN  (EMRSCALEWINDOWEXTEX, 4)
    TEST_FIELD_SIZE  (EMRSCALEWINDOWEXTEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSCALEWINDOWEXTEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSCALEWINDOWEXTEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSCALEWINDOWEXTEX, xNum, 4)
    TEST_FIELD_ALIGN (EMRSCALEWINDOWEXTEX, xNum, 4)
    TEST_FIELD_OFFSET(EMRSCALEWINDOWEXTEX, xNum, 8)
    TEST_FIELD_SIZE  (EMRSCALEWINDOWEXTEX, xDenom, 4)
    TEST_FIELD_ALIGN (EMRSCALEWINDOWEXTEX, xDenom, 4)
    TEST_FIELD_OFFSET(EMRSCALEWINDOWEXTEX, xDenom, 12)
    TEST_FIELD_SIZE  (EMRSCALEWINDOWEXTEX, yNum, 4)
    TEST_FIELD_ALIGN (EMRSCALEWINDOWEXTEX, yNum, 4)
    TEST_FIELD_OFFSET(EMRSCALEWINDOWEXTEX, yNum, 16)
    TEST_FIELD_SIZE  (EMRSCALEWINDOWEXTEX, yDenom, 4)
    TEST_FIELD_ALIGN (EMRSCALEWINDOWEXTEX, yDenom, 4)
    TEST_FIELD_OFFSET(EMRSCALEWINDOWEXTEX, yDenom, 20)
}

static void test_pack_EMRSELECTCLIPPATH(void)
{
    /* EMRSELECTCLIPPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRSELECTCLIPPATH, 12)
    TEST_TYPE_ALIGN  (EMRSELECTCLIPPATH, 4)
    TEST_FIELD_SIZE  (EMRSELECTCLIPPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRSELECTCLIPPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRSELECTCLIPPATH, emr, 0)
    TEST_FIELD_SIZE  (EMRSELECTCLIPPATH, iMode, 4)
    TEST_FIELD_ALIGN (EMRSELECTCLIPPATH, iMode, 4)
    TEST_FIELD_OFFSET(EMRSELECTCLIPPATH, iMode, 8)
}

static void test_pack_EMRSELECTCOLORSPACE(void)
{
    /* EMRSELECTCOLORSPACE (pack 4) */
    TEST_TYPE_SIZE   (EMRSELECTCOLORSPACE, 12)
    TEST_TYPE_ALIGN  (EMRSELECTCOLORSPACE, 4)
    TEST_FIELD_SIZE  (EMRSELECTCOLORSPACE, emr, 8)
    TEST_FIELD_ALIGN (EMRSELECTCOLORSPACE, emr, 4)
    TEST_FIELD_OFFSET(EMRSELECTCOLORSPACE, emr, 0)
    TEST_FIELD_SIZE  (EMRSELECTCOLORSPACE, ihCS, 4)
    TEST_FIELD_ALIGN (EMRSELECTCOLORSPACE, ihCS, 4)
    TEST_FIELD_OFFSET(EMRSELECTCOLORSPACE, ihCS, 8)
}

static void test_pack_EMRSELECTOBJECT(void)
{
    /* EMRSELECTOBJECT (pack 4) */
    TEST_TYPE_SIZE   (EMRSELECTOBJECT, 12)
    TEST_TYPE_ALIGN  (EMRSELECTOBJECT, 4)
    TEST_FIELD_SIZE  (EMRSELECTOBJECT, emr, 8)
    TEST_FIELD_ALIGN (EMRSELECTOBJECT, emr, 4)
    TEST_FIELD_OFFSET(EMRSELECTOBJECT, emr, 0)
    TEST_FIELD_SIZE  (EMRSELECTOBJECT, ihObject, 4)
    TEST_FIELD_ALIGN (EMRSELECTOBJECT, ihObject, 4)
    TEST_FIELD_OFFSET(EMRSELECTOBJECT, ihObject, 8)
}

static void test_pack_EMRSELECTPALETTE(void)
{
    /* EMRSELECTPALETTE (pack 4) */
    TEST_TYPE_SIZE   (EMRSELECTPALETTE, 12)
    TEST_TYPE_ALIGN  (EMRSELECTPALETTE, 4)
    TEST_FIELD_SIZE  (EMRSELECTPALETTE, emr, 8)
    TEST_FIELD_ALIGN (EMRSELECTPALETTE, emr, 4)
    TEST_FIELD_OFFSET(EMRSELECTPALETTE, emr, 0)
    TEST_FIELD_SIZE  (EMRSELECTPALETTE, ihPal, 4)
    TEST_FIELD_ALIGN (EMRSELECTPALETTE, ihPal, 4)
    TEST_FIELD_OFFSET(EMRSELECTPALETTE, ihPal, 8)
}

static void test_pack_EMRSETARCDIRECTION(void)
{
    /* EMRSETARCDIRECTION (pack 4) */
    TEST_TYPE_SIZE   (EMRSETARCDIRECTION, 12)
    TEST_TYPE_ALIGN  (EMRSETARCDIRECTION, 4)
    TEST_FIELD_SIZE  (EMRSETARCDIRECTION, emr, 8)
    TEST_FIELD_ALIGN (EMRSETARCDIRECTION, emr, 4)
    TEST_FIELD_OFFSET(EMRSETARCDIRECTION, emr, 0)
    TEST_FIELD_SIZE  (EMRSETARCDIRECTION, iArcDirection, 4)
    TEST_FIELD_ALIGN (EMRSETARCDIRECTION, iArcDirection, 4)
    TEST_FIELD_OFFSET(EMRSETARCDIRECTION, iArcDirection, 8)
}

static void test_pack_EMRSETBKCOLOR(void)
{
    /* EMRSETBKCOLOR (pack 4) */
    TEST_TYPE_SIZE   (EMRSETBKCOLOR, 12)
    TEST_TYPE_ALIGN  (EMRSETBKCOLOR, 4)
    TEST_FIELD_SIZE  (EMRSETBKCOLOR, emr, 8)
    TEST_FIELD_ALIGN (EMRSETBKCOLOR, emr, 4)
    TEST_FIELD_OFFSET(EMRSETBKCOLOR, emr, 0)
    TEST_FIELD_SIZE  (EMRSETBKCOLOR, crColor, 4)
    TEST_FIELD_ALIGN (EMRSETBKCOLOR, crColor, 4)
    TEST_FIELD_OFFSET(EMRSETBKCOLOR, crColor, 8)
}

static void test_pack_EMRSETBKMODE(void)
{
    /* EMRSETBKMODE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETBKMODE, 12)
    TEST_TYPE_ALIGN  (EMRSETBKMODE, 4)
    TEST_FIELD_SIZE  (EMRSETBKMODE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETBKMODE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETBKMODE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETBKMODE, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETBKMODE, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETBKMODE, iMode, 8)
}

static void test_pack_EMRSETBRUSHORGEX(void)
{
    /* EMRSETBRUSHORGEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSETBRUSHORGEX, 16)
    TEST_TYPE_ALIGN  (EMRSETBRUSHORGEX, 4)
    TEST_FIELD_SIZE  (EMRSETBRUSHORGEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSETBRUSHORGEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSETBRUSHORGEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSETBRUSHORGEX, ptlOrigin, 8)
    TEST_FIELD_ALIGN (EMRSETBRUSHORGEX, ptlOrigin, 4)
    TEST_FIELD_OFFSET(EMRSETBRUSHORGEX, ptlOrigin, 8)
}

static void test_pack_EMRSETCOLORADJUSTMENT(void)
{
    /* EMRSETCOLORADJUSTMENT (pack 4) */
    TEST_TYPE_SIZE   (EMRSETCOLORADJUSTMENT, 32)
    TEST_TYPE_ALIGN  (EMRSETCOLORADJUSTMENT, 4)
    TEST_FIELD_SIZE  (EMRSETCOLORADJUSTMENT, emr, 8)
    TEST_FIELD_ALIGN (EMRSETCOLORADJUSTMENT, emr, 4)
    TEST_FIELD_OFFSET(EMRSETCOLORADJUSTMENT, emr, 0)
    TEST_FIELD_SIZE  (EMRSETCOLORADJUSTMENT, ColorAdjustment, 24)
    TEST_FIELD_ALIGN (EMRSETCOLORADJUSTMENT, ColorAdjustment, 2)
    TEST_FIELD_OFFSET(EMRSETCOLORADJUSTMENT, ColorAdjustment, 8)
}

static void test_pack_EMRSETCOLORSPACE(void)
{
    /* EMRSETCOLORSPACE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETCOLORSPACE, 12)
    TEST_TYPE_ALIGN  (EMRSETCOLORSPACE, 4)
    TEST_FIELD_SIZE  (EMRSETCOLORSPACE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETCOLORSPACE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETCOLORSPACE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETCOLORSPACE, ihCS, 4)
    TEST_FIELD_ALIGN (EMRSETCOLORSPACE, ihCS, 4)
    TEST_FIELD_OFFSET(EMRSETCOLORSPACE, ihCS, 8)
}

static void test_pack_EMRSETDIBITSTODEVICE(void)
{
    /* EMRSETDIBITSTODEVICE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETDIBITSTODEVICE, 76)
    TEST_TYPE_ALIGN  (EMRSETDIBITSTODEVICE, 4)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, xDest, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, xDest, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, xDest, 24)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, yDest, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, yDest, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, yDest, 28)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, xSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, xSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, xSrc, 32)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, ySrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, ySrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, ySrc, 36)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, cxSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, cxSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, cxSrc, 40)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, cySrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, cySrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, cySrc, 44)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, offBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, offBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, offBmiSrc, 48)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, cbBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, cbBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, cbBmiSrc, 52)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, offBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, offBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, offBitsSrc, 56)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, cbBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, cbBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, cbBitsSrc, 60)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, iUsageSrc, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, iUsageSrc, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, iUsageSrc, 64)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, iStartScan, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, iStartScan, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, iStartScan, 68)
    TEST_FIELD_SIZE  (EMRSETDIBITSTODEVICE, cScans, 4)
    TEST_FIELD_ALIGN (EMRSETDIBITSTODEVICE, cScans, 4)
    TEST_FIELD_OFFSET(EMRSETDIBITSTODEVICE, cScans, 72)
}

static void test_pack_EMRSETICMMODE(void)
{
    /* EMRSETICMMODE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETICMMODE, 12)
    TEST_TYPE_ALIGN  (EMRSETICMMODE, 4)
    TEST_FIELD_SIZE  (EMRSETICMMODE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETICMMODE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETICMMODE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETICMMODE, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETICMMODE, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETICMMODE, iMode, 8)
}

static void test_pack_EMRSETLAYOUT(void)
{
    /* EMRSETLAYOUT (pack 4) */
    TEST_TYPE_SIZE   (EMRSETLAYOUT, 12)
    TEST_TYPE_ALIGN  (EMRSETLAYOUT, 4)
    TEST_FIELD_SIZE  (EMRSETLAYOUT, emr, 8)
    TEST_FIELD_ALIGN (EMRSETLAYOUT, emr, 4)
    TEST_FIELD_OFFSET(EMRSETLAYOUT, emr, 0)
    TEST_FIELD_SIZE  (EMRSETLAYOUT, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETLAYOUT, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETLAYOUT, iMode, 8)
}

static void test_pack_EMRSETMAPMODE(void)
{
    /* EMRSETMAPMODE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETMAPMODE, 12)
    TEST_TYPE_ALIGN  (EMRSETMAPMODE, 4)
    TEST_FIELD_SIZE  (EMRSETMAPMODE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETMAPMODE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETMAPMODE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETMAPMODE, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETMAPMODE, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETMAPMODE, iMode, 8)
}

static void test_pack_EMRSETMAPPERFLAGS(void)
{
    /* EMRSETMAPPERFLAGS (pack 4) */
    TEST_TYPE_SIZE   (EMRSETMAPPERFLAGS, 12)
    TEST_TYPE_ALIGN  (EMRSETMAPPERFLAGS, 4)
    TEST_FIELD_SIZE  (EMRSETMAPPERFLAGS, emr, 8)
    TEST_FIELD_ALIGN (EMRSETMAPPERFLAGS, emr, 4)
    TEST_FIELD_OFFSET(EMRSETMAPPERFLAGS, emr, 0)
    TEST_FIELD_SIZE  (EMRSETMAPPERFLAGS, dwFlags, 4)
    TEST_FIELD_ALIGN (EMRSETMAPPERFLAGS, dwFlags, 4)
    TEST_FIELD_OFFSET(EMRSETMAPPERFLAGS, dwFlags, 8)
}

static void test_pack_EMRSETMETARGN(void)
{
    /* EMRSETMETARGN (pack 4) */
    TEST_TYPE_SIZE   (EMRSETMETARGN, 8)
    TEST_TYPE_ALIGN  (EMRSETMETARGN, 4)
    TEST_FIELD_SIZE  (EMRSETMETARGN, emr, 8)
    TEST_FIELD_ALIGN (EMRSETMETARGN, emr, 4)
    TEST_FIELD_OFFSET(EMRSETMETARGN, emr, 0)
}

static void test_pack_EMRSETMITERLIMIT(void)
{
    /* EMRSETMITERLIMIT (pack 4) */
    TEST_TYPE_SIZE   (EMRSETMITERLIMIT, 12)
    TEST_TYPE_ALIGN  (EMRSETMITERLIMIT, 4)
    TEST_FIELD_SIZE  (EMRSETMITERLIMIT, emr, 8)
    TEST_FIELD_ALIGN (EMRSETMITERLIMIT, emr, 4)
    TEST_FIELD_OFFSET(EMRSETMITERLIMIT, emr, 0)
    TEST_FIELD_SIZE  (EMRSETMITERLIMIT, eMiterLimit, 4)
    TEST_FIELD_ALIGN (EMRSETMITERLIMIT, eMiterLimit, 4)
    TEST_FIELD_OFFSET(EMRSETMITERLIMIT, eMiterLimit, 8)
}

static void test_pack_EMRSETPIXELV(void)
{
    /* EMRSETPIXELV (pack 4) */
    TEST_TYPE_SIZE   (EMRSETPIXELV, 20)
    TEST_TYPE_ALIGN  (EMRSETPIXELV, 4)
    TEST_FIELD_SIZE  (EMRSETPIXELV, emr, 8)
    TEST_FIELD_ALIGN (EMRSETPIXELV, emr, 4)
    TEST_FIELD_OFFSET(EMRSETPIXELV, emr, 0)
    TEST_FIELD_SIZE  (EMRSETPIXELV, ptlPixel, 8)
    TEST_FIELD_ALIGN (EMRSETPIXELV, ptlPixel, 4)
    TEST_FIELD_OFFSET(EMRSETPIXELV, ptlPixel, 8)
    TEST_FIELD_SIZE  (EMRSETPIXELV, crColor, 4)
    TEST_FIELD_ALIGN (EMRSETPIXELV, crColor, 4)
    TEST_FIELD_OFFSET(EMRSETPIXELV, crColor, 16)
}

static void test_pack_EMRSETPOLYFILLMODE(void)
{
    /* EMRSETPOLYFILLMODE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETPOLYFILLMODE, 12)
    TEST_TYPE_ALIGN  (EMRSETPOLYFILLMODE, 4)
    TEST_FIELD_SIZE  (EMRSETPOLYFILLMODE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETPOLYFILLMODE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETPOLYFILLMODE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETPOLYFILLMODE, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETPOLYFILLMODE, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETPOLYFILLMODE, iMode, 8)
}

static void test_pack_EMRSETROP2(void)
{
    /* EMRSETROP2 (pack 4) */
    TEST_TYPE_SIZE   (EMRSETROP2, 12)
    TEST_TYPE_ALIGN  (EMRSETROP2, 4)
    TEST_FIELD_SIZE  (EMRSETROP2, emr, 8)
    TEST_FIELD_ALIGN (EMRSETROP2, emr, 4)
    TEST_FIELD_OFFSET(EMRSETROP2, emr, 0)
    TEST_FIELD_SIZE  (EMRSETROP2, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETROP2, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETROP2, iMode, 8)
}

static void test_pack_EMRSETSTRETCHBLTMODE(void)
{
    /* EMRSETSTRETCHBLTMODE (pack 4) */
    TEST_TYPE_SIZE   (EMRSETSTRETCHBLTMODE, 12)
    TEST_TYPE_ALIGN  (EMRSETSTRETCHBLTMODE, 4)
    TEST_FIELD_SIZE  (EMRSETSTRETCHBLTMODE, emr, 8)
    TEST_FIELD_ALIGN (EMRSETSTRETCHBLTMODE, emr, 4)
    TEST_FIELD_OFFSET(EMRSETSTRETCHBLTMODE, emr, 0)
    TEST_FIELD_SIZE  (EMRSETSTRETCHBLTMODE, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETSTRETCHBLTMODE, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETSTRETCHBLTMODE, iMode, 8)
}

static void test_pack_EMRSETTEXTALIGN(void)
{
    /* EMRSETTEXTALIGN (pack 4) */
    TEST_TYPE_SIZE   (EMRSETTEXTALIGN, 12)
    TEST_TYPE_ALIGN  (EMRSETTEXTALIGN, 4)
    TEST_FIELD_SIZE  (EMRSETTEXTALIGN, emr, 8)
    TEST_FIELD_ALIGN (EMRSETTEXTALIGN, emr, 4)
    TEST_FIELD_OFFSET(EMRSETTEXTALIGN, emr, 0)
    TEST_FIELD_SIZE  (EMRSETTEXTALIGN, iMode, 4)
    TEST_FIELD_ALIGN (EMRSETTEXTALIGN, iMode, 4)
    TEST_FIELD_OFFSET(EMRSETTEXTALIGN, iMode, 8)
}

static void test_pack_EMRSETTEXTCOLOR(void)
{
    /* EMRSETTEXTCOLOR (pack 4) */
    TEST_TYPE_SIZE   (EMRSETTEXTCOLOR, 12)
    TEST_TYPE_ALIGN  (EMRSETTEXTCOLOR, 4)
    TEST_FIELD_SIZE  (EMRSETTEXTCOLOR, emr, 8)
    TEST_FIELD_ALIGN (EMRSETTEXTCOLOR, emr, 4)
    TEST_FIELD_OFFSET(EMRSETTEXTCOLOR, emr, 0)
    TEST_FIELD_SIZE  (EMRSETTEXTCOLOR, crColor, 4)
    TEST_FIELD_ALIGN (EMRSETTEXTCOLOR, crColor, 4)
    TEST_FIELD_OFFSET(EMRSETTEXTCOLOR, crColor, 8)
}

static void test_pack_EMRSETVIEWPORTEXTEX(void)
{
    /* EMRSETVIEWPORTEXTEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSETVIEWPORTEXTEX, 16)
    TEST_TYPE_ALIGN  (EMRSETVIEWPORTEXTEX, 4)
    TEST_FIELD_SIZE  (EMRSETVIEWPORTEXTEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSETVIEWPORTEXTEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSETVIEWPORTEXTEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSETVIEWPORTEXTEX, szlExtent, 8)
    TEST_FIELD_ALIGN (EMRSETVIEWPORTEXTEX, szlExtent, 4)
    TEST_FIELD_OFFSET(EMRSETVIEWPORTEXTEX, szlExtent, 8)
}

static void test_pack_EMRSETVIEWPORTORGEX(void)
{
    /* EMRSETVIEWPORTORGEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSETVIEWPORTORGEX, 16)
    TEST_TYPE_ALIGN  (EMRSETVIEWPORTORGEX, 4)
    TEST_FIELD_SIZE  (EMRSETVIEWPORTORGEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSETVIEWPORTORGEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSETVIEWPORTORGEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSETVIEWPORTORGEX, ptlOrigin, 8)
    TEST_FIELD_ALIGN (EMRSETVIEWPORTORGEX, ptlOrigin, 4)
    TEST_FIELD_OFFSET(EMRSETVIEWPORTORGEX, ptlOrigin, 8)
}

static void test_pack_EMRSETWINDOWEXTEX(void)
{
    /* EMRSETWINDOWEXTEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSETWINDOWEXTEX, 16)
    TEST_TYPE_ALIGN  (EMRSETWINDOWEXTEX, 4)
    TEST_FIELD_SIZE  (EMRSETWINDOWEXTEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSETWINDOWEXTEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSETWINDOWEXTEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSETWINDOWEXTEX, szlExtent, 8)
    TEST_FIELD_ALIGN (EMRSETWINDOWEXTEX, szlExtent, 4)
    TEST_FIELD_OFFSET(EMRSETWINDOWEXTEX, szlExtent, 8)
}

static void test_pack_EMRSETWINDOWORGEX(void)
{
    /* EMRSETWINDOWORGEX (pack 4) */
    TEST_TYPE_SIZE   (EMRSETWINDOWORGEX, 16)
    TEST_TYPE_ALIGN  (EMRSETWINDOWORGEX, 4)
    TEST_FIELD_SIZE  (EMRSETWINDOWORGEX, emr, 8)
    TEST_FIELD_ALIGN (EMRSETWINDOWORGEX, emr, 4)
    TEST_FIELD_OFFSET(EMRSETWINDOWORGEX, emr, 0)
    TEST_FIELD_SIZE  (EMRSETWINDOWORGEX, ptlOrigin, 8)
    TEST_FIELD_ALIGN (EMRSETWINDOWORGEX, ptlOrigin, 4)
    TEST_FIELD_OFFSET(EMRSETWINDOWORGEX, ptlOrigin, 8)
}

static void test_pack_EMRSETWORLDTRANSFORM(void)
{
    /* EMRSETWORLDTRANSFORM (pack 4) */
    TEST_TYPE_SIZE   (EMRSETWORLDTRANSFORM, 32)
    TEST_TYPE_ALIGN  (EMRSETWORLDTRANSFORM, 4)
    TEST_FIELD_SIZE  (EMRSETWORLDTRANSFORM, emr, 8)
    TEST_FIELD_ALIGN (EMRSETWORLDTRANSFORM, emr, 4)
    TEST_FIELD_OFFSET(EMRSETWORLDTRANSFORM, emr, 0)
    TEST_FIELD_SIZE  (EMRSETWORLDTRANSFORM, xform, 24)
    TEST_FIELD_ALIGN (EMRSETWORLDTRANSFORM, xform, 4)
    TEST_FIELD_OFFSET(EMRSETWORLDTRANSFORM, xform, 8)
}

static void test_pack_EMRSTRETCHBLT(void)
{
    /* EMRSTRETCHBLT (pack 4) */
    TEST_TYPE_SIZE   (EMRSTRETCHBLT, 108)
    TEST_TYPE_ALIGN  (EMRSTRETCHBLT, 4)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, emr, 8)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, emr, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, emr, 0)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, xDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, xDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, xDest, 24)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, yDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, yDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, yDest, 28)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, cxDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, cxDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, cxDest, 32)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, cyDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, cyDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, cyDest, 36)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, dwRop, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, dwRop, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, dwRop, 40)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, xSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, xSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, xSrc, 44)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, ySrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, ySrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, ySrc, 48)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, xformSrc, 24)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, xformSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, xformSrc, 52)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, crBkColorSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, crBkColorSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, crBkColorSrc, 76)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, iUsageSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, iUsageSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, iUsageSrc, 80)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, offBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, offBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, offBmiSrc, 84)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, cbBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, cbBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, cbBmiSrc, 88)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, offBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, offBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, offBitsSrc, 92)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, cbBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, cbBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, cbBitsSrc, 96)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, cxSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, cxSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, cxSrc, 100)
    TEST_FIELD_SIZE  (EMRSTRETCHBLT, cySrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHBLT, cySrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHBLT, cySrc, 104)
}

static void test_pack_EMRSTRETCHDIBITS(void)
{
    /* EMRSTRETCHDIBITS (pack 4) */
    TEST_TYPE_SIZE   (EMRSTRETCHDIBITS, 80)
    TEST_TYPE_ALIGN  (EMRSTRETCHDIBITS, 4)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, emr, 8)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, emr, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, emr, 0)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, rclBounds, 8)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, xDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, xDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, xDest, 24)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, yDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, yDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, yDest, 28)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, xSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, xSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, xSrc, 32)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, ySrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, ySrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, ySrc, 36)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, cxSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, cxSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, cxSrc, 40)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, cySrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, cySrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, cySrc, 44)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, offBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, offBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, offBmiSrc, 48)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, cbBmiSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, cbBmiSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, cbBmiSrc, 52)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, offBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, offBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, offBitsSrc, 56)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, cbBitsSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, cbBitsSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, cbBitsSrc, 60)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, iUsageSrc, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, iUsageSrc, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, iUsageSrc, 64)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, dwRop, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, dwRop, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, dwRop, 68)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, cxDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, cxDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, cxDest, 72)
    TEST_FIELD_SIZE  (EMRSTRETCHDIBITS, cyDest, 4)
    TEST_FIELD_ALIGN (EMRSTRETCHDIBITS, cyDest, 4)
    TEST_FIELD_OFFSET(EMRSTRETCHDIBITS, cyDest, 76)
}

static void test_pack_EMRSTROKEANDFILLPATH(void)
{
    /* EMRSTROKEANDFILLPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRSTROKEANDFILLPATH, 24)
    TEST_TYPE_ALIGN  (EMRSTROKEANDFILLPATH, 4)
    TEST_FIELD_SIZE  (EMRSTROKEANDFILLPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRSTROKEANDFILLPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRSTROKEANDFILLPATH, emr, 0)
    TEST_FIELD_SIZE  (EMRSTROKEANDFILLPATH, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRSTROKEANDFILLPATH, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRSTROKEANDFILLPATH, rclBounds, 8)
}

static void test_pack_EMRSTROKEPATH(void)
{
    /* EMRSTROKEPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRSTROKEPATH, 24)
    TEST_TYPE_ALIGN  (EMRSTROKEPATH, 4)
    TEST_FIELD_SIZE  (EMRSTROKEPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRSTROKEPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRSTROKEPATH, emr, 0)
    TEST_FIELD_SIZE  (EMRSTROKEPATH, rclBounds, 16)
    TEST_FIELD_ALIGN (EMRSTROKEPATH, rclBounds, 4)
    TEST_FIELD_OFFSET(EMRSTROKEPATH, rclBounds, 8)
}

static void test_pack_EMRTEXT(void)
{
    /* EMRTEXT (pack 4) */
    TEST_TYPE_SIZE   (EMRTEXT, 40)
    TEST_TYPE_ALIGN  (EMRTEXT, 4)
    TEST_FIELD_SIZE  (EMRTEXT, ptlReference, 8)
    TEST_FIELD_ALIGN (EMRTEXT, ptlReference, 4)
    TEST_FIELD_OFFSET(EMRTEXT, ptlReference, 0)
    TEST_FIELD_SIZE  (EMRTEXT, nChars, 4)
    TEST_FIELD_ALIGN (EMRTEXT, nChars, 4)
    TEST_FIELD_OFFSET(EMRTEXT, nChars, 8)
    TEST_FIELD_SIZE  (EMRTEXT, offString, 4)
    TEST_FIELD_ALIGN (EMRTEXT, offString, 4)
    TEST_FIELD_OFFSET(EMRTEXT, offString, 12)
    TEST_FIELD_SIZE  (EMRTEXT, fOptions, 4)
    TEST_FIELD_ALIGN (EMRTEXT, fOptions, 4)
    TEST_FIELD_OFFSET(EMRTEXT, fOptions, 16)
    TEST_FIELD_SIZE  (EMRTEXT, rcl, 16)
    TEST_FIELD_ALIGN (EMRTEXT, rcl, 4)
    TEST_FIELD_OFFSET(EMRTEXT, rcl, 20)
    TEST_FIELD_SIZE  (EMRTEXT, offDx, 4)
    TEST_FIELD_ALIGN (EMRTEXT, offDx, 4)
    TEST_FIELD_OFFSET(EMRTEXT, offDx, 36)
}

static void test_pack_EMRWIDENPATH(void)
{
    /* EMRWIDENPATH (pack 4) */
    TEST_TYPE_SIZE   (EMRWIDENPATH, 8)
    TEST_TYPE_ALIGN  (EMRWIDENPATH, 4)
    TEST_FIELD_SIZE  (EMRWIDENPATH, emr, 8)
    TEST_FIELD_ALIGN (EMRWIDENPATH, emr, 4)
    TEST_FIELD_OFFSET(EMRWIDENPATH, emr, 0)
}

static void test_pack_ENHMETAHEADER(void)
{
    /* ENHMETAHEADER (pack 4) */
    TEST_TYPE_SIZE   (ENHMETAHEADER, 108)
    TEST_TYPE_ALIGN  (ENHMETAHEADER, 4)
    TEST_FIELD_SIZE  (ENHMETAHEADER, iType, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, iType, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, iType, 0)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nSize, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nSize, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nSize, 4)
    TEST_FIELD_SIZE  (ENHMETAHEADER, rclBounds, 16)
    TEST_FIELD_ALIGN (ENHMETAHEADER, rclBounds, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, rclBounds, 8)
    TEST_FIELD_SIZE  (ENHMETAHEADER, rclFrame, 16)
    TEST_FIELD_ALIGN (ENHMETAHEADER, rclFrame, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, rclFrame, 24)
    TEST_FIELD_SIZE  (ENHMETAHEADER, dSignature, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, dSignature, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, dSignature, 40)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nVersion, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nVersion, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nVersion, 44)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nBytes, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nBytes, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nBytes, 48)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nRecords, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nRecords, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nRecords, 52)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nHandles, 2)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nHandles, 2)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nHandles, 56)
    TEST_FIELD_SIZE  (ENHMETAHEADER, sReserved, 2)
    TEST_FIELD_ALIGN (ENHMETAHEADER, sReserved, 2)
    TEST_FIELD_OFFSET(ENHMETAHEADER, sReserved, 58)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nDescription, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nDescription, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nDescription, 60)
    TEST_FIELD_SIZE  (ENHMETAHEADER, offDescription, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, offDescription, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, offDescription, 64)
    TEST_FIELD_SIZE  (ENHMETAHEADER, nPalEntries, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, nPalEntries, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, nPalEntries, 68)
    TEST_FIELD_SIZE  (ENHMETAHEADER, szlDevice, 8)
    TEST_FIELD_ALIGN (ENHMETAHEADER, szlDevice, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, szlDevice, 72)
    TEST_FIELD_SIZE  (ENHMETAHEADER, szlMillimeters, 8)
    TEST_FIELD_ALIGN (ENHMETAHEADER, szlMillimeters, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, szlMillimeters, 80)
    TEST_FIELD_SIZE  (ENHMETAHEADER, cbPixelFormat, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, cbPixelFormat, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, cbPixelFormat, 88)
    TEST_FIELD_SIZE  (ENHMETAHEADER, offPixelFormat, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, offPixelFormat, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, offPixelFormat, 92)
    TEST_FIELD_SIZE  (ENHMETAHEADER, bOpenGL, 4)
    TEST_FIELD_ALIGN (ENHMETAHEADER, bOpenGL, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, bOpenGL, 96)
    TEST_FIELD_SIZE  (ENHMETAHEADER, szlMicrometers, 8)
    TEST_FIELD_ALIGN (ENHMETAHEADER, szlMicrometers, 4)
    TEST_FIELD_OFFSET(ENHMETAHEADER, szlMicrometers, 100)
}

static void test_pack_ENHMETARECORD(void)
{
    /* ENHMETARECORD (pack 4) */
    TEST_TYPE_SIZE   (ENHMETARECORD, 12)
    TEST_TYPE_ALIGN  (ENHMETARECORD, 4)
    TEST_FIELD_SIZE  (ENHMETARECORD, iType, 4)
    TEST_FIELD_ALIGN (ENHMETARECORD, iType, 4)
    TEST_FIELD_OFFSET(ENHMETARECORD, iType, 0)
    TEST_FIELD_SIZE  (ENHMETARECORD, nSize, 4)
    TEST_FIELD_ALIGN (ENHMETARECORD, nSize, 4)
    TEST_FIELD_OFFSET(ENHMETARECORD, nSize, 4)
    TEST_FIELD_SIZE  (ENHMETARECORD, dParm, 4)
    TEST_FIELD_ALIGN (ENHMETARECORD, dParm, 4)
    TEST_FIELD_OFFSET(ENHMETARECORD, dParm, 8)
}

static void test_pack_ENHMFENUMPROC(void)
{
    /* ENHMFENUMPROC */
    TEST_TYPE_SIZE   (ENHMFENUMPROC, 4)
    TEST_TYPE_ALIGN  (ENHMFENUMPROC, 4)
}

static void test_pack_ENUMLOGFONTA(void)
{
    /* ENUMLOGFONTA (pack 4) */
    TEST_TYPE_SIZE   (ENUMLOGFONTA, 156)
    TEST_TYPE_ALIGN  (ENUMLOGFONTA, 4)
    TEST_FIELD_SIZE  (ENUMLOGFONTA, elfLogFont, 60)
    TEST_FIELD_ALIGN (ENUMLOGFONTA, elfLogFont, 4)
    TEST_FIELD_OFFSET(ENUMLOGFONTA, elfLogFont, 0)
    TEST_FIELD_SIZE  (ENUMLOGFONTA, elfFullName, 64)
    TEST_FIELD_ALIGN (ENUMLOGFONTA, elfFullName, 1)
    TEST_FIELD_OFFSET(ENUMLOGFONTA, elfFullName, 60)
    TEST_FIELD_SIZE  (ENUMLOGFONTA, elfStyle, 32)
    TEST_FIELD_ALIGN (ENUMLOGFONTA, elfStyle, 1)
    TEST_FIELD_OFFSET(ENUMLOGFONTA, elfStyle, 124)
}

static void test_pack_ENUMLOGFONTEXA(void)
{
    /* ENUMLOGFONTEXA (pack 4) */
    TEST_TYPE_SIZE   (ENUMLOGFONTEXA, 188)
    TEST_TYPE_ALIGN  (ENUMLOGFONTEXA, 4)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXA, elfLogFont, 60)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXA, elfLogFont, 4)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXA, elfLogFont, 0)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXA, elfFullName, 64)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXA, elfFullName, 1)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXA, elfFullName, 60)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXA, elfStyle, 32)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXA, elfStyle, 1)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXA, elfStyle, 124)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXA, elfScript, 32)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXA, elfScript, 1)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXA, elfScript, 156)
}

static void test_pack_ENUMLOGFONTEXW(void)
{
    /* ENUMLOGFONTEXW (pack 4) */
    TEST_TYPE_SIZE   (ENUMLOGFONTEXW, 348)
    TEST_TYPE_ALIGN  (ENUMLOGFONTEXW, 4)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXW, elfLogFont, 92)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXW, elfLogFont, 4)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXW, elfLogFont, 0)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXW, elfFullName, 128)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXW, elfFullName, 2)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXW, elfFullName, 92)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXW, elfStyle, 64)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXW, elfStyle, 2)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXW, elfStyle, 220)
    TEST_FIELD_SIZE  (ENUMLOGFONTEXW, elfScript, 64)
    TEST_FIELD_ALIGN (ENUMLOGFONTEXW, elfScript, 2)
    TEST_FIELD_OFFSET(ENUMLOGFONTEXW, elfScript, 284)
}

static void test_pack_ENUMLOGFONTW(void)
{
    /* ENUMLOGFONTW (pack 4) */
    TEST_TYPE_SIZE   (ENUMLOGFONTW, 284)
    TEST_TYPE_ALIGN  (ENUMLOGFONTW, 4)
    TEST_FIELD_SIZE  (ENUMLOGFONTW, elfLogFont, 92)
    TEST_FIELD_ALIGN (ENUMLOGFONTW, elfLogFont, 4)
    TEST_FIELD_OFFSET(ENUMLOGFONTW, elfLogFont, 0)
    TEST_FIELD_SIZE  (ENUMLOGFONTW, elfFullName, 128)
    TEST_FIELD_ALIGN (ENUMLOGFONTW, elfFullName, 2)
    TEST_FIELD_OFFSET(ENUMLOGFONTW, elfFullName, 92)
    TEST_FIELD_SIZE  (ENUMLOGFONTW, elfStyle, 64)
    TEST_FIELD_ALIGN (ENUMLOGFONTW, elfStyle, 2)
    TEST_FIELD_OFFSET(ENUMLOGFONTW, elfStyle, 220)
}

static void test_pack_EXTLOGFONTA(void)
{
    /* EXTLOGFONTA (pack 4) */
    TEST_TYPE_SIZE   (EXTLOGFONTA, 192)
    TEST_TYPE_ALIGN  (EXTLOGFONTA, 4)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfLogFont, 60)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfLogFont, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfLogFont, 0)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfFullName, 64)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfFullName, 1)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfFullName, 60)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfStyle, 32)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfStyle, 1)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfStyle, 124)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfVersion, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfVersion, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfVersion, 156)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfStyleSize, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfStyleSize, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfStyleSize, 160)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfMatch, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfMatch, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfMatch, 164)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfReserved, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfReserved, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfReserved, 168)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfVendorId, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfVendorId, 1)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfVendorId, 172)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfCulture, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfCulture, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfCulture, 176)
    TEST_FIELD_SIZE  (EXTLOGFONTA, elfPanose, 10)
    TEST_FIELD_ALIGN (EXTLOGFONTA, elfPanose, 1)
    TEST_FIELD_OFFSET(EXTLOGFONTA, elfPanose, 180)
}

static void test_pack_EXTLOGFONTW(void)
{
    /* EXTLOGFONTW (pack 4) */
    TEST_TYPE_SIZE   (EXTLOGFONTW, 320)
    TEST_TYPE_ALIGN  (EXTLOGFONTW, 4)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfLogFont, 92)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfLogFont, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfLogFont, 0)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfFullName, 128)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfFullName, 2)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfFullName, 92)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfStyle, 64)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfStyle, 2)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfStyle, 220)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfVersion, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfVersion, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfVersion, 284)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfStyleSize, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfStyleSize, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfStyleSize, 288)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfMatch, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfMatch, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfMatch, 292)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfReserved, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfReserved, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfReserved, 296)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfVendorId, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfVendorId, 1)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfVendorId, 300)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfCulture, 4)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfCulture, 4)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfCulture, 304)
    TEST_FIELD_SIZE  (EXTLOGFONTW, elfPanose, 10)
    TEST_FIELD_ALIGN (EXTLOGFONTW, elfPanose, 1)
    TEST_FIELD_OFFSET(EXTLOGFONTW, elfPanose, 308)
}

static void test_pack_EXTLOGPEN(void)
{
    /* EXTLOGPEN (pack 4) */
    TEST_TYPE_SIZE   (EXTLOGPEN, 28)
    TEST_TYPE_ALIGN  (EXTLOGPEN, 4)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpPenStyle, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpPenStyle, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpPenStyle, 0)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpWidth, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpWidth, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpWidth, 4)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpBrushStyle, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpBrushStyle, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpBrushStyle, 8)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpColor, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpColor, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpColor, 12)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpHatch, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpHatch, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpHatch, 16)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpNumEntries, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpNumEntries, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpNumEntries, 20)
    TEST_FIELD_SIZE  (EXTLOGPEN, elpStyleEntry, 4)
    TEST_FIELD_ALIGN (EXTLOGPEN, elpStyleEntry, 4)
    TEST_FIELD_OFFSET(EXTLOGPEN, elpStyleEntry, 24)
}

static void test_pack_FIXED(void)
{
    /* FIXED (pack 4) */
    TEST_TYPE_SIZE   (FIXED, 4)
    TEST_TYPE_ALIGN  (FIXED, 2)
    TEST_FIELD_SIZE  (FIXED, fract, 2)
    TEST_FIELD_ALIGN (FIXED, fract, 2)
    TEST_FIELD_OFFSET(FIXED, fract, 0)
    TEST_FIELD_SIZE  (FIXED, value, 2)
    TEST_FIELD_ALIGN (FIXED, value, 2)
    TEST_FIELD_OFFSET(FIXED, value, 2)
}

static void test_pack_FONTENUMPROCA(void)
{
    /* FONTENUMPROCA */
    TEST_TYPE_SIZE   (FONTENUMPROCA, 4)
    TEST_TYPE_ALIGN  (FONTENUMPROCA, 4)
}

static void test_pack_FONTENUMPROCW(void)
{
    /* FONTENUMPROCW */
    TEST_TYPE_SIZE   (FONTENUMPROCW, 4)
    TEST_TYPE_ALIGN  (FONTENUMPROCW, 4)
}

static void test_pack_FONTSIGNATURE(void)
{
    /* FONTSIGNATURE (pack 4) */
    TEST_TYPE_SIZE   (FONTSIGNATURE, 24)
    TEST_TYPE_ALIGN  (FONTSIGNATURE, 4)
    TEST_FIELD_SIZE  (FONTSIGNATURE, fsUsb, 16)
    TEST_FIELD_ALIGN (FONTSIGNATURE, fsUsb, 4)
    TEST_FIELD_OFFSET(FONTSIGNATURE, fsUsb, 0)
    TEST_FIELD_SIZE  (FONTSIGNATURE, fsCsb, 8)
    TEST_FIELD_ALIGN (FONTSIGNATURE, fsCsb, 4)
    TEST_FIELD_OFFSET(FONTSIGNATURE, fsCsb, 16)
}

static void test_pack_FXPT16DOT16(void)
{
    /* FXPT16DOT16 */
    TEST_TYPE_SIZE   (FXPT16DOT16, 4)
    TEST_TYPE_ALIGN  (FXPT16DOT16, 4)
}

static void test_pack_FXPT2DOT30(void)
{
    /* FXPT2DOT30 */
    TEST_TYPE_SIZE   (FXPT2DOT30, 4)
    TEST_TYPE_ALIGN  (FXPT2DOT30, 4)
}

static void test_pack_GCP_RESULTSA(void)
{
    /* GCP_RESULTSA (pack 4) */
    TEST_TYPE_SIZE   (GCP_RESULTSA, 36)
    TEST_TYPE_ALIGN  (GCP_RESULTSA, 4)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lStructSize, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lStructSize, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lStructSize, 0)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lpOutString, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lpOutString, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lpOutString, 4)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lpOrder, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lpOrder, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lpOrder, 8)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lpDx, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lpDx, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lpDx, 12)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lpCaretPos, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lpCaretPos, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lpCaretPos, 16)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lpClass, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lpClass, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lpClass, 20)
    TEST_FIELD_SIZE  (GCP_RESULTSA, lpGlyphs, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, lpGlyphs, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, lpGlyphs, 24)
    TEST_FIELD_SIZE  (GCP_RESULTSA, nGlyphs, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, nGlyphs, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, nGlyphs, 28)
    TEST_FIELD_SIZE  (GCP_RESULTSA, nMaxFit, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSA, nMaxFit, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSA, nMaxFit, 32)
}

static void test_pack_GCP_RESULTSW(void)
{
    /* GCP_RESULTSW (pack 4) */
    TEST_TYPE_SIZE   (GCP_RESULTSW, 36)
    TEST_TYPE_ALIGN  (GCP_RESULTSW, 4)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lStructSize, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lStructSize, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lStructSize, 0)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lpOutString, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lpOutString, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lpOutString, 4)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lpOrder, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lpOrder, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lpOrder, 8)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lpDx, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lpDx, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lpDx, 12)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lpCaretPos, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lpCaretPos, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lpCaretPos, 16)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lpClass, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lpClass, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lpClass, 20)
    TEST_FIELD_SIZE  (GCP_RESULTSW, lpGlyphs, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, lpGlyphs, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, lpGlyphs, 24)
    TEST_FIELD_SIZE  (GCP_RESULTSW, nGlyphs, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, nGlyphs, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, nGlyphs, 28)
    TEST_FIELD_SIZE  (GCP_RESULTSW, nMaxFit, 4)
    TEST_FIELD_ALIGN (GCP_RESULTSW, nMaxFit, 4)
    TEST_FIELD_OFFSET(GCP_RESULTSW, nMaxFit, 32)
}

static void test_pack_GLYPHMETRICS(void)
{
    /* GLYPHMETRICS (pack 4) */
    TEST_TYPE_SIZE   (GLYPHMETRICS, 20)
    TEST_TYPE_ALIGN  (GLYPHMETRICS, 4)
    TEST_FIELD_SIZE  (GLYPHMETRICS, gmBlackBoxX, 4)
    TEST_FIELD_ALIGN (GLYPHMETRICS, gmBlackBoxX, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICS, gmBlackBoxX, 0)
    TEST_FIELD_SIZE  (GLYPHMETRICS, gmBlackBoxY, 4)
    TEST_FIELD_ALIGN (GLYPHMETRICS, gmBlackBoxY, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICS, gmBlackBoxY, 4)
    TEST_FIELD_SIZE  (GLYPHMETRICS, gmptGlyphOrigin, 8)
    TEST_FIELD_ALIGN (GLYPHMETRICS, gmptGlyphOrigin, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICS, gmptGlyphOrigin, 8)
    TEST_FIELD_SIZE  (GLYPHMETRICS, gmCellIncX, 2)
    TEST_FIELD_ALIGN (GLYPHMETRICS, gmCellIncX, 2)
    TEST_FIELD_OFFSET(GLYPHMETRICS, gmCellIncX, 16)
    TEST_FIELD_SIZE  (GLYPHMETRICS, gmCellIncY, 2)
    TEST_FIELD_ALIGN (GLYPHMETRICS, gmCellIncY, 2)
    TEST_FIELD_OFFSET(GLYPHMETRICS, gmCellIncY, 18)
}

static void test_pack_GLYPHMETRICSFLOAT(void)
{
    /* GLYPHMETRICSFLOAT (pack 4) */
    TEST_TYPE_SIZE   (GLYPHMETRICSFLOAT, 24)
    TEST_TYPE_ALIGN  (GLYPHMETRICSFLOAT, 4)
    TEST_FIELD_SIZE  (GLYPHMETRICSFLOAT, gmfBlackBoxX, 4)
    TEST_FIELD_ALIGN (GLYPHMETRICSFLOAT, gmfBlackBoxX, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICSFLOAT, gmfBlackBoxX, 0)
    TEST_FIELD_SIZE  (GLYPHMETRICSFLOAT, gmfBlackBoxY, 4)
    TEST_FIELD_ALIGN (GLYPHMETRICSFLOAT, gmfBlackBoxY, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICSFLOAT, gmfBlackBoxY, 4)
    TEST_FIELD_SIZE  (GLYPHMETRICSFLOAT, gmfptGlyphOrigin, 8)
    TEST_FIELD_ALIGN (GLYPHMETRICSFLOAT, gmfptGlyphOrigin, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICSFLOAT, gmfptGlyphOrigin, 8)
    TEST_FIELD_SIZE  (GLYPHMETRICSFLOAT, gmfCellIncX, 4)
    TEST_FIELD_ALIGN (GLYPHMETRICSFLOAT, gmfCellIncX, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICSFLOAT, gmfCellIncX, 16)
    TEST_FIELD_SIZE  (GLYPHMETRICSFLOAT, gmfCellIncY, 4)
    TEST_FIELD_ALIGN (GLYPHMETRICSFLOAT, gmfCellIncY, 4)
    TEST_FIELD_OFFSET(GLYPHMETRICSFLOAT, gmfCellIncY, 20)
}

static void test_pack_GOBJENUMPROC(void)
{
    /* GOBJENUMPROC */
    TEST_TYPE_SIZE   (GOBJENUMPROC, 4)
    TEST_TYPE_ALIGN  (GOBJENUMPROC, 4)
}

static void test_pack_GRADIENT_RECT(void)
{
    /* GRADIENT_RECT (pack 4) */
    TEST_TYPE_SIZE   (GRADIENT_RECT, 8)
    TEST_TYPE_ALIGN  (GRADIENT_RECT, 4)
    TEST_FIELD_SIZE  (GRADIENT_RECT, UpperLeft, 4)
    TEST_FIELD_ALIGN (GRADIENT_RECT, UpperLeft, 4)
    TEST_FIELD_OFFSET(GRADIENT_RECT, UpperLeft, 0)
    TEST_FIELD_SIZE  (GRADIENT_RECT, LowerRight, 4)
    TEST_FIELD_ALIGN (GRADIENT_RECT, LowerRight, 4)
    TEST_FIELD_OFFSET(GRADIENT_RECT, LowerRight, 4)
}

static void test_pack_GRADIENT_TRIANGLE(void)
{
    /* GRADIENT_TRIANGLE (pack 4) */
    TEST_TYPE_SIZE   (GRADIENT_TRIANGLE, 12)
    TEST_TYPE_ALIGN  (GRADIENT_TRIANGLE, 4)
    TEST_FIELD_SIZE  (GRADIENT_TRIANGLE, Vertex1, 4)
    TEST_FIELD_ALIGN (GRADIENT_TRIANGLE, Vertex1, 4)
    TEST_FIELD_OFFSET(GRADIENT_TRIANGLE, Vertex1, 0)
    TEST_FIELD_SIZE  (GRADIENT_TRIANGLE, Vertex2, 4)
    TEST_FIELD_ALIGN (GRADIENT_TRIANGLE, Vertex2, 4)
    TEST_FIELD_OFFSET(GRADIENT_TRIANGLE, Vertex2, 4)
    TEST_FIELD_SIZE  (GRADIENT_TRIANGLE, Vertex3, 4)
    TEST_FIELD_ALIGN (GRADIENT_TRIANGLE, Vertex3, 4)
    TEST_FIELD_OFFSET(GRADIENT_TRIANGLE, Vertex3, 8)
}

static void test_pack_HANDLETABLE(void)
{
    /* HANDLETABLE (pack 4) */
    TEST_TYPE_SIZE   (HANDLETABLE, 4)
    TEST_TYPE_ALIGN  (HANDLETABLE, 4)
    TEST_FIELD_SIZE  (HANDLETABLE, objectHandle, 4)
    TEST_FIELD_ALIGN (HANDLETABLE, objectHandle, 4)
    TEST_FIELD_OFFSET(HANDLETABLE, objectHandle, 0)
}

static void test_pack_ICMENUMPROCA(void)
{
    /* ICMENUMPROCA */
    TEST_TYPE_SIZE   (ICMENUMPROCA, 4)
    TEST_TYPE_ALIGN  (ICMENUMPROCA, 4)
}

static void test_pack_ICMENUMPROCW(void)
{
    /* ICMENUMPROCW */
    TEST_TYPE_SIZE   (ICMENUMPROCW, 4)
    TEST_TYPE_ALIGN  (ICMENUMPROCW, 4)
}

static void test_pack_KERNINGPAIR(void)
{
    /* KERNINGPAIR (pack 4) */
    TEST_TYPE_SIZE   (KERNINGPAIR, 8)
    TEST_TYPE_ALIGN  (KERNINGPAIR, 4)
    TEST_FIELD_SIZE  (KERNINGPAIR, wFirst, 2)
    TEST_FIELD_ALIGN (KERNINGPAIR, wFirst, 2)
    TEST_FIELD_OFFSET(KERNINGPAIR, wFirst, 0)
    TEST_FIELD_SIZE  (KERNINGPAIR, wSecond, 2)
    TEST_FIELD_ALIGN (KERNINGPAIR, wSecond, 2)
    TEST_FIELD_OFFSET(KERNINGPAIR, wSecond, 2)
    TEST_FIELD_SIZE  (KERNINGPAIR, iKernAmount, 4)
    TEST_FIELD_ALIGN (KERNINGPAIR, iKernAmount, 4)
    TEST_FIELD_OFFSET(KERNINGPAIR, iKernAmount, 4)
}

static void test_pack_LAYERPLANEDESCRIPTOR(void)
{
    /* LAYERPLANEDESCRIPTOR (pack 4) */
    TEST_TYPE_SIZE   (LAYERPLANEDESCRIPTOR, 32)
    TEST_TYPE_ALIGN  (LAYERPLANEDESCRIPTOR, 4)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, nSize, 2)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, nSize, 2)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, nSize, 0)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, nVersion, 2)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, nVersion, 2)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, nVersion, 2)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, dwFlags, 4)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, dwFlags, 4)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, dwFlags, 4)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, iPixelType, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, iPixelType, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, iPixelType, 8)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cColorBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cColorBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cColorBits, 9)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cRedBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cRedBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cRedBits, 10)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cRedShift, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cRedShift, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cRedShift, 11)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cGreenBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cGreenBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cGreenBits, 12)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cGreenShift, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cGreenShift, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cGreenShift, 13)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cBlueBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cBlueBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cBlueBits, 14)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cBlueShift, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cBlueShift, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cBlueShift, 15)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAlphaBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAlphaBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAlphaBits, 16)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAlphaShift, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAlphaShift, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAlphaShift, 17)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAccumBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAccumBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAccumBits, 18)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAccumRedBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAccumRedBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAccumRedBits, 19)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAccumGreenBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAccumGreenBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAccumGreenBits, 20)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAccumBlueBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAccumBlueBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAccumBlueBits, 21)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAccumAlphaBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAccumAlphaBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAccumAlphaBits, 22)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cDepthBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cDepthBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cDepthBits, 23)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cStencilBits, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cStencilBits, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cStencilBits, 24)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, cAuxBuffers, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, cAuxBuffers, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, cAuxBuffers, 25)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, iLayerPlane, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, iLayerPlane, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, iLayerPlane, 26)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, bReserved, 1)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, bReserved, 1)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, bReserved, 27)
    TEST_FIELD_SIZE  (LAYERPLANEDESCRIPTOR, crTransparent, 4)
    TEST_FIELD_ALIGN (LAYERPLANEDESCRIPTOR, crTransparent, 4)
    TEST_FIELD_OFFSET(LAYERPLANEDESCRIPTOR, crTransparent, 28)
}

static void test_pack_LCSCSTYPE(void)
{
    /* LCSCSTYPE */
    TEST_TYPE_SIZE   (LCSCSTYPE, 4)
    TEST_TYPE_ALIGN  (LCSCSTYPE, 4)
}

static void test_pack_LCSGAMUTMATCH(void)
{
    /* LCSGAMUTMATCH */
    TEST_TYPE_SIZE   (LCSGAMUTMATCH, 4)
    TEST_TYPE_ALIGN  (LCSGAMUTMATCH, 4)
}

static void test_pack_LINEDDAPROC(void)
{
    /* LINEDDAPROC */
    TEST_TYPE_SIZE   (LINEDDAPROC, 4)
    TEST_TYPE_ALIGN  (LINEDDAPROC, 4)
}

static void test_pack_LOCALESIGNATURE(void)
{
    /* LOCALESIGNATURE (pack 4) */
    TEST_TYPE_SIZE   (LOCALESIGNATURE, 32)
    TEST_TYPE_ALIGN  (LOCALESIGNATURE, 4)
    TEST_FIELD_SIZE  (LOCALESIGNATURE, lsUsb, 16)
    TEST_FIELD_ALIGN (LOCALESIGNATURE, lsUsb, 4)
    TEST_FIELD_OFFSET(LOCALESIGNATURE, lsUsb, 0)
    TEST_FIELD_SIZE  (LOCALESIGNATURE, lsCsbDefault, 8)
    TEST_FIELD_ALIGN (LOCALESIGNATURE, lsCsbDefault, 4)
    TEST_FIELD_OFFSET(LOCALESIGNATURE, lsCsbDefault, 16)
    TEST_FIELD_SIZE  (LOCALESIGNATURE, lsCsbSupported, 8)
    TEST_FIELD_ALIGN (LOCALESIGNATURE, lsCsbSupported, 4)
    TEST_FIELD_OFFSET(LOCALESIGNATURE, lsCsbSupported, 24)
}

static void test_pack_LOGBRUSH(void)
{
    /* LOGBRUSH (pack 4) */
    TEST_TYPE_SIZE   (LOGBRUSH, 12)
    TEST_TYPE_ALIGN  (LOGBRUSH, 4)
    TEST_FIELD_SIZE  (LOGBRUSH, lbStyle, 4)
    TEST_FIELD_ALIGN (LOGBRUSH, lbStyle, 4)
    TEST_FIELD_OFFSET(LOGBRUSH, lbStyle, 0)
    TEST_FIELD_SIZE  (LOGBRUSH, lbColor, 4)
    TEST_FIELD_ALIGN (LOGBRUSH, lbColor, 4)
    TEST_FIELD_OFFSET(LOGBRUSH, lbColor, 4)
    TEST_FIELD_SIZE  (LOGBRUSH, lbHatch, 4)
    TEST_FIELD_ALIGN (LOGBRUSH, lbHatch, 4)
    TEST_FIELD_OFFSET(LOGBRUSH, lbHatch, 8)
}

static void test_pack_LOGCOLORSPACEA(void)
{
    /* LOGCOLORSPACEA (pack 4) */
    TEST_TYPE_SIZE   (LOGCOLORSPACEA, 328)
    TEST_TYPE_ALIGN  (LOGCOLORSPACEA, 4)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsSignature, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsSignature, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsSignature, 0)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsVersion, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsVersion, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsVersion, 4)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsSize, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsSize, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsSize, 8)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsCSType, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsCSType, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsCSType, 12)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsIntent, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsIntent, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsIntent, 16)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsEndpoints, 36)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsEndpoints, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsEndpoints, 20)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsGammaRed, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsGammaRed, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsGammaRed, 56)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsGammaGreen, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsGammaGreen, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsGammaGreen, 60)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsGammaBlue, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsGammaBlue, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsGammaBlue, 64)
    TEST_FIELD_SIZE  (LOGCOLORSPACEA, lcsFilename, 260)
    TEST_FIELD_ALIGN (LOGCOLORSPACEA, lcsFilename, 1)
    TEST_FIELD_OFFSET(LOGCOLORSPACEA, lcsFilename, 68)
}

static void test_pack_LOGCOLORSPACEW(void)
{
    /* LOGCOLORSPACEW (pack 4) */
    TEST_TYPE_SIZE   (LOGCOLORSPACEW, 588)
    TEST_TYPE_ALIGN  (LOGCOLORSPACEW, 4)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsSignature, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsSignature, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsSignature, 0)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsVersion, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsVersion, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsVersion, 4)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsSize, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsSize, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsSize, 8)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsCSType, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsCSType, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsCSType, 12)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsIntent, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsIntent, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsIntent, 16)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsEndpoints, 36)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsEndpoints, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsEndpoints, 20)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsGammaRed, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsGammaRed, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsGammaRed, 56)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsGammaGreen, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsGammaGreen, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsGammaGreen, 60)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsGammaBlue, 4)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsGammaBlue, 4)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsGammaBlue, 64)
    TEST_FIELD_SIZE  (LOGCOLORSPACEW, lcsFilename, 520)
    TEST_FIELD_ALIGN (LOGCOLORSPACEW, lcsFilename, 2)
    TEST_FIELD_OFFSET(LOGCOLORSPACEW, lcsFilename, 68)
}

static void test_pack_LOGFONTA(void)
{
    /* LOGFONTA (pack 4) */
    TEST_TYPE_SIZE   (LOGFONTA, 60)
    TEST_TYPE_ALIGN  (LOGFONTA, 4)
    TEST_FIELD_SIZE  (LOGFONTA, lfHeight, 4)
    TEST_FIELD_ALIGN (LOGFONTA, lfHeight, 4)
    TEST_FIELD_OFFSET(LOGFONTA, lfHeight, 0)
    TEST_FIELD_SIZE  (LOGFONTA, lfWidth, 4)
    TEST_FIELD_ALIGN (LOGFONTA, lfWidth, 4)
    TEST_FIELD_OFFSET(LOGFONTA, lfWidth, 4)
    TEST_FIELD_SIZE  (LOGFONTA, lfEscapement, 4)
    TEST_FIELD_ALIGN (LOGFONTA, lfEscapement, 4)
    TEST_FIELD_OFFSET(LOGFONTA, lfEscapement, 8)
    TEST_FIELD_SIZE  (LOGFONTA, lfOrientation, 4)
    TEST_FIELD_ALIGN (LOGFONTA, lfOrientation, 4)
    TEST_FIELD_OFFSET(LOGFONTA, lfOrientation, 12)
    TEST_FIELD_SIZE  (LOGFONTA, lfWeight, 4)
    TEST_FIELD_ALIGN (LOGFONTA, lfWeight, 4)
    TEST_FIELD_OFFSET(LOGFONTA, lfWeight, 16)
    TEST_FIELD_SIZE  (LOGFONTA, lfItalic, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfItalic, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfItalic, 20)
    TEST_FIELD_SIZE  (LOGFONTA, lfUnderline, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfUnderline, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfUnderline, 21)
    TEST_FIELD_SIZE  (LOGFONTA, lfStrikeOut, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfStrikeOut, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfStrikeOut, 22)
    TEST_FIELD_SIZE  (LOGFONTA, lfCharSet, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfCharSet, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfCharSet, 23)
    TEST_FIELD_SIZE  (LOGFONTA, lfOutPrecision, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfOutPrecision, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfOutPrecision, 24)
    TEST_FIELD_SIZE  (LOGFONTA, lfClipPrecision, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfClipPrecision, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfClipPrecision, 25)
    TEST_FIELD_SIZE  (LOGFONTA, lfQuality, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfQuality, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfQuality, 26)
    TEST_FIELD_SIZE  (LOGFONTA, lfPitchAndFamily, 1)
    TEST_FIELD_ALIGN (LOGFONTA, lfPitchAndFamily, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfPitchAndFamily, 27)
    TEST_FIELD_SIZE  (LOGFONTA, lfFaceName, 32)
    TEST_FIELD_ALIGN (LOGFONTA, lfFaceName, 1)
    TEST_FIELD_OFFSET(LOGFONTA, lfFaceName, 28)
}

static void test_pack_LOGFONTW(void)
{
    /* LOGFONTW (pack 4) */
    TEST_TYPE_SIZE   (LOGFONTW, 92)
    TEST_TYPE_ALIGN  (LOGFONTW, 4)
    TEST_FIELD_SIZE  (LOGFONTW, lfHeight, 4)
    TEST_FIELD_ALIGN (LOGFONTW, lfHeight, 4)
    TEST_FIELD_OFFSET(LOGFONTW, lfHeight, 0)
    TEST_FIELD_SIZE  (LOGFONTW, lfWidth, 4)
    TEST_FIELD_ALIGN (LOGFONTW, lfWidth, 4)
    TEST_FIELD_OFFSET(LOGFONTW, lfWidth, 4)
    TEST_FIELD_SIZE  (LOGFONTW, lfEscapement, 4)
    TEST_FIELD_ALIGN (LOGFONTW, lfEscapement, 4)
    TEST_FIELD_OFFSET(LOGFONTW, lfEscapement, 8)
    TEST_FIELD_SIZE  (LOGFONTW, lfOrientation, 4)
    TEST_FIELD_ALIGN (LOGFONTW, lfOrientation, 4)
    TEST_FIELD_OFFSET(LOGFONTW, lfOrientation, 12)
    TEST_FIELD_SIZE  (LOGFONTW, lfWeight, 4)
    TEST_FIELD_ALIGN (LOGFONTW, lfWeight, 4)
    TEST_FIELD_OFFSET(LOGFONTW, lfWeight, 16)
    TEST_FIELD_SIZE  (LOGFONTW, lfItalic, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfItalic, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfItalic, 20)
    TEST_FIELD_SIZE  (LOGFONTW, lfUnderline, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfUnderline, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfUnderline, 21)
    TEST_FIELD_SIZE  (LOGFONTW, lfStrikeOut, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfStrikeOut, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfStrikeOut, 22)
    TEST_FIELD_SIZE  (LOGFONTW, lfCharSet, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfCharSet, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfCharSet, 23)
    TEST_FIELD_SIZE  (LOGFONTW, lfOutPrecision, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfOutPrecision, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfOutPrecision, 24)
    TEST_FIELD_SIZE  (LOGFONTW, lfClipPrecision, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfClipPrecision, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfClipPrecision, 25)
    TEST_FIELD_SIZE  (LOGFONTW, lfQuality, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfQuality, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfQuality, 26)
    TEST_FIELD_SIZE  (LOGFONTW, lfPitchAndFamily, 1)
    TEST_FIELD_ALIGN (LOGFONTW, lfPitchAndFamily, 1)
    TEST_FIELD_OFFSET(LOGFONTW, lfPitchAndFamily, 27)
    TEST_FIELD_SIZE  (LOGFONTW, lfFaceName, 64)
    TEST_FIELD_ALIGN (LOGFONTW, lfFaceName, 2)
    TEST_FIELD_OFFSET(LOGFONTW, lfFaceName, 28)
}

static void test_pack_LOGPEN(void)
{
    /* LOGPEN (pack 4) */
    TEST_TYPE_SIZE   (LOGPEN, 16)
    TEST_TYPE_ALIGN  (LOGPEN, 4)
    TEST_FIELD_SIZE  (LOGPEN, lopnStyle, 4)
    TEST_FIELD_ALIGN (LOGPEN, lopnStyle, 4)
    TEST_FIELD_OFFSET(LOGPEN, lopnStyle, 0)
    TEST_FIELD_SIZE  (LOGPEN, lopnWidth, 8)
    TEST_FIELD_ALIGN (LOGPEN, lopnWidth, 4)
    TEST_FIELD_OFFSET(LOGPEN, lopnWidth, 4)
    TEST_FIELD_SIZE  (LOGPEN, lopnColor, 4)
    TEST_FIELD_ALIGN (LOGPEN, lopnColor, 4)
    TEST_FIELD_OFFSET(LOGPEN, lopnColor, 12)
}

static void test_pack_LPABC(void)
{
    /* LPABC */
    TEST_TYPE_SIZE   (LPABC, 4)
    TEST_TYPE_ALIGN  (LPABC, 4)
    TEST_TARGET_SIZE (LPABC, 12)
    TEST_TARGET_ALIGN(LPABC, 4)
}

static void test_pack_LPABCFLOAT(void)
{
    /* LPABCFLOAT */
    TEST_TYPE_SIZE   (LPABCFLOAT, 4)
    TEST_TYPE_ALIGN  (LPABCFLOAT, 4)
    TEST_TARGET_SIZE (LPABCFLOAT, 12)
    TEST_TARGET_ALIGN(LPABCFLOAT, 4)
}

static void test_pack_LPBITMAP(void)
{
    /* LPBITMAP */
    TEST_TYPE_SIZE   (LPBITMAP, 4)
    TEST_TYPE_ALIGN  (LPBITMAP, 4)
    TEST_TARGET_SIZE (LPBITMAP, 24)
    TEST_TARGET_ALIGN(LPBITMAP, 4)
}

static void test_pack_LPBITMAPCOREHEADER(void)
{
    /* LPBITMAPCOREHEADER */
    TEST_TYPE_SIZE   (LPBITMAPCOREHEADER, 4)
    TEST_TYPE_ALIGN  (LPBITMAPCOREHEADER, 4)
    TEST_TARGET_SIZE (LPBITMAPCOREHEADER, 12)
    TEST_TARGET_ALIGN(LPBITMAPCOREHEADER, 4)
}

static void test_pack_LPBITMAPCOREINFO(void)
{
    /* LPBITMAPCOREINFO */
    TEST_TYPE_SIZE   (LPBITMAPCOREINFO, 4)
    TEST_TYPE_ALIGN  (LPBITMAPCOREINFO, 4)
    TEST_TARGET_SIZE (LPBITMAPCOREINFO, 16)
    TEST_TARGET_ALIGN(LPBITMAPCOREINFO, 4)
}

static void test_pack_LPBITMAPFILEHEADER(void)
{
    /* LPBITMAPFILEHEADER */
    TEST_TYPE_SIZE   (LPBITMAPFILEHEADER, 4)
    TEST_TYPE_ALIGN  (LPBITMAPFILEHEADER, 4)
    TEST_TARGET_SIZE (LPBITMAPFILEHEADER, 14)
    TEST_TARGET_ALIGN(LPBITMAPFILEHEADER, 2)
}

static void test_pack_LPBITMAPINFO(void)
{
    /* LPBITMAPINFO */
    TEST_TYPE_SIZE   (LPBITMAPINFO, 4)
    TEST_TYPE_ALIGN  (LPBITMAPINFO, 4)
    TEST_TARGET_SIZE (LPBITMAPINFO, 44)
    TEST_TARGET_ALIGN(LPBITMAPINFO, 4)
}

static void test_pack_LPBITMAPINFOHEADER(void)
{
    /* LPBITMAPINFOHEADER */
    TEST_TYPE_SIZE   (LPBITMAPINFOHEADER, 4)
    TEST_TYPE_ALIGN  (LPBITMAPINFOHEADER, 4)
    TEST_TARGET_SIZE (LPBITMAPINFOHEADER, 40)
    TEST_TARGET_ALIGN(LPBITMAPINFOHEADER, 4)
}

static void test_pack_LPBITMAPV5HEADER(void)
{
    /* LPBITMAPV5HEADER */
    TEST_TYPE_SIZE   (LPBITMAPV5HEADER, 4)
    TEST_TYPE_ALIGN  (LPBITMAPV5HEADER, 4)
    TEST_TARGET_SIZE (LPBITMAPV5HEADER, 124)
    TEST_TARGET_ALIGN(LPBITMAPV5HEADER, 4)
}

static void test_pack_LPCHARSETINFO(void)
{
    /* LPCHARSETINFO */
    TEST_TYPE_SIZE   (LPCHARSETINFO, 4)
    TEST_TYPE_ALIGN  (LPCHARSETINFO, 4)
    TEST_TARGET_SIZE (LPCHARSETINFO, 32)
    TEST_TARGET_ALIGN(LPCHARSETINFO, 4)
}

static void test_pack_LPCIEXYZ(void)
{
    /* LPCIEXYZ */
    TEST_TYPE_SIZE   (LPCIEXYZ, 4)
    TEST_TYPE_ALIGN  (LPCIEXYZ, 4)
    TEST_TARGET_SIZE (LPCIEXYZ, 12)
    TEST_TARGET_ALIGN(LPCIEXYZ, 4)
}

static void test_pack_LPCIEXYZTRIPLE(void)
{
    /* LPCIEXYZTRIPLE */
    TEST_TYPE_SIZE   (LPCIEXYZTRIPLE, 4)
    TEST_TYPE_ALIGN  (LPCIEXYZTRIPLE, 4)
    TEST_TARGET_SIZE (LPCIEXYZTRIPLE, 36)
    TEST_TARGET_ALIGN(LPCIEXYZTRIPLE, 4)
}

static void test_pack_LPCOLORADJUSTMENT(void)
{
    /* LPCOLORADJUSTMENT */
    TEST_TYPE_SIZE   (LPCOLORADJUSTMENT, 4)
    TEST_TYPE_ALIGN  (LPCOLORADJUSTMENT, 4)
    TEST_TARGET_SIZE (LPCOLORADJUSTMENT, 24)
    TEST_TARGET_ALIGN(LPCOLORADJUSTMENT, 2)
}

static void test_pack_LPDEVMODEA(void)
{
    /* LPDEVMODEA */
    TEST_TYPE_SIZE   (LPDEVMODEA, 4)
    TEST_TYPE_ALIGN  (LPDEVMODEA, 4)
}

static void test_pack_LPDEVMODEW(void)
{
    /* LPDEVMODEW */
    TEST_TYPE_SIZE   (LPDEVMODEW, 4)
    TEST_TYPE_ALIGN  (LPDEVMODEW, 4)
}

static void test_pack_LPDIBSECTION(void)
{
    /* LPDIBSECTION */
    TEST_TYPE_SIZE   (LPDIBSECTION, 4)
    TEST_TYPE_ALIGN  (LPDIBSECTION, 4)
    TEST_TARGET_SIZE (LPDIBSECTION, 84)
    TEST_TARGET_ALIGN(LPDIBSECTION, 4)
}

static void test_pack_LPDISPLAY_DEVICEA(void)
{
    /* LPDISPLAY_DEVICEA */
    TEST_TYPE_SIZE   (LPDISPLAY_DEVICEA, 4)
    TEST_TYPE_ALIGN  (LPDISPLAY_DEVICEA, 4)
    TEST_TARGET_SIZE (LPDISPLAY_DEVICEA, 424)
    TEST_TARGET_ALIGN(LPDISPLAY_DEVICEA, 4)
}

static void test_pack_LPDISPLAY_DEVICEW(void)
{
    /* LPDISPLAY_DEVICEW */
    TEST_TYPE_SIZE   (LPDISPLAY_DEVICEW, 4)
    TEST_TYPE_ALIGN  (LPDISPLAY_DEVICEW, 4)
    TEST_TARGET_SIZE (LPDISPLAY_DEVICEW, 840)
    TEST_TARGET_ALIGN(LPDISPLAY_DEVICEW, 4)
}

static void test_pack_LPDOCINFOA(void)
{
    /* LPDOCINFOA */
    TEST_TYPE_SIZE   (LPDOCINFOA, 4)
    TEST_TYPE_ALIGN  (LPDOCINFOA, 4)
    TEST_TARGET_SIZE (LPDOCINFOA, 20)
    TEST_TARGET_ALIGN(LPDOCINFOA, 4)
}

static void test_pack_LPDOCINFOW(void)
{
    /* LPDOCINFOW */
    TEST_TYPE_SIZE   (LPDOCINFOW, 4)
    TEST_TYPE_ALIGN  (LPDOCINFOW, 4)
    TEST_TARGET_SIZE (LPDOCINFOW, 20)
    TEST_TARGET_ALIGN(LPDOCINFOW, 4)
}

static void test_pack_LPENHMETAHEADER(void)
{
    /* LPENHMETAHEADER */
    TEST_TYPE_SIZE   (LPENHMETAHEADER, 4)
    TEST_TYPE_ALIGN  (LPENHMETAHEADER, 4)
    TEST_TARGET_SIZE (LPENHMETAHEADER, 108)
    TEST_TARGET_ALIGN(LPENHMETAHEADER, 4)
}

static void test_pack_LPENHMETARECORD(void)
{
    /* LPENHMETARECORD */
    TEST_TYPE_SIZE   (LPENHMETARECORD, 4)
    TEST_TYPE_ALIGN  (LPENHMETARECORD, 4)
    TEST_TARGET_SIZE (LPENHMETARECORD, 12)
    TEST_TARGET_ALIGN(LPENHMETARECORD, 4)
}

static void test_pack_LPENUMLOGFONTA(void)
{
    /* LPENUMLOGFONTA */
    TEST_TYPE_SIZE   (LPENUMLOGFONTA, 4)
    TEST_TYPE_ALIGN  (LPENUMLOGFONTA, 4)
    TEST_TARGET_SIZE (LPENUMLOGFONTA, 156)
    TEST_TARGET_ALIGN(LPENUMLOGFONTA, 4)
}

static void test_pack_LPENUMLOGFONTEXA(void)
{
    /* LPENUMLOGFONTEXA */
    TEST_TYPE_SIZE   (LPENUMLOGFONTEXA, 4)
    TEST_TYPE_ALIGN  (LPENUMLOGFONTEXA, 4)
    TEST_TARGET_SIZE (LPENUMLOGFONTEXA, 188)
    TEST_TARGET_ALIGN(LPENUMLOGFONTEXA, 4)
}

static void test_pack_LPENUMLOGFONTEXW(void)
{
    /* LPENUMLOGFONTEXW */
    TEST_TYPE_SIZE   (LPENUMLOGFONTEXW, 4)
    TEST_TYPE_ALIGN  (LPENUMLOGFONTEXW, 4)
    TEST_TARGET_SIZE (LPENUMLOGFONTEXW, 348)
    TEST_TARGET_ALIGN(LPENUMLOGFONTEXW, 4)
}

static void test_pack_LPENUMLOGFONTW(void)
{
    /* LPENUMLOGFONTW */
    TEST_TYPE_SIZE   (LPENUMLOGFONTW, 4)
    TEST_TYPE_ALIGN  (LPENUMLOGFONTW, 4)
    TEST_TARGET_SIZE (LPENUMLOGFONTW, 284)
    TEST_TARGET_ALIGN(LPENUMLOGFONTW, 4)
}

static void test_pack_LPEXTLOGFONTA(void)
{
    /* LPEXTLOGFONTA */
    TEST_TYPE_SIZE   (LPEXTLOGFONTA, 4)
    TEST_TYPE_ALIGN  (LPEXTLOGFONTA, 4)
    TEST_TARGET_SIZE (LPEXTLOGFONTA, 192)
    TEST_TARGET_ALIGN(LPEXTLOGFONTA, 4)
}

static void test_pack_LPEXTLOGFONTW(void)
{
    /* LPEXTLOGFONTW */
    TEST_TYPE_SIZE   (LPEXTLOGFONTW, 4)
    TEST_TYPE_ALIGN  (LPEXTLOGFONTW, 4)
    TEST_TARGET_SIZE (LPEXTLOGFONTW, 320)
    TEST_TARGET_ALIGN(LPEXTLOGFONTW, 4)
}

static void test_pack_LPEXTLOGPEN(void)
{
    /* LPEXTLOGPEN */
    TEST_TYPE_SIZE   (LPEXTLOGPEN, 4)
    TEST_TYPE_ALIGN  (LPEXTLOGPEN, 4)
    TEST_TARGET_SIZE (LPEXTLOGPEN, 28)
    TEST_TARGET_ALIGN(LPEXTLOGPEN, 4)
}

static void test_pack_LPFONTSIGNATURE(void)
{
    /* LPFONTSIGNATURE */
    TEST_TYPE_SIZE   (LPFONTSIGNATURE, 4)
    TEST_TYPE_ALIGN  (LPFONTSIGNATURE, 4)
    TEST_TARGET_SIZE (LPFONTSIGNATURE, 24)
    TEST_TARGET_ALIGN(LPFONTSIGNATURE, 4)
}

static void test_pack_LPGCP_RESULTSA(void)
{
    /* LPGCP_RESULTSA */
    TEST_TYPE_SIZE   (LPGCP_RESULTSA, 4)
    TEST_TYPE_ALIGN  (LPGCP_RESULTSA, 4)
    TEST_TARGET_SIZE (LPGCP_RESULTSA, 36)
    TEST_TARGET_ALIGN(LPGCP_RESULTSA, 4)
}

static void test_pack_LPGCP_RESULTSW(void)
{
    /* LPGCP_RESULTSW */
    TEST_TYPE_SIZE   (LPGCP_RESULTSW, 4)
    TEST_TYPE_ALIGN  (LPGCP_RESULTSW, 4)
    TEST_TARGET_SIZE (LPGCP_RESULTSW, 36)
    TEST_TARGET_ALIGN(LPGCP_RESULTSW, 4)
}

static void test_pack_LPGLYPHMETRICS(void)
{
    /* LPGLYPHMETRICS */
    TEST_TYPE_SIZE   (LPGLYPHMETRICS, 4)
    TEST_TYPE_ALIGN  (LPGLYPHMETRICS, 4)
    TEST_TARGET_SIZE (LPGLYPHMETRICS, 20)
    TEST_TARGET_ALIGN(LPGLYPHMETRICS, 4)
}

static void test_pack_LPGLYPHMETRICSFLOAT(void)
{
    /* LPGLYPHMETRICSFLOAT */
    TEST_TYPE_SIZE   (LPGLYPHMETRICSFLOAT, 4)
    TEST_TYPE_ALIGN  (LPGLYPHMETRICSFLOAT, 4)
    TEST_TARGET_SIZE (LPGLYPHMETRICSFLOAT, 24)
    TEST_TARGET_ALIGN(LPGLYPHMETRICSFLOAT, 4)
}

static void test_pack_LPGRADIENT_RECT(void)
{
    /* LPGRADIENT_RECT */
    TEST_TYPE_SIZE   (LPGRADIENT_RECT, 4)
    TEST_TYPE_ALIGN  (LPGRADIENT_RECT, 4)
    TEST_TARGET_SIZE (LPGRADIENT_RECT, 8)
    TEST_TARGET_ALIGN(LPGRADIENT_RECT, 4)
}

static void test_pack_LPGRADIENT_TRIANGLE(void)
{
    /* LPGRADIENT_TRIANGLE */
    TEST_TYPE_SIZE   (LPGRADIENT_TRIANGLE, 4)
    TEST_TYPE_ALIGN  (LPGRADIENT_TRIANGLE, 4)
    TEST_TARGET_SIZE (LPGRADIENT_TRIANGLE, 12)
    TEST_TARGET_ALIGN(LPGRADIENT_TRIANGLE, 4)
}

static void test_pack_LPHANDLETABLE(void)
{
    /* LPHANDLETABLE */
    TEST_TYPE_SIZE   (LPHANDLETABLE, 4)
    TEST_TYPE_ALIGN  (LPHANDLETABLE, 4)
    TEST_TARGET_SIZE (LPHANDLETABLE, 4)
    TEST_TARGET_ALIGN(LPHANDLETABLE, 4)
}

static void test_pack_LPKERNINGPAIR(void)
{
    /* LPKERNINGPAIR */
    TEST_TYPE_SIZE   (LPKERNINGPAIR, 4)
    TEST_TYPE_ALIGN  (LPKERNINGPAIR, 4)
    TEST_TARGET_SIZE (LPKERNINGPAIR, 8)
    TEST_TARGET_ALIGN(LPKERNINGPAIR, 4)
}

static void test_pack_LPLAYERPLANEDESCRIPTOR(void)
{
    /* LPLAYERPLANEDESCRIPTOR */
    TEST_TYPE_SIZE   (LPLAYERPLANEDESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (LPLAYERPLANEDESCRIPTOR, 4)
    TEST_TARGET_SIZE (LPLAYERPLANEDESCRIPTOR, 32)
    TEST_TARGET_ALIGN(LPLAYERPLANEDESCRIPTOR, 4)
}

static void test_pack_LPLOCALESIGNATURE(void)
{
    /* LPLOCALESIGNATURE */
    TEST_TYPE_SIZE   (LPLOCALESIGNATURE, 4)
    TEST_TYPE_ALIGN  (LPLOCALESIGNATURE, 4)
    TEST_TARGET_SIZE (LPLOCALESIGNATURE, 32)
    TEST_TARGET_ALIGN(LPLOCALESIGNATURE, 4)
}

static void test_pack_LPLOGBRUSH(void)
{
    /* LPLOGBRUSH */
    TEST_TYPE_SIZE   (LPLOGBRUSH, 4)
    TEST_TYPE_ALIGN  (LPLOGBRUSH, 4)
    TEST_TARGET_SIZE (LPLOGBRUSH, 12)
    TEST_TARGET_ALIGN(LPLOGBRUSH, 4)
}

static void test_pack_LPLOGCOLORSPACEA(void)
{
    /* LPLOGCOLORSPACEA */
    TEST_TYPE_SIZE   (LPLOGCOLORSPACEA, 4)
    TEST_TYPE_ALIGN  (LPLOGCOLORSPACEA, 4)
    TEST_TARGET_SIZE (LPLOGCOLORSPACEA, 328)
    TEST_TARGET_ALIGN(LPLOGCOLORSPACEA, 4)
}

static void test_pack_LPLOGCOLORSPACEW(void)
{
    /* LPLOGCOLORSPACEW */
    TEST_TYPE_SIZE   (LPLOGCOLORSPACEW, 4)
    TEST_TYPE_ALIGN  (LPLOGCOLORSPACEW, 4)
    TEST_TARGET_SIZE (LPLOGCOLORSPACEW, 588)
    TEST_TARGET_ALIGN(LPLOGCOLORSPACEW, 4)
}

static void test_pack_LPLOGFONTA(void)
{
    /* LPLOGFONTA */
    TEST_TYPE_SIZE   (LPLOGFONTA, 4)
    TEST_TYPE_ALIGN  (LPLOGFONTA, 4)
    TEST_TARGET_SIZE (LPLOGFONTA, 60)
    TEST_TARGET_ALIGN(LPLOGFONTA, 4)
}

static void test_pack_LPLOGFONTW(void)
{
    /* LPLOGFONTW */
    TEST_TYPE_SIZE   (LPLOGFONTW, 4)
    TEST_TYPE_ALIGN  (LPLOGFONTW, 4)
    TEST_TARGET_SIZE (LPLOGFONTW, 92)
    TEST_TARGET_ALIGN(LPLOGFONTW, 4)
}

static void test_pack_LPLOGPEN(void)
{
    /* LPLOGPEN */
    TEST_TYPE_SIZE   (LPLOGPEN, 4)
    TEST_TYPE_ALIGN  (LPLOGPEN, 4)
    TEST_TARGET_SIZE (LPLOGPEN, 16)
    TEST_TARGET_ALIGN(LPLOGPEN, 4)
}

static void test_pack_LPMAT2(void)
{
    /* LPMAT2 */
    TEST_TYPE_SIZE   (LPMAT2, 4)
    TEST_TYPE_ALIGN  (LPMAT2, 4)
    TEST_TARGET_SIZE (LPMAT2, 16)
    TEST_TARGET_ALIGN(LPMAT2, 2)
}

static void test_pack_LPMETAFILEPICT(void)
{
    /* LPMETAFILEPICT */
    TEST_TYPE_SIZE   (LPMETAFILEPICT, 4)
    TEST_TYPE_ALIGN  (LPMETAFILEPICT, 4)
    TEST_TARGET_SIZE (LPMETAFILEPICT, 16)
    TEST_TARGET_ALIGN(LPMETAFILEPICT, 4)
}

static void test_pack_LPMETAHEADER(void)
{
    /* LPMETAHEADER */
    TEST_TYPE_SIZE   (LPMETAHEADER, 4)
    TEST_TYPE_ALIGN  (LPMETAHEADER, 4)
    TEST_TARGET_SIZE (LPMETAHEADER, 18)
    TEST_TARGET_ALIGN(LPMETAHEADER, 2)
}

static void test_pack_LPMETARECORD(void)
{
    /* LPMETARECORD */
    TEST_TYPE_SIZE   (LPMETARECORD, 4)
    TEST_TYPE_ALIGN  (LPMETARECORD, 4)
    TEST_TARGET_SIZE (LPMETARECORD, 8)
    TEST_TARGET_ALIGN(LPMETARECORD, 4)
}

static void test_pack_LPNEWTEXTMETRICA(void)
{
    /* LPNEWTEXTMETRICA */
    TEST_TYPE_SIZE   (LPNEWTEXTMETRICA, 4)
    TEST_TYPE_ALIGN  (LPNEWTEXTMETRICA, 4)
    TEST_TARGET_SIZE (LPNEWTEXTMETRICA, 72)
    TEST_TARGET_ALIGN(LPNEWTEXTMETRICA, 4)
}

static void test_pack_LPNEWTEXTMETRICW(void)
{
    /* LPNEWTEXTMETRICW */
    TEST_TYPE_SIZE   (LPNEWTEXTMETRICW, 4)
    TEST_TYPE_ALIGN  (LPNEWTEXTMETRICW, 4)
    TEST_TARGET_SIZE (LPNEWTEXTMETRICW, 76)
    TEST_TARGET_ALIGN(LPNEWTEXTMETRICW, 4)
}

static void test_pack_LPOUTLINETEXTMETRICA(void)
{
    /* LPOUTLINETEXTMETRICA */
    TEST_TYPE_SIZE   (LPOUTLINETEXTMETRICA, 4)
    TEST_TYPE_ALIGN  (LPOUTLINETEXTMETRICA, 4)
    TEST_TARGET_SIZE (LPOUTLINETEXTMETRICA, 212)
    TEST_TARGET_ALIGN(LPOUTLINETEXTMETRICA, 4)
}

static void test_pack_LPOUTLINETEXTMETRICW(void)
{
    /* LPOUTLINETEXTMETRICW */
    TEST_TYPE_SIZE   (LPOUTLINETEXTMETRICW, 4)
    TEST_TYPE_ALIGN  (LPOUTLINETEXTMETRICW, 4)
    TEST_TARGET_SIZE (LPOUTLINETEXTMETRICW, 216)
    TEST_TARGET_ALIGN(LPOUTLINETEXTMETRICW, 4)
}

static void test_pack_LPPANOSE(void)
{
    /* LPPANOSE */
    TEST_TYPE_SIZE   (LPPANOSE, 4)
    TEST_TYPE_ALIGN  (LPPANOSE, 4)
    TEST_TARGET_SIZE (LPPANOSE, 10)
    TEST_TARGET_ALIGN(LPPANOSE, 1)
}

static void test_pack_LPPELARRAY(void)
{
    /* LPPELARRAY */
    TEST_TYPE_SIZE   (LPPELARRAY, 4)
    TEST_TYPE_ALIGN  (LPPELARRAY, 4)
    TEST_TARGET_SIZE (LPPELARRAY, 20)
    TEST_TARGET_ALIGN(LPPELARRAY, 4)
}

static void test_pack_LPPIXELFORMATDESCRIPTOR(void)
{
    /* LPPIXELFORMATDESCRIPTOR */
    TEST_TYPE_SIZE   (LPPIXELFORMATDESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (LPPIXELFORMATDESCRIPTOR, 4)
    TEST_TARGET_SIZE (LPPIXELFORMATDESCRIPTOR, 40)
    TEST_TARGET_ALIGN(LPPIXELFORMATDESCRIPTOR, 4)
}

static void test_pack_LPPOINTFX(void)
{
    /* LPPOINTFX */
    TEST_TYPE_SIZE   (LPPOINTFX, 4)
    TEST_TYPE_ALIGN  (LPPOINTFX, 4)
    TEST_TARGET_SIZE (LPPOINTFX, 8)
    TEST_TARGET_ALIGN(LPPOINTFX, 2)
}

static void test_pack_LPPOLYTEXTA(void)
{
    /* LPPOLYTEXTA */
    TEST_TYPE_SIZE   (LPPOLYTEXTA, 4)
    TEST_TYPE_ALIGN  (LPPOLYTEXTA, 4)
    TEST_TARGET_SIZE (LPPOLYTEXTA, 40)
    TEST_TARGET_ALIGN(LPPOLYTEXTA, 4)
}

static void test_pack_LPPOLYTEXTW(void)
{
    /* LPPOLYTEXTW */
    TEST_TYPE_SIZE   (LPPOLYTEXTW, 4)
    TEST_TYPE_ALIGN  (LPPOLYTEXTW, 4)
    TEST_TARGET_SIZE (LPPOLYTEXTW, 40)
    TEST_TARGET_ALIGN(LPPOLYTEXTW, 4)
}

static void test_pack_LPRASTERIZER_STATUS(void)
{
    /* LPRASTERIZER_STATUS */
    TEST_TYPE_SIZE   (LPRASTERIZER_STATUS, 4)
    TEST_TYPE_ALIGN  (LPRASTERIZER_STATUS, 4)
    TEST_TARGET_SIZE (LPRASTERIZER_STATUS, 6)
    TEST_TARGET_ALIGN(LPRASTERIZER_STATUS, 2)
}

static void test_pack_LPRGBQUAD(void)
{
    /* LPRGBQUAD */
    TEST_TYPE_SIZE   (LPRGBQUAD, 4)
    TEST_TYPE_ALIGN  (LPRGBQUAD, 4)
    TEST_TARGET_SIZE (LPRGBQUAD, 4)
    TEST_TARGET_ALIGN(LPRGBQUAD, 1)
}

static void test_pack_LPRGNDATA(void)
{
    /* LPRGNDATA */
    TEST_TYPE_SIZE   (LPRGNDATA, 4)
    TEST_TYPE_ALIGN  (LPRGNDATA, 4)
    TEST_TARGET_SIZE (LPRGNDATA, 36)
    TEST_TARGET_ALIGN(LPRGNDATA, 4)
}

static void test_pack_LPTEXTMETRICA(void)
{
    /* LPTEXTMETRICA */
    TEST_TYPE_SIZE   (LPTEXTMETRICA, 4)
    TEST_TYPE_ALIGN  (LPTEXTMETRICA, 4)
    TEST_TARGET_SIZE (LPTEXTMETRICA, 56)
    TEST_TARGET_ALIGN(LPTEXTMETRICA, 4)
}

static void test_pack_LPTEXTMETRICW(void)
{
    /* LPTEXTMETRICW */
    TEST_TYPE_SIZE   (LPTEXTMETRICW, 4)
    TEST_TYPE_ALIGN  (LPTEXTMETRICW, 4)
    TEST_TARGET_SIZE (LPTEXTMETRICW, 60)
    TEST_TARGET_ALIGN(LPTEXTMETRICW, 4)
}

static void test_pack_LPTRIVERTEX(void)
{
    /* LPTRIVERTEX */
    TEST_TYPE_SIZE   (LPTRIVERTEX, 4)
    TEST_TYPE_ALIGN  (LPTRIVERTEX, 4)
    TEST_TARGET_SIZE (LPTRIVERTEX, 16)
    TEST_TARGET_ALIGN(LPTRIVERTEX, 4)
}

static void test_pack_LPTTPOLYCURVE(void)
{
    /* LPTTPOLYCURVE */
    TEST_TYPE_SIZE   (LPTTPOLYCURVE, 4)
    TEST_TYPE_ALIGN  (LPTTPOLYCURVE, 4)
    TEST_TARGET_SIZE (LPTTPOLYCURVE, 12)
    TEST_TARGET_ALIGN(LPTTPOLYCURVE, 2)
}

static void test_pack_LPTTPOLYGONHEADER(void)
{
    /* LPTTPOLYGONHEADER */
    TEST_TYPE_SIZE   (LPTTPOLYGONHEADER, 4)
    TEST_TYPE_ALIGN  (LPTTPOLYGONHEADER, 4)
    TEST_TARGET_SIZE (LPTTPOLYGONHEADER, 16)
    TEST_TARGET_ALIGN(LPTTPOLYGONHEADER, 4)
}

static void test_pack_LPXFORM(void)
{
    /* LPXFORM */
    TEST_TYPE_SIZE   (LPXFORM, 4)
    TEST_TYPE_ALIGN  (LPXFORM, 4)
    TEST_TARGET_SIZE (LPXFORM, 24)
    TEST_TARGET_ALIGN(LPXFORM, 4)
}

static void test_pack_MAT2(void)
{
    /* MAT2 (pack 4) */
    TEST_TYPE_SIZE   (MAT2, 16)
    TEST_TYPE_ALIGN  (MAT2, 2)
    TEST_FIELD_SIZE  (MAT2, eM11, 4)
    TEST_FIELD_ALIGN (MAT2, eM11, 2)
    TEST_FIELD_OFFSET(MAT2, eM11, 0)
    TEST_FIELD_SIZE  (MAT2, eM12, 4)
    TEST_FIELD_ALIGN (MAT2, eM12, 2)
    TEST_FIELD_OFFSET(MAT2, eM12, 4)
    TEST_FIELD_SIZE  (MAT2, eM21, 4)
    TEST_FIELD_ALIGN (MAT2, eM21, 2)
    TEST_FIELD_OFFSET(MAT2, eM21, 8)
    TEST_FIELD_SIZE  (MAT2, eM22, 4)
    TEST_FIELD_ALIGN (MAT2, eM22, 2)
    TEST_FIELD_OFFSET(MAT2, eM22, 12)
}

static void test_pack_METAFILEPICT(void)
{
    /* METAFILEPICT (pack 4) */
    TEST_TYPE_SIZE   (METAFILEPICT, 16)
    TEST_TYPE_ALIGN  (METAFILEPICT, 4)
    TEST_FIELD_SIZE  (METAFILEPICT, mm, 4)
    TEST_FIELD_ALIGN (METAFILEPICT, mm, 4)
    TEST_FIELD_OFFSET(METAFILEPICT, mm, 0)
    TEST_FIELD_SIZE  (METAFILEPICT, xExt, 4)
    TEST_FIELD_ALIGN (METAFILEPICT, xExt, 4)
    TEST_FIELD_OFFSET(METAFILEPICT, xExt, 4)
    TEST_FIELD_SIZE  (METAFILEPICT, yExt, 4)
    TEST_FIELD_ALIGN (METAFILEPICT, yExt, 4)
    TEST_FIELD_OFFSET(METAFILEPICT, yExt, 8)
    TEST_FIELD_SIZE  (METAFILEPICT, hMF, 4)
    TEST_FIELD_ALIGN (METAFILEPICT, hMF, 4)
    TEST_FIELD_OFFSET(METAFILEPICT, hMF, 12)
}

static void test_pack_METAHEADER(void)
{
    /* METAHEADER (pack 2) */
    TEST_TYPE_SIZE   (METAHEADER, 18)
    TEST_TYPE_ALIGN  (METAHEADER, 2)
    TEST_FIELD_SIZE  (METAHEADER, mtType, 2)
    TEST_FIELD_ALIGN (METAHEADER, mtType, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtType, 0)
    TEST_FIELD_SIZE  (METAHEADER, mtHeaderSize, 2)
    TEST_FIELD_ALIGN (METAHEADER, mtHeaderSize, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtHeaderSize, 2)
    TEST_FIELD_SIZE  (METAHEADER, mtVersion, 2)
    TEST_FIELD_ALIGN (METAHEADER, mtVersion, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtVersion, 4)
    TEST_FIELD_SIZE  (METAHEADER, mtSize, 4)
    TEST_FIELD_ALIGN (METAHEADER, mtSize, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtSize, 6)
    TEST_FIELD_SIZE  (METAHEADER, mtNoObjects, 2)
    TEST_FIELD_ALIGN (METAHEADER, mtNoObjects, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtNoObjects, 10)
    TEST_FIELD_SIZE  (METAHEADER, mtMaxRecord, 4)
    TEST_FIELD_ALIGN (METAHEADER, mtMaxRecord, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtMaxRecord, 12)
    TEST_FIELD_SIZE  (METAHEADER, mtNoParameters, 2)
    TEST_FIELD_ALIGN (METAHEADER, mtNoParameters, 2)
    TEST_FIELD_OFFSET(METAHEADER, mtNoParameters, 16)
}

static void test_pack_METARECORD(void)
{
    /* METARECORD (pack 4) */
    TEST_TYPE_SIZE   (METARECORD, 8)
    TEST_TYPE_ALIGN  (METARECORD, 4)
    TEST_FIELD_SIZE  (METARECORD, rdSize, 4)
    TEST_FIELD_ALIGN (METARECORD, rdSize, 4)
    TEST_FIELD_OFFSET(METARECORD, rdSize, 0)
    TEST_FIELD_SIZE  (METARECORD, rdFunction, 2)
    TEST_FIELD_ALIGN (METARECORD, rdFunction, 2)
    TEST_FIELD_OFFSET(METARECORD, rdFunction, 4)
    TEST_FIELD_SIZE  (METARECORD, rdParm, 2)
    TEST_FIELD_ALIGN (METARECORD, rdParm, 2)
    TEST_FIELD_OFFSET(METARECORD, rdParm, 6)
}

static void test_pack_MFENUMPROC(void)
{
    /* MFENUMPROC */
    TEST_TYPE_SIZE   (MFENUMPROC, 4)
    TEST_TYPE_ALIGN  (MFENUMPROC, 4)
}

static void test_pack_NEWTEXTMETRICA(void)
{
    /* NEWTEXTMETRICA (pack 4) */
    TEST_TYPE_SIZE   (NEWTEXTMETRICA, 72)
    TEST_TYPE_ALIGN  (NEWTEXTMETRICA, 4)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmHeight, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmHeight, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmHeight, 0)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmAscent, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmAscent, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmAscent, 4)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmDescent, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmDescent, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmDescent, 8)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmInternalLeading, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmInternalLeading, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmInternalLeading, 12)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmExternalLeading, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmExternalLeading, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmExternalLeading, 16)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmAveCharWidth, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmAveCharWidth, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmAveCharWidth, 20)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmMaxCharWidth, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmMaxCharWidth, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmMaxCharWidth, 24)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmWeight, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmWeight, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmWeight, 28)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmOverhang, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmOverhang, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmOverhang, 32)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmDigitizedAspectX, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmDigitizedAspectX, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmDigitizedAspectX, 36)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmDigitizedAspectY, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmDigitizedAspectY, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmDigitizedAspectY, 40)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmFirstChar, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmFirstChar, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmFirstChar, 44)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmLastChar, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmLastChar, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmLastChar, 45)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmDefaultChar, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmDefaultChar, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmDefaultChar, 46)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmBreakChar, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmBreakChar, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmBreakChar, 47)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmItalic, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmItalic, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmItalic, 48)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmUnderlined, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmUnderlined, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmUnderlined, 49)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmStruckOut, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmStruckOut, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmStruckOut, 50)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmPitchAndFamily, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmPitchAndFamily, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmPitchAndFamily, 51)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, tmCharSet, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, tmCharSet, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, tmCharSet, 52)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, ntmFlags, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, ntmFlags, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, ntmFlags, 56)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, ntmSizeEM, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, ntmSizeEM, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, ntmSizeEM, 60)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, ntmCellHeight, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, ntmCellHeight, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, ntmCellHeight, 64)
    TEST_FIELD_SIZE  (NEWTEXTMETRICA, ntmAvgWidth, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICA, ntmAvgWidth, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICA, ntmAvgWidth, 68)
}

static void test_pack_NEWTEXTMETRICEXA(void)
{
    /* NEWTEXTMETRICEXA (pack 4) */
    TEST_TYPE_SIZE   (NEWTEXTMETRICEXA, 96)
    TEST_TYPE_ALIGN  (NEWTEXTMETRICEXA, 4)
    TEST_FIELD_SIZE  (NEWTEXTMETRICEXA, ntmTm, 72)
    TEST_FIELD_ALIGN (NEWTEXTMETRICEXA, ntmTm, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICEXA, ntmTm, 0)
    TEST_FIELD_SIZE  (NEWTEXTMETRICEXA, ntmFontSig, 24)
    TEST_FIELD_ALIGN (NEWTEXTMETRICEXA, ntmFontSig, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICEXA, ntmFontSig, 72)
}

static void test_pack_NEWTEXTMETRICEXW(void)
{
    /* NEWTEXTMETRICEXW (pack 4) */
    TEST_TYPE_SIZE   (NEWTEXTMETRICEXW, 100)
    TEST_TYPE_ALIGN  (NEWTEXTMETRICEXW, 4)
    TEST_FIELD_SIZE  (NEWTEXTMETRICEXW, ntmTm, 76)
    TEST_FIELD_ALIGN (NEWTEXTMETRICEXW, ntmTm, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICEXW, ntmTm, 0)
    TEST_FIELD_SIZE  (NEWTEXTMETRICEXW, ntmFontSig, 24)
    TEST_FIELD_ALIGN (NEWTEXTMETRICEXW, ntmFontSig, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICEXW, ntmFontSig, 76)
}

static void test_pack_NEWTEXTMETRICW(void)
{
    /* NEWTEXTMETRICW (pack 4) */
    TEST_TYPE_SIZE   (NEWTEXTMETRICW, 76)
    TEST_TYPE_ALIGN  (NEWTEXTMETRICW, 4)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmHeight, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmHeight, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmHeight, 0)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmAscent, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmAscent, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmAscent, 4)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmDescent, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmDescent, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmDescent, 8)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmInternalLeading, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmInternalLeading, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmInternalLeading, 12)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmExternalLeading, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmExternalLeading, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmExternalLeading, 16)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmAveCharWidth, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmAveCharWidth, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmAveCharWidth, 20)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmMaxCharWidth, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmMaxCharWidth, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmMaxCharWidth, 24)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmWeight, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmWeight, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmWeight, 28)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmOverhang, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmOverhang, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmOverhang, 32)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmDigitizedAspectX, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmDigitizedAspectX, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmDigitizedAspectX, 36)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmDigitizedAspectY, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmDigitizedAspectY, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmDigitizedAspectY, 40)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmFirstChar, 2)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmFirstChar, 2)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmFirstChar, 44)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmLastChar, 2)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmLastChar, 2)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmLastChar, 46)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmDefaultChar, 2)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmDefaultChar, 2)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmDefaultChar, 48)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmBreakChar, 2)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmBreakChar, 2)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmBreakChar, 50)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmItalic, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmItalic, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmItalic, 52)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmUnderlined, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmUnderlined, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmUnderlined, 53)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmStruckOut, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmStruckOut, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmStruckOut, 54)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmPitchAndFamily, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmPitchAndFamily, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmPitchAndFamily, 55)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, tmCharSet, 1)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, tmCharSet, 1)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, tmCharSet, 56)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, ntmFlags, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, ntmFlags, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, ntmFlags, 60)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, ntmSizeEM, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, ntmSizeEM, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, ntmSizeEM, 64)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, ntmCellHeight, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, ntmCellHeight, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, ntmCellHeight, 68)
    TEST_FIELD_SIZE  (NEWTEXTMETRICW, ntmAvgWidth, 4)
    TEST_FIELD_ALIGN (NEWTEXTMETRICW, ntmAvgWidth, 4)
    TEST_FIELD_OFFSET(NEWTEXTMETRICW, ntmAvgWidth, 72)
}

static void test_pack_NPEXTLOGPEN(void)
{
    /* NPEXTLOGPEN */
    TEST_TYPE_SIZE   (NPEXTLOGPEN, 4)
    TEST_TYPE_ALIGN  (NPEXTLOGPEN, 4)
    TEST_TARGET_SIZE (NPEXTLOGPEN, 28)
    TEST_TARGET_ALIGN(NPEXTLOGPEN, 4)
}

static void test_pack_OLDFONTENUMPROC(void)
{
    /* OLDFONTENUMPROC */
    TEST_TYPE_SIZE   (OLDFONTENUMPROC, 4)
    TEST_TYPE_ALIGN  (OLDFONTENUMPROC, 4)
}

static void test_pack_OLDFONTENUMPROCA(void)
{
    /* OLDFONTENUMPROCA */
    TEST_TYPE_SIZE   (OLDFONTENUMPROCA, 4)
    TEST_TYPE_ALIGN  (OLDFONTENUMPROCA, 4)
}

static void test_pack_OLDFONTENUMPROCW(void)
{
    /* OLDFONTENUMPROCW */
    TEST_TYPE_SIZE   (OLDFONTENUMPROCW, 4)
    TEST_TYPE_ALIGN  (OLDFONTENUMPROCW, 4)
}

static void test_pack_OUTLINETEXTMETRICA(void)
{
    /* OUTLINETEXTMETRICA (pack 4) */
    TEST_TYPE_SIZE   (OUTLINETEXTMETRICA, 212)
    TEST_TYPE_ALIGN  (OUTLINETEXTMETRICA, 4)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmSize, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmSize, 0)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmTextMetrics, 56)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmTextMetrics, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmTextMetrics, 4)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmFiller, 1)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmFiller, 1)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmFiller, 60)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmPanoseNumber, 10)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmPanoseNumber, 1)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmPanoseNumber, 61)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmfsSelection, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmfsSelection, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmfsSelection, 72)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmfsType, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmfsType, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmfsType, 76)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsCharSlopeRise, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsCharSlopeRise, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsCharSlopeRise, 80)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsCharSlopeRun, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsCharSlopeRun, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsCharSlopeRun, 84)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmItalicAngle, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmItalicAngle, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmItalicAngle, 88)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmEMSquare, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmEMSquare, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmEMSquare, 92)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmAscent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmAscent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmAscent, 96)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmDescent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmDescent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmDescent, 100)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmLineGap, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmLineGap, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmLineGap, 104)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsCapEmHeight, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsCapEmHeight, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsCapEmHeight, 108)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsXHeight, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsXHeight, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsXHeight, 112)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmrcFontBox, 16)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmrcFontBox, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmrcFontBox, 116)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmMacAscent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmMacAscent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmMacAscent, 132)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmMacDescent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmMacDescent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmMacDescent, 136)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmMacLineGap, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmMacLineGap, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmMacLineGap, 140)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmusMinimumPPEM, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmusMinimumPPEM, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmusMinimumPPEM, 144)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmptSubscriptSize, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmptSubscriptSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmptSubscriptSize, 148)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmptSubscriptOffset, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmptSubscriptOffset, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmptSubscriptOffset, 156)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmptSuperscriptSize, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmptSuperscriptSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmptSuperscriptSize, 164)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmptSuperscriptOffset, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmptSuperscriptOffset, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmptSuperscriptOffset, 172)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsStrikeoutSize, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsStrikeoutSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsStrikeoutSize, 180)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsStrikeoutPosition, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsStrikeoutPosition, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsStrikeoutPosition, 184)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsUnderscoreSize, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsUnderscoreSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsUnderscoreSize, 188)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmsUnderscorePosition, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmsUnderscorePosition, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmsUnderscorePosition, 192)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmpFamilyName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmpFamilyName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmpFamilyName, 196)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmpFaceName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmpFaceName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmpFaceName, 200)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmpStyleName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmpStyleName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmpStyleName, 204)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICA, otmpFullName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICA, otmpFullName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICA, otmpFullName, 208)
}

static void test_pack_OUTLINETEXTMETRICW(void)
{
    /* OUTLINETEXTMETRICW (pack 4) */
    TEST_TYPE_SIZE   (OUTLINETEXTMETRICW, 216)
    TEST_TYPE_ALIGN  (OUTLINETEXTMETRICW, 4)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmSize, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmSize, 0)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmTextMetrics, 60)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmTextMetrics, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmTextMetrics, 4)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmFiller, 1)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmFiller, 1)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmFiller, 64)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmPanoseNumber, 10)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmPanoseNumber, 1)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmPanoseNumber, 65)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmfsSelection, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmfsSelection, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmfsSelection, 76)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmfsType, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmfsType, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmfsType, 80)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsCharSlopeRise, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsCharSlopeRise, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsCharSlopeRise, 84)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsCharSlopeRun, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsCharSlopeRun, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsCharSlopeRun, 88)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmItalicAngle, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmItalicAngle, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmItalicAngle, 92)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmEMSquare, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmEMSquare, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmEMSquare, 96)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmAscent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmAscent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmAscent, 100)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmDescent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmDescent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmDescent, 104)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmLineGap, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmLineGap, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmLineGap, 108)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsCapEmHeight, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsCapEmHeight, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsCapEmHeight, 112)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsXHeight, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsXHeight, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsXHeight, 116)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmrcFontBox, 16)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmrcFontBox, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmrcFontBox, 120)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmMacAscent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmMacAscent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmMacAscent, 136)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmMacDescent, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmMacDescent, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmMacDescent, 140)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmMacLineGap, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmMacLineGap, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmMacLineGap, 144)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmusMinimumPPEM, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmusMinimumPPEM, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmusMinimumPPEM, 148)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmptSubscriptSize, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmptSubscriptSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmptSubscriptSize, 152)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmptSubscriptOffset, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmptSubscriptOffset, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmptSubscriptOffset, 160)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmptSuperscriptSize, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmptSuperscriptSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmptSuperscriptSize, 168)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmptSuperscriptOffset, 8)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmptSuperscriptOffset, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmptSuperscriptOffset, 176)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsStrikeoutSize, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsStrikeoutSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsStrikeoutSize, 184)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsStrikeoutPosition, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsStrikeoutPosition, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsStrikeoutPosition, 188)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsUnderscoreSize, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsUnderscoreSize, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsUnderscoreSize, 192)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmsUnderscorePosition, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmsUnderscorePosition, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmsUnderscorePosition, 196)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmpFamilyName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmpFamilyName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmpFamilyName, 200)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmpFaceName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmpFaceName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmpFaceName, 204)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmpStyleName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmpStyleName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmpStyleName, 208)
    TEST_FIELD_SIZE  (OUTLINETEXTMETRICW, otmpFullName, 4)
    TEST_FIELD_ALIGN (OUTLINETEXTMETRICW, otmpFullName, 4)
    TEST_FIELD_OFFSET(OUTLINETEXTMETRICW, otmpFullName, 212)
}

static void test_pack_PABC(void)
{
    /* PABC */
    TEST_TYPE_SIZE   (PABC, 4)
    TEST_TYPE_ALIGN  (PABC, 4)
    TEST_TARGET_SIZE (PABC, 12)
    TEST_TARGET_ALIGN(PABC, 4)
}

static void test_pack_PABCFLOAT(void)
{
    /* PABCFLOAT */
    TEST_TYPE_SIZE   (PABCFLOAT, 4)
    TEST_TYPE_ALIGN  (PABCFLOAT, 4)
    TEST_TARGET_SIZE (PABCFLOAT, 12)
    TEST_TARGET_ALIGN(PABCFLOAT, 4)
}

static void test_pack_PANOSE(void)
{
    /* PANOSE (pack 4) */
    TEST_TYPE_SIZE   (PANOSE, 10)
    TEST_TYPE_ALIGN  (PANOSE, 1)
    TEST_FIELD_SIZE  (PANOSE, bFamilyType, 1)
    TEST_FIELD_ALIGN (PANOSE, bFamilyType, 1)
    TEST_FIELD_OFFSET(PANOSE, bFamilyType, 0)
    TEST_FIELD_SIZE  (PANOSE, bSerifStyle, 1)
    TEST_FIELD_ALIGN (PANOSE, bSerifStyle, 1)
    TEST_FIELD_OFFSET(PANOSE, bSerifStyle, 1)
    TEST_FIELD_SIZE  (PANOSE, bWeight, 1)
    TEST_FIELD_ALIGN (PANOSE, bWeight, 1)
    TEST_FIELD_OFFSET(PANOSE, bWeight, 2)
    TEST_FIELD_SIZE  (PANOSE, bProportion, 1)
    TEST_FIELD_ALIGN (PANOSE, bProportion, 1)
    TEST_FIELD_OFFSET(PANOSE, bProportion, 3)
    TEST_FIELD_SIZE  (PANOSE, bContrast, 1)
    TEST_FIELD_ALIGN (PANOSE, bContrast, 1)
    TEST_FIELD_OFFSET(PANOSE, bContrast, 4)
    TEST_FIELD_SIZE  (PANOSE, bStrokeVariation, 1)
    TEST_FIELD_ALIGN (PANOSE, bStrokeVariation, 1)
    TEST_FIELD_OFFSET(PANOSE, bStrokeVariation, 5)
    TEST_FIELD_SIZE  (PANOSE, bArmStyle, 1)
    TEST_FIELD_ALIGN (PANOSE, bArmStyle, 1)
    TEST_FIELD_OFFSET(PANOSE, bArmStyle, 6)
    TEST_FIELD_SIZE  (PANOSE, bLetterform, 1)
    TEST_FIELD_ALIGN (PANOSE, bLetterform, 1)
    TEST_FIELD_OFFSET(PANOSE, bLetterform, 7)
    TEST_FIELD_SIZE  (PANOSE, bMidline, 1)
    TEST_FIELD_ALIGN (PANOSE, bMidline, 1)
    TEST_FIELD_OFFSET(PANOSE, bMidline, 8)
    TEST_FIELD_SIZE  (PANOSE, bXHeight, 1)
    TEST_FIELD_ALIGN (PANOSE, bXHeight, 1)
    TEST_FIELD_OFFSET(PANOSE, bXHeight, 9)
}

static void test_pack_PATTERN(void)
{
    /* PATTERN */
    TEST_TYPE_SIZE   (PATTERN, 12)
    TEST_TYPE_ALIGN  (PATTERN, 4)
}

static void test_pack_PBITMAP(void)
{
    /* PBITMAP */
    TEST_TYPE_SIZE   (PBITMAP, 4)
    TEST_TYPE_ALIGN  (PBITMAP, 4)
    TEST_TARGET_SIZE (PBITMAP, 24)
    TEST_TARGET_ALIGN(PBITMAP, 4)
}

static void test_pack_PBITMAPCOREHEADER(void)
{
    /* PBITMAPCOREHEADER */
    TEST_TYPE_SIZE   (PBITMAPCOREHEADER, 4)
    TEST_TYPE_ALIGN  (PBITMAPCOREHEADER, 4)
    TEST_TARGET_SIZE (PBITMAPCOREHEADER, 12)
    TEST_TARGET_ALIGN(PBITMAPCOREHEADER, 4)
}

static void test_pack_PBITMAPCOREINFO(void)
{
    /* PBITMAPCOREINFO */
    TEST_TYPE_SIZE   (PBITMAPCOREINFO, 4)
    TEST_TYPE_ALIGN  (PBITMAPCOREINFO, 4)
    TEST_TARGET_SIZE (PBITMAPCOREINFO, 16)
    TEST_TARGET_ALIGN(PBITMAPCOREINFO, 4)
}

static void test_pack_PBITMAPFILEHEADER(void)
{
    /* PBITMAPFILEHEADER */
    TEST_TYPE_SIZE   (PBITMAPFILEHEADER, 4)
    TEST_TYPE_ALIGN  (PBITMAPFILEHEADER, 4)
    TEST_TARGET_SIZE (PBITMAPFILEHEADER, 14)
    TEST_TARGET_ALIGN(PBITMAPFILEHEADER, 2)
}

static void test_pack_PBITMAPINFO(void)
{
    /* PBITMAPINFO */
    TEST_TYPE_SIZE   (PBITMAPINFO, 4)
    TEST_TYPE_ALIGN  (PBITMAPINFO, 4)
    TEST_TARGET_SIZE (PBITMAPINFO, 44)
    TEST_TARGET_ALIGN(PBITMAPINFO, 4)
}

static void test_pack_PBITMAPINFOHEADER(void)
{
    /* PBITMAPINFOHEADER */
    TEST_TYPE_SIZE   (PBITMAPINFOHEADER, 4)
    TEST_TYPE_ALIGN  (PBITMAPINFOHEADER, 4)
    TEST_TARGET_SIZE (PBITMAPINFOHEADER, 40)
    TEST_TARGET_ALIGN(PBITMAPINFOHEADER, 4)
}

static void test_pack_PBITMAPV4HEADER(void)
{
    /* PBITMAPV4HEADER */
    TEST_TYPE_SIZE   (PBITMAPV4HEADER, 4)
    TEST_TYPE_ALIGN  (PBITMAPV4HEADER, 4)
    TEST_TARGET_SIZE (PBITMAPV4HEADER, 108)
    TEST_TARGET_ALIGN(PBITMAPV4HEADER, 4)
}

static void test_pack_PBITMAPV5HEADER(void)
{
    /* PBITMAPV5HEADER */
    TEST_TYPE_SIZE   (PBITMAPV5HEADER, 4)
    TEST_TYPE_ALIGN  (PBITMAPV5HEADER, 4)
    TEST_TARGET_SIZE (PBITMAPV5HEADER, 124)
    TEST_TARGET_ALIGN(PBITMAPV5HEADER, 4)
}

static void test_pack_PBLENDFUNCTION(void)
{
    /* PBLENDFUNCTION */
    TEST_TYPE_SIZE   (PBLENDFUNCTION, 4)
    TEST_TYPE_ALIGN  (PBLENDFUNCTION, 4)
    TEST_TARGET_SIZE (PBLENDFUNCTION, 4)
    TEST_TARGET_ALIGN(PBLENDFUNCTION, 1)
}

static void test_pack_PCHARSETINFO(void)
{
    /* PCHARSETINFO */
    TEST_TYPE_SIZE   (PCHARSETINFO, 4)
    TEST_TYPE_ALIGN  (PCHARSETINFO, 4)
    TEST_TARGET_SIZE (PCHARSETINFO, 32)
    TEST_TARGET_ALIGN(PCHARSETINFO, 4)
}

static void test_pack_PCOLORADJUSTMENT(void)
{
    /* PCOLORADJUSTMENT */
    TEST_TYPE_SIZE   (PCOLORADJUSTMENT, 4)
    TEST_TYPE_ALIGN  (PCOLORADJUSTMENT, 4)
    TEST_TARGET_SIZE (PCOLORADJUSTMENT, 24)
    TEST_TARGET_ALIGN(PCOLORADJUSTMENT, 2)
}

static void test_pack_PDEVMODEA(void)
{
    /* PDEVMODEA */
    TEST_TYPE_SIZE   (PDEVMODEA, 4)
    TEST_TYPE_ALIGN  (PDEVMODEA, 4)
}

static void test_pack_PDEVMODEW(void)
{
    /* PDEVMODEW */
    TEST_TYPE_SIZE   (PDEVMODEW, 4)
    TEST_TYPE_ALIGN  (PDEVMODEW, 4)
}

static void test_pack_PDIBSECTION(void)
{
    /* PDIBSECTION */
    TEST_TYPE_SIZE   (PDIBSECTION, 4)
    TEST_TYPE_ALIGN  (PDIBSECTION, 4)
    TEST_TARGET_SIZE (PDIBSECTION, 84)
    TEST_TARGET_ALIGN(PDIBSECTION, 4)
}

static void test_pack_PDISPLAY_DEVICEA(void)
{
    /* PDISPLAY_DEVICEA */
    TEST_TYPE_SIZE   (PDISPLAY_DEVICEA, 4)
    TEST_TYPE_ALIGN  (PDISPLAY_DEVICEA, 4)
    TEST_TARGET_SIZE (PDISPLAY_DEVICEA, 424)
    TEST_TARGET_ALIGN(PDISPLAY_DEVICEA, 4)
}

static void test_pack_PDISPLAY_DEVICEW(void)
{
    /* PDISPLAY_DEVICEW */
    TEST_TYPE_SIZE   (PDISPLAY_DEVICEW, 4)
    TEST_TYPE_ALIGN  (PDISPLAY_DEVICEW, 4)
    TEST_TARGET_SIZE (PDISPLAY_DEVICEW, 840)
    TEST_TARGET_ALIGN(PDISPLAY_DEVICEW, 4)
}

static void test_pack_PELARRAY(void)
{
    /* PELARRAY (pack 4) */
    TEST_TYPE_SIZE   (PELARRAY, 20)
    TEST_TYPE_ALIGN  (PELARRAY, 4)
    TEST_FIELD_SIZE  (PELARRAY, paXCount, 4)
    TEST_FIELD_ALIGN (PELARRAY, paXCount, 4)
    TEST_FIELD_OFFSET(PELARRAY, paXCount, 0)
    TEST_FIELD_SIZE  (PELARRAY, paYCount, 4)
    TEST_FIELD_ALIGN (PELARRAY, paYCount, 4)
    TEST_FIELD_OFFSET(PELARRAY, paYCount, 4)
    TEST_FIELD_SIZE  (PELARRAY, paXExt, 4)
    TEST_FIELD_ALIGN (PELARRAY, paXExt, 4)
    TEST_FIELD_OFFSET(PELARRAY, paXExt, 8)
    TEST_FIELD_SIZE  (PELARRAY, paYExt, 4)
    TEST_FIELD_ALIGN (PELARRAY, paYExt, 4)
    TEST_FIELD_OFFSET(PELARRAY, paYExt, 12)
    TEST_FIELD_SIZE  (PELARRAY, paRGBs, 1)
    TEST_FIELD_ALIGN (PELARRAY, paRGBs, 1)
    TEST_FIELD_OFFSET(PELARRAY, paRGBs, 16)
}

static void test_pack_PEMR(void)
{
    /* PEMR */
    TEST_TYPE_SIZE   (PEMR, 4)
    TEST_TYPE_ALIGN  (PEMR, 4)
    TEST_TARGET_SIZE (PEMR, 8)
    TEST_TARGET_ALIGN(PEMR, 4)
}

static void test_pack_PEMRABORTPATH(void)
{
    /* PEMRABORTPATH */
    TEST_TYPE_SIZE   (PEMRABORTPATH, 4)
    TEST_TYPE_ALIGN  (PEMRABORTPATH, 4)
    TEST_TARGET_SIZE (PEMRABORTPATH, 8)
    TEST_TARGET_ALIGN(PEMRABORTPATH, 4)
}

static void test_pack_PEMRANGLEARC(void)
{
    /* PEMRANGLEARC */
    TEST_TYPE_SIZE   (PEMRANGLEARC, 4)
    TEST_TYPE_ALIGN  (PEMRANGLEARC, 4)
    TEST_TARGET_SIZE (PEMRANGLEARC, 28)
    TEST_TARGET_ALIGN(PEMRANGLEARC, 4)
}

static void test_pack_PEMRARC(void)
{
    /* PEMRARC */
    TEST_TYPE_SIZE   (PEMRARC, 4)
    TEST_TYPE_ALIGN  (PEMRARC, 4)
    TEST_TARGET_SIZE (PEMRARC, 40)
    TEST_TARGET_ALIGN(PEMRARC, 4)
}

static void test_pack_PEMRARCTO(void)
{
    /* PEMRARCTO */
    TEST_TYPE_SIZE   (PEMRARCTO, 4)
    TEST_TYPE_ALIGN  (PEMRARCTO, 4)
    TEST_TARGET_SIZE (PEMRARCTO, 40)
    TEST_TARGET_ALIGN(PEMRARCTO, 4)
}

static void test_pack_PEMRBEGINPATH(void)
{
    /* PEMRBEGINPATH */
    TEST_TYPE_SIZE   (PEMRBEGINPATH, 4)
    TEST_TYPE_ALIGN  (PEMRBEGINPATH, 4)
    TEST_TARGET_SIZE (PEMRBEGINPATH, 8)
    TEST_TARGET_ALIGN(PEMRBEGINPATH, 4)
}

static void test_pack_PEMRBITBLT(void)
{
    /* PEMRBITBLT */
    TEST_TYPE_SIZE   (PEMRBITBLT, 4)
    TEST_TYPE_ALIGN  (PEMRBITBLT, 4)
    TEST_TARGET_SIZE (PEMRBITBLT, 100)
    TEST_TARGET_ALIGN(PEMRBITBLT, 4)
}

static void test_pack_PEMRCHORD(void)
{
    /* PEMRCHORD */
    TEST_TYPE_SIZE   (PEMRCHORD, 4)
    TEST_TYPE_ALIGN  (PEMRCHORD, 4)
    TEST_TARGET_SIZE (PEMRCHORD, 40)
    TEST_TARGET_ALIGN(PEMRCHORD, 4)
}

static void test_pack_PEMRCLOSEFIGURE(void)
{
    /* PEMRCLOSEFIGURE */
    TEST_TYPE_SIZE   (PEMRCLOSEFIGURE, 4)
    TEST_TYPE_ALIGN  (PEMRCLOSEFIGURE, 4)
    TEST_TARGET_SIZE (PEMRCLOSEFIGURE, 8)
    TEST_TARGET_ALIGN(PEMRCLOSEFIGURE, 4)
}

static void test_pack_PEMRCREATEBRUSHINDIRECT(void)
{
    /* PEMRCREATEBRUSHINDIRECT */
    TEST_TYPE_SIZE   (PEMRCREATEBRUSHINDIRECT, 4)
    TEST_TYPE_ALIGN  (PEMRCREATEBRUSHINDIRECT, 4)
    TEST_TARGET_SIZE (PEMRCREATEBRUSHINDIRECT, 24)
    TEST_TARGET_ALIGN(PEMRCREATEBRUSHINDIRECT, 4)
}

static void test_pack_PEMRCREATECOLORSPACE(void)
{
    /* PEMRCREATECOLORSPACE */
    TEST_TYPE_SIZE   (PEMRCREATECOLORSPACE, 4)
    TEST_TYPE_ALIGN  (PEMRCREATECOLORSPACE, 4)
    TEST_TARGET_SIZE (PEMRCREATECOLORSPACE, 340)
    TEST_TARGET_ALIGN(PEMRCREATECOLORSPACE, 4)
}

static void test_pack_PEMRCREATECOLORSPACEW(void)
{
    /* PEMRCREATECOLORSPACEW */
    TEST_TYPE_SIZE   (PEMRCREATECOLORSPACEW, 4)
    TEST_TYPE_ALIGN  (PEMRCREATECOLORSPACEW, 4)
    TEST_TARGET_SIZE (PEMRCREATECOLORSPACEW, 612)
    TEST_TARGET_ALIGN(PEMRCREATECOLORSPACEW, 4)
}

static void test_pack_PEMRCREATEDIBPATTERNBRUSHPT(void)
{
    /* PEMRCREATEDIBPATTERNBRUSHPT */
    TEST_TYPE_SIZE   (PEMRCREATEDIBPATTERNBRUSHPT, 4)
    TEST_TYPE_ALIGN  (PEMRCREATEDIBPATTERNBRUSHPT, 4)
    TEST_TARGET_SIZE (PEMRCREATEDIBPATTERNBRUSHPT, 32)
    TEST_TARGET_ALIGN(PEMRCREATEDIBPATTERNBRUSHPT, 4)
}

static void test_pack_PEMRCREATEMONOBRUSH(void)
{
    /* PEMRCREATEMONOBRUSH */
    TEST_TYPE_SIZE   (PEMRCREATEMONOBRUSH, 4)
    TEST_TYPE_ALIGN  (PEMRCREATEMONOBRUSH, 4)
    TEST_TARGET_SIZE (PEMRCREATEMONOBRUSH, 32)
    TEST_TARGET_ALIGN(PEMRCREATEMONOBRUSH, 4)
}

static void test_pack_PEMRCREATEPALETTE(void)
{
    /* PEMRCREATEPALETTE */
    TEST_TYPE_SIZE   (PEMRCREATEPALETTE, 4)
    TEST_TYPE_ALIGN  (PEMRCREATEPALETTE, 4)
    TEST_TARGET_SIZE (PEMRCREATEPALETTE, 20)
    TEST_TARGET_ALIGN(PEMRCREATEPALETTE, 4)
}

static void test_pack_PEMRCREATEPEN(void)
{
    /* PEMRCREATEPEN */
    TEST_TYPE_SIZE   (PEMRCREATEPEN, 4)
    TEST_TYPE_ALIGN  (PEMRCREATEPEN, 4)
    TEST_TARGET_SIZE (PEMRCREATEPEN, 28)
    TEST_TARGET_ALIGN(PEMRCREATEPEN, 4)
}

static void test_pack_PEMRDELETECOLORSPACE(void)
{
    /* PEMRDELETECOLORSPACE */
    TEST_TYPE_SIZE   (PEMRDELETECOLORSPACE, 4)
    TEST_TYPE_ALIGN  (PEMRDELETECOLORSPACE, 4)
    TEST_TARGET_SIZE (PEMRDELETECOLORSPACE, 12)
    TEST_TARGET_ALIGN(PEMRDELETECOLORSPACE, 4)
}

static void test_pack_PEMRDELETEOBJECT(void)
{
    /* PEMRDELETEOBJECT */
    TEST_TYPE_SIZE   (PEMRDELETEOBJECT, 4)
    TEST_TYPE_ALIGN  (PEMRDELETEOBJECT, 4)
    TEST_TARGET_SIZE (PEMRDELETEOBJECT, 12)
    TEST_TARGET_ALIGN(PEMRDELETEOBJECT, 4)
}

static void test_pack_PEMRELLIPSE(void)
{
    /* PEMRELLIPSE */
    TEST_TYPE_SIZE   (PEMRELLIPSE, 4)
    TEST_TYPE_ALIGN  (PEMRELLIPSE, 4)
    TEST_TARGET_SIZE (PEMRELLIPSE, 24)
    TEST_TARGET_ALIGN(PEMRELLIPSE, 4)
}

static void test_pack_PEMRENDPATH(void)
{
    /* PEMRENDPATH */
    TEST_TYPE_SIZE   (PEMRENDPATH, 4)
    TEST_TYPE_ALIGN  (PEMRENDPATH, 4)
    TEST_TARGET_SIZE (PEMRENDPATH, 8)
    TEST_TARGET_ALIGN(PEMRENDPATH, 4)
}

static void test_pack_PEMREOF(void)
{
    /* PEMREOF */
    TEST_TYPE_SIZE   (PEMREOF, 4)
    TEST_TYPE_ALIGN  (PEMREOF, 4)
    TEST_TARGET_SIZE (PEMREOF, 20)
    TEST_TARGET_ALIGN(PEMREOF, 4)
}

static void test_pack_PEMREXCLUDECLIPRECT(void)
{
    /* PEMREXCLUDECLIPRECT */
    TEST_TYPE_SIZE   (PEMREXCLUDECLIPRECT, 4)
    TEST_TYPE_ALIGN  (PEMREXCLUDECLIPRECT, 4)
    TEST_TARGET_SIZE (PEMREXCLUDECLIPRECT, 24)
    TEST_TARGET_ALIGN(PEMREXCLUDECLIPRECT, 4)
}

static void test_pack_PEMREXTCREATEFONTINDIRECTW(void)
{
    /* PEMREXTCREATEFONTINDIRECTW */
    TEST_TYPE_SIZE   (PEMREXTCREATEFONTINDIRECTW, 4)
    TEST_TYPE_ALIGN  (PEMREXTCREATEFONTINDIRECTW, 4)
    TEST_TARGET_SIZE (PEMREXTCREATEFONTINDIRECTW, 332)
    TEST_TARGET_ALIGN(PEMREXTCREATEFONTINDIRECTW, 4)
}

static void test_pack_PEMREXTCREATEPEN(void)
{
    /* PEMREXTCREATEPEN */
    TEST_TYPE_SIZE   (PEMREXTCREATEPEN, 4)
    TEST_TYPE_ALIGN  (PEMREXTCREATEPEN, 4)
    TEST_TARGET_SIZE (PEMREXTCREATEPEN, 56)
    TEST_TARGET_ALIGN(PEMREXTCREATEPEN, 4)
}

static void test_pack_PEMREXTFLOODFILL(void)
{
    /* PEMREXTFLOODFILL */
    TEST_TYPE_SIZE   (PEMREXTFLOODFILL, 4)
    TEST_TYPE_ALIGN  (PEMREXTFLOODFILL, 4)
    TEST_TARGET_SIZE (PEMREXTFLOODFILL, 24)
    TEST_TARGET_ALIGN(PEMREXTFLOODFILL, 4)
}

static void test_pack_PEMREXTSELECTCLIPRGN(void)
{
    /* PEMREXTSELECTCLIPRGN */
    TEST_TYPE_SIZE   (PEMREXTSELECTCLIPRGN, 4)
    TEST_TYPE_ALIGN  (PEMREXTSELECTCLIPRGN, 4)
    TEST_TARGET_SIZE (PEMREXTSELECTCLIPRGN, 20)
    TEST_TARGET_ALIGN(PEMREXTSELECTCLIPRGN, 4)
}

static void test_pack_PEMREXTTEXTOUTA(void)
{
    /* PEMREXTTEXTOUTA */
    TEST_TYPE_SIZE   (PEMREXTTEXTOUTA, 4)
    TEST_TYPE_ALIGN  (PEMREXTTEXTOUTA, 4)
    TEST_TARGET_SIZE (PEMREXTTEXTOUTA, 76)
    TEST_TARGET_ALIGN(PEMREXTTEXTOUTA, 4)
}

static void test_pack_PEMREXTTEXTOUTW(void)
{
    /* PEMREXTTEXTOUTW */
    TEST_TYPE_SIZE   (PEMREXTTEXTOUTW, 4)
    TEST_TYPE_ALIGN  (PEMREXTTEXTOUTW, 4)
    TEST_TARGET_SIZE (PEMREXTTEXTOUTW, 76)
    TEST_TARGET_ALIGN(PEMREXTTEXTOUTW, 4)
}

static void test_pack_PEMRFILLPATH(void)
{
    /* PEMRFILLPATH */
    TEST_TYPE_SIZE   (PEMRFILLPATH, 4)
    TEST_TYPE_ALIGN  (PEMRFILLPATH, 4)
    TEST_TARGET_SIZE (PEMRFILLPATH, 24)
    TEST_TARGET_ALIGN(PEMRFILLPATH, 4)
}

static void test_pack_PEMRFILLRGN(void)
{
    /* PEMRFILLRGN */
    TEST_TYPE_SIZE   (PEMRFILLRGN, 4)
    TEST_TYPE_ALIGN  (PEMRFILLRGN, 4)
    TEST_TARGET_SIZE (PEMRFILLRGN, 36)
    TEST_TARGET_ALIGN(PEMRFILLRGN, 4)
}

static void test_pack_PEMRFLATTENPATH(void)
{
    /* PEMRFLATTENPATH */
    TEST_TYPE_SIZE   (PEMRFLATTENPATH, 4)
    TEST_TYPE_ALIGN  (PEMRFLATTENPATH, 4)
    TEST_TARGET_SIZE (PEMRFLATTENPATH, 8)
    TEST_TARGET_ALIGN(PEMRFLATTENPATH, 4)
}

static void test_pack_PEMRFORMAT(void)
{
    /* PEMRFORMAT */
    TEST_TYPE_SIZE   (PEMRFORMAT, 4)
    TEST_TYPE_ALIGN  (PEMRFORMAT, 4)
    TEST_TARGET_SIZE (PEMRFORMAT, 16)
    TEST_TARGET_ALIGN(PEMRFORMAT, 4)
}

static void test_pack_PEMRFRAMERGN(void)
{
    /* PEMRFRAMERGN */
    TEST_TYPE_SIZE   (PEMRFRAMERGN, 4)
    TEST_TYPE_ALIGN  (PEMRFRAMERGN, 4)
    TEST_TARGET_SIZE (PEMRFRAMERGN, 44)
    TEST_TARGET_ALIGN(PEMRFRAMERGN, 4)
}

static void test_pack_PEMRGDICOMMENT(void)
{
    /* PEMRGDICOMMENT */
    TEST_TYPE_SIZE   (PEMRGDICOMMENT, 4)
    TEST_TYPE_ALIGN  (PEMRGDICOMMENT, 4)
    TEST_TARGET_SIZE (PEMRGDICOMMENT, 16)
    TEST_TARGET_ALIGN(PEMRGDICOMMENT, 4)
}

static void test_pack_PEMRGLSBOUNDEDRECORD(void)
{
    /* PEMRGLSBOUNDEDRECORD */
    TEST_TYPE_SIZE   (PEMRGLSBOUNDEDRECORD, 4)
    TEST_TYPE_ALIGN  (PEMRGLSBOUNDEDRECORD, 4)
    TEST_TARGET_SIZE (PEMRGLSBOUNDEDRECORD, 32)
    TEST_TARGET_ALIGN(PEMRGLSBOUNDEDRECORD, 4)
}

static void test_pack_PEMRGLSRECORD(void)
{
    /* PEMRGLSRECORD */
    TEST_TYPE_SIZE   (PEMRGLSRECORD, 4)
    TEST_TYPE_ALIGN  (PEMRGLSRECORD, 4)
    TEST_TARGET_SIZE (PEMRGLSRECORD, 16)
    TEST_TARGET_ALIGN(PEMRGLSRECORD, 4)
}

static void test_pack_PEMRINTERSECTCLIPRECT(void)
{
    /* PEMRINTERSECTCLIPRECT */
    TEST_TYPE_SIZE   (PEMRINTERSECTCLIPRECT, 4)
    TEST_TYPE_ALIGN  (PEMRINTERSECTCLIPRECT, 4)
    TEST_TARGET_SIZE (PEMRINTERSECTCLIPRECT, 24)
    TEST_TARGET_ALIGN(PEMRINTERSECTCLIPRECT, 4)
}

static void test_pack_PEMRINVERTRGN(void)
{
    /* PEMRINVERTRGN */
    TEST_TYPE_SIZE   (PEMRINVERTRGN, 4)
    TEST_TYPE_ALIGN  (PEMRINVERTRGN, 4)
    TEST_TARGET_SIZE (PEMRINVERTRGN, 32)
    TEST_TARGET_ALIGN(PEMRINVERTRGN, 4)
}

static void test_pack_PEMRLINETO(void)
{
    /* PEMRLINETO */
    TEST_TYPE_SIZE   (PEMRLINETO, 4)
    TEST_TYPE_ALIGN  (PEMRLINETO, 4)
    TEST_TARGET_SIZE (PEMRLINETO, 16)
    TEST_TARGET_ALIGN(PEMRLINETO, 4)
}

static void test_pack_PEMRMASKBLT(void)
{
    /* PEMRMASKBLT */
    TEST_TYPE_SIZE   (PEMRMASKBLT, 4)
    TEST_TYPE_ALIGN  (PEMRMASKBLT, 4)
    TEST_TARGET_SIZE (PEMRMASKBLT, 128)
    TEST_TARGET_ALIGN(PEMRMASKBLT, 4)
}

static void test_pack_PEMRMODIFYWORLDTRANSFORM(void)
{
    /* PEMRMODIFYWORLDTRANSFORM */
    TEST_TYPE_SIZE   (PEMRMODIFYWORLDTRANSFORM, 4)
    TEST_TYPE_ALIGN  (PEMRMODIFYWORLDTRANSFORM, 4)
    TEST_TARGET_SIZE (PEMRMODIFYWORLDTRANSFORM, 36)
    TEST_TARGET_ALIGN(PEMRMODIFYWORLDTRANSFORM, 4)
}

static void test_pack_PEMRMOVETOEX(void)
{
    /* PEMRMOVETOEX */
    TEST_TYPE_SIZE   (PEMRMOVETOEX, 4)
    TEST_TYPE_ALIGN  (PEMRMOVETOEX, 4)
    TEST_TARGET_SIZE (PEMRMOVETOEX, 16)
    TEST_TARGET_ALIGN(PEMRMOVETOEX, 4)
}

static void test_pack_PEMROFFSETCLIPRGN(void)
{
    /* PEMROFFSETCLIPRGN */
    TEST_TYPE_SIZE   (PEMROFFSETCLIPRGN, 4)
    TEST_TYPE_ALIGN  (PEMROFFSETCLIPRGN, 4)
    TEST_TARGET_SIZE (PEMROFFSETCLIPRGN, 16)
    TEST_TARGET_ALIGN(PEMROFFSETCLIPRGN, 4)
}

static void test_pack_PEMRPAINTRGN(void)
{
    /* PEMRPAINTRGN */
    TEST_TYPE_SIZE   (PEMRPAINTRGN, 4)
    TEST_TYPE_ALIGN  (PEMRPAINTRGN, 4)
    TEST_TARGET_SIZE (PEMRPAINTRGN, 32)
    TEST_TARGET_ALIGN(PEMRPAINTRGN, 4)
}

static void test_pack_PEMRPIE(void)
{
    /* PEMRPIE */
    TEST_TYPE_SIZE   (PEMRPIE, 4)
    TEST_TYPE_ALIGN  (PEMRPIE, 4)
    TEST_TARGET_SIZE (PEMRPIE, 40)
    TEST_TARGET_ALIGN(PEMRPIE, 4)
}

static void test_pack_PEMRPIXELFORMAT(void)
{
    /* PEMRPIXELFORMAT */
    TEST_TYPE_SIZE   (PEMRPIXELFORMAT, 4)
    TEST_TYPE_ALIGN  (PEMRPIXELFORMAT, 4)
    TEST_TARGET_SIZE (PEMRPIXELFORMAT, 48)
    TEST_TARGET_ALIGN(PEMRPIXELFORMAT, 4)
}

static void test_pack_PEMRPLGBLT(void)
{
    /* PEMRPLGBLT */
    TEST_TYPE_SIZE   (PEMRPLGBLT, 4)
    TEST_TYPE_ALIGN  (PEMRPLGBLT, 4)
    TEST_TARGET_SIZE (PEMRPLGBLT, 140)
    TEST_TARGET_ALIGN(PEMRPLGBLT, 4)
}

static void test_pack_PEMRPOLYBEZIER(void)
{
    /* PEMRPOLYBEZIER */
    TEST_TYPE_SIZE   (PEMRPOLYBEZIER, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYBEZIER, 4)
    TEST_TARGET_SIZE (PEMRPOLYBEZIER, 36)
    TEST_TARGET_ALIGN(PEMRPOLYBEZIER, 4)
}

static void test_pack_PEMRPOLYBEZIER16(void)
{
    /* PEMRPOLYBEZIER16 */
    TEST_TYPE_SIZE   (PEMRPOLYBEZIER16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYBEZIER16, 4)
    TEST_TARGET_SIZE (PEMRPOLYBEZIER16, 32)
    TEST_TARGET_ALIGN(PEMRPOLYBEZIER16, 4)
}

static void test_pack_PEMRPOLYBEZIERTO(void)
{
    /* PEMRPOLYBEZIERTO */
    TEST_TYPE_SIZE   (PEMRPOLYBEZIERTO, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYBEZIERTO, 4)
    TEST_TARGET_SIZE (PEMRPOLYBEZIERTO, 36)
    TEST_TARGET_ALIGN(PEMRPOLYBEZIERTO, 4)
}

static void test_pack_PEMRPOLYBEZIERTO16(void)
{
    /* PEMRPOLYBEZIERTO16 */
    TEST_TYPE_SIZE   (PEMRPOLYBEZIERTO16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYBEZIERTO16, 4)
    TEST_TARGET_SIZE (PEMRPOLYBEZIERTO16, 32)
    TEST_TARGET_ALIGN(PEMRPOLYBEZIERTO16, 4)
}

static void test_pack_PEMRPOLYDRAW(void)
{
    /* PEMRPOLYDRAW */
    TEST_TYPE_SIZE   (PEMRPOLYDRAW, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYDRAW, 4)
    TEST_TARGET_SIZE (PEMRPOLYDRAW, 40)
    TEST_TARGET_ALIGN(PEMRPOLYDRAW, 4)
}

static void test_pack_PEMRPOLYDRAW16(void)
{
    /* PEMRPOLYDRAW16 */
    TEST_TYPE_SIZE   (PEMRPOLYDRAW16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYDRAW16, 4)
    TEST_TARGET_SIZE (PEMRPOLYDRAW16, 36)
    TEST_TARGET_ALIGN(PEMRPOLYDRAW16, 4)
}

static void test_pack_PEMRPOLYGON(void)
{
    /* PEMRPOLYGON */
    TEST_TYPE_SIZE   (PEMRPOLYGON, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYGON, 4)
    TEST_TARGET_SIZE (PEMRPOLYGON, 36)
    TEST_TARGET_ALIGN(PEMRPOLYGON, 4)
}

static void test_pack_PEMRPOLYGON16(void)
{
    /* PEMRPOLYGON16 */
    TEST_TYPE_SIZE   (PEMRPOLYGON16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYGON16, 4)
    TEST_TARGET_SIZE (PEMRPOLYGON16, 32)
    TEST_TARGET_ALIGN(PEMRPOLYGON16, 4)
}

static void test_pack_PEMRPOLYLINE(void)
{
    /* PEMRPOLYLINE */
    TEST_TYPE_SIZE   (PEMRPOLYLINE, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYLINE, 4)
    TEST_TARGET_SIZE (PEMRPOLYLINE, 36)
    TEST_TARGET_ALIGN(PEMRPOLYLINE, 4)
}

static void test_pack_PEMRPOLYLINE16(void)
{
    /* PEMRPOLYLINE16 */
    TEST_TYPE_SIZE   (PEMRPOLYLINE16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYLINE16, 4)
    TEST_TARGET_SIZE (PEMRPOLYLINE16, 32)
    TEST_TARGET_ALIGN(PEMRPOLYLINE16, 4)
}

static void test_pack_PEMRPOLYLINETO(void)
{
    /* PEMRPOLYLINETO */
    TEST_TYPE_SIZE   (PEMRPOLYLINETO, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYLINETO, 4)
    TEST_TARGET_SIZE (PEMRPOLYLINETO, 36)
    TEST_TARGET_ALIGN(PEMRPOLYLINETO, 4)
}

static void test_pack_PEMRPOLYLINETO16(void)
{
    /* PEMRPOLYLINETO16 */
    TEST_TYPE_SIZE   (PEMRPOLYLINETO16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYLINETO16, 4)
    TEST_TARGET_SIZE (PEMRPOLYLINETO16, 32)
    TEST_TARGET_ALIGN(PEMRPOLYLINETO16, 4)
}

static void test_pack_PEMRPOLYPOLYGON(void)
{
    /* PEMRPOLYPOLYGON */
    TEST_TYPE_SIZE   (PEMRPOLYPOLYGON, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYPOLYGON, 4)
    TEST_TARGET_SIZE (PEMRPOLYPOLYGON, 44)
    TEST_TARGET_ALIGN(PEMRPOLYPOLYGON, 4)
}

static void test_pack_PEMRPOLYPOLYGON16(void)
{
    /* PEMRPOLYPOLYGON16 */
    TEST_TYPE_SIZE   (PEMRPOLYPOLYGON16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYPOLYGON16, 4)
    TEST_TARGET_SIZE (PEMRPOLYPOLYGON16, 40)
    TEST_TARGET_ALIGN(PEMRPOLYPOLYGON16, 4)
}

static void test_pack_PEMRPOLYPOLYLINE(void)
{
    /* PEMRPOLYPOLYLINE */
    TEST_TYPE_SIZE   (PEMRPOLYPOLYLINE, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYPOLYLINE, 4)
    TEST_TARGET_SIZE (PEMRPOLYPOLYLINE, 44)
    TEST_TARGET_ALIGN(PEMRPOLYPOLYLINE, 4)
}

static void test_pack_PEMRPOLYPOLYLINE16(void)
{
    /* PEMRPOLYPOLYLINE16 */
    TEST_TYPE_SIZE   (PEMRPOLYPOLYLINE16, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYPOLYLINE16, 4)
    TEST_TARGET_SIZE (PEMRPOLYPOLYLINE16, 40)
    TEST_TARGET_ALIGN(PEMRPOLYPOLYLINE16, 4)
}

static void test_pack_PEMRPOLYTEXTOUTA(void)
{
    /* PEMRPOLYTEXTOUTA */
    TEST_TYPE_SIZE   (PEMRPOLYTEXTOUTA, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYTEXTOUTA, 4)
    TEST_TARGET_SIZE (PEMRPOLYTEXTOUTA, 80)
    TEST_TARGET_ALIGN(PEMRPOLYTEXTOUTA, 4)
}

static void test_pack_PEMRPOLYTEXTOUTW(void)
{
    /* PEMRPOLYTEXTOUTW */
    TEST_TYPE_SIZE   (PEMRPOLYTEXTOUTW, 4)
    TEST_TYPE_ALIGN  (PEMRPOLYTEXTOUTW, 4)
    TEST_TARGET_SIZE (PEMRPOLYTEXTOUTW, 80)
    TEST_TARGET_ALIGN(PEMRPOLYTEXTOUTW, 4)
}

static void test_pack_PEMRREALIZEPALETTE(void)
{
    /* PEMRREALIZEPALETTE */
    TEST_TYPE_SIZE   (PEMRREALIZEPALETTE, 4)
    TEST_TYPE_ALIGN  (PEMRREALIZEPALETTE, 4)
    TEST_TARGET_SIZE (PEMRREALIZEPALETTE, 8)
    TEST_TARGET_ALIGN(PEMRREALIZEPALETTE, 4)
}

static void test_pack_PEMRRECTANGLE(void)
{
    /* PEMRRECTANGLE */
    TEST_TYPE_SIZE   (PEMRRECTANGLE, 4)
    TEST_TYPE_ALIGN  (PEMRRECTANGLE, 4)
    TEST_TARGET_SIZE (PEMRRECTANGLE, 24)
    TEST_TARGET_ALIGN(PEMRRECTANGLE, 4)
}

static void test_pack_PEMRRESIZEPALETTE(void)
{
    /* PEMRRESIZEPALETTE */
    TEST_TYPE_SIZE   (PEMRRESIZEPALETTE, 4)
    TEST_TYPE_ALIGN  (PEMRRESIZEPALETTE, 4)
    TEST_TARGET_SIZE (PEMRRESIZEPALETTE, 16)
    TEST_TARGET_ALIGN(PEMRRESIZEPALETTE, 4)
}

static void test_pack_PEMRRESTOREDC(void)
{
    /* PEMRRESTOREDC */
    TEST_TYPE_SIZE   (PEMRRESTOREDC, 4)
    TEST_TYPE_ALIGN  (PEMRRESTOREDC, 4)
    TEST_TARGET_SIZE (PEMRRESTOREDC, 12)
    TEST_TARGET_ALIGN(PEMRRESTOREDC, 4)
}

static void test_pack_PEMRROUNDRECT(void)
{
    /* PEMRROUNDRECT */
    TEST_TYPE_SIZE   (PEMRROUNDRECT, 4)
    TEST_TYPE_ALIGN  (PEMRROUNDRECT, 4)
    TEST_TARGET_SIZE (PEMRROUNDRECT, 32)
    TEST_TARGET_ALIGN(PEMRROUNDRECT, 4)
}

static void test_pack_PEMRSAVEDC(void)
{
    /* PEMRSAVEDC */
    TEST_TYPE_SIZE   (PEMRSAVEDC, 4)
    TEST_TYPE_ALIGN  (PEMRSAVEDC, 4)
    TEST_TARGET_SIZE (PEMRSAVEDC, 8)
    TEST_TARGET_ALIGN(PEMRSAVEDC, 4)
}

static void test_pack_PEMRSCALEVIEWPORTEXTEX(void)
{
    /* PEMRSCALEVIEWPORTEXTEX */
    TEST_TYPE_SIZE   (PEMRSCALEVIEWPORTEXTEX, 4)
    TEST_TYPE_ALIGN  (PEMRSCALEVIEWPORTEXTEX, 4)
    TEST_TARGET_SIZE (PEMRSCALEVIEWPORTEXTEX, 24)
    TEST_TARGET_ALIGN(PEMRSCALEVIEWPORTEXTEX, 4)
}

static void test_pack_PEMRSCALEWINDOWEXTEX(void)
{
    /* PEMRSCALEWINDOWEXTEX */
    TEST_TYPE_SIZE   (PEMRSCALEWINDOWEXTEX, 4)
    TEST_TYPE_ALIGN  (PEMRSCALEWINDOWEXTEX, 4)
    TEST_TARGET_SIZE (PEMRSCALEWINDOWEXTEX, 24)
    TEST_TARGET_ALIGN(PEMRSCALEWINDOWEXTEX, 4)
}

static void test_pack_PEMRSELECTCLIPPATH(void)
{
    /* PEMRSELECTCLIPPATH */
    TEST_TYPE_SIZE   (PEMRSELECTCLIPPATH, 4)
    TEST_TYPE_ALIGN  (PEMRSELECTCLIPPATH, 4)
    TEST_TARGET_SIZE (PEMRSELECTCLIPPATH, 12)
    TEST_TARGET_ALIGN(PEMRSELECTCLIPPATH, 4)
}

static void test_pack_PEMRSELECTCOLORSPACE(void)
{
    /* PEMRSELECTCOLORSPACE */
    TEST_TYPE_SIZE   (PEMRSELECTCOLORSPACE, 4)
    TEST_TYPE_ALIGN  (PEMRSELECTCOLORSPACE, 4)
    TEST_TARGET_SIZE (PEMRSELECTCOLORSPACE, 12)
    TEST_TARGET_ALIGN(PEMRSELECTCOLORSPACE, 4)
}

static void test_pack_PEMRSELECTOBJECT(void)
{
    /* PEMRSELECTOBJECT */
    TEST_TYPE_SIZE   (PEMRSELECTOBJECT, 4)
    TEST_TYPE_ALIGN  (PEMRSELECTOBJECT, 4)
    TEST_TARGET_SIZE (PEMRSELECTOBJECT, 12)
    TEST_TARGET_ALIGN(PEMRSELECTOBJECT, 4)
}

static void test_pack_PEMRSELECTPALETTE(void)
{
    /* PEMRSELECTPALETTE */
    TEST_TYPE_SIZE   (PEMRSELECTPALETTE, 4)
    TEST_TYPE_ALIGN  (PEMRSELECTPALETTE, 4)
    TEST_TARGET_SIZE (PEMRSELECTPALETTE, 12)
    TEST_TARGET_ALIGN(PEMRSELECTPALETTE, 4)
}

static void test_pack_PEMRSETARCDIRECTION(void)
{
    /* PEMRSETARCDIRECTION */
    TEST_TYPE_SIZE   (PEMRSETARCDIRECTION, 4)
    TEST_TYPE_ALIGN  (PEMRSETARCDIRECTION, 4)
    TEST_TARGET_SIZE (PEMRSETARCDIRECTION, 12)
    TEST_TARGET_ALIGN(PEMRSETARCDIRECTION, 4)
}

static void test_pack_PEMRSETBKCOLOR(void)
{
    /* PEMRSETBKCOLOR */
    TEST_TYPE_SIZE   (PEMRSETBKCOLOR, 4)
    TEST_TYPE_ALIGN  (PEMRSETBKCOLOR, 4)
    TEST_TARGET_SIZE (PEMRSETBKCOLOR, 12)
    TEST_TARGET_ALIGN(PEMRSETBKCOLOR, 4)
}

static void test_pack_PEMRSETBKMODE(void)
{
    /* PEMRSETBKMODE */
    TEST_TYPE_SIZE   (PEMRSETBKMODE, 4)
    TEST_TYPE_ALIGN  (PEMRSETBKMODE, 4)
    TEST_TARGET_SIZE (PEMRSETBKMODE, 12)
    TEST_TARGET_ALIGN(PEMRSETBKMODE, 4)
}

static void test_pack_PEMRSETBRUSHORGEX(void)
{
    /* PEMRSETBRUSHORGEX */
    TEST_TYPE_SIZE   (PEMRSETBRUSHORGEX, 4)
    TEST_TYPE_ALIGN  (PEMRSETBRUSHORGEX, 4)
    TEST_TARGET_SIZE (PEMRSETBRUSHORGEX, 16)
    TEST_TARGET_ALIGN(PEMRSETBRUSHORGEX, 4)
}

static void test_pack_PEMRSETCOLORADJUSTMENT(void)
{
    /* PEMRSETCOLORADJUSTMENT */
    TEST_TYPE_SIZE   (PEMRSETCOLORADJUSTMENT, 4)
    TEST_TYPE_ALIGN  (PEMRSETCOLORADJUSTMENT, 4)
    TEST_TARGET_SIZE (PEMRSETCOLORADJUSTMENT, 32)
    TEST_TARGET_ALIGN(PEMRSETCOLORADJUSTMENT, 4)
}

static void test_pack_PEMRSETCOLORSPACE(void)
{
    /* PEMRSETCOLORSPACE */
    TEST_TYPE_SIZE   (PEMRSETCOLORSPACE, 4)
    TEST_TYPE_ALIGN  (PEMRSETCOLORSPACE, 4)
    TEST_TARGET_SIZE (PEMRSETCOLORSPACE, 12)
    TEST_TARGET_ALIGN(PEMRSETCOLORSPACE, 4)
}

static void test_pack_PEMRSETDIBITSTODEVICE(void)
{
    /* PEMRSETDIBITSTODEVICE */
    TEST_TYPE_SIZE   (PEMRSETDIBITSTODEVICE, 4)
    TEST_TYPE_ALIGN  (PEMRSETDIBITSTODEVICE, 4)
    TEST_TARGET_SIZE (PEMRSETDIBITSTODEVICE, 76)
    TEST_TARGET_ALIGN(PEMRSETDIBITSTODEVICE, 4)
}

static void test_pack_PEMRSETICMMODE(void)
{
    /* PEMRSETICMMODE */
    TEST_TYPE_SIZE   (PEMRSETICMMODE, 4)
    TEST_TYPE_ALIGN  (PEMRSETICMMODE, 4)
    TEST_TARGET_SIZE (PEMRSETICMMODE, 12)
    TEST_TARGET_ALIGN(PEMRSETICMMODE, 4)
}

static void test_pack_PEMRSETLAYOUT(void)
{
    /* PEMRSETLAYOUT */
    TEST_TYPE_SIZE   (PEMRSETLAYOUT, 4)
    TEST_TYPE_ALIGN  (PEMRSETLAYOUT, 4)
    TEST_TARGET_SIZE (PEMRSETLAYOUT, 12)
    TEST_TARGET_ALIGN(PEMRSETLAYOUT, 4)
}

static void test_pack_PEMRSETMAPMODE(void)
{
    /* PEMRSETMAPMODE */
    TEST_TYPE_SIZE   (PEMRSETMAPMODE, 4)
    TEST_TYPE_ALIGN  (PEMRSETMAPMODE, 4)
    TEST_TARGET_SIZE (PEMRSETMAPMODE, 12)
    TEST_TARGET_ALIGN(PEMRSETMAPMODE, 4)
}

static void test_pack_PEMRSETMAPPERFLAGS(void)
{
    /* PEMRSETMAPPERFLAGS */
    TEST_TYPE_SIZE   (PEMRSETMAPPERFLAGS, 4)
    TEST_TYPE_ALIGN  (PEMRSETMAPPERFLAGS, 4)
    TEST_TARGET_SIZE (PEMRSETMAPPERFLAGS, 12)
    TEST_TARGET_ALIGN(PEMRSETMAPPERFLAGS, 4)
}

static void test_pack_PEMRSETMETARGN(void)
{
    /* PEMRSETMETARGN */
    TEST_TYPE_SIZE   (PEMRSETMETARGN, 4)
    TEST_TYPE_ALIGN  (PEMRSETMETARGN, 4)
    TEST_TARGET_SIZE (PEMRSETMETARGN, 8)
    TEST_TARGET_ALIGN(PEMRSETMETARGN, 4)
}

static void test_pack_PEMRSETMITERLIMIT(void)
{
    /* PEMRSETMITERLIMIT */
    TEST_TYPE_SIZE   (PEMRSETMITERLIMIT, 4)
    TEST_TYPE_ALIGN  (PEMRSETMITERLIMIT, 4)
    TEST_TARGET_SIZE (PEMRSETMITERLIMIT, 12)
    TEST_TARGET_ALIGN(PEMRSETMITERLIMIT, 4)
}

static void test_pack_PEMRSETPALETTEENTRIES(void)
{
    /* PEMRSETPALETTEENTRIES */
    TEST_TYPE_SIZE   (PEMRSETPALETTEENTRIES, 4)
    TEST_TYPE_ALIGN  (PEMRSETPALETTEENTRIES, 4)
    TEST_TARGET_SIZE (PEMRSETPALETTEENTRIES, 24)
    TEST_TARGET_ALIGN(PEMRSETPALETTEENTRIES, 4)
}

static void test_pack_PEMRSETPIXELV(void)
{
    /* PEMRSETPIXELV */
    TEST_TYPE_SIZE   (PEMRSETPIXELV, 4)
    TEST_TYPE_ALIGN  (PEMRSETPIXELV, 4)
    TEST_TARGET_SIZE (PEMRSETPIXELV, 20)
    TEST_TARGET_ALIGN(PEMRSETPIXELV, 4)
}

static void test_pack_PEMRSETPOLYFILLMODE(void)
{
    /* PEMRSETPOLYFILLMODE */
    TEST_TYPE_SIZE   (PEMRSETPOLYFILLMODE, 4)
    TEST_TYPE_ALIGN  (PEMRSETPOLYFILLMODE, 4)
    TEST_TARGET_SIZE (PEMRSETPOLYFILLMODE, 12)
    TEST_TARGET_ALIGN(PEMRSETPOLYFILLMODE, 4)
}

static void test_pack_PEMRSETROP2(void)
{
    /* PEMRSETROP2 */
    TEST_TYPE_SIZE   (PEMRSETROP2, 4)
    TEST_TYPE_ALIGN  (PEMRSETROP2, 4)
    TEST_TARGET_SIZE (PEMRSETROP2, 12)
    TEST_TARGET_ALIGN(PEMRSETROP2, 4)
}

static void test_pack_PEMRSETSTRETCHBLTMODE(void)
{
    /* PEMRSETSTRETCHBLTMODE */
    TEST_TYPE_SIZE   (PEMRSETSTRETCHBLTMODE, 4)
    TEST_TYPE_ALIGN  (PEMRSETSTRETCHBLTMODE, 4)
    TEST_TARGET_SIZE (PEMRSETSTRETCHBLTMODE, 12)
    TEST_TARGET_ALIGN(PEMRSETSTRETCHBLTMODE, 4)
}

static void test_pack_PEMRSETTEXTALIGN(void)
{
    /* PEMRSETTEXTALIGN */
    TEST_TYPE_SIZE   (PEMRSETTEXTALIGN, 4)
    TEST_TYPE_ALIGN  (PEMRSETTEXTALIGN, 4)
    TEST_TARGET_SIZE (PEMRSETTEXTALIGN, 12)
    TEST_TARGET_ALIGN(PEMRSETTEXTALIGN, 4)
}

static void test_pack_PEMRSETTEXTCOLOR(void)
{
    /* PEMRSETTEXTCOLOR */
    TEST_TYPE_SIZE   (PEMRSETTEXTCOLOR, 4)
    TEST_TYPE_ALIGN  (PEMRSETTEXTCOLOR, 4)
    TEST_TARGET_SIZE (PEMRSETTEXTCOLOR, 12)
    TEST_TARGET_ALIGN(PEMRSETTEXTCOLOR, 4)
}

static void test_pack_PEMRSETVIEWPORTEXTEX(void)
{
    /* PEMRSETVIEWPORTEXTEX */
    TEST_TYPE_SIZE   (PEMRSETVIEWPORTEXTEX, 4)
    TEST_TYPE_ALIGN  (PEMRSETVIEWPORTEXTEX, 4)
    TEST_TARGET_SIZE (PEMRSETVIEWPORTEXTEX, 16)
    TEST_TARGET_ALIGN(PEMRSETVIEWPORTEXTEX, 4)
}

static void test_pack_PEMRSETVIEWPORTORGEX(void)
{
    /* PEMRSETVIEWPORTORGEX */
    TEST_TYPE_SIZE   (PEMRSETVIEWPORTORGEX, 4)
    TEST_TYPE_ALIGN  (PEMRSETVIEWPORTORGEX, 4)
    TEST_TARGET_SIZE (PEMRSETVIEWPORTORGEX, 16)
    TEST_TARGET_ALIGN(PEMRSETVIEWPORTORGEX, 4)
}

static void test_pack_PEMRSETWINDOWEXTEX(void)
{
    /* PEMRSETWINDOWEXTEX */
    TEST_TYPE_SIZE   (PEMRSETWINDOWEXTEX, 4)
    TEST_TYPE_ALIGN  (PEMRSETWINDOWEXTEX, 4)
    TEST_TARGET_SIZE (PEMRSETWINDOWEXTEX, 16)
    TEST_TARGET_ALIGN(PEMRSETWINDOWEXTEX, 4)
}

static void test_pack_PEMRSETWINDOWORGEX(void)
{
    /* PEMRSETWINDOWORGEX */
    TEST_TYPE_SIZE   (PEMRSETWINDOWORGEX, 4)
    TEST_TYPE_ALIGN  (PEMRSETWINDOWORGEX, 4)
    TEST_TARGET_SIZE (PEMRSETWINDOWORGEX, 16)
    TEST_TARGET_ALIGN(PEMRSETWINDOWORGEX, 4)
}

static void test_pack_PEMRSETWORLDTRANSFORM(void)
{
    /* PEMRSETWORLDTRANSFORM */
    TEST_TYPE_SIZE   (PEMRSETWORLDTRANSFORM, 4)
    TEST_TYPE_ALIGN  (PEMRSETWORLDTRANSFORM, 4)
    TEST_TARGET_SIZE (PEMRSETWORLDTRANSFORM, 32)
    TEST_TARGET_ALIGN(PEMRSETWORLDTRANSFORM, 4)
}

static void test_pack_PEMRSTRETCHBLT(void)
{
    /* PEMRSTRETCHBLT */
    TEST_TYPE_SIZE   (PEMRSTRETCHBLT, 4)
    TEST_TYPE_ALIGN  (PEMRSTRETCHBLT, 4)
    TEST_TARGET_SIZE (PEMRSTRETCHBLT, 108)
    TEST_TARGET_ALIGN(PEMRSTRETCHBLT, 4)
}

static void test_pack_PEMRSTRETCHDIBITS(void)
{
    /* PEMRSTRETCHDIBITS */
    TEST_TYPE_SIZE   (PEMRSTRETCHDIBITS, 4)
    TEST_TYPE_ALIGN  (PEMRSTRETCHDIBITS, 4)
    TEST_TARGET_SIZE (PEMRSTRETCHDIBITS, 80)
    TEST_TARGET_ALIGN(PEMRSTRETCHDIBITS, 4)
}

static void test_pack_PEMRSTROKEANDFILLPATH(void)
{
    /* PEMRSTROKEANDFILLPATH */
    TEST_TYPE_SIZE   (PEMRSTROKEANDFILLPATH, 4)
    TEST_TYPE_ALIGN  (PEMRSTROKEANDFILLPATH, 4)
    TEST_TARGET_SIZE (PEMRSTROKEANDFILLPATH, 24)
    TEST_TARGET_ALIGN(PEMRSTROKEANDFILLPATH, 4)
}

static void test_pack_PEMRSTROKEPATH(void)
{
    /* PEMRSTROKEPATH */
    TEST_TYPE_SIZE   (PEMRSTROKEPATH, 4)
    TEST_TYPE_ALIGN  (PEMRSTROKEPATH, 4)
    TEST_TARGET_SIZE (PEMRSTROKEPATH, 24)
    TEST_TARGET_ALIGN(PEMRSTROKEPATH, 4)
}

static void test_pack_PEMRTEXT(void)
{
    /* PEMRTEXT */
    TEST_TYPE_SIZE   (PEMRTEXT, 4)
    TEST_TYPE_ALIGN  (PEMRTEXT, 4)
    TEST_TARGET_SIZE (PEMRTEXT, 40)
    TEST_TARGET_ALIGN(PEMRTEXT, 4)
}

static void test_pack_PEMRWIDENPATH(void)
{
    /* PEMRWIDENPATH */
    TEST_TYPE_SIZE   (PEMRWIDENPATH, 4)
    TEST_TYPE_ALIGN  (PEMRWIDENPATH, 4)
    TEST_TARGET_SIZE (PEMRWIDENPATH, 8)
    TEST_TARGET_ALIGN(PEMRWIDENPATH, 4)
}

static void test_pack_PENHMETAHEADER(void)
{
    /* PENHMETAHEADER */
    TEST_TYPE_SIZE   (PENHMETAHEADER, 4)
    TEST_TYPE_ALIGN  (PENHMETAHEADER, 4)
    TEST_TARGET_SIZE (PENHMETAHEADER, 108)
    TEST_TARGET_ALIGN(PENHMETAHEADER, 4)
}

static void test_pack_PEXTLOGFONTA(void)
{
    /* PEXTLOGFONTA */
    TEST_TYPE_SIZE   (PEXTLOGFONTA, 4)
    TEST_TYPE_ALIGN  (PEXTLOGFONTA, 4)
    TEST_TARGET_SIZE (PEXTLOGFONTA, 192)
    TEST_TARGET_ALIGN(PEXTLOGFONTA, 4)
}

static void test_pack_PEXTLOGFONTW(void)
{
    /* PEXTLOGFONTW */
    TEST_TYPE_SIZE   (PEXTLOGFONTW, 4)
    TEST_TYPE_ALIGN  (PEXTLOGFONTW, 4)
    TEST_TARGET_SIZE (PEXTLOGFONTW, 320)
    TEST_TARGET_ALIGN(PEXTLOGFONTW, 4)
}

static void test_pack_PEXTLOGPEN(void)
{
    /* PEXTLOGPEN */
    TEST_TYPE_SIZE   (PEXTLOGPEN, 4)
    TEST_TYPE_ALIGN  (PEXTLOGPEN, 4)
    TEST_TARGET_SIZE (PEXTLOGPEN, 28)
    TEST_TARGET_ALIGN(PEXTLOGPEN, 4)
}

static void test_pack_PFONTSIGNATURE(void)
{
    /* PFONTSIGNATURE */
    TEST_TYPE_SIZE   (PFONTSIGNATURE, 4)
    TEST_TYPE_ALIGN  (PFONTSIGNATURE, 4)
    TEST_TARGET_SIZE (PFONTSIGNATURE, 24)
    TEST_TARGET_ALIGN(PFONTSIGNATURE, 4)
}

static void test_pack_PGLYPHMETRICSFLOAT(void)
{
    /* PGLYPHMETRICSFLOAT */
    TEST_TYPE_SIZE   (PGLYPHMETRICSFLOAT, 4)
    TEST_TYPE_ALIGN  (PGLYPHMETRICSFLOAT, 4)
    TEST_TARGET_SIZE (PGLYPHMETRICSFLOAT, 24)
    TEST_TARGET_ALIGN(PGLYPHMETRICSFLOAT, 4)
}

static void test_pack_PGRADIENT_RECT(void)
{
    /* PGRADIENT_RECT */
    TEST_TYPE_SIZE   (PGRADIENT_RECT, 4)
    TEST_TYPE_ALIGN  (PGRADIENT_RECT, 4)
    TEST_TARGET_SIZE (PGRADIENT_RECT, 8)
    TEST_TARGET_ALIGN(PGRADIENT_RECT, 4)
}

static void test_pack_PGRADIENT_TRIANGLE(void)
{
    /* PGRADIENT_TRIANGLE */
    TEST_TYPE_SIZE   (PGRADIENT_TRIANGLE, 4)
    TEST_TYPE_ALIGN  (PGRADIENT_TRIANGLE, 4)
    TEST_TARGET_SIZE (PGRADIENT_TRIANGLE, 12)
    TEST_TARGET_ALIGN(PGRADIENT_TRIANGLE, 4)
}

static void test_pack_PHANDLETABLE(void)
{
    /* PHANDLETABLE */
    TEST_TYPE_SIZE   (PHANDLETABLE, 4)
    TEST_TYPE_ALIGN  (PHANDLETABLE, 4)
    TEST_TARGET_SIZE (PHANDLETABLE, 4)
    TEST_TARGET_ALIGN(PHANDLETABLE, 4)
}

static void test_pack_PIXELFORMATDESCRIPTOR(void)
{
    /* PIXELFORMATDESCRIPTOR (pack 4) */
    TEST_TYPE_SIZE   (PIXELFORMATDESCRIPTOR, 40)
    TEST_TYPE_ALIGN  (PIXELFORMATDESCRIPTOR, 4)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, nSize, 2)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, nSize, 2)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, nSize, 0)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, nVersion, 2)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, nVersion, 2)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, nVersion, 2)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, dwFlags, 4)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, dwFlags, 4)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, dwFlags, 4)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, iPixelType, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, iPixelType, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, iPixelType, 8)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cColorBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cColorBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cColorBits, 9)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cRedBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cRedBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cRedBits, 10)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cRedShift, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cRedShift, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cRedShift, 11)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cGreenBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cGreenBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cGreenBits, 12)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cGreenShift, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cGreenShift, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cGreenShift, 13)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cBlueBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cBlueBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cBlueBits, 14)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cBlueShift, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cBlueShift, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cBlueShift, 15)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAlphaBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAlphaBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAlphaBits, 16)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAlphaShift, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAlphaShift, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAlphaShift, 17)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAccumBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAccumBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAccumBits, 18)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAccumRedBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAccumRedBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAccumRedBits, 19)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAccumGreenBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAccumGreenBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAccumGreenBits, 20)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAccumBlueBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAccumBlueBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAccumBlueBits, 21)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAccumAlphaBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAccumAlphaBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAccumAlphaBits, 22)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cDepthBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cDepthBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cDepthBits, 23)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cStencilBits, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cStencilBits, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cStencilBits, 24)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, cAuxBuffers, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, cAuxBuffers, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, cAuxBuffers, 25)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, iLayerType, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, iLayerType, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, iLayerType, 26)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, bReserved, 1)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, bReserved, 1)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, bReserved, 27)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, dwLayerMask, 4)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, dwLayerMask, 4)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, dwLayerMask, 28)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, dwVisibleMask, 4)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, dwVisibleMask, 4)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, dwVisibleMask, 32)
    TEST_FIELD_SIZE  (PIXELFORMATDESCRIPTOR, dwDamageMask, 4)
    TEST_FIELD_ALIGN (PIXELFORMATDESCRIPTOR, dwDamageMask, 4)
    TEST_FIELD_OFFSET(PIXELFORMATDESCRIPTOR, dwDamageMask, 36)
}

static void test_pack_PLAYERPLANEDESCRIPTOR(void)
{
    /* PLAYERPLANEDESCRIPTOR */
    TEST_TYPE_SIZE   (PLAYERPLANEDESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (PLAYERPLANEDESCRIPTOR, 4)
    TEST_TARGET_SIZE (PLAYERPLANEDESCRIPTOR, 32)
    TEST_TARGET_ALIGN(PLAYERPLANEDESCRIPTOR, 4)
}

static void test_pack_PLOCALESIGNATURE(void)
{
    /* PLOCALESIGNATURE */
    TEST_TYPE_SIZE   (PLOCALESIGNATURE, 4)
    TEST_TYPE_ALIGN  (PLOCALESIGNATURE, 4)
    TEST_TARGET_SIZE (PLOCALESIGNATURE, 32)
    TEST_TARGET_ALIGN(PLOCALESIGNATURE, 4)
}

static void test_pack_PLOGBRUSH(void)
{
    /* PLOGBRUSH */
    TEST_TYPE_SIZE   (PLOGBRUSH, 4)
    TEST_TYPE_ALIGN  (PLOGBRUSH, 4)
    TEST_TARGET_SIZE (PLOGBRUSH, 12)
    TEST_TARGET_ALIGN(PLOGBRUSH, 4)
}

static void test_pack_PLOGFONTA(void)
{
    /* PLOGFONTA */
    TEST_TYPE_SIZE   (PLOGFONTA, 4)
    TEST_TYPE_ALIGN  (PLOGFONTA, 4)
    TEST_TARGET_SIZE (PLOGFONTA, 60)
    TEST_TARGET_ALIGN(PLOGFONTA, 4)
}

static void test_pack_PLOGFONTW(void)
{
    /* PLOGFONTW */
    TEST_TYPE_SIZE   (PLOGFONTW, 4)
    TEST_TYPE_ALIGN  (PLOGFONTW, 4)
    TEST_TARGET_SIZE (PLOGFONTW, 92)
    TEST_TARGET_ALIGN(PLOGFONTW, 4)
}

static void test_pack_PMETAHEADER(void)
{
    /* PMETAHEADER */
    TEST_TYPE_SIZE   (PMETAHEADER, 4)
    TEST_TYPE_ALIGN  (PMETAHEADER, 4)
    TEST_TARGET_SIZE (PMETAHEADER, 18)
    TEST_TARGET_ALIGN(PMETAHEADER, 2)
}

static void test_pack_PMETARECORD(void)
{
    /* PMETARECORD */
    TEST_TYPE_SIZE   (PMETARECORD, 4)
    TEST_TYPE_ALIGN  (PMETARECORD, 4)
    TEST_TARGET_SIZE (PMETARECORD, 8)
    TEST_TARGET_ALIGN(PMETARECORD, 4)
}

static void test_pack_PNEWTEXTMETRICA(void)
{
    /* PNEWTEXTMETRICA */
    TEST_TYPE_SIZE   (PNEWTEXTMETRICA, 4)
    TEST_TYPE_ALIGN  (PNEWTEXTMETRICA, 4)
    TEST_TARGET_SIZE (PNEWTEXTMETRICA, 72)
    TEST_TARGET_ALIGN(PNEWTEXTMETRICA, 4)
}

static void test_pack_PNEWTEXTMETRICW(void)
{
    /* PNEWTEXTMETRICW */
    TEST_TYPE_SIZE   (PNEWTEXTMETRICW, 4)
    TEST_TYPE_ALIGN  (PNEWTEXTMETRICW, 4)
    TEST_TARGET_SIZE (PNEWTEXTMETRICW, 76)
    TEST_TARGET_ALIGN(PNEWTEXTMETRICW, 4)
}

static void test_pack_POINTFLOAT(void)
{
    /* POINTFLOAT (pack 4) */
    TEST_TYPE_SIZE   (POINTFLOAT, 8)
    TEST_TYPE_ALIGN  (POINTFLOAT, 4)
    TEST_FIELD_SIZE  (POINTFLOAT, x, 4)
    TEST_FIELD_ALIGN (POINTFLOAT, x, 4)
    TEST_FIELD_OFFSET(POINTFLOAT, x, 0)
    TEST_FIELD_SIZE  (POINTFLOAT, y, 4)
    TEST_FIELD_ALIGN (POINTFLOAT, y, 4)
    TEST_FIELD_OFFSET(POINTFLOAT, y, 4)
}

static void test_pack_POINTFX(void)
{
    /* POINTFX (pack 4) */
    TEST_TYPE_SIZE   (POINTFX, 8)
    TEST_TYPE_ALIGN  (POINTFX, 2)
    TEST_FIELD_SIZE  (POINTFX, x, 4)
    TEST_FIELD_ALIGN (POINTFX, x, 2)
    TEST_FIELD_OFFSET(POINTFX, x, 0)
    TEST_FIELD_SIZE  (POINTFX, y, 4)
    TEST_FIELD_ALIGN (POINTFX, y, 2)
    TEST_FIELD_OFFSET(POINTFX, y, 4)
}

static void test_pack_POLYTEXTA(void)
{
    /* POLYTEXTA (pack 4) */
    TEST_TYPE_SIZE   (POLYTEXTA, 40)
    TEST_TYPE_ALIGN  (POLYTEXTA, 4)
    TEST_FIELD_SIZE  (POLYTEXTA, x, 4)
    TEST_FIELD_ALIGN (POLYTEXTA, x, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, x, 0)
    TEST_FIELD_SIZE  (POLYTEXTA, y, 4)
    TEST_FIELD_ALIGN (POLYTEXTA, y, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, y, 4)
    TEST_FIELD_SIZE  (POLYTEXTA, n, 4)
    TEST_FIELD_ALIGN (POLYTEXTA, n, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, n, 8)
    TEST_FIELD_SIZE  (POLYTEXTA, lpstr, 4)
    TEST_FIELD_ALIGN (POLYTEXTA, lpstr, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, lpstr, 12)
    TEST_FIELD_SIZE  (POLYTEXTA, uiFlags, 4)
    TEST_FIELD_ALIGN (POLYTEXTA, uiFlags, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, uiFlags, 16)
    TEST_FIELD_SIZE  (POLYTEXTA, rcl, 16)
    TEST_FIELD_ALIGN (POLYTEXTA, rcl, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, rcl, 20)
    TEST_FIELD_SIZE  (POLYTEXTA, pdx, 4)
    TEST_FIELD_ALIGN (POLYTEXTA, pdx, 4)
    TEST_FIELD_OFFSET(POLYTEXTA, pdx, 36)
}

static void test_pack_POLYTEXTW(void)
{
    /* POLYTEXTW (pack 4) */
    TEST_TYPE_SIZE   (POLYTEXTW, 40)
    TEST_TYPE_ALIGN  (POLYTEXTW, 4)
    TEST_FIELD_SIZE  (POLYTEXTW, x, 4)
    TEST_FIELD_ALIGN (POLYTEXTW, x, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, x, 0)
    TEST_FIELD_SIZE  (POLYTEXTW, y, 4)
    TEST_FIELD_ALIGN (POLYTEXTW, y, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, y, 4)
    TEST_FIELD_SIZE  (POLYTEXTW, n, 4)
    TEST_FIELD_ALIGN (POLYTEXTW, n, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, n, 8)
    TEST_FIELD_SIZE  (POLYTEXTW, lpstr, 4)
    TEST_FIELD_ALIGN (POLYTEXTW, lpstr, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, lpstr, 12)
    TEST_FIELD_SIZE  (POLYTEXTW, uiFlags, 4)
    TEST_FIELD_ALIGN (POLYTEXTW, uiFlags, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, uiFlags, 16)
    TEST_FIELD_SIZE  (POLYTEXTW, rcl, 16)
    TEST_FIELD_ALIGN (POLYTEXTW, rcl, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, rcl, 20)
    TEST_FIELD_SIZE  (POLYTEXTW, pdx, 4)
    TEST_FIELD_ALIGN (POLYTEXTW, pdx, 4)
    TEST_FIELD_OFFSET(POLYTEXTW, pdx, 36)
}

static void test_pack_POUTLINETEXTMETRICA(void)
{
    /* POUTLINETEXTMETRICA */
    TEST_TYPE_SIZE   (POUTLINETEXTMETRICA, 4)
    TEST_TYPE_ALIGN  (POUTLINETEXTMETRICA, 4)
    TEST_TARGET_SIZE (POUTLINETEXTMETRICA, 212)
    TEST_TARGET_ALIGN(POUTLINETEXTMETRICA, 4)
}

static void test_pack_POUTLINETEXTMETRICW(void)
{
    /* POUTLINETEXTMETRICW */
    TEST_TYPE_SIZE   (POUTLINETEXTMETRICW, 4)
    TEST_TYPE_ALIGN  (POUTLINETEXTMETRICW, 4)
    TEST_TARGET_SIZE (POUTLINETEXTMETRICW, 216)
    TEST_TARGET_ALIGN(POUTLINETEXTMETRICW, 4)
}

static void test_pack_PPELARRAY(void)
{
    /* PPELARRAY */
    TEST_TYPE_SIZE   (PPELARRAY, 4)
    TEST_TYPE_ALIGN  (PPELARRAY, 4)
    TEST_TARGET_SIZE (PPELARRAY, 20)
    TEST_TARGET_ALIGN(PPELARRAY, 4)
}

static void test_pack_PPIXELFORMATDESCRIPTOR(void)
{
    /* PPIXELFORMATDESCRIPTOR */
    TEST_TYPE_SIZE   (PPIXELFORMATDESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (PPIXELFORMATDESCRIPTOR, 4)
    TEST_TARGET_SIZE (PPIXELFORMATDESCRIPTOR, 40)
    TEST_TARGET_ALIGN(PPIXELFORMATDESCRIPTOR, 4)
}

static void test_pack_PPOINTFLOAT(void)
{
    /* PPOINTFLOAT */
    TEST_TYPE_SIZE   (PPOINTFLOAT, 4)
    TEST_TYPE_ALIGN  (PPOINTFLOAT, 4)
    TEST_TARGET_SIZE (PPOINTFLOAT, 8)
    TEST_TARGET_ALIGN(PPOINTFLOAT, 4)
}

static void test_pack_PPOLYTEXTA(void)
{
    /* PPOLYTEXTA */
    TEST_TYPE_SIZE   (PPOLYTEXTA, 4)
    TEST_TYPE_ALIGN  (PPOLYTEXTA, 4)
    TEST_TARGET_SIZE (PPOLYTEXTA, 40)
    TEST_TARGET_ALIGN(PPOLYTEXTA, 4)
}

static void test_pack_PPOLYTEXTW(void)
{
    /* PPOLYTEXTW */
    TEST_TYPE_SIZE   (PPOLYTEXTW, 4)
    TEST_TYPE_ALIGN  (PPOLYTEXTW, 4)
    TEST_TARGET_SIZE (PPOLYTEXTW, 40)
    TEST_TARGET_ALIGN(PPOLYTEXTW, 4)
}

static void test_pack_PRGNDATA(void)
{
    /* PRGNDATA */
    TEST_TYPE_SIZE   (PRGNDATA, 4)
    TEST_TYPE_ALIGN  (PRGNDATA, 4)
    TEST_TARGET_SIZE (PRGNDATA, 36)
    TEST_TARGET_ALIGN(PRGNDATA, 4)
}

static void test_pack_PRGNDATAHEADER(void)
{
    /* PRGNDATAHEADER */
    TEST_TYPE_SIZE   (PRGNDATAHEADER, 4)
    TEST_TYPE_ALIGN  (PRGNDATAHEADER, 4)
    TEST_TARGET_SIZE (PRGNDATAHEADER, 32)
    TEST_TARGET_ALIGN(PRGNDATAHEADER, 4)
}

static void test_pack_PTEXTMETRICA(void)
{
    /* PTEXTMETRICA */
    TEST_TYPE_SIZE   (PTEXTMETRICA, 4)
    TEST_TYPE_ALIGN  (PTEXTMETRICA, 4)
    TEST_TARGET_SIZE (PTEXTMETRICA, 56)
    TEST_TARGET_ALIGN(PTEXTMETRICA, 4)
}

static void test_pack_PTEXTMETRICW(void)
{
    /* PTEXTMETRICW */
    TEST_TYPE_SIZE   (PTEXTMETRICW, 4)
    TEST_TYPE_ALIGN  (PTEXTMETRICW, 4)
    TEST_TARGET_SIZE (PTEXTMETRICW, 60)
    TEST_TARGET_ALIGN(PTEXTMETRICW, 4)
}

static void test_pack_PTRIVERTEX(void)
{
    /* PTRIVERTEX */
    TEST_TYPE_SIZE   (PTRIVERTEX, 4)
    TEST_TYPE_ALIGN  (PTRIVERTEX, 4)
    TEST_TARGET_SIZE (PTRIVERTEX, 16)
    TEST_TARGET_ALIGN(PTRIVERTEX, 4)
}

static void test_pack_PXFORM(void)
{
    /* PXFORM */
    TEST_TYPE_SIZE   (PXFORM, 4)
    TEST_TYPE_ALIGN  (PXFORM, 4)
    TEST_TARGET_SIZE (PXFORM, 24)
    TEST_TARGET_ALIGN(PXFORM, 4)
}

static void test_pack_RASTERIZER_STATUS(void)
{
    /* RASTERIZER_STATUS (pack 4) */
    TEST_TYPE_SIZE   (RASTERIZER_STATUS, 6)
    TEST_TYPE_ALIGN  (RASTERIZER_STATUS, 2)
    TEST_FIELD_SIZE  (RASTERIZER_STATUS, nSize, 2)
    TEST_FIELD_ALIGN (RASTERIZER_STATUS, nSize, 2)
    TEST_FIELD_OFFSET(RASTERIZER_STATUS, nSize, 0)
    TEST_FIELD_SIZE  (RASTERIZER_STATUS, wFlags, 2)
    TEST_FIELD_ALIGN (RASTERIZER_STATUS, wFlags, 2)
    TEST_FIELD_OFFSET(RASTERIZER_STATUS, wFlags, 2)
    TEST_FIELD_SIZE  (RASTERIZER_STATUS, nLanguageID, 2)
    TEST_FIELD_ALIGN (RASTERIZER_STATUS, nLanguageID, 2)
    TEST_FIELD_OFFSET(RASTERIZER_STATUS, nLanguageID, 4)
}

static void test_pack_RGBQUAD(void)
{
    /* RGBQUAD (pack 4) */
    TEST_TYPE_SIZE   (RGBQUAD, 4)
    TEST_TYPE_ALIGN  (RGBQUAD, 1)
    TEST_FIELD_SIZE  (RGBQUAD, rgbBlue, 1)
    TEST_FIELD_ALIGN (RGBQUAD, rgbBlue, 1)
    TEST_FIELD_OFFSET(RGBQUAD, rgbBlue, 0)
    TEST_FIELD_SIZE  (RGBQUAD, rgbGreen, 1)
    TEST_FIELD_ALIGN (RGBQUAD, rgbGreen, 1)
    TEST_FIELD_OFFSET(RGBQUAD, rgbGreen, 1)
    TEST_FIELD_SIZE  (RGBQUAD, rgbRed, 1)
    TEST_FIELD_ALIGN (RGBQUAD, rgbRed, 1)
    TEST_FIELD_OFFSET(RGBQUAD, rgbRed, 2)
    TEST_FIELD_SIZE  (RGBQUAD, rgbReserved, 1)
    TEST_FIELD_ALIGN (RGBQUAD, rgbReserved, 1)
    TEST_FIELD_OFFSET(RGBQUAD, rgbReserved, 3)
}

static void test_pack_RGBTRIPLE(void)
{
    /* RGBTRIPLE (pack 4) */
    TEST_TYPE_SIZE   (RGBTRIPLE, 3)
    TEST_TYPE_ALIGN  (RGBTRIPLE, 1)
    TEST_FIELD_SIZE  (RGBTRIPLE, rgbtBlue, 1)
    TEST_FIELD_ALIGN (RGBTRIPLE, rgbtBlue, 1)
    TEST_FIELD_OFFSET(RGBTRIPLE, rgbtBlue, 0)
    TEST_FIELD_SIZE  (RGBTRIPLE, rgbtGreen, 1)
    TEST_FIELD_ALIGN (RGBTRIPLE, rgbtGreen, 1)
    TEST_FIELD_OFFSET(RGBTRIPLE, rgbtGreen, 1)
    TEST_FIELD_SIZE  (RGBTRIPLE, rgbtRed, 1)
    TEST_FIELD_ALIGN (RGBTRIPLE, rgbtRed, 1)
    TEST_FIELD_OFFSET(RGBTRIPLE, rgbtRed, 2)
}

static void test_pack_RGNDATA(void)
{
    /* RGNDATA (pack 4) */
    TEST_TYPE_SIZE   (RGNDATA, 36)
    TEST_TYPE_ALIGN  (RGNDATA, 4)
    TEST_FIELD_SIZE  (RGNDATA, rdh, 32)
    TEST_FIELD_ALIGN (RGNDATA, rdh, 4)
    TEST_FIELD_OFFSET(RGNDATA, rdh, 0)
    TEST_FIELD_SIZE  (RGNDATA, Buffer, 1)
    TEST_FIELD_ALIGN (RGNDATA, Buffer, 1)
    TEST_FIELD_OFFSET(RGNDATA, Buffer, 32)
}

static void test_pack_RGNDATAHEADER(void)
{
    /* RGNDATAHEADER (pack 4) */
    TEST_TYPE_SIZE   (RGNDATAHEADER, 32)
    TEST_TYPE_ALIGN  (RGNDATAHEADER, 4)
    TEST_FIELD_SIZE  (RGNDATAHEADER, dwSize, 4)
    TEST_FIELD_ALIGN (RGNDATAHEADER, dwSize, 4)
    TEST_FIELD_OFFSET(RGNDATAHEADER, dwSize, 0)
    TEST_FIELD_SIZE  (RGNDATAHEADER, iType, 4)
    TEST_FIELD_ALIGN (RGNDATAHEADER, iType, 4)
    TEST_FIELD_OFFSET(RGNDATAHEADER, iType, 4)
    TEST_FIELD_SIZE  (RGNDATAHEADER, nCount, 4)
    TEST_FIELD_ALIGN (RGNDATAHEADER, nCount, 4)
    TEST_FIELD_OFFSET(RGNDATAHEADER, nCount, 8)
    TEST_FIELD_SIZE  (RGNDATAHEADER, nRgnSize, 4)
    TEST_FIELD_ALIGN (RGNDATAHEADER, nRgnSize, 4)
    TEST_FIELD_OFFSET(RGNDATAHEADER, nRgnSize, 12)
    TEST_FIELD_SIZE  (RGNDATAHEADER, rcBound, 16)
    TEST_FIELD_ALIGN (RGNDATAHEADER, rcBound, 4)
    TEST_FIELD_OFFSET(RGNDATAHEADER, rcBound, 16)
}

static void test_pack_TEXTMETRICA(void)
{
    /* TEXTMETRICA (pack 4) */
    TEST_TYPE_SIZE   (TEXTMETRICA, 56)
    TEST_TYPE_ALIGN  (TEXTMETRICA, 4)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmHeight, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmHeight, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmHeight, 0)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmAscent, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmAscent, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmAscent, 4)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmDescent, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmDescent, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmDescent, 8)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmInternalLeading, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmInternalLeading, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmInternalLeading, 12)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmExternalLeading, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmExternalLeading, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmExternalLeading, 16)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmAveCharWidth, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmAveCharWidth, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmAveCharWidth, 20)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmMaxCharWidth, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmMaxCharWidth, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmMaxCharWidth, 24)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmWeight, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmWeight, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmWeight, 28)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmOverhang, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmOverhang, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmOverhang, 32)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmDigitizedAspectX, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmDigitizedAspectX, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmDigitizedAspectX, 36)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmDigitizedAspectY, 4)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmDigitizedAspectY, 4)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmDigitizedAspectY, 40)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmFirstChar, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmFirstChar, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmFirstChar, 44)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmLastChar, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmLastChar, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmLastChar, 45)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmDefaultChar, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmDefaultChar, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmDefaultChar, 46)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmBreakChar, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmBreakChar, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmBreakChar, 47)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmItalic, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmItalic, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmItalic, 48)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmUnderlined, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmUnderlined, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmUnderlined, 49)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmStruckOut, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmStruckOut, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmStruckOut, 50)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmPitchAndFamily, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmPitchAndFamily, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmPitchAndFamily, 51)
    TEST_FIELD_SIZE  (TEXTMETRICA, tmCharSet, 1)
    TEST_FIELD_ALIGN (TEXTMETRICA, tmCharSet, 1)
    TEST_FIELD_OFFSET(TEXTMETRICA, tmCharSet, 52)
}

static void test_pack_TEXTMETRICW(void)
{
    /* TEXTMETRICW (pack 4) */
    TEST_TYPE_SIZE   (TEXTMETRICW, 60)
    TEST_TYPE_ALIGN  (TEXTMETRICW, 4)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmHeight, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmHeight, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmHeight, 0)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmAscent, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmAscent, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmAscent, 4)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmDescent, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmDescent, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmDescent, 8)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmInternalLeading, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmInternalLeading, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmInternalLeading, 12)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmExternalLeading, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmExternalLeading, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmExternalLeading, 16)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmAveCharWidth, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmAveCharWidth, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmAveCharWidth, 20)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmMaxCharWidth, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmMaxCharWidth, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmMaxCharWidth, 24)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmWeight, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmWeight, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmWeight, 28)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmOverhang, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmOverhang, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmOverhang, 32)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmDigitizedAspectX, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmDigitizedAspectX, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmDigitizedAspectX, 36)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmDigitizedAspectY, 4)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmDigitizedAspectY, 4)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmDigitizedAspectY, 40)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmFirstChar, 2)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmFirstChar, 2)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmFirstChar, 44)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmLastChar, 2)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmLastChar, 2)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmLastChar, 46)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmDefaultChar, 2)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmDefaultChar, 2)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmDefaultChar, 48)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmBreakChar, 2)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmBreakChar, 2)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmBreakChar, 50)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmItalic, 1)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmItalic, 1)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmItalic, 52)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmUnderlined, 1)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmUnderlined, 1)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmUnderlined, 53)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmStruckOut, 1)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmStruckOut, 1)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmStruckOut, 54)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmPitchAndFamily, 1)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmPitchAndFamily, 1)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmPitchAndFamily, 55)
    TEST_FIELD_SIZE  (TEXTMETRICW, tmCharSet, 1)
    TEST_FIELD_ALIGN (TEXTMETRICW, tmCharSet, 1)
    TEST_FIELD_OFFSET(TEXTMETRICW, tmCharSet, 56)
}

static void test_pack_TRIVERTEX(void)
{
    /* TRIVERTEX (pack 4) */
    TEST_TYPE_SIZE   (TRIVERTEX, 16)
    TEST_TYPE_ALIGN  (TRIVERTEX, 4)
    TEST_FIELD_SIZE  (TRIVERTEX, x, 4)
    TEST_FIELD_ALIGN (TRIVERTEX, x, 4)
    TEST_FIELD_OFFSET(TRIVERTEX, x, 0)
    TEST_FIELD_SIZE  (TRIVERTEX, y, 4)
    TEST_FIELD_ALIGN (TRIVERTEX, y, 4)
    TEST_FIELD_OFFSET(TRIVERTEX, y, 4)
    TEST_FIELD_SIZE  (TRIVERTEX, Red, 2)
    TEST_FIELD_ALIGN (TRIVERTEX, Red, 2)
    TEST_FIELD_OFFSET(TRIVERTEX, Red, 8)
    TEST_FIELD_SIZE  (TRIVERTEX, Green, 2)
    TEST_FIELD_ALIGN (TRIVERTEX, Green, 2)
    TEST_FIELD_OFFSET(TRIVERTEX, Green, 10)
    TEST_FIELD_SIZE  (TRIVERTEX, Blue, 2)
    TEST_FIELD_ALIGN (TRIVERTEX, Blue, 2)
    TEST_FIELD_OFFSET(TRIVERTEX, Blue, 12)
    TEST_FIELD_SIZE  (TRIVERTEX, Alpha, 2)
    TEST_FIELD_ALIGN (TRIVERTEX, Alpha, 2)
    TEST_FIELD_OFFSET(TRIVERTEX, Alpha, 14)
}

static void test_pack_TTPOLYCURVE(void)
{
    /* TTPOLYCURVE (pack 4) */
    TEST_TYPE_SIZE   (TTPOLYCURVE, 12)
    TEST_TYPE_ALIGN  (TTPOLYCURVE, 2)
    TEST_FIELD_SIZE  (TTPOLYCURVE, wType, 2)
    TEST_FIELD_ALIGN (TTPOLYCURVE, wType, 2)
    TEST_FIELD_OFFSET(TTPOLYCURVE, wType, 0)
    TEST_FIELD_SIZE  (TTPOLYCURVE, cpfx, 2)
    TEST_FIELD_ALIGN (TTPOLYCURVE, cpfx, 2)
    TEST_FIELD_OFFSET(TTPOLYCURVE, cpfx, 2)
    TEST_FIELD_SIZE  (TTPOLYCURVE, apfx, 8)
    TEST_FIELD_ALIGN (TTPOLYCURVE, apfx, 2)
    TEST_FIELD_OFFSET(TTPOLYCURVE, apfx, 4)
}

static void test_pack_TTPOLYGONHEADER(void)
{
    /* TTPOLYGONHEADER (pack 4) */
    TEST_TYPE_SIZE   (TTPOLYGONHEADER, 16)
    TEST_TYPE_ALIGN  (TTPOLYGONHEADER, 4)
    TEST_FIELD_SIZE  (TTPOLYGONHEADER, cb, 4)
    TEST_FIELD_ALIGN (TTPOLYGONHEADER, cb, 4)
    TEST_FIELD_OFFSET(TTPOLYGONHEADER, cb, 0)
    TEST_FIELD_SIZE  (TTPOLYGONHEADER, dwType, 4)
    TEST_FIELD_ALIGN (TTPOLYGONHEADER, dwType, 4)
    TEST_FIELD_OFFSET(TTPOLYGONHEADER, dwType, 4)
    TEST_FIELD_SIZE  (TTPOLYGONHEADER, pfxStart, 8)
    TEST_FIELD_ALIGN (TTPOLYGONHEADER, pfxStart, 2)
    TEST_FIELD_OFFSET(TTPOLYGONHEADER, pfxStart, 8)
}

static void test_pack_XFORM(void)
{
    /* XFORM (pack 4) */
    TEST_TYPE_SIZE   (XFORM, 24)
    TEST_TYPE_ALIGN  (XFORM, 4)
    TEST_FIELD_SIZE  (XFORM, eM11, 4)
    TEST_FIELD_ALIGN (XFORM, eM11, 4)
    TEST_FIELD_OFFSET(XFORM, eM11, 0)
    TEST_FIELD_SIZE  (XFORM, eM12, 4)
    TEST_FIELD_ALIGN (XFORM, eM12, 4)
    TEST_FIELD_OFFSET(XFORM, eM12, 4)
    TEST_FIELD_SIZE  (XFORM, eM21, 4)
    TEST_FIELD_ALIGN (XFORM, eM21, 4)
    TEST_FIELD_OFFSET(XFORM, eM21, 8)
    TEST_FIELD_SIZE  (XFORM, eM22, 4)
    TEST_FIELD_ALIGN (XFORM, eM22, 4)
    TEST_FIELD_OFFSET(XFORM, eM22, 12)
    TEST_FIELD_SIZE  (XFORM, eDx, 4)
    TEST_FIELD_ALIGN (XFORM, eDx, 4)
    TEST_FIELD_OFFSET(XFORM, eDx, 16)
    TEST_FIELD_SIZE  (XFORM, eDy, 4)
    TEST_FIELD_ALIGN (XFORM, eDy, 4)
    TEST_FIELD_OFFSET(XFORM, eDy, 20)
}

static void test_pack(void)
{
    test_pack_ABC();
    test_pack_ABCFLOAT();
    test_pack_ABORTPROC();
    test_pack_BITMAP();
    test_pack_BITMAPCOREHEADER();
    test_pack_BITMAPCOREINFO();
    test_pack_BITMAPFILEHEADER();
    test_pack_BITMAPINFO();
    test_pack_BITMAPINFOHEADER();
    test_pack_BITMAPV4HEADER();
    test_pack_BITMAPV5HEADER();
    test_pack_BLENDFUNCTION();
    test_pack_CHARSETINFO();
    test_pack_CIEXYZ();
    test_pack_CIEXYZTRIPLE();
    test_pack_COLOR16();
    test_pack_COLORADJUSTMENT();
    test_pack_DEVMODEA();
    test_pack_DEVMODEW();
    test_pack_DIBSECTION();
    test_pack_DISPLAY_DEVICEA();
    test_pack_DISPLAY_DEVICEW();
    test_pack_DOCINFOA();
    test_pack_DOCINFOW();
    test_pack_EMR();
    test_pack_EMRABORTPATH();
    test_pack_EMRANGLEARC();
    test_pack_EMRARC();
    test_pack_EMRARCTO();
    test_pack_EMRBEGINPATH();
    test_pack_EMRBITBLT();
    test_pack_EMRCHORD();
    test_pack_EMRCLOSEFIGURE();
    test_pack_EMRCREATEBRUSHINDIRECT();
    test_pack_EMRCREATECOLORSPACE();
    test_pack_EMRCREATECOLORSPACEW();
    test_pack_EMRCREATEDIBPATTERNBRUSHPT();
    test_pack_EMRCREATEMONOBRUSH();
    test_pack_EMRCREATEPEN();
    test_pack_EMRDELETECOLORSPACE();
    test_pack_EMRDELETEOBJECT();
    test_pack_EMRELLIPSE();
    test_pack_EMRENDPATH();
    test_pack_EMREOF();
    test_pack_EMREXCLUDECLIPRECT();
    test_pack_EMREXTCREATEFONTINDIRECTW();
    test_pack_EMREXTCREATEPEN();
    test_pack_EMREXTFLOODFILL();
    test_pack_EMREXTSELECTCLIPRGN();
    test_pack_EMREXTTEXTOUTA();
    test_pack_EMREXTTEXTOUTW();
    test_pack_EMRFILLPATH();
    test_pack_EMRFILLRGN();
    test_pack_EMRFLATTENPATH();
    test_pack_EMRFORMAT();
    test_pack_EMRFRAMERGN();
    test_pack_EMRGDICOMMENT();
    test_pack_EMRGLSBOUNDEDRECORD();
    test_pack_EMRGLSRECORD();
    test_pack_EMRINTERSECTCLIPRECT();
    test_pack_EMRINVERTRGN();
    test_pack_EMRLINETO();
    test_pack_EMRMASKBLT();
    test_pack_EMRMODIFYWORLDTRANSFORM();
    test_pack_EMRMOVETOEX();
    test_pack_EMROFFSETCLIPRGN();
    test_pack_EMRPAINTRGN();
    test_pack_EMRPIE();
    test_pack_EMRPIXELFORMAT();
    test_pack_EMRPLGBLT();
    test_pack_EMRPOLYBEZIER();
    test_pack_EMRPOLYBEZIER16();
    test_pack_EMRPOLYBEZIERTO();
    test_pack_EMRPOLYBEZIERTO16();
    test_pack_EMRPOLYDRAW();
    test_pack_EMRPOLYDRAW16();
    test_pack_EMRPOLYGON();
    test_pack_EMRPOLYGON16();
    test_pack_EMRPOLYLINE();
    test_pack_EMRPOLYLINE16();
    test_pack_EMRPOLYLINETO();
    test_pack_EMRPOLYLINETO16();
    test_pack_EMRPOLYPOLYGON();
    test_pack_EMRPOLYPOLYGON16();
    test_pack_EMRPOLYPOLYLINE();
    test_pack_EMRPOLYPOLYLINE16();
    test_pack_EMRPOLYTEXTOUTA();
    test_pack_EMRPOLYTEXTOUTW();
    test_pack_EMRREALIZEPALETTE();
    test_pack_EMRRECTANGLE();
    test_pack_EMRRESIZEPALETTE();
    test_pack_EMRRESTOREDC();
    test_pack_EMRROUNDRECT();
    test_pack_EMRSAVEDC();
    test_pack_EMRSCALEVIEWPORTEXTEX();
    test_pack_EMRSCALEWINDOWEXTEX();
    test_pack_EMRSELECTCLIPPATH();
    test_pack_EMRSELECTCOLORSPACE();
    test_pack_EMRSELECTOBJECT();
    test_pack_EMRSELECTPALETTE();
    test_pack_EMRSETARCDIRECTION();
    test_pack_EMRSETBKCOLOR();
    test_pack_EMRSETBKMODE();
    test_pack_EMRSETBRUSHORGEX();
    test_pack_EMRSETCOLORADJUSTMENT();
    test_pack_EMRSETCOLORSPACE();
    test_pack_EMRSETDIBITSTODEVICE();
    test_pack_EMRSETICMMODE();
    test_pack_EMRSETLAYOUT();
    test_pack_EMRSETMAPMODE();
    test_pack_EMRSETMAPPERFLAGS();
    test_pack_EMRSETMETARGN();
    test_pack_EMRSETMITERLIMIT();
    test_pack_EMRSETPIXELV();
    test_pack_EMRSETPOLYFILLMODE();
    test_pack_EMRSETROP2();
    test_pack_EMRSETSTRETCHBLTMODE();
    test_pack_EMRSETTEXTALIGN();
    test_pack_EMRSETTEXTCOLOR();
    test_pack_EMRSETVIEWPORTEXTEX();
    test_pack_EMRSETVIEWPORTORGEX();
    test_pack_EMRSETWINDOWEXTEX();
    test_pack_EMRSETWINDOWORGEX();
    test_pack_EMRSETWORLDTRANSFORM();
    test_pack_EMRSTRETCHBLT();
    test_pack_EMRSTRETCHDIBITS();
    test_pack_EMRSTROKEANDFILLPATH();
    test_pack_EMRSTROKEPATH();
    test_pack_EMRTEXT();
    test_pack_EMRWIDENPATH();
    test_pack_ENHMETAHEADER();
    test_pack_ENHMETARECORD();
    test_pack_ENHMFENUMPROC();
    test_pack_ENUMLOGFONTA();
    test_pack_ENUMLOGFONTEXA();
    test_pack_ENUMLOGFONTEXW();
    test_pack_ENUMLOGFONTW();
    test_pack_EXTLOGFONTA();
    test_pack_EXTLOGFONTW();
    test_pack_EXTLOGPEN();
    test_pack_FIXED();
    test_pack_FONTENUMPROCA();
    test_pack_FONTENUMPROCW();
    test_pack_FONTSIGNATURE();
    test_pack_FXPT16DOT16();
    test_pack_FXPT2DOT30();
    test_pack_GCP_RESULTSA();
    test_pack_GCP_RESULTSW();
    test_pack_GLYPHMETRICS();
    test_pack_GLYPHMETRICSFLOAT();
    test_pack_GOBJENUMPROC();
    test_pack_GRADIENT_RECT();
    test_pack_GRADIENT_TRIANGLE();
    test_pack_HANDLETABLE();
    test_pack_ICMENUMPROCA();
    test_pack_ICMENUMPROCW();
    test_pack_KERNINGPAIR();
    test_pack_LAYERPLANEDESCRIPTOR();
    test_pack_LCSCSTYPE();
    test_pack_LCSGAMUTMATCH();
    test_pack_LINEDDAPROC();
    test_pack_LOCALESIGNATURE();
    test_pack_LOGBRUSH();
    test_pack_LOGCOLORSPACEA();
    test_pack_LOGCOLORSPACEW();
    test_pack_LOGFONTA();
    test_pack_LOGFONTW();
    test_pack_LOGPEN();
    test_pack_LPABC();
    test_pack_LPABCFLOAT();
    test_pack_LPBITMAP();
    test_pack_LPBITMAPCOREHEADER();
    test_pack_LPBITMAPCOREINFO();
    test_pack_LPBITMAPFILEHEADER();
    test_pack_LPBITMAPINFO();
    test_pack_LPBITMAPINFOHEADER();
    test_pack_LPBITMAPV5HEADER();
    test_pack_LPCHARSETINFO();
    test_pack_LPCIEXYZ();
    test_pack_LPCIEXYZTRIPLE();
    test_pack_LPCOLORADJUSTMENT();
    test_pack_LPDEVMODEA();
    test_pack_LPDEVMODEW();
    test_pack_LPDIBSECTION();
    test_pack_LPDISPLAY_DEVICEA();
    test_pack_LPDISPLAY_DEVICEW();
    test_pack_LPDOCINFOA();
    test_pack_LPDOCINFOW();
    test_pack_LPENHMETAHEADER();
    test_pack_LPENHMETARECORD();
    test_pack_LPENUMLOGFONTA();
    test_pack_LPENUMLOGFONTEXA();
    test_pack_LPENUMLOGFONTEXW();
    test_pack_LPENUMLOGFONTW();
    test_pack_LPEXTLOGFONTA();
    test_pack_LPEXTLOGFONTW();
    test_pack_LPEXTLOGPEN();
    test_pack_LPFONTSIGNATURE();
    test_pack_LPGCP_RESULTSA();
    test_pack_LPGCP_RESULTSW();
    test_pack_LPGLYPHMETRICS();
    test_pack_LPGLYPHMETRICSFLOAT();
    test_pack_LPGRADIENT_RECT();
    test_pack_LPGRADIENT_TRIANGLE();
    test_pack_LPHANDLETABLE();
    test_pack_LPKERNINGPAIR();
    test_pack_LPLAYERPLANEDESCRIPTOR();
    test_pack_LPLOCALESIGNATURE();
    test_pack_LPLOGBRUSH();
    test_pack_LPLOGCOLORSPACEA();
    test_pack_LPLOGCOLORSPACEW();
    test_pack_LPLOGFONTA();
    test_pack_LPLOGFONTW();
    test_pack_LPLOGPEN();
    test_pack_LPMAT2();
    test_pack_LPMETAFILEPICT();
    test_pack_LPMETAHEADER();
    test_pack_LPMETARECORD();
    test_pack_LPNEWTEXTMETRICA();
    test_pack_LPNEWTEXTMETRICW();
    test_pack_LPOUTLINETEXTMETRICA();
    test_pack_LPOUTLINETEXTMETRICW();
    test_pack_LPPANOSE();
    test_pack_LPPELARRAY();
    test_pack_LPPIXELFORMATDESCRIPTOR();
    test_pack_LPPOINTFX();
    test_pack_LPPOLYTEXTA();
    test_pack_LPPOLYTEXTW();
    test_pack_LPRASTERIZER_STATUS();
    test_pack_LPRGBQUAD();
    test_pack_LPRGNDATA();
    test_pack_LPTEXTMETRICA();
    test_pack_LPTEXTMETRICW();
    test_pack_LPTRIVERTEX();
    test_pack_LPTTPOLYCURVE();
    test_pack_LPTTPOLYGONHEADER();
    test_pack_LPXFORM();
    test_pack_MAT2();
    test_pack_METAFILEPICT();
    test_pack_METAHEADER();
    test_pack_METARECORD();
    test_pack_MFENUMPROC();
    test_pack_NEWTEXTMETRICA();
    test_pack_NEWTEXTMETRICEXA();
    test_pack_NEWTEXTMETRICEXW();
    test_pack_NEWTEXTMETRICW();
    test_pack_NPEXTLOGPEN();
    test_pack_OLDFONTENUMPROC();
    test_pack_OLDFONTENUMPROCA();
    test_pack_OLDFONTENUMPROCW();
    test_pack_OUTLINETEXTMETRICA();
    test_pack_OUTLINETEXTMETRICW();
    test_pack_PABC();
    test_pack_PABCFLOAT();
    test_pack_PANOSE();
    test_pack_PATTERN();
    test_pack_PBITMAP();
    test_pack_PBITMAPCOREHEADER();
    test_pack_PBITMAPCOREINFO();
    test_pack_PBITMAPFILEHEADER();
    test_pack_PBITMAPINFO();
    test_pack_PBITMAPINFOHEADER();
    test_pack_PBITMAPV4HEADER();
    test_pack_PBITMAPV5HEADER();
    test_pack_PBLENDFUNCTION();
    test_pack_PCHARSETINFO();
    test_pack_PCOLORADJUSTMENT();
    test_pack_PDEVMODEA();
    test_pack_PDEVMODEW();
    test_pack_PDIBSECTION();
    test_pack_PDISPLAY_DEVICEA();
    test_pack_PDISPLAY_DEVICEW();
    test_pack_PELARRAY();
    test_pack_PEMR();
    test_pack_PEMRABORTPATH();
    test_pack_PEMRANGLEARC();
    test_pack_PEMRARC();
    test_pack_PEMRARCTO();
    test_pack_PEMRBEGINPATH();
    test_pack_PEMRBITBLT();
    test_pack_PEMRCHORD();
    test_pack_PEMRCLOSEFIGURE();
    test_pack_PEMRCREATEBRUSHINDIRECT();
    test_pack_PEMRCREATECOLORSPACE();
    test_pack_PEMRCREATECOLORSPACEW();
    test_pack_PEMRCREATEDIBPATTERNBRUSHPT();
    test_pack_PEMRCREATEMONOBRUSH();
    test_pack_PEMRCREATEPALETTE();
    test_pack_PEMRCREATEPEN();
    test_pack_PEMRDELETECOLORSPACE();
    test_pack_PEMRDELETEOBJECT();
    test_pack_PEMRELLIPSE();
    test_pack_PEMRENDPATH();
    test_pack_PEMREOF();
    test_pack_PEMREXCLUDECLIPRECT();
    test_pack_PEMREXTCREATEFONTINDIRECTW();
    test_pack_PEMREXTCREATEPEN();
    test_pack_PEMREXTFLOODFILL();
    test_pack_PEMREXTSELECTCLIPRGN();
    test_pack_PEMREXTTEXTOUTA();
    test_pack_PEMREXTTEXTOUTW();
    test_pack_PEMRFILLPATH();
    test_pack_PEMRFILLRGN();
    test_pack_PEMRFLATTENPATH();
    test_pack_PEMRFORMAT();
    test_pack_PEMRFRAMERGN();
    test_pack_PEMRGDICOMMENT();
    test_pack_PEMRGLSBOUNDEDRECORD();
    test_pack_PEMRGLSRECORD();
    test_pack_PEMRINTERSECTCLIPRECT();
    test_pack_PEMRINVERTRGN();
    test_pack_PEMRLINETO();
    test_pack_PEMRMASKBLT();
    test_pack_PEMRMODIFYWORLDTRANSFORM();
    test_pack_PEMRMOVETOEX();
    test_pack_PEMROFFSETCLIPRGN();
    test_pack_PEMRPAINTRGN();
    test_pack_PEMRPIE();
    test_pack_PEMRPIXELFORMAT();
    test_pack_PEMRPLGBLT();
    test_pack_PEMRPOLYBEZIER();
    test_pack_PEMRPOLYBEZIER16();
    test_pack_PEMRPOLYBEZIERTO();
    test_pack_PEMRPOLYBEZIERTO16();
    test_pack_PEMRPOLYDRAW();
    test_pack_PEMRPOLYDRAW16();
    test_pack_PEMRPOLYGON();
    test_pack_PEMRPOLYGON16();
    test_pack_PEMRPOLYLINE();
    test_pack_PEMRPOLYLINE16();
    test_pack_PEMRPOLYLINETO();
    test_pack_PEMRPOLYLINETO16();
    test_pack_PEMRPOLYPOLYGON();
    test_pack_PEMRPOLYPOLYGON16();
    test_pack_PEMRPOLYPOLYLINE();
    test_pack_PEMRPOLYPOLYLINE16();
    test_pack_PEMRPOLYTEXTOUTA();
    test_pack_PEMRPOLYTEXTOUTW();
    test_pack_PEMRREALIZEPALETTE();
    test_pack_PEMRRECTANGLE();
    test_pack_PEMRRESIZEPALETTE();
    test_pack_PEMRRESTOREDC();
    test_pack_PEMRROUNDRECT();
    test_pack_PEMRSAVEDC();
    test_pack_PEMRSCALEVIEWPORTEXTEX();
    test_pack_PEMRSCALEWINDOWEXTEX();
    test_pack_PEMRSELECTCLIPPATH();
    test_pack_PEMRSELECTCOLORSPACE();
    test_pack_PEMRSELECTOBJECT();
    test_pack_PEMRSELECTPALETTE();
    test_pack_PEMRSETARCDIRECTION();
    test_pack_PEMRSETBKCOLOR();
    test_pack_PEMRSETBKMODE();
    test_pack_PEMRSETBRUSHORGEX();
    test_pack_PEMRSETCOLORADJUSTMENT();
    test_pack_PEMRSETCOLORSPACE();
    test_pack_PEMRSETDIBITSTODEVICE();
    test_pack_PEMRSETICMMODE();
    test_pack_PEMRSETLAYOUT();
    test_pack_PEMRSETMAPMODE();
    test_pack_PEMRSETMAPPERFLAGS();
    test_pack_PEMRSETMETARGN();
    test_pack_PEMRSETMITERLIMIT();
    test_pack_PEMRSETPALETTEENTRIES();
    test_pack_PEMRSETPIXELV();
    test_pack_PEMRSETPOLYFILLMODE();
    test_pack_PEMRSETROP2();
    test_pack_PEMRSETSTRETCHBLTMODE();
    test_pack_PEMRSETTEXTALIGN();
    test_pack_PEMRSETTEXTCOLOR();
    test_pack_PEMRSETVIEWPORTEXTEX();
    test_pack_PEMRSETVIEWPORTORGEX();
    test_pack_PEMRSETWINDOWEXTEX();
    test_pack_PEMRSETWINDOWORGEX();
    test_pack_PEMRSETWORLDTRANSFORM();
    test_pack_PEMRSTRETCHBLT();
    test_pack_PEMRSTRETCHDIBITS();
    test_pack_PEMRSTROKEANDFILLPATH();
    test_pack_PEMRSTROKEPATH();
    test_pack_PEMRTEXT();
    test_pack_PEMRWIDENPATH();
    test_pack_PENHMETAHEADER();
    test_pack_PEXTLOGFONTA();
    test_pack_PEXTLOGFONTW();
    test_pack_PEXTLOGPEN();
    test_pack_PFONTSIGNATURE();
    test_pack_PGLYPHMETRICSFLOAT();
    test_pack_PGRADIENT_RECT();
    test_pack_PGRADIENT_TRIANGLE();
    test_pack_PHANDLETABLE();
    test_pack_PIXELFORMATDESCRIPTOR();
    test_pack_PLAYERPLANEDESCRIPTOR();
    test_pack_PLOCALESIGNATURE();
    test_pack_PLOGBRUSH();
    test_pack_PLOGFONTA();
    test_pack_PLOGFONTW();
    test_pack_PMETAHEADER();
    test_pack_PMETARECORD();
    test_pack_PNEWTEXTMETRICA();
    test_pack_PNEWTEXTMETRICW();
    test_pack_POINTFLOAT();
    test_pack_POINTFX();
    test_pack_POLYTEXTA();
    test_pack_POLYTEXTW();
    test_pack_POUTLINETEXTMETRICA();
    test_pack_POUTLINETEXTMETRICW();
    test_pack_PPELARRAY();
    test_pack_PPIXELFORMATDESCRIPTOR();
    test_pack_PPOINTFLOAT();
    test_pack_PPOLYTEXTA();
    test_pack_PPOLYTEXTW();
    test_pack_PRGNDATA();
    test_pack_PRGNDATAHEADER();
    test_pack_PTEXTMETRICA();
    test_pack_PTEXTMETRICW();
    test_pack_PTRIVERTEX();
    test_pack_PXFORM();
    test_pack_RASTERIZER_STATUS();
    test_pack_RGBQUAD();
    test_pack_RGBTRIPLE();
    test_pack_RGNDATA();
    test_pack_RGNDATAHEADER();
    test_pack_TEXTMETRICA();
    test_pack_TEXTMETRICW();
    test_pack_TRIVERTEX();
    test_pack_TTPOLYCURVE();
    test_pack_TTPOLYGONHEADER();
    test_pack_XFORM();
}

START_TEST(generated)
{
#ifdef _WIN64
    ok(0, "The type size / alignment tests don't support Win64 yet\n");
#else
    test_pack();
#endif
}
