/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.util.Logger;

abstract class QuantumCalculation {
    protected boolean doDebug = false;
    protected static final float bohr_per_angstrom = 1.8897161f;
    protected float[][][] voxelData;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;
    protected QMAtom[] qmAtoms;
    protected int atomIndex;
    protected QMAtom thisAtom;
    protected float[] xBohr;
    protected float[] yBohr;
    protected float[] zBohr;
    protected float[] originBohr = new float[3];
    protected float[] stepBohr = new float[3];
    protected int nX;
    protected int nY;
    protected int nZ;
    protected float[] X;
    protected float[] Y;
    protected float[] Z;
    protected float[] X2;
    protected float[] Y2;
    protected float[] Z2;
    protected float rangeBohr = 10.0f;
    protected float volume = 1.0f;

    QuantumCalculation() {
    }

    protected void initialize(int n, int n2, int n3) {
        this.nX = n;
        this.nY = n2;
        this.nZ = n3;
        this.xBohr = new float[n];
        this.yBohr = new float[n2];
        this.zBohr = new float[n3];
        this.X = new float[n];
        this.Y = new float[n2];
        this.Z = new float[n3];
        this.X2 = new float[n];
        this.Y2 = new float[n2];
        this.Z2 = new float[n3];
    }

    protected void setupCoordinates(float[] fArray, float[] fArray2, BitSet bitSet, Point3f[] point3fArray) {
        int n;
        int n2 = 3;
        while (--n2 >= 0) {
            this.originBohr[n2] = fArray[n2] * 1.8897161f;
            this.stepBohr[n2] = fArray2[n2] * 1.8897161f;
            this.volume *= this.stepBohr[n2];
        }
        this.setXYZBohr(this.xBohr, 0, this.nX);
        this.setXYZBohr(this.yBohr, 1, this.nY);
        this.setXYZBohr(this.zBohr, 2, this.nZ);
        this.qmAtoms = new QMAtom[point3fArray.length];
        n2 = bitSet == null ? 1 : 0;
        int n3 = n = n2 != 0 ? this.qmAtoms.length - 1 : bitSet.nextSetBit(0);
        while (n3 >= 0) {
            this.qmAtoms[n3] = new QMAtom(point3fArray[n3], this.X, this.Y, this.Z, this.X2, this.Y2, this.Z2);
            n3 = n2 != 0 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        if (this.doDebug) {
            Logger.debug("QuantumCalculation:\n origin(Bohr)= " + this.originBohr[0] + " " + this.originBohr[1] + " " + this.originBohr[2] + "\n steps(Bohr)= " + this.stepBohr[0] + " " + this.stepBohr[1] + " " + this.stepBohr[2] + "\n counts= " + this.nX + " " + this.nY + " " + this.nZ);
        }
    }

    private void setXYZBohr(float[] fArray, int n, int n2) {
        fArray[0] = this.originBohr[n];
        float f = this.stepBohr[n];
        int n3 = 0;
        while (++n3 < n2) {
            fArray[n3] = fArray[n3 - 1] + f;
        }
    }

    class QMAtom
    extends Point3f {
        private float[] myX;
        private float[] myY;
        private float[] myZ;
        private float[] myX2;
        private float[] myY2;
        private float[] myZ2;

        QMAtom(Point3f point3f, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6) {
            this.myX = fArray;
            this.myY = fArray2;
            this.myZ = fArray3;
            this.myX2 = fArray4;
            this.myY2 = fArray5;
            this.myZ2 = fArray6;
            this.set(point3f);
            this.scale(1.8897161f);
        }

        protected void setXYZ(boolean bl) {
            try {
                int n;
                if (bl) {
                    n = (int)Math.floor((this.x - QuantumCalculation.this.xBohr[0] - QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[0]);
                    QuantumCalculation.this.xMin = n < 0 ? 0 : n;
                    n = (int)Math.floor(1.0f + (this.x - QuantumCalculation.this.xBohr[0] + QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[0]);
                    QuantumCalculation.this.xMax = n >= QuantumCalculation.this.nX ? QuantumCalculation.this.nX : n + 1;
                    n = (int)Math.floor((this.y - QuantumCalculation.this.yBohr[0] - QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[1]);
                    QuantumCalculation.this.yMin = n < 0 ? 0 : n;
                    n = (int)Math.floor(1.0f + (this.y - QuantumCalculation.this.yBohr[0] + QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[1]);
                    QuantumCalculation.this.yMax = n >= QuantumCalculation.this.nY ? QuantumCalculation.this.nY : n + 1;
                    n = (int)Math.floor((this.z - QuantumCalculation.this.zBohr[0] - QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[2]);
                    QuantumCalculation.this.zMin = n < 0 ? 0 : n;
                    n = (int)Math.floor(1.0f + (this.z - QuantumCalculation.this.zBohr[0] + QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[2]);
                    QuantumCalculation.this.zMax = n >= QuantumCalculation.this.nZ ? QuantumCalculation.this.nZ : n + 1;
                }
                n = QuantumCalculation.this.xMax;
                while (--n >= QuantumCalculation.this.xMin) {
                    this.myX2[n] = this.myX[n] = QuantumCalculation.this.xBohr[n] - this.x;
                    int n2 = n;
                    this.myX2[n2] = this.myX2[n2] * this.myX[n];
                }
                n = QuantumCalculation.this.yMax;
                while (--n >= QuantumCalculation.this.yMin) {
                    this.myY2[n] = this.myY[n] = QuantumCalculation.this.yBohr[n] - this.y;
                    int n3 = n;
                    this.myY2[n3] = this.myY2[n3] * this.myY[n];
                }
                n = QuantumCalculation.this.zMax;
                while (--n >= QuantumCalculation.this.zMin) {
                    this.myZ2[n] = this.myZ[n] = QuantumCalculation.this.zBohr[n] - this.z;
                    int n4 = n;
                    this.myZ2[n4] = this.myZ2[n4] * this.myZ[n];
                }
            }
            catch (Exception exception) {
                Logger.error("Error in QuantumCalculation setting bounds");
            }
        }
    }
}

