/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.Molecule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MoleculeStream {
    public static Molecule ReadUnknown(InputStream istr) throws IOException {
        return MoleculeStream.ReadUnknown(new BufferedReader(new InputStreamReader(istr)));
    }

    public static Molecule ReadUnknown(BufferedReader in) throws IOException {
        Molecule mdlmol = null;
        Molecule elmol = null;
        int BUFFMAX = 100000;
        in.mark(100000);
        try {
            mdlmol = MoleculeStream.ReadMDLMOL(in);
            if (mdlmol != null) {
                in.mark(100000);
            }
        }
        catch (IOException e) {
            mdlmol = null;
            in.reset();
        }
        try {
            elmol = MoleculeStream.ReadNative(in);
        }
        catch (IOException e) {
            elmol = null;
        }
        if (elmol != null) {
            return elmol;
        }
        if (mdlmol != null) {
            return mdlmol;
        }
        throw new IOException("Unknown or invalid format.");
    }

    public static Molecule ReadNative(InputStream istr) throws IOException {
        return MoleculeStream.ReadNative(new BufferedReader(new InputStreamReader(istr)));
    }

    public static Molecule ReadNative(BufferedReader in) throws IOException {
        Molecule mol = new Molecule();
        String GENERIC_ERROR = "Invalid WIMSchem file.";
        try {
            String[] bits;
            int n;
            String line = in.readLine();
            if (!line.startsWith("WIMSchem!")) {
                throw new IOException("Not a WIMSchem file.");
            }
            int p1 = line.indexOf(40);
            int p2 = line.indexOf(44);
            int p3 = line.indexOf(41);
            if (p1 == 0 || p2 == 0 || p3 == 0) {
                throw new IOException("Invalid WIMSchem file.");
            }
            int numAtoms = Integer.parseInt(line.substring(p1 + 1, p2).trim());
            int numBonds = Integer.parseInt(line.substring(p2 + 1, p3).trim());
            for (n = 0; n < numAtoms; ++n) {
                line = in.readLine();
                bits = line.split("[\\=\\,\\;]");
                if (bits.length < 5) {
                    throw new IOException("Invalid WIMSchem file.");
                }
                int num = mol.AddAtom(bits[0], Double.parseDouble(bits[1].trim()), Double.parseDouble(bits[2].trim()), Integer.parseInt(bits[3].trim()), Integer.parseInt(bits[4].trim()));
                for (int i = 5; i < bits.length; ++i) {
                    if (bits[i].length() <= 0) continue;
                    if (bits[i].charAt(0) == 'e') {
                        mol.SetAtomHExplicit(num, Integer.parseInt(bits[i].substring(1)));
                        continue;
                    }
                    if (bits[i].charAt(0) != 'n') continue;
                    mol.SetAtomMapNum(num, Integer.parseInt(bits[i].substring(1)));
                }
            }
            for (n = 0; n < numBonds; ++n) {
                line = in.readLine();
                bits = line.split("[\\-\\=\\,]");
                if (bits.length < 4) {
                    throw new IOException("Invalid WIMSchem file.");
                }
                mol.AddBond(Integer.parseInt(bits[0].trim()), Integer.parseInt(bits[1].trim()), Integer.parseInt(bits[2].trim()), Integer.parseInt(bits[3].trim()));
            }
            line = in.readLine();
            if (line.compareTo("!FIN") != 0) {
                throw new IOException("Invalid WIMSchem file.");
            }
        }
        catch (Exception e) {
            throw new IOException("Invalid WIMSchem file.");
        }
        return mol;
    }

    public static void WriteNative(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.WriteNative(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void WriteNative(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        out.write("WIMSchem!(" + mol.NumAtoms() + "," + mol.NumBonds() + ")\n");
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            String hy = mol.AtomHExplicit(n) != -1 ? "e" + mol.AtomHExplicit(n) : "i" + mol.AtomHydrogens(n);
            out.write(mol.AtomElement(n) + "=" + fmt.format(mol.AtomX(n)) + "," + fmt.format(mol.AtomY(n)) + ";" + mol.AtomCharge(n) + "," + mol.AtomUnpaired(n) + "," + hy);
            if (mol.AtomMapNum(n) > 0) {
                out.write(",n" + mol.AtomMapNum(n));
            }
            out.write("\n");
        }
        for (n = 1; n <= mol.NumBonds(); ++n) {
            out.write(mol.BondFrom(n) + "-" + mol.BondTo(n) + "=" + mol.BondOrder(n) + "," + mol.BondType(n) + "\n");
        }
        out.write("!FIN\n");
        out.flush();
    }

    public static void WriteNative2JavaScript(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.WriteNative2JavaScript(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void WriteNative2JavaScript(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        out.write("\"WIMSchem!(" + mol.NumAtoms() + "," + mol.NumBonds() + ")\\n\"+");
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            String hy = mol.AtomHExplicit(n) != -1 ? "e" + mol.AtomHExplicit(n) : "i" + mol.AtomHydrogens(n);
            out.write("\"" + mol.AtomElement(n) + "=" + fmt.format(mol.AtomX(n)) + "," + fmt.format(mol.AtomY(n)) + ";" + mol.AtomCharge(n) + "," + mol.AtomUnpaired(n) + "," + hy);
            if (mol.AtomMapNum(n) > 0) {
                out.write(",n" + mol.AtomMapNum(n));
            }
            out.write("\\n\"+");
        }
        for (n = 1; n <= mol.NumBonds(); ++n) {
            out.write("\"" + mol.BondFrom(n) + "-" + mol.BondTo(n) + "=" + mol.BondOrder(n) + "," + mol.BondType(n) + "\\n\"+");
        }
        out.write("\"!FIN\"");
        out.flush();
    }

    public static void WriteMDLMol2JavaScript(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.WriteMDLMol2JavaScript(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void WriteMDLMol2JavaScript(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        String line;
        int n2;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        out.write("\"\\nWIMSchem molfile\\n\\n\"+");
        out.write("\"" + MoleculeStream.intrpad(mol.NumAtoms(), 3) + MoleculeStream.intrpad(mol.NumBonds(), 3) + "  0  0  0  0  0  0  0  0999 V2000\\n\"+");
        for (n2 = 1; n2 <= mol.NumAtoms(); ++n2) {
            String str = "\"   " + fmt.format(mol.AtomX(n2));
            line = MoleculeStream.rep(" ", 10 - str.length()) + str;
            str = fmt.format(mol.AtomY(n2));
            line = line + MoleculeStream.rep(" ", 10 - str.length()) + str;
            line = line + "    0.0000 ";
            str = mol.AtomElement(n2);
            line = line + str + MoleculeStream.rep(" ", 4 - str.length()) + "0";
            int chg = mol.AtomCharge(n2);
            int spin = mol.AtomUnpaired(n2);
            int mapnum = mol.AtomMapNum(n2);
            if (chg >= -3 && chg <= -1) {
                chg = 4 - chg;
            } else if (chg == 0 && spin == 2) {
                chg = 4;
            } else if (chg < 1 || chg > 3) {
                chg = 0;
            }
            line = line + MoleculeStream.intrpad(chg, 3) + "  0  0  0  0  0  0  0" + MoleculeStream.intrpad(mapnum, 3) + "  0  0";
            out.write(line + "\\n\"+");
        }
        for (n2 = 1; n2 <= mol.NumBonds(); ++n2) {
            int stereo;
            int type = mol.BondOrder(n2);
            if (type < 1 || type > 3) {
                type = 1;
            }
            if ((stereo = mol.BondType(n2)) != 0) {
                if (stereo == 1) {
                    stereo = 1;
                    type = 1;
                } else if (stereo == 2) {
                    stereo = 6;
                    type = 1;
                } else if (stereo == 3) {
                    stereo = 4;
                    type = 1;
                } else {
                    stereo = 0;
                }
            }
            out.write("\"" + MoleculeStream.intrpad(mol.BondFrom(n2), 3) + MoleculeStream.intrpad(mol.BondTo(n2), 3) + MoleculeStream.intrpad(type, 3) + MoleculeStream.intrpad(stereo, 3) + "  0  0  0\\n\"+");
        }
        int count = 0;
        line = "";
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            if (mol.AtomCharge(n) == 0) continue;
            line = line + MoleculeStream.intrpad(n, 4) + MoleculeStream.intrpad(mol.AtomCharge(n), 4);
            if (++count != 8) continue;
            out.write("\"M  CHG" + MoleculeStream.intrpad(count, 3) + line + "\\n\"+");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("\"M  CHG" + MoleculeStream.intrpad(count, 3) + line + "\\n\"+");
        }
        count = 0;
        line = "";
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            if (mol.AtomUnpaired(n) == 0) continue;
            line = line + MoleculeStream.intrpad(n, 4) + MoleculeStream.intrpad(mol.AtomUnpaired(n), 4);
            if (++count != 8) continue;
            out.write("\"M  RAD" + MoleculeStream.intrpad(count, 3) + line + "\\n\"+");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("\"M  RAD" + MoleculeStream.intrpad(count, 3) + line + "\\n\"");
        }
        out.write("\"M  END\\n\"");
        out.flush();
    }

    public static String Molecule2String(Molecule mol) throws IOException {
        int n;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        String i = "WIMSchem!(" + mol.NumAtoms() + "," + mol.NumBonds() + ")\n";
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            String hy = mol.AtomHExplicit(n) != -1 ? "e" + mol.AtomHExplicit(n) : "i" + mol.AtomHydrogens(n);
            i = i + mol.AtomElement(n) + "=" + fmt.format(mol.AtomX(n)) + "," + fmt.format(mol.AtomY(n)) + ";" + mol.AtomCharge(n) + "," + mol.AtomUnpaired(n) + "," + hy;
            if (mol.AtomMapNum(n) > 0) {
                i = i + ",n" + mol.AtomMapNum(n);
            }
            i = i + "\n";
        }
        for (n = 1; n <= mol.NumBonds(); ++n) {
            i = i + mol.BondFrom(n) + "-" + mol.BondTo(n) + "=" + mol.BondOrder(n) + "," + mol.BondType(n) + "\n";
        }
        i = i + "!FIN\n";
        return i;
    }

    public static Molecule ReadMDLMOL(BufferedReader in) throws IOException {
        Molecule mol = new Molecule();
        String GENERIC_ERROR = "Invalid MDL MOL file.";
        try {
            int n;
            String line = null;
            for (int n2 = 0; n2 < 4; ++n2) {
                line = in.readLine();
            }
            if (!line.substring(34, 39).equals("V2000")) {
                throw new IOException("Invalid MDL MOL file.");
            }
            int numAtoms = Integer.parseInt(line.substring(0, 3).trim());
            int numBonds = Integer.parseInt(line.substring(3, 6).trim());
            for (n = 0; n < numAtoms; ++n) {
                line = in.readLine();
                double x = Double.parseDouble(line.substring(0, 10).trim());
                double y = Double.parseDouble(line.substring(10, 20).trim());
                String el = line.substring(31, 34).trim();
                int chg = Integer.parseInt(line.substring(36, 39).trim());
                int rad = 0;
                int mapnum = Integer.parseInt(line.substring(60, 63).trim());
                if (chg > 3) {
                    if (chg == 4) {
                        chg = 0;
                        rad = 2;
                    } else {
                        chg = 4 - chg;
                    }
                }
                mol.AddAtom(el, x, y, chg, rad);
                mol.SetAtomMapNum(mol.NumAtoms(), mapnum);
            }
            for (n = 0; n < numBonds; ++n) {
                line = in.readLine();
                int from = Integer.parseInt(line.substring(0, 3).trim());
                int to = Integer.parseInt(line.substring(3, 6).trim());
                int type = Integer.parseInt(line.substring(6, 9).trim());
                int stereo = Integer.parseInt(line.substring(9, 12).trim());
                if (from == to || from < 1 || from > numAtoms || to < 1 || to > numAtoms) {
                    throw new IOException("Invalid MDL MOL file.");
                }
                int order = type >= 1 && type <= 3 ? type : 1;
                int style = 0;
                if (stereo == 1) {
                    style = 1;
                } else if (stereo == 6) {
                    style = 2;
                }
                mol.AddBond(from, to, order, style);
            }
            while (!(line = in.readLine()).startsWith("M  END")) {
                int type = 0;
                if (line.startsWith("M  CHG")) {
                    type = 1;
                } else if (line.startsWith("M  RAD")) {
                    type = 2;
                }
                if (type <= 0) continue;
                int len = Integer.parseInt(line.substring(6, 9).trim());
                for (int n3 = 0; n3 < len; ++n3) {
                    int apos = Integer.parseInt(line.substring(9 + 8 * n3, 13 + 8 * n3).trim());
                    int aval = Integer.parseInt(line.substring(13 + 8 * n3, 17 + 8 * n3).trim());
                    if (type == 1) {
                        mol.SetAtomCharge(apos, aval);
                        continue;
                    }
                    mol.SetAtomUnpaired(apos, aval);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Invalid MDL MOL file.hier");
        }
        return mol;
    }

    public static void WriteMDLMOL(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.WriteMDLMOL(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void WriteMDLMOL(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        String line;
        int n2;
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        out.write("\nWIMSchem molfile\n\n");
        out.write(MoleculeStream.intrpad(mol.NumAtoms(), 3) + MoleculeStream.intrpad(mol.NumBonds(), 3) + "  0  0  0  0  0  0  0  0999 V2000\n");
        for (n2 = 1; n2 <= mol.NumAtoms(); ++n2) {
            String str = fmt.format(mol.AtomX(n2));
            line = MoleculeStream.rep(" ", 10 - str.length()) + str;
            str = fmt.format(mol.AtomY(n2));
            line = line + MoleculeStream.rep(" ", 10 - str.length()) + str;
            line = line + "    0.0000 ";
            str = mol.AtomElement(n2);
            line = line + str + MoleculeStream.rep(" ", 4 - str.length()) + "0";
            int chg = mol.AtomCharge(n2);
            int spin = mol.AtomUnpaired(n2);
            int mapnum = mol.AtomMapNum(n2);
            if (chg >= -3 && chg <= -1) {
                chg = 4 - chg;
            } else if (chg == 0 && spin == 2) {
                chg = 4;
            } else if (chg < 1 || chg > 3) {
                chg = 0;
            }
            line = line + MoleculeStream.intrpad(chg, 3) + "  0  0  0  0  0  0  0" + MoleculeStream.intrpad(mapnum, 3) + "  0  0";
            out.write(line + "\n");
        }
        for (n2 = 1; n2 <= mol.NumBonds(); ++n2) {
            int stereo;
            int type = mol.BondOrder(n2);
            if (type < 1 || type > 3) {
                type = 1;
            }
            if ((stereo = mol.BondType(n2)) != 0) {
                if (stereo == 1) {
                    stereo = 1;
                    type = 1;
                } else if (stereo == 2) {
                    stereo = 6;
                    type = 1;
                } else if (stereo == 3) {
                    stereo = 4;
                    type = 1;
                } else {
                    stereo = 0;
                }
            }
            out.write(MoleculeStream.intrpad(mol.BondFrom(n2), 3) + MoleculeStream.intrpad(mol.BondTo(n2), 3) + MoleculeStream.intrpad(type, 3) + MoleculeStream.intrpad(stereo, 3) + "  0  0  0\n");
        }
        int count = 0;
        line = "";
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            if (mol.AtomCharge(n) == 0) continue;
            line = line + MoleculeStream.intrpad(n, 4) + MoleculeStream.intrpad(mol.AtomCharge(n), 4);
            if (++count != 8) continue;
            out.write("M  CHG" + MoleculeStream.intrpad(count, 3) + line + "\n");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("M  CHG" + MoleculeStream.intrpad(count, 3) + line + "\n");
        }
        count = 0;
        line = "";
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            if (mol.AtomUnpaired(n) == 0) continue;
            line = line + MoleculeStream.intrpad(n, 4) + MoleculeStream.intrpad(mol.AtomUnpaired(n), 4);
            if (++count != 8) continue;
            out.write("M  RAD" + MoleculeStream.intrpad(count, 3) + line + "\n");
            count = 0;
            line = "";
        }
        if (count > 0) {
            out.write("M  RAD" + MoleculeStream.intrpad(count, 3) + line + "\n");
        }
        out.write("M  END\n");
        out.flush();
    }

    public static void WriteCMLXML(OutputStream ostr, Molecule mol) throws IOException {
        MoleculeStream.WriteCMLXML(new BufferedWriter(new OutputStreamWriter(ostr)), mol);
    }

    public static void WriteCMLXML(BufferedWriter out, Molecule mol) throws IOException {
        int n;
        out.write("<cml>\n");
        out.write("  <molecule>\n");
        out.write("    <atomArray>\n");
        for (n = 1; n <= mol.NumAtoms(); ++n) {
            out.write("      <atom id=\"a" + n + "\" elementType=\"" + mol.AtomElement(n) + "\"" + " x2=\"" + mol.AtomX(n) + "\" y2=\"" + mol.AtomY(n) + "\" hydrogenCount=\"" + mol.AtomHydrogens(n) + "\"/>\n");
        }
        out.write("    </atomArray>\n");
        out.write("    <bondArray>\n");
        for (n = 1; n <= mol.NumBonds(); ++n) {
            out.write("      <bond id=\"b" + n + "\" atomRefs2=\"a" + mol.BondFrom(n) + " a" + mol.BondTo(n) + "\" order=\"" + mol.BondOrder(n) + "\"/>\n");
        }
        out.write("    </bondArray>\n");
        out.write("  </molecule>\n");
        out.write("</cml>\n");
        out.flush();
    }

    static boolean ExamineIsDatabase(FileInputStream istr) throws IOException {
        long lastpos = istr.getChannel().position();
        boolean isdb = MoleculeStream.FindNextPosition(istr, 0L) >= 0L;
        istr.getChannel().position(lastpos);
        return isdb;
    }

    static long FindNextPosition(FileInputStream istr, long startpos) throws IOException {
        FileChannel fch = istr.getChannel();
        fch.position(startpos);
        long pos = startpos;
        long size = fch.size();
        long nextpos = -1L;
        String rec = "";
        while (nextpos < size) {
            int inp = istr.read();
            ++pos;
            if (inp < 0) break;
            char ch = (char)inp;
            if (ch == '\r' || !(rec = rec.concat(String.valueOf(ch))).endsWith("$$$$\n")) continue;
            nextpos = pos;
            break;
        }
        if (nextpos < 0L) {
            return -1L;
        }
        try {
            BufferedReader in = new BufferedReader(new StringReader(rec));
            Molecule mol = MoleculeStream.ReadMDLMOL(in);
            if (mol == null) {
                nextpos = -1L;
            }
        }
        catch (IOException e) {
            nextpos = -1L;
        }
        return nextpos;
    }

    static Molecule FetchFromPosition(FileInputStream istr, long pos) throws IOException {
        istr.getChannel().position(pos);
        return MoleculeStream.ReadMDLMOL(new BufferedReader(new InputStreamReader(istr)));
    }

    static String intrpad(int Val, int Len) {
        String str = Integer.toString(Val);
        if ((str = MoleculeStream.rep(" ", Len - str.length()) + str).length() > Len) {
            str = str.substring(0, Len);
        }
        return str;
    }

    static String rep(String Ch, int Len) {
        if (Len <= 0) {
            return "";
        }
        String str = Ch;
        while (str.length() < Len) {
            str = str + Ch;
        }
        return str;
    }

    public static String GetSmiles(Molecule mol) {
        int p = 0;
        int H1 = 0;
        int H2 = 0;
        int C1 = 0;
        int C2 = 0;
        String c1 = "";
        String c2 = "";
        String smile = "";
        int M = mol.NumBonds();
        int N = mol.NumAtoms();
        try {
            if (N == 1) {
                H1 = mol.AtomHExplicit(1) != -1 ? mol.AtomHExplicit(1) : mol.AtomHydrogens(1);
                C1 = mol.AtomCharge(1);
                c1 = C1 != 0 ? (C1 > 0 ? (C1 == 1 ? "<sup><small><b>+</b></small></sup>" : "<sup><small><b>" + C1 + "+</b></small></sup>") : ((C1 = -1 * C1) == 1 ? "<sup><small><b>-</b></small></sup>" : "<sup><small><b>" + C1 + "-</b></small></sup>")) : "";
                smile = H1 != 0 ? (H1 == 1 ? mol.AtomElement(1) + c1 + "H" : mol.AtomElement(1) + c1 + "H<sub><small>" + H1 + "</small></sub>") : mol.AtomElement(1) + c1;
            } else {
                int n;
                int[] From = new int[M + 1];
                int[] To = new int[M + 1];
                boolean[] Fdone = new boolean[N + 1];
                boolean[] Tdone = new boolean[N + 1];
                boolean test = true;
                for (n = 1; n <= M; ++n) {
                    From[n] = mol.BondFrom(n);
                    To[n] = mol.BondTo(n);
                }
                for (n = 0; n <= N; ++n) {
                    Fdone[n] = false;
                    Tdone[n] = false;
                }
                for (n = 1; n <= M; ++n) {
                    test = true;
                    int a = From[n];
                    int b = To[n];
                    p = 1;
                    H1 = mol.AtomHExplicit(a) != -1 ? mol.AtomHExplicit(a) : mol.AtomHydrogens(a);
                    H2 = mol.AtomHExplicit(b) != -1 ? mol.AtomHExplicit(b) : mol.AtomHydrogens(b);
                    C1 = mol.AtomCharge(a);
                    C2 = mol.AtomCharge(b);
                    c1 = C1 != 0 ? (C1 > 0 ? (C1 == 1 ? "<sup><small><b>+</b></small></sup>" : "<sup><small><b>" + C1 + "+</b></small></sup>") : ((C1 = -1 * C1) == 1 ? "<sup><small><b>-</b></small></sup>" : "<sup><small><b>" + C1 + "-</b></small></sup>")) : "";
                    c2 = C2 != 0 ? (C2 > 0 ? (C2 == 1 ? "<sup><small><b>+</b></small></sup>" : "<sup><small><b>" + C2 + "+</b></small></sup>") : ((C2 = -1 * C2) == 1 ? "<sup><small><b>-</b></small></sup>" : "<sup><small><b>" + C2 + "-</b></small></sup>")) : "";
                    while (test && p <= M) {
                        if (!Fdone[a] && !Tdone[a]) {
                            smile = H1 != 0 ? (H1 == 1 ? smile + "(" + mol.AtomElement(a) + c1 + "H)" + MoleculeStream.htmlbond(mol.BondOrder(a)) : smile + "(" + mol.AtomElement(a) + c1 + "H<sub><small>" + H1 + "</small></sub>)" + MoleculeStream.htmlbond(mol.BondOrder(a))) : smile + mol.AtomElement(a) + c1 + MoleculeStream.htmlbond(mol.BondOrder(a));
                            Fdone[a] = true;
                        }
                        if (!Tdone[b] && !Fdone[b]) {
                            smile = n < M ? (H2 != 0 ? (H2 == 1 ? smile + "(" + mol.AtomElement(b) + c2 + "H)" + MoleculeStream.htmlbond(mol.BondOrder(b)) : smile + "(" + mol.AtomElement(b) + c2 + "H<sub><small>" + H2 + "</small></sub>)" + MoleculeStream.htmlbond(mol.BondOrder(b))) : smile + mol.AtomElement(b) + c2 + MoleculeStream.htmlbond(mol.BondOrder(b))) : (H2 != 0 ? (H2 == 1 ? smile + "(" + mol.AtomElement(b) + c2 + "H)" : smile + "(" + mol.AtomElement(b) + c2 + "H<sub><small>" + H2 + "</small></sub>)") : smile + mol.AtomElement(b) + c2);
                            Tdone[b] = true;
                        }
                        if (Tdone[b] || Fdone[a]) {
                            test = false;
                        }
                        ++p;
                    }
                }
            }
            return smile;
        }
        catch (Exception e) {
            return "error \n Are You drawing more than 1 molecule ???";
        }
    }

    public static String htmlbond(int order) {
        String s = "&minus";
        if (order == 0) {
            s = "\u22ef";
        } else if (order == 1) {
            s = "&minus;";
        } else if (order == 2) {
            s = "=";
        } else if (order == 3) {
            s = "&equiv;";
        }
        return s;
    }
}

