/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.Drawable;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Panner
extends Drawable
implements MouseListener,
MouseMotionListener {
    private int modifiers;
    private Controller onUserAction;
    private Controller onFinishDrag;
    private boolean dragging;
    private int prevX;
    private int prevY;

    public Panner() {
        this(4);
    }

    public Panner(int n) {
        this.modifiers = n & 0xF;
    }

    public void setOnUserAction(Controller controller) {
        this.onUserAction = controller;
    }

    public Controller getOnUserAction() {
        return this.onUserAction;
    }

    public void setOnFinishDrag(Controller controller) {
        this.onFinishDrag = controller;
    }

    public Controller getOnFinishDrag() {
        return this.onFinishDrag;
    }

    protected void setOwnerData(DisplayCanvas displayCanvas, CoordinateRect coordinateRect) {
        if (displayCanvas != null) {
            displayCanvas.removeMouseListener(this);
            displayCanvas.removeMouseMotionListener(this);
        }
        super.setOwnerData(displayCanvas, coordinateRect);
        if (displayCanvas != null) {
            displayCanvas.addMouseListener(this);
            displayCanvas.addMouseMotionListener(this);
        }
    }

    public void draw(Graphics graphics, boolean bl) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragging = false;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!this.getVisible() || this.canvas == null || this.coords == null) {
            return;
        }
        if ((mouseEvent.getModifiers() & this.modifiers) != this.modifiers) {
            return;
        }
        this.prevX = mouseEvent.getX();
        this.prevY = mouseEvent.getY();
        if (this.prevX < this.coords.getLeft() || this.prevX >= this.coords.getLeft() + this.coords.getWidth() || this.prevY < this.coords.getTop() || this.prevY >= this.coords.getTop() + this.coords.getHeight()) {
            return;
        }
        mouseEvent.consume();
        this.dragging = true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        mouseEvent.consume();
        if (mouseEvent.getX() == this.prevX && mouseEvent.getY() == this.prevY) {
            return;
        }
        double[] dArray = this.coords.getLimits();
        if (dArray == null) {
            return;
        }
        double d = (double)(mouseEvent.getX() - this.prevX) * this.coords.getPixelWidth();
        double d2 = (double)(mouseEvent.getY() - this.prevY) * this.coords.getPixelHeight();
        this.coords.setLimits(dArray[0] - d, dArray[1] - d, dArray[2] + d2, dArray[3] + d2);
        this.needsRedraw();
        if (this.onUserAction != null) {
            this.onUserAction.compute();
        }
        this.prevX = mouseEvent.getX();
        this.prevY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        mouseEvent.consume();
        this.mouseDragged(mouseEvent);
        this.dragging = false;
        if (this.onFinishDrag != null) {
            this.onFinishDrag.compute();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

