/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim;

import fr.ove.openmath.jome.ctrlview.bidim.BidimDisplay;
import fr.ove.openmath.jome.ctrlview.bidim.Displayable;
import fr.ove.openmath.jome.ctrlview.bidim.GraphicContext;
import fr.ove.openmath.jome.ctrlview.bidim.SymbolLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class SymbolDisplay
extends BidimDisplay {
    private Displayable symbol;

    public SymbolDisplay(GraphicContext graphicContext, Displayable displayable) {
        this(graphicContext);
        this.symbol = displayable;
        displayable.setGraphicContext(graphicContext);
    }

    public SymbolDisplay(GraphicContext graphicContext) {
        super(graphicContext);
        SymbolLayout symbolLayout = new SymbolLayout();
        symbolLayout.initDisplay(this);
        this.setLayout(symbolLayout);
    }

    public void setSymbol(Displayable displayable) {
        this.symbol = displayable;
        displayable.setGraphicContext(this.getGraphicContext());
    }

    public Displayable getSymbol() {
        return this.symbol;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = graphics.getColor();
        Rectangle rectangle = this.getBounds();
        if (this.isSelected()) {
            graphics.setColor(this.getSelectionColor());
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setColor(this.getForegroundColor());
        if (this.weDrawBounds()) {
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
        this.symbol.paint(graphics);
        graphics.setColor(color);
    }

    public void scaleDisplay() {
        this.setTheFont(this.getGraphicContext().scaleFont(this.getLevel()));
        this.setComputeAttributes(true);
        this.invalidate();
        if (this.symbol != null) {
            this.symbol.setGraphicContext(this.getGraphicContext());
        }
    }

    public void setAttributes(int n, int n2, int n3, int n4) {
        super.setAttributes(n, n2, n3, n4);
        this.symbol.setAscent(n);
        this.symbol.setDescent(n2);
        this.symbol.setShiftX(n3);
        this.symbol.setShiftY(n4);
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        super.setGraphicContext(graphicContext);
        this.symbol.setGraphicContext(graphicContext);
    }
}

