/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.gdi.Arc;
import org.freehep.graphicsio.emf.gdi.ArcTo;
import org.freehep.graphicsio.emf.gdi.BeginPath;
import org.freehep.graphicsio.emf.gdi.Chord;
import org.freehep.graphicsio.emf.gdi.CloseFigure;
import org.freehep.graphicsio.emf.gdi.CreatePen;
import org.freehep.graphicsio.emf.gdi.Ellipse;
import org.freehep.graphicsio.emf.gdi.LineTo;
import org.freehep.graphicsio.emf.gdi.LogPen;
import org.freehep.graphicsio.emf.gdi.MoveToEx;
import org.freehep.graphicsio.emf.gdi.Pie;
import org.freehep.util.io.Tag;

public class EMFDisplay
extends JPanel {
    private EMFInputStream is;
    private Point currentPosition;
    private AffineTransform at;

    public EMFDisplay() {
        this.setBackground(Color.white);
    }

    public EMFDisplay(EMFInputStream eMFInputStream) {
        this.is = eMFInputStream;
        try {
            EMFHeader eMFHeader = eMFInputStream.readHeader();
            this.setSize(eMFHeader.getBounds().width, eMFHeader.getBounds().height);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setBackground(Color.white);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.at == null) {
            this.at = new AffineTransform();
            this.at.setToIdentity();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            EMFHeader eMFHeader = this.is.readHeader();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.concatenate(this.at);
            Rectangle rectangle = eMFHeader.getBounds();
            System.out.println("bounds " + rectangle);
            affineTransform.translate(50.0, 50.0);
            graphics2D.transform(this.at);
            graphics2D.drawLine(-100, 0, 100, 0);
            graphics2D.drawLine(0, -100, 0, 100);
            this.at = affineTransform;
            graphics2D.draw(rectangle);
            System.out.println("device " + eMFHeader.getDevice());
            Tag tag = this.is.readTag();
            while (tag != null) {
                System.out.println(tag);
                this.map(tag, graphics2D);
                tag = this.is.readTag();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void map(Tag tag, Graphics2D graphics2D) {
        if (tag instanceof Arc) {
            Arc arc = (Arc)tag;
            double d2 = arc.getStart().x / arc.getBounds().width;
            double d3 = arc.getEnd().x / arc.getBounds().width;
            double d4 = Math.acos(d2);
            double d5 = Math.acos(d3);
            Arc2D.Double double_ = new Arc2D.Double(arc.getStart().x, arc.getStart().y, arc.getBounds().width, arc.getBounds().height, d4, d5 - d4, 0);
            graphics2D.draw(double_);
        } else if (tag instanceof ArcTo) {
            ArcTo arcTo = (ArcTo)tag;
            double d6 = arcTo.getStart().x / arcTo.getBounds().width;
            double d7 = arcTo.getEnd().x / arcTo.getBounds().width;
            double d8 = Math.acos(d6);
            double d9 = Math.acos(d7);
            this.currentPosition = arcTo.getEnd();
            Arc2D.Double double_ = new Arc2D.Double(arcTo.getStart().x, arcTo.getStart().y, arcTo.getBounds().width, arcTo.getBounds().height, d8, d9 - d8, 0);
            graphics2D.draw(double_);
        } else if (!(tag instanceof BeginPath)) {
            if (tag instanceof Chord) {
                Chord chord = (Chord)tag;
                double d10 = chord.getStart().x / chord.getBounds().width;
                double d11 = chord.getEnd().x / chord.getBounds().width;
                double d12 = Math.acos(d10);
                double d13 = Math.acos(d11);
                this.currentPosition = chord.getEnd();
                Arc2D.Double double_ = new Arc2D.Double(chord.getStart().x, chord.getStart().y, chord.getBounds().width, chord.getBounds().height, d12, d13 - d12, 1);
                graphics2D.draw(double_);
            } else if (!(tag instanceof CloseFigure)) {
                if (tag instanceof CreatePen) {
                    CreatePen createPen = (CreatePen)tag;
                    LogPen logPen = createPen.getPen();
                    float[] fArray = null;
                    if (logPen.getPenStyle() == 1) {
                        fArray = new float[]{5.0f, 5.0f};
                    } else if (logPen.getPenStyle() == 3) {
                        fArray = new float[]{5.0f, 2.0f, 1.0f, 2.0f};
                    } else if (logPen.getPenStyle() == 4) {
                        fArray = new float[]{5.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f};
                    } else if (logPen.getPenStyle() == 2) {
                        fArray = new float[]{1.0f, 2.0f};
                    } else if (logPen.getPenStyle() == 0) {
                        fArray = new float[]{1.0f};
                    } else {
                        System.out.println("got unsupported pen style " + logPen.getPenStyle());
                    }
                    BasicStroke basicStroke = new BasicStroke(logPen.getWidth(), 2, 2, 1.0f, fArray, 0.0f);
                    graphics2D.setStroke(basicStroke);
                } else if (tag instanceof Ellipse) {
                    Ellipse ellipse = (Ellipse)tag;
                    Ellipse2D.Double double_ = new Ellipse2D.Double(ellipse.getBounds().getX(), ellipse.getBounds().getY(), ellipse.getBounds().getWidth(), ellipse.getBounds().getHeight());
                    graphics2D.draw(double_);
                } else if (tag instanceof LineTo) {
                    LineTo lineTo = (LineTo)tag;
                    Line2D.Double double_ = new Line2D.Double(this.currentPosition, lineTo.getPoint());
                    graphics2D.draw(double_);
                } else if (tag instanceof MoveToEx) {
                    MoveToEx moveToEx = (MoveToEx)tag;
                    this.currentPosition = moveToEx.getPoint();
                } else if (tag instanceof Pie) {
                    Pie pie = (Pie)tag;
                    double d14 = pie.getStart().x / pie.getBounds().width;
                    double d15 = pie.getEnd().x / pie.getBounds().width;
                    double d16 = Math.acos(d14);
                    double d17 = Math.acos(d15);
                    Arc2D.Double double_ = new Arc2D.Double(pie.getStart().x, pie.getStart().y, pie.getBounds().width, pie.getBounds().height, d16, d17 - d16, 2);
                    graphics2D.draw(double_);
                } else {
                    System.out.println("tag " + tag + " not supported");
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            EMFInputStream eMFInputStream = new EMFInputStream(fileInputStream);
            JFrame jFrame = new JFrame("EMF " + stringArray[0]);
            JScrollPane jScrollPane = new JScrollPane(new EMFDisplay(eMFInputStream));
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(550, 400);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

