target=glouton wp glwp


#if #TARGET (glouton)
 \title{Algorithme glouton de coloration}
#endif

#if #TARGET (wp)
 \title{Algorithme de coloration Welsh et Powell}
#endif

#if #TARGET (glwp)
 \title{Algorithmes de coloration}
#endif

#include "style.inc"
#include "couleur.inc"
#include "algo.inc"

\text{Co=}
\for{i=1 to items(\couleur)}{
\text{Co = \Co, <table width=25 bgcolor=\couleur[\i]><tr><td>&nbsp;</td></tr></table>}
}
\text{Co=wims(nonempty items \Co)}

\text{Co2=<table><tr>}
\for{i=1 to items(\couleur)}{
\text{Co2 = \Co2 <td bgcolor=\couleur[\i]>&nbsp;&nbsp;&nbsp;&nbsp;</td>}
}
\text{Co2= \Co2</tr></table>}



#if #TARGET (glouton)

\text{LL=wims(makelist x for x = 1 to \n)}
\text{Ord=shuffle(\LL)}
\text{Lord=\LL[\Ord]}
\text{C=pari(G = Mat([\G]) ; LL=[\LL] ; n = \n ; Ord = [\Ord] ; 
   glouton(G,LL,n,Ord))}
   
\text{Dessin=draw(\SIZE
\dessin)}

\for{j=1 to \n}{ 
  \text{dessin=\dessin
   disk \abscord[\2*\Lord[\j]-1,\2*\Lord[\j]],13,\couleur[\C[\Lord[\j]]]}
   \text{Dessin=\Dessin,draw(\SIZE
\dessin)}
}
\text{ordinal=premier,deuxime,troisime,quatrime,cinquime,sixime,septime,
huitime,neuvime,dixime,onzime,douzime,treizime,quatorzime}

#endif
 
#if #TARGET (wp)
\text{degre=pari([\degre])}
\text{LL=pari(vecsort([\degre],,5))}
\text{Ord=wims(makelist x for x = 1 to \n)}
\text{Lord=\LL[\Ord]}
\text{C=pari(G = Mat([\G]) ; LL=[\LL] ; n = \n ; Ord = [\Ord] ; 
   welsh(G,LL,n,Ord))}
\text{LIST = pari(Vec(LIST))}
\text{N=items(\LIST)}
\matrix{List=}
\for{i=1 to \N}{
  \matrix{List=\List
  wims(declosing \LIST[\i])
  }
}

\text{Dessin=draw(\SIZE
\dessin)}

\text{Dessin=\Dessin,\Dessin}
\for{j=1 to \N}{ 
  \integer{cnt=items(\List[\j;])}
  \for{k=1 to \cnt}{
    \text{dessin=\dessin
   disk \abscord[\2*\List[\j;\k]-1,\2*\List[\j;\k]],13,\couleur[\j]}
  }
   \text{Dessin=\Dessin,draw(\SIZE
\dessin)}
}
\text{ordinal=premire,deuxime,troisime,quatrime,cinquime,sixime,septime,
huitime,neuvime,dixime,onzime,douzime,treizime,quatorzime}

#endif


#if #TARGET (glwp)
\text{LLg=wims(makelist x for x = 1 to \n)}
\text{Ordg=shuffle(\LLg)}
\text{Lordg=\LLg[\Ordg]}
\text{degre=pari([\degre])}
\text{LLw=pari(vecsort([\degre],,5))}
\text{Ordw=wims(makelist x for x = 1 to \n)}
\text{Lordw=\LLw[\Ordw]}


\text{LLg=\LLw}
\text{Ordg=\Ordw}
\text{Lordg=\Lordw}


\text{Cw=pari(G = Mat([\G]) ; LL=[\LLw] ; n = \n ; Ord = [\Ordw] ; 
   welsh(G,LL,n,Ord))}
\text{LIST = pari(concat(Vec(LIST)))}
\text{Cg=pari(G = Mat([\G]) ; LL=[\LLg] ; n = \n ; Ord = [\Ordg] ; 
   glouton(G,LL,n,Ord))}
   
\text{dessing=\dessin}
\text{dessinw=\dessin}

\for{j=1 to \n}{ 
  \text{dessinw=\dessinw
   disk \abscord[\2*\Lordw[\j]-1,\2*\Lordw[\j]],13,\couleur[\Cw[\Lordw[\j]]]}
   \text{dessing=\dessing
   disk \abscord[\2*\Lordg[\j]-1,\2*\Lordg[\j]],13,\couleur[\Cg[\Lordg[\j]]]}
}

\text{Dessing=draw(\SIZE
\dessing)}
\text{Dessinw=draw(\SIZE
\dessinw)}

#endif

#if #TARGET (glouton)

\text{STEP = wims(makelist r x for x = 1 to \n)}
\text{STEP = wims(items2lines \STEP)}

\steps{\STEP}
\statement{\style 
<table><tr><td valign=top>
Voici un graphe. En utilisant l'algorithme 
\special{help glouton,glouton}, vous devez
dterminer une \special{help colorier, coloration} du graphe en coloriant
les sommets dans l'ordre suivant 
<p align = center><font size=+1 color=green>\Lord</font></p>
Les couleurs ont t ordonnes dans l'ordre
<p> \Co2 </p>
</td><td align="center"><img src=\Dessin[\step]>
</td></tr></table>

Le \ordinal[\step] sommet de la liste (sommet \Lord[\step])
est de couleur \embed{reply \step, 25x25}

}

\answer{Sommet 1}{\Co[\C[\Lord[1]]];\Co}{type=clickfill}
\answer{Sommet 2}{\Co[\C[\Lord[2]]];\Co}{type=clickfill}
\answer{Sommet 3}{\Co[\C[\Lord[3]]];\Co}{type=clickfill}
\answer{Sommet 4}{\Co[\C[\Lord[4]]];\Co}{type=clickfill}
\answer{Sommet 5}{\Co[\C[\Lord[5]]];\Co}{type=clickfill}
\answer{Sommet 6}{\Co[\C[\Lord[6]]];\Co}{type=clickfill}
\answer{Sommet 7}{\Co[\C[\Lord[7]]];\Co}{type=clickfill}
\answer{Sommet 8}{\Co[\C[\Lord[8]]];\Co}{type=clickfill}
\answer{Sommet 9}{\Co[\C[\Lord[9]]];\Co}{type=clickfill}
\answer{Sommet 10}{\Co[\C[\Lord[10]]];\Co}{type=clickfill}
\answer{Sommet 11}{\Co[\C[\Lord[11]]];\Co}{type=clickfill}
\answer{Sommet 12}{\Co[\C[\Lord[12]]];\Co}{type=clickfill}

#endif

#if #TARGET (wp)
\text{h=items(wims(listuniq \C))}
\text{STEP = wims(makelist r x for x = 1 to \h + 1)}
\matrix{STEP = wims(items2lines \STEP)}

\steps{\STEP}
\statement{\style 
<table><tr><td valign=top>
Voici un graphe. En utilisant l'algorithme de 
\special{help wp,Welsh et Powell}, vous devez
dterminer une \special{help colorier, coloration} du graphe.

\if{\step =1}{
<div class=question>Donner la liste des degrs des sommets dans 
l'ordre de leur numro : \embed{reply \step,20}
</div>
}
{<div class=reponse>La liste des degrs des sommets est 
<p align="center">\degre. </p>
On choisit de classer les sommets 
dans l'ordre suivant (degr dcroissant) : 
<p align = center><font size=+1 color=green>\Lord</font></p>
</div>

<div class=question>
Avec la \ordinal[\step-1] couleur, on colorie successivement 
(et dans l'ordre) les sommets 
\embed{r \step,10}.
</div>

Les couleurs ont t mises dans l'ordre
<p> \Co2 </p>
}

</td><td align="center"><img src=\Dessin[\step]>
</td></tr></table>

<i>Consigne : sparer les nombres par des virgules. </i>
}

\answer{Liste des degrs}{\degre}{type=vector}
\answer{Couleur 1}{\List[1;]}{type=vector}
\answer{Couleur 2}{\List[2;]}{type=vector}
\answer{Couleur 3}{\List[3;]}{type=vector}
\answer{Couleur 4}{\List[4;]}{type=vector}
\answer{Couleur 5}{\List[5;]}{type=vector}
\answer{Couleur 6}{\List[6;]}{type=vector}
\answer{Couleur 7}{\List[7;]}{type=vector}
\answer{Couleur 8}{\List[8;]}{type=vector}
\answer{Couleur 9}{\List[9;]}{type=vector}
\answer{Couleur 10}{\List[10;]}{type=vector}
\answer{Couleur 11}{\List[11;]}{type=vector}
\answer{Couleur 12}{\List[12;]}{type=vector}

\feedback{1=1}{ <p align="center"><img src=\Dessin[\N+2]> </p>}
#endif

#if #TARGET(glwp)
\text{n=randint(1,2)}
\text{Dessin=\n=1 ? \Dessing : \Dessinw}
\text{ordre = \n=1 ? \Lordg : \LIST}
\text{ordre_s=wims(replace internal , by  ,&nbsp; in \ordre)}
\text{ordre_s=wims(nospace \ordre_s)}
\text{choix=A,B}
\text{Choix=algorithme glouton,algorithme de Welsh-Powell}
\statement{Voici un graphe colori :
<p align="center"><img src=\Dessin></p>
Les sommets ont t coloris dans l'ordre 
<p align="center"><font size=+1 color=green>\ordre_s</font></p>

Quel algorithme a-t-on utilis ?

<p align="center">\embed{r 1,1} : \special{help glouton,algorithme glouton}  \embed{r 1,2} : \special{help wp,\Choix[2]} </p>
}

\answer{}{\n;\choix}{type=radio}

Si je fais un autre choix, il faut tre sur que la rponse ne peut pas tre un
des algo. 

#endif

#include "help.inc"
