/**
 * Sum.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente la somme de deux fonctions.
 *
 * @author Nicolae
 */
public class Composition extends DefaultMap { 

	private Map f;
	private Map g;	

	private double[] v = new double[2]; 
	
	/**
	 * Cache le constructor standard.
	 */
	private Composition() {}
	
	/**
	 * Constructor qui initialise les deux applications.
	 *
	 * @param f application.
	 * @param f application.
	 */
	public Composition(Map f, Map g) {
		this.f = f;
		this.g = g;
	}

	/* (non-Javadoc)
	 * @see maths.DefaultMap#apply()
	 */
	protected void apply() {
		g.value(x, y, v);
		f.value(v[0], v[1], v);

		fx = v[0];
		fy = v[1];
	}

	/* (non-Javadoc)
	 * @see maths.DefaultMap#inverse()
	 */
	public Map[] inverse() {
		return null;
	}

	protected void compDiff() {
		Map df = f.differential();
		Map dg = g.differential();
		
		if(df == null || dg == null)
			der = null;
		else {
			Map dfg = new Composition(df, g);
			
			der = new Product(dfg, dg);
		}		
	}
}
