target=guidadd

#include "header.inc"
\computeanswer{no}

\title{Guided addition}

\integer{den1=random(8,9,10,12,14,15,16)}
\integer{den2=random(randint(\den1/2+1..\den1-1),randint(\den1+1..2*\den1-1))}
\integer{num1=randint(2..1.5*\den1)}
\integer{num1=gcd(\num1,\den1)>1?\num1+1}
\integer{num2=randint(2..1.5*\den2)}
\integer{num2=gcd(\num2,\den2)>1?\num2+1}
\text{hr=<HR noshade size=2>}
\text{new=}
\integer{test1=0}
\text{big1=<font size=+2>}
\text{big2=</font>}
\text{objets=only the numerator, only the denominator,
the numerator and the denominator}

\text{gtext1=random(Rewrite the two fractions to put them on the same denominator,
    Put the two fractions on the same denominator
)}

\text{method1=\gtext1,
    Rewrite the two fractions to put them to the same numerator,
    Add numerators first,
    Add denominators first,
    Add the numerators and multiply the denominators,
    Multiply the numerators
}
\integer{cnt1=items(\method1)}
\text{sh1=shuffle(\cnt1)}
\integer{good1=position(1,\sh1)}
\text{method1=item(\sh1,\method1)}

\text{method2=Add the numerators and keep the common denominator,
 Add the numerators and the denominators separately
}
\integer{cnt2=items(\method2)}
\text{sh2=shuffle(\cnt2)}
\integer{good2=position(1,\sh2)}
\text{method2=item(\sh2,\method2)}

\text{nstep=r1}
\nextstep{\nstep}

\statement{Compute the following addition.
<p><center>
\(\num1/(\den1) + \num2/(\den2))
</center> <p>

\if{\step=1}{
 Choose the starting method: <ul>
 \for{k=1 to \cnt1}{ <li>\embed{r1,\k} }
 </ul>
 \exit{}
}

\if{\step=2 or \test1<1}{
 Step 1. Put the fractions on the same denominator.
 <p>
 Multiplying \embed{r2} of \(\num1/(\den1)) by \embed{r3,3}, we get
 <p><center><table border=0 cellpadding=3>
  <tr>
  <td align=center>\num1<td rowspan=3>&nbsp;\big1=\big2&nbsp;
  <td align=center>\embed{r6,3}
  <tr><td>\hr<td>\hr
  <tr><td align=center>\den1
  <td align=center>\embed{r7,3}
 </table></center> <p>
 Multiplying \embed{r4} of \(\num2/(\den2)) by \embed{r5,3}, we get
 <p><center><table border=0 cellpadding=3>
  <tr>
  <td align=center>\num2<td rowspan=3>&nbsp;\big1=\big2&nbsp;
  <td align=center>\embed{r8,3}
  <tr><td>\hr<td>\hr
  <tr><td align=center>\den2
  <td align=center>\embed{r9,3}
 </table></center> <p>
 \exit{}
}
 Step 1. We have \(\num1/(\den1) = \new[1]/(\new[2])) and
 \(\num2/(\den2) = \new[3]/(\new[4])), therefore the sum becomes
 <p><center>
  \(\new[1]/(\new[2]) + \new[3]/(\new[4])) .
 </center> <p>
 \if{\step=3}{
  What is the next step? <ul>
  \for{k=1 to \cnt2}{ <li>\embed{r10,\k} }
  </ul>
  \exit{}
 }
 Step 2. We add the numerators and keep the common denominators, therefore
 the sum is
 <p><center>
 <table border=0 cellpadding=2>
 <tr><td align=center>\num1
 <td rowspan=3>&nbsp;&nbsp;\big1+\big2&nbsp;&nbsp;</td>
 <td align=center>\num2
 <td rowspan=3>&nbsp;&nbsp;&nbsp;\big1=\big2&nbsp;&nbsp;&nbsp;</td>
 <td align=center>\new[1]
 <td rowspan=3>&nbsp;&nbsp;\big1+\big2&nbsp;&nbsp;</td>
 <td align=center>\new[3]
 <td rowspan=3>&nbsp;&nbsp;&nbsp;\big1=\big2&nbsp;&nbsp;&nbsp;</td>
 <td align=center>\embed{r11,4}
 <tr><td>\hr<td>\hr<td>\hr<td>\hr<td>\hr
 <tr><td align=center>\den1
 <td align=center>\den2
 <td align=center>\new[2]
 <td align=center>\new[4]
 <td align=center>\embed{r12,4}
 </table> 
 </center> <p>

}

\answer{Method step 1}{\good1;\method1}{type=click}

\answer{Objects to multiply 1}{3;\objets}{type=menu}
\answer{Multiplier 1}{\m1}{type=number}
\answer{Objects to multiply 2}{3;\objets}{type=menu}
\answer{Multiplier 2}{\m2}{type=number}
\answer{New numerator 1}{\nn1}{type=number}
\answer{New denominator 1}{\nd1}{type=number}
\answer{New numerator 2}{\nn2}{type=number}
\answer{New denominator 2}{\nd2}{type=number}

\answer{Method step 2}{\good2;\method2}{type=click}

\answer{Numerator of the sum}{\nsum}{type=number}
\answer{Denominator of the sum}{\dsum}{type=number}

\if{\step=2}{
 \text{nstep=r2,r3,r4,r5,r6,r7,r8,r9}
}

\text{test1=\test1<1 and \m1>0 and \m1=floor(\m1) and \m2>0 and \m2=floor(\m2)
    and \nn1=\num1*\m1 and \nd1=\den1*\m1
    and \nn2=\num2*\m2 and \nd2=\den2*\m2
    and \nd1=\nd2?1}
\if{\test1>0}{
 \text{new=\nn1,\nd1,\nn2,\nd2}
}

\condition{The multiplications are correct}{\test1>0}

\if{\step=3 and \test1>0}{
 \text{nstep=r10}
}

\if{\step=4}{
 \text{nstep=r11,r12}
}

\condition{The sum is good}{\test1>0 and \nsum=\nn1+\nn2 and \dsum=\nd1}

\feedback{\step=1 and \reply1 notsametext ~\good1}{
 The two fractions have different denominators. One cannot add them directly;
 we have first to rewrite them in order to put them on the same denominator.
}

\feedback{\step=2 and (\reply2 notsametext ~3 or \reply4 notsametext ~3)}{
 In order that a fraction remains unchanged in value, one must multiply its
 numerator and denominator by a same number.
}

\feedback{\step=3 and (\m1=0 or \m2=0)}{
 You don't have the right to multiply the numerator and denominator of a
 fraction by 0!
 <p>
 You would get a ``fraction'' \(0/(0)), which doesn't make sense.
}

\feedback{\step=3 and (\m1<0 or \m2<0)}{
 Sorry but this exercise does not allow you to multiply by a negative number.
}

\feedback{\step=3 and \m1>0 and \m2>0 and (\floor(\m1)!=\m1 or \floor(\m2)!=\m2)}{
 You should multiply the numerator and denominator of a fraction by an
 integer.
}

\feedback{\step=3 and \nd1=\den1*\m1 and \nd2=\den2*\m2 and \nd1!=\nd2}{
 Your aim is to put the fractions on a same denominator. Your multiplications
 do not achieve this, as the newly written fractions have different
 denominators. Wrong multiplications.
}

\feedback{\step=3 and (\nd1!=\den1*\m1 or \nn1!=\num1*\m1 or
	\nd2!=\den2*\m2 or \nn2!=\num2*\m2)}{
  Computational error in the multiplications.
}

\feedback{\step=3 and \reply10 notsametext ~\good2}{
 To add two fractions of the same denominator, one has only to add the
 numerators, while keeping the common denominator.
}

