(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.

Parameter gcd : Z -> Z -> Z.

Axiom gcd_asubb_b : forall a b:Z, gcd a b = gcd (a - b) b.
Axiom gcd_a_bsuba : forall a b:Z, gcd a b = gcd a (b - a).
Axiom gcd_a_a : forall a:Z, gcd a a = a.
Axiom gcd_a_0 : forall a:Z, gcd a 0 = a.
Axiom gcd_a_amodb : forall a b:Z, gcd a b = gcd b (a mod b).

Hint Resolve gcd_asubb_b gcd_a_bsuba gcd_a_a gcd_a_0 gcd_a_amodb .

Definition max (x y:Z) : Z :=
  match Z_le_gt_dec x y with
  | left _ => y
  | right _ => x
  end.

Proof.
intuition.
Save.

Proof.
intuition.
subst.
transitivity (gcd x y); auto.
unfold Zwf, max.
case (Z_le_gt_dec x0 y); case (Z_le_gt_dec x y); intros; omega.
Save.

Proof.
intuition.
subst.
transitivity (gcd x y); auto.
unfold Zwf, max.
assert (h: x <> y).
 assumption.
 case (Z_le_gt_dec x y0); case (Z_le_gt_dec x y); intros; omega.
Save.

Proof.
intuition; subst.
transitivity (gcd y y); auto.
Save.


Proof.
intuition.
Save.

Proof.
intuition.
assert (h_y0: y <> 0).
 assumption.
assert (h1_y0: (y > 0)).
 omega.
generalize (Z_mod_lt x y h1_y0); intro.
subst; tauto.
subst.
transitivity (gcd x y); auto.
unfold Zwf.
assert (h_y0: y <> 0).
 assumption.
assert (h1_y0: (y > 0)).
 omega.
generalize (Z_mod_lt x y h1_y0); omega.
Save.

Proof.
intuition; subst.
transitivity (gcd x 0); auto.
Save.


(*Why logic*) Definition gcd : Z -> Z -> Z.
Admitted.

(*Why axiom*) Lemma gcd_asubb_b :
  (forall (a:Z), (forall (b:Z), (gcd a b) = (gcd (a - b) b))).
Admitted.

(*Why axiom*) Lemma gcd_a_bsuba :
  (forall (a:Z), (forall (b:Z), (gcd a b) = (gcd a (b - a)))).
Admitted.

(*Why axiom*) Lemma gcd_a_a : (forall (a:Z), (gcd a a) = a).
Admitted.

(*Why axiom*) Lemma gcd_a_0 : (forall (a:Z), (gcd a 0) = a).
Admitted.

(*Why logic*) Definition max : Z -> Z -> Z.
Admitted.

(*Why axiom*) Lemma max_def :
  (forall (x:Z),
   (forall (y:Z), ((max x y) = x \/ (max x y) = y) /\ (max x y) >= x /\
    (max x y) >= y)).
Admitted.

(*Why axiom*) Lemma gcd_a_amodb :
  (forall (a:Z), (forall (b:Z), (gcd a b) = (gcd b ((Zmod a b))))).
Admitted.

(*Why axiom*) Lemma mod_lt :
  (forall (a:Z), (forall (b:Z), 0 <= ((Zmod a b)) /\ ((Zmod a b)) < b)).
Admitted.

