/*
 * NodeCone.h
 *
 * Copyright (C) 1999 Stephen F. White
 *               2003 Th. Rothermel
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_CONE_H
#define _NODE_CONE_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#ifndef _VEC3F_H
#include "Vec3f.h"
#endif

#include "SFMFTypes.h"

class ProtoCone : public Proto {
public:
		    ProtoCone(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex bottomRadius;
    FieldIndex height;
    FieldIndex side;
    FieldIndex bottom;
};

class NodeCone : public Node {
public:
		    NodeCone(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_CONE; }
    virtual Node   *copy() const { return new NodeCone(*this); }
    virtual int	    getNodeClass() const { return GEOMETRY_NODE; }
    virtual void    draw();
    virtual void    drawHandles();
    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v);
    virtual Node   *toNurbs(int nshell, int narea, int narcs, int uDegree, int vDegree);

    virtual bool    isInvalidChildNode(void) { return true; }
    virtual bool    hasBoundingBox(void) { return true; }
    virtual Vec3f   getMinBoundingBox(void);
    virtual Vec3f   getMaxBoundingBox(void);
    virtual void    flip(int index);

    virtual int     countPrimitives(void) {return 1;}

    fieldMacros(SFFloat, bottomRadius, ProtoCone)
    fieldMacros(SFFloat, height,       ProtoCone)
    fieldMacros(SFBool,  side,         ProtoCone)
    fieldMacros(SFBool,  bottom,       ProtoCone)
};

#endif // _NODE_CONE_H
