// Cancels the outline elements
function webdeveloper_cancelOutlineElements()
{
    window.opener.document.getElementById("webdeveloper-outline-custom-elements-menu").checked = false;

    window.close();
}

// Initializes the outline elements dialog
function webdeveloper_initializeOutlineElements()
{
    var color   = null;
    var element = null;

    // Loop through the possible custom elements
	for(var i = 1; i <= 5; i++)
	{
	    color   = "webdeveloper.custom." + i + ".color";
	    element = "webdeveloper.custom." + i + ".element";

        // If the color is set
        if(webdeveloper_isPreferenceSet(color))
        {
		    document.getElementById(color).color = webdeveloper_getStringPreference(color, true);
		}

        // If the element is set
        if(webdeveloper_isPreferenceSet(element))
        {
		    document.getElementById(element).value = webdeveloper_getStringPreference(element, true);
		}
	}
}

// Saves the list of colors and elements to outline
function webdeveloper_saveOutlineElements()
{
    var color   = null;
    var element = null;

    // Loop through the possible custom elements
	for(var i = 1; i <= 5; i++)
	{
	    color   = "webdeveloper.custom." + i + ".color";
	    element = "webdeveloper.custom." + i + ".element";

        webdeveloper_setStringPreference(color, document.getElementById(color).color);
        webdeveloper_setStringPreference(element, webdeveloper_trim(document.getElementById(element).value));
	}

	window.arguments[0].push(true);
}