//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>



//<file>
//
//
// Name:            table.h
//
// Purpose:         Interface of class TableGlyph
//
// Created:         22 May 95   Bernhard Marschall
// Modified:        22 May 95   Bernhard Marschall
//
//
// Description:
//
//</file>


#ifndef harmony_widgets_table_h
#define harmony_widgets_table_h

#include "libwidgets.h"
#include <InterViews/box.h>


//<class>
//
// Name:
//
// Purpose: 
//
// Public Interface:
//
// Description:
//
//</class>

class TableGlyph : public Box {
public:
  TableGlyph(
    int columns,            // number of columns
    int rows = 10,          // estimation for number of rows
    Coord hnatural = 0.0,   // natural space between columns
    Coord hstretch = 0.0,   // minimal space between columns
    Coord hshrink = 0.0     // maximal space between columns
  );
  virtual ~TableGlyph();

  virtual void appendRow(PolyGlyph*);
  virtual void prependRow(PolyGlyph*);
  virtual void insertRow(GlyphIndex, PolyGlyph*);
  virtual void removeRow(GlyphIndex);
  virtual void replaceRow(GlyphIndex, PolyGlyph*);

  int rows() const;

private:
  void insertVGlue(GlyphIndex);
  Coord height(PolyGlyph*) const;

  int cols_;
  int rows_;

  Glyph* hglue_;
};

inline void TableGlyph::appendRow(PolyGlyph* g) {
  insertRow(rows_, g);
}

inline void TableGlyph::prependRow(PolyGlyph* g) {
  insertRow(0, g);
}

inline void TableGlyph::replaceRow(GlyphIndex gi, PolyGlyph* g) {
  removeRow(gi);
  insertRow(gi, g);
}

inline int TableGlyph::rows() const {
  return rows_;
}

#endif
