//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

/*
 * File    :  slist.C
 *
 * Author  :  Keith Andrews, IICM, TU Graz, Austria
 *
 * Changes :  Michael Hofer (until May 92) and Michael Pichler
 *
 * Changed :   7 Feb 95
 *
 */


#include "slist.h"
#include "memleak.h"


void slist::put (void *item)            // append item to end of list
{
  if (!item)  // ignore nil item pointer
    return ;

  register snode *tmp = New snode;
  tmp->data = item ;
  tmp->next = 0 ;

  if (tail) 
  { tail->next = tmp;
    tail = tmp;
  }
  else
    head = tail = tmp;
} // put


void slist::removeFirst ()              // remove first item
// NB: does not call delete on data
{
  if (head)
  {
    snode* oldhead = head;
    head = head->next;
    if (curr == oldhead)
      curr = head;
    if (tail == oldhead)
      tail = head;
    delete oldhead;
  }
} // removeHead


void slist::clear ()                    // Delete entire list structure
// NB: does not call delete on data
{
  snode *ptr = head;
  snode *tmp;

  while (ptr) 
  { tmp = ptr;
    ptr = ptr->next;
    Delete tmp;
  }

  head = tail = curr = 0;
} // clear
