
// permgenmain.cpp
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Tom King and Dan Kimberg

#include "permgen.h"
#include <qapplication.h>
#include <qvariant.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <q3listbox.h>
#include <q3groupbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <q3popupmenu.h>
#include <q3toolbar.h>
#include <qdialog.h>
#include "vbprefs.h"

void permgen_help();
int commandlineExecute(int argc, char **argv);

VBPrefs vbp;
gsl_rng *theRNG;

int main( int argc, char ** argv )
{
  vbp.init();
  vbp.read_jobtypes();
  if (argc > 2) {
     int err = 0;
     err = commandlineExecute(argc, argv);
     if (err)
       switch (err) {
         case 1:
          printErrorMsg(VB_ERROR, "vbpermgen: bad argument structure.\n");
          return -1;
         case 2:
          printErrorMsg(VB_ERROR, "vbpermgen: no matrix stem name indicated.\n");
          return -1;
         case 3:
          printErrorMsg(VB_ERROR, "vbpermgen: no permutation directory indicated.\n");
          return -1;
         case 4:
          printErrorMsg(VB_ERROR, "vbpermgen: no method indicated.\n");
          return -1;
         case 5:
          printErrorMsg(VB_ERROR, "vbpermgen: number of permutations not indicated.\n");
          return -1;
         case 6:
          printErrorMsg(VB_ERROR, "vbpermgen: scale not indicated.\n");
          return -1;
         case 7:
          printErrorMsg(VB_ERROR, "vbpermgen: no contrasts inciated.\n");
          return -1;
         case 8:
          printErrorMsg(VB_ERROR, "vbpermgen: number of permuations desired exceeds number possible.\n");
          return -1;
       }
     return 0;
  }
  QApplication a(argc,argv);
  permGenerator pg;
  if (argc > 0) {
     if (strcmp(argv[argc-1], "-h")==0) {
        permgen_help();
        exit(0);
     }
  }
  QFont font( "SansSerif", 10, 0 );
  font.setStyleHint( QFont::SansSerif );
  a.setFont( font );
  pg.setFont( font );
  a.setMainWidget(&pg);
  pg.show();
  a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
  return a.exec();
}

void
permgen_help()
{
  printf("\nVoxBo vbpermgen (v%s)\n",vbversion.c_str());
  printf("summary: creates permutations on data from a specified glm directory.\n");
  printf("usage:\n");
  printf("          vbpermgen [flags]                                   \n" );
  printf("example that loads the GUI:\n");
  printf("          vbpermgen\n");
  printf("command line example:\n");
  printf("          vbpermgen -m glm -d perm -t 1 -c \"1 0\" -s t -p 0 0 0 -n 10 -a sn -b 2\n");
  printf("flags:\n");
  printf("          -h help    \n");
  printf("          -m <matrix stem name>     Specify the matrix stem name. Required.\n");
  printf("          -d Permutation directory name. Required.\n");
  printf("          -t Permutation type. 0 means no permutation.\n");
  printf("            1 means regular permutation.  2 means\n");
  printf("            signed permutation. Required.        \n");
  printf("          -s scale value of stat cubes. Required.\n");
  printf("          -c contrast values, in quotes. Required.\n");
  printf("          -p pseudoT values, in quotes. Required.\n");
  printf("          -v Global VoxBo version number. Optional.\n");
  printf("          -n index of permutation to be generated. Optional.\n");
  printf("          -a sequence name for the scheduler. Default is glm dir name. Optional.\n");
  printf("          -b prioity of sequence. Default is 2. Optional.\n");
  printf("scales:\n");
  printf("          t            - t value map\n");
  printf("          i            - intercept term percent change map\n");
  printf("          beta or rb   - raw beta values map\n");
  printf("          f            - F value map\n");
  printf("          tp tp/1 tp/2 - p map of t values\n");
  printf("          fp           - p map for F values\n");
  printf("          tz tz/1 tz/2 - Z map of t values\n");
  printf("          fz           - Z map for F values\n");
  printf("notes:\n");
  printf("          /1 and /2 force one tailed and two tailed, and,\n");
  printf("          if not indicated, VoxBo assumes one tailed testing.\n");
  printf("\n");
}

