
// permgen.cpp
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Tom King and Daniel Y. Kimberg

#include "permgen.h"
#include "vbx.h"
#include <iostream>
#include <fstream>
#include <qcheckbox.h>
#include <qvariant.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <q3textedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <q3frame.h>
//Added by qt3to4:
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <Q3BoxLayout>
#include <QCloseEvent>

extern VBPrefs vbp;

VBSequence seq;
VBJobSpec js;
string tempPRM;
int msgboxsetpermnumber;

using namespace std;

permGenerator::permGenerator( QWidget* parent, const char* name, bool modal, Qt::WFlags fl )
  : QDialog( parent, name, modal, fl )

{
  if ( !name )
    setName( "permGenerator" );

  Q3BoxLayout *x = new Q3VBoxLayout(this); 

  txtPRM = new QLineEdit( this, "txtPRM" );
  txtPRM->setGeometry( QRect( 250, 10, 170, 24 ) );
  connect(txtPRM, SIGNAL(textChanged(const QString &)), this, SLOT(CalculateNumPerms()));        

  pbDir = new QPushButton( this, "pbDir" );
  pbDir->setGeometry( QRect( 50, 10, 180, 20 ) );
  connect(pbDir, SIGNAL(clicked()), this, SLOT(getPRMFile()));

  Q3BoxLayout *y = new Q3HBoxLayout(x);
  y->insertWidget(0, pbDir, 10, Qt::AlignRight);
  y->addSpacing(30); 
  y->insertWidget(2, txtPRM, 10, Qt::AlignTop);
  y->addStretch(1);               
  y->setMargin(5);  
                                                                                                          
  txtPermDir = new QLineEdit( this, "txtPermDir" );
  txtPermDir->setGeometry( QRect( 250, 40, 170, 24 ) );

  lblPermDir = new QLabel( this, "lblPermNumber" );
  lblPermDir->setGeometry( QRect( 90, 130, 140, 20 ) );

  Q3BoxLayout *y1 = new Q3HBoxLayout(x);
  y1->insertWidget(0, lblPermDir, 10, Qt::AlignRight);
  y1->addSpacing(30);
  y1->insertWidget(2, txtPermDir, 10, Qt::AlignTop);
  y1->addStretch(1);
  y1->setMargin(5);
                                                                                                             
  txtContrasts = new QLineEdit( this, "txtContrasts" );
  txtContrasts->setGeometry( QRect( 250, 70, 170, 24 ) );

  lblContrasts = new QLabel( this, "lblContrasts" );
  lblContrasts->setGeometry( QRect( 130, 70, 100, 20 ) );

  Q3BoxLayout *y2 = new Q3HBoxLayout(x);
  y2->insertWidget(0, lblContrasts, 10, Qt::AlignRight);
  y2->addSpacing(30);
  y2->insertWidget(2, txtContrasts, 10, Qt::AlignTop);
  y2->addStretch(1);
  y2->setMargin(5);

  cbScale = new QComboBox( this, "txtScale" );
  cbScale->setGeometry( QRect( 250, 100, 170, 24 ) );
                                                                                                               
  lblScale = new QLabel( this, "lblScale" );
  lblScale->setGeometry( QRect( 130, 100, 100, 20 ) );
                                                                                                              
  Q3BoxLayout *y5 = new Q3HBoxLayout(x);
  y5->insertWidget(0, lblScale, 10, Qt::AlignRight);
  y5->addSpacing(30);
  y5->insertWidget(2, cbScale, 10, Qt::AlignTop);
  y5->addStretch(1);
  y5->setMargin(5);
                                                                                                               
  txtPermNumber = new QLineEdit( this, "txtPermNumber" );
  txtPermNumber->setGeometry( QRect( 250, 130, 170, 24 ) );
  connect(txtPermNumber, SIGNAL(textChanged(const QString &)), this, SLOT(warnCalculateNumPerms()));            

  lblPermNumber = new QLabel( this, "lblPermNumber" );
  lblPermNumber->setGeometry( QRect( 90, 130, 140, 20 ) );

  Q3BoxLayout *y3 = new Q3HBoxLayout(x);
  y3->insertWidget(0, lblPermNumber, 10, Qt::AlignRight);
  y3->addSpacing(30);
  y3->insertWidget(2, txtPermNumber, 10, Qt::AlignTop);
  y3->addStretch(1); 
  y3->setMargin(5);            

  lblPseudoT = new QLabel( this, "lblPseudoT" );
  lblPseudoT->setGeometry( QRect(10, 150, 143, 40) );
                                                                                                               
  QCheckBox *on=new QCheckBox("on/off",this);
  on->setChecked(0);
  on->setGeometry( QRect( 160, 160, 60, 21 ) );
  QObject::connect(on,SIGNAL(toggled(bool)),this,SLOT(mod(bool)));            
                              
  txtZ = new QLineEdit( this, "txtZ" );
  txtZ->setGeometry( QRect( 390, 160, 30, 24 ) );
  txtZ->setDisabled(true);
                                                                                                              
  lblZ = new QLabel( this, "lblZ" );
  lblZ->setGeometry( QRect( 370, 160, 16, 21 ) );
                                                                                                              
  txtX = new QLineEdit( this, "txtX" );
  txtX->setGeometry( QRect( 270, 160, 30, 24 ) );
  txtX->setDisabled(true);
                                                                                                              
  txtY = new QLineEdit( this, "txtY" );
  txtY->setGeometry( QRect( 330, 160, 30, 24 ) );
  txtY->setDisabled(true);
                                                                                                                
  lblX = new QLabel( this, "lblX" );
  lblX->setGeometry( QRect( 250, 160, 16, 20 ) );
                                                                                                                
  lblY = new QLabel( this, "lblY" );
  lblY->setGeometry( QRect( 310, 160, 16, 20 ) );

  Q3BoxLayout *y4 = new Q3HBoxLayout(x);
  y4->addSpacing(10);
  y4->insertWidget(1, lblPseudoT, 10, Qt::AlignRight);
  y4->addSpacing(10);
  y4->insertWidget(3, on, 10, Qt::AlignRight);
  y4->addSpacing(10);
  y4->insertWidget(5, lblX, 10, Qt::AlignRight);
  y4->addSpacing(5);
  y4->insertWidget(7, txtX, 10, Qt::AlignTop);
  y4->addSpacing(10);
  y4->insertWidget(9, lblY, 10, Qt::AlignRight);
  y4->addSpacing(5);
  y4->insertWidget(11, txtY, 10, Qt::AlignTop);
  y4->addSpacing(10);
  y4->insertWidget(13, lblZ, 10, Qt::AlignRight);
  y4->addSpacing(5);
  y4->insertWidget(15, txtZ, 10, Qt::AlignTop);
  y4->addStretch(1);
  y4->setMargin(5);

  lblPermType = new QLabel( this, "lblPermType" );
  lblPermType->setGeometry( QRect( 0, 190, 230, 20 ) );
                                                                                                                       
  cbPermType = new QComboBox( this, "cbPermType" );
  cbPermType->setGeometry( QRect( 250, 190, 170, 24 ) );
                                                                                                              
  Q3BoxLayout *y6 = new Q3HBoxLayout(x);
  y6->insertWidget(0, lblPermType, 10, Qt::AlignRight);
  y6->addSpacing(30);
  y6->insertWidget(2, cbPermType, 10, Qt::AlignTop);
  y6->addStretch(1);
  y6->setMargin(5);

  line2 = new Q3Frame( this, "line2" );
  line2->setGeometry( QRect( 21, 220, 400, 20 ) );
  line2->setFrameShape( Q3Frame::HLine );
  line2->setFrameShadow( Q3Frame::Sunken );
  line2->setFrameShape( Q3Frame::HLine );
                                                                                                              
  Q3BoxLayout *y7 = new Q3HBoxLayout(x);
  y7->addSpacing(10);
  y7->addWidget(line2, 10, Qt::AlignTop);
  y7->addSpacing(10);
  y7->setMargin(5);

  sbPriority = new QSpinBox( this, "sbPriority" );
  sbPriority->setGeometry( QRect( 360, 240, 41, 20 ) );
  sbPriority->setMaxValue( 4 );
  sbPriority->setMinValue( 1 );
  sbPriority->setValue( 3 );
                                                                                                              
  txtSN = new QLineEdit( this, "txtSN" );
  txtSN->setGeometry( QRect( 140, 240, 130, 23 ) );
                                                                                                               
  lblPriority = new QLabel( this, "lblPriority" );
  lblPriority->setGeometry( QRect( 300, 240, 50, 21 ) );
                                                                                                               
  lblSN = new QLabel( this, "lblSequenceName" );
  lblSN->setGeometry( QRect( 30, 240, 111, 21 ) );
                                                                                                                
  Q3BoxLayout *y8 = new Q3HBoxLayout(x);
  y8->addSpacing(30);
  y8->insertWidget(1, lblSN, 10, Qt::AlignRight);
  y8->addSpacing(30);
  y8->insertWidget(3, txtSN, 10, Qt::AlignTop);
  y8->addSpacing(10);
  y8->insertWidget(5, lblPriority, 10, Qt::AlignRight);
  y8->addSpacing(30);
  y8->insertWidget(7, sbPriority, 10, Qt::AlignLeft);
  y8->addStretch(1);
  y8->setMargin(5);

  //QBoxLayout *y9 = new QHBoxLayout(x);
  //y9->addSpacing(30);
  //y9->addStretch(1);

  pbCancel = new QPushButton( this, "pbCancel" );
  pbCancel->setGeometry( QRect( 310, 280, 110, 30 ) );
  connect(pbCancel, SIGNAL(clicked()), this, SLOT(exitProgram()));

  pbGO = new QPushButton( this, "pbGO" );
  pbGO->setGeometry( QRect( 30, 280, 120, 30 ) );
  connect(pbGO, SIGNAL(clicked()), this, SLOT(pressed()));

  Q3BoxLayout *y10 = new Q3HBoxLayout(x);
  y10->addSpacing(30);
  y10->insertWidget(1, pbGO, 10, Qt::AlignTop);
  y10->addSpacing(100); 
  y10->insertWidget(3, pbCancel, 10, Qt::AlignTop);
  y10->addSpacing(30);
  y10->addStretch(1);
  y10->setMargin(5);

  languageChange();
  resize( QSize(436, 318).expandedTo(minimumSizeHint()) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
permGenerator::~permGenerator()
{
  // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void permGenerator::languageChange()
{
  setCaption( tr( "Permutation Generator" ) );
  lblZ->setText( tr( "z:" ) );
  lblX->setText( tr( "x:" ) );
  lblY->setText( tr( "y:" ) );
  txtX->insert("0");
  txtY->insert("0");
  txtZ->insert("0");
  pbGO->setText( tr( "Submit Jobs" ) );
  lblContrasts->setText( tr( "Contrast:" ) );
  lblScale->setText( tr( "Scale:" ) );
  txtPermNumber->insert("0");
  lblPermNumber->setText( tr( "Number of Permutations:" ) );
  lblPseudoT->setText( tr( "Smoothing for Pseudo-t \n"
                           "map (FWHM in Voxels):" ) );
  lblPermType->setText( tr( " Perm Type:" ) );
  pbDir->setText( tr( "Select PRM File" ) );
  lblPriority->setText( tr( "Priority:" ) );
  lblSN->setText( tr( "Sequence Name:" ) );
  lblPermDir->setText( tr( "Perm Directory (to be created):" ) );

  cbScale->addItem("t values");
  cbScale->addItem("intercept % change");
  cbScale->addItem("raw beta values");
  cbScale->addItem("F values");
  cbScale->addItem("p map for t values");
  cbScale->addItem("p map for F values");
  cbScale->addItem("Z map for t values");
  cbScale->addItem("Z map for F values");

  cbPermType->addItem("Sign");
  cbPermType->addItem("Regular");

  pbCancel->setText( tr( "Cancel" ) );
  msgboxsetpermnumber = 0;
}

void permGenerator::mod(bool x) {
  txtX->setEnabled(x);
  txtY->setEnabled(x);
  txtZ->setEnabled(x);
  if (x == FALSE) {
    txtX->clear();
    txtX->insert("0");
    txtY->clear();
    txtY->insert("0");
    txtZ->clear();
    txtZ->insert("0");
  }
  return;
}
QString permGenerator::getPRMFile() {
  QString s=Q3FileDialog::getOpenFileName(".","All (*.prm)",this,"open .prm file","Choose a .prm file to load");
  if (s==QString::null)
    return QString("");
  tempPRM = s.ascii(); 
  txtPRM->clear();
  createfullpath(s.ascii());
  txtPRM->insert(s.ascii());
  if (s==QString::null)
    return QString("");
  else
    return s;
}

int commandlineExecute(int argc, char **argv) {
  GLMInfo glmi;
  string matrixStemName, permDir, sscale, seqname;
  int method, priority;
  string scale;
  string contrasts, pseudoT, clist, plist;
  arghandler a;
  a.setArgs("-h", "--help", 0);
  a.setArgs("-m", "--matrixstemname", 1);
  a.setArgs("-d", "--permdir", 1);
  a.setArgs("-t", "--method", 1);
  a.setArgs("-v", "--version", 0);
  a.setArgs("-n", "--permindex", 1);
  a.setArgs("-s", "--scale", 1);
  a.setArgs("-c", "--contrast", 1);
  a.setArgs("-p", "--pseudot", 3);
  a.setArgs("-a", "--seqname", 1);
  a.setArgs("-b", "--priority", 1);
  a.parseArgs(argc, argv);
  string errstring = a.badArg();
  if (errstring.size()) 
    return 1;
  matrixStemName = a.getFlaggedArgs("-m")[0];
  if (matrixStemName.size() == 0) return 2;
  glmi.setup(matrixStemName);
  permDir = a.getFlaggedArgs("-d")[0];
  if (permDir.size() == 0) return 3;
  method = atoi(a.getFlaggedArgs("-t")[0].c_str());
  if (a.getFlaggedArgs("-t")[0].size() == 0) return 4;
  if (a.flagPresent("-v"))
    printf("\nVoxBo v%s\n",vbversion.c_str());
  int numPerms = atoi(a.getFlaggedArgs("-n")[0].c_str());
  int maxPerms = 0;
  int onOff = 0;
  VBMatrix headerMatrix;
  string headerName = xrootname(glmi.stemname) + ".G";
  headerMatrix.ReadMAT1Header(headerName);
  double orderG = (double)headerMatrix.m;
  if (pow(2.0, (orderG-1)) < 1000)
    maxPerms = (int)pow(2.0, (orderG-1));
  else
    maxPerms = 1000;
  if (numPerms > maxPerms) return 8;
  if (a.getFlaggedArgs("-n")[0].size() == 0) return 5;
  sscale = a.getFlaggedArgs("-s")[0];
  if (sscale.size() == 0) return 6;
  seqname = a.getFlaggedArgs("-a")[0];
  if (seqname.size() == 0) seqname = glmi.stemname;
  priority = atoi(a.getFlaggedArgs("-b")[0].c_str());
  if (a.getFlaggedArgs("-b")[0].size() == 0) priority = 3;
  clist =a.getFlaggedArgs("-c")[0];
  if (a.getFlaggedArgs("-c")[0].size() == 0) return 7;
  plist = a.getFlaggedArgs("-p")[0] + " " + a.getFlaggedArgs("-p")[1] + " " + a.getFlaggedArgs("-p")[2];
  if (a.getFlaggedArgs("-p")[0].size() == 0) 
    plist = "'0 0 0'";
  else
    onOff = 1;
  char presentDir[STRINGLEN];
  char temp[STRINGLEN];
  char tempstring[STRINGLEN];
  getcwd(presentDir,STRINGLEN-1);
  strcat(presentDir, "/");
  struct stat my_stat;
  string file;
  //check permutation directory if mat file already exists
  file = glmi.stemname + "_" + permDir + "/" + "permutations.mat";
  //clist = "'" + clist + "'";
  if (clist.size()) {
    if (glmi.parsecontrast(clist) != 0) {
      errstring = "contrast: failed to derive a valid contrast from " + clist;
      printErrorMsg(VB_ERROR, errstring.c_str()); 
      return -1;
    }
    else {
      contrasts = "";
      for (int index = 0; index < glmi.contrast.contrast.size(); index++) {
        sprintf(tempstring, "%1.0f", glmi.contrast.contrast[index]);
        if (index != 0) contrasts += " ";
        contrasts += tempstring;
      }
    }
  }
  else {
    errstring = "contrast: no contrast values were supplied.";
    printErrorMsg(VB_ERROR, errstring.c_str()); 
    return -1; 
  }
  clist = "'";
  for (int index = 0; index < glmi.contrast.contrast.size(); index++) {
    sprintf(tempstring, "%1.0f", glmi.contrast.contrast[index]);
    if (index != 0) clist += " ";
    clist += tempstring;
  }
  clist += "'";
  if (!sscale.size()) {
    if (glmi.contrast.scale.size())
      sscale = glmi.contrast.scale;
    else {
      errstring = "vbpermgen: no scale was provided.";
      printErrorMsg(VB_ERROR, errstring.c_str());
      return -1;
    }
  }
  if (!(validscale(sscale)) && sscale.size()) {
    errstring = "contrast: invalid scale passed: " + sscale;
    printErrorMsg(VB_ERROR, errstring.c_str());
    return -1;
  }
  plist = "'" + plist + "'";
  permclass pc;
  pc.AddMatrixStemName(glmi.stemname);
  pc.AddPermDir(permDir);
  pc.AddScale(sscale);
  pc.AddMethod(method);
  pc.AddContrastlist(contrasts);
  pc.AddPseudoTList(plist);
  pc.AddPseudoTOnOff(onOff);
  pc.SetFileName("perminfo.txt");
  pc.AddPrmTimeStamp(glmi.stemname);
  if (stat(file.c_str(), &my_stat) != 0)
    permStart(pc);
  pc.SavePermClass();
  memset((void*)&my_stat, 0, sizeof(my_stat));
  seq.init();
  QString name;
  int count = 0;
  if (numPerms > 0) {
    for (int permIndex = 0; permIndex < numPerms; permIndex++) {
      js.init();
      js.arguments.clear();
      if (method == 1)
        js.jobtype="permstep";
      else
        js.jobtype="permstep2";

      // Modified by Dongbo to add the argument title ina dumb way (10/12/2005)
      //          js.arguments.Add(glmi.stemname);
      //          js.arguments.Add(permDir);
      //          sprintf(temp, "%d", method); 
      //          js.arguments.Add(temp); 
      //          sprintf(temp, "%s", scale.c_str());
      //          js.arguments.Add(temp);
      //          js.arguments.Add(clist);
      //          js.arguments.Add(plist);
      //          sprintf(temp, "%d", permIndex);
      //          js.arguments.Add(temp);
      js.arguments["matrixstemname"]=glmi.stemname;
      js.arguments["permdir"]=permDir;
      js.arguments["permtype"]=strnum(method);
      // FIXME steps is set to sscale???
      js.arguments["steps"]=temp;
      js.arguments["contrast"]=clist;
      js.arguments["pseudot"]=plist;
      js.arguments["permindex"]=strnum(permIndex);

      js.magnitude=0;
      js.name=permDir+temp;
      js.dirname = presentDir;
      js.jnum = permIndex;
      count = permIndex;
      seq.addJob(js);
    }
  }
  js.init();
  js.arguments.clear();
  js.jobtype="permfinish";

  // Modified by Dongbo too (10/12/2005)
  //    js.arguments.Add(glmi.stemname + "_" + permDir + "/" + "iterations/permcube");
  //    js.arguments.Add(glmi.stemname + "_" + permDir + "/results.ref");
  js.arguments["permstemname"]=glmi.stemname + "_" + permDir + "/" + "iterations/permcube";
  js.arguments["resultsfile"]=glmi.stemname + "_" + permDir + "/results.ref";

  js.magnitude=0;
  js.name="finish";
  js.dirname = presentDir;
  js.jnum = count + 1;
  for (int i=0; i<=count; i++)
    js.waitfor.insert(i);
  seq.addJob(js);
  seq.name=seqname;
  if (seq.name.size() == 0)
    seq.name="perm"+matrixStemName;
  seq.priority = priority;
  seq.seqnum = (int)getpid();
  if (vbp.cores==0) {
    if (seq.Submit(vbp) == 0) {
      errstring = "vbpermgen successfully submitted the sequence.";
      printErrorMsg(VB_INFO, errstring.c_str());
    }
    else {
      errstring = "vbpermgen failed to submit the sequence.";
      printErrorMsg(VB_ERROR, errstring.c_str());
      return -1;
    }
  }
  else {
    runseq(vbp,seq,vbp.cores);
  }
  return 0;
}

void permGenerator::pressed() {
  GLMInfo glmi;
  char presentDir[STRINGLEN];
  char temp[STRINGLEN];
  char tempstring[STRINGLEN];
  getcwd(presentDir,STRINGLEN-1);
  strcat(presentDir, "/");
  string matrixStemName = txtPRM->text().latin1();
  string permDir = txtPermDir->text().latin1();
  string scale = cbScale->currentText().latin1();
  int method = 2-(cbPermType->currentItem()); //methods start at 1, not 0
  int numPerms = atoi(txtPermNumber->text());
  string contrasts = txtContrasts->text().latin1();
  string clist = contrasts;
  if (clist.size()) {
    glmi.setup(matrixStemName);
    if (glmi.parsecontrast(clist) != 0) {
      string errstring = "contrast: failed to derive a valid contrast from " + clist + "\n";
      QMessageBox::warning( this, "Warning!", errstring.c_str());
      return;
    }
    else {
      contrasts = "";
      for (int index = 0; index < glmi.contrast.contrast.size(); index++) {
        sprintf(tempstring, "%1.0f", glmi.contrast.contrast[index]);
        if (index != 0) contrasts += " ";
        contrasts += tempstring;
      }
    }
  }
  else {
    string errstring = "contrast: no contrast values were supplied.\n";
    QMessageBox::warning( this, "Warning!", errstring.c_str());
    return;
  }
  clist = "'";
  for (int index = 0; index < glmi.contrast.contrast.size(); index++) {
    sprintf(tempstring, "%1.0f", glmi.contrast.contrast[index]);
    if (index != 0) clist += " ";
    clist += tempstring;
  }
  clist += "'";
  if (!scale.size()) {
    if (glmi.contrast.scale.size())
      scale = glmi.contrast.scale;
    else {
      string errstring = "vbpermgen: no scale was provided.";
      printErrorMsg(VB_ERROR, errstring.c_str());
      return;
    }
  }
  if (scale == "t values") scale = "t";
  else if (scale == "intercept % change") scale = "i";
  else if (scale == "raw beta values") scale = "rb";
  else if (scale == "F values") scale = "f";
  else if (scale == "p map for t values") scale = "tp";
  else if (scale == "p map for F values") scale = "fp";
  else if (scale == "Z map for t values") scale = "tz";
  else if (scale == "Z map for F values") scale = "fz";
  if (!(validscale(scale)) && scale.size()) {
    string errstring = "contrast: invalid scale passed: " + scale;
    QMessageBox::warning( this, "Warning!", errstring.c_str()); 
    return;
  }
  string pseudoT = (string)txtX->text().latin1() + " " + txtY->text().latin1() + " " + txtZ->text().latin1();
  if (!txtX->isEnabled())
    pseudoT = "0 0 0";
  string plist = "'" + pseudoT + "'"; 
  permclass pc;
  pc.AddMatrixStemName(glmi.stemname);
  pc.AddPermDir(permDir);
  pc.AddScale(scale);
  pc.AddMethod(method);
  pc.AddContrastlist(contrasts);
  pc.AddPseudoTList(pseudoT);
  pc.AddPseudoTOnOff(txtX->isEnabled());
  pc.AddPrmTimeStamp(glmi.stemname);
  pc.SetFileName("perminfo.txt");
  if (matrixStemName.size() == 0) {
    QMessageBox::warning( this, "Warning!", "Must specify the matrix stem name (glm directory).\n");
    return;
  }
  if (permDir.size() == 0) {
    QMessageBox::warning( this, "Warning!", "Must specify the permutation directory name.\n"); 
    return;
  }
  if ((method < 0) || (method > 2)) {
    QMessageBox::warning( this, "Warning!", "Must specify the permutation method.\n"); 
    return;
  }
  if ((scale != "t") && (scale != "i") && (scale != "rb") && (scale != "f") && (scale != "tp") &&
      (scale != "fp") && (scale != "tz") && (scale != "fz")) { 
    QMessageBox::warning( this, "Warning!", "Must specify the scale. For list of scales, type permgen -h.\n");
    return;
  }
  struct stat my_stat;
  string file;
  //check permutation directory if mat file already exists
  file = glmi.stemname + "_" + permDir + "/" + "permutations.mat"; 
  // FIXME if permstart returns an error, we're in trouble.  but
  // really this should be a job instead.
  if (stat(file.c_str(), &my_stat) != 0) 
    permStart(pc);
  pc.SavePermClass(); 
  memset((void*)&my_stat, 0, sizeof(my_stat));
  seq.init();
  QString name;
  int count = 0;
  if (numPerms > 0) {
    for (int permIndex = 0; permIndex < numPerms; permIndex++) {
      js.init();
      js.arguments.clear();
      if (method == 1)
        js.jobtype="permstep";
      else
        js.jobtype="permstep2";

      // Modified by Dongbo to add the argument title ina dumb way (10/12/2005)
      //          js.arguments.Add(glmi.stemname);
      //          js.arguments.Add(permDir);
      //          sprintf(temp, "%d", method); 
      //          js.arguments.Add(temp); 
      //          sprintf(temp, "%s", scale.c_str());
      //          js.arguments.Add(temp);
      //          js.arguments.Add(clist);
      //          js.arguments.Add(plist);
      //          sprintf(temp, "%d", permIndex);
      //          js.arguments.Add(temp);
      js.arguments["matrixstemname"]=glmi.stemname;
      js.arguments["permdir"]=permDir;
      js.arguments["permtype"]=strnum(method);
      // FIXME steps = scale???
      js.arguments["steps"]=scale;
      js.arguments["contrast"]=clist;
      js.arguments["pseudot"]=plist;
      js.arguments["permindex"]=strnum(permIndex);

      // FIXME following flag line is totally broken
      // if (method == 2) js.arguments.Add("-e");
      js.magnitude=0;
      js.name=permDir+temp;
      js.dirname = presentDir;
      js.jnum = permIndex;
      count = permIndex;
      seq.addJob(js);
    }
  }
  js.init();
  js.arguments.clear();
  js.jobtype="permfinish";

  // Modified by Dongbo too (10/12/2005)
  //    js.arguments.Add(glmi.stemname + "_" + permDir + "/" + "iterations/permcube");
  //    js.arguments.Add(glmi.stemname + "_" + permDir + "/results.ref");
  js.arguments["permstemname"]=glmi.stemname + "_" + permDir + "/" + "iterations/permcube";
  js.arguments["resultsfile"]=glmi.stemname + "_" + permDir + "/results.ref";

  js.magnitude=0;
  js.name="finish";
  js.dirname = presentDir;
  js.jnum = count + 1;
  for (int i=0; i<=count; i++)
    js.waitfor.insert(i);
  seq.addJob(js);
  seq.name=txtSN->text().ascii();
  if (seq.name.size() == 0)
    seq.name="perm"+matrixStemName;
  seq.priority = sbPriority->value();
  seq.seqnum = (int)getpid();
  if (vbp.cores==0) {
    if (seq.Submit(vbp) == 0) {
      QMessageBox::warning( this, "Information", "The requested sequence was submitted.\n");
      return;
    }
    else {
      QMessageBox::warning( this, "Information", "The requested sequence failed to submit.\n");
      return;
    }
  }
  else {
    runseq(vbp,seq,vbp.cores);
  }
  msgboxsetpermnumber = 0;
  return;
}

int permGenerator::warnCalculateNumPerms() {
  if (msgboxsetpermnumber) return 1;
  VBMatrix headerMatrix;
  GLMInfo glmi;
  struct stat my_stat;
  int numPerms = 0;
  string matrixStemName;
  if (txtPRM->text().length())
    matrixStemName = txtPRM->text().ascii();
  else
    matrixStemName = tempPRM; 
  string headerName = xrootname(matrixStemName) + ".G";
  if (stat(headerName.c_str(),&my_stat)) {
    return 1;
  }
  headerMatrix.ReadMAT1Header(headerName);
  double orderG = (double)headerMatrix.m;
  if (pow(2.0, (orderG-1)) < 1000)
    numPerms = (int)pow(2.0, (orderG-1));
  else
    numPerms = 1000;
  char num[STRINGLEN];
  char obs[STRINGLEN];
  char old[STRINGLEN];
  sprintf(num, "%d", numPerms);
  sprintf(obs, "%d", (int)orderG);
  sprintf(old, "%d", atoi(txtPermNumber->text().ascii()));
  string snum = num;
  string og = obs;
  string sold = old;
  string msg = "Maximum permutations is " + snum + " based on your data.\n Do you want to generate the " + snum + " possible?";
  if (atoi(txtPermNumber->text().ascii()) > numPerms) {
    QMessageBox mb( "vbpermgen",
                    msg.c_str(),
                    QMessageBox::Information,
                    QMessageBox::Yes | QMessageBox::Default,
                    QMessageBox::No,
                    QMessageBox::Cancel | QMessageBox::Escape );
    mb.setButtonText( QMessageBox::Yes, "Replace" );
    mb.setButtonText( QMessageBox::No, "Abort" );
    switch( mb.exec() ) {
    case QMessageBox::Yes:
      msgboxsetpermnumber = 1;
      txtPermNumber->clear();
      txtPermNumber->insert(num); 
      msgboxsetpermnumber = 0;
      return 0;
      break;
    case QMessageBox::No:
      msgboxsetpermnumber = 1;
      txtPermNumber->clear();
      txtPermNumber->insert("0");
      msgboxsetpermnumber = 0;
      return 1;
      break;
    case QMessageBox::Cancel:
      msgboxsetpermnumber = 1;
      txtPermNumber->clear();
      txtPermNumber->insert("0");
      msgboxsetpermnumber = 0; 
      return 1; 
      break;
    } 
  }
  return numPerms;
}

void permGenerator::CalculateNumPerms() {
  if (msgboxsetpermnumber) return;
  VBMatrix headerMatrix;
  GLMInfo glmi;
  struct stat my_stat;
  int numPerms = 0;
  string matrixStemName;
  if (txtPRM->text().length())
    matrixStemName = txtPRM->text().ascii();
  else
    matrixStemName = tempPRM;
  string headerName = xrootname(matrixStemName) + ".G";
  if (stat(headerName.c_str(),&my_stat)) {
    return;
  }
  headerMatrix.ReadMAT1Header(headerName);
  double orderG = (double)headerMatrix.m;
  if (pow(2.0, (orderG-1)) < 1000)
    numPerms = (int)pow(2.0, (orderG-1));
  else
    numPerms = 1000;
  char num[STRINGLEN];
  sprintf(num, "%d", numPerms);
  txtPermNumber->clear();
  txtPermNumber->insert(num);
  return;
}

void permGenerator::closeEvent( QCloseEvent *ce ){
  ce->accept();
  return;
}

void permGenerator::exitProgram() {
  exit(0);
  return;
}
