/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListBuilder;
import org.apache.fop.fo.TreeBuilder;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler
implements TreeBuilder {
    protected Hashtable fobjTable = new Hashtable();
    protected Hashtable propertylistTable = new Hashtable();
    protected FObj currentFObj = null;
    protected FObj rootFObj = null;
    protected Hashtable unknownFOs = new Hashtable();

    public void addElementPropertyList(String string, String string2, Hashtable hashtable) {
        PropertyListBuilder propertyListBuilder = (PropertyListBuilder)this.propertylistTable.get(string);
        if (propertyListBuilder == null) {
            propertyListBuilder = new PropertyListBuilder();
            propertyListBuilder.addElementList(string2, hashtable);
            this.propertylistTable.put(string, propertyListBuilder);
        } else {
            propertyListBuilder.addElementList(string2, hashtable);
        }
    }

    public void addMapping(String string, String string2, FObj.Maker maker) {
        this.fobjTable.put(String.valueOf(string) + "^" + string2, maker);
    }

    public void addPropertyList(String string, Hashtable hashtable) {
        PropertyListBuilder propertyListBuilder = (PropertyListBuilder)this.propertylistTable.get(string);
        if (propertyListBuilder == null) {
            propertyListBuilder = new PropertyListBuilder();
            propertyListBuilder.addList(hashtable);
            this.propertylistTable.put(string, propertyListBuilder);
        } else {
            propertyListBuilder.addList(hashtable);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.currentFObj.addCharacters(cArray, n, n + n2);
    }

    public void endElement(String string, String string2, String string3) {
        this.currentFObj.end();
        this.currentFObj = this.currentFObj.getParent();
    }

    public void format(AreaTree areaTree) throws FOPException {
        MessageHandler.logln("formatting FOs into areas");
        ((Root)this.rootFObj).format(areaTree);
    }

    public void startDocument() {
        MessageHandler.logln("building formatting object tree");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        FObj fObj;
        String string4 = String.valueOf(string) + "^" + string2;
        FObj.Maker maker = (FObj.Maker)this.fobjTable.get(string4);
        PropertyListBuilder propertyListBuilder = (PropertyListBuilder)this.propertylistTable.get(string);
        if (maker == null) {
            if (!this.unknownFOs.containsKey(string4)) {
                this.unknownFOs.put(string4, "");
                MessageHandler.errorln("WARNING: Unknown formatting object " + string4);
            }
            maker = new FObjMixed.Maker();
        }
        try {
            PropertyList propertyList = null;
            propertyList = propertyListBuilder != null ? propertyListBuilder.makeList(string4, attributes, this.currentFObj == null ? null : this.currentFObj.properties, this.currentFObj) : this.currentFObj.properties;
            fObj = maker.make(this.currentFObj, propertyList);
        }
        catch (FOPException fOPException) {
            throw new SAXException(fOPException);
        }
        if (this.rootFObj == null) {
            this.rootFObj = fObj;
            if (!fObj.getName().equals("fo:root")) {
                throw new SAXException(new FOPException("Root element must be root, not " + fObj.getName()));
            }
        } else {
            this.currentFObj.addChild(fObj);
        }
        this.currentFObj = fObj;
    }
}

