/* vtgutils.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgutils.vala, do not modify */

/*
 *  vtgutils.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <valagee.h>
#include <vbf.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <stdarg.h>
#include <afrodite.h>
#include <gedit/gedit-document.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_CACHES (vtg_caches_get_type ())
#define VTG_CACHES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CACHES, VtgCaches))
#define VTG_CACHES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CACHES, VtgCachesClass))
#define VTG_IS_CACHES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CACHES))
#define VTG_IS_CACHES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CACHES))
#define VTG_CACHES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CACHES, VtgCachesClass))

typedef struct _VtgCaches VtgCaches;
typedef struct _VtgCachesClass VtgCachesClass;
typedef struct _VtgCachesPrivate VtgCachesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _VtgParamSpecCaches VtgParamSpecCaches;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_UTILS (vtg_utils_get_type ())
#define VTG_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_UTILS, VtgUtils))
#define VTG_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_UTILS, VtgUtilsClass))
#define VTG_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_UTILS))
#define VTG_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_UTILS))
#define VTG_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_UTILS, VtgUtilsClass))

typedef struct _VtgUtils VtgUtils;
typedef struct _VtgUtilsClass VtgUtilsClass;
typedef struct _VtgUtilsPrivate VtgUtilsPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

typedef enum  {
	VTG_PROJECT_MANAGER_ERROR_NO_BACKEND
} VtgProjectManagerError;
#define VTG_PROJECT_MANAGER_ERROR vtg_project_manager_error_quark ()
typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgCaches {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgCachesPrivate * priv;
};

struct _VtgCachesClass {
	GTypeClass parent_class;
	void (*finalize) (VtgCaches *self);
};

struct _VtgParamSpecCaches {
	GParamSpec parent_instance;
};

struct _VtgUtils {
	GObject parent_instance;
	VtgUtilsPrivate * priv;
};

struct _VtgUtilsClass {
	GObjectClass parent_class;
};


static gpointer vtg_caches_parent_class = NULL;
static GtkListStore* vtg_caches__build_cache;
static GtkListStore* vtg_caches__build_cache = NULL;
static GtkListStore* vtg_caches__compile_cache;
static GtkListStore* vtg_caches__compile_cache = NULL;
static GtkListStore* vtg_caches__configure_cache;
static GtkListStore* vtg_caches__configure_cache = NULL;
static GtkListStore* vtg_caches__executer_cache;
static GtkListStore* vtg_caches__executer_cache = NULL;
static GType vtg_caches_type_id = 0;
static gpointer vtg_utils_parent_class = NULL;
static gboolean vtg_utils__initialized;
static gboolean vtg_utils__initialized = FALSE;
static ValaList* vtg_utils__available_packages;
static ValaList* vtg_utils__available_packages = NULL;
static GtkBuilder* vtg_utils__builder;
static GtkBuilder* vtg_utils__builder = NULL;
static gchar** vtg_utils__vala_keywords;
static gint vtg_utils__vala_keywords_length1;
static gchar** vtg_utils__vala_keywords = NULL;
static gint vtg_utils__vala_keywords_length1 = 0;
static gint _vtg_utils__vala_keywords_size_ = 0;
extern GdkPixbuf* vtg_utils_icon_generic;
GdkPixbuf* vtg_utils_icon_generic = NULL;
extern GdkPixbuf* vtg_utils_icon_field;
GdkPixbuf* vtg_utils_icon_field = NULL;
extern GdkPixbuf* vtg_utils_icon_method;
GdkPixbuf* vtg_utils_icon_method = NULL;
extern GdkPixbuf* vtg_utils_icon_class;
GdkPixbuf* vtg_utils_icon_class = NULL;
extern GdkPixbuf* vtg_utils_icon_struct;
GdkPixbuf* vtg_utils_icon_struct = NULL;
extern GdkPixbuf* vtg_utils_icon_property;
GdkPixbuf* vtg_utils_icon_property = NULL;
extern GdkPixbuf* vtg_utils_icon_signal;
GdkPixbuf* vtg_utils_icon_signal = NULL;
extern GdkPixbuf* vtg_utils_icon_iface;
GdkPixbuf* vtg_utils_icon_iface = NULL;
extern GdkPixbuf* vtg_utils_icon_const;
GdkPixbuf* vtg_utils_icon_const = NULL;
extern GdkPixbuf* vtg_utils_icon_enum;
GdkPixbuf* vtg_utils_icon_enum = NULL;
extern GdkPixbuf* vtg_utils_icon_namespace;
GdkPixbuf* vtg_utils_icon_namespace = NULL;
extern GdkPixbuf* vtg_utils_icon_project;
GdkPixbuf* vtg_utils_icon_project = NULL;
extern GdkPixbuf* vtg_utils_icon_folder_packages;
GdkPixbuf* vtg_utils_icon_folder_packages = NULL;
extern GdkPixbuf* vtg_utils_icon_package;
GdkPixbuf* vtg_utils_icon_package = NULL;
extern GdkPixbuf* vtg_utils_icon_project_library_16;
GdkPixbuf* vtg_utils_icon_project_library_16 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_library_22;
GdkPixbuf* vtg_utils_icon_project_library_22 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_unknown_16;
GdkPixbuf* vtg_utils_icon_project_unknown_16 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_unknown_22;
GdkPixbuf* vtg_utils_icon_project_unknown_22 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_data_16;
GdkPixbuf* vtg_utils_icon_project_data_16 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_data_22;
GdkPixbuf* vtg_utils_icon_project_data_22 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_executable_16;
GdkPixbuf* vtg_utils_icon_project_executable_16 = NULL;
extern GdkPixbuf* vtg_utils_icon_project_executable_22;
GdkPixbuf* vtg_utils_icon_project_executable_22 = NULL;
static GType vtg_utils_type_id = 0;

GQuark vtg_project_manager_error_quark (void);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
void vtg_interaction_error_message (const gchar* message, GError* err);
void vtg_interaction_info_message (const gchar* message);
gpointer vtg_caches_ref (gpointer instance);
void vtg_caches_unref (gpointer instance);
GParamSpec* vtg_param_spec_caches (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_caches (GValue* value, gpointer v_object);
void vtg_value_take_caches (GValue* value, gpointer v_object);
gpointer vtg_value_get_caches (const GValue* value);
GType vtg_caches_get_type (void) G_GNUC_CONST;
GType vtg_caches_register_type (GTypeModule * module);
enum  {
	VTG_CACHES_DUMMY_PROPERTY
};
#define VTG_CACHES_CACHE_LIMIT 20
GtkListStore* vtg_caches_get_build_cache (void);
GtkListStore* vtg_caches_get_compile_cache (void);
GtkListStore* vtg_caches_get_configure_cache (void);
GtkListStore* vtg_caches_get_executer_cache (void);
gboolean vtg_caches_cache_contains (GtkListStore* cache, const gchar* data);
gboolean vtg_caches_cache_remove (GtkListStore* cache, const gchar* data);
void vtg_caches_cache_add (GtkListStore* cache, const gchar* data);
gint vtg_caches_cache_count (GtkListStore* cache);
VtgCaches* vtg_caches_new (void);
VtgCaches* vtg_caches_construct (GType object_type);
static void vtg_caches_finalize (VtgCaches* obj);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
gchar* vtg_string_utils_replace (const gchar* data, const gchar* search, const gchar* replace);
gchar* vtg_path_utils_normalize_path (const gchar* name);
gint vtg_path_utils_compare_vala_filenames (const gchar* filea, const gchar* fileb);
GType vtg_utils_get_type (void) G_GNUC_CONST;
GType vtg_utils_register_type (GTypeModule * module);
enum  {
	VTG_UTILS_DUMMY_PROPERTY
};
void vtg_utils_trace (const gchar* format, ...);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos);
gboolean vtg_utils_is_vala_keyword (const gchar* word);
gchar* vtg_utils_get_document_uri (GeditDocument* doc);
gchar* vtg_utils_get_document_name (GeditDocument* doc);
AfroditeSourceType vtg_utils_get_source_type (GeditDocument* doc);
GtkBuilder* vtg_utils_get_builder (void);
gchar* vtg_utils_get_ui_path (const gchar* id);
gchar* vtg_utils_get_image_path (const gchar* id);
static void vtg_utils_initialize (void);
ValaList* vtg_utils_get_available_packages (void);
static void vtg_utils_initialize_packages_cache (void);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GdkPixbuf* vtg_utils_get_icon_for_type_name (AfroditeMemberType type);
gchar* vtg_utils_get_stock_id_for_target_type_to_delete (VbfTargetTypes type);
GdkPixbuf* vtg_utils_get_small_icon_for_target_type (VbfTargetTypes type);
GdkPixbuf* vtg_utils_get_big_icon_for_target_type (VbfTargetTypes type);
gint vtg_utils_symbol_type_compare (AfroditeSymbol* vala, AfroditeSymbol* valb);
VtgUtils* vtg_utils_new (void);
VtgUtils* vtg_utils_construct (GType object_type);
static void vtg_utils_finalize (GObject* obj);
gchar* vtg_parser_utils_get_line_to_end (GtkTextIter* start);
void vtg_parser_utils_parse_line (const gchar* line, gchar** token, gboolean* is_assignment, gboolean* is_creation, gboolean* is_declaration);
gchar* vtg_parser_utils_get_token (const gchar* line, gint* i);
gboolean vtg_parser_utils_is_eof (const gchar* line, gint i);
gint vtg_parser_utils_skip_spaces (const gchar* line, gint i);
GRegex* vtg_language_support_get_using_regex (GeditDocument* doc, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark vtg_project_manager_error_quark (void) {
	return g_quark_from_static_string ("vtg_project_manager_error-quark");
}


GType vtg_vcs_types_get_type (void) {
	static volatile gsize vtg_vcs_types_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_vcs_types_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_VCS_TYPES_NONE, "VTG_VCS_TYPES_NONE", "none"}, {VTG_VCS_TYPES_GIT, "VTG_VCS_TYPES_GIT", "git"}, {VTG_VCS_TYPES_BZR, "VTG_VCS_TYPES_BZR", "bzr"}, {VTG_VCS_TYPES_SVN, "VTG_VCS_TYPES_SVN", "svn"}, {0, NULL, NULL}};
		GType vtg_vcs_types_type_id;
		vtg_vcs_types_type_id = g_enum_register_static ("VtgVcsTypes", values);
		g_once_init_leave (&vtg_vcs_types_type_id__volatile, vtg_vcs_types_type_id);
	}
	return vtg_vcs_types_type_id__volatile;
}


void vtg_interaction_error_message (const gchar* message, GError* err) {
	GtkMessageDialog* _tmp0_ = NULL;
	GtkMessageDialog* dialog;
	g_return_if_fail (message != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, message);
	dialog = g_object_ref_sink (_tmp0_);
	g_object_set (dialog, "secondary-text", err->message, NULL);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


void vtg_interaction_info_message (const gchar* message) {
	GtkMessageDialog* _tmp0_ = NULL;
	GtkMessageDialog* dialog;
	g_return_if_fail (message != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, message);
	dialog = g_object_ref_sink (_tmp0_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GtkListStore* vtg_caches_get_build_cache (void) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp1_;
	if (vtg_caches__build_cache == NULL) {
		GtkListStore* _tmp0_ = NULL;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
		_g_object_unref0 (vtg_caches__build_cache);
		vtg_caches__build_cache = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (vtg_caches__build_cache);
	result = _tmp1_;
	return result;
}


GtkListStore* vtg_caches_get_compile_cache (void) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp1_;
	if (vtg_caches__compile_cache == NULL) {
		GtkListStore* _tmp0_ = NULL;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
		_g_object_unref0 (vtg_caches__compile_cache);
		vtg_caches__compile_cache = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (vtg_caches__compile_cache);
	result = _tmp1_;
	return result;
}


GtkListStore* vtg_caches_get_configure_cache (void) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp1_;
	if (vtg_caches__configure_cache == NULL) {
		GtkListStore* _tmp0_ = NULL;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
		_g_object_unref0 (vtg_caches__configure_cache);
		vtg_caches__configure_cache = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (vtg_caches__configure_cache);
	result = _tmp1_;
	return result;
}


GtkListStore* vtg_caches_get_executer_cache (void) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp1_;
	if (vtg_caches__executer_cache == NULL) {
		GtkListStore* _tmp0_ = NULL;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
		_g_object_unref0 (vtg_caches__executer_cache);
		vtg_caches__executer_cache = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (vtg_caches__executer_cache);
	result = _tmp1_;
	return result;
}


gboolean vtg_caches_cache_contains (GtkListStore* cache, const gchar* data) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gboolean found;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (cache != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	found = FALSE;
	_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* tmp = NULL;
				if (!_tmp2_) {
					gboolean _tmp3_;
					_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter);
					if (!_tmp3_) {
						break;
					}
				}
				_tmp2_ = FALSE;
				gtk_tree_model_get ((GtkTreeModel*) cache, &iter, 0, &tmp, -1);
				if (g_strcmp0 (tmp, data) == 0) {
					found = TRUE;
					_g_free0 (tmp);
					break;
				}
				_g_free0 (tmp);
			}
		}
	}
	result = found;
	return result;
}


gboolean vtg_caches_cache_remove (GtkListStore* cache, const gchar* data) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gboolean found;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (cache != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	found = FALSE;
	_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* tmp = NULL;
				if (!_tmp2_) {
					gboolean _tmp3_;
					_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter);
					if (!_tmp3_) {
						break;
					}
				}
				_tmp2_ = FALSE;
				gtk_tree_model_get ((GtkTreeModel*) cache, &iter, 0, &tmp, -1);
				if (g_strcmp0 (tmp, data) == 0) {
					found = TRUE;
					gtk_list_store_remove (cache, &iter);
					_g_free0 (tmp);
					break;
				}
				_g_free0 (tmp);
			}
		}
	}
	result = found;
	return result;
}


void vtg_caches_cache_add (GtkListStore* cache, const gchar* data) {
	GtkTreeIter iter = {0};
	gint _tmp0_;
	GtkTreeIter _tmp4_ = {0};
	g_return_if_fail (cache != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = vtg_caches_cache_count (cache);
	if (_tmp0_ > VTG_CACHES_CACHE_LIMIT) {
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &_tmp1_);
		iter = _tmp1_;
		if (_tmp2_) {
			GtkTreeIter target;
			target = iter;
			while (TRUE) {
				gboolean _tmp3_;
				_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter);
				if (!_tmp3_) {
					break;
				}
				target = iter;
			}
			gtk_list_store_remove (cache, &target);
		}
	}
	gtk_list_store_insert (cache, &_tmp4_, 0);
	iter = _tmp4_;
	gtk_list_store_set (cache, &iter, 0, data, -1);
}


gint vtg_caches_cache_count (GtkListStore* cache) {
	gint result = 0;
	gint count;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (cache != NULL, 0);
	count = 0;
	_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					gboolean _tmp3_;
					_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter);
					if (!_tmp3_) {
						break;
					}
				}
				_tmp2_ = FALSE;
				count++;
			}
		}
	}
	result = count;
	return result;
}


VtgCaches* vtg_caches_construct (GType object_type) {
	VtgCaches* self = NULL;
	self = (VtgCaches*) g_type_create_instance (object_type);
	return self;
}


VtgCaches* vtg_caches_new (void) {
	return vtg_caches_construct (VTG_TYPE_CACHES);
}


static void vtg_value_caches_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vtg_value_caches_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vtg_caches_unref (value->data[0].v_pointer);
	}
}


static void vtg_value_caches_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vtg_caches_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vtg_value_caches_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vtg_value_caches_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		VtgCaches* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vtg_caches_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vtg_value_caches_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VtgCaches** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vtg_caches_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vtg_param_spec_caches (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	VtgParamSpecCaches* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VTG_TYPE_CACHES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vtg_value_get_caches (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VTG_TYPE_CACHES), NULL);
	return value->data[0].v_pointer;
}


void vtg_value_set_caches (GValue* value, gpointer v_object) {
	VtgCaches* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VTG_TYPE_CACHES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VTG_TYPE_CACHES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vtg_caches_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vtg_caches_unref (old);
	}
}


void vtg_value_take_caches (GValue* value, gpointer v_object) {
	VtgCaches* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VTG_TYPE_CACHES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VTG_TYPE_CACHES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vtg_caches_unref (old);
	}
}


static void vtg_caches_class_init (VtgCachesClass * klass) {
	vtg_caches_parent_class = g_type_class_peek_parent (klass);
	VTG_CACHES_CLASS (klass)->finalize = vtg_caches_finalize;
}


static void vtg_caches_instance_init (VtgCaches * self) {
	self->ref_count = 1;
}


static void vtg_caches_finalize (VtgCaches* obj) {
	VtgCaches * self;
	self = VTG_CACHES (obj);
}


GType vtg_caches_get_type (void) {
	return vtg_caches_type_id;
}


GType vtg_caches_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { vtg_value_caches_init, vtg_value_caches_free_value, vtg_value_caches_copy_value, vtg_value_caches_peek_pointer, "p", vtg_value_caches_collect_value, "p", vtg_value_caches_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VtgCachesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_caches_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgCaches), 0, (GInstanceInitFunc) vtg_caches_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	vtg_caches_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VtgCaches", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vtg_caches_type_id;
}


gpointer vtg_caches_ref (gpointer instance) {
	VtgCaches* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vtg_caches_unref (gpointer instance) {
	VtgCaches* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VTG_CACHES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gboolean vtg_string_utils_is_null_or_empty (const gchar* data) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (data == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (data, "") == 0;
	}
	result = _tmp0_;
	return result;
}


gchar* vtg_string_utils_replace (const gchar* data, const gchar* search, const gchar* replace) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	g_return_val_if_fail (replace != NULL, NULL);
	_tmp0_ = g_regex_escape_string (search, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch53_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, data, (gssize) (-1), 0, replace, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch53_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally53;
	__catch53_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally53:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gchar* vtg_path_utils_normalize_path (const gchar* name) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_;
	gchar** name_parts;
	gint name_parts_length1;
	gint _name_parts_size_;
	gchar* last_item;
	gchar* _tmp9_;
	gchar* target_name;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	if (name == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		_tmp1_ = strlen (name);
		_tmp0_ = _tmp1_ < 2;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (name);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = strlen (name);
	_tmp4_ = string_substring (name, (glong) 1, (glong) (_tmp3_ - 1));
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "/", 0);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	name_parts = _tmp8_;
	name_parts_length1 = _vala_array_length (_tmp6_);
	_name_parts_size_ = _vala_array_length (_tmp6_);
	last_item = NULL;
	_tmp9_ = g_strdup ("");
	target_name = _tmp9_;
	{
		gchar** item_collection;
		int item_collection_length1;
		int item_it;
		item_collection = name_parts;
		item_collection_length1 = name_parts_length1;
		for (item_it = 0; item_it < name_parts_length1; item_it = item_it + 1) {
			gchar* _tmp10_;
			gchar* item;
			_tmp10_ = g_strdup (item_collection[item_it]);
			item = _tmp10_;
			{
				if (g_strcmp0 (item, "..") != 0) {
					gchar* _tmp14_;
					if (last_item != NULL) {
						gchar* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp11_ = g_strconcat ("/", last_item, NULL);
						_tmp12_ = _tmp11_;
						_tmp13_ = g_strconcat (target_name, _tmp12_, NULL);
						_g_free0 (target_name);
						target_name = _tmp13_;
						_g_free0 (_tmp12_);
					}
					_tmp14_ = g_strdup (item);
					_g_free0 (last_item);
					last_item = _tmp14_;
				} else {
					_g_free0 (last_item);
					last_item = NULL;
				}
				_g_free0 (item);
			}
		}
	}
	if (last_item != NULL) {
		_tmp15_ = g_strcmp0 (last_item, "..") != 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = g_strconcat ("/", last_item, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (target_name, _tmp17_, NULL);
		_g_free0 (target_name);
		target_name = _tmp18_;
		_g_free0 (_tmp17_);
	}
	result = target_name;
	_g_free0 (last_item);
	name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gint vtg_path_utils_compare_vala_filenames (const gchar* filea, const gchar* fileb) {
	gint result = 0;
	gchar* _tmp0_;
	gchar* dataa;
	gchar* _tmp1_;
	gchar* datab;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gint _tmp18_;
	g_return_val_if_fail (filea != NULL, 0);
	g_return_val_if_fail (fileb != NULL, 0);
	_tmp0_ = g_strdup (filea);
	dataa = _tmp0_;
	_tmp1_ = g_strdup (fileb);
	datab = _tmp1_;
	_tmp3_ = g_str_has_suffix (dataa, ".vala");
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = g_str_has_suffix (dataa, ".vapi");
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp5_ = strlen (dataa);
		_tmp6_ = string_substring (dataa, (glong) 0, (glong) (_tmp5_ - 5));
		_g_free0 (dataa);
		dataa = _tmp6_;
	} else {
		gboolean _tmp7_;
		_tmp7_ = g_str_has_suffix (dataa, ".gs");
		if (_tmp7_) {
			gint _tmp8_;
			gchar* _tmp9_ = NULL;
			_tmp8_ = strlen (dataa);
			_tmp9_ = string_substring (dataa, (glong) 0, (glong) (_tmp8_ - 3));
			_g_free0 (dataa);
			dataa = _tmp9_;
		}
	}
	_tmp11_ = g_str_has_suffix (datab, ".vala");
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp12_;
		_tmp12_ = g_str_has_suffix (datab, ".vapi");
		_tmp10_ = _tmp12_;
	}
	if (_tmp10_) {
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp13_ = strlen (datab);
		_tmp14_ = string_substring (datab, (glong) 0, (glong) (_tmp13_ - 5));
		_g_free0 (datab);
		datab = _tmp14_;
	} else {
		gboolean _tmp15_;
		_tmp15_ = g_str_has_suffix (datab, ".gs");
		if (_tmp15_) {
			gint _tmp16_;
			gchar* _tmp17_ = NULL;
			_tmp16_ = strlen (datab);
			_tmp17_ = string_substring (datab, (glong) 0, (glong) (_tmp16_ - 3));
			_g_free0 (datab);
			datab = _tmp17_;
		}
	}
	_tmp18_ = g_strcmp0 (dataa, datab);
	result = _tmp18_;
	_g_free0 (datab);
	_g_free0 (dataa);
	return result;
}


inline void vtg_utils_trace (const gchar* format, ...) {
	va_list va;
	va_list va2;
	g_return_if_fail (format != NULL);
	va_start (va, format);
	va_copy (va2, va);
	afrodite_utils_log_message ("ValaToys", format, va2);
	va_end (va2);
	va_end (va);
}


gboolean vtg_utils_is_vala_doc (GeditDocument* doc) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkSourceLanguage* _tmp1_ = NULL;
	g_return_val_if_fail (doc != NULL, FALSE);
	_tmp1_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) doc);
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		GtkSourceLanguage* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) doc);
		_tmp4_ = gtk_source_language_get_id (_tmp3_);
		if (g_strcmp0 (_tmp4_, "vala") == 0) {
			_tmp2_ = TRUE;
		} else {
			GtkSourceLanguage* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp5_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) doc);
			_tmp6_ = gtk_source_language_get_id (_tmp5_);
			_tmp2_ = g_strcmp0 (_tmp6_, "genie") == 0;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos) {
	gboolean result = FALSE;
	gboolean res;
	gboolean _tmp0_;
	g_return_val_if_fail (src != NULL, FALSE);
	res = FALSE;
	_tmp0_ = gtk_source_buffer_iter_has_context_class (src, pos, "comment");
	if (_tmp0_) {
		res = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		_tmp2_ = gtk_text_iter_is_end (pos);
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gunichar _tmp3_;
			_tmp3_ = gtk_text_iter_get_char (pos);
			_tmp1_ = _tmp3_ == '\n';
		}
		if (_tmp1_) {
			gboolean _tmp4_;
			_tmp4_ = gtk_text_iter_backward_char (pos);
			if (_tmp4_) {
				gboolean _tmp5_;
				_tmp5_ = gtk_source_buffer_iter_has_context_class (src, pos, "comment");
				if (_tmp5_) {
					res = TRUE;
				} else {
					gtk_text_iter_forward_char (pos);
				}
			}
		}
	}
	if (!res) {
		gboolean _tmp6_;
		_tmp6_ = gtk_source_buffer_iter_has_context_class (src, pos, "string");
		if (_tmp6_) {
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			_tmp8_ = gtk_text_iter_is_start (pos);
			if (!_tmp8_) {
				gunichar _tmp9_;
				_tmp9_ = gtk_text_iter_get_char (pos);
				_tmp7_ = _tmp9_ == '"';
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				gboolean _tmp10_;
				_tmp10_ = gtk_text_iter_backward_char (pos);
				if (_tmp10_) {
					gboolean _tmp11_;
					_tmp11_ = gtk_source_buffer_iter_has_context_class (src, pos, "string");
					if (_tmp11_) {
						res = TRUE;
					} else {
						gtk_text_iter_forward_char (pos);
					}
				}
			}
		}
	}
	result = res;
	return result;
}


gboolean vtg_utils_is_vala_keyword (const gchar* word) {
	gboolean result = FALSE;
	gboolean res;
	g_return_val_if_fail (word != NULL, FALSE);
	res = FALSE;
	{
		gchar** keyword_collection;
		int keyword_collection_length1;
		int keyword_it;
		keyword_collection = vtg_utils__vala_keywords;
		keyword_collection_length1 = vtg_utils__vala_keywords_length1;
		for (keyword_it = 0; keyword_it < vtg_utils__vala_keywords_length1; keyword_it = keyword_it + 1) {
			gchar* _tmp0_;
			gchar* keyword;
			_tmp0_ = g_strdup (keyword_collection[keyword_it]);
			keyword = _tmp0_;
			{
				if (g_strcmp0 (keyword, word) == 0) {
					res = TRUE;
					_g_free0 (keyword);
					break;
				}
				_g_free0 (keyword);
			}
		}
	}
	result = res;
	return result;
}


gchar* vtg_utils_get_document_uri (GeditDocument* doc) {
	gchar* result = NULL;
	gchar* _result_;
	GFile* _tmp0_ = NULL;
	GFile* file;
	g_return_val_if_fail (doc != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = gedit_document_get_location (doc);
	file = _tmp0_;
	if (file != NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_file_get_uri (file);
		_g_free0 (_result_);
		_result_ = _tmp1_;
	}
	result = _result_;
	_g_object_unref0 (file);
	return result;
}


gchar* vtg_utils_get_document_name (GeditDocument* doc) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = vtg_utils_get_document_uri (doc);
	name = _tmp0_;
	if (name == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = gedit_document_get_short_name_for_display (doc);
		_g_free0 (name);
		name = _tmp1_;
	} else {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = g_filename_from_uri (name, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch54_g_error;
		}
		_g_free0 (name);
		name = _tmp3_;
		goto __finally54;
		__catch54_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("vtgutils.vala:383: error %s converting file %s to uri", e->message, name);
			_g_error_free0 (e);
		}
		__finally54:
		if (_inner_error_ != NULL) {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = vtg_utils_is_vala_doc (doc);
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp8_ = g_str_has_suffix (name, ".vala");
		if (!_tmp8_) {
			gboolean _tmp9_;
			_tmp9_ = g_str_has_suffix (name, ".vapi");
			_tmp7_ = !_tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gboolean _tmp10_;
			_tmp10_ = g_str_has_suffix (name, ".gs");
			_tmp6_ = !_tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		AfroditeSourceType _tmp11_;
		_tmp11_ = vtg_utils_get_source_type (doc);
		if (_tmp11_ == AFRODITE_SOURCE_TYPE_GENIE) {
			gchar* _tmp12_;
			_tmp12_ = g_strconcat (name, ".gs", NULL);
			_g_free0 (name);
			name = _tmp12_;
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strconcat (name, ".vala", NULL);
			_g_free0 (name);
			name = _tmp13_;
		}
	}
	result = name;
	return result;
}


AfroditeSourceType vtg_utils_get_source_type (GeditDocument* doc) {
	AfroditeSourceType result = 0;
	GtkSourceLanguage* _tmp0_ = NULL;
	g_return_val_if_fail (doc != NULL, 0);
	_tmp0_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) doc);
	if (_tmp0_ != NULL) {
		GtkSourceLanguage* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) doc);
		_tmp2_ = gtk_source_language_get_id (_tmp1_);
		if (g_strcmp0 (_tmp2_, "vala") == 0) {
			GFile* _tmp3_ = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* name;
			gboolean _tmp7_ = FALSE;
			_tmp3_ = gedit_document_get_location (doc);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_file_get_uri (_tmp4_);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			name = _tmp6_;
			if (name != NULL) {
				gboolean _tmp8_;
				_tmp8_ = g_str_has_suffix (name, ".vapi");
				_tmp7_ = _tmp8_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = AFRODITE_SOURCE_TYPE_VAPI;
				_g_free0 (name);
				return result;
			} else {
				result = AFRODITE_SOURCE_TYPE_VALA;
				_g_free0 (name);
				return result;
			}
			_g_free0 (name);
		} else {
			GtkSourceLanguage* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) doc);
			_tmp10_ = gtk_source_language_get_id (_tmp9_);
			if (g_strcmp0 (_tmp10_, "genie") == 0) {
				result = AFRODITE_SOURCE_TYPE_GENIE;
				return result;
			}
		}
	}
	result = AFRODITE_SOURCE_TYPE_UNKNOWN;
	return result;
}


GtkBuilder* vtg_utils_get_builder (void) {
	GtkBuilder* result = NULL;
	GtkBuilder* _tmp3_;
	GError * _inner_error_ = NULL;
	if (vtg_utils__builder == NULL) {
		GtkBuilder* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = gtk_builder_new ();
		_g_object_unref0 (vtg_utils__builder);
		vtg_utils__builder = _tmp0_;
		_tmp1_ = vtg_utils_get_ui_path ("vtg.ui");
		_tmp2_ = _tmp1_;
		gtk_builder_add_from_file (vtg_utils__builder, _tmp2_, &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch55_g_error;
		}
		goto __finally55;
		__catch55_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("vtgutils.vala:422: initialize_ui: %s", err->message);
			_g_error_free0 (err);
		}
		__finally55:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _g_object_ref0 (vtg_utils__builder);
	result = _tmp3_;
	return result;
}


gchar* vtg_utils_get_image_path (const gchar* id) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_build_filename (PACKAGE_DATADIR, "images", id, NULL);
	_result_ = _tmp0_;
	result = _result_;
	return result;
}


gchar* vtg_utils_get_ui_path (const gchar* id) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_build_filename (PACKAGE_DATADIR, "ui", id, NULL);
	_result_ = _tmp0_;
	result = _result_;
	return result;
}


static void vtg_utils_initialize (void) {
	GtkIconTheme* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GdkPixbuf* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GdkPixbuf* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_;
	GdkPixbuf* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	GdkPixbuf* _tmp25_ = NULL;
	GdkPixbuf* _tmp26_;
	GdkPixbuf* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GdkPixbuf* _tmp30_ = NULL;
	GdkPixbuf* _tmp31_;
	GdkPixbuf* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	GdkPixbuf* _tmp35_ = NULL;
	GdkPixbuf* _tmp36_;
	GdkPixbuf* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	GdkPixbuf* _tmp40_ = NULL;
	GdkPixbuf* _tmp41_;
	GdkPixbuf* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	GdkPixbuf* _tmp45_ = NULL;
	GdkPixbuf* _tmp46_;
	GdkPixbuf* _tmp47_;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_;
	GdkPixbuf* _tmp50_ = NULL;
	GdkPixbuf* _tmp51_;
	GdkPixbuf* _tmp52_;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	GdkPixbuf* _tmp55_ = NULL;
	GdkPixbuf* _tmp56_;
	GdkPixbuf* _tmp57_;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_;
	GdkPixbuf* _tmp60_ = NULL;
	GdkPixbuf* _tmp61_;
	GdkPixbuf* _tmp62_;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_;
	GdkPixbuf* _tmp65_ = NULL;
	GdkPixbuf* _tmp66_;
	GdkPixbuf* _tmp67_;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_;
	GdkPixbuf* _tmp70_ = NULL;
	GdkPixbuf* _tmp71_;
	GdkPixbuf* _tmp72_;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_;
	GdkPixbuf* _tmp75_ = NULL;
	GdkPixbuf* _tmp76_;
	GdkPixbuf* _tmp77_;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_;
	GdkPixbuf* _tmp80_ = NULL;
	GdkPixbuf* _tmp81_;
	GdkPixbuf* _tmp82_;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_;
	GdkPixbuf* _tmp85_ = NULL;
	GdkPixbuf* _tmp86_;
	GdkPixbuf* _tmp87_;
	gchar* _tmp88_ = NULL;
	gchar* _tmp89_;
	GdkPixbuf* _tmp90_ = NULL;
	GdkPixbuf* _tmp91_;
	GdkPixbuf* _tmp92_;
	gchar* _tmp93_ = NULL;
	gchar* _tmp94_;
	GdkPixbuf* _tmp95_ = NULL;
	GdkPixbuf* _tmp96_;
	GdkPixbuf* _tmp97_;
	GtkIconTheme* _tmp98_ = NULL;
	GdkPixbuf* _tmp99_ = NULL;
	GdkPixbuf* _tmp100_;
	GtkIconTheme* _tmp101_ = NULL;
	GdkPixbuf* _tmp102_ = NULL;
	GdkPixbuf* _tmp103_;
	GError * _inner_error_ = NULL;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = gtk_icon_theme_load_icon (_tmp0_, GTK_STOCK_FILE, 16, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_generic);
	vtg_utils_icon_generic = _tmp2_;
	_tmp3_ = vtg_utils_get_image_path ("element-field-16.png");
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_pixbuf_new_from_file (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_field);
	vtg_utils_icon_field = _tmp7_;
	_tmp8_ = vtg_utils_get_image_path ("element-method-16.png");
	_tmp9_ = _tmp8_;
	_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_, &_inner_error_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_method);
	vtg_utils_icon_method = _tmp12_;
	_tmp13_ = vtg_utils_get_image_path ("element-class-16.png");
	_tmp14_ = _tmp13_;
	_tmp15_ = gdk_pixbuf_new_from_file (_tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_class);
	vtg_utils_icon_class = _tmp17_;
	_tmp18_ = vtg_utils_get_image_path ("element-structure-16.png");
	_tmp19_ = _tmp18_;
	_tmp20_ = gdk_pixbuf_new_from_file (_tmp19_, &_inner_error_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp22_ = _tmp21_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_struct);
	vtg_utils_icon_struct = _tmp22_;
	_tmp23_ = vtg_utils_get_image_path ("element-property-16.png");
	_tmp24_ = _tmp23_;
	_tmp25_ = gdk_pixbuf_new_from_file (_tmp24_, &_inner_error_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	_tmp27_ = _tmp26_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_property);
	vtg_utils_icon_property = _tmp27_;
	_tmp28_ = vtg_utils_get_image_path ("element-event-16.png");
	_tmp29_ = _tmp28_;
	_tmp30_ = gdk_pixbuf_new_from_file (_tmp29_, &_inner_error_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	_tmp32_ = _tmp31_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_signal);
	vtg_utils_icon_signal = _tmp32_;
	_tmp33_ = vtg_utils_get_image_path ("element-interface-16.png");
	_tmp34_ = _tmp33_;
	_tmp35_ = gdk_pixbuf_new_from_file (_tmp34_, &_inner_error_);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	_tmp37_ = _tmp36_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_iface);
	vtg_utils_icon_iface = _tmp37_;
	_tmp38_ = vtg_utils_get_image_path ("element-enumeration-16.png");
	_tmp39_ = _tmp38_;
	_tmp40_ = gdk_pixbuf_new_from_file (_tmp39_, &_inner_error_);
	_tmp41_ = _tmp40_;
	_g_free0 (_tmp39_);
	_tmp42_ = _tmp41_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_enum);
	vtg_utils_icon_enum = _tmp42_;
	_tmp43_ = vtg_utils_get_image_path ("element-literal-16.png");
	_tmp44_ = _tmp43_;
	_tmp45_ = gdk_pixbuf_new_from_file (_tmp44_, &_inner_error_);
	_tmp46_ = _tmp45_;
	_g_free0 (_tmp44_);
	_tmp47_ = _tmp46_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_const);
	vtg_utils_icon_const = _tmp47_;
	_tmp48_ = vtg_utils_get_image_path ("element-namespace-16.png");
	_tmp49_ = _tmp48_;
	_tmp50_ = gdk_pixbuf_new_from_file (_tmp49_, &_inner_error_);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	_tmp52_ = _tmp51_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_namespace);
	vtg_utils_icon_namespace = _tmp52_;
	_tmp53_ = vtg_utils_get_image_path ("project-16.png");
	_tmp54_ = _tmp53_;
	_tmp55_ = gdk_pixbuf_new_from_file (_tmp54_, &_inner_error_);
	_tmp56_ = _tmp55_;
	_g_free0 (_tmp54_);
	_tmp57_ = _tmp56_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project);
	vtg_utils_icon_project = _tmp57_;
	_tmp58_ = vtg_utils_get_image_path ("project-reference-folder-16.png");
	_tmp59_ = _tmp58_;
	_tmp60_ = gdk_pixbuf_new_from_file (_tmp59_, &_inner_error_);
	_tmp61_ = _tmp60_;
	_g_free0 (_tmp59_);
	_tmp62_ = _tmp61_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_folder_packages);
	vtg_utils_icon_folder_packages = _tmp62_;
	_tmp63_ = vtg_utils_get_image_path ("package-16.png");
	_tmp64_ = _tmp63_;
	_tmp65_ = gdk_pixbuf_new_from_file (_tmp64_, &_inner_error_);
	_tmp66_ = _tmp65_;
	_g_free0 (_tmp64_);
	_tmp67_ = _tmp66_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_package);
	vtg_utils_icon_package = _tmp67_;
	_tmp68_ = vtg_utils_get_image_path ("project-library-16.png");
	_tmp69_ = _tmp68_;
	_tmp70_ = gdk_pixbuf_new_from_file (_tmp69_, &_inner_error_);
	_tmp71_ = _tmp70_;
	_g_free0 (_tmp69_);
	_tmp72_ = _tmp71_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_library_16);
	vtg_utils_icon_project_library_16 = _tmp72_;
	_tmp73_ = vtg_utils_get_image_path ("project-library-22.png");
	_tmp74_ = _tmp73_;
	_tmp75_ = gdk_pixbuf_new_from_file (_tmp74_, &_inner_error_);
	_tmp76_ = _tmp75_;
	_g_free0 (_tmp74_);
	_tmp77_ = _tmp76_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_library_22);
	vtg_utils_icon_project_library_22 = _tmp77_;
	_tmp78_ = vtg_utils_get_image_path ("project-unknown-16.png");
	_tmp79_ = _tmp78_;
	_tmp80_ = gdk_pixbuf_new_from_file (_tmp79_, &_inner_error_);
	_tmp81_ = _tmp80_;
	_g_free0 (_tmp79_);
	_tmp82_ = _tmp81_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_unknown_16);
	vtg_utils_icon_project_unknown_16 = _tmp82_;
	_tmp83_ = vtg_utils_get_image_path ("project-unknown-22.png");
	_tmp84_ = _tmp83_;
	_tmp85_ = gdk_pixbuf_new_from_file (_tmp84_, &_inner_error_);
	_tmp86_ = _tmp85_;
	_g_free0 (_tmp84_);
	_tmp87_ = _tmp86_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_unknown_22);
	vtg_utils_icon_project_unknown_22 = _tmp87_;
	_tmp88_ = vtg_utils_get_image_path ("project-data-16.png");
	_tmp89_ = _tmp88_;
	_tmp90_ = gdk_pixbuf_new_from_file (_tmp89_, &_inner_error_);
	_tmp91_ = _tmp90_;
	_g_free0 (_tmp89_);
	_tmp92_ = _tmp91_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_data_16);
	vtg_utils_icon_project_data_16 = _tmp92_;
	_tmp93_ = vtg_utils_get_image_path ("project-data-22.png");
	_tmp94_ = _tmp93_;
	_tmp95_ = gdk_pixbuf_new_from_file (_tmp94_, &_inner_error_);
	_tmp96_ = _tmp95_;
	_g_free0 (_tmp94_);
	_tmp97_ = _tmp96_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_data_22);
	vtg_utils_icon_project_data_22 = _tmp97_;
	_tmp98_ = gtk_icon_theme_get_default ();
	_tmp99_ = gtk_icon_theme_load_icon (_tmp98_, GTK_STOCK_EXECUTE, 16, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error_);
	_tmp100_ = _tmp99_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_executable_16);
	vtg_utils_icon_project_executable_16 = _tmp100_;
	_tmp101_ = gtk_icon_theme_get_default ();
	_tmp102_ = gtk_icon_theme_load_icon (_tmp101_, GTK_STOCK_EXECUTE, 22, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error_);
	_tmp103_ = _tmp102_;
	if (_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	_g_object_unref0 (vtg_utils_icon_project_executable_22);
	vtg_utils_icon_project_executable_22 = _tmp103_;
	vtg_utils__initialized = TRUE;
	goto __finally56;
	__catch56_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgutils.vala:486: %s", err->message);
		_g_error_free0 (err);
	}
	__finally56:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vtg_utils_get_available_packages (void) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	if (vtg_utils__available_packages == NULL) {
		vtg_utils_initialize_packages_cache ();
	}
	_tmp0_ = _vala_iterable_ref0 (vtg_utils__available_packages);
	result = _tmp0_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void vtg_utils_initialize_packages_cache (void) {
	GList* vapidirs;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaArrayList* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	vapidirs = NULL;
	_tmp0_ = g_strdup (VALA_VAPIDIR);
	vapidirs = g_list_append (vapidirs, _tmp0_);
	_tmp1_ = g_strdup ("/usr/local/share/vala/vapi");
	vapidirs = g_list_append (vapidirs, _tmp1_);
	_tmp2_ = vala_array_list_new (VBF_TYPE_PACKAGE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	_vala_iterable_unref0 (vtg_utils__available_packages);
	vtg_utils__available_packages = (ValaList*) _tmp2_;
	{
		GList* vapidir_collection;
		GList* vapidir_it;
		vapidir_collection = vapidirs;
		for (vapidir_it = vapidir_collection; vapidir_it != NULL; vapidir_it = vapidir_it->next) {
			gchar* _tmp3_;
			gchar* vapidir;
			_tmp3_ = g_strdup ((const gchar*) vapidir_it->data);
			vapidir = _tmp3_;
			{
				GDir* dir = NULL;
				GDir* _tmp4_ = NULL;
				GDir* _tmp5_;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* filename;
				_tmp4_ = g_dir_open (vapidir, (guint) 0, &_inner_error_);
				_tmp5_ = _tmp4_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch57_g_file_error;
					}
					_g_dir_close0 (dir);
					_g_free0 (vapidir);
					__g_list_free__g_free0_0 (vapidirs);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_dir_close0 (dir);
				dir = _tmp5_;
				goto __finally57;
				__catch57_g_file_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
					_g_dir_close0 (dir);
					_g_free0 (vapidir);
					continue;
				}
				__finally57:
				if (_inner_error_ != NULL) {
					_g_dir_close0 (dir);
					_g_free0 (vapidir);
					__g_list_free__g_free0_0 (vapidirs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp6_ = g_dir_read_name (dir);
				_tmp7_ = g_strdup (_tmp6_);
				filename = _tmp7_;
				while (TRUE) {
					gboolean _tmp8_;
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					if (!(filename != NULL)) {
						break;
					}
					_tmp8_ = g_str_has_suffix (filename, ".vapi");
					if (_tmp8_) {
						gchar* _tmp9_ = NULL;
						gint _tmp10_;
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						VbfPackage* _tmp13_ = NULL;
						VbfPackage* _tmp14_;
						_tmp9_ = g_utf8_strdown (filename, (gssize) (-1));
						_g_free0 (filename);
						filename = _tmp9_;
						_tmp10_ = strlen (filename);
						_tmp11_ = string_substring (filename, (glong) 0, (glong) (_tmp10_ - 5));
						_tmp12_ = _tmp11_;
						_tmp13_ = vbf_package_new (_tmp12_);
						_tmp14_ = _tmp13_;
						vala_collection_add ((ValaCollection*) vtg_utils__available_packages, _tmp14_);
						_g_object_unref0 (_tmp14_);
						_g_free0 (_tmp12_);
					}
					_tmp15_ = g_dir_read_name (dir);
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (filename);
					filename = _tmp16_;
				}
				_g_free0 (filename);
				_g_dir_close0 (dir);
				_g_free0 (vapidir);
			}
		}
	}
	__g_list_free__g_free0_0 (vapidirs);
}


GdkPixbuf* vtg_utils_get_icon_for_type_name (AfroditeMemberType type) {
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp27_;
	if (!vtg_utils__initialized) {
		vtg_utils_initialize ();
	}
	if (vtg_utils_icon_namespace != NULL) {
		_tmp0_ = type == AFRODITE_MEMBER_TYPE_NAMESPACE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkPixbuf* _tmp1_;
		_tmp1_ = _g_object_ref0 (vtg_utils_icon_namespace);
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		if (vtg_utils_icon_class != NULL) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			if (type == AFRODITE_MEMBER_TYPE_CLASS) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = type == AFRODITE_MEMBER_TYPE_CREATION_METHOD;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = type == AFRODITE_MEMBER_TYPE_DESTRUCTOR;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = type == AFRODITE_MEMBER_TYPE_CONSTRUCTOR;
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = type == AFRODITE_MEMBER_TYPE_ERROR_DOMAIN;
			}
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GdkPixbuf* _tmp7_;
			_tmp7_ = _g_object_ref0 (vtg_utils_icon_class);
			result = _tmp7_;
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			if (vtg_utils_icon_struct != NULL) {
				_tmp8_ = type == AFRODITE_MEMBER_TYPE_STRUCT;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GdkPixbuf* _tmp9_;
				_tmp9_ = _g_object_ref0 (vtg_utils_icon_struct);
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				if (vtg_utils_icon_iface != NULL) {
					_tmp10_ = type == AFRODITE_MEMBER_TYPE_INTERFACE;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					GdkPixbuf* _tmp11_;
					_tmp11_ = _g_object_ref0 (vtg_utils_icon_iface);
					result = _tmp11_;
					return result;
				} else {
					gboolean _tmp12_ = FALSE;
					if (vtg_utils_icon_field != NULL) {
						_tmp12_ = type == AFRODITE_MEMBER_TYPE_FIELD;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						GdkPixbuf* _tmp13_;
						_tmp13_ = _g_object_ref0 (vtg_utils_icon_field);
						result = _tmp13_;
						return result;
					} else {
						gboolean _tmp14_ = FALSE;
						if (vtg_utils_icon_property != NULL) {
							_tmp14_ = type == AFRODITE_MEMBER_TYPE_PROPERTY;
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							GdkPixbuf* _tmp15_;
							_tmp15_ = _g_object_ref0 (vtg_utils_icon_property);
							result = _tmp15_;
							return result;
						} else {
							gboolean _tmp16_ = FALSE;
							if (vtg_utils_icon_method != NULL) {
								gboolean _tmp17_ = FALSE;
								if (type == AFRODITE_MEMBER_TYPE_METHOD) {
									_tmp17_ = TRUE;
								} else {
									_tmp17_ = type == AFRODITE_MEMBER_TYPE_DELEGATE;
								}
								_tmp16_ = _tmp17_;
							} else {
								_tmp16_ = FALSE;
							}
							if (_tmp16_) {
								GdkPixbuf* _tmp18_;
								_tmp18_ = _g_object_ref0 (vtg_utils_icon_method);
								result = _tmp18_;
								return result;
							} else {
								gboolean _tmp19_ = FALSE;
								if (vtg_utils_icon_enum != NULL) {
									_tmp19_ = type == AFRODITE_MEMBER_TYPE_ENUM;
								} else {
									_tmp19_ = FALSE;
								}
								if (_tmp19_) {
									GdkPixbuf* _tmp20_;
									_tmp20_ = _g_object_ref0 (vtg_utils_icon_enum);
									result = _tmp20_;
									return result;
								} else {
									gboolean _tmp21_ = FALSE;
									if (vtg_utils_icon_const != NULL) {
										gboolean _tmp22_ = FALSE;
										gboolean _tmp23_ = FALSE;
										if (type == AFRODITE_MEMBER_TYPE_CONSTANT) {
											_tmp23_ = TRUE;
										} else {
											_tmp23_ = type == AFRODITE_MEMBER_TYPE_ENUM_VALUE;
										}
										if (_tmp23_) {
											_tmp22_ = TRUE;
										} else {
											_tmp22_ = type == AFRODITE_MEMBER_TYPE_ERROR_CODE;
										}
										_tmp21_ = _tmp22_;
									} else {
										_tmp21_ = FALSE;
									}
									if (_tmp21_) {
										GdkPixbuf* _tmp24_;
										_tmp24_ = _g_object_ref0 (vtg_utils_icon_const);
										result = _tmp24_;
										return result;
									} else {
										gboolean _tmp25_ = FALSE;
										if (vtg_utils_icon_signal != NULL) {
											_tmp25_ = type == AFRODITE_MEMBER_TYPE_SIGNAL;
										} else {
											_tmp25_ = FALSE;
										}
										if (_tmp25_) {
											GdkPixbuf* _tmp26_;
											_tmp26_ = _g_object_ref0 (vtg_utils_icon_signal);
											result = _tmp26_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp27_ = _g_object_ref0 (vtg_utils_icon_generic);
	result = _tmp27_;
	return result;
}


gchar* vtg_utils_get_stock_id_for_target_type_to_delete (VbfTargetTypes type) {
	gchar* result = NULL;
	switch (type) {
		case VBF_TARGET_TYPES_PROGRAM:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp0_;
			return result;
		}
		case VBF_TARGET_TYPES_LIBRARY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp1_;
			return result;
		}
		case VBF_TARGET_TYPES_DATA:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_DIRECTORY);
			result = _tmp2_;
			return result;
		}
		case VBF_TARGET_TYPES_BUILT_SOURCES:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (GTK_STOCK_DIRECTORY);
			result = _tmp4_;
			return result;
		}
	}
}


GdkPixbuf* vtg_utils_get_small_icon_for_target_type (VbfTargetTypes type) {
	GdkPixbuf* result = NULL;
	switch (type) {
		case VBF_TARGET_TYPES_PROGRAM:
		{
			GdkPixbuf* _tmp0_;
			_tmp0_ = _g_object_ref0 (vtg_utils_icon_project_executable_16);
			result = _tmp0_;
			return result;
		}
		case VBF_TARGET_TYPES_LIBRARY:
		{
			GdkPixbuf* _tmp1_;
			_tmp1_ = _g_object_ref0 (vtg_utils_icon_project_library_16);
			result = _tmp1_;
			return result;
		}
		case VBF_TARGET_TYPES_DATA:
		{
			GdkPixbuf* _tmp2_;
			_tmp2_ = _g_object_ref0 (vtg_utils_icon_project_data_16);
			result = _tmp2_;
			return result;
		}
		case VBF_TARGET_TYPES_BUILT_SOURCES:
		{
			GdkPixbuf* _tmp3_;
			_tmp3_ = _g_object_ref0 (vtg_utils_icon_project_executable_16);
			result = _tmp3_;
			return result;
		}
		default:
		{
			GdkPixbuf* _tmp4_;
			_tmp4_ = _g_object_ref0 (vtg_utils_icon_project_unknown_16);
			result = _tmp4_;
			return result;
		}
	}
}


GdkPixbuf* vtg_utils_get_big_icon_for_target_type (VbfTargetTypes type) {
	GdkPixbuf* result = NULL;
	switch (type) {
		case VBF_TARGET_TYPES_PROGRAM:
		{
			GdkPixbuf* _tmp0_;
			_tmp0_ = _g_object_ref0 (vtg_utils_icon_project_executable_22);
			result = _tmp0_;
			return result;
		}
		case VBF_TARGET_TYPES_LIBRARY:
		{
			GdkPixbuf* _tmp1_;
			_tmp1_ = _g_object_ref0 (vtg_utils_icon_project_library_22);
			result = _tmp1_;
			return result;
		}
		case VBF_TARGET_TYPES_DATA:
		{
			GdkPixbuf* _tmp2_;
			_tmp2_ = _g_object_ref0 (vtg_utils_icon_project_data_22);
			result = _tmp2_;
			return result;
		}
		case VBF_TARGET_TYPES_BUILT_SOURCES:
		{
			GdkPixbuf* _tmp3_;
			_tmp3_ = _g_object_ref0 (vtg_utils_icon_project_executable_22);
			result = _tmp3_;
			return result;
		}
		default:
		{
			GdkPixbuf* _tmp4_;
			_tmp4_ = _g_object_ref0 (vtg_utils_icon_project_unknown_22);
			result = _tmp4_;
			return result;
		}
	}
}


gint vtg_utils_symbol_type_compare (AfroditeSymbol* vala, AfroditeSymbol* valb) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	AfroditeMemberType _tmp3_;
	AfroditeMemberType _tmp4_;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gint _tmp33_;
	if (vala == NULL) {
		_tmp0_ = valb == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (vala == NULL) {
			_tmp1_ = valb != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = 1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (vala != NULL) {
				_tmp2_ = valb == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = -1;
				return result;
			}
		}
	}
	_tmp3_ = afrodite_symbol_get_member_type (vala);
	_tmp4_ = afrodite_symbol_get_member_type (valb);
	if (_tmp3_ != _tmp4_) {
		AfroditeMemberType _tmp5_;
		_tmp5_ = afrodite_symbol_get_member_type (vala);
		if (_tmp5_ == AFRODITE_MEMBER_TYPE_CONSTANT) {
			result = -1;
			return result;
		} else {
			AfroditeMemberType _tmp6_;
			_tmp6_ = afrodite_symbol_get_member_type (valb);
			if (_tmp6_ == AFRODITE_MEMBER_TYPE_CONSTANT) {
				result = 1;
				return result;
			} else {
				AfroditeMemberType _tmp7_;
				_tmp7_ = afrodite_symbol_get_member_type (vala);
				if (_tmp7_ == AFRODITE_MEMBER_TYPE_ENUM) {
					result = -1;
					return result;
				} else {
					AfroditeMemberType _tmp8_;
					_tmp8_ = afrodite_symbol_get_member_type (valb);
					if (_tmp8_ == AFRODITE_MEMBER_TYPE_ENUM) {
						result = 1;
						return result;
					} else {
						AfroditeMemberType _tmp9_;
						_tmp9_ = afrodite_symbol_get_member_type (vala);
						if (_tmp9_ == AFRODITE_MEMBER_TYPE_FIELD) {
							result = -1;
							return result;
						} else {
							AfroditeMemberType _tmp10_;
							_tmp10_ = afrodite_symbol_get_member_type (valb);
							if (_tmp10_ == AFRODITE_MEMBER_TYPE_FIELD) {
								result = 1;
								return result;
							} else {
								AfroditeMemberType _tmp11_;
								_tmp11_ = afrodite_symbol_get_member_type (vala);
								if (_tmp11_ == AFRODITE_MEMBER_TYPE_PROPERTY) {
									result = -1;
									return result;
								} else {
									AfroditeMemberType _tmp12_;
									_tmp12_ = afrodite_symbol_get_member_type (valb);
									if (_tmp12_ == AFRODITE_MEMBER_TYPE_PROPERTY) {
										result = 1;
										return result;
									} else {
										AfroditeMemberType _tmp13_;
										_tmp13_ = afrodite_symbol_get_member_type (vala);
										if (_tmp13_ == AFRODITE_MEMBER_TYPE_SIGNAL) {
											result = -1;
											return result;
										} else {
											AfroditeMemberType _tmp14_;
											_tmp14_ = afrodite_symbol_get_member_type (valb);
											if (_tmp14_ == AFRODITE_MEMBER_TYPE_SIGNAL) {
												result = 1;
												return result;
											} else {
												AfroditeMemberType _tmp15_;
												_tmp15_ = afrodite_symbol_get_member_type (vala);
												if (_tmp15_ == AFRODITE_MEMBER_TYPE_CREATION_METHOD) {
													result = -1;
													return result;
												} else {
													AfroditeMemberType _tmp16_;
													_tmp16_ = afrodite_symbol_get_member_type (valb);
													if (_tmp16_ == AFRODITE_MEMBER_TYPE_CREATION_METHOD) {
														result = 1;
														return result;
													} else {
														AfroditeMemberType _tmp17_;
														_tmp17_ = afrodite_symbol_get_member_type (vala);
														if (_tmp17_ == AFRODITE_MEMBER_TYPE_CONSTRUCTOR) {
															result = -1;
															return result;
														} else {
															AfroditeMemberType _tmp18_;
															_tmp18_ = afrodite_symbol_get_member_type (valb);
															if (_tmp18_ == AFRODITE_MEMBER_TYPE_CONSTRUCTOR) {
																result = 1;
																return result;
															} else {
																AfroditeMemberType _tmp19_;
																_tmp19_ = afrodite_symbol_get_member_type (vala);
																if (_tmp19_ == AFRODITE_MEMBER_TYPE_METHOD) {
																	result = -1;
																	return result;
																} else {
																	AfroditeMemberType _tmp20_;
																	_tmp20_ = afrodite_symbol_get_member_type (valb);
																	if (_tmp20_ == AFRODITE_MEMBER_TYPE_METHOD) {
																		result = 1;
																		return result;
																	} else {
																		AfroditeMemberType _tmp21_;
																		_tmp21_ = afrodite_symbol_get_member_type (vala);
																		if (_tmp21_ == AFRODITE_MEMBER_TYPE_ERROR_DOMAIN) {
																			result = -1;
																			return result;
																		} else {
																			AfroditeMemberType _tmp22_;
																			_tmp22_ = afrodite_symbol_get_member_type (valb);
																			if (_tmp22_ == AFRODITE_MEMBER_TYPE_ERROR_DOMAIN) {
																				result = 1;
																				return result;
																			} else {
																				AfroditeMemberType _tmp23_;
																				_tmp23_ = afrodite_symbol_get_member_type (vala);
																				if (_tmp23_ == AFRODITE_MEMBER_TYPE_NAMESPACE) {
																					result = -1;
																					return result;
																				} else {
																					AfroditeMemberType _tmp24_;
																					_tmp24_ = afrodite_symbol_get_member_type (valb);
																					if (_tmp24_ == AFRODITE_MEMBER_TYPE_NAMESPACE) {
																						result = 1;
																						return result;
																					} else {
																						AfroditeMemberType _tmp25_;
																						_tmp25_ = afrodite_symbol_get_member_type (vala);
																						if (_tmp25_ == AFRODITE_MEMBER_TYPE_STRUCT) {
																							result = -1;
																							return result;
																						} else {
																							AfroditeMemberType _tmp26_;
																							_tmp26_ = afrodite_symbol_get_member_type (valb);
																							if (_tmp26_ == AFRODITE_MEMBER_TYPE_STRUCT) {
																								result = 1;
																								return result;
																							} else {
																								AfroditeMemberType _tmp27_;
																								_tmp27_ = afrodite_symbol_get_member_type (vala);
																								if (_tmp27_ == AFRODITE_MEMBER_TYPE_CLASS) {
																									result = -1;
																									return result;
																								} else {
																									AfroditeMemberType _tmp28_;
																									_tmp28_ = afrodite_symbol_get_member_type (valb);
																									if (_tmp28_ == AFRODITE_MEMBER_TYPE_CLASS) {
																										result = 1;
																										return result;
																									} else {
																										AfroditeMemberType _tmp29_;
																										_tmp29_ = afrodite_symbol_get_member_type (vala);
																										if (_tmp29_ == AFRODITE_MEMBER_TYPE_INTERFACE) {
																											result = -1;
																											return result;
																										} else {
																											AfroditeMemberType _tmp30_;
																											_tmp30_ = afrodite_symbol_get_member_type (valb);
																											if (_tmp30_ == AFRODITE_MEMBER_TYPE_INTERFACE) {
																												result = 1;
																												return result;
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp31_ = afrodite_symbol_get_name (vala);
	_tmp32_ = afrodite_symbol_get_name (valb);
	_tmp33_ = g_strcmp0 (_tmp31_, _tmp32_);
	result = _tmp33_;
	return result;
}


VtgUtils* vtg_utils_construct (GType object_type) {
	VtgUtils * self = NULL;
	self = (VtgUtils*) g_object_new (object_type, NULL);
	return self;
}


VtgUtils* vtg_utils_new (void) {
	return vtg_utils_construct (VTG_TYPE_UTILS);
}


static void vtg_utils_class_init (VtgUtilsClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_ = NULL;
	vtg_utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vtg_utils_finalize;
	_tmp0_ = g_strdup ("var");
	_tmp1_ = g_strdup ("out");
	_tmp2_ = g_strdup ("ref");
	_tmp3_ = g_strdup ("const");
	_tmp4_ = g_strdup ("static");
	_tmp5_ = g_strdup ("inline");
	_tmp6_ = g_strdup ("readonly");
	_tmp7_ = g_strdup ("async");
	_tmp8_ = g_strdup ("abstract");
	_tmp9_ = g_strdup ("public");
	_tmp10_ = g_strdup ("protected");
	_tmp11_ = g_strdup ("private");
	_tmp12_ = g_strdup ("internal");
	_tmp13_ = g_strdup ("this");
	_tmp14_ = g_strdup ("base");
	_tmp15_ = g_strdup ("if");
	_tmp16_ = g_strdup ("while");
	_tmp17_ = g_strdup ("do");
	_tmp18_ = g_strdup ("else");
	_tmp19_ = g_strdup ("return");
	_tmp20_ = g_strdup ("try");
	_tmp21_ = g_strdup ("catch");
	_tmp22_ = g_strdup ("class");
	_tmp23_ = g_strdup ("struct");
	_tmp24_ = g_strdup ("interface");
	_tmp25_ = g_strdup ("enum");
	_tmp26_ = g_strdup ("signal");
	_tmp27_ = g_strdup ("delegate");
	_tmp28_ = g_new0 (gchar*, 28 + 1);
	_tmp28_[0] = _tmp0_;
	_tmp28_[1] = _tmp1_;
	_tmp28_[2] = _tmp2_;
	_tmp28_[3] = _tmp3_;
	_tmp28_[4] = _tmp4_;
	_tmp28_[5] = _tmp5_;
	_tmp28_[6] = _tmp6_;
	_tmp28_[7] = _tmp7_;
	_tmp28_[8] = _tmp8_;
	_tmp28_[9] = _tmp9_;
	_tmp28_[10] = _tmp10_;
	_tmp28_[11] = _tmp11_;
	_tmp28_[12] = _tmp12_;
	_tmp28_[13] = _tmp13_;
	_tmp28_[14] = _tmp14_;
	_tmp28_[15] = _tmp15_;
	_tmp28_[16] = _tmp16_;
	_tmp28_[17] = _tmp17_;
	_tmp28_[18] = _tmp18_;
	_tmp28_[19] = _tmp19_;
	_tmp28_[20] = _tmp20_;
	_tmp28_[21] = _tmp21_;
	_tmp28_[22] = _tmp22_;
	_tmp28_[23] = _tmp23_;
	_tmp28_[24] = _tmp24_;
	_tmp28_[25] = _tmp25_;
	_tmp28_[26] = _tmp26_;
	_tmp28_[27] = _tmp27_;
	vtg_utils__vala_keywords = _tmp28_;
	vtg_utils__vala_keywords_length1 = 28;
}


static void vtg_utils_instance_init (VtgUtils * self) {
}


static void vtg_utils_finalize (GObject* obj) {
	VtgUtils * self;
	self = VTG_UTILS (obj);
	G_OBJECT_CLASS (vtg_utils_parent_class)->finalize (obj);
}


GType vtg_utils_get_type (void) {
	return vtg_utils_type_id;
}


GType vtg_utils_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgUtils), 0, (GInstanceInitFunc) vtg_utils_instance_init, NULL };
	vtg_utils_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgUtils", &g_define_type_info, 0);
	return vtg_utils_type_id;
}


/**
 * Utility method to get the text from the start iter
 * to the end of line.
 *
 * @param start start iter from which start to get the text (this iter will not be modified)
 * @return the text from the start iter to the end of line or an empty string if the iter is already on the line end.
 */
gchar* vtg_parser_utils_get_line_to_end (GtkTextIter* start) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* text;
	GtkTextIter end;
	gboolean _tmp1_;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	end = *start;
	gtk_text_iter_set_line_offset (&end, 0);
	_tmp1_ = gtk_text_iter_forward_to_line_end (&end);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = gtk_text_iter_get_text (start, &end);
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (text);
		text = _tmp3_;
	}
	result = text;
	return result;
}


void vtg_parser_utils_parse_line (const gchar* line, gchar** token, gboolean* is_assignment, gboolean* is_creation, gboolean* is_declaration) {
	gchar* _token = NULL;
	gboolean _is_assignment = FALSE;
	gboolean _is_creation = FALSE;
	gboolean _is_declaration = FALSE;
	gchar* _tmp0_;
	gint _tmp1_;
	gint i;
	gchar* tok = NULL;
	gint count;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (line != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (_token);
	_token = _tmp0_;
	_is_assignment = FALSE;
	_is_creation = FALSE;
	_is_declaration = FALSE;
	_tmp1_ = strlen (line);
	i = ((gint) _tmp1_) - 1;
	count = 0;
	_tmp2_ = vtg_parser_utils_get_token (line, &i);
	_g_free0 (_token);
	_token = _tmp2_;
	if (_token != NULL) {
		gchar* _tmp3_;
		gchar* last_token;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp14_;
		count = 1;
		_tmp3_ = g_strdup (_token);
		last_token = _tmp3_;
		while (TRUE) {
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = vtg_parser_utils_get_token (line, &i);
			_g_free0 (tok);
			tok = _tmp4_;
			if (!(tok != NULL)) {
				break;
			}
			count++;
			if (g_strcmp0 (tok, "=") == 0) {
				_is_assignment = TRUE;
			} else {
				if (g_strcmp0 (tok, "new") == 0) {
					_is_creation = TRUE;
				}
			}
			_tmp5_ = g_strdup (tok);
			_g_free0 (last_token);
			last_token = _tmp5_;
		}
		if (!_is_assignment) {
			_tmp7_ = !_is_creation;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = count == 2;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gboolean _tmp8_ = FALSE;
			if (g_strcmp0 (last_token, "var") == 0) {
				_tmp8_ = TRUE;
			} else {
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_;
				_tmp11_ = vtg_utils_is_vala_keyword (last_token);
				if (!_tmp11_) {
					gboolean _tmp12_;
					_tmp12_ = g_str_has_prefix (last_token, "\"");
					_tmp10_ = !_tmp12_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gboolean _tmp13_;
					_tmp13_ = g_str_has_prefix (last_token, "'");
					_tmp9_ = !_tmp13_;
				} else {
					_tmp9_ = FALSE;
				}
				_tmp8_ = _tmp9_;
			}
			if (_tmp8_) {
				_is_declaration = TRUE;
			}
		}
		_tmp14_ = g_str_has_suffix (_token, ".");
		if (_tmp14_) {
			gint _tmp15_;
			gchar* _tmp16_ = NULL;
			_tmp15_ = strlen (_token);
			_tmp16_ = string_substring (_token, (glong) 0, (glong) (_tmp15_ - 1));
			_g_free0 (_token);
			_token = _tmp16_;
		}
		_g_free0 (last_token);
	}
	vtg_utils_trace ("vtgutils.vala:735: parse line new: '%s'. is_assignment: %d is_creation" \
": %d is_declaration: %d token: '%s'", line, (gint) _is_assignment, (gint) _is_creation, (gint) _is_declaration, _token);
	_g_free0 (tok);
	if (token) {
		*token = _token;
	} else {
		_g_free0 (_token);
	}
	if (is_assignment) {
		*is_assignment = _is_assignment;
	}
	if (is_creation) {
		*is_creation = _is_creation;
	}
	if (is_declaration) {
		*is_declaration = _is_declaration;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


gchar* vtg_parser_utils_get_token (const gchar* line, gint* i) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* tok;
	gint skip_lev;
	gboolean in_string;
	gboolean should_skip_spaces;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = g_strdup ("");
	tok = _tmp0_;
	skip_lev = 0;
	in_string = FALSE;
	should_skip_spaces = TRUE;
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp3_;
		_tmp1_ = vtg_parser_utils_is_eof (line, *i);
		if (!(!_tmp1_)) {
			break;
		}
		if (should_skip_spaces) {
			gint _tmp2_;
			_tmp2_ = vtg_parser_utils_skip_spaces (line, *i);
			*i = _tmp2_;
			should_skip_spaces = FALSE;
		}
		_tmp3_ = vtg_parser_utils_is_eof (line, *i);
		if (!_tmp3_) {
			gchar _tmp4_;
			gunichar ch;
			_tmp4_ = string_get (line, (glong) (*i));
			ch = (gunichar) _tmp4_;
			if (skip_lev == 0) {
				gboolean _tmp5_ = FALSE;
				if (ch == '"') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = ch == '\'';
				}
				if (_tmp5_) {
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = g_unichar_to_string (ch);
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strconcat (_tmp7_, tok, NULL);
					_g_free0 (tok);
					tok = _tmp8_;
					_g_free0 (_tmp7_);
					if (!in_string) {
						in_string = TRUE;
					} else {
						in_string = FALSE;
					}
				} else {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					if (ch == '_') {
						_tmp11_ = TRUE;
					} else {
						_tmp11_ = ch == '.';
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						gboolean _tmp12_ = FALSE;
						gint _tmp13_;
						_tmp13_ = strlen (tok);
						if (_tmp13_ == 0) {
							gboolean _tmp14_;
							_tmp14_ = g_unichar_isalpha (ch);
							_tmp12_ = _tmp14_;
						} else {
							_tmp12_ = FALSE;
						}
						_tmp10_ = _tmp12_;
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						gboolean _tmp15_ = FALSE;
						gint _tmp16_;
						_tmp16_ = strlen (tok);
						if (_tmp16_ > 0) {
							gboolean _tmp17_;
							_tmp17_ = g_unichar_isalnum (ch);
							_tmp15_ = _tmp17_;
						} else {
							_tmp15_ = FALSE;
						}
						_tmp9_ = _tmp15_;
					}
					if (_tmp9_) {
						gchar* _tmp18_ = NULL;
						gchar* _tmp19_;
						gchar* _tmp20_;
						_tmp18_ = g_unichar_to_string (ch);
						_tmp19_ = _tmp18_;
						_tmp20_ = g_strconcat (_tmp19_, tok, NULL);
						_g_free0 (tok);
						tok = _tmp20_;
						_g_free0 (_tmp19_);
					} else {
						gboolean _tmp21_ = FALSE;
						gboolean _tmp22_ = FALSE;
						gboolean _tmp23_ = FALSE;
						gboolean _tmp24_ = FALSE;
						if (ch == ' ') {
							_tmp24_ = TRUE;
						} else {
							_tmp24_ = ch == '=';
						}
						if (_tmp24_) {
							_tmp23_ = TRUE;
						} else {
							_tmp23_ = ch == '!';
						}
						if (_tmp23_) {
							_tmp22_ = TRUE;
						} else {
							_tmp22_ = ch == '<';
						}
						if (_tmp22_) {
							_tmp21_ = TRUE;
						} else {
							_tmp21_ = ch == '>';
						}
						if (_tmp21_) {
							if (in_string) {
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_;
								gchar* _tmp27_;
								_tmp25_ = g_unichar_to_string (ch);
								_tmp26_ = _tmp25_;
								_tmp27_ = g_strconcat (_tmp26_, tok, NULL);
								_g_free0 (tok);
								tok = _tmp27_;
								_g_free0 (_tmp26_);
							} else {
								break;
							}
						}
					}
				}
			}
			if (!in_string) {
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				if (ch == '(') {
					_tmp29_ = TRUE;
				} else {
					_tmp29_ = ch == '[';
				}
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					_tmp28_ = ch == '{';
				}
				if (_tmp28_) {
					if (skip_lev > 0) {
						skip_lev--;
						if (skip_lev == 0) {
							should_skip_spaces = TRUE;
						}
					} else {
						break;
					}
				} else {
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					if (ch == ')') {
						_tmp31_ = TRUE;
					} else {
						_tmp31_ = ch == ']';
					}
					if (_tmp31_) {
						_tmp30_ = TRUE;
					} else {
						_tmp30_ = ch == '}';
					}
					if (_tmp30_) {
						skip_lev++;
					}
				}
			}
			(*i)--;
		}
	}
	if (g_strcmp0 (tok, "") == 0) {
		_tmp32_ = NULL;
	} else {
		_tmp32_ = tok;
	}
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_free0 (tok);
	return result;
}


gint vtg_parser_utils_skip_spaces (const gchar* line, gint i) {
	gint result = 0;
	gchar _tmp0_;
	gunichar ch;
	g_return_val_if_fail (line != NULL, 0);
	_tmp0_ = string_get (line, (glong) i);
	ch = (gunichar) _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gchar _tmp6_;
		_tmp2_ = vtg_parser_utils_is_eof (line, i);
		if (!_tmp2_) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			if (ch == ' ') {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = ch == '\t';
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp5_;
				_tmp5_ = g_unichar_isspace (ch);
				_tmp3_ = _tmp5_;
			}
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		i--;
		_tmp6_ = string_get (line, (glong) i);
		ch = (gunichar) _tmp6_;
	}
	result = i;
	return result;
}


gboolean vtg_parser_utils_is_eof (const gchar* line, gint i) {
	gboolean result = FALSE;
	g_return_val_if_fail (line != NULL, FALSE);
	result = i < 0;
	return result;
}


GRegex* vtg_language_support_get_using_regex (GeditDocument* doc, GError** error) {
	GRegex* result = NULL;
	AfroditeSourceType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = vtg_utils_get_source_type (doc);
	if (_tmp0_ == AFRODITE_SOURCE_TYPE_GENIE) {
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("^(uses|\\t+|\\s+)(\\w\\S*)\\s*\\n", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp2_;
		return result;
	} else {
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		_tmp3_ = g_regex_new ("^\\s*(using)\\s+(\\w\\S*)\\s*;.*$", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp4_;
		return result;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



