/* vtgchangelog.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgchangelog.vala, do not modify */

/*
 *  vtgchangelog.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vbf.h>
#include <gedit/gedit-tab.h>
#include <gedit/gedit-document.h>
#include <gtk/gtk.h>
#include <libpeas-gtk/peas-gtk.h>
#include <girepository.h>
#include <gmodule.h>
#include <libpeas/peas.h>
#include <time.h>
#include <glib/gi18n-lib.h>


#define VTG_TYPE_CHANGE_LOG (vtg_change_log_get_type ())
#define VTG_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CHANGE_LOG, VtgChangeLog))
#define VTG_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CHANGE_LOG, VtgChangeLogClass))
#define VTG_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CHANGE_LOG))
#define VTG_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CHANGE_LOG))
#define VTG_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CHANGE_LOG, VtgChangeLogClass))

typedef struct _VtgChangeLog VtgChangeLog;
typedef struct _VtgChangeLogClass VtgChangeLogClass;
typedef struct _VtgChangeLogPrivate VtgChangeLogPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())

#define VTG_VCS_BACKENDS_TYPE_VCS_BASE (vtg_vcs_backends_vcs_base_get_type ())
#define VTG_VCS_BACKENDS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBase))
#define VTG_VCS_BACKENDS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))
#define VTG_VCS_BACKENDS_IS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_IS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_VCS_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))

typedef struct _VtgVcsBackendsVcsBase VtgVcsBackendsVcsBase;
typedef struct _VtgVcsBackendsVcsBaseClass VtgVcsBackendsVcsBaseClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_VCS_BACKENDS_TYPE_ITEM (vtg_vcs_backends_item_get_type ())
#define VTG_VCS_BACKENDS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_ITEM, VtgVcsBackendsItem))
#define VTG_VCS_BACKENDS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_ITEM, VtgVcsBackendsItemClass))
#define VTG_VCS_BACKENDS_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_ITEM))
#define VTG_VCS_BACKENDS_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_ITEM))
#define VTG_VCS_BACKENDS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_ITEM, VtgVcsBackendsItemClass))

typedef struct _VtgVcsBackendsItem VtgVcsBackendsItem;
typedef struct _VtgVcsBackendsItemClass VtgVcsBackendsItemClass;
typedef struct _VtgVcsBackendsItemPrivate VtgVcsBackendsItemPrivate;

#define VTG_VCS_BACKENDS_TYPE_STATES (vtg_vcs_backends_states_get_type ())
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))

#define VTG_VCS_BACKENDS_TYPE_GIT (vtg_vcs_backends_git_get_type ())
#define VTG_VCS_BACKENDS_GIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGit))
#define VTG_VCS_BACKENDS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))
#define VTG_VCS_BACKENDS_IS_GIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_IS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_GIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))

typedef struct _VtgVcsBackendsGit VtgVcsBackendsGit;
typedef struct _VtgVcsBackendsGitClass VtgVcsBackendsGitClass;

#define VTG_VCS_BACKENDS_TYPE_BZR (vtg_vcs_backends_bzr_get_type ())
#define VTG_VCS_BACKENDS_BZR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzr))
#define VTG_VCS_BACKENDS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))
#define VTG_VCS_BACKENDS_IS_BZR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_IS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_BZR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))

typedef struct _VtgVcsBackendsBzr VtgVcsBackendsBzr;
typedef struct _VtgVcsBackendsBzrClass VtgVcsBackendsBzrClass;

#define VTG_VCS_BACKENDS_TYPE_SVN (vtg_vcs_backends_svn_get_type ())
#define VTG_VCS_BACKENDS_SVN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvn))
#define VTG_VCS_BACKENDS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))
#define VTG_VCS_BACKENDS_IS_SVN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_IS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_SVN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))

typedef struct _VtgVcsBackendsSvn VtgVcsBackendsSvn;
typedef struct _VtgVcsBackendsSvnClass VtgVcsBackendsSvnClass;

struct _VtgChangeLog {
	GObject parent_instance;
	VtgChangeLogPrivate * priv;
};

struct _VtgChangeLogClass {
	GObjectClass parent_class;
};

struct _VtgChangeLogPrivate {
	VtgPluginInstance* _plugin_instance;
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	gchar* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	gchar* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};

typedef enum  {
	VTG_VCS_BACKENDS_STATES_UNTRACKED,
	VTG_VCS_BACKENDS_STATES_ADDED,
	VTG_VCS_BACKENDS_STATES_MODIFIED,
	VTG_VCS_BACKENDS_STATES_DELETED
} VtgVcsBackendsStates;

struct _VtgVcsBackendsItem {
	GObject parent_instance;
	VtgVcsBackendsItemPrivate * priv;
	gchar* name;
	VtgVcsBackendsStates state;
};

struct _VtgVcsBackendsItemClass {
	GObjectClass parent_class;
};


static gpointer vtg_change_log_parent_class = NULL;
extern VtgPlugin* vtg_plugin_main_instance;
static GType vtg_change_log_type_id = 0;

GType vtg_change_log_get_type (void) G_GNUC_CONST;
GType vtg_change_log_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_CHANGE_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_CHANGE_LOG, VtgChangeLogPrivate))
enum  {
	VTG_CHANGE_LOG_DUMMY_PROPERTY
};
VtgChangeLog* vtg_change_log_new (VtgPluginInstance* plugin_instance);
VtgChangeLog* vtg_change_log_construct (GType object_type, VtgPluginInstance* plugin_instance);
gboolean vtg_change_log_prepare (VtgChangeLog* self, const gchar* file, GError** error);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_vcs_base_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_vcs_base_register_type (GTypeModule * module);
static VtgVcsBackendsVcsBase* vtg_change_log_vcs_backend_factory (VtgChangeLog* self, VtgVcsTypes type);
GType vtg_vcs_backends_item_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_item_register_type (GTypeModule * module);
ValaList* vtg_vcs_backends_vcs_base_get_items (VtgVcsBackendsVcsBase* self, const gchar* path, GError** error);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
GType vtg_vcs_backends_states_get_type (void) G_GNUC_CONST;
GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const gchar* uri, gint line, gint col);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
const gchar* vtg_configuration_get_author (VtgConfiguration* self);
const gchar* vtg_configuration_get_email_address (VtgConfiguration* self);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
VtgVcsBackendsGit* vtg_vcs_backends_git_new (void);
VtgVcsBackendsGit* vtg_vcs_backends_git_construct (GType object_type);
GType vtg_vcs_backends_git_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_git_register_type (GTypeModule * module);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_new (void);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_construct (GType object_type);
GType vtg_vcs_backends_bzr_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_bzr_register_type (GTypeModule * module);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_new (void);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_construct (GType object_type);
GType vtg_vcs_backends_svn_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_svn_register_type (GTypeModule * module);
static void vtg_change_log_finalize (GObject* obj);


VtgChangeLog* vtg_change_log_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgChangeLog * self = NULL;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgChangeLog*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	return self;
}


VtgChangeLog* vtg_change_log_new (VtgPluginInstance* plugin_instance) {
	return vtg_change_log_construct (VTG_TYPE_CHANGE_LOG, plugin_instance);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


gboolean vtg_change_log_prepare (VtgChangeLog* self, const gchar* file, GError** error) {
	gboolean result = FALSE;
	VtgProjectView* _tmp0_ = NULL;
	VtgProjectManager* _tmp1_ = NULL;
	VtgProjectManager* _tmp2_;
	VtgProjectManager* project_manager;
	gchar* _tmp3_;
	gchar* file_list;
	gboolean force_add_new;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vtg_plugin_instance_get_project_view (self->priv->_plugin_instance);
	_tmp1_ = vtg_project_view_get_current_project (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	project_manager = _tmp2_;
	if (project_manager == NULL) {
		result = FALSE;
		_g_object_unref0 (project_manager);
		return result;
	}
	_tmp3_ = g_strdup ("");
	file_list = _tmp3_;
	force_add_new = TRUE;
	if (file != NULL) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = g_strdup_printf ("\t* %s:\n", file);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (file_list, _tmp5_, NULL);
		_g_free0 (file_list);
		file_list = _tmp6_;
		_g_free0 (_tmp5_);
		force_add_new = FALSE;
	} else {
		VtgVcsBackendsVcsBase* _tmp7_ = NULL;
		VtgVcsBackendsVcsBase* backend;
		VbfProject* _tmp8_ = NULL;
		ValaList* _tmp9_ = NULL;
		ValaList* items;
		_tmp7_ = vtg_change_log_vcs_backend_factory (self, project_manager->vcs_type);
		backend = _tmp7_;
		if (backend == NULL) {
			result = FALSE;
			_g_object_unref0 (backend);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return result;
		}
		_tmp8_ = vtg_project_manager_get_project (project_manager);
		_tmp9_ = vtg_vcs_backends_vcs_base_get_items (backend, _tmp8_->working_dir, &_inner_error_);
		items = _tmp9_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (backend);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return FALSE;
		}
		{
			ValaList* _tmp10_;
			ValaList* _item_list;
			gint _tmp11_;
			gint _item_size;
			gint _item_index;
			_tmp10_ = _vala_iterable_ref0 (items);
			_item_list = _tmp10_;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _item_list);
			_item_size = _tmp11_;
			_item_index = -1;
			while (TRUE) {
				gpointer _tmp12_ = NULL;
				VtgVcsBackendsItem* item;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_item_index = _item_index + 1;
				if (!(_item_index < _item_size)) {
					break;
				}
				_tmp12_ = vala_list_get (_item_list, _item_index);
				item = (VtgVcsBackendsItem*) _tmp12_;
				_tmp13_ = g_strdup_printf ("\t* %s:\n", item->name);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (file_list, _tmp14_, NULL);
				_g_free0 (file_list);
				file_list = _tmp15_;
				_g_free0 (_tmp14_);
				_g_object_unref0 (item);
			}
			_vala_iterable_unref0 (_item_list);
		}
		_vala_iterable_unref0 (items);
		_g_object_unref0 (backend);
	}
	if (g_strcmp0 (file_list, "") != 0) {
		GeditTab* _tmp16_ = NULL;
		GeditTab* tab;
		GeditDocument* _tmp17_ = NULL;
		GeditDocument* _tmp18_;
		GeditDocument* doc;
		GMainContext* _tmp19_ = NULL;
		GMainContext* _tmp20_;
		GMainContext* ctx;
		GtkTextIter iter = {0};
		VtgConfiguration* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* author;
		VtgConfiguration* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* email;
		time_t _tmp28_;
		struct tm _tmp29_ = {0};
		struct tm _tmp30_ = {0};
		struct tm today;
		gboolean _tmp31_;
		gboolean _tmp34_;
		gboolean _tmp37_;
		gboolean _tmp40_;
		gchar* _tmp43_ = NULL;
		gchar* date;
		gchar* _tmp44_ = NULL;
		gchar* header;
		gchar* current_header;
		gchar* entry = NULL;
		gint backward_chars_count;
		GtkTextIter _tmp45_ = {0};
		gint _tmp51_;
		GtkTextMark* _tmp52_ = NULL;
		GtkTextMark* mark;
		GtkTextIter _tmp53_ = {0};
		_tmp16_ = vtg_plugin_instance_activate_uri (self->priv->_plugin_instance, project_manager->changelog_uri, 0, 0);
		tab = _tmp16_;
		if (tab == NULL) {
			result = FALSE;
			_g_object_unref0 (tab);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return result;
		}
		_tmp17_ = gedit_tab_get_document (tab);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		doc = _tmp18_;
		if (doc == NULL) {
			result = FALSE;
			_g_object_unref0 (doc);
			_g_object_unref0 (tab);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return result;
		}
		_tmp19_ = g_main_context_default ();
		_tmp20_ = _g_main_context_ref0 (_tmp19_);
		ctx = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_;
			_tmp21_ = g_main_context_pending (ctx);
			if (!_tmp21_) {
				break;
			}
			g_main_context_iteration (ctx, FALSE);
		}
		_tmp22_ = vtg_plugin_get_config (vtg_plugin_main_instance);
		_tmp23_ = vtg_configuration_get_author (_tmp22_);
		_tmp24_ = g_strdup (_tmp23_);
		author = _tmp24_;
		_tmp25_ = vtg_plugin_get_config (vtg_plugin_main_instance);
		_tmp26_ = vtg_configuration_get_email_address (_tmp25_);
		_tmp27_ = g_strdup (_tmp26_);
		email = _tmp27_;
		_tmp28_ = time (NULL);
		g_time_local (_tmp28_, &_tmp29_);
		_tmp30_ = _tmp29_;
		today = _tmp30_;
		_tmp31_ = vtg_string_utils_is_null_or_empty (author);
		if (_tmp31_) {
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			_tmp32_ = g_getenv ("REAL_NAME");
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (author);
			author = _tmp33_;
		}
		_tmp34_ = vtg_string_utils_is_null_or_empty (email);
		if (_tmp34_) {
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp35_ = g_getenv ("EMAIL_ADDRESS");
			_tmp36_ = g_strdup (_tmp35_);
			_g_free0 (email);
			email = _tmp36_;
		}
		_tmp37_ = vtg_string_utils_is_null_or_empty (author);
		if (_tmp37_) {
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			_tmp38_ = _ ("Author Name");
			_tmp39_ = g_strdup (_tmp38_);
			_g_free0 (author);
			author = _tmp39_;
		}
		_tmp40_ = vtg_string_utils_is_null_or_empty (email);
		if (_tmp40_) {
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			_tmp41_ = _ ("Email Address");
			_tmp42_ = g_strdup (_tmp41_);
			_g_free0 (email);
			email = _tmp42_;
		}
		_tmp43_ = g_strdup_printf ("%04d-%02d-%02d", today.tm_year + 1900, today.tm_mon + 1, today.tm_mday);
		date = _tmp43_;
		_tmp44_ = g_strdup_printf ("%s  %s  <%s>", date, author, email);
		header = _tmp44_;
		current_header = NULL;
		backward_chars_count = 2;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) doc, &_tmp45_, 0);
		iter = _tmp45_;
		if (!force_add_new) {
			GtkTextIter end;
			gboolean _tmp46_;
			end = iter;
			_tmp46_ = gtk_text_iter_forward_line (&end);
			if (_tmp46_) {
				const gchar* _tmp47_ = NULL;
				gchar* _tmp48_;
				gtk_text_iter_backward_char (&end);
				_tmp47_ = gtk_text_iter_get_text (&iter, &end);
				_tmp48_ = g_strdup (_tmp47_);
				_g_free0 (current_header);
				current_header = _tmp48_;
			}
		}
		if (g_strcmp0 (current_header, header) != 0) {
			gchar* _tmp49_ = NULL;
			_tmp49_ = g_strdup_printf ("%s\n\n%s\n\t\n\n", header, file_list);
			_g_free0 (entry);
			entry = _tmp49_;
		} else {
			gchar* _tmp50_ = NULL;
			_tmp50_ = g_strdup_printf ("\n%s\n\t\n", file_list);
			_g_free0 (entry);
			entry = _tmp50_;
			gtk_text_iter_forward_line (&iter);
			backward_chars_count = 1;
		}
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) doc, &iter);
		_tmp51_ = strlen (entry);
		gtk_text_buffer_insert_interactive_at_cursor ((GtkTextBuffer*) doc, entry, (gint) _tmp51_, TRUE);
		_tmp52_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) doc);
		mark = GTK_TEXT_MARK (_tmp52_);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &_tmp53_, mark);
		iter = _tmp53_;
		gtk_text_iter_backward_chars (&iter, backward_chars_count);
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) doc, &iter);
		result = TRUE;
		_g_free0 (entry);
		_g_free0 (current_header);
		_g_free0 (header);
		_g_free0 (date);
		_g_free0 (email);
		_g_free0 (author);
		_g_main_context_unref0 (ctx);
		_g_object_unref0 (doc);
		_g_object_unref0 (tab);
		_g_free0 (file_list);
		_g_object_unref0 (project_manager);
		return result;
	}
	result = FALSE;
	_g_free0 (file_list);
	_g_object_unref0 (project_manager);
	return result;
}


static VtgVcsBackendsVcsBase* vtg_change_log_vcs_backend_factory (VtgChangeLog* self, VtgVcsTypes type) {
	VtgVcsBackendsVcsBase* result = NULL;
	VtgVcsBackendsVcsBase* backend = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (type) {
		case VTG_VCS_TYPES_GIT:
		{
			VtgVcsBackendsGit* _tmp0_ = NULL;
			_tmp0_ = vtg_vcs_backends_git_new ();
			_g_object_unref0 (backend);
			backend = (VtgVcsBackendsVcsBase*) _tmp0_;
			break;
		}
		case VTG_VCS_TYPES_BZR:
		{
			VtgVcsBackendsBzr* _tmp1_ = NULL;
			_tmp1_ = vtg_vcs_backends_bzr_new ();
			_g_object_unref0 (backend);
			backend = (VtgVcsBackendsVcsBase*) _tmp1_;
			break;
		}
		case VTG_VCS_TYPES_SVN:
		{
			VtgVcsBackendsSvn* _tmp2_ = NULL;
			_tmp2_ = vtg_vcs_backends_svn_new ();
			_g_object_unref0 (backend);
			backend = (VtgVcsBackendsVcsBase*) _tmp2_;
			break;
		}
		default:
		{
			_g_object_unref0 (backend);
			backend = NULL;
			break;
		}
	}
	result = backend;
	return result;
}


static void vtg_change_log_class_init (VtgChangeLogClass * klass) {
	vtg_change_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgChangeLogPrivate));
	G_OBJECT_CLASS (klass)->finalize = vtg_change_log_finalize;
}


static void vtg_change_log_instance_init (VtgChangeLog * self) {
	self->priv = VTG_CHANGE_LOG_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
}


static void vtg_change_log_finalize (GObject* obj) {
	VtgChangeLog * self;
	self = VTG_CHANGE_LOG (obj);
	G_OBJECT_CLASS (vtg_change_log_parent_class)->finalize (obj);
}


GType vtg_change_log_get_type (void) {
	return vtg_change_log_type_id;
}


GType vtg_change_log_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgChangeLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_change_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgChangeLog), 0, (GInstanceInitFunc) vtg_change_log_instance_init, NULL };
	vtg_change_log_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgChangeLog", &g_define_type_info, 0);
	return vtg_change_log_type_id;
}



