/* vtgprojects.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgprojects.vala, do not modify */

/*
 *  vtgprojects.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2010 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-plugin.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <vbf.h>
#include <gedit/gedit-document.h>
#include <gio/gio.h>


#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;
typedef struct _VtgProjectsPrivate VtgProjectsPrivate;

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _VtgProjects {
	GObject parent_instance;
	VtgProjectsPrivate * priv;
};

struct _VtgProjectsClass {
	GObjectClass parent_class;
};

struct _VtgProjectsPrivate {
	VtgPlugin* _plugin;
	ValaList* _project_managers;
	VtgProjectManager* _default_project;
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	char* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	char* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};


extern VtgPlugin* vtg_plugin_main_instance;
static gpointer vtg_projects_parent_class = NULL;
static GType vtg_projects_type_id = 0;

GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
#define VTG_PROJECTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECTS, VtgProjectsPrivate))
enum  {
	VTG_PROJECTS_DUMMY_PROPERTY,
	VTG_PROJECTS_PROJECT_MANAGERS
};
VtgProjects* vtg_projects_new (VtgPlugin* plugin);
VtgProjects* vtg_projects_construct (GType object_type, VtgPlugin* plugin);
static void vtg_projects_initialize_default_project (VtgProjects* self);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
gboolean vtg_configuration_get_symbol_enabled (VtgConfiguration* self);
VtgProjectManager* vtg_project_manager_new (gboolean enable_completion);
VtgProjectManager* vtg_project_manager_construct (GType object_type, gboolean enable_completion);
void vtg_project_manager_create_default_project (VtgProjectManager* self);
static void vtg_projects_add (VtgProjects* self, VtgProjectManager* project_manager);
static void vtg_projects_on_project_updated (VtgProjects* self, VtgProjectManager* sender);
static void _vtg_projects_on_project_updated_vtg_project_manager_updated (VtgProjectManager* _sender, gpointer self);
static void vtg_projects_remove (VtgProjects* self, VtgProjectManager* project_manager);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
VtgProjectManager* vtg_projects_open_project (VtgProjects* self, const char* path, GError** error);
gboolean vtg_project_manager_open (VtgProjectManager* self, const char* project_filename, GError** error);
void vtg_projects_close_project (VtgProjects* self, VtgProjectManager* project);
void vtg_project_manager_close (VtgProjectManager* self);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document, GError** error);
char* vtg_utils_get_document_name (GeditDocument* doc);
gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const char* filename);
gboolean vtg_configuration_get_project_find_root_folder (VtgConfiguration* self);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
static gboolean vtg_projects_find_project_root_folder (VtgProjects* self, const char* file, char** root);
void vtg_project_manager_set_automanaged (VtgProjectManager* self, gboolean value);
void vtg_utils_trace (const char* format, ...);
VtgProjectManager* vtg_projects_get_project_manager_for_project_id (VtgProjects* self, const char* project_id);
VtgProjectManager* vtg_projects_get_project_manager_for_project_name (VtgProjects* self, const char* project_name);
VbfTarget* vtg_projects_get_target_for_document (VtgProjects* self, GeditDocument* document);
VbfSource* vtg_project_manager_get_source_file_for_filename (VtgProjectManager* self, const char* filename);
ValaList* vtg_projects_get_project_managers (VtgProjects* self);
static void vtg_projects_finalize (GObject* obj);
static void vtg_projects_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



VtgProjects* vtg_projects_construct (GType object_type, VtgPlugin* plugin) {
	VtgProjects * self;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (VtgProjects*) g_object_new (object_type, NULL);
	self->priv->_plugin = plugin;
	vtg_projects_initialize_default_project (self);
	return self;
}


VtgProjects* vtg_projects_new (VtgPlugin* plugin) {
	return vtg_projects_construct (VTG_TYPE_PROJECTS, plugin);
}


static void vtg_projects_initialize_default_project (VtgProjects* self) {
	VtgProjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_default_project = (_tmp0_ = vtg_project_manager_new (vtg_configuration_get_symbol_enabled (vtg_plugin_get_config (self->priv->_plugin))), _g_object_unref0 (self->priv->_default_project), _tmp0_);
	vtg_project_manager_create_default_project (self->priv->_default_project);
	vala_collection_add ((ValaCollection*) self->priv->_project_managers, self->priv->_default_project);
}


static void _vtg_projects_on_project_updated_vtg_project_manager_updated (VtgProjectManager* _sender, gpointer self) {
	vtg_projects_on_project_updated (self, _sender);
}


static void vtg_projects_add (VtgProjects* self, VtgProjectManager* project_manager) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (project_manager != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_project_managers, project_manager);
	g_signal_connect_object (project_manager, "updated", (GCallback) _vtg_projects_on_project_updated_vtg_project_manager_updated, self, 0);
}


static void vtg_projects_remove (VtgProjects* self, VtgProjectManager* project_manager) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project_manager != NULL);
	g_signal_parse_name ("updated", VTG_TYPE_PROJECT_MANAGER, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (project_manager, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_projects_on_project_updated_vtg_project_manager_updated, self);
	vala_collection_remove ((ValaCollection*) self->priv->_project_managers, project_manager);
}


static void vtg_projects_on_project_updated (VtgProjects* self, VtgProjectManager* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (sender->is_default) {
		return;
	}
	{
		ValaIterator* _source_it;
		_source_it = vala_iterable_iterator ((ValaIterable*) sender->all_vala_sources);
		while (TRUE) {
			VbfSource* source;
			if (!vala_iterator_next (_source_it)) {
				break;
			}
			source = (VbfSource*) vala_iterator_get (_source_it);
			{
				ValaIterator* _def_source_it;
				_def_source_it = vala_iterable_iterator ((ValaIterable*) self->priv->_default_project->all_vala_sources);
				while (TRUE) {
					VbfSource* def_source;
					if (!vala_iterator_next (_def_source_it)) {
						break;
					}
					def_source = (VbfSource*) vala_iterator_get (_def_source_it);
					if (_vala_strcmp0 (((VbfFile*) source)->filename, ((VbfFile*) def_source)->filename) == 0) {
						VbfGroup* group;
						VbfTarget* target;
						group = vbf_project_get_group (vtg_project_manager_get_project (self->priv->_default_project), "Sources");
						target = vbf_group_get_target_for_id (group, "Default");
						vbf_target_remove_source (target, def_source);
						g_signal_emit_by_name (self->priv->_default_project, "updated");
						_g_object_unref0 (target);
						_g_object_unref0 (group);
						_g_object_unref0 (def_source);
						break;
					}
					_g_object_unref0 (def_source);
				}
				_vala_collection_object_unref0 (_def_source_it);
			}
			_g_object_unref0 (source);
		}
		_vala_collection_object_unref0 (_source_it);
	}
}


VtgProjectManager* vtg_projects_open_project (VtgProjects* self, const char* path, GError** error) {
	VtgProjectManager* result = NULL;
	VtgProjectManager* project;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	project = vtg_project_manager_new (vtg_configuration_get_symbol_enabled (vtg_plugin_get_config (vtg_plugin_main_instance)));
	_tmp0_ = vtg_project_manager_open (project, path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (project);
		return NULL;
	}
	if (_tmp0_) {
		vtg_projects_add (self, project);
		g_signal_emit_by_name (self, "project-opened", (GObject*) project);
	}
	result = project;
	return result;
}


void vtg_projects_close_project (VtgProjects* self, VtgProjectManager* project) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_signal_emit_by_name (self, "project-closed", (GObject*) project);
	vtg_project_manager_close (project);
	vtg_projects_remove (self, project);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document, GError** error) {
	VtgProjectManager* result = NULL;
	char* file;
	char* root;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (document != NULL, NULL);
	file = vtg_utils_get_document_name (document);
	if (file != NULL) {
		{
			ValaIterator* _project_manager_it;
			_project_manager_it = vala_iterable_iterator ((ValaIterable*) self->priv->_project_managers);
			while (TRUE) {
				VtgProjectManager* project_manager;
				if (!vala_iterator_next (_project_manager_it)) {
					break;
				}
				project_manager = (VtgProjectManager*) vala_iterator_get (_project_manager_it);
				if (vtg_project_manager_contains_filename (project_manager, file)) {
					result = project_manager;
					_vala_collection_object_unref0 (_project_manager_it);
					_g_free0 (file);
					return result;
				}
				_g_object_unref0 (project_manager);
			}
			_vala_collection_object_unref0 (_project_manager_it);
		}
	}
	root = NULL;
	if (vtg_configuration_get_project_find_root_folder (vtg_plugin_get_config (vtg_plugin_main_instance))) {
		_tmp1_ = vtg_utils_is_vala_doc (document);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp2_ = NULL;
		gboolean _tmp3_;
		char* _tmp4_;
		_tmp0_ = (_tmp3_ = vtg_projects_find_project_root_folder (self, file, &_tmp2_), root = (_tmp4_ = _tmp2_, _g_free0 (root), _tmp4_), _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		VtgProjectManager* project;
		project = vtg_projects_open_project (self, root, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (root);
			_g_free0 (file);
			return NULL;
		}
		vtg_project_manager_set_automanaged (project, TRUE);
		result = project;
		_g_free0 (root);
		_g_free0 (file);
		return result;
	}
	result = _g_object_ref0 (self->priv->_default_project);
	_g_free0 (root);
	_g_free0 (file);
	return result;
}


static gboolean vtg_projects_find_project_root_folder (VtgProjects* self, const char* file, char** root) {
	gboolean result = FALSE;
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	if (root != NULL) {
		*root = NULL;
	}
	dir = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_path_get_dirname (file)), _g_free0 (_tmp0_), _tmp1_);
	*root = (_tmp2_ = NULL, _g_free0 (*root), _tmp2_);
	{
		gboolean _tmp3_;
		_tmp3_ = TRUE;
		while (TRUE) {
			char* _tmp4_;
			VbfIProjectBackend* dummy;
			char* _tmp5_;
			VbfIProjectBackend* _tmp6_ = NULL;
			gboolean _tmp7_;
			VbfIProjectBackend* _tmp8_;
			gboolean _tmp9_;
			GFile* _tmp11_;
			if (!_tmp3_) {
				if (!(dir != NULL)) {
					break;
				}
			}
			_tmp3_ = FALSE;
			vtg_utils_trace ("vtgprojects.vala:146: testing directory: %s", _tmp4_ = g_file_get_path (dir));
			_g_free0 (_tmp4_);
			dummy = NULL;
			if ((_tmp9_ = (_tmp7_ = vbf_probe (_tmp5_ = g_file_get_path (dir), &_tmp6_), dummy = (_tmp8_ = _tmp6_, _g_object_unref0 (dummy), _tmp8_), _tmp7_), _g_free0 (_tmp5_), _tmp9_)) {
				char* _tmp10_;
				*root = (_tmp10_ = g_file_get_path (dir), _g_free0 (*root), _tmp10_);
			} else {
				if ((*root) != NULL) {
					_g_object_unref0 (dummy);
					break;
				}
			}
			dir = (_tmp11_ = g_file_get_parent (dir), _g_object_unref0 (dir), _tmp11_);
			_g_object_unref0 (dummy);
		}
	}
	result = (*root) != NULL;
	_g_object_unref0 (dir);
	return result;
}


VtgProjectManager* vtg_projects_get_project_manager_for_project_id (VtgProjects* self, const char* project_id) {
	VtgProjectManager* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		ValaIterator* _item_it;
		_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_project_managers);
		while (TRUE) {
			VtgProjectManager* item;
			if (!vala_iterator_next (_item_it)) {
				break;
			}
			item = (VtgProjectManager*) vala_iterator_get (_item_it);
			if (_vala_strcmp0 (vtg_project_manager_get_project (item)->id, project_id) == 0) {
				result = item;
				_vala_collection_object_unref0 (_item_it);
				return result;
			}
			_g_object_unref0 (item);
		}
		_vala_collection_object_unref0 (_item_it);
	}
	result = NULL;
	return result;
}


VtgProjectManager* vtg_projects_get_project_manager_for_project_name (VtgProjects* self, const char* project_name) {
	VtgProjectManager* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (project_name != NULL) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_project_managers);
			while (TRUE) {
				VtgProjectManager* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (VtgProjectManager*) vala_iterator_get (_item_it);
				if (_vala_strcmp0 (vtg_project_manager_get_project (item)->name, project_name) == 0) {
					result = item;
					_vala_collection_object_unref0 (_item_it);
					return result;
				}
				_g_object_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	result = NULL;
	return result;
}


VbfTarget* vtg_projects_get_target_for_document (VtgProjects* self, GeditDocument* document) {
	VbfTarget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (document != NULL) {
		char* file;
		file = vtg_utils_get_document_name (document);
		if (file != NULL) {
			{
				ValaIterator* _item_it;
				_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_project_managers);
				while (TRUE) {
					VtgProjectManager* item;
					VbfSource* source;
					if (!vala_iterator_next (_item_it)) {
						break;
					}
					item = (VtgProjectManager*) vala_iterator_get (_item_it);
					source = vtg_project_manager_get_source_file_for_filename (item, file);
					if (source != NULL) {
						result = _g_object_ref0 (((VbfFile*) source)->target);
						_g_object_unref0 (source);
						_g_object_unref0 (item);
						_vala_collection_object_unref0 (_item_it);
						_g_free0 (file);
						return result;
					}
					_g_object_unref0 (source);
					_g_object_unref0 (item);
				}
				_vala_collection_object_unref0 (_item_it);
			}
		}
		_g_free0 (file);
	}
	result = NULL;
	return result;
}


ValaList* vtg_projects_get_project_managers (VtgProjects* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project_managers;
	return result;
}


static void vtg_projects_class_init (VtgProjectsClass * klass) {
	vtg_projects_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectsPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_projects_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_projects_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECTS_PROJECT_MANAGERS, vala_param_spec_collection_object ("project-managers", "project-managers", "project-managers", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("project_opened", VTG_TYPE_PROJECTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
	g_signal_new ("project_closed", VTG_TYPE_PROJECTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
}


static void vtg_projects_instance_init (VtgProjects * self) {
	self->priv = VTG_PROJECTS_GET_PRIVATE (self);
	self->priv->_project_managers = (ValaList*) vala_array_list_new (VTG_TYPE_PROJECT_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_default_project = NULL;
}


static void vtg_projects_finalize (GObject* obj) {
	VtgProjects * self;
	self = VTG_PROJECTS (obj);
	_vala_collection_object_unref0 (self->priv->_project_managers);
	_g_object_unref0 (self->priv->_default_project);
	G_OBJECT_CLASS (vtg_projects_parent_class)->finalize (obj);
}


GType vtg_projects_get_type (void) {
	return vtg_projects_type_id;
}


GType vtg_projects_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjects), 0, (GInstanceInitFunc) vtg_projects_instance_init, NULL };
	vtg_projects_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjects", &g_define_type_info, 0);
	return vtg_projects_type_id;
}


static void vtg_projects_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjects * self;
	self = VTG_PROJECTS (object);
	switch (property_id) {
		case VTG_PROJECTS_PROJECT_MANAGERS:
		vala_value_set_collection_object (value, vtg_projects_get_project_managers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




