/* vbfsmartfolder.c generated by valac 0.10.0, the Vala compiler
 * generated from vbfsmartfolder.vala, do not modify */

/*
 *  vbfsmartfolder.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define VBF_TYPE_IPROJECT_BACKEND (vbf_iproject_backend_get_type ())
#define VBF_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackend))
#define VBF_IS_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_IPROJECT_BACKEND))
#define VBF_IPROJECT_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackendIface))

typedef struct _VbfIProjectBackend VbfIProjectBackend;
typedef struct _VbfIProjectBackendIface VbfIProjectBackendIface;

#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;

#define VBF_TYPE_PROJECT (vbf_project_get_type ())
#define VBF_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PROJECT, VbfProject))
#define VBF_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PROJECT, VbfProjectClass))
#define VBF_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PROJECT))
#define VBF_IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PROJECT))
#define VBF_PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PROJECT, VbfProjectClass))

typedef struct _VbfProject VbfProject;
typedef struct _VbfProjectClass VbfProjectClass;

#define VBF_BACKENDS_TYPE_SMART_FOLDER (vbf_backends_smart_folder_get_type ())
#define VBF_BACKENDS_SMART_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolder))
#define VBF_BACKENDS_SMART_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolderClass))
#define VBF_BACKENDS_IS_SMART_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_BACKENDS_TYPE_SMART_FOLDER))
#define VBF_BACKENDS_IS_SMART_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_BACKENDS_TYPE_SMART_FOLDER))
#define VBF_BACKENDS_SMART_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolderClass))

typedef struct _VbfBackendsSmartFolder VbfBackendsSmartFolder;
typedef struct _VbfBackendsSmartFolderClass VbfBackendsSmartFolderClass;
typedef struct _VbfBackendsSmartFolderPrivate VbfBackendsSmartFolderPrivate;

#define VBF_BACKENDS_SMART_FOLDER_TYPE_PROJECT_SUB_TYPE (vbf_backends_smart_folder_project_sub_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
typedef struct _VbfConfigNodePrivate VbfConfigNodePrivate;
typedef struct _VbfProjectPrivate VbfProjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;
typedef struct _VbfGroupPrivate VbfGroupPrivate;

#define VBF_TYPE_TARGET_TYPES (vbf_target_types_get_type ())

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;
typedef struct _VbfTargetPrivate VbfTargetPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VBF_TYPE_PACKAGE (vbf_package_get_type ())
#define VBF_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PACKAGE, VbfPackage))
#define VBF_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PACKAGE, VbfPackageClass))
#define VBF_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PACKAGE))
#define VBF_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PACKAGE))
#define VBF_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PACKAGE, VbfPackageClass))

typedef struct _VbfPackage VbfPackage;
typedef struct _VbfPackageClass VbfPackageClass;

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;

#define VBF_TYPE_SOURCE (vbf_source_get_type ())
#define VBF_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_SOURCE, VbfSource))
#define VBF_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_SOURCE, VbfSourceClass))
#define VBF_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_SOURCE))
#define VBF_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_SOURCE))
#define VBF_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_SOURCE, VbfSourceClass))

typedef struct _VbfSource VbfSource;
typedef struct _VbfSourceClass VbfSourceClass;
typedef struct _VbfFilePrivate VbfFilePrivate;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

struct _VbfIProjectBackendIface {
	GTypeInterface parent_iface;
	gboolean (*probe) (VbfIProjectBackend* self, const char* project_file);
	VbfProject* (*open) (VbfIProjectBackend* self, const char* project_file);
	void (*refresh) (VbfIProjectBackend* self, VbfProject* project);
	char* (*get_configure_command) (VbfIProjectBackend* self);
	char* (*get_build_command) (VbfIProjectBackend* self);
	char* (*get_clean_command) (VbfIProjectBackend* self);
};

struct _VbfBackendsSmartFolder {
	GObject parent_instance;
	VbfBackendsSmartFolderPrivate * priv;
};

struct _VbfBackendsSmartFolderClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN,
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF,
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE,
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE
} VbfBackendsSmartFolderProjectSubType;

struct _VbfBackendsSmartFolderPrivate {
	VbfProject* _project;
	char* _configure_command;
	char* _build_command;
	char* _clean_command;
	GRegex* _regex;
	ValaList* _file_mons;
	ValaList* _visited_directory;
	VbfBackendsSmartFolderProjectSubType _project_subtype;
};

struct _VbfConfigNode {
	GObject parent_instance;
	VbfConfigNodePrivate * priv;
	VbfConfigNode* parent;
};

struct _VbfConfigNodeClass {
	GObjectClass parent_class;
	char* (*to_string) (VbfConfigNode* self);
};

struct _VbfProject {
	VbfConfigNode parent_instance;
	VbfProjectPrivate * priv;
	char* id;
	char* name;
	char* url;
	char* version;
	char* working_dir;
	VbfIProjectBackend* backend;
};

struct _VbfProjectClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfGroup {
	GObject parent_instance;
	VbfGroupPrivate * priv;
	char* name;
	char* id;
	VbfProject* project;
};

struct _VbfGroupClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_TARGET_TYPES_PROGRAM,
	VBF_TARGET_TYPES_LIBRARY,
	VBF_TARGET_TYPES_DATA,
	VBF_TARGET_TYPES_BUILT_SOURCES
} VbfTargetTypes;

struct _VbfTarget {
	GObject parent_instance;
	VbfTargetPrivate * priv;
	char* id;
	char* name;
	VbfTargetTypes type;
	gboolean no_install;
	VbfGroup* group;
};

struct _VbfTargetClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfFile {
	GObject parent_instance;
	VbfFilePrivate * priv;
	char* name;
	char* filename;
	char* uri;
	VbfFileTypes type;
	VbfTarget* target;
};

struct _VbfFileClass {
	GObjectClass parent_class;
};


static gpointer vbf_backends_smart_folder_parent_class = NULL;
static VbfIProjectBackendIface* vbf_backends_smart_folder_vbf_iproject_backend_parent_iface = NULL;

GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_project_get_type (void) G_GNUC_CONST;
GType vbf_iproject_backend_get_type (void) G_GNUC_CONST;
GType vbf_backends_smart_folder_get_type (void) G_GNUC_CONST;
static GType vbf_backends_smart_folder_project_sub_type_get_type (void) G_GNUC_UNUSED;
#define VBF_BACKENDS_SMART_FOLDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolderPrivate))
enum  {
	VBF_BACKENDS_SMART_FOLDER_DUMMY_PROPERTY,
	VBF_BACKENDS_SMART_FOLDER_CONFIGURE_COMMAND,
	VBF_BACKENDS_SMART_FOLDER_BUILD_COMMAND,
	VBF_BACKENDS_SMART_FOLDER_CLEAN_COMMAND
};
static gboolean vbf_backends_smart_folder_real_probe (VbfIProjectBackend* base, const char* project_file);
gboolean vbf_utils_is_waf_project (const char* path);
gboolean vbf_utils_is_cmake_project (const char* path);
gboolean vbf_utils_is_simple_make_project (const char* path);
static VbfProject* vbf_backends_smart_folder_real_open (VbfIProjectBackend* base, const char* project_file);
VbfProject* vbf_project_new (const char* id);
VbfProject* vbf_project_construct (GType object_type, const char* id);
void vbf_iproject_backend_refresh (VbfIProjectBackend* self, VbfProject* project);
static void vbf_backends_smart_folder_cleanup_file_monitors (VbfBackendsSmartFolder* self);
static void vbf_backends_smart_folder_on_project_directory_changed (VbfBackendsSmartFolder* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void vbf_backends_smart_folder_real_refresh (VbfIProjectBackend* base, VbfProject* project);
void vbf_project_clear (VbfProject* self);
VbfGroup* vbf_group_new (VbfProject* project, const char* id);
VbfGroup* vbf_group_construct (GType object_type, VbfProject* project, const char* id);
GType vbf_group_get_type (void) G_GNUC_CONST;
GType vbf_target_types_get_type (void) G_GNUC_CONST;
VbfTarget* vbf_target_new (VbfGroup* group, VbfTargetTypes type, const char* id);
VbfTarget* vbf_target_construct (GType object_type, VbfGroup* group, VbfTargetTypes type, const char* id);
GType vbf_target_get_type (void) G_GNUC_CONST;
void vbf_group_add_target (VbfGroup* self, VbfTarget* target);
void vbf_project_add_group (VbfProject* self, VbfGroup* group);
void vbf_utils_trace (const char* format, ...);
static void vbf_backends_smart_folder_scan_directory (VbfBackendsSmartFolder* self, const char* directory, VbfProject* project, const char* build_filename, GError** error);
void vbf_backends_smart_folder_setup_file_monitors (VbfBackendsSmartFolder* self, VbfProject* project);
VbfGroup* vbf_project_get_group (VbfProject* self, const char* id);
VbfTarget* vbf_group_get_target_for_id (VbfGroup* self, const char* id);
static void vbf_backends_smart_folder_add_vala_source (VbfBackendsSmartFolder* self, VbfTarget* target, const char* directory, GFileInfo* file_info);
static void vbf_backends_smart_folder_add_vapi_source (VbfBackendsSmartFolder* self, VbfTarget* target, const char* directory, GFileInfo* file_info);
static void vbf_backends_smart_folder_parse_build_file_infos (VbfBackendsSmartFolder* self, VbfTarget* target, const char* filename);
static void vbf_backends_smart_folder_parse_cmake_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const char* filename);
static void vbf_backends_smart_folder_parse_waf_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const char* filename);
static char* vbf_backends_smart_folder_get_token (VbfBackendsSmartFolder* self, const char* content, gint* start_position);
static gint vbf_backends_smart_folder_skip_line (VbfBackendsSmartFolder* self, const char* content, gint start_position);
gboolean vbf_target_contains_package (VbfTarget* self, const char* package_id);
GType vbf_package_get_type (void) G_GNUC_CONST;
void vbf_target_add_package (VbfTarget* self, VbfPackage* package);
VbfPackage* vbf_package_new (const char* id);
VbfPackage* vbf_package_construct (GType object_type, const char* id);
static gboolean vbf_backends_smart_folder_expect_token (VbfBackendsSmartFolder* self, const char* token, const char* content, gint* start_position);
static gint vbf_backends_smart_folder_skip_spaces (VbfBackendsSmartFolder* self, const char* content, gint start_position);
static gboolean vbf_backends_smart_folder_eof (VbfBackendsSmartFolder* self, const char* content, gint position);
VbfSource* vbf_source_new (VbfTarget* target, const char* filename);
VbfSource* vbf_source_construct (GType object_type, VbfTarget* target, const char* filename);
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_source_get_type (void) G_GNUC_CONST;
GType vbf_file_types_get_type (void) G_GNUC_CONST;
void vbf_target_add_source (VbfTarget* self, VbfSource* source);
char* vbf_utils_guess_package_vapi (const char* using_name, char** vapi_dirs, int vapi_dirs_length1);
gboolean vbf_target_contains_include_dir (VbfTarget* self, const char* dir);
void vbf_target_add_include_dir (VbfTarget* self, const char* dir);
gboolean vbf_utils_is_vala_source (const char* filename);
void vbf_project_update (VbfProject* self);
VbfBackendsSmartFolder* vbf_backends_smart_folder_new (void);
VbfBackendsSmartFolder* vbf_backends_smart_folder_construct (GType object_type);
static void vbf_backends_smart_folder_finalize (GObject* obj);
char* vbf_iproject_backend_get_configure_command (VbfIProjectBackend* self);
char* vbf_iproject_backend_get_build_command (VbfIProjectBackend* self);
char* vbf_iproject_backend_get_clean_command (VbfIProjectBackend* self);
static void vbf_backends_smart_folder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GType vbf_backends_smart_folder_project_sub_type_get_type (void) {
	static volatile gsize vbf_backends_smart_folder_project_sub_type_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_backends_smart_folder_project_sub_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN", "unknown"}, {VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF", "waf"}, {VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE", "cmake"}, {VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE", "make"}, {0, NULL, NULL}};
		GType vbf_backends_smart_folder_project_sub_type_type_id;
		vbf_backends_smart_folder_project_sub_type_type_id = g_enum_register_static ("VbfBackendsSmartFolderProjectSubType", values);
		g_once_init_leave (&vbf_backends_smart_folder_project_sub_type_type_id__volatile, vbf_backends_smart_folder_project_sub_type_type_id);
	}
	return vbf_backends_smart_folder_project_sub_type_type_id__volatile;
}


static gboolean vbf_backends_smart_folder_real_probe (VbfIProjectBackend* base, const char* project_file) {
	VbfBackendsSmartFolder * self;
	gboolean result = FALSE;
	gboolean res;
	self = (VbfBackendsSmartFolder*) base;
	g_return_val_if_fail (project_file != NULL, FALSE);
	res = FALSE;
	if (g_file_test (project_file, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vbf_utils_is_waf_project (project_file)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vbf_utils_is_cmake_project (project_file);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vbf_utils_is_simple_make_project (project_file);
		}
		res = _tmp0_;
	}
	result = res;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static VbfProject* vbf_backends_smart_folder_real_open (VbfIProjectBackend* base, const char* project_file) {
	VbfBackendsSmartFolder * self;
	VbfProject* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	VbfProject* project;
	VbfIProjectBackend* _tmp3_;
	self = (VbfBackendsSmartFolder*) base;
	g_return_val_if_fail (project_file != NULL, NULL);
	self->priv->_project = NULL;
	self->priv->_configure_command = (_tmp0_ = NULL, _g_free0 (self->priv->_configure_command), _tmp0_);
	self->priv->_build_command = (_tmp1_ = NULL, _g_free0 (self->priv->_build_command), _tmp1_);
	self->priv->_clean_command = (_tmp2_ = NULL, _g_free0 (self->priv->_clean_command), _tmp2_);
	project = vbf_project_new (project_file);
	project->backend = (_tmp3_ = _g_object_ref0 ((VbfIProjectBackend*) self), _g_object_unref0 (project->backend), _tmp3_);
	vbf_iproject_backend_refresh ((VbfIProjectBackend*) self, project);
	if (project->name == NULL) {
		result = NULL;
		_g_object_unref0 (project);
		return result;
	} else {
		self->priv->_project = project;
		result = project;
		return result;
	}
	_g_object_unref0 (project);
}


static void _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	vbf_backends_smart_folder_on_project_directory_changed (self, _sender, file, other_file, event_type);
}


static void vbf_backends_smart_folder_cleanup_file_monitors (VbfBackendsSmartFolder* self) {
	g_return_if_fail (self != NULL);
	{
		ValaIterator* _file_mon_it;
		_file_mon_it = vala_iterable_iterator ((ValaIterable*) self->priv->_file_mons);
		while (TRUE) {
			GFileMonitor* file_mon;
			guint _tmp0_;
			if (!vala_iterator_next (_file_mon_it)) {
				break;
			}
			file_mon = (GFileMonitor*) vala_iterator_get (_file_mon_it);
			g_signal_parse_name ("changed", G_TYPE_FILE_MONITOR, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (file_mon, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed, self);
			g_file_monitor_cancel (file_mon);
			_g_object_unref0 (file_mon);
		}
		_vala_collection_object_unref0 (_file_mon_it);
	}
	vala_collection_clear ((ValaCollection*) self->priv->_file_mons);
}


static void vbf_backends_smart_folder_real_refresh (VbfIProjectBackend* base, VbfProject* project) {
	VbfBackendsSmartFolder * self;
	GError * _inner_error_ = NULL;
	self = (VbfBackendsSmartFolder*) base;
	g_return_if_fail (project != NULL);
	vbf_backends_smart_folder_cleanup_file_monitors (self);
	{
		char* build_filename;
		char* _tmp0_;
		GFile* file;
		char* _tmp1_;
		char* _tmp2_;
		VbfGroup* group;
		char* _tmp3_;
		VbfTarget* target;
		char* _tmp4_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		ValaList* _tmp17_;
		GRegex* _tmp18_;
		ValaList* _tmp19_;
		build_filename = NULL;
		vbf_project_clear (project);
		project->working_dir = (_tmp0_ = g_strdup (project->id), _g_free0 (project->working_dir), _tmp0_);
		file = g_file_new_for_path (project->id);
		project->name = (_tmp2_ = g_filename_display_basename (_tmp1_ = g_file_get_basename (file)), _g_free0 (project->name), _tmp2_);
		_g_free0 (_tmp1_);
		group = vbf_group_new (project, project->id);
		group->name = (_tmp3_ = g_strdup (project->name), _g_free0 (group->name), _tmp3_);
		target = vbf_target_new (group, VBF_TARGET_TYPES_PROGRAM, project->id);
		target->name = (_tmp4_ = g_strdup (project->name), _g_free0 (target->name), _tmp4_);
		vbf_group_add_target (group, target);
		vbf_project_add_group (project, group);
		if (vbf_utils_is_waf_project (project->id)) {
			char* waf_command;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			waf_command = g_build_filename (project->id, "waf", NULL);
			vbf_utils_trace ("vbfsmartfolder.vala:124: waf command is %s", waf_command);
			self->priv->_configure_command = (_tmp5_ = g_strdup_printf ("%s configure", waf_command), _g_free0 (self->priv->_configure_command), _tmp5_);
			self->priv->_build_command = (_tmp6_ = g_strdup_printf ("%s build", waf_command), _g_free0 (self->priv->_build_command), _tmp6_);
			self->priv->_clean_command = (_tmp7_ = g_strdup_printf ("%s clean", waf_command), _g_free0 (self->priv->_clean_command), _tmp7_);
			self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF;
			build_filename = (_tmp8_ = g_strdup ("wscript"), _g_free0 (build_filename), _tmp8_);
			_g_free0 (waf_command);
		} else {
			if (vbf_utils_is_cmake_project (project->id)) {
				char* _tmp9_;
				char* _tmp10_;
				char* _tmp11_;
				char* _tmp12_;
				self->priv->_configure_command = (_tmp9_ = g_strdup ("cmake"), _g_free0 (self->priv->_configure_command), _tmp9_);
				self->priv->_build_command = (_tmp10_ = g_strdup ("make"), _g_free0 (self->priv->_build_command), _tmp10_);
				self->priv->_clean_command = (_tmp11_ = g_strdup ("make clean"), _g_free0 (self->priv->_clean_command), _tmp11_);
				self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE;
				build_filename = (_tmp12_ = g_strdup ("CMakeLists.txt"), _g_free0 (build_filename), _tmp12_);
			} else {
				if (vbf_utils_is_simple_make_project (project->id)) {
					char* _tmp13_;
					char* _tmp14_;
					self->priv->_build_command = (_tmp13_ = g_strdup ("make"), _g_free0 (self->priv->_build_command), _tmp13_);
					self->priv->_clean_command = (_tmp14_ = g_strdup ("make clean"), _g_free0 (self->priv->_clean_command), _tmp14_);
					self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE;
				} else {
					self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN;
				}
			}
		}
		_tmp15_ = g_regex_new ("^\\s*(using)\\s+(\\w\\S*)\\s*;.*$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (target);
			_g_object_unref0 (group);
			_g_object_unref0 (file);
			_g_free0 (build_filename);
			goto __catch8_g_error;
		}
		self->priv->_regex = (_tmp16_ = _tmp15_, _g_regex_unref0 (self->priv->_regex), _tmp16_);
		self->priv->_visited_directory = (_tmp17_ = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal), _vala_collection_object_unref0 (self->priv->_visited_directory), _tmp17_);
		vbf_backends_smart_folder_scan_directory (self, project->id, project, build_filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (target);
			_g_object_unref0 (group);
			_g_object_unref0 (file);
			_g_free0 (build_filename);
			goto __catch8_g_error;
		}
		if (project->name != NULL) {
			vbf_backends_smart_folder_setup_file_monitors (self, project);
		}
		self->priv->_regex = (_tmp18_ = NULL, _g_regex_unref0 (self->priv->_regex), _tmp18_);
		vala_collection_clear ((ValaCollection*) self->priv->_visited_directory);
		self->priv->_visited_directory = (_tmp19_ = NULL, _vala_collection_object_unref0 (self->priv->_visited_directory), _tmp19_);
		_g_object_unref0 (target);
		_g_object_unref0 (group);
		_g_object_unref0 (file);
		_g_free0 (build_filename);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfsmartfolder.vala:155: open: %s", err->message);
			_g_error_free0 (err);
			return;
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_smart_folder_scan_directory (VbfBackendsSmartFolder* self, const char* directory, VbfProject* project, const char* build_filename, GError** error) {
	GFile* dir;
	GFileEnumerator* enm;
	GFileInfo* file_info;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (project != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_visited_directory, directory);
	dir = g_file_new_for_path (directory);
	enm = g_file_enumerate_children (dir, "standard::*", 0, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	file_info = NULL;
	while (TRUE) {
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_enumerator_next_file (enm, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enm);
			_g_object_unref0 (dir);
			return;
		}
		if (!((file_info = (_tmp1_ = _tmp0_, _g_object_unref0 (file_info), _tmp1_)) != NULL)) {
			break;
		}
		if (g_file_info_get_file_type (file_info) == G_FILE_TYPE_DIRECTORY) {
			gboolean _tmp2_ = FALSE;
			if (!g_str_has_prefix (g_file_info_get_name (file_info), ".")) {
				_tmp2_ = !g_str_has_prefix (g_file_info_get_name (file_info), "_");
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				char* _tmp3_;
				vbf_backends_smart_folder_scan_directory (self, _tmp3_ = g_build_filename (directory, g_file_info_get_name (file_info), NULL), project, build_filename, &_inner_error_);
				_g_free0 (_tmp3_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (file_info);
					_g_object_unref0 (enm);
					_g_object_unref0 (dir);
					return;
				}
			}
		} else {
			VbfTarget* target;
			char* name;
			target = NULL;
			name = g_strdup (g_file_info_get_display_name (file_info));
			if (g_str_has_suffix (name, ".vala")) {
				VbfGroup* _tmp4_;
				VbfTarget* _tmp5_;
				target = (_tmp5_ = vbf_group_get_target_for_id (_tmp4_ = vbf_project_get_group (project, project->id), project->id), _g_object_unref0 (target), _tmp5_);
				_g_object_unref0 (_tmp4_);
				vbf_backends_smart_folder_add_vala_source (self, target, directory, file_info);
			} else {
				if (g_str_has_suffix (name, ".vapi")) {
					VbfGroup* _tmp6_;
					VbfTarget* _tmp7_;
					target = (_tmp7_ = vbf_group_get_target_for_id (_tmp6_ = vbf_project_get_group (project, project->id), project->id), _g_object_unref0 (target), _tmp7_);
					_g_object_unref0 (_tmp6_);
					vbf_backends_smart_folder_add_vapi_source (self, target, directory, file_info);
				} else {
					gboolean _tmp8_ = FALSE;
					if (build_filename != NULL) {
						_tmp8_ = _vala_strcmp0 (name, build_filename) == 0;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						VbfGroup* _tmp9_;
						VbfTarget* _tmp10_;
						char* _tmp11_;
						target = (_tmp10_ = vbf_group_get_target_for_id (_tmp9_ = vbf_project_get_group (project, project->id), project->id), _g_object_unref0 (target), _tmp10_);
						_g_object_unref0 (_tmp9_);
						vbf_backends_smart_folder_parse_build_file_infos (self, target, _tmp11_ = g_build_filename (directory, g_file_info_get_name (file_info), NULL));
						_g_free0 (_tmp11_);
					}
				}
			}
			_g_free0 (name);
			_g_object_unref0 (target);
		}
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (enm);
	_g_object_unref0 (dir);
}


static void vbf_backends_smart_folder_parse_build_file_infos (VbfBackendsSmartFolder* self, VbfTarget* target, const char* filename) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (filename != NULL);
	switch (self->priv->_project_subtype) {
		case VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE:
		{
			vbf_backends_smart_folder_parse_cmake_build_file (self, target, filename);
			break;
		}
		case VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF:
		{
			vbf_backends_smart_folder_parse_waf_build_file (self, target, filename);
			break;
		}
		default:
		{
			break;
		}
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static void vbf_backends_smart_folder_parse_cmake_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const char* filename) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (filename != NULL);
	{
		char* content;
		gboolean _tmp0_ = FALSE;
		char* _tmp1_ = NULL;
		gboolean _tmp2_;
		char* _tmp3_;
		gboolean _tmp4_;
		vbf_utils_trace ("vbfsmartfolder.vala:207: parsing cmake build file: %s", filename);
		content = NULL;
		_tmp4_ = (_tmp2_ = g_file_get_contents (filename, &_tmp1_, NULL, &_inner_error_), content = (_tmp3_ = _tmp1_, _g_free0 (content), _tmp3_), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			goto __catch9_g_error;
		}
		if (_tmp4_) {
			_tmp0_ = content != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gint start_position;
			char* token;
			gboolean in_precompile;
			gboolean in_package;
			gint par_level;
			start_position = 0;
			token = NULL;
			in_precompile = FALSE;
			in_package = FALSE;
			par_level = 0;
			while (TRUE) {
				char* _tmp5_;
				if (!((token = (_tmp5_ = vbf_backends_smart_folder_get_token (self, content, &start_position), _g_free0 (token), _tmp5_)) != NULL)) {
					break;
				}
				if (g_str_has_prefix (token, "#")) {
					start_position = vbf_backends_smart_folder_skip_line (self, content, start_position);
				} else {
					if (in_package) {
						gboolean _tmp6_ = FALSE;
						gboolean _tmp7_ = FALSE;
						gboolean _tmp8_ = FALSE;
						if (string_get_length (token) > 1) {
							_tmp8_ = _vala_strcmp0 (token, "OPTIONS") == 0;
						} else {
							_tmp8_ = FALSE;
						}
						if (_tmp8_) {
							_tmp7_ = TRUE;
						} else {
							_tmp7_ = _vala_strcmp0 (token, "CUSTOM_VAPIS") == 0;
						}
						if (_tmp7_) {
							_tmp6_ = TRUE;
						} else {
							char* _tmp9_;
							_tmp6_ = _vala_strcmp0 (_tmp9_ = g_utf8_strup (token, -1), token) == 0;
							_g_free0 (_tmp9_);
						}
						if (_tmp6_) {
							in_package = FALSE;
							break;
						} else {
							vbf_utils_trace ("vbfsmartfolder.vala:224: cmake backend adding package: %s", token);
							if (!vbf_target_contains_package (target, token)) {
								VbfPackage* _tmp10_;
								vbf_target_add_package (target, _tmp10_ = vbf_package_new (token));
								_g_object_unref0 (_tmp10_);
							}
						}
					} else {
						if (in_precompile) {
							if (_vala_strcmp0 (token, "(") == 0) {
								par_level++;
							} else {
								if (_vala_strcmp0 (token, ")") == 0) {
									if (par_level == 0) {
										in_precompile = FALSE;
										break;
									} else {
										par_level--;
									}
								} else {
									if (_vala_strcmp0 (token, "PACKAGES") == 0) {
										in_package = TRUE;
									}
								}
							}
						} else {
							if (_vala_strcmp0 (token, "vala_precompile") == 0) {
								in_precompile = vbf_backends_smart_folder_expect_token (self, "(", content, &start_position);
							}
						}
					}
				}
			}
			_g_free0 (token);
		}
		_g_free0 (content);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfsmartfolder.vala:251: Error parsing cmake build file '%s': %s", filename, err->message);
			_g_error_free0 (err);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_smart_folder_parse_waf_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const char* filename) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (filename != NULL);
	{
		char* content;
		gboolean _tmp0_ = FALSE;
		char* _tmp1_ = NULL;
		gboolean _tmp2_;
		char* _tmp3_;
		gboolean _tmp4_;
		vbf_utils_trace ("vbfsmartfolder.vala:258: parsing waf build file: %s", filename);
		content = NULL;
		_tmp4_ = (_tmp2_ = g_file_get_contents (filename, &_tmp1_, NULL, &_inner_error_), content = (_tmp3_ = _tmp1_, _g_free0 (content), _tmp3_), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			goto __catch10_g_error;
		}
		if (_tmp4_) {
			_tmp0_ = content != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gint start_position;
			char* token;
			gboolean in_build;
			gboolean in_package;
			gint par_level;
			start_position = 0;
			token = NULL;
			in_build = FALSE;
			in_package = FALSE;
			par_level = 0;
			while (TRUE) {
				char* _tmp5_;
				if (!((token = (_tmp5_ = vbf_backends_smart_folder_get_token (self, content, &start_position), _g_free0 (token), _tmp5_)) != NULL)) {
					break;
				}
				if (g_str_has_prefix (token, "#")) {
					start_position = vbf_backends_smart_folder_skip_line (self, content, start_position);
				} else {
					if (in_package) {
						gboolean _tmp6_ = FALSE;
						if (string_get_length (token) == 1) {
							gboolean _tmp7_ = FALSE;
							if (_vala_strcmp0 (token, "\"") == 0) {
								_tmp7_ = TRUE;
							} else {
								_tmp7_ = _vala_strcmp0 (token, "'") == 0;
							}
							_tmp6_ = _tmp7_;
						} else {
							_tmp6_ = FALSE;
						}
						if (_tmp6_) {
							in_package = FALSE;
							break;
						} else {
							vbf_utils_trace ("vbfsmartfolder.vala:275: waf backend adding package: %s", token);
							if (!vbf_target_contains_package (target, token)) {
								VbfPackage* _tmp8_;
								vbf_target_add_package (target, _tmp8_ = vbf_package_new (token));
								_g_object_unref0 (_tmp8_);
							}
						}
					} else {
						if (in_build) {
							if (_vala_strcmp0 (token, "(") == 0) {
								par_level++;
							} else {
								if (_vala_strcmp0 (token, ")") == 0) {
									if (par_level == 0) {
										in_build = FALSE;
										break;
									} else {
										par_level--;
									}
								} else {
									if (_vala_strcmp0 (token, "prog.packages") == 0) {
										char* _tmp9_;
										in_package = vbf_backends_smart_folder_expect_token (self, "=", content, &start_position);
										_tmp9_ = vbf_backends_smart_folder_get_token (self, content, &start_position);
										_g_free0 (_tmp9_);
									}
								}
							}
						} else {
							if (_vala_strcmp0 (token, "def") == 0) {
								in_build = vbf_backends_smart_folder_expect_token (self, "build", content, &start_position);
								start_position = vbf_backends_smart_folder_skip_line (self, content, start_position);
							}
						}
					}
				}
			}
			_g_free0 (token);
		}
		_g_free0 (content);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfsmartfolder.vala:305: Error parsing waf wscript file '%s': %s", filename, err->message);
			_g_error_free0 (err);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean vbf_backends_smart_folder_expect_token (VbfBackendsSmartFolder* self, const char* token, const char* content, gint* start_position) {
	gboolean result = FALSE;
	char* tmp;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (token != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	tmp = vbf_backends_smart_folder_get_token (self, content, start_position);
	result = _vala_strcmp0 (token, tmp) == 0;
	_g_free0 (tmp);
	return result;
}


static char* g_unichar_to_string (gunichar self) {
	char* result = NULL;
	char* str;
	str = (char*) g_new0 (gchar, 7);
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static char* vbf_backends_smart_folder_get_token (VbfBackendsSmartFolder* self, const char* content, gint* start_position) {
	char* result = NULL;
	char* token;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	token = NULL;
	*start_position = vbf_backends_smart_folder_skip_spaces (self, content, *start_position);
	while (TRUE) {
		gunichar ch;
		if (!(!vbf_backends_smart_folder_eof (self, content, *start_position))) {
			break;
		}
		ch = g_utf8_get_char (g_utf8_offset_to_pointer (content, *start_position));
		if (token == NULL) {
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			if (ch != '_') {
				_tmp1_ = ch != '$';
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				_tmp0_ = g_unichar_isalnum (ch) == FALSE;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* _tmp2_;
				token = (_tmp2_ = g_unichar_to_string (ch), _g_free0 (token), _tmp2_);
				(*start_position)++;
				break;
			} else {
				char* _tmp3_;
				token = (_tmp3_ = g_unichar_to_string (ch), _g_free0 (token), _tmp3_);
			}
		} else {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			if (ch == ' ') {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = ch == '\t';
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = ch == '\n';
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = ch == '\r';
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				_tmp9_ = ch == ')';
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				_tmp8_ = ch == '}';
			}
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = ch == '\'';
			}
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = ch == '\"';
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp13_ = FALSE;
				if (ch == '(') {
					_tmp13_ = g_utf8_get_char (g_utf8_offset_to_pointer (token, string_get_length (token) - 1)) != '$';
				} else {
					_tmp13_ = FALSE;
				}
				_tmp5_ = _tmp13_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				if (ch == '{') {
					_tmp14_ = g_utf8_get_char (g_utf8_offset_to_pointer (token, string_get_length (token) - 1)) != '$';
				} else {
					_tmp14_ = FALSE;
				}
				_tmp4_ = _tmp14_;
			}
			if (_tmp4_) {
				break;
			} else {
				char* _tmp15_;
				char* _tmp16_;
				token = (_tmp16_ = g_strconcat (token, _tmp15_ = g_unichar_to_string (ch), NULL), _g_free0 (token), _tmp16_);
				_g_free0 (_tmp15_);
			}
		}
		(*start_position)++;
	}
	result = token;
	return result;
}


static gint vbf_backends_smart_folder_skip_line (VbfBackendsSmartFolder* self, const char* content, gint start_position) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (content != NULL, 0);
	while (TRUE) {
		gunichar ch;
		if (!(!vbf_backends_smart_folder_eof (self, content, start_position))) {
			break;
		}
		ch = g_utf8_get_char (g_utf8_offset_to_pointer (content, start_position));
		if (ch != '\n') {
			start_position++;
		} else {
			break;
		}
	}
	result = start_position;
	return result;
}


static gint vbf_backends_smart_folder_skip_spaces (VbfBackendsSmartFolder* self, const char* content, gint start_position) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (content != NULL, 0);
	while (TRUE) {
		gunichar ch;
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (!(!vbf_backends_smart_folder_eof (self, content, start_position))) {
			break;
		}
		ch = g_utf8_get_char (g_utf8_offset_to_pointer (content, start_position));
		if (g_unichar_isspace (ch)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ch == '\t';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = ch == '\n';
		}
		if (_tmp0_) {
			start_position++;
		} else {
			break;
		}
	}
	result = start_position;
	return result;
}


static gboolean vbf_backends_smart_folder_eof (VbfBackendsSmartFolder* self, const char* content, gint position) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	result = string_get_length (content) <= position;
	return result;
}


static void vbf_backends_smart_folder_add_vala_source (VbfBackendsSmartFolder* self, VbfTarget* target, const char* directory, GFileInfo* file_info) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* file;
	char* _tmp2_;
	char* _tmp3_;
	VbfSource* _tmp4_;
	VbfSource* source;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (file_info != NULL);
	file = (_tmp1_ = g_file_resolve_relative_path (_tmp0_ = g_file_new_for_path (directory), g_file_info_get_name (file_info)), _g_object_unref0 (_tmp0_), _tmp1_);
	vbf_utils_trace ("vbfsmartfolder.vala:387: adding vala source: %s", _tmp2_ = g_file_get_path (file));
	_g_free0 (_tmp2_);
	source = (_tmp4_ = vbf_source_new (target, _tmp3_ = g_file_get_path (file)), _g_free0 (_tmp3_), _tmp4_);
	((VbfFile*) source)->type = VBF_FILE_TYPES_VALA_SOURCE;
	vbf_target_add_source (target, source);
	{
		GFileInputStream* input_stream;
		GDataInputStream* data_stream;
		gint count;
		char* line;
		gsize len = 0UL;
		input_stream = g_file_read (file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		data_stream = g_data_input_stream_new ((GInputStream*) input_stream);
		count = 0;
		line = NULL;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			char* _tmp6_;
			char* _tmp7_;
			GMatchInfo* match;
			GMatchInfo* _tmp8_ = NULL;
			GMatchInfo* _tmp9_;
			_tmp6_ = g_data_input_stream_read_line (data_stream, &len, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (line);
				_g_object_unref0 (data_stream);
				_g_object_unref0 (input_stream);
				goto __catch11_g_error;
			}
			if ((line = (_tmp7_ = _tmp6_, _g_free0 (line), _tmp7_)) != NULL) {
				_tmp5_ = count < 100;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			count++;
			match = NULL;
			g_regex_match (self->priv->_regex, line, G_REGEX_MATCH_NEWLINE_ANY, &_tmp8_);
			match = (_tmp9_ = _tmp8_, _g_match_info_free0 (match), _tmp9_);
			while (TRUE) {
				char* _tmp10_;
				char* _tmp11_;
				char* package_name;
				char* _tmp12_;
				if (!g_match_info_matches (match)) {
					break;
				}
				package_name = (_tmp11_ = vbf_utils_guess_package_vapi (_tmp10_ = g_match_info_fetch (match, 2), NULL, 0), _g_free0 (_tmp10_), _tmp11_);
				vbf_utils_trace ("vbfsmartfolder.vala:405: guessing name for %s: %s", _tmp12_ = g_match_info_fetch (match, 2), package_name);
				_g_free0 (_tmp12_);
				if (package_name != NULL) {
					if (!vbf_target_contains_package (target, package_name)) {
						VbfPackage* _tmp13_;
						vbf_target_add_package (target, _tmp13_ = vbf_package_new (package_name));
						_g_object_unref0 (_tmp13_);
					}
				}
				g_match_info_next (match, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (package_name);
					_g_match_info_free0 (match);
					_g_free0 (line);
					_g_object_unref0 (data_stream);
					_g_object_unref0 (input_stream);
					goto __catch11_g_error;
				}
				_g_free0 (package_name);
			}
			_g_match_info_free0 (match);
		}
		_g_free0 (line);
		_g_object_unref0 (data_stream);
		_g_object_unref0 (input_stream);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp14_;
			g_warning ("vbfsmartfolder.vala:416: error sniffing file %s: %s", _tmp14_ = g_file_get_path (file), err->message);
			_g_free0 (_tmp14_);
			_g_error_free0 (err);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (source);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (source);
	_g_object_unref0 (file);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vbf_backends_smart_folder_add_vapi_source (VbfBackendsSmartFolder* self, VbfTarget* target, const char* directory, GFileInfo* file_info) {
	char* vapifile;
	VbfPackage* package;
	char* path;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* file;
	GFile* _tmp3_;
	char* _tmp4_;
	char* vapidir;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (file_info != NULL);
	vapifile = g_strdup (g_file_info_get_name (file_info));
	if (g_str_has_suffix (vapifile, ".vapi")) {
		char* _tmp0_;
		vapifile = (_tmp0_ = string_substring (vapifile, (glong) 0, string_get_length (vapifile) - 5), _g_free0 (vapifile), _tmp0_);
	}
	vbf_utils_trace ("vbfsmartfolder.vala:427: adding vapi package: %s", vapifile);
	package = vbf_package_new (vapifile);
	vbf_target_add_package (target, package);
	path = g_build_filename (directory, g_file_info_get_name (file_info), NULL);
	file = (_tmp2_ = g_file_resolve_relative_path (_tmp1_ = g_file_new_for_path (path), path), _g_object_unref0 (_tmp1_), _tmp2_);
	vapidir = (_tmp4_ = g_file_get_path (_tmp3_ = g_file_get_parent (file)), _g_object_unref0 (_tmp3_), _tmp4_);
	if (!vbf_target_contains_include_dir (target, vapidir)) {
		vbf_utils_trace ("vbfsmartfolder.vala:437: adding include dir: %s", vapidir);
		vbf_target_add_include_dir (target, vapidir);
	}
	_g_free0 (vapidir);
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_object_unref0 (package);
	_g_free0 (vapifile);
}


void vbf_backends_smart_folder_setup_file_monitors (VbfBackendsSmartFolder* self, VbfProject* project) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	{
		GFile* file;
		GFileMonitor* file_mon;
		file = NULL;
		file_mon = NULL;
		{
			ValaIterator* _dirname_it;
			_dirname_it = vala_iterable_iterator ((ValaIterable*) self->priv->_visited_directory);
			while (TRUE) {
				char* dirname;
				GFile* _tmp0_;
				GFileMonitor* _tmp1_;
				GFileMonitor* _tmp2_;
				if (!vala_iterator_next (_dirname_it)) {
					break;
				}
				dirname = (char*) vala_iterator_get (_dirname_it);
				file = (_tmp0_ = g_file_new_for_path (dirname), _g_object_unref0 (file), _tmp0_);
				vbf_utils_trace ("vbfsmartfolder.vala:450: setup_file_monitors for: %s", dirname);
				_tmp1_ = g_file_monitor_directory (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (dirname);
					_vala_collection_object_unref0 (_dirname_it);
					_g_object_unref0 (file_mon);
					_g_object_unref0 (file);
					goto __catch12_g_error;
				}
				file_mon = (_tmp2_ = _tmp1_, _g_object_unref0 (file_mon), _tmp2_);
				g_signal_connect_object (file_mon, "changed", (GCallback) _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed, self, 0);
				vala_collection_add ((ValaCollection*) self->priv->_file_mons, file_mon);
				_g_free0 (dirname);
			}
			_vala_collection_object_unref0 (_dirname_it);
		}
		_g_object_unref0 (file_mon);
		_g_object_unref0 (file);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfsmartfolder.vala:457: setup_file_monitors error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_smart_folder_on_project_directory_changed (VbfBackendsSmartFolder* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (file != NULL);
	if (!g_file_monitor_is_cancelled (sender)) {
		gboolean _tmp0_ = FALSE;
		if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = event_type == G_FILE_MONITOR_EVENT_DELETED;
		}
		if (_tmp0_) {
			char* _tmp1_;
			gboolean _tmp2_;
			if ((_tmp2_ = vbf_utils_is_vala_source (_tmp1_ = g_file_get_path (file)), _g_free0 (_tmp1_), _tmp2_)) {
				const char* _tmp3_;
				char* _tmp4_;
				_tmp3_ = NULL;
				if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
					_tmp3_ = "created";
				} else {
					_tmp3_ = "deleted";
				}
				vbf_utils_trace ("vbfsmartfolder.vala:466: file %s: %s", _tmp3_, _tmp4_ = g_file_get_path (file));
				_g_free0 (_tmp4_);
				vbf_project_update (self->priv->_project);
			}
		}
	}
}


VbfBackendsSmartFolder* vbf_backends_smart_folder_construct (GType object_type) {
	VbfBackendsSmartFolder * self;
	self = (VbfBackendsSmartFolder*) g_object_new (object_type, NULL);
	return self;
}


VbfBackendsSmartFolder* vbf_backends_smart_folder_new (void) {
	return vbf_backends_smart_folder_construct (VBF_BACKENDS_TYPE_SMART_FOLDER);
}


static char* vbf_backends_smart_folder_real_get_configure_command (VbfIProjectBackend* base) {
	char* result;
	VbfBackendsSmartFolder* self;
	self = (VbfBackendsSmartFolder*) base;
	result = g_strdup (self->priv->_configure_command);
	return result;
}


static char* vbf_backends_smart_folder_real_get_build_command (VbfIProjectBackend* base) {
	char* result;
	VbfBackendsSmartFolder* self;
	self = (VbfBackendsSmartFolder*) base;
	result = g_strdup (self->priv->_build_command);
	return result;
}


static char* vbf_backends_smart_folder_real_get_clean_command (VbfIProjectBackend* base) {
	char* result;
	VbfBackendsSmartFolder* self;
	self = (VbfBackendsSmartFolder*) base;
	result = g_strdup (self->priv->_clean_command);
	return result;
}


static void vbf_backends_smart_folder_class_init (VbfBackendsSmartFolderClass * klass) {
	vbf_backends_smart_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfBackendsSmartFolderPrivate));
	G_OBJECT_CLASS (klass)->get_property = vbf_backends_smart_folder_get_property;
	G_OBJECT_CLASS (klass)->finalize = vbf_backends_smart_folder_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_SMART_FOLDER_CONFIGURE_COMMAND, "configure-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_SMART_FOLDER_BUILD_COMMAND, "build-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_SMART_FOLDER_CLEAN_COMMAND, "clean-command");
}


static void vbf_backends_smart_folder_vbf_iproject_backend_interface_init (VbfIProjectBackendIface * iface) {
	vbf_backends_smart_folder_vbf_iproject_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->probe = vbf_backends_smart_folder_real_probe;
	iface->open = vbf_backends_smart_folder_real_open;
	iface->refresh = vbf_backends_smart_folder_real_refresh;
	iface->get_configure_command = vbf_backends_smart_folder_real_get_configure_command;
	iface->get_build_command = vbf_backends_smart_folder_real_get_build_command;
	iface->get_clean_command = vbf_backends_smart_folder_real_get_clean_command;
}


static void vbf_backends_smart_folder_instance_init (VbfBackendsSmartFolder * self) {
	self->priv = VBF_BACKENDS_SMART_FOLDER_GET_PRIVATE (self);
	self->priv->_file_mons = (ValaList*) vala_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN;
}


static void vbf_backends_smart_folder_finalize (GObject* obj) {
	VbfBackendsSmartFolder * self;
	self = VBF_BACKENDS_SMART_FOLDER (obj);
	_g_free0 (self->priv->_configure_command);
	_g_free0 (self->priv->_build_command);
	_g_free0 (self->priv->_clean_command);
	_g_regex_unref0 (self->priv->_regex);
	_vala_collection_object_unref0 (self->priv->_file_mons);
	_vala_collection_object_unref0 (self->priv->_visited_directory);
	G_OBJECT_CLASS (vbf_backends_smart_folder_parent_class)->finalize (obj);
}


GType vbf_backends_smart_folder_get_type (void) {
	static volatile gsize vbf_backends_smart_folder_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_backends_smart_folder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfBackendsSmartFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_backends_smart_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfBackendsSmartFolder), 0, (GInstanceInitFunc) vbf_backends_smart_folder_instance_init, NULL };
		static const GInterfaceInfo vbf_iproject_backend_info = { (GInterfaceInitFunc) vbf_backends_smart_folder_vbf_iproject_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vbf_backends_smart_folder_type_id;
		vbf_backends_smart_folder_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfBackendsSmartFolder", &g_define_type_info, 0);
		g_type_add_interface_static (vbf_backends_smart_folder_type_id, VBF_TYPE_IPROJECT_BACKEND, &vbf_iproject_backend_info);
		g_once_init_leave (&vbf_backends_smart_folder_type_id__volatile, vbf_backends_smart_folder_type_id);
	}
	return vbf_backends_smart_folder_type_id__volatile;
}


static void vbf_backends_smart_folder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VbfBackendsSmartFolder * self;
	self = VBF_BACKENDS_SMART_FOLDER (object);
	switch (property_id) {
		case VBF_BACKENDS_SMART_FOLDER_CONFIGURE_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_configure_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_SMART_FOLDER_BUILD_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_build_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_SMART_FOLDER_CLEAN_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_clean_command ((VbfIProjectBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




