/* datatype.c generated by valac 0.10.0, the Vala compiler
 * generated from datatype.vala, do not modify */

/* datatype.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gobject/gvaluecollector.h>


#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;
typedef struct _AfroditeDataTypePrivate AfroditeDataTypePrivate;

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;

#define AFRODITE_TYPE_SOURCE_REFERENCE (afrodite_source_reference_get_type ())
#define AFRODITE_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReference))
#define AFRODITE_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))
#define AFRODITE_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))

typedef struct _AfroditeSourceReference AfroditeSourceReference;
typedef struct _AfroditeSourceReferenceClass AfroditeSourceReferenceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
typedef struct _AfroditeParamSpecDataType AfroditeParamSpecDataType;

struct _AfroditeDataType {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeDataTypePrivate * priv;
};

struct _AfroditeDataTypeClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeDataType *self);
};

struct _AfroditeDataTypePrivate {
	AfroditeSymbol* _symbol;
	char* _name;
	gboolean _is_array;
	gboolean _is_pointer;
	gboolean _is_generic;
	gboolean _is_nullable;
	gboolean _is_out;
	gboolean _is_ref;
	gboolean _is_dynamic;
	gboolean _is_ellipsis;
	gboolean _is_iterator;
	char* _default_expression;
	ValaList* _generic_types;
	AfroditeSourceReference* _source_reference;
	char* _type_name;
};

struct _AfroditeParamSpecDataType {
	GParamSpec parent_instance;
};


static gpointer afrodite_data_type_parent_class = NULL;

gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
gpointer afrodite_symbol_ref (gpointer instance);
void afrodite_symbol_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol (GValue* value, gpointer v_object);
void afrodite_value_take_symbol (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol (const GValue* value);
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_reference_ref (gpointer instance);
void afrodite_source_reference_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_reference (GValue* value, gpointer v_object);
void afrodite_value_take_source_reference (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_reference (const GValue* value);
GType afrodite_source_reference_get_type (void) G_GNUC_CONST;
#define AFRODITE_DATA_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypePrivate))
enum  {
	AFRODITE_DATA_TYPE_DUMMY_PROPERTY
};
AfroditeDataType* afrodite_data_type_new (const char* type_name, const char* name);
AfroditeDataType* afrodite_data_type_construct (GType object_type, const char* type_name, const char* name);
void afrodite_data_type_set_name (AfroditeDataType* self, const char* value);
void afrodite_data_type_set_type_name (AfroditeDataType* self, const char* value);
static char* afrodite_data_type_fix_simple_type_name (AfroditeDataType* self, const char* type_name);
static char* afrodite_data_type_process_type_name (AfroditeDataType* self, const char* type_name);
void afrodite_data_type_set_is_pointer (AfroditeDataType* self, gboolean value);
void afrodite_data_type_set_is_nullable (AfroditeDataType* self, gboolean value);
void afrodite_data_type_set_is_array (AfroditeDataType* self, gboolean value);
void afrodite_data_type_set_is_generic (AfroditeDataType* self, gboolean value);
void afrodite_data_type_add_generic_type (AfroditeDataType* self, AfroditeDataType* type);
ValaList* afrodite_data_type_get_generic_types (AfroditeDataType* self);
void afrodite_data_type_set_generic_types (AfroditeDataType* self, ValaList* value);
void afrodite_data_type_remove_generic_type (AfroditeDataType* self, AfroditeDataType* type);
AfroditeDataType* afrodite_data_type_copy (AfroditeDataType* self);
const char* afrodite_data_type_get_type_name (AfroditeDataType* self);
const char* afrodite_data_type_get_name (AfroditeDataType* self);
void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value);
gboolean afrodite_data_type_get_is_array (AfroditeDataType* self);
gboolean afrodite_data_type_get_is_pointer (AfroditeDataType* self);
gboolean afrodite_data_type_get_is_generic (AfroditeDataType* self);
gboolean afrodite_data_type_get_is_nullable (AfroditeDataType* self);
gboolean afrodite_data_type_get_is_out (AfroditeDataType* self);
void afrodite_data_type_set_is_out (AfroditeDataType* self, gboolean value);
gboolean afrodite_data_type_get_is_ref (AfroditeDataType* self);
void afrodite_data_type_set_is_ref (AfroditeDataType* self, gboolean value);
gboolean afrodite_data_type_get_is_dynamic (AfroditeDataType* self);
void afrodite_data_type_set_is_dynamic (AfroditeDataType* self, gboolean value);
gboolean afrodite_data_type_get_is_ellipsis (AfroditeDataType* self);
void afrodite_data_type_set_is_ellipsis (AfroditeDataType* self, gboolean value);
gboolean afrodite_data_type_get_is_iterator (AfroditeDataType* self);
void afrodite_data_type_set_is_iterator (AfroditeDataType* self, gboolean value);
const char* afrodite_data_type_get_default_expression (AfroditeDataType* self);
void afrodite_data_type_set_default_expression (AfroditeDataType* self, const char* value);
AfroditeSourceReference* afrodite_data_type_get_source_reference (AfroditeDataType* self);
void afrodite_data_type_set_source_reference (AfroditeDataType* self, AfroditeSourceReference* value);
AfroditeSymbol* afrodite_data_type_get_symbol (AfroditeDataType* self);
gboolean afrodite_data_type_get_unresolved (AfroditeDataType* self);
gboolean afrodite_data_type_get_has_generic_types (AfroditeDataType* self);
char* afrodite_data_type_get_description (AfroditeDataType* self);
const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self);
static void afrodite_data_type_finalize (AfroditeDataType* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



AfroditeDataType* afrodite_data_type_construct (GType object_type, const char* type_name, const char* name) {
	AfroditeDataType* self;
	g_return_val_if_fail (type_name != NULL, NULL);
	self = (AfroditeDataType*) g_type_create_instance (object_type);
	afrodite_data_type_set_name (self, name);
	afrodite_data_type_set_type_name (self, type_name);
	return self;
}


AfroditeDataType* afrodite_data_type_new (const char* type_name, const char* name) {
	return afrodite_data_type_construct (AFRODITE_TYPE_DATA_TYPE, type_name, name);
}


static char* afrodite_data_type_fix_simple_type_name (AfroditeDataType* self, const char* type_name) {
	char* result = NULL;
	gint types_length1;
	gint _types_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** types;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	types = (_tmp1_ = _tmp0_ = g_strsplit (type_name, ".", 0), types_length1 = _vala_array_length (_tmp0_), _types_size_ = types_length1, _tmp1_);
	if (types_length1 > 1) {
		char* _result_;
		_result_ = NULL;
		{
			char** type_collection;
			int type_collection_length1;
			int type_it;
			type_collection = types;
			type_collection_length1 = types_length1;
			for (type_it = 0; type_it < types_length1; type_it = type_it + 1) {
				char* type;
				type = g_strdup (type_collection[type_it]);
				{
					gboolean _tmp2_ = FALSE;
					gboolean _tmp3_ = FALSE;
					if (_vala_strcmp0 (type, "int") != 0) {
						_tmp3_ = _vala_strcmp0 (type, "float") != 0;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						_tmp2_ = _vala_strcmp0 (type, "double") != 0;
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						result = g_strdup (type_name);
						_g_free0 (type);
						_g_free0 (_result_);
						types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					if (_result_ == NULL) {
						char* _tmp4_;
						_result_ = (_tmp4_ = g_strdup (type), _g_free0 (_result_), _tmp4_);
					} else {
						if (_vala_strcmp0 (_result_, type) != 0) {
							gboolean _tmp5_ = FALSE;
							if (_vala_strcmp0 (_result_, "int") == 0) {
								gboolean _tmp6_ = FALSE;
								if (_vala_strcmp0 (type, "float") == 0) {
									_tmp6_ = TRUE;
								} else {
									_tmp6_ = _vala_strcmp0 (type, "double") == 0;
								}
								_tmp5_ = _tmp6_;
							} else {
								_tmp5_ = FALSE;
							}
							if (_tmp5_) {
								char* _tmp7_;
								_result_ = (_tmp7_ = g_strdup (type), _g_free0 (_result_), _tmp7_);
							}
						}
					}
					_g_free0 (type);
				}
			}
		}
		result = _result_;
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		result = g_strdup (type_name);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* afrodite_data_type_process_type_name (AfroditeDataType* self, const char* type_name) {
	char* result = NULL;
	GString* sb;
	gint skip_level;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	sb = g_string_new ("");
	skip_level = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gunichar ch;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < string_get_length (type_name))) {
					break;
				}
				ch = g_utf8_get_char (g_utf8_offset_to_pointer (type_name, i));
				if (skip_level > 0) {
					gboolean _tmp1_ = FALSE;
					if (ch == ']') {
						_tmp1_ = TRUE;
					} else {
						_tmp1_ = ch == '>';
					}
					if (_tmp1_) {
						skip_level--;
					}
					continue;
				}
				if (ch == '*') {
					afrodite_data_type_set_is_pointer (self, TRUE);
				} else {
					if (ch == '?') {
						afrodite_data_type_set_is_nullable (self, TRUE);
					} else {
						if (ch == '!') {
							afrodite_data_type_set_is_nullable (self, FALSE);
						} else {
							if (ch == '[') {
								afrodite_data_type_set_is_array (self, TRUE);
								skip_level++;
							} else {
								if (ch == '<') {
									afrodite_data_type_set_is_generic (self, TRUE);
									skip_level++;
								} else {
									g_string_append_unichar (sb, ch);
								}
							}
						}
					}
				}
			}
		}
	}
	result = g_strdup (sb->str);
	_g_string_free0 (sb);
	return result;
}


void afrodite_data_type_add_generic_type (AfroditeDataType* self, AfroditeDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (self->priv->_generic_types == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_data_type_set_generic_types (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_DATA_TYPE, (GBoxedCopyFunc) afrodite_data_type_ref, afrodite_data_type_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_generic_types, type);
}


void afrodite_data_type_remove_generic_type (AfroditeDataType* self, AfroditeDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_generic_types, type);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_generic_types) == 0) {
		afrodite_data_type_set_generic_types (self, NULL);
	}
}


AfroditeDataType* afrodite_data_type_copy (AfroditeDataType* self) {
	AfroditeDataType* result = NULL;
	AfroditeDataType* res;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	res = afrodite_data_type_new (afrodite_data_type_get_type_name (self), self->priv->_name);
	res->priv->_type_name = (_tmp0_ = g_strdup (afrodite_data_type_get_type_name (self)), _g_free0 (res->priv->_type_name), _tmp0_);
	afrodite_data_type_set_name (res, self->priv->_name);
	afrodite_data_type_set_symbol (res, NULL);
	afrodite_data_type_set_is_array (res, self->priv->_is_array);
	afrodite_data_type_set_is_pointer (res, self->priv->_is_pointer);
	afrodite_data_type_set_is_generic (res, self->priv->_is_generic);
	afrodite_data_type_set_is_nullable (res, self->priv->_is_nullable);
	afrodite_data_type_set_is_out (res, self->priv->_is_out);
	afrodite_data_type_set_is_ref (res, self->priv->_is_ref);
	afrodite_data_type_set_is_dynamic (res, self->priv->_is_dynamic);
	afrodite_data_type_set_is_ellipsis (res, self->priv->_is_ellipsis);
	afrodite_data_type_set_is_iterator (res, self->priv->_is_iterator);
	afrodite_data_type_set_default_expression (res, self->priv->_default_expression);
	if (self->priv->_generic_types != NULL) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_generic_types);
			while (TRUE) {
				AfroditeDataType* item;
				AfroditeDataType* _tmp1_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				afrodite_data_type_add_generic_type (res, _tmp1_ = afrodite_data_type_copy (item));
				_afrodite_data_type_unref0 (_tmp1_);
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	afrodite_data_type_set_source_reference (res, self->priv->_source_reference);
	result = res;
	return result;
}


AfroditeSymbol* afrodite_data_type_get_symbol (AfroditeDataType* self) {
	AfroditeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_symbol;
	return result;
}


void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_symbol = value;
}


const char* afrodite_data_type_get_name (AfroditeDataType* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void afrodite_data_type_set_name (AfroditeDataType* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
}


gboolean afrodite_data_type_get_is_array (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_array;
	return result;
}


void afrodite_data_type_set_is_array (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_array = value;
}


gboolean afrodite_data_type_get_is_pointer (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_pointer;
	return result;
}


void afrodite_data_type_set_is_pointer (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_pointer = value;
}


gboolean afrodite_data_type_get_is_generic (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_generic;
	return result;
}


void afrodite_data_type_set_is_generic (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_generic = value;
}


gboolean afrodite_data_type_get_is_nullable (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_nullable;
	return result;
}


void afrodite_data_type_set_is_nullable (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_nullable = value;
}


gboolean afrodite_data_type_get_is_out (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_out;
	return result;
}


void afrodite_data_type_set_is_out (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_out = value;
}


gboolean afrodite_data_type_get_is_ref (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_ref;
	return result;
}


void afrodite_data_type_set_is_ref (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_ref = value;
}


gboolean afrodite_data_type_get_is_dynamic (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_dynamic;
	return result;
}


void afrodite_data_type_set_is_dynamic (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_dynamic = value;
}


gboolean afrodite_data_type_get_is_ellipsis (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_ellipsis;
	return result;
}


void afrodite_data_type_set_is_ellipsis (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_ellipsis = value;
}


gboolean afrodite_data_type_get_is_iterator (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_iterator;
	return result;
}


void afrodite_data_type_set_is_iterator (AfroditeDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_iterator = value;
}


const char* afrodite_data_type_get_default_expression (AfroditeDataType* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_expression;
	return result;
}


void afrodite_data_type_set_default_expression (AfroditeDataType* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_default_expression = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_default_expression), _tmp0_);
}


ValaList* afrodite_data_type_get_generic_types (AfroditeDataType* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_generic_types;
	return result;
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


void afrodite_data_type_set_generic_types (AfroditeDataType* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_generic_types = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_generic_types), _tmp0_);
}


AfroditeSourceReference* afrodite_data_type_get_source_reference (AfroditeDataType* self) {
	AfroditeSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_reference;
	return result;
}


static gpointer _afrodite_source_reference_ref0 (gpointer self) {
	return self ? afrodite_source_reference_ref (self) : NULL;
}


void afrodite_data_type_set_source_reference (AfroditeDataType* self, AfroditeSourceReference* value) {
	AfroditeSourceReference* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_reference = (_tmp0_ = _afrodite_source_reference_ref0 (value), _afrodite_source_reference_unref0 (self->priv->_source_reference), _tmp0_);
}


const char* afrodite_data_type_get_type_name (AfroditeDataType* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_name;
	return result;
}


void afrodite_data_type_set_type_name (AfroditeDataType* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_type_name = (_tmp1_ = afrodite_data_type_process_type_name (self, _tmp0_ = afrodite_data_type_fix_simple_type_name (self, value)), _g_free0 (self->priv->_type_name), _tmp1_);
	_g_free0 (_tmp0_);
}


gboolean afrodite_data_type_get_unresolved (AfroditeDataType* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (afrodite_data_type_get_type_name (self) != NULL) {
		_tmp0_ = self->priv->_symbol == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean afrodite_data_type_get_has_generic_types (AfroditeDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_generic_types != NULL;
	return result;
}


char* afrodite_data_type_get_description (AfroditeDataType* self) {
	char* result;
	char* res;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	if (self->priv->_is_ellipsis) {
		char* _tmp0_;
		res = (_tmp0_ = g_strdup ("..."), _g_free0 (res), _tmp0_);
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp16_ = FALSE;
		if (self->priv->_is_out) {
			char* _tmp1_;
			res = (_tmp1_ = g_strdup ("out "), _g_free0 (res), _tmp1_);
		} else {
			if (self->priv->_is_ref) {
				char* _tmp2_;
				res = (_tmp2_ = g_strdup ("ref "), _g_free0 (res), _tmp2_);
			} else {
				char* _tmp3_;
				res = (_tmp3_ = g_strdup (""), _g_free0 (res), _tmp3_);
			}
		}
		if (self->priv->_is_dynamic) {
			char* _tmp4_;
			res = (_tmp4_ = g_strconcat (res, "dynamic ", NULL), _g_free0 (res), _tmp4_);
		}
		if (self->priv->_symbol == NULL) {
			char* _tmp5_;
			char* _tmp6_;
			res = (_tmp6_ = g_strconcat (res, _tmp5_ = g_strdup_printf ("%s!", afrodite_data_type_get_type_name (self)), NULL), _g_free0 (res), _tmp6_);
			_g_free0 (_tmp5_);
		} else {
			char* _tmp7_;
			res = (_tmp7_ = g_strconcat (res, afrodite_symbol_get_fully_qualified_name (self->priv->_symbol), NULL), _g_free0 (res), _tmp7_);
		}
		if (self->priv->_is_pointer) {
			char* _tmp8_;
			res = (_tmp8_ = g_strconcat (res, "*", NULL), _g_free0 (res), _tmp8_);
		}
		if (self->priv->_is_array) {
			char* _tmp9_;
			res = (_tmp9_ = g_strconcat (res, "[]", NULL), _g_free0 (res), _tmp9_);
		}
		if (afrodite_data_type_get_has_generic_types (self)) {
			GString* sb;
			char* _tmp11_;
			sb = g_string_new ("");
			g_string_append (sb, "&lt;");
			{
				ValaIterator* _t_it;
				_t_it = vala_iterable_iterator ((ValaIterable*) self->priv->_generic_types);
				while (TRUE) {
					AfroditeDataType* t;
					char* _tmp10_;
					if (!vala_iterator_next (_t_it)) {
						break;
					}
					t = (AfroditeDataType*) vala_iterator_get (_t_it);
					g_string_append_printf (sb, "%s, ", _tmp10_ = afrodite_data_type_get_description (t));
					_g_free0 (_tmp10_);
					_afrodite_data_type_unref0 (t);
				}
				_vala_collection_object_unref0 (_t_it);
			}
			g_string_truncate (sb, (gsize) (sb->len - 2));
			g_string_append (sb, "&gt;");
			res = (_tmp11_ = g_strconcat (res, sb->str, NULL), _g_free0 (res), _tmp11_);
			_g_string_free0 (sb);
		}
		if (self->priv->_is_nullable) {
			char* _tmp12_;
			res = (_tmp12_ = g_strconcat (res, "?", NULL), _g_free0 (res), _tmp12_);
		}
		if (self->priv->_name != NULL) {
			_tmp13_ = _vala_strcmp0 (self->priv->_name, "") != 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			char* _tmp14_;
			char* _tmp15_;
			res = (_tmp15_ = g_strconcat (res, _tmp14_ = g_strdup_printf (" %s", self->priv->_name), NULL), _g_free0 (res), _tmp15_);
			_g_free0 (_tmp14_);
		}
		if (self->priv->_default_expression != NULL) {
			_tmp16_ = _vala_strcmp0 (self->priv->_default_expression, "") != 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			char* _tmp17_;
			char* _tmp18_;
			res = (_tmp18_ = g_strconcat (res, _tmp17_ = g_strconcat (" = ", self->priv->_default_expression, NULL), NULL), _g_free0 (res), _tmp18_);
			_g_free0 (_tmp17_);
		}
	}
	result = res;
	return result;
}


static void afrodite_value_data_type_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void afrodite_value_data_type_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		afrodite_data_type_unref (value->data[0].v_pointer);
	}
}


static void afrodite_value_data_type_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = afrodite_data_type_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer afrodite_value_data_type_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* afrodite_value_data_type_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AfroditeDataType* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = afrodite_data_type_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* afrodite_value_data_type_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AfroditeDataType** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = afrodite_data_type_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AfroditeParamSpecDataType* spec;
	g_return_val_if_fail (g_type_is_a (object_type, AFRODITE_TYPE_DATA_TYPE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer afrodite_value_get_data_type (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_DATA_TYPE), NULL);
	return value->data[0].v_pointer;
}


void afrodite_value_set_data_type (GValue* value, gpointer v_object) {
	AfroditeDataType* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_DATA_TYPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_TYPE_DATA_TYPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		afrodite_data_type_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_data_type_unref (old);
	}
}


void afrodite_value_take_data_type (GValue* value, gpointer v_object) {
	AfroditeDataType* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_DATA_TYPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_TYPE_DATA_TYPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_data_type_unref (old);
	}
}


static void afrodite_data_type_class_init (AfroditeDataTypeClass * klass) {
	afrodite_data_type_parent_class = g_type_class_peek_parent (klass);
	AFRODITE_DATA_TYPE_CLASS (klass)->finalize = afrodite_data_type_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeDataTypePrivate));
}


static void afrodite_data_type_instance_init (AfroditeDataType * self) {
	self->priv = AFRODITE_DATA_TYPE_GET_PRIVATE (self);
	self->priv->_type_name = NULL;
	self->ref_count = 1;
}


static void afrodite_data_type_finalize (AfroditeDataType* obj) {
	AfroditeDataType * self;
	self = AFRODITE_DATA_TYPE (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_default_expression);
	_vala_collection_object_unref0 (self->priv->_generic_types);
	_afrodite_source_reference_unref0 (self->priv->_source_reference);
	_g_free0 (self->priv->_type_name);
}


GType afrodite_data_type_get_type (void) {
	static volatile gsize afrodite_data_type_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_data_type_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { afrodite_value_data_type_init, afrodite_value_data_type_free_value, afrodite_value_data_type_copy_value, afrodite_value_data_type_peek_pointer, "p", afrodite_value_data_type_collect_value, "p", afrodite_value_data_type_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeDataTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_data_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeDataType), 0, (GInstanceInitFunc) afrodite_data_type_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType afrodite_data_type_type_id;
		afrodite_data_type_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AfroditeDataType", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&afrodite_data_type_type_id__volatile, afrodite_data_type_type_id);
	}
	return afrodite_data_type_type_id__volatile;
}


gpointer afrodite_data_type_ref (gpointer instance) {
	AfroditeDataType* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void afrodite_data_type_unref (gpointer instance) {
	AfroditeDataType* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AFRODITE_DATA_TYPE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




