/* ast.c generated by valac 0.10.0, the Vala compiler
 * generated from ast.vala, do not modify */

/* ast.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define AFRODITE_TYPE_AST (afrodite_ast_get_type ())
#define AFRODITE_AST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST, AfroditeAst))
#define AFRODITE_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST, AfroditeAstClass))
#define AFRODITE_IS_AST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST))
#define AFRODITE_IS_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST))
#define AFRODITE_AST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST, AfroditeAstClass))

typedef struct _AfroditeAst AfroditeAst;
typedef struct _AfroditeAstClass AfroditeAstClass;
typedef struct _AfroditeAstPrivate AfroditeAstPrivate;

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _afrodite_symbol_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_unref (var), NULL)))

#define AFRODITE_TYPE_COMPARE_MODE (afrodite_compare_mode_get_type ())

#define AFRODITE_TYPE_SYMBOL_ACCESSIBILITY (afrodite_symbol_accessibility_get_type ())

#define AFRODITE_TYPE_MEMBER_BINDING (afrodite_member_binding_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define AFRODITE_TYPE_CASE_SENSITIVENESS (afrodite_case_sensitiveness_get_type ())
typedef struct _AfroditeSymbolPrivate AfroditeSymbolPrivate;
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))

#define AFRODITE_TYPE_QUERY_OPTIONS (afrodite_query_options_get_type ())
#define AFRODITE_QUERY_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_QUERY_OPTIONS, AfroditeQueryOptions))
#define AFRODITE_QUERY_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_QUERY_OPTIONS, AfroditeQueryOptionsClass))
#define AFRODITE_IS_QUERY_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_QUERY_OPTIONS))
#define AFRODITE_IS_QUERY_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_QUERY_OPTIONS))
#define AFRODITE_QUERY_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_QUERY_OPTIONS, AfroditeQueryOptionsClass))

typedef struct _AfroditeQueryOptions AfroditeQueryOptions;
typedef struct _AfroditeQueryOptionsClass AfroditeQueryOptionsClass;

#define AFRODITE_TYPE_QUERY_RESULT (afrodite_query_result_get_type ())
#define AFRODITE_QUERY_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_QUERY_RESULT, AfroditeQueryResult))
#define AFRODITE_QUERY_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_QUERY_RESULT, AfroditeQueryResultClass))
#define AFRODITE_IS_QUERY_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_QUERY_RESULT))
#define AFRODITE_IS_QUERY_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_QUERY_RESULT))
#define AFRODITE_QUERY_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_QUERY_RESULT, AfroditeQueryResultClass))

typedef struct _AfroditeQueryResult AfroditeQueryResult;
typedef struct _AfroditeQueryResultClass AfroditeQueryResultClass;

#define AFRODITE_TYPE_LOOKUP_MODE (afrodite_lookup_mode_get_type ())
typedef struct _AfroditeQueryOptionsPrivate AfroditeQueryOptionsPrivate;

#define AFRODITE_TYPE_RESULT_ITEM (afrodite_result_item_get_type ())
#define AFRODITE_RESULT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_RESULT_ITEM, AfroditeResultItem))
#define AFRODITE_RESULT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_RESULT_ITEM, AfroditeResultItemClass))
#define AFRODITE_IS_RESULT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_RESULT_ITEM))
#define AFRODITE_IS_RESULT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_RESULT_ITEM))
#define AFRODITE_RESULT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_RESULT_ITEM, AfroditeResultItemClass))

typedef struct _AfroditeResultItem AfroditeResultItem;
typedef struct _AfroditeResultItemClass AfroditeResultItemClass;
#define _afrodite_result_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_result_item_unref (var), NULL)))
#define _afrodite_query_result_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_result_unref (var), NULL)))

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;

#define AFRODITE_TYPE_SOURCE_REFERENCE (afrodite_source_reference_get_type ())
#define AFRODITE_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReference))
#define AFRODITE_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))
#define AFRODITE_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))

typedef struct _AfroditeSourceReference AfroditeSourceReference;
typedef struct _AfroditeSourceReferenceClass AfroditeSourceReferenceClass;
typedef struct _AfroditeSourceReferencePrivate AfroditeSourceReferencePrivate;
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
typedef struct _AfroditeParamSpecAst AfroditeParamSpecAst;

struct _AfroditeAst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeAstPrivate * priv;
	ValaHashMap* symbols;
	ValaList* unresolved_symbols;
};

struct _AfroditeAstClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeAst *self);
};

struct _AfroditeAstPrivate {
	AfroditeSymbol* _root;
	ValaList* _source_files;
};

typedef enum  {
	AFRODITE_COMPARE_MODE_EXACT,
	AFRODITE_COMPARE_MODE_START_WITH
} AfroditeCompareMode;

typedef enum  {
	AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE = 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL = 1 << 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED = 1 << 2,
	AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC = 1 << 3,
	AFRODITE_SYMBOL_ACCESSIBILITY_ANY = ((AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC
} AfroditeSymbolAccessibility;

typedef enum  {
	AFRODITE_MEMBER_BINDING_INSTANCE = 1,
	AFRODITE_MEMBER_BINDING_CLASS = 1 << 1,
	AFRODITE_MEMBER_BINDING_STATIC = 1 << 2,
	AFRODITE_MEMBER_BINDING_ANY = (AFRODITE_MEMBER_BINDING_INSTANCE | AFRODITE_MEMBER_BINDING_CLASS) | AFRODITE_MEMBER_BINDING_STATIC
} AfroditeMemberBinding;

typedef enum  {
	AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE,
	AFRODITE_CASE_SENSITIVENESS_CASE_INSENSITIVE,
	AFRODITE_CASE_SENSITIVENESS_AUTO
} AfroditeCaseSensitiveness;

struct _AfroditeSymbol {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSymbolPrivate * priv;
	ValaList* resolved_targets;
	ValaList* resolve_targets;
	AfroditeMemberBinding binding;
	gboolean is_virtual;
	gboolean is_abstract;
	gboolean overrides;
	gint _static_child_count;
	gint _creation_method_child_count;
};

struct _AfroditeSymbolClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSymbol *self);
};

typedef enum  {
	AFRODITE_LOOKUP_MODE_Symbol,
	AFRODITE_LOOKUP_MODE_Type
} AfroditeLookupMode;

struct _AfroditeQueryOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeQueryOptionsPrivate * priv;
	gboolean all_symbols;
	gboolean only_creation_methods;
	gboolean only_static_factories;
	gboolean only_error_domains;
	gboolean exclude_creation_methods;
	gboolean exclude_code_node;
	AfroditeSymbolAccessibility access;
	gboolean auto_member_binding_mode;
	AfroditeMemberBinding binding;
	AfroditeCompareMode compare_mode;
};

struct _AfroditeQueryOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeQueryOptions *self);
};

struct _AfroditeSourceReference {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSourceReferencePrivate * priv;
	AfroditeSourceFile* file;
	gint first_line;
	gint last_line;
	gint first_column;
	gint last_column;
};

struct _AfroditeSourceReferenceClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSourceReference *self);
};

struct _AfroditeParamSpecAst {
	GParamSpec parent_instance;
};


static gpointer afrodite_ast_parent_class = NULL;

gpointer afrodite_ast_ref (gpointer instance);
void afrodite_ast_unref (gpointer instance);
GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_ast (GValue* value, gpointer v_object);
void afrodite_value_take_ast (GValue* value, gpointer v_object);
gpointer afrodite_value_get_ast (const GValue* value);
GType afrodite_ast_get_type (void) G_GNUC_CONST;
gpointer afrodite_symbol_ref (gpointer instance);
void afrodite_symbol_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol (GValue* value, gpointer v_object);
void afrodite_value_take_symbol (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol (const GValue* value);
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
#define AFRODITE_AST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_AST, AfroditeAstPrivate))
enum  {
	AFRODITE_AST_DUMMY_PROPERTY
};
AfroditeSymbol* afrodite_symbol_new (const char* fully_qualified_name, const char* type_name);
AfroditeSymbol* afrodite_symbol_construct (GType object_type, const char* fully_qualified_name, const char* type_name);
void afrodite_ast_dump_symbols (AfroditeAst* self);
void afrodite_utils_trace (const char* format, ...);
const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self);
AfroditeSymbol* afrodite_ast_lookup (AfroditeAst* self, const char* fully_qualified_name);
gboolean afrodite_symbol_get_has_children (AfroditeSymbol* self);
GType afrodite_compare_mode_get_type (void) G_GNUC_CONST;
GType afrodite_symbol_accessibility_get_type (void) G_GNUC_CONST;
GType afrodite_member_binding_get_type (void) G_GNUC_CONST;
AfroditeSymbol* afrodite_ast_lookup_symbol (const char* qualified_name, AfroditeSymbol* parent_symbol, AfroditeSymbol** parent, AfroditeCompareMode mode, AfroditeSymbolAccessibility access, AfroditeMemberBinding binding);
ValaList* afrodite_symbol_get_children (AfroditeSymbol* self);
GType afrodite_case_sensitiveness_get_type (void) G_GNUC_CONST;
static gboolean afrodite_ast_compare_symbol_names (const char* name1, const char* name2, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness);
const char* afrodite_symbol_get_name (AfroditeSymbol* self);
AfroditeSymbolAccessibility afrodite_symbol_get_access (AfroditeSymbol* self);
AfroditeSourceFile* afrodite_ast_add_source_file (AfroditeAst* self, const char* filename);
AfroditeSourceFile* afrodite_ast_lookup_source_file (AfroditeAst* self, const char* filename);
AfroditeSourceFile* afrodite_source_file_new (const char* filename);
AfroditeSourceFile* afrodite_source_file_construct (GType object_type, const char* filename);
ValaList* afrodite_ast_get_source_files (AfroditeAst* self);
void afrodite_ast_set_source_files (AfroditeAst* self, ValaList* value);
void afrodite_source_file_set_parent (AfroditeSourceFile* self, AfroditeAst* value);
const char* afrodite_source_file_get_filename (AfroditeSourceFile* self);
void afrodite_ast_remove_source (AfroditeAst* self, AfroditeSourceFile* source);
AfroditeSymbol* afrodite_ast_lookup_symbol_at (AfroditeAst* self, const char* filename, gint line, gint column);
gboolean afrodite_source_file_get_has_symbols (AfroditeSourceFile* self);
AfroditeSymbol* afrodite_ast_get_symbol_for_source_and_position (AfroditeAst* self, AfroditeSourceFile* source, gint line, gint column);
gpointer afrodite_query_options_ref (gpointer instance);
void afrodite_query_options_unref (gpointer instance);
GParamSpec* afrodite_param_spec_query_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_query_options (GValue* value, gpointer v_object);
void afrodite_value_take_query_options (GValue* value, gpointer v_object);
gpointer afrodite_value_get_query_options (const GValue* value);
GType afrodite_query_options_get_type (void) G_GNUC_CONST;
gpointer afrodite_query_result_ref (gpointer instance);
void afrodite_query_result_unref (gpointer instance);
GParamSpec* afrodite_param_spec_query_result (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_query_result (GValue* value, gpointer v_object);
void afrodite_value_take_query_result (GValue* value, gpointer v_object);
gpointer afrodite_value_get_query_result (const GValue* value);
GType afrodite_query_result_get_type (void) G_GNUC_CONST;
AfroditeQueryResult* afrodite_ast_get_symbol_for_name_and_path (AfroditeAst* self, AfroditeQueryOptions* options, const char* symbol_qualified_name, const char* path, gint line, gint column);
AfroditeQueryResult* afrodite_query_result_new (void);
AfroditeQueryResult* afrodite_query_result_construct (GType object_type);
GType afrodite_lookup_mode_get_type (void) G_GNUC_CONST;
static AfroditeSymbol* afrodite_ast_get_symbol_or_type_for_name_and_path (AfroditeAst* self, AfroditeLookupMode mode, AfroditeMemberBinding binding, AfroditeQueryOptions* options, const char* symbol_qualified_name, const char* path, gint line, gint column);
gpointer afrodite_result_item_ref (gpointer instance);
void afrodite_result_item_unref (gpointer instance);
GParamSpec* afrodite_param_spec_result_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_result_item (GValue* value, gpointer v_object);
void afrodite_value_take_result_item (GValue* value, gpointer v_object);
gpointer afrodite_value_get_result_item (const GValue* value);
GType afrodite_result_item_get_type (void) G_GNUC_CONST;
AfroditeResultItem* afrodite_query_result_new_result_item (AfroditeQueryResult* self, AfroditeResultItem* parent, AfroditeSymbol* symbol);
void afrodite_query_result_add_result_item (AfroditeQueryResult* self, AfroditeResultItem* item);
AfroditeQueryResult* afrodite_ast_get_symbol_type_for_name_and_path (AfroditeAst* self, AfroditeQueryOptions* options, const char* symbol_qualified_name, const char* path, gint line, gint column);
static AfroditeSymbol* afrodite_ast_lookup_name_with_symbol (AfroditeAst* self, const char* name, AfroditeSymbol* symbol, AfroditeSourceFile* source, AfroditeCompareMode mode, AfroditeSymbolAccessibility access, AfroditeMemberBinding binding);
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
AfroditeDataType* afrodite_symbol_get_symbol_type (AfroditeSymbol* self);
AfroditeSymbol* afrodite_data_type_get_symbol (AfroditeDataType* self);
const char* afrodite_symbol_get_type_name (AfroditeSymbol* self);
static AfroditeSymbol* afrodite_ast_lookup_name_in_base_types (AfroditeAst* self, const char* name, AfroditeSymbol* symbol, AfroditeSymbolAccessibility access, AfroditeMemberBinding binding);
AfroditeQueryResult* afrodite_ast_get_symbols_for_path (AfroditeAst* self, AfroditeQueryOptions* options, const char* path);
static void afrodite_ast_get_child_symbols_for_path (AfroditeAst* self, AfroditeQueryResult* _result_, AfroditeQueryOptions* options, const char* path, AfroditeResultItem* parent);
ValaList* afrodite_result_item_get_children (AfroditeResultItem* self);
AfroditeSymbol* afrodite_result_item_get_symbol (AfroditeResultItem* self);
static gboolean afrodite_ast_symbol_has_filename_reference (AfroditeAst* self, const char* filename, AfroditeSymbol* symbol);
gboolean afrodite_symbol_check_options (AfroditeSymbol* self, AfroditeQueryOptions* options);
void afrodite_result_item_add_result_item (AfroditeResultItem* self, AfroditeResultItem* item);
AfroditeSymbol* afrodite_symbol_get_parent (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_source_references (AfroditeSymbol* self);
gpointer afrodite_source_reference_ref (gpointer instance);
void afrodite_source_reference_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_reference (GValue* value, gpointer v_object);
void afrodite_value_take_source_reference (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_reference (const GValue* value);
GType afrodite_source_reference_get_type (void) G_GNUC_CONST;
ValaList* afrodite_symbol_get_source_references (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_base_types (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_base_types (AfroditeSymbol* self);
gboolean afrodite_data_type_get_unresolved (AfroditeDataType* self);
static AfroditeSymbol* afrodite_ast_lookup_this_symbol (AfroditeAst* self, AfroditeSymbol* root);
static void afrodite_ast_append_visible_symbols (AfroditeAst* self, ValaList* results, AfroditeSymbol* symbol, const char* name, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness, AfroditeSymbolAccessibility access);
gboolean afrodite_symbol_get_has_local_variables (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_local_variables (AfroditeSymbol* self);
const char* afrodite_data_type_get_name (AfroditeDataType* self);
const char* afrodite_data_type_get_type_name (AfroditeDataType* self);
AfroditeDataType* afrodite_data_type_copy (AfroditeDataType* self);
void afrodite_symbol_set_return_type (AfroditeSymbol* self, AfroditeDataType* value);
AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self);
void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value);
gboolean afrodite_symbol_get_has_parameters (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_parameters (AfroditeSymbol* self);
static void afrodite_ast_append_all_visible_symbols (AfroditeAst* self, ValaList* results, AfroditeSymbol* symbol, const char* name, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness);
ValaList* afrodite_ast_lookup_visible_symbols_from_symbol (AfroditeAst* self, AfroditeSymbol* symbol, const char* name, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness);
gboolean afrodite_source_file_get_has_using_directives (AfroditeSourceFile* self);
ValaList* afrodite_source_file_get_using_directives (AfroditeSourceFile* self);
ValaList* afrodite_source_file_get_symbols (AfroditeSourceFile* self);
AfroditeSourceReference* afrodite_symbol_lookup_source_reference_sourcefile (AfroditeSymbol* self, AfroditeSourceFile* source);
gboolean afrodite_source_reference_contains_position (AfroditeSourceReference* self, gint line, gint column);
gboolean afrodite_source_reference_contains_source_reference (AfroditeSourceReference* self, AfroditeSourceReference* child);
AfroditeAst* afrodite_ast_new (void);
AfroditeAst* afrodite_ast_construct (GType object_type);
AfroditeSymbol* afrodite_ast_get_root (AfroditeAst* self);
void afrodite_ast_set_root (AfroditeAst* self, AfroditeSymbol* value);
gboolean afrodite_ast_get_has_source_files (AfroditeAst* self);
static void afrodite_ast_finalize (AfroditeAst* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



void afrodite_ast_dump_symbols (AfroditeAst* self) {
	g_return_if_fail (self != NULL);
	{
		ValaCollection* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _s_it;
		_s_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_map_get_values ((ValaMap*) self->symbols))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			AfroditeSymbol* s;
			if (!vala_iterator_next (_s_it)) {
				break;
			}
			s = (AfroditeSymbol*) vala_iterator_get (_s_it);
			afrodite_utils_trace ("ast.vala:46: %s (%p)", afrodite_symbol_get_fully_qualified_name (s), s);
		}
		_vala_collection_object_unref0 (_s_it);
	}
}


static gpointer _afrodite_symbol_ref0 (gpointer self) {
	return self ? afrodite_symbol_ref (self) : NULL;
}


AfroditeSymbol* afrodite_ast_lookup (AfroditeAst* self, const char* fully_qualified_name) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* _result_;
	AfroditeSymbol* parent;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fully_qualified_name != NULL, NULL);
	_result_ = NULL;
	parent = _afrodite_symbol_ref0 (self->priv->_root);
	if (afrodite_symbol_get_has_children (self->priv->_root)) {
		AfroditeSymbol* _tmp0_;
		_result_ = (_tmp0_ = afrodite_ast_lookup_symbol (fully_qualified_name, self->priv->_root, &parent, AFRODITE_COMPARE_MODE_EXACT, AFRODITE_SYMBOL_ACCESSIBILITY_ANY, AFRODITE_MEMBER_BINDING_ANY), _afrodite_symbol_unref0 (_result_), _tmp0_);
	}
	result = _result_;
	_afrodite_symbol_unref0 (parent);
	return result;
}


AfroditeSymbol* afrodite_ast_lookup_symbol (const char* qualified_name, AfroditeSymbol* parent_symbol, AfroditeSymbol** parent, AfroditeCompareMode mode, AfroditeSymbolAccessibility access, AfroditeMemberBinding binding) {
	AfroditeSymbol* result = NULL;
	gint tmp_length1;
	gint _tmp_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** tmp;
	char* name;
	g_return_val_if_fail (qualified_name != NULL, NULL);
	g_return_val_if_fail (parent_symbol != NULL, NULL);
	tmp = (_tmp1_ = _tmp0_ = g_strsplit (qualified_name, ".", 2), tmp_length1 = _vala_array_length (_tmp0_), _tmp_size_ = tmp_length1, _tmp1_);
	name = g_strdup (tmp[0]);
	if (!afrodite_symbol_get_has_children (parent_symbol)) {
		result = NULL;
		_g_free0 (name);
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		ValaIterator* _symbol_it;
		_symbol_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (parent_symbol));
		while (TRUE) {
			AfroditeSymbol* symbol;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = (AfroditeSymbol*) vala_iterator_get (_symbol_it);
			if (afrodite_ast_compare_symbol_names (afrodite_symbol_get_name (symbol), name, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE)) {
				_tmp3_ = (afrodite_symbol_get_access (symbol) & access) != 0;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				_tmp2_ = (symbol->binding & binding) != 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				if (tmp_length1 > 1) {
					AfroditeSymbol* child_sym;
					AfroditeSymbol* _tmp4_;
					child_sym = NULL;
					*parent = (_tmp4_ = _afrodite_symbol_ref0 (symbol), _afrodite_symbol_unref0 (*parent), _tmp4_);
					if (afrodite_symbol_get_has_children (symbol)) {
						AfroditeSymbol* _tmp5_;
						child_sym = (_tmp5_ = afrodite_ast_lookup_symbol (tmp[1], symbol, parent, mode, access, binding), _afrodite_symbol_unref0 (child_sym), _tmp5_);
					}
					result = child_sym;
					_afrodite_symbol_unref0 (symbol);
					_vala_collection_object_unref0 (_symbol_it);
					_g_free0 (name);
					tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					result = symbol;
					_vala_collection_object_unref0 (_symbol_it);
					_g_free0 (name);
					tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
			_afrodite_symbol_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
	result = NULL;
	_g_free0 (name);
	tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


AfroditeSourceFile* afrodite_ast_add_source_file (AfroditeAst* self, const char* filename) {
	AfroditeSourceFile* result = NULL;
	AfroditeSourceFile* file;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	file = afrodite_ast_lookup_source_file (self, filename);
	if (file == NULL) {
		AfroditeSourceFile* _tmp0_;
		file = (_tmp0_ = afrodite_source_file_new (filename), _afrodite_source_file_unref0 (file), _tmp0_);
		if (self->priv->_source_files == NULL) {
			ValaArrayList* _tmp1_;
			afrodite_ast_set_source_files (self, (ValaList*) (_tmp1_ = vala_array_list_new (AFRODITE_TYPE_SOURCE_FILE, (GBoxedCopyFunc) afrodite_source_file_ref, afrodite_source_file_unref, g_direct_equal)));
			_vala_collection_object_unref0 (_tmp1_);
		}
		afrodite_source_file_set_parent (file, self);
		vala_collection_add ((ValaCollection*) self->priv->_source_files, file);
	}
	result = file;
	return result;
}


AfroditeSourceFile* afrodite_ast_lookup_source_file (AfroditeAst* self, const char* filename) {
	AfroditeSourceFile* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	if (self->priv->_source_files != NULL) {
		{
			ValaIterator* _file_it;
			_file_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_files);
			while (TRUE) {
				AfroditeSourceFile* file;
				if (!vala_iterator_next (_file_it)) {
					break;
				}
				file = (AfroditeSourceFile*) vala_iterator_get (_file_it);
				if (_vala_strcmp0 (afrodite_source_file_get_filename (file), filename) == 0) {
					result = file;
					_vala_collection_object_unref0 (_file_it);
					return result;
				}
				_afrodite_source_file_unref0 (file);
			}
			_vala_collection_object_unref0 (_file_it);
		}
	}
	result = NULL;
	return result;
}


void afrodite_ast_remove_source (AfroditeAst* self, AfroditeSourceFile* source) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (self->priv->_source_files != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_source_files, source);
}


AfroditeSymbol* afrodite_ast_lookup_symbol_at (AfroditeAst* self, const char* filename, gint line, gint column) {
	AfroditeSymbol* result = NULL;
	AfroditeSourceFile* source;
	gboolean _tmp0_ = FALSE;
	AfroditeSymbol* sym;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	source = afrodite_ast_lookup_source_file (self, filename);
	if (source == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !afrodite_source_file_get_has_symbols (source);
	}
	if (_tmp0_) {
		result = NULL;
		_afrodite_source_file_unref0 (source);
		return result;
	}
	sym = afrodite_ast_get_symbol_for_source_and_position (self, source, line, column);
	result = sym;
	_afrodite_source_file_unref0 (source);
	return result;
}


AfroditeQueryResult* afrodite_ast_get_symbol_for_name_and_path (AfroditeAst* self, AfroditeQueryOptions* options, const char* symbol_qualified_name, const char* path, gint line, gint column) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	AfroditeSymbol* symbol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (symbol_qualified_name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_result_ = afrodite_query_result_new ();
	symbol = afrodite_ast_get_symbol_or_type_for_name_and_path (self, AFRODITE_LOOKUP_MODE_Symbol, options->binding, options, symbol_qualified_name, path, line, column);
	if (symbol != NULL) {
		AfroditeResultItem* item;
		item = afrodite_query_result_new_result_item (_result_, NULL, symbol);
		afrodite_query_result_add_result_item (_result_, item);
		_afrodite_result_item_unref0 (item);
	}
	result = _result_;
	_afrodite_symbol_unref0 (symbol);
	return result;
}


AfroditeQueryResult* afrodite_ast_get_symbol_type_for_name_and_path (AfroditeAst* self, AfroditeQueryOptions* options, const char* symbol_qualified_name, const char* path, gint line, gint column) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	AfroditeSymbol* symbol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (symbol_qualified_name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_result_ = afrodite_query_result_new ();
	symbol = afrodite_ast_get_symbol_or_type_for_name_and_path (self, AFRODITE_LOOKUP_MODE_Type, options->binding, options, symbol_qualified_name, path, line, column);
	if (symbol != NULL) {
		AfroditeResultItem* item;
		item = afrodite_query_result_new_result_item (_result_, NULL, symbol);
		afrodite_query_result_add_result_item (_result_, item);
		_afrodite_result_item_unref0 (item);
	}
	result = _result_;
	_afrodite_symbol_unref0 (symbol);
	return result;
}


static AfroditeSymbol* afrodite_ast_get_symbol_or_type_for_name_and_path (AfroditeAst* self, AfroditeLookupMode mode, AfroditeMemberBinding binding, AfroditeQueryOptions* options, const char* symbol_qualified_name, const char* path, gint line, gint column) {
	AfroditeSymbol* result = NULL;
	AfroditeSourceFile* source;
	gboolean _tmp0_ = FALSE;
	AfroditeSymbol* sym;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (symbol_qualified_name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	source = afrodite_ast_lookup_source_file (self, path);
	if (source == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !afrodite_source_file_get_has_symbols (source);
	}
	if (_tmp0_) {
		const char* _tmp1_;
		_tmp1_ = NULL;
		if (source == NULL) {
			_tmp1_ = "not found, so";
		} else {
			_tmp1_ = "found but";
		}
		g_warning ("ast.vala:188: source file %s %s without any symbols", path, _tmp1_);
		result = NULL;
		_afrodite_source_file_unref0 (source);
		return result;
	}
	sym = afrodite_ast_get_symbol_for_source_and_position (self, source, line, column);
	if (sym != NULL) {
		gint parts_length1;
		gint _parts_size_;
		char** _tmp3_;
		char** _tmp2_;
		char** parts;
		AfroditeSymbol* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		parts = (_tmp3_ = _tmp2_ = g_strsplit (symbol_qualified_name, ".", 0), parts_length1 = _vala_array_length (_tmp2_), _parts_size_ = parts_length1, _tmp3_);
		if (options->auto_member_binding_mode) {
			if (_vala_strcmp0 (parts[0], "this") == 0) {
				binding = binding & (~((gint) AFRODITE_MEMBER_BINDING_STATIC));
				options->binding = binding;
				options->access = options->access | AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				if (_vala_strcmp0 (parts[0], "base") == 0) {
					binding = binding & (~((gint) AFRODITE_MEMBER_BINDING_STATIC));
					options->binding = binding;
					options->access = (options->access & (~((gint) AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE))) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED;
				}
			}
		}
		sym = (_tmp4_ = afrodite_ast_lookup_name_with_symbol (self, parts[0], sym, source, options->compare_mode, AFRODITE_SYMBOL_ACCESSIBILITY_ANY, AFRODITE_MEMBER_BINDING_ANY), _afrodite_symbol_unref0 (sym), _tmp4_);
		if (sym != NULL) {
			_tmp5_ = afrodite_symbol_get_symbol_type (sym) != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp6_ = FALSE;
			if (mode != AFRODITE_LOOKUP_MODE_Symbol) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = parts_length1 > 1;
			}
			if (_tmp6_) {
				AfroditeSymbol* _tmp7_;
				sym = (_tmp7_ = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (afrodite_symbol_get_symbol_type (sym))), _afrodite_symbol_unref0 (sym), _tmp7_);
			}
		}
		if (parts_length1 > 1) {
			_tmp9_ = sym != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = afrodite_symbol_get_has_children (sym);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gboolean _tmp10_ = FALSE;
			if (_vala_strcmp0 (afrodite_symbol_get_type_name (sym), "Namespace") == 0) {
				_tmp10_ = TRUE;
			} else {
				gboolean _tmp11_ = FALSE;
				if (_vala_strcmp0 (parts[0], afrodite_symbol_get_name (sym)) == 0) {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					if (_vala_strcmp0 (afrodite_symbol_get_type_name (sym), "Class") == 0) {
						_tmp13_ = TRUE;
					} else {
						_tmp13_ = _vala_strcmp0 (afrodite_symbol_get_type_name (sym), "Struct") == 0;
					}
					if (_tmp13_) {
						_tmp12_ = TRUE;
					} else {
						_tmp12_ = _vala_strcmp0 (afrodite_symbol_get_type_name (sym), "Interface") == 0;
					}
					_tmp11_ = _tmp12_;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp10_ = _tmp11_;
			}
			if (_tmp10_) {
				binding = AFRODITE_MEMBER_BINDING_STATIC;
			}
			{
				gint i;
				i = 1;
				{
					gboolean _tmp14_;
					_tmp14_ = TRUE;
					while (TRUE) {
						AfroditeSymbol* parent;
						AfroditeSymbol* dummy;
						AfroditeSymbol* _tmp15_;
						gboolean _tmp17_ = FALSE;
						gboolean _tmp18_ = FALSE;
						if (!_tmp14_) {
							i++;
						}
						_tmp14_ = FALSE;
						if (!(i < parts_length1)) {
							break;
						}
						parent = _afrodite_symbol_ref0 (sym);
						dummy = NULL;
						sym = (_tmp15_ = afrodite_ast_lookup_symbol (parts[i], sym, &dummy, options->compare_mode, AFRODITE_SYMBOL_ACCESSIBILITY_ANY, AFRODITE_MEMBER_BINDING_ANY), _afrodite_symbol_unref0 (sym), _tmp15_);
						if (sym == NULL) {
							AfroditeSymbol* _tmp16_;
							sym = (_tmp16_ = afrodite_ast_lookup_name_in_base_types (self, parts[i], parent, AFRODITE_SYMBOL_ACCESSIBILITY_ANY, AFRODITE_MEMBER_BINDING_ANY), _afrodite_symbol_unref0 (sym), _tmp16_);
						}
						if (sym != NULL) {
							_tmp18_ = mode == AFRODITE_LOOKUP_MODE_Type;
						} else {
							_tmp18_ = FALSE;
						}
						if (_tmp18_) {
							_tmp17_ = afrodite_symbol_get_symbol_type (sym) != NULL;
						} else {
							_tmp17_ = FALSE;
						}
						if (_tmp17_) {
							AfroditeSymbol* _tmp19_;
							sym = (_tmp19_ = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (afrodite_symbol_get_symbol_type (sym))), _afrodite_symbol_unref0 (sym), _tmp19_);
						} else {
							_afrodite_symbol_unref0 (dummy);
							_afrodite_symbol_unref0 (parent);
							break;
						}
						_afrodite_symbol_unref0 (dummy);
						_afrodite_symbol_unref0 (parent);
					}
				}
			}
		}
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	if (sym != NULL) {
		_tmp21_ = afrodite_symbol_get_symbol_type (sym) != NULL;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = mode == AFRODITE_LOOKUP_MODE_Type;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		result = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (afrodite_symbol_get_symbol_type (sym)));
		_afrodite_symbol_unref0 (sym);
		_afrodite_source_file_unref0 (source);
		return result;
	} else {
		result = sym;
		_afrodite_source_file_unref0 (source);
		return result;
	}
	_afrodite_symbol_unref0 (sym);
	_afrodite_source_file_unref0 (source);
}


AfroditeQueryResult* afrodite_ast_get_symbols_for_path (AfroditeAst* self, AfroditeQueryOptions* options, const char* path) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	AfroditeResultItem* first;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_result_ = afrodite_query_result_new ();
	first = afrodite_query_result_new_result_item (_result_, NULL, self->priv->_root);
	afrodite_ast_get_child_symbols_for_path (self, _result_, options, path, first);
	if (vala_collection_get_size ((ValaCollection*) afrodite_result_item_get_children (first)) > 0) {
		afrodite_query_result_add_result_item (_result_, first);
	}
	result = _result_;
	_afrodite_result_item_unref0 (first);
	return result;
}


static void afrodite_ast_get_child_symbols_for_path (AfroditeAst* self, AfroditeQueryResult* _result_, AfroditeQueryOptions* options, const char* path, AfroditeResultItem* parent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (parent != NULL);
	if (!afrodite_symbol_get_has_children (afrodite_result_item_get_symbol (parent))) {
		return;
	}
	{
		ValaIterator* _symbol_it;
		_symbol_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (afrodite_result_item_get_symbol (parent)));
		while (TRUE) {
			AfroditeSymbol* symbol;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = (AfroditeSymbol*) vala_iterator_get (_symbol_it);
			if (afrodite_ast_symbol_has_filename_reference (self, path, symbol)) {
				if (afrodite_symbol_check_options (symbol, options)) {
					AfroditeResultItem* result_item;
					result_item = afrodite_query_result_new_result_item (_result_, parent, symbol);
					afrodite_result_item_add_result_item (parent, result_item);
					if (afrodite_symbol_get_has_children (symbol)) {
						AfroditeSymbol* item;
						gboolean circular_ref;
						item = _afrodite_symbol_ref0 (afrodite_result_item_get_symbol (parent));
						circular_ref = FALSE;
						while (TRUE) {
							AfroditeSymbol* _tmp0_;
							if (!(item != NULL)) {
								break;
							}
							if (symbol == item) {
								g_critical ("ast.vala:289: circular reference %s", afrodite_symbol_get_fully_qualified_name (symbol));
								circular_ref = TRUE;
								break;
							}
							item = (_tmp0_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (item)), _afrodite_symbol_unref0 (item), _tmp0_);
						}
						if (!circular_ref) {
							afrodite_ast_get_child_symbols_for_path (self, _result_, options, path, result_item);
						}
						_afrodite_symbol_unref0 (item);
					}
					_afrodite_result_item_unref0 (result_item);
				}
			}
			_afrodite_symbol_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
}


static gboolean afrodite_ast_symbol_has_filename_reference (AfroditeAst* self, const char* filename, AfroditeSymbol* symbol) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (!afrodite_symbol_get_has_source_references (symbol)) {
		result = FALSE;
		return result;
	}
	{
		ValaIterator* _sr_it;
		_sr_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_source_references (symbol));
		while (TRUE) {
			AfroditeSourceReference* sr;
			if (!vala_iterator_next (_sr_it)) {
				break;
			}
			sr = (AfroditeSourceReference*) vala_iterator_get (_sr_it);
			if (_vala_strcmp0 (afrodite_source_file_get_filename (sr->file), filename) == 0) {
				result = TRUE;
				_afrodite_source_reference_unref0 (sr);
				_vala_collection_object_unref0 (_sr_it);
				return result;
			}
			_afrodite_source_reference_unref0 (sr);
		}
		_vala_collection_object_unref0 (_sr_it);
	}
	result = FALSE;
	return result;
}


static AfroditeSymbol* afrodite_ast_lookup_name_in_base_types (AfroditeAst* self, const char* name, AfroditeSymbol* symbol, AfroditeSymbolAccessibility access, AfroditeMemberBinding binding) {
	AfroditeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (afrodite_symbol_get_has_base_types (symbol)) {
		AfroditeSymbol* parent;
		parent = NULL;
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (symbol));
			while (TRUE) {
				AfroditeDataType* type;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				if (!afrodite_data_type_get_unresolved (type)) {
					gboolean _tmp0_ = FALSE;
					gboolean _tmp1_ = FALSE;
					if (_vala_strcmp0 (afrodite_symbol_get_name (afrodite_data_type_get_symbol (type)), name) == 0) {
						_tmp1_ = (afrodite_symbol_get_access (afrodite_data_type_get_symbol (type)) & access) != 0;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						_tmp0_ = (afrodite_data_type_get_symbol (type)->binding & binding) != 0;
					} else {
						_tmp0_ = FALSE;
					}
					if (_tmp0_) {
						result = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (type));
						_afrodite_data_type_unref0 (type);
						_vala_collection_object_unref0 (_type_it);
						_afrodite_symbol_unref0 (parent);
						return result;
					}
					if (afrodite_symbol_get_has_children (afrodite_data_type_get_symbol (type))) {
						AfroditeSymbol* sym;
						sym = afrodite_ast_lookup_symbol (name, afrodite_data_type_get_symbol (type), &parent, AFRODITE_COMPARE_MODE_EXACT, access, binding);
						if (sym != NULL) {
							result = sym;
							_afrodite_data_type_unref0 (type);
							_vala_collection_object_unref0 (_type_it);
							_afrodite_symbol_unref0 (parent);
							return result;
						}
						_afrodite_symbol_unref0 (sym);
					}
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
		_afrodite_symbol_unref0 (parent);
	}
	result = NULL;
	return result;
}


static AfroditeSymbol* afrodite_ast_lookup_this_symbol (AfroditeAst* self, AfroditeSymbol* root) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* current;
	g_return_val_if_fail (self != NULL, NULL);
	current = _afrodite_symbol_ref0 (root);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(current != NULL)) {
			break;
		}
		if (_vala_strcmp0 (afrodite_symbol_get_type_name (current), "Class") == 0) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = _vala_strcmp0 (afrodite_symbol_get_type_name (current), "Struct") == 0;
		}
		if (_tmp0_) {
			break;
		} else {
			if (_vala_strcmp0 (afrodite_symbol_get_type_name (current), "Namespace") == 0) {
				AfroditeSymbol* _tmp1_;
				current = (_tmp1_ = NULL, _afrodite_symbol_unref0 (current), _tmp1_);
			} else {
				AfroditeSymbol* _tmp2_;
				current = (_tmp2_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (current)), _afrodite_symbol_unref0 (current), _tmp2_);
			}
		}
	}
	result = current;
	return result;
}


static void afrodite_ast_append_visible_symbols (AfroditeAst* self, ValaList* results, AfroditeSymbol* symbol, const char* name, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness, AfroditeSymbolAccessibility access) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	if (afrodite_symbol_get_has_local_variables (symbol)) {
		{
			ValaIterator* _d_it;
			_d_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_local_variables (symbol));
			while (TRUE) {
				AfroditeDataType* d;
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_ = FALSE;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (AfroditeDataType*) vala_iterator_get (_d_it);
				if (!afrodite_data_type_get_unresolved (d)) {
					_tmp1_ = (access & AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE) != 0;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					gboolean _tmp2_ = FALSE;
					if (name == NULL) {
						_tmp2_ = TRUE;
					} else {
						_tmp2_ = afrodite_ast_compare_symbol_names (afrodite_data_type_get_name (d), name, mode, case_sensitiveness);
					}
					_tmp0_ = _tmp2_;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					AfroditeSymbol* s;
					AfroditeDataType* _tmp3_;
					s = afrodite_symbol_new (afrodite_data_type_get_name (d), afrodite_data_type_get_type_name (d));
					afrodite_symbol_set_return_type (s, _tmp3_ = afrodite_data_type_copy (d));
					_afrodite_data_type_unref0 (_tmp3_);
					afrodite_data_type_set_symbol (afrodite_symbol_get_return_type (s), afrodite_data_type_get_symbol (d));
					vala_collection_add ((ValaCollection*) results, s);
					_afrodite_symbol_unref0 (s);
				}
				_afrodite_data_type_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
	}
	if (afrodite_symbol_get_has_parameters (symbol)) {
		{
			ValaIterator* _d_it;
			_d_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_parameters (symbol));
			while (TRUE) {
				AfroditeDataType* d;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (AfroditeDataType*) vala_iterator_get (_d_it);
				if (!afrodite_data_type_get_unresolved (d)) {
					_tmp5_ = (access & AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE) != 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gboolean _tmp6_ = FALSE;
					if (name == NULL) {
						_tmp6_ = TRUE;
					} else {
						_tmp6_ = afrodite_ast_compare_symbol_names (afrodite_data_type_get_name (d), name, mode, case_sensitiveness);
					}
					_tmp4_ = _tmp6_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					AfroditeSymbol* s;
					AfroditeDataType* _tmp7_;
					s = afrodite_symbol_new (afrodite_data_type_get_name (d), afrodite_data_type_get_type_name (d));
					afrodite_symbol_set_return_type (s, _tmp7_ = afrodite_data_type_copy (d));
					_afrodite_data_type_unref0 (_tmp7_);
					afrodite_data_type_set_symbol (afrodite_symbol_get_return_type (s), afrodite_data_type_get_symbol (d));
					vala_collection_add ((ValaCollection*) results, s);
					_afrodite_symbol_unref0 (s);
				}
				_afrodite_data_type_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
	}
	if (afrodite_symbol_get_has_children (symbol)) {
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (symbol));
			while (TRUE) {
				AfroditeSymbol* s;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSymbol*) vala_iterator_get (_s_it);
				if ((afrodite_symbol_get_access (s) & access) != 0) {
					_tmp9_ = _vala_strcmp0 (afrodite_symbol_get_fully_qualified_name (s), afrodite_symbol_get_fully_qualified_name (symbol)) != 0;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gboolean _tmp10_ = FALSE;
					if (name == NULL) {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = afrodite_ast_compare_symbol_names (afrodite_symbol_get_name (s), name, mode, case_sensitiveness);
					}
					_tmp8_ = _tmp10_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					vala_collection_add ((ValaCollection*) results, s);
				}
				_afrodite_symbol_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
	}
	if (afrodite_symbol_get_has_base_types (symbol)) {
		{
			ValaIterator* _d_it;
			_d_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (symbol));
			while (TRUE) {
				AfroditeDataType* d;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (AfroditeDataType*) vala_iterator_get (_d_it);
				if (!afrodite_data_type_get_unresolved (d)) {
					afrodite_ast_append_visible_symbols (self, results, afrodite_data_type_get_symbol (d), name, mode, case_sensitiveness, (AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED);
				}
				_afrodite_data_type_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
	}
}


static void afrodite_ast_append_all_visible_symbols (AfroditeAst* self, ValaList* results, AfroditeSymbol* symbol, const char* name, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	afrodite_ast_append_visible_symbols (self, results, symbol, name, mode, case_sensitiveness, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	if (afrodite_symbol_get_parent (symbol) != NULL) {
		afrodite_ast_append_all_visible_symbols (self, results, afrodite_symbol_get_parent (symbol), name, mode, case_sensitiveness);
	}
}


ValaList* afrodite_ast_lookup_visible_symbols_from_symbol (AfroditeAst* self, AfroditeSymbol* symbol, const char* name, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness) {
	ValaList* result = NULL;
	ValaList* results;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	results = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) afrodite_symbol_ref, afrodite_symbol_unref, g_direct_equal);
	afrodite_ast_append_all_visible_symbols (self, results, symbol, name, mode, case_sensitiveness);
	if (afrodite_symbol_get_has_source_references (symbol)) {
		ValaArrayList* using_done;
		using_done = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_source_references (symbol));
			while (TRUE) {
				AfroditeSourceReference* s;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSourceReference*) vala_iterator_get (_s_it);
				if (afrodite_source_file_get_has_using_directives (s->file)) {
					afrodite_utils_trace ("ast.vala:449: import symbol from symbol %s, file: %s", afrodite_symbol_get_fully_qualified_name (symbol), afrodite_source_file_get_filename (s->file));
					{
						ValaIterator* _u_it;
						_u_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_using_directives (s->file));
						while (TRUE) {
							AfroditeDataType* u;
							if (!vala_iterator_next (_u_it)) {
								break;
							}
							u = (AfroditeDataType*) vala_iterator_get (_u_it);
							if (!vala_collection_contains ((ValaCollection*) using_done, afrodite_data_type_get_type_name (u))) {
								vala_collection_add ((ValaCollection*) using_done, afrodite_data_type_get_type_name (u));
								afrodite_utils_trace ("ast.vala:453:     import symbol from namespace: %s", afrodite_data_type_get_type_name (u));
								if (!afrodite_data_type_get_unresolved (u)) {
									afrodite_ast_append_visible_symbols (self, results, afrodite_data_type_get_symbol (u), name, mode, case_sensitiveness, AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC);
								}
							}
							_afrodite_data_type_unref0 (u);
						}
						_vala_collection_object_unref0 (_u_it);
					}
				}
				_afrodite_source_reference_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
		_vala_collection_object_unref0 (using_done);
	}
	result = results;
	return result;
}


static gboolean afrodite_ast_compare_symbol_names (const char* name1, const char* name2, AfroditeCompareMode mode, AfroditeCaseSensitiveness case_sensitiveness) {
	gboolean result = FALSE;
	char* a;
	char* b;
	a = g_strdup (name1);
	b = g_strdup (name2);
	switch (case_sensitiveness) {
		case AFRODITE_CASE_SENSITIVENESS_CASE_INSENSITIVE:
		{
			char* _tmp0_;
			char* _tmp3_;
			char* _tmp4_;
			char* _tmp7_;
			_tmp0_ = NULL;
			if (name1 != NULL) {
				char* _tmp1_;
				_tmp0_ = (_tmp1_ = g_utf8_strdown (name1, -1), _g_free0 (_tmp0_), _tmp1_);
			} else {
				char* _tmp2_;
				_tmp0_ = (_tmp2_ = NULL, _g_free0 (_tmp0_), _tmp2_);
			}
			a = (_tmp3_ = g_strdup (_tmp0_), _g_free0 (a), _tmp3_);
			_tmp4_ = NULL;
			if (name2 != NULL) {
				char* _tmp5_;
				_tmp4_ = (_tmp5_ = g_utf8_strdown (name2, -1), _g_free0 (_tmp4_), _tmp5_);
			} else {
				char* _tmp6_;
				_tmp4_ = (_tmp6_ = NULL, _g_free0 (_tmp4_), _tmp6_);
			}
			b = (_tmp7_ = g_strdup (_tmp4_), _g_free0 (b), _tmp7_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp0_);
			break;
		}
		case AFRODITE_CASE_SENSITIVENESS_AUTO:
		{
			char* _tmp8_;
			gboolean _tmp9_;
			if ((_tmp9_ = _vala_strcmp0 (_tmp8_ = g_utf8_strdown (name2, -1), name2) == 0, _g_free0 (_tmp8_), _tmp9_)) {
				char* _tmp10_;
				char* _tmp13_;
				char* _tmp14_;
				char* _tmp17_;
				_tmp10_ = NULL;
				if (name1 != NULL) {
					char* _tmp11_;
					_tmp10_ = (_tmp11_ = g_utf8_strdown (name1, -1), _g_free0 (_tmp10_), _tmp11_);
				} else {
					char* _tmp12_;
					_tmp10_ = (_tmp12_ = NULL, _g_free0 (_tmp10_), _tmp12_);
				}
				a = (_tmp13_ = g_strdup (_tmp10_), _g_free0 (a), _tmp13_);
				_tmp14_ = NULL;
				if (name2 != NULL) {
					char* _tmp15_;
					_tmp14_ = (_tmp15_ = g_utf8_strdown (name2, -1), _g_free0 (_tmp14_), _tmp15_);
				} else {
					char* _tmp16_;
					_tmp14_ = (_tmp16_ = NULL, _g_free0 (_tmp14_), _tmp16_);
				}
				b = (_tmp17_ = g_strdup (_tmp14_), _g_free0 (b), _tmp17_);
				_g_free0 (_tmp14_);
				_g_free0 (_tmp10_);
			}
			break;
		}
	}
	if (mode == AFRODITE_COMPARE_MODE_START_WITH) {
		gboolean _tmp18_ = FALSE;
		if (a != NULL) {
			_tmp18_ = b != NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			result = g_str_has_prefix (a, b);
			_g_free0 (b);
			_g_free0 (a);
			return result;
		} else {
			result = FALSE;
			_g_free0 (b);
			_g_free0 (a);
			return result;
		}
	} else {
		result = _vala_strcmp0 (a, b) == 0;
		_g_free0 (b);
		_g_free0 (a);
		return result;
	}
	_g_free0 (b);
	_g_free0 (a);
}


static AfroditeSymbol* afrodite_ast_lookup_name_with_symbol (AfroditeAst* self, const char* name, AfroditeSymbol* symbol, AfroditeSourceFile* source, AfroditeCompareMode mode, AfroditeSymbolAccessibility access, AfroditeMemberBinding binding) {
	AfroditeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	if (_vala_strcmp0 (name, "this") == 0) {
		result = afrodite_ast_lookup_this_symbol (self, symbol);
		return result;
	} else {
		if (_vala_strcmp0 (name, "base") == 0) {
			AfroditeSymbol* this_sym;
			gboolean _tmp0_ = FALSE;
			this_sym = afrodite_ast_lookup_this_symbol (self, symbol);
			if (this_sym != NULL) {
				_tmp0_ = afrodite_symbol_get_has_base_types (this_sym);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				{
					ValaIterator* _type_it;
					_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (this_sym));
					while (TRUE) {
						AfroditeDataType* type;
						gboolean _tmp1_ = FALSE;
						if (!vala_iterator_next (_type_it)) {
							break;
						}
						type = (AfroditeDataType*) vala_iterator_get (_type_it);
						if (!afrodite_data_type_get_unresolved (type)) {
							_tmp1_ = _vala_strcmp0 (afrodite_symbol_get_type_name (afrodite_data_type_get_symbol (type)), "Class") == 0;
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							result = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (type));
							_afrodite_data_type_unref0 (type);
							_vala_collection_object_unref0 (_type_it);
							_afrodite_symbol_unref0 (this_sym);
							return result;
						}
						_afrodite_data_type_unref0 (type);
					}
					_vala_collection_object_unref0 (_type_it);
				}
			}
			_afrodite_symbol_unref0 (this_sym);
		} else {
			AfroditeSymbol* current_sym;
			AfroditeSymbol* _tmp7_;
			AfroditeSymbol* sym;
			current_sym = _afrodite_symbol_ref0 (symbol);
			while (TRUE) {
				AfroditeSymbol* _tmp6_;
				if (!(current_sym != NULL)) {
					break;
				}
				if (afrodite_symbol_get_has_local_variables (current_sym)) {
					{
						ValaIterator* _type_it;
						_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_local_variables (current_sym));
						while (TRUE) {
							AfroditeDataType* type;
							if (!vala_iterator_next (_type_it)) {
								break;
							}
							type = (AfroditeDataType*) vala_iterator_get (_type_it);
							if (!afrodite_data_type_get_unresolved (type)) {
								gboolean _tmp2_ = FALSE;
								gboolean _tmp3_ = FALSE;
								if (afrodite_ast_compare_symbol_names (afrodite_data_type_get_name (type), name, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE)) {
									_tmp3_ = (afrodite_symbol_get_access (afrodite_data_type_get_symbol (type)) & access) != 0;
								} else {
									_tmp3_ = FALSE;
								}
								if (_tmp3_) {
									_tmp2_ = (afrodite_data_type_get_symbol (type)->binding & binding) != 0;
								} else {
									_tmp2_ = FALSE;
								}
								if (_tmp2_) {
									result = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (type));
									_afrodite_data_type_unref0 (type);
									_vala_collection_object_unref0 (_type_it);
									_afrodite_symbol_unref0 (current_sym);
									return result;
								}
							}
							_afrodite_data_type_unref0 (type);
						}
						_vala_collection_object_unref0 (_type_it);
					}
				}
				if (afrodite_symbol_get_has_parameters (current_sym)) {
					{
						ValaIterator* _type_it;
						_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_parameters (current_sym));
						while (TRUE) {
							AfroditeDataType* type;
							if (!vala_iterator_next (_type_it)) {
								break;
							}
							type = (AfroditeDataType*) vala_iterator_get (_type_it);
							if (!afrodite_data_type_get_unresolved (type)) {
								gboolean _tmp4_ = FALSE;
								gboolean _tmp5_ = FALSE;
								if (afrodite_ast_compare_symbol_names (afrodite_data_type_get_name (type), name, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE)) {
									_tmp5_ = (afrodite_symbol_get_access (afrodite_data_type_get_symbol (type)) & access) != 0;
								} else {
									_tmp5_ = FALSE;
								}
								if (_tmp5_) {
									_tmp4_ = (afrodite_data_type_get_symbol (type)->binding & binding) != 0;
								} else {
									_tmp4_ = FALSE;
								}
								if (_tmp4_) {
									result = _afrodite_symbol_ref0 (afrodite_data_type_get_symbol (type));
									_afrodite_data_type_unref0 (type);
									_vala_collection_object_unref0 (_type_it);
									_afrodite_symbol_unref0 (current_sym);
									return result;
								}
							}
							_afrodite_data_type_unref0 (type);
						}
						_vala_collection_object_unref0 (_type_it);
					}
				}
				current_sym = (_tmp6_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (current_sym)), _afrodite_symbol_unref0 (current_sym), _tmp6_);
			}
			current_sym = (_tmp7_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (symbol)), _afrodite_symbol_unref0 (current_sym), _tmp7_);
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				AfroditeSymbol* _tmp12_;
				if (!(current_sym != NULL)) {
					break;
				}
				if (current_sym != NULL) {
					_tmp8_ = afrodite_symbol_get_has_children (current_sym);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					{
						ValaIterator* _sibling_it;
						_sibling_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (current_sym));
						while (TRUE) {
							AfroditeSymbol* sibling;
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							if (!vala_iterator_next (_sibling_it)) {
								break;
							}
							sibling = (AfroditeSymbol*) vala_iterator_get (_sibling_it);
							if (sibling != symbol) {
								_tmp11_ = afrodite_ast_compare_symbol_names (afrodite_symbol_get_name (sibling), name, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE);
							} else {
								_tmp11_ = FALSE;
							}
							if (_tmp11_) {
								_tmp10_ = (afrodite_symbol_get_access (sibling) & access) != 0;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								_tmp9_ = (sibling->binding & binding) != 0;
							} else {
								_tmp9_ = FALSE;
							}
							if (_tmp9_) {
								result = sibling;
								_vala_collection_object_unref0 (_sibling_it);
								_afrodite_symbol_unref0 (current_sym);
								return result;
							}
							_afrodite_symbol_unref0 (sibling);
						}
						_vala_collection_object_unref0 (_sibling_it);
					}
				}
				current_sym = (_tmp12_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (current_sym)), _afrodite_symbol_unref0 (current_sym), _tmp12_);
			}
			sym = afrodite_ast_lookup_name_in_base_types (self, name, symbol, access, binding);
			if (sym != NULL) {
				result = sym;
				_afrodite_symbol_unref0 (current_sym);
				return result;
			}
			if (afrodite_source_file_get_has_using_directives (source)) {
				{
					ValaIterator* _u_it;
					_u_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_using_directives (source));
					while (TRUE) {
						AfroditeDataType* u;
						AfroditeSymbol* _tmp13_;
						if (!vala_iterator_next (_u_it)) {
							break;
						}
						u = (AfroditeDataType*) vala_iterator_get (_u_it);
						sym = (_tmp13_ = afrodite_ast_lookup (self, afrodite_data_type_get_type_name (u)), _afrodite_symbol_unref0 (sym), _tmp13_);
						if (sym != NULL) {
							AfroditeSymbol* parent;
							parent = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (sym));
							if (afrodite_ast_compare_symbol_names (afrodite_symbol_get_name (sym), name, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE)) {
								result = sym;
								_afrodite_symbol_unref0 (parent);
								_afrodite_data_type_unref0 (u);
								_vala_collection_object_unref0 (_u_it);
								_afrodite_symbol_unref0 (current_sym);
								return result;
							} else {
								if (afrodite_symbol_get_has_children (sym)) {
									AfroditeSymbol* _tmp14_;
									sym = (_tmp14_ = afrodite_ast_lookup_symbol (name, sym, &parent, mode, access, binding), _afrodite_symbol_unref0 (sym), _tmp14_);
									if (sym != NULL) {
										result = sym;
										_afrodite_symbol_unref0 (parent);
										_afrodite_data_type_unref0 (u);
										_vala_collection_object_unref0 (_u_it);
										_afrodite_symbol_unref0 (current_sym);
										return result;
									}
								}
							}
							_afrodite_symbol_unref0 (parent);
						}
						_afrodite_data_type_unref0 (u);
					}
					_vala_collection_object_unref0 (_u_it);
				}
			}
			_afrodite_symbol_unref0 (sym);
			_afrodite_symbol_unref0 (current_sym);
		}
	}
	result = NULL;
	return result;
}


AfroditeSymbol* afrodite_ast_get_symbol_for_source_and_position (AfroditeAst* self, AfroditeSourceFile* source, gint line, gint column) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* _result_;
	AfroditeSourceReference* result_sr;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_result_ = NULL;
	result_sr = NULL;
	if (afrodite_source_file_get_has_symbols (source)) {
		line++;
		{
			ValaIterator* _symbol_it;
			_symbol_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_symbols (source));
			while (TRUE) {
				AfroditeSymbol* symbol;
				AfroditeSourceReference* sr;
				if (!vala_iterator_next (_symbol_it)) {
					break;
				}
				symbol = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_iterator_get (_symbol_it));
				sr = afrodite_symbol_lookup_source_reference_sourcefile (symbol, source);
				if (sr == NULL) {
					_afrodite_source_reference_unref0 (sr);
					_afrodite_symbol_unref0 (symbol);
					continue;
				}
				if (afrodite_source_reference_contains_position (sr, line, column)) {
					gboolean _tmp0_ = FALSE;
					if (_result_ == NULL) {
						_tmp0_ = TRUE;
					} else {
						_tmp0_ = afrodite_source_reference_contains_source_reference (result_sr, sr);
					}
					if (_tmp0_) {
						AfroditeSymbol* _tmp1_;
						_result_ = (_tmp1_ = _afrodite_symbol_ref0 (symbol), _afrodite_symbol_unref0 (_result_), _tmp1_);
						result_sr = sr;
					}
				}
				_afrodite_source_reference_unref0 (sr);
				_afrodite_symbol_unref0 (symbol);
			}
			_vala_collection_object_unref0 (_symbol_it);
		}
	}
	if (_result_ == NULL) {
		afrodite_utils_trace ("ast.vala:619: no symbol found");
	} else {
		afrodite_utils_trace ("ast.vala:621:    found %s", afrodite_symbol_get_fully_qualified_name (_result_));
	}
	result = _result_;
	return result;
}


AfroditeAst* afrodite_ast_construct (GType object_type) {
	AfroditeAst* self;
	self = (AfroditeAst*) g_type_create_instance (object_type);
	return self;
}


AfroditeAst* afrodite_ast_new (void) {
	return afrodite_ast_construct (AFRODITE_TYPE_AST);
}


AfroditeSymbol* afrodite_ast_get_root (AfroditeAst* self) {
	AfroditeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_root;
	return result;
}


void afrodite_ast_set_root (AfroditeAst* self, AfroditeSymbol* value) {
	AfroditeSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_root = (_tmp0_ = _afrodite_symbol_ref0 (value), _afrodite_symbol_unref0 (self->priv->_root), _tmp0_);
}


ValaList* afrodite_ast_get_source_files (AfroditeAst* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_files;
	return result;
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


void afrodite_ast_set_source_files (AfroditeAst* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_files = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_source_files), _tmp0_);
}


gboolean afrodite_ast_get_has_source_files (AfroditeAst* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_source_files != NULL;
	return result;
}


static void afrodite_value_ast_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void afrodite_value_ast_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		afrodite_ast_unref (value->data[0].v_pointer);
	}
}


static void afrodite_value_ast_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = afrodite_ast_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer afrodite_value_ast_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* afrodite_value_ast_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AfroditeAst* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = afrodite_ast_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* afrodite_value_ast_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AfroditeAst** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = afrodite_ast_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AfroditeParamSpecAst* spec;
	g_return_val_if_fail (g_type_is_a (object_type, AFRODITE_TYPE_AST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer afrodite_value_get_ast (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_AST), NULL);
	return value->data[0].v_pointer;
}


void afrodite_value_set_ast (GValue* value, gpointer v_object) {
	AfroditeAst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_AST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_TYPE_AST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		afrodite_ast_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_ast_unref (old);
	}
}


void afrodite_value_take_ast (GValue* value, gpointer v_object) {
	AfroditeAst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_AST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_TYPE_AST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_ast_unref (old);
	}
}


static void afrodite_ast_class_init (AfroditeAstClass * klass) {
	afrodite_ast_parent_class = g_type_class_peek_parent (klass);
	AFRODITE_AST_CLASS (klass)->finalize = afrodite_ast_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeAstPrivate));
}


static void afrodite_ast_instance_init (AfroditeAst * self) {
	self->priv = AFRODITE_AST_GET_PRIVATE (self);
	self->symbols = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, AFRODITE_TYPE_SYMBOL, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	self->unresolved_symbols = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, NULL, NULL, g_direct_equal);
	self->priv->_root = afrodite_symbol_new (NULL, NULL);
	self->ref_count = 1;
}


static void afrodite_ast_finalize (AfroditeAst* obj) {
	AfroditeAst * self;
	self = AFRODITE_AST (obj);
	{
		AfroditeSymbol* _tmp0_;
		afrodite_utils_trace ("ast.vala:36: Ast destroy");
		self->priv->_root = (_tmp0_ = NULL, _afrodite_symbol_unref0 (self->priv->_root), _tmp0_);
		afrodite_ast_set_source_files (self, NULL);
		afrodite_utils_trace ("ast.vala:40: Ast destroyed");
	}
	_vala_collection_object_unref0 (self->symbols);
	_vala_collection_object_unref0 (self->unresolved_symbols);
	_afrodite_symbol_unref0 (self->priv->_root);
	_vala_collection_object_unref0 (self->priv->_source_files);
}


GType afrodite_ast_get_type (void) {
	static volatile gsize afrodite_ast_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_ast_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { afrodite_value_ast_init, afrodite_value_ast_free_value, afrodite_value_ast_copy_value, afrodite_value_ast_peek_pointer, "p", afrodite_value_ast_collect_value, "p", afrodite_value_ast_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeAstClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_ast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeAst), 0, (GInstanceInitFunc) afrodite_ast_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType afrodite_ast_type_id;
		afrodite_ast_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AfroditeAst", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&afrodite_ast_type_id__volatile, afrodite_ast_type_id);
	}
	return afrodite_ast_type_id__volatile;
}


gpointer afrodite_ast_ref (gpointer instance) {
	AfroditeAst* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void afrodite_ast_unref (gpointer instance) {
	AfroditeAst* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AFRODITE_AST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




