/* afroditetest.c generated by valac 0.10.0, the Vala compiler
 * generated from afroditetest.vala, do not modify */

/* afroditetest.vala
 *
 * Copyright (C) 2010  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <afrodite.h>
#include <glib/gi18n-lib.h>
#include <valagee.h>
#include <glib/gstdio.h>


#define AFRODITE_TEST_TYPE_APPLICATION (afrodite_test_application_get_type ())
#define AFRODITE_TEST_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TEST_TYPE_APPLICATION, AfroditeTestApplication))
#define AFRODITE_TEST_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TEST_TYPE_APPLICATION, AfroditeTestApplicationClass))
#define AFRODITE_TEST_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TEST_TYPE_APPLICATION))
#define AFRODITE_TEST_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TEST_TYPE_APPLICATION))
#define AFRODITE_TEST_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TEST_TYPE_APPLICATION, AfroditeTestApplicationClass))

typedef struct _AfroditeTestApplication AfroditeTestApplication;
typedef struct _AfroditeTestApplicationClass AfroditeTestApplicationClass;
typedef struct _AfroditeTestApplicationPrivate AfroditeTestApplicationPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _afrodite_symbol_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_unref (var), NULL)))
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
#define _afrodite_query_result_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_result_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
#define _afrodite_result_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_result_item_unref (var), NULL)))
#define _afrodite_query_options_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_options_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _afrodite_source_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_item_unref (var), NULL)))

struct _AfroditeTestApplication {
	GObject parent_instance;
	AfroditeTestApplicationPrivate * priv;
};

struct _AfroditeTestApplicationClass {
	GObjectClass parent_class;
};

struct _AfroditeTestApplicationPrivate {
	GMainLoop* _loop;
	AfroditeCompletionEngine* _engine;
};


extern char* option_symbol_name;
char* option_symbol_name = NULL;
extern gint option_line;
gint option_line = 0;
extern gint option_column;
gint option_column = 0;
extern char* option_visible_symbols;
char* option_visible_symbols = NULL;
extern char* option_filter;
char* option_filter = NULL;
extern char* option_namespace;
char* option_namespace = NULL;
extern char** option_files;
extern gint option_files_length1;
char** option_files = NULL;
gint option_files_length1 = 0;
static gint _option_files_size_ = 0;
extern gint option_repeat;
gint option_repeat = 0;
extern gboolean option_live_buffers;
gboolean option_live_buffers = FALSE;
static gpointer afrodite_test_application_parent_class = NULL;

GType afrodite_test_application_get_type (void) G_GNUC_CONST;
#define AFRODITE_TEST_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TEST_TYPE_APPLICATION, AfroditeTestApplicationPrivate))
enum  {
	AFRODITE_TEST_APPLICATION_DUMMY_PROPERTY
};
gint afrodite_test_application_run (AfroditeTestApplication* self, char** args, int args_length1);
static void afrodite_test_application_parse (AfroditeTestApplication* self);
static void afrodite_test_application_on_begin_parsing (AfroditeTestApplication* self, AfroditeCompletionEngine* engine);
static void afrodite_test_application_on_end_parsing (AfroditeTestApplication* self, AfroditeCompletionEngine* engine);
static void afrodite_test_application_dump (AfroditeTestApplication* self, AfroditeCompletionEngine* engine);
static void _afrodite_test_application_on_begin_parsing_afrodite_completion_engine_begin_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self);
static void _afrodite_test_application_on_end_parsing_afrodite_completion_engine_end_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self);
static gint afrodite_test_application_main (char** args, int args_length1);
AfroditeTestApplication* afrodite_test_application_new (void);
AfroditeTestApplication* afrodite_test_application_construct (GType object_type);
static void afrodite_test_application_finalize (GObject* obj);

const GOptionEntry options[10] = {{"symbol-name", 's', 0, G_OPTION_ARG_STRING, &option_symbol_name, "Symbol to search NAME", "NAME"}, {"visible-symbols", 'd', 0, G_OPTION_ARG_FILENAME, &option_visible_symbols, "Dump visible symbols from line / column of source FILENAME", "FILENAME"}, {"filter", 'f', 0, G_OPTION_ARG_STRING, &option_filter, "Filter results showing only symbols starting with NAME", "NAME"}, {"line", 'l', 0, G_OPTION_ARG_INT, &option_line, "Line NUMBER", "NUMBER"}, {"column", 'c', 0, G_OPTION_ARG_INT, &option_column, "Column NUMBER", "NUMBER"}, {"repeat", 'r', 0, G_OPTION_ARG_INT, &option_repeat, "Repeat parsing NUMBER", "NUMBER"}, {"dump-namespace", 'n', 0, G_OPTION_ARG_STRING, &option_namespace, "Namespace to dump NAME", "NAME"}, {"queue-as-live-buffer", 'e', 0, G_OPTION_ARG_STRING, &option_live_buffers, "Parse the source files as live buffers", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_files, "Source files NAME", "NAME"}, {NULL}};


gint afrodite_test_application_run (AfroditeTestApplication* self, char** args, int args_length1) {
	gint result = 0;
	GOptionContext* opt_context;
	GMainLoop* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	opt_context = g_option_context_new ("- Afrodite Test");
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, options, NULL);
	{
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("afroditetest.vala:62: %s", _ ("parsing options"));
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (option_repeat == 0) {
		option_repeat = 1;
	}
	afrodite_test_application_parse (self);
	self->priv->_loop = (_tmp0_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->_loop), _tmp0_);
	g_main_loop_run (self->priv->_loop);
	result = 0;
	_g_option_context_free0 (opt_context);
	return result;
}


static void afrodite_test_application_on_begin_parsing (AfroditeTestApplication* self, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_print ("\nAfrodite engine is parsing sources\n");
}


static void afrodite_test_application_on_end_parsing (AfroditeTestApplication* self, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_print ("\nAfrodite engine end parsing sources\n");
	g_main_loop_quit (self->priv->_loop);
	afrodite_test_application_dump (self, engine);
}


static void afrodite_test_application_dump (AfroditeTestApplication* self, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_print (": done\n\n");
	g_print ("Looking for '%s' %d,%d\n\nDump follows:\n", option_symbol_name, option_line, option_column);
	while (TRUE) {
		AfroditeAstDumper* dumper;
		dumper = afrodite_ast_dumper_new ();
		afrodite_ast_dumper_dump (dumper, afrodite_completion_engine_get_ast (engine), option_namespace);
		g_print ("\n");
		if (option_visible_symbols != NULL) {
			AfroditeSourceFile* source;
			source = afrodite_ast_lookup_source_file (afrodite_completion_engine_get_ast (engine), option_visible_symbols);
			if (source != NULL) {
				AfroditeSymbol* s;
				s = afrodite_ast_get_symbol_for_source_and_position (afrodite_completion_engine_get_ast (engine), source, option_line, option_column);
				if (s != NULL) {
					ValaList* syms;
					ValaList* _tmp0_;
					syms = NULL;
					syms = (_tmp0_ = afrodite_ast_lookup_visible_symbols_from_symbol (afrodite_completion_engine_get_ast (engine), s, option_filter, AFRODITE_COMPARE_MODE_START_WITH, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE), _vala_collection_object_unref0 (syms), _tmp0_);
					g_print ("Symbols found: %d\n", vala_collection_get_size ((ValaCollection*) syms));
					{
						ValaIterator* _sym_it;
						_sym_it = vala_iterable_iterator ((ValaIterable*) syms);
						while (TRUE) {
							AfroditeSymbol* sym;
							const char* _tmp1_;
							char* _tmp2_;
							if (!vala_iterator_next (_sym_it)) {
								break;
							}
							sym = (AfroditeSymbol*) vala_iterator_get (_sym_it);
							_tmp1_ = NULL;
							if (afrodite_symbol_get_parent (sym) == NULL) {
								_tmp1_ = "<root>";
							} else {
								_tmp1_ = afrodite_symbol_get_fully_qualified_name (afrodite_symbol_get_parent (sym));
							}
							g_print ("          from %s: %s\n", _tmp1_, _tmp2_ = afrodite_utils_unescape_xml_string (afrodite_symbol_get_description (sym)));
							_g_free0 (_tmp2_);
							_afrodite_symbol_unref0 (sym);
						}
						_vala_collection_object_unref0 (_sym_it);
					}
					_vala_collection_object_unref0 (syms);
				} else {
					g_print ("no symbol found for position: %d-%d\n", option_line, option_column);
				}
				_afrodite_symbol_unref0 (s);
			} else {
				g_print ("source file not found: %s\n", option_visible_symbols);
			}
			_afrodite_source_file_unref0 (source);
		} else {
			if (option_symbol_name != NULL) {
				AfroditeQueryOptions* options;
				AfroditeQueryResult* sym;
				AfroditeQueryResult* _tmp3_;
				options = afrodite_query_options_standard ();
				options->auto_member_binding_mode = TRUE;
				options->compare_mode = AFRODITE_COMPARE_MODE_EXACT;
				options->access = AFRODITE_SYMBOL_ACCESSIBILITY_ANY;
				options->binding = AFRODITE_MEMBER_BINDING_ANY;
				sym = NULL;
				sym = (_tmp3_ = afrodite_ast_get_symbol_type_for_name_and_path (afrodite_completion_engine_get_ast (engine), options, option_symbol_name, option_files[0], option_line, option_column), _afrodite_query_result_unref0 (sym), _tmp3_);
				g_print ("The type for '%s' is: ", option_symbol_name);
				if (!afrodite_query_result_get_is_empty (sym)) {
					{
						ValaIterator* _item_it;
						_item_it = vala_iterable_iterator ((ValaIterable*) afrodite_query_result_get_children (sym));
						while (TRUE) {
							AfroditeResultItem* item;
							char* _tmp4_;
							if (!vala_iterator_next (_item_it)) {
								break;
							}
							item = (AfroditeResultItem*) vala_iterator_get (_item_it);
							g_print ("%s\n     Childs:\n", _tmp4_ = afrodite_utils_unescape_xml_string (afrodite_symbol_get_description (afrodite_result_item_get_symbol (item))));
							_g_free0 (_tmp4_);
							if (afrodite_symbol_get_has_children (afrodite_result_item_get_symbol (item))) {
								gint count;
								gboolean _tmp6_ = FALSE;
								count = 0;
								{
									ValaIterator* _child_it;
									_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (afrodite_result_item_get_symbol (item)));
									while (TRUE) {
										AfroditeSymbol* child;
										char* _tmp5_;
										if (!vala_iterator_next (_child_it)) {
											break;
										}
										child = (AfroditeSymbol*) vala_iterator_get (_child_it);
										g_print ("          %s\n", _tmp5_ = afrodite_utils_unescape_xml_string (afrodite_symbol_get_description (child)));
										_g_free0 (_tmp5_);
										count++;
										if (count == 6) {
											g_print ("          ......\n");
											_afrodite_symbol_unref0 (child);
											break;
										}
										_afrodite_symbol_unref0 (child);
									}
									_vala_collection_object_unref0 (_child_it);
								}
								if (count < 6) {
									_tmp6_ = afrodite_symbol_get_has_base_types (afrodite_result_item_get_symbol (item));
								} else {
									_tmp6_ = FALSE;
								}
								if (_tmp6_) {
									{
										ValaIterator* _base_item_it;
										_base_item_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (afrodite_result_item_get_symbol (item)));
										while (TRUE) {
											AfroditeDataType* base_item;
											gboolean _tmp7_ = FALSE;
											if (!vala_iterator_next (_base_item_it)) {
												break;
											}
											base_item = (AfroditeDataType*) vala_iterator_get (_base_item_it);
											if (afrodite_data_type_get_unresolved (base_item)) {
												_tmp7_ = TRUE;
											} else {
												_tmp7_ = !afrodite_symbol_get_has_children (afrodite_data_type_get_symbol (base_item));
											}
											if (_tmp7_) {
												_afrodite_data_type_unref0 (base_item);
												continue;
											}
											{
												ValaIterator* _child_it;
												_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (afrodite_data_type_get_symbol (base_item)));
												while (TRUE) {
													AfroditeSymbol* child;
													char* _tmp8_;
													if (!vala_iterator_next (_child_it)) {
														break;
													}
													child = (AfroditeSymbol*) vala_iterator_get (_child_it);
													g_print ("          %s\n", _tmp8_ = afrodite_utils_unescape_xml_string (afrodite_symbol_get_description (child)));
													_g_free0 (_tmp8_);
													count++;
													if (count == 6) {
														_afrodite_symbol_unref0 (child);
														break;
													}
													_afrodite_symbol_unref0 (child);
												}
												_vala_collection_object_unref0 (_child_it);
											}
											if (count == 6) {
												g_print ("          ......\n");
												_afrodite_data_type_unref0 (base_item);
												break;
											}
											_afrodite_data_type_unref0 (base_item);
										}
										_vala_collection_object_unref0 (_base_item_it);
									}
								}
							}
							_afrodite_result_item_unref0 (item);
						}
						_vala_collection_object_unref0 (_item_it);
					}
				} else {
					g_print ("unresolved :(\n");
				}
				_afrodite_query_result_unref0 (sym);
				_afrodite_query_options_unref0 (options);
			}
		}
		_vala_code_visitor_unref0 (dumper);
		break;
	}
	g_print ("done\n");
}


static void _afrodite_test_application_on_begin_parsing_afrodite_completion_engine_begin_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self) {
	afrodite_test_application_on_begin_parsing (self, sender);
}


static void _afrodite_test_application_on_end_parsing_afrodite_completion_engine_end_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self) {
	afrodite_test_application_on_end_parsing (self, sender);
}


static void afrodite_test_application_parse (AfroditeTestApplication* self) {
	gint i;
	AfroditeCompletionEngine* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	i = 0;
	self->priv->_engine = (_tmp0_ = afrodite_completion_engine_new ("afrodite-test-engine"), _g_object_unref0 (self->priv->_engine), _tmp0_);
	g_signal_connect_object (self->priv->_engine, "begin-parsing", (GCallback) _afrodite_test_application_on_begin_parsing_afrodite_completion_engine_begin_parsing, self, 0);
	g_signal_connect_object (self->priv->_engine, "end-parsing", (GCallback) _afrodite_test_application_on_end_parsing_afrodite_completion_engine_end_parsing, self, 0);
	{
		gint repeat;
		repeat = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					repeat++;
				}
				_tmp1_ = FALSE;
				if (!(repeat < option_repeat)) {
					break;
				}
				g_print ("Adding sources (%d):\n", repeat);
				i = 0;
				while (TRUE) {
					char* filename;
					const char* _tmp2_;
					if (!(option_files[i] != NULL)) {
						break;
					}
					filename = g_strdup (option_files[i]);
					_tmp2_ = NULL;
					if (option_live_buffers) {
						_tmp2_ = " (live buffer)";
					} else {
						_tmp2_ = "";
					}
					g_print ("   %s%s\n", filename, _tmp2_);
					if (option_live_buffers) {
						AfroditeSourceItem* source;
						char* buffer;
						char* _tmp5_;
						char* _tmp6_;
						source = afrodite_source_item_new ();
						buffer = NULL;
						{
							char* _tmp3_ = NULL;
							char* _tmp4_;
							g_file_get_contents (filename, &_tmp3_, NULL, &_inner_error_);
							buffer = (_tmp4_ = _tmp3_, _g_free0 (buffer), _tmp4_);
							if (_inner_error_ != NULL) {
								goto __catch1_g_error;
							}
						}
						goto __finally1;
						__catch1_g_error:
						{
							GError * err;
							err = _inner_error_;
							_inner_error_ = NULL;
							{
								g_error ("afroditetest.vala:189: %s", _ ("parsing options"));
								_g_error_free0 (err);
							}
						}
						__finally1:
						if (_inner_error_ != NULL) {
							_g_free0 (buffer);
							_afrodite_source_item_unref0 (source);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						source->content = (_tmp5_ = g_strdup (buffer), _g_free0 (source->content), _tmp5_);
						source->path = (_tmp6_ = g_strdup ("live-buffer.vala"), _g_free0 (source->path), _tmp6_);
						afrodite_completion_engine_queue_source (self->priv->_engine, source);
						_g_free0 (buffer);
						_afrodite_source_item_unref0 (source);
					} else {
						afrodite_completion_engine_queue_sourcefile (self->priv->_engine, filename, NULL, FALSE, FALSE);
					}
					i++;
					_g_free0 (filename);
				}
			}
		}
	}
}


static gint afrodite_test_application_main (char** args, int args_length1) {
	gint result = 0;
	AfroditeTestApplication* application;
	application = afrodite_test_application_new ();
	result = afrodite_test_application_run (application, args, args_length1);
	_g_object_unref0 (application);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return afrodite_test_application_main (argv, argc);
}


AfroditeTestApplication* afrodite_test_application_construct (GType object_type) {
	AfroditeTestApplication * self;
	self = (AfroditeTestApplication*) g_object_new (object_type, NULL);
	return self;
}


AfroditeTestApplication* afrodite_test_application_new (void) {
	return afrodite_test_application_construct (AFRODITE_TEST_TYPE_APPLICATION);
}


static void afrodite_test_application_class_init (AfroditeTestApplicationClass * klass) {
	afrodite_test_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AfroditeTestApplicationPrivate));
	G_OBJECT_CLASS (klass)->finalize = afrodite_test_application_finalize;
}


static void afrodite_test_application_instance_init (AfroditeTestApplication * self) {
	self->priv = AFRODITE_TEST_APPLICATION_GET_PRIVATE (self);
}


static void afrodite_test_application_finalize (GObject* obj) {
	AfroditeTestApplication * self;
	self = AFRODITE_TEST_APPLICATION (obj);
	_g_main_loop_unref0 (self->priv->_loop);
	_g_object_unref0 (self->priv->_engine);
	G_OBJECT_CLASS (afrodite_test_application_parent_class)->finalize (obj);
}


GType afrodite_test_application_get_type (void) {
	static volatile gsize afrodite_test_application_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_test_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeTestApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_test_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeTestApplication), 0, (GInstanceInitFunc) afrodite_test_application_instance_init, NULL };
		GType afrodite_test_application_type_id;
		afrodite_test_application_type_id = g_type_register_static (G_TYPE_OBJECT, "AfroditeTestApplication", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_test_application_type_id__volatile, afrodite_test_application_type_id);
	}
	return afrodite_test_application_type_id__volatile;
}




