/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse mèl :
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est régi par la licence CeCILL soumise au droit français et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accepté les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef GTK_ELEMENTCOMBOBOX_H
#define GTK_ELEMENTCOMBOBOX_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

/**
 * ELEMENT_COMBOX_TYPE:
 *
 * Return the associated #GType to the #ElementComboBox objects.
 *
 * Since: 3.6
 */
#define ELEMENT_COMBOX_TYPE         (elementComboBox_get_type ())
/**
 * ELEMENT_COMBOX:
 * @obj: the widget to cast.
 *
 * Cast the given object to a #ElementComboBox object.
 *
 * Since: 3.6
 */
#define ELEMENT_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELEMENT_COMBOX_TYPE, ElementComboBox))
/**
 * ELEMENT_COMBOX_CLASS:
 * @klass: the class to cast.
 *
 * Cast the given class to a #ElementComboBox object.
 *
 * Since: 3.6
 */
#define ELEMENT_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELEMENT_COMBOX_TYPE, ElementComboBoxClass))
/**
 * IS_ELEMENT_COMBOX:
 * @obj: the object to test.
 *
 * Return if the given object is a valid #ElementComboBox object.
 *
 * Since: 3.6
 */
#define IS_ELEMENT_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELEMENT_COMBOX_TYPE))
/**
 * IS_ELEMENT_COMBOX_CLASS:
 * @klass: the class to test.
 *
 * Return if the given class is a valid #ElementComboBoxClass class.
 *
 * Since: 3.6
 */
#define IS_ELEMENT_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELEMENT_COMBOX_TYPE))
/**
 * ELEMENT_COMBOX_GET_CLASS:
 * @obj: the widget to get the class of.
 *
 * Get the class of the given object.
 *
 * Since: 3.6
 */
#define ELEMENT_COMBOX_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, ELEMENT_COMBOX_TYPE, ElementComboBoxClass))

typedef struct _ElementComboBox ElementComboBox;
typedef struct _ElementComboBoxClass ElementComboBoxClass;

/**
 * elementComboBox_get_type:
 *
 * Internal routine, retrieves the type of #ElementComboBox
 * objects. Use ELEMENT_COMBOX_TYPE macro instead.
 *
 * Since: 3.6
 */
GType elementComboBox_get_type(void);

GtkWidget* elementComboBox_new(gboolean hasAllSelector, gboolean hasNoneSelector,
                               const gchar *format);
GList* elementComboBoxGet_selectedElement(ElementComboBox *wd);
gboolean elementComboBoxSet_selection(ElementComboBox* wd, const gchar *name);

G_END_DECLS

#endif
