

-- UUAGC 0.9.37.1 (SemHsTokens.ag)
module SemHsTokens where
{-# LINE 4 "SemHsTokens.ag" #-}

import qualified Data.Sequence as Seq
import Data.Sequence(Seq,empty,singleton,(><))
import Data.Foldable(toList)
import Pretty

import TokenDef
import HsToken
import ErrorMessages
{-# LINE 16 "../src-derived/SemHsTokens.hs" #-}

{-# LINE 2 "./HsToken.ag" #-}

import CommonTypes
import UU.Scanner.Position(Pos)
{-# LINE 22 "../src-derived/SemHsTokens.hs" #-}
{-# LINE 57 "SemHsTokens.ag" #-}

isNTname allnts (Just (NT nt _)) = nt `elem` allnts
isNTname allnts _                = False
{-# LINE 27 "../src-derived/SemHsTokens.hs" #-}
-- HsToken -----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         attrs                : [(Identifier,Identifier)]
         con                  : Identifier
         fieldnames           : [Identifier]
         nt                   : Identifier
      synthesized attributes:
         errors               : Seq Error
         tok                  : (Pos,String)
         usedAttrs            : [(Identifier,Identifier)]
         usedFields           : Seq Identifier
         usedLocals           : [Identifier]
   alternatives:
      alternative AGField:
         child field          : {Identifier}
         child attr           : {Identifier}
         child pos            : {Pos}
         child rdesc          : {Maybe String}
         visit 0:
            local addTrace    : _
      alternative AGLocal:
         child var            : {Identifier}
         child pos            : {Pos}
         child rdesc          : {Maybe String}
         visit 0:
            local _tup1       : _
            local errors      : _
            local tok         : _
            local usedLocals  : _
      alternative CharToken:
         child value          : {String}
         child pos            : {Pos}
      alternative Err:
         child mesg           : {String}
         child pos            : {Pos}
      alternative HsToken:
         child value          : {String}
         child pos            : {Pos}
      alternative StrToken:
         child value          : {String}
         child pos            : {Pos}
-}
-- cata
sem_HsToken :: HsToken  ->
               T_HsToken 
sem_HsToken (AGField _field _attr _pos _rdesc )  =
    (sem_HsToken_AGField _field _attr _pos _rdesc )
sem_HsToken (AGLocal _var _pos _rdesc )  =
    (sem_HsToken_AGLocal _var _pos _rdesc )
sem_HsToken (CharToken _value _pos )  =
    (sem_HsToken_CharToken _value _pos )
sem_HsToken (Err _mesg _pos )  =
    (sem_HsToken_Err _mesg _pos )
sem_HsToken (HsToken _value _pos )  =
    (sem_HsToken_HsToken _value _pos )
sem_HsToken (StrToken _value _pos )  =
    (sem_HsToken_StrToken _value _pos )
-- semantic domain
newtype T_HsToken  = T_HsToken (([(Identifier,Type,Maybe (Maybe Type))]) ->
                                ([Identifier]) ->
                                ([(Identifier,Identifier)]) ->
                                Identifier ->
                                ([Identifier]) ->
                                Identifier ->
                                ( (Seq Error),((Pos,String)),([(Identifier,Identifier)]),(Seq Identifier),([Identifier])))
data Inh_HsToken  = Inh_HsToken {allfields_Inh_HsToken :: ([(Identifier,Type,Maybe (Maybe Type))]),allnts_Inh_HsToken :: ([Identifier]),attrs_Inh_HsToken :: ([(Identifier,Identifier)]),con_Inh_HsToken :: Identifier,fieldnames_Inh_HsToken :: ([Identifier]),nt_Inh_HsToken :: Identifier}
data Syn_HsToken  = Syn_HsToken {errors_Syn_HsToken :: (Seq Error),tok_Syn_HsToken :: ((Pos,String)),usedAttrs_Syn_HsToken :: ([(Identifier,Identifier)]),usedFields_Syn_HsToken :: (Seq Identifier),usedLocals_Syn_HsToken :: ([Identifier])}
wrap_HsToken :: T_HsToken  ->
                Inh_HsToken  ->
                Syn_HsToken 
wrap_HsToken (T_HsToken sem ) (Inh_HsToken _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIfieldnames _lhsInt )  =
    (let ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals) = sem _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIfieldnames _lhsInt 
     in  (Syn_HsToken _lhsOerrors _lhsOtok _lhsOusedAttrs _lhsOusedFields _lhsOusedLocals ))
sem_HsToken_AGField :: Identifier ->
                       Identifier ->
                       Pos ->
                       (Maybe String) ->
                       T_HsToken 
sem_HsToken_AGField field_ attr_ pos_ rdesc_  =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    (let _lhsOerrors :: (Seq Error)
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOtok :: ((Pos,String))
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         -- "SemHsTokens.ag"(line 74, column 15)
                         _lhsOerrors =
                             ({-# LINE 74 "SemHsTokens.ag" #-}
                              if (field_,attr_) `elem` _lhsIattrs
                                    then Seq.empty
                                    else if not(field_ `elem` (_LHS : _LOC: _lhsIfieldnames))
                                            then Seq.singleton (UndefChild _lhsInt _lhsIcon field_)
                                            else Seq.singleton (UndefAttr _lhsInt _lhsIcon field_ attr_ False)
                              {-# LINE 130 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 88, column 13)
                         _lhsOusedAttrs =
                             ({-# LINE 88 "SemHsTokens.ag" #-}
                              [(field_,attr_)]
                              {-# LINE 136 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 115, column 8)
                         _addTrace =
                             ({-# LINE 115 "SemHsTokens.ag" #-}
                              case rdesc_ of
                                Just d  -> \x -> "(trace " ++ show (d ++ " -> " ++ show field_ ++ "." ++ show attr_) ++ " (" ++ x ++ "))"
                                Nothing -> id
                              {-# LINE 144 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 118, column 8)
                         _lhsOtok =
                             ({-# LINE 118 "SemHsTokens.ag" #-}
                              (pos_, _addTrace     $ attrname True field_ attr_)
                              {-# LINE 150 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 93, column 40)
                         _lhsOusedFields =
                             ({-# LINE 93 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 156 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 84, column 40)
                         _lhsOusedLocals =
                             ({-# LINE 84 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 162 "SemHsTokens.hs" #-}
                              )
                     in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
sem_HsToken_AGLocal :: Identifier ->
                       Pos ->
                       (Maybe String) ->
                       T_HsToken 
sem_HsToken_AGLocal var_ pos_ rdesc_  =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    (let _lhsOusedFields :: (Seq Identifier)
                         _lhsOerrors :: (Seq Error)
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedLocals :: ([Identifier])
                         _lhsOtok :: ((Pos,String))
                         -- "SemHsTokens.ag"(line 64, column 19)
                         __tup1 =
                             ({-# LINE 64 "SemHsTokens.ag" #-}
                              if var_ `elem` _lhsIfieldnames
                              then if  isNTname _lhsIallnts (lookup var_ (map (\(n,t,_) -> (n,t)) _lhsIallfields))
                                   then (Seq.singleton(ChildAsLocal _lhsInt _lhsIcon var_), (pos_,fieldname var_), []    )
                                   else (Seq.empty, (pos_,fieldname var_), []    )
                              else if (_LOC,var_) `elem` _lhsIattrs
                              then (Seq.empty                                   , (pos_,locname   var_), [var_])
                              else (Seq.singleton(UndefLocal _lhsInt _lhsIcon var_), (pos_,locname   var_), []    )
                              {-# LINE 191 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 64, column 19)
                         (_errors,_,_) =
                             ({-# LINE 64 "SemHsTokens.ag" #-}
                              __tup1
                              {-# LINE 197 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 64, column 19)
                         (_,_tok,_) =
                             ({-# LINE 64 "SemHsTokens.ag" #-}
                              __tup1
                              {-# LINE 203 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 64, column 19)
                         (_,_,_usedLocals) =
                             ({-# LINE 64 "SemHsTokens.ag" #-}
                              __tup1
                              {-# LINE 209 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 96, column 13)
                         _lhsOusedFields =
                             ({-# LINE 96 "SemHsTokens.ag" #-}
                              if var_ `elem` _lhsIfieldnames
                               then Seq.singleton var_
                               else Seq.empty
                              {-# LINE 217 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 43, column 37)
                         _lhsOerrors =
                             ({-# LINE 43 "SemHsTokens.ag" #-}
                              _errors
                              {-# LINE 223 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 85, column 40)
                         _lhsOusedAttrs =
                             ({-# LINE 85 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 229 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 84, column 40)
                         _lhsOusedLocals =
                             ({-# LINE 84 "SemHsTokens.ag" #-}
                              _usedLocals
                              {-# LINE 235 "SemHsTokens.hs" #-}
                              )
                         -- copy rule (from local)
                         _lhsOtok =
                             ({-# LINE 113 "SemHsTokens.ag" #-}
                              _tok
                              {-# LINE 241 "SemHsTokens.hs" #-}
                              )
                     in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
sem_HsToken_CharToken :: String ->
                         Pos ->
                         T_HsToken 
sem_HsToken_CharToken value_ pos_  =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    (let _lhsOtok :: ((Pos,String))
                         _lhsOerrors :: (Seq Error)
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         -- "SemHsTokens.ag"(line 122, column 16)
                         _lhsOtok =
                             ({-# LINE 122 "SemHsTokens.ag" #-}
                              (pos_, if null value_
                                        then ""
                                        else showCharShort (head value_)
                              )
                              {-# LINE 266 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 43, column 37)
                         _lhsOerrors =
                             ({-# LINE 43 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 272 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 85, column 40)
                         _lhsOusedAttrs =
                             ({-# LINE 85 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 278 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 93, column 40)
                         _lhsOusedFields =
                             ({-# LINE 93 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 284 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 84, column 40)
                         _lhsOusedLocals =
                             ({-# LINE 84 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 290 "SemHsTokens.hs" #-}
                              )
                     in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
sem_HsToken_Err :: String ->
                   Pos ->
                   T_HsToken 
sem_HsToken_Err mesg_ pos_  =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    (let _lhsOerrors :: (Seq Error)
                         _lhsOtok :: ((Pos,String))
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         -- "SemHsTokens.ag"(line 50, column 9)
                         _lhsOerrors =
                             ({-# LINE 50 "SemHsTokens.ag" #-}
                              let m = text mesg_
                              in Seq.singleton (CustomError False pos_ m)
                              {-# LINE 313 "SemHsTokens.hs" #-}
                              )
                         -- "SemHsTokens.ag"(line 128, column 16)
                         _lhsOtok =
                             ({-# LINE 128 "SemHsTokens.ag" #-}
                              (pos_, "")
                              {-# LINE 319 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 85, column 40)
                         _lhsOusedAttrs =
                             ({-# LINE 85 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 325 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 93, column 40)
                         _lhsOusedFields =
                             ({-# LINE 93 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 331 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 84, column 40)
                         _lhsOusedLocals =
                             ({-# LINE 84 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 337 "SemHsTokens.hs" #-}
                              )
                     in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
sem_HsToken_HsToken :: String ->
                       Pos ->
                       T_HsToken 
sem_HsToken_HsToken value_ pos_  =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    (let _lhsOtok :: ((Pos,String))
                         _lhsOerrors :: (Seq Error)
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         -- "SemHsTokens.ag"(line 120, column 14)
                         _lhsOtok =
                             ({-# LINE 120 "SemHsTokens.ag" #-}
                              (pos_, value_)
                              {-# LINE 359 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 43, column 37)
                         _lhsOerrors =
                             ({-# LINE 43 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 365 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 85, column 40)
                         _lhsOusedAttrs =
                             ({-# LINE 85 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 371 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 93, column 40)
                         _lhsOusedFields =
                             ({-# LINE 93 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 377 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 84, column 40)
                         _lhsOusedLocals =
                             ({-# LINE 84 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 383 "SemHsTokens.hs" #-}
                              )
                     in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
sem_HsToken_StrToken :: String ->
                        Pos ->
                        T_HsToken 
sem_HsToken_StrToken value_ pos_  =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    (let _lhsOtok :: ((Pos,String))
                         _lhsOerrors :: (Seq Error)
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         -- "SemHsTokens.ag"(line 127, column 16)
                         _lhsOtok =
                             ({-# LINE 127 "SemHsTokens.ag" #-}
                              (pos_, showStrShort value_)
                              {-# LINE 405 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 43, column 37)
                         _lhsOerrors =
                             ({-# LINE 43 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 411 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 85, column 40)
                         _lhsOusedAttrs =
                             ({-# LINE 85 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 417 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 93, column 40)
                         _lhsOusedFields =
                             ({-# LINE 93 "SemHsTokens.ag" #-}
                              Seq.empty
                              {-# LINE 423 "SemHsTokens.hs" #-}
                              )
                         -- use rule "SemHsTokens.ag"(line 84, column 40)
                         _lhsOusedLocals =
                             ({-# LINE 84 "SemHsTokens.ag" #-}
                              []
                              {-# LINE 429 "SemHsTokens.hs" #-}
                              )
                     in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
-- HsTokens ----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         attrs                : [(Identifier,Identifier)]
         con                  : Identifier
         fieldnames           : [Identifier]
         nt                   : Identifier
      synthesized attributes:
         errors               : Seq Error
         tks                  : [(Pos,String)]
         usedAttrs            : [(Identifier,Identifier)]
         usedFields           : Seq Identifier
         usedLocals           : [Identifier]
   alternatives:
      alternative Cons:
         child hd             : HsToken 
         child tl             : HsTokens 
      alternative Nil:
-}
-- cata
sem_HsTokens :: HsTokens  ->
                T_HsTokens 
sem_HsTokens list  =
    (Prelude.foldr sem_HsTokens_Cons sem_HsTokens_Nil (Prelude.map sem_HsToken list) )
-- semantic domain
newtype T_HsTokens  = T_HsTokens (([(Identifier,Type,Maybe (Maybe Type))]) ->
                                  ([Identifier]) ->
                                  ([(Identifier,Identifier)]) ->
                                  Identifier ->
                                  ([Identifier]) ->
                                  Identifier ->
                                  ( (Seq Error),([(Pos,String)]),([(Identifier,Identifier)]),(Seq Identifier),([Identifier])))
data Inh_HsTokens  = Inh_HsTokens {allfields_Inh_HsTokens :: ([(Identifier,Type,Maybe (Maybe Type))]),allnts_Inh_HsTokens :: ([Identifier]),attrs_Inh_HsTokens :: ([(Identifier,Identifier)]),con_Inh_HsTokens :: Identifier,fieldnames_Inh_HsTokens :: ([Identifier]),nt_Inh_HsTokens :: Identifier}
data Syn_HsTokens  = Syn_HsTokens {errors_Syn_HsTokens :: (Seq Error),tks_Syn_HsTokens :: ([(Pos,String)]),usedAttrs_Syn_HsTokens :: ([(Identifier,Identifier)]),usedFields_Syn_HsTokens :: (Seq Identifier),usedLocals_Syn_HsTokens :: ([Identifier])}
wrap_HsTokens :: T_HsTokens  ->
                 Inh_HsTokens  ->
                 Syn_HsTokens 
wrap_HsTokens (T_HsTokens sem ) (Inh_HsTokens _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIfieldnames _lhsInt )  =
    (let ( _lhsOerrors,_lhsOtks,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals) = sem _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIfieldnames _lhsInt 
     in  (Syn_HsTokens _lhsOerrors _lhsOtks _lhsOusedAttrs _lhsOusedFields _lhsOusedLocals ))
sem_HsTokens_Cons :: T_HsToken  ->
                     T_HsTokens  ->
                     T_HsTokens 
sem_HsTokens_Cons (T_HsToken hd_ ) (T_HsTokens tl_ )  =
    (T_HsTokens (\ _lhsIallfields
                   _lhsIallnts
                   _lhsIattrs
                   _lhsIcon
                   _lhsIfieldnames
                   _lhsInt ->
                     (let _lhsOtks :: ([(Pos,String)])
                          _lhsOerrors :: (Seq Error)
                          _lhsOusedAttrs :: ([(Identifier,Identifier)])
                          _lhsOusedFields :: (Seq Identifier)
                          _lhsOusedLocals :: ([Identifier])
                          _hdOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _hdOallnts :: ([Identifier])
                          _hdOattrs :: ([(Identifier,Identifier)])
                          _hdOcon :: Identifier
                          _hdOfieldnames :: ([Identifier])
                          _hdOnt :: Identifier
                          _tlOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _tlOallnts :: ([Identifier])
                          _tlOattrs :: ([(Identifier,Identifier)])
                          _tlOcon :: Identifier
                          _tlOfieldnames :: ([Identifier])
                          _tlOnt :: Identifier
                          _hdIerrors :: (Seq Error)
                          _hdItok :: ((Pos,String))
                          _hdIusedAttrs :: ([(Identifier,Identifier)])
                          _hdIusedFields :: (Seq Identifier)
                          _hdIusedLocals :: ([Identifier])
                          _tlIerrors :: (Seq Error)
                          _tlItks :: ([(Pos,String)])
                          _tlIusedAttrs :: ([(Identifier,Identifier)])
                          _tlIusedFields :: (Seq Identifier)
                          _tlIusedLocals :: ([Identifier])
                          -- "SemHsTokens.ag"(line 110, column 10)
                          _lhsOtks =
                              ({-# LINE 110 "SemHsTokens.ag" #-}
                               _hdItok : _tlItks
                               {-# LINE 516 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 43, column 37)
                          _lhsOerrors =
                              ({-# LINE 43 "SemHsTokens.ag" #-}
                               _hdIerrors Seq.>< _tlIerrors
                               {-# LINE 522 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 85, column 40)
                          _lhsOusedAttrs =
                              ({-# LINE 85 "SemHsTokens.ag" #-}
                               _hdIusedAttrs ++ _tlIusedAttrs
                               {-# LINE 528 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 93, column 40)
                          _lhsOusedFields =
                              ({-# LINE 93 "SemHsTokens.ag" #-}
                               _hdIusedFields Seq.>< _tlIusedFields
                               {-# LINE 534 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 84, column 40)
                          _lhsOusedLocals =
                              ({-# LINE 84 "SemHsTokens.ag" #-}
                               _hdIusedLocals ++ _tlIusedLocals
                               {-# LINE 540 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOallfields =
                              ({-# LINE 30 "SemHsTokens.ag" #-}
                               _lhsIallfields
                               {-# LINE 546 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOallnts =
                              ({-# LINE 31 "SemHsTokens.ag" #-}
                               _lhsIallnts
                               {-# LINE 552 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOattrs =
                              ({-# LINE 32 "SemHsTokens.ag" #-}
                               _lhsIattrs
                               {-# LINE 558 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOcon =
                              ({-# LINE 29 "SemHsTokens.ag" #-}
                               _lhsIcon
                               {-# LINE 564 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOfieldnames =
                              ({-# LINE 36 "SemHsTokens.ag" #-}
                               _lhsIfieldnames
                               {-# LINE 570 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOnt =
                              ({-# LINE 29 "SemHsTokens.ag" #-}
                               _lhsInt
                               {-# LINE 576 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOallfields =
                              ({-# LINE 30 "SemHsTokens.ag" #-}
                               _lhsIallfields
                               {-# LINE 582 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOallnts =
                              ({-# LINE 31 "SemHsTokens.ag" #-}
                               _lhsIallnts
                               {-# LINE 588 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOattrs =
                              ({-# LINE 32 "SemHsTokens.ag" #-}
                               _lhsIattrs
                               {-# LINE 594 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOcon =
                              ({-# LINE 29 "SemHsTokens.ag" #-}
                               _lhsIcon
                               {-# LINE 600 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOfieldnames =
                              ({-# LINE 36 "SemHsTokens.ag" #-}
                               _lhsIfieldnames
                               {-# LINE 606 "SemHsTokens.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOnt =
                              ({-# LINE 29 "SemHsTokens.ag" #-}
                               _lhsInt
                               {-# LINE 612 "SemHsTokens.hs" #-}
                               )
                          ( _hdIerrors,_hdItok,_hdIusedAttrs,_hdIusedFields,_hdIusedLocals) =
                              hd_ _hdOallfields _hdOallnts _hdOattrs _hdOcon _hdOfieldnames _hdOnt 
                          ( _tlIerrors,_tlItks,_tlIusedAttrs,_tlIusedFields,_tlIusedLocals) =
                              tl_ _tlOallfields _tlOallnts _tlOattrs _tlOcon _tlOfieldnames _tlOnt 
                      in  ( _lhsOerrors,_lhsOtks,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
sem_HsTokens_Nil :: T_HsTokens 
sem_HsTokens_Nil  =
    (T_HsTokens (\ _lhsIallfields
                   _lhsIallnts
                   _lhsIattrs
                   _lhsIcon
                   _lhsIfieldnames
                   _lhsInt ->
                     (let _lhsOtks :: ([(Pos,String)])
                          _lhsOerrors :: (Seq Error)
                          _lhsOusedAttrs :: ([(Identifier,Identifier)])
                          _lhsOusedFields :: (Seq Identifier)
                          _lhsOusedLocals :: ([Identifier])
                          -- "SemHsTokens.ag"(line 111, column 10)
                          _lhsOtks =
                              ({-# LINE 111 "SemHsTokens.ag" #-}
                               []
                               {-# LINE 636 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 43, column 37)
                          _lhsOerrors =
                              ({-# LINE 43 "SemHsTokens.ag" #-}
                               Seq.empty
                               {-# LINE 642 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 85, column 40)
                          _lhsOusedAttrs =
                              ({-# LINE 85 "SemHsTokens.ag" #-}
                               []
                               {-# LINE 648 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 93, column 40)
                          _lhsOusedFields =
                              ({-# LINE 93 "SemHsTokens.ag" #-}
                               Seq.empty
                               {-# LINE 654 "SemHsTokens.hs" #-}
                               )
                          -- use rule "SemHsTokens.ag"(line 84, column 40)
                          _lhsOusedLocals =
                              ({-# LINE 84 "SemHsTokens.ag" #-}
                               []
                               {-# LINE 660 "SemHsTokens.hs" #-}
                               )
                      in  ( _lhsOerrors,_lhsOtks,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
-- HsTokensRoot ------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         attrs                : [(Identifier,Identifier)]
         con                  : Identifier
         nt                   : Identifier
      synthesized attributes:
         errors               : Seq Error
         textLines            : [String]
         usedAttrs            : [(Identifier,Identifier)]
         usedFields           : [Identifier]
         usedLocals           : [Identifier]
   alternatives:
      alternative HsTokensRoot:
         child tokens         : HsTokens 
-}
-- cata
sem_HsTokensRoot :: HsTokensRoot  ->
                    T_HsTokensRoot 
sem_HsTokensRoot (HsTokensRoot _tokens )  =
    (sem_HsTokensRoot_HsTokensRoot (sem_HsTokens _tokens ) )
-- semantic domain
newtype T_HsTokensRoot  = T_HsTokensRoot (([(Identifier,Type,Maybe (Maybe Type))]) ->
                                          ([Identifier]) ->
                                          ([(Identifier,Identifier)]) ->
                                          Identifier ->
                                          Identifier ->
                                          ( (Seq Error),([String]),([(Identifier,Identifier)]),([Identifier]),([Identifier])))
data Inh_HsTokensRoot  = Inh_HsTokensRoot {allfields_Inh_HsTokensRoot :: ([(Identifier,Type,Maybe (Maybe Type))]),allnts_Inh_HsTokensRoot :: ([Identifier]),attrs_Inh_HsTokensRoot :: ([(Identifier,Identifier)]),con_Inh_HsTokensRoot :: Identifier,nt_Inh_HsTokensRoot :: Identifier}
data Syn_HsTokensRoot  = Syn_HsTokensRoot {errors_Syn_HsTokensRoot :: (Seq Error),textLines_Syn_HsTokensRoot :: ([String]),usedAttrs_Syn_HsTokensRoot :: ([(Identifier,Identifier)]),usedFields_Syn_HsTokensRoot :: ([Identifier]),usedLocals_Syn_HsTokensRoot :: ([Identifier])}
wrap_HsTokensRoot :: T_HsTokensRoot  ->
                     Inh_HsTokensRoot  ->
                     Syn_HsTokensRoot 
wrap_HsTokensRoot (T_HsTokensRoot sem ) (Inh_HsTokensRoot _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsInt )  =
    (let ( _lhsOerrors,_lhsOtextLines,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals) = sem _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsInt 
     in  (Syn_HsTokensRoot _lhsOerrors _lhsOtextLines _lhsOusedAttrs _lhsOusedFields _lhsOusedLocals ))
sem_HsTokensRoot_HsTokensRoot :: T_HsTokens  ->
                                 T_HsTokensRoot 
sem_HsTokensRoot_HsTokensRoot (T_HsTokens tokens_ )  =
    (T_HsTokensRoot (\ _lhsIallfields
                       _lhsIallnts
                       _lhsIattrs
                       _lhsIcon
                       _lhsInt ->
                         (let _tokensOfieldnames :: ([Identifier])
                              _lhsOusedFields :: ([Identifier])
                              _lhsOtextLines :: ([String])
                              _lhsOerrors :: (Seq Error)
                              _lhsOusedAttrs :: ([(Identifier,Identifier)])
                              _lhsOusedLocals :: ([Identifier])
                              _tokensOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                              _tokensOallnts :: ([Identifier])
                              _tokensOattrs :: ([(Identifier,Identifier)])
                              _tokensOcon :: Identifier
                              _tokensOnt :: Identifier
                              _tokensIerrors :: (Seq Error)
                              _tokensItks :: ([(Pos,String)])
                              _tokensIusedAttrs :: ([(Identifier,Identifier)])
                              _tokensIusedFields :: (Seq Identifier)
                              _tokensIusedLocals :: ([Identifier])
                              -- "SemHsTokens.ag"(line 38, column 18)
                              _tokensOfieldnames =
                                  ({-# LINE 38 "SemHsTokens.ag" #-}
                                   map (\(n,_,_) -> n) _lhsIallfields
                                   {-# LINE 730 "SemHsTokens.hs" #-}
                                   )
                              -- "SemHsTokens.ag"(line 100, column 18)
                              _lhsOusedFields =
                                  ({-# LINE 100 "SemHsTokens.ag" #-}
                                   toList _tokensIusedFields
                                   {-# LINE 736 "SemHsTokens.hs" #-}
                                   )
                              -- "SemHsTokens.ag"(line 107, column 18)
                              _lhsOtextLines =
                                  ({-# LINE 107 "SemHsTokens.ag" #-}
                                   showTokens _tokensItks
                                   {-# LINE 742 "SemHsTokens.hs" #-}
                                   )
                              -- use rule "SemHsTokens.ag"(line 18, column 18)
                              _lhsOerrors =
                                  ({-# LINE 18 "SemHsTokens.ag" #-}
                                   _tokensIerrors
                                   {-# LINE 748 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (up)
                              _lhsOusedAttrs =
                                  ({-# LINE 20 "SemHsTokens.ag" #-}
                                   _tokensIusedAttrs
                                   {-# LINE 754 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (up)
                              _lhsOusedLocals =
                                  ({-# LINE 19 "SemHsTokens.ag" #-}
                                   _tokensIusedLocals
                                   {-# LINE 760 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (down)
                              _tokensOallfields =
                                  ({-# LINE 30 "SemHsTokens.ag" #-}
                                   _lhsIallfields
                                   {-# LINE 766 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (down)
                              _tokensOallnts =
                                  ({-# LINE 31 "SemHsTokens.ag" #-}
                                   _lhsIallnts
                                   {-# LINE 772 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (down)
                              _tokensOattrs =
                                  ({-# LINE 32 "SemHsTokens.ag" #-}
                                   _lhsIattrs
                                   {-# LINE 778 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (down)
                              _tokensOcon =
                                  ({-# LINE 29 "SemHsTokens.ag" #-}
                                   _lhsIcon
                                   {-# LINE 784 "SemHsTokens.hs" #-}
                                   )
                              -- copy rule (down)
                              _tokensOnt =
                                  ({-# LINE 29 "SemHsTokens.ag" #-}
                                   _lhsInt
                                   {-# LINE 790 "SemHsTokens.hs" #-}
                                   )
                              ( _tokensIerrors,_tokensItks,_tokensIusedAttrs,_tokensIusedFields,_tokensIusedLocals) =
                                  tokens_ _tokensOallfields _tokensOallnts _tokensOattrs _tokensOcon _tokensOfieldnames _tokensOnt 
                          in  ( _lhsOerrors,_lhsOtextLines,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )